<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/analytics/data/v1alpha/analytics_data_api.proto

namespace Google\Analytics\Data\V1alpha;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A recurring audience list produces new audience lists each day. Audience
 * lists are users in an audience at the time of the list's creation. A
 * recurring audience list ensures that you have audience list based on the most
 * recent data available for use each day.
 *
 * Generated from protobuf message <code>google.analytics.data.v1alpha.RecurringAudienceList</code>
 */
class RecurringAudienceList extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $audience = '';
    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $audience_display_name = '';
    /**
     * Required. The dimensions requested and displayed in the audience list
     * response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $dimensions;
    /**
     * Optional. The number of remaining days that a recurring audience export
     * will produce an audience list instance. This counter decreases by one each
     * day, and when it reaches zero, no new audience lists will be created.
     * Recurring audience list request for Analytics 360 properties default to 180
     * days and have a maximum of 365 days. Requests for standard Analytics
     * properties default to 14 days and have a maximum of 30 days.
     * The minimum value allowed during creation is 1. Requests above their
     * respective maximum will be coerced to their maximum.
     *
     * Generated from protobuf field <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $active_days_remaining = null;
    /**
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     * This list is ordered with the most recently created audience list first.
     *
     * Generated from protobuf field <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $audience_lists;
    /**
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers & avoid the need for polling.
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $webhook_notification = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Identifier. The recurring audience list resource name assigned
     *           during creation. This resource name identifies this
     *           `RecurringAudienceList`.
     *           Format:
     *           `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     *     @type string $audience
     *           Required. The audience resource name. This resource name identifies the
     *           audience being listed and is shared between the Analytics Data & Admin
     *           APIs.
     *           Format: `properties/{property}/audiences/{audience}`
     *     @type string $audience_display_name
     *           Output only. The descriptive display name for this audience. For example,
     *           "Purchasers".
     *     @type array<\Google\Analytics\Data\V1alpha\AudienceDimension>|\Google\Protobuf\Internal\RepeatedField $dimensions
     *           Required. The dimensions requested and displayed in the audience list
     *           response.
     *     @type int $active_days_remaining
     *           Optional. The number of remaining days that a recurring audience export
     *           will produce an audience list instance. This counter decreases by one each
     *           day, and when it reaches zero, no new audience lists will be created.
     *           Recurring audience list request for Analytics 360 properties default to 180
     *           days and have a maximum of 365 days. Requests for standard Analytics
     *           properties default to 14 days and have a maximum of 30 days.
     *           The minimum value allowed during creation is 1. Requests above their
     *           respective maximum will be coerced to their maximum.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $audience_lists
     *           Output only. Audience list resource names for audience list instances
     *           created for this recurring audience list. One audience list is created for
     *           each day, and the audience list will be listed here.
     *           This list is ordered with the most recently created audience list first.
     *     @type \Google\Analytics\Data\V1alpha\WebhookNotification $webhook_notification
     *           Optional. Configures webhook notifications to be sent from the Google
     *           Analytics Data API to your webhook server. Use of webhooks is optional. If
     *           unused, you'll need to poll this API to determine when a recurring audience
     *           list creates new audience lists. Webhooks allow a notification to be sent
     *           to your servers & avoid the need for polling.
     *           Two POST requests will be sent each time a recurring audience list creates
     *           an audience list. This happens once per day until a recurring audience list
     *           reaches 0 active days remaining. The first request will be sent showing a
     *           newly created audience list in its CREATING state. The second request will
     *           be sent after the audience list completes creation (either the ACTIVE or
     *           FAILED state).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Analytics\Data\V1Alpha\AnalyticsDataApi::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. The recurring audience list resource name assigned
     * during creation. This resource name identifies this
     * `RecurringAudienceList`.
     * Format:
     * `properties/{property}/recurringAudienceLists/{recurring_audience_list}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getAudience()
    {
        return $this->audience;
    }

    /**
     * Required. The audience resource name. This resource name identifies the
     * audience being listed and is shared between the Analytics Data & Admin
     * APIs.
     * Format: `properties/{property}/audiences/{audience}`
     *
     * Generated from protobuf field <code>string audience = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setAudience($var)
    {
        GPBUtil::checkString($var, True);
        $this->audience = $var;

        return $this;
    }

    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAudienceDisplayName()
    {
        return $this->audience_display_name;
    }

    /**
     * Output only. The descriptive display name for this audience. For example,
     * "Purchasers".
     *
     * Generated from protobuf field <code>string audience_display_name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAudienceDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->audience_display_name = $var;

        return $this;
    }

    /**
     * Required. The dimensions requested and displayed in the audience list
     * response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDimensions()
    {
        return $this->dimensions;
    }

    /**
     * Required. The dimensions requested and displayed in the audience list
     * response.
     *
     * Generated from protobuf field <code>repeated .google.analytics.data.v1alpha.AudienceDimension dimensions = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Analytics\Data\V1alpha\AudienceDimension>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDimensions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Analytics\Data\V1alpha\AudienceDimension::class);
        $this->dimensions = $arr;

        return $this;
    }

    /**
     * Optional. The number of remaining days that a recurring audience export
     * will produce an audience list instance. This counter decreases by one each
     * day, and when it reaches zero, no new audience lists will be created.
     * Recurring audience list request for Analytics 360 properties default to 180
     * days and have a maximum of 365 days. Requests for standard Analytics
     * properties default to 14 days and have a maximum of 30 days.
     * The minimum value allowed during creation is 1. Requests above their
     * respective maximum will be coerced to their maximum.
     *
     * Generated from protobuf field <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getActiveDaysRemaining()
    {
        return isset($this->active_days_remaining) ? $this->active_days_remaining : 0;
    }

    public function hasActiveDaysRemaining()
    {
        return isset($this->active_days_remaining);
    }

    public function clearActiveDaysRemaining()
    {
        unset($this->active_days_remaining);
    }

    /**
     * Optional. The number of remaining days that a recurring audience export
     * will produce an audience list instance. This counter decreases by one each
     * day, and when it reaches zero, no new audience lists will be created.
     * Recurring audience list request for Analytics 360 properties default to 180
     * days and have a maximum of 365 days. Requests for standard Analytics
     * properties default to 14 days and have a maximum of 30 days.
     * The minimum value allowed during creation is 1. Requests above their
     * respective maximum will be coerced to their maximum.
     *
     * Generated from protobuf field <code>optional int32 active_days_remaining = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setActiveDaysRemaining($var)
    {
        GPBUtil::checkInt32($var);
        $this->active_days_remaining = $var;

        return $this;
    }

    /**
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     * This list is ordered with the most recently created audience list first.
     *
     * Generated from protobuf field <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAudienceLists()
    {
        return $this->audience_lists;
    }

    /**
     * Output only. Audience list resource names for audience list instances
     * created for this recurring audience list. One audience list is created for
     * each day, and the audience list will be listed here.
     * This list is ordered with the most recently created audience list first.
     *
     * Generated from protobuf field <code>repeated string audience_lists = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAudienceLists($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->audience_lists = $arr;

        return $this;
    }

    /**
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers & avoid the need for polling.
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Analytics\Data\V1alpha\WebhookNotification|null
     */
    public function getWebhookNotification()
    {
        return $this->webhook_notification;
    }

    public function hasWebhookNotification()
    {
        return isset($this->webhook_notification);
    }

    public function clearWebhookNotification()
    {
        unset($this->webhook_notification);
    }

    /**
     * Optional. Configures webhook notifications to be sent from the Google
     * Analytics Data API to your webhook server. Use of webhooks is optional. If
     * unused, you'll need to poll this API to determine when a recurring audience
     * list creates new audience lists. Webhooks allow a notification to be sent
     * to your servers & avoid the need for polling.
     * Two POST requests will be sent each time a recurring audience list creates
     * an audience list. This happens once per day until a recurring audience list
     * reaches 0 active days remaining. The first request will be sent showing a
     * newly created audience list in its CREATING state. The second request will
     * be sent after the audience list completes creation (either the ACTIVE or
     * FAILED state).
     *
     * Generated from protobuf field <code>optional .google.analytics.data.v1alpha.WebhookNotification webhook_notification = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Analytics\Data\V1alpha\WebhookNotification $var
     * @return $this
     */
    public function setWebhookNotification($var)
    {
        GPBUtil::checkMessage($var, \Google\Analytics\Data\V1alpha\WebhookNotification::class);
        $this->webhook_notification = $var;

        return $this;
    }

}

