<?php

return [
    'name' => '뉴스레터',
    'newsletter_form' => '뉴스레터 양식',
    'description' => '뉴스레터 구독자 보기 및 삭제',
    'settings' => [
        'email' => [
            'templates' => [
                'title' => '뉴스레터',
                'description' => '뉴스레터 이메일 템플릿 구성',
                'to_admin' => [
                    'title' => '관리자에게 전송된 이메일',
                    'description' => '관리자에게 이메일을 전송하기 위한 템플릿',
                    'subject' => '새 사용자가 귀하의 뉴스레터를 구독했습니다',
                    'newsletter_email' => '뉴스레터를 구독한 사용자의 이메일',
                ],
                'to_user' => [
                    'title' => '사용자에게 전송된 이메일',
                    'description' => '구독자에게 이메일을 전송하기 위한 템플릿',
                    'subject' => '{{ site_title }}: 구독이 확인되었습니다!',
                    'newsletter_name' => '뉴스레터를 구독한 사용자의 전체 이름',
                    'newsletter_email' => '뉴스레터를 구독한 사용자의 이메일',
                    'newsletter_unsubscribe_link' => '뉴스레터 구독 취소 링크',
                    'newsletter_unsubscribe_url' => '뉴스레터 구독 취소 URL',
                ],
            ],
        ],
        'title' => '뉴스레터',
        'panel_description' => '뉴스레터 설정 보기 및 업데이트',
        'description' => '뉴스레터 설정 (웹사이트에서 누군가 뉴스레터를 등록하면 SendGrid, Mailchimp... 로 뉴스레터 이메일을 자동으로 전송합니다).',
        'mailchimp_api_key' => 'Mailchimp API 키',
        'mailchimp_api_key_helper' => '뉴스레터 구독자를 자동으로 동기화하려면 Mailchimp API 키를 입력하세요. Mailchimp에서 API 키 받기: 계정 → 추가 기능 → API 키 → 키 만들기.',
        'mailchimp_api_key_instruction' => 'API 키를 받으려면: Mailchimp에 로그인 → 프로필 이름 클릭 → 계정 → 추가 기능 → API 키 → 키 만들기. <a href="https://mailchimp.com/help/about-api-keys/" target="_blank" rel="noopener">자세히 알아보기</a>',
        'mailchimp_list_id' => 'Mailchimp 목록 ID',
        'mailchimp_list_id_helper' => '구독자가 추가될 Mailchimp 오디언스(목록) ID를 입력하세요.',
        'mailchimp_list' => 'Mailchimp 목록',
        'mailchimp_list_helper' => '새 구독자가 자동으로 추가될 Mailchimp 오디언스 목록을 선택하세요.',
        'sendgrid_api_key' => 'Sendgrid API 키',
        'sendgrid_api_key_helper' => '뉴스레터 구독자를 자동으로 동기화하려면 SendGrid API 키를 입력하세요. API 키에는 "마케팅" 권한이 활성화되어 있어야 합니다.',
        'sendgrid_api_key_instruction' => 'API 키를 만들려면: SendGrid에 로그인 → 설정 → API 키 → API 키 만들기 → "제한된 액세스" 선택 → "마케팅" 권한 활성화. <a href="https://docs.sendgrid.com/ui/account-and-settings/api-keys" target="_blank" rel="noopener">자세히 알아보기</a>',
        'sendgrid_list_id' => 'Sendgrid 목록 ID',
        'sendgrid_list_id_helper' => '구독자가 추가될 SendGrid 연락처 목록 ID를 입력하세요.',
        'sendgrid_list' => 'Sendgrid 목록',
        'sendgrid_list_helper' => '새 구독자가 자동으로 추가될 SendGrid 연락처 목록을 선택하세요.',
        'enable_newsletter_contacts_list_api' => '뉴스레터 연락처 목록 API를 활성화하시겠습니까?',
        'enable_newsletter_contacts_list_api_helper' => '활성화하면 새 뉴스레터 구독자가 이메일 마케팅 서비스(Mailchimp 또는 SendGrid)에 자동으로 동기화됩니다. 이를 통해 선호하는 플랫폼을 통해 캠페인을 관리하고 전송할 수 있습니다.',
    ],
    'statuses' => [
        'subscribed' => '구독됨',
        'unsubscribed' => '구독 취소됨',
    ],
    'email_templates' => [
        // Admin email template
        'admin_new_subscriber_title' => '새로운 구독자',
        'admin_new_subscriber_message' => '새 사용자가 귀하의 뉴스레터를 구독했습니다:',

        // Subscriber email template
        'subscriber_success_title' => '구독 성공',
        'subscriber_thank_you_message' => '뉴스레터를 구독해 주셔서 감사합니다!',
        'subscriber_unsubscribe_instruction' => '뉴스레터 구독을 취소하려면 :newsletter_unsubscribe_link 를 클릭하세요',
    ],

    'enter_your_email' => '이메일을 입력하세요',
    'subscribe' => '구독하다',
    'newsletter_popup' => '뉴스레터 팝업',
    'enable_newsletter_popup' => '뉴스레터 팝업 활성화',
    'popup_image' => '데스크탑 이미지',
    'popup_image_helper' => '너비 1200px 이상의 장치용.',
    'popup_tablet_image' => '태블릿 이미지',
    'popup_tablet_image_helper' => '너비 768px에서 1199px 사이의 장치용. 비어 있으면 데스크탑 이미지가 사용됩니다.',
    'popup_mobile_image' => '모바일 이미지',
    'popup_mobile_image_helper' => '너비 768px 미만의 장치용. 비어 있으면 태블릿 이미지가 사용됩니다.',
    'popup_title' => '팝업 제목',
    'popup_subtitle' => '팝업 자막',
    'popup_description' => '팝업 설명',
    'popup_delay_seconds' => '팝업 지연(초)',
    'popup_delay_helper' => '페이지 로드 후 뉴스레터 팝업이 표시되기까지의 지연 시간입니다. ',
    'display_on_pages' => '페이지에 표시',
    'homepage' => '홈페이지',
    'all_pages' => '모든 페이지',
    'subscribe_success' => '뉴스레터를 성공적으로 구독했습니다!',
    'unsubscribe_success' => '뉴스레터 구독 취소가 완료되었습니다.',
    'email_not_exist_or_unsubscribed' => '귀하의 이메일이 시스템에 존재하지 않거나 이미 구독을 취소하셨습니다!',
    'email_address' => '이메일 주소',
    'dont_show_popup_again' => '이 팝업을 다시 표시하지 않음',
    'here' => '여기',
];
