@php
    $isConfigurable = $product->has_variation;
@endphp

<div class="card bb-product-item">
    <a title="{{ $product->name }}" href="{{ $product->url }}">
        <div class="wrapper">
            <div class="image">
                {!! RvMedia::image($product->image, $product->name, 'product-thumb', attributes: ['class' => 'card-img-top']) !!}
            </div>
        </div>
        <div class="card-body">
            <div class="card-title product-name fw-bold mb-3" >
                <a class="text-black" title="{{ $product->name }}" href="{{ $product->url }}">{{ $product->name }}</a>
            </div>

            @include(EcommerceHelper::viewPath('includes.product-price'))

            @if(EcommerceHelper::isReviewEnabled() && (!EcommerceHelper::hideRatingWhenNoReviews() || $product->reviews_count > 0))
                @include(EcommerceHelper::viewPath('includes.rating'))
            @endif

            <div class="product-add-cart-btn-large-wrapper">
                @if (EcommerceHelper::isCartEnabled())
                    <button
                        type="button"
                        class="btn btn-primary bb-btn-product-actions-icon"
                        @if($isConfigurable)
                            data-url="{{ route('public.ajax.quick-shop', $product->slug) }}"
                        {!! EcommerceHelper::jsAttributes('quick-shop', $product) !!}
                        @else
                            data-url="{{ route('public.cart.add-to-cart') }}"
                            data-id="{{ $product->original_product->id }}"
                            {!! EcommerceHelper::jsAttributes('add-to-cart', $product) !!}
                        @endif
                    >
                        <x-core::icon name="ti ti-shopping-cart"/>
                        <span class="tp-product-tooltip tp-product-tooltip-right">
                            @if ($isConfigurable)
                                {{ trans('plugins/ecommerce::ecommerce.select_options') }}
                            @else
                                {{ trans('plugins/ecommerce::ecommerce.add_to_cart') }}
                            @endif
                </span>
                    </button>
                @endif
            </div>
        </div>
    </a>
</div>
