@extends('plugins/ecommerce::orders.master')

@section('title', theme_option('ecommerce_checkout_seo_title') ?: __('Checkout'))

@section('content')
    @if (Cart::instance('cart')->isNotEmpty())
        @if (is_plugin_active('payment'))
            @include('plugins/payment::partials.header')
        @endif

        {!! $checkoutForm->renderForm() !!}

        @if (is_plugin_active('payment'))
            @include('plugins/payment::partials.footer')
        @endif
    @else
        <div class="container">
            <div class="alert alert-warning my-5">
                <span>{!! BaseHelper::clean(__('No products in cart. :link!', ['link' => Html::link(BaseHelper::getHomepageUrl(), __('Back to shopping'))])) !!}</span>
            </div>
        </div>
    @endif
@stop

@push('footer')
    <script type="text/javascript" src="{{ asset('vendor/core/core/base/libraries/jquery-compat/jquery4-compat.js') }}?v={{ EcommerceHelper::getAssetVersion() }}"></script>
    <script type="text/javascript" src="{{ asset('vendor/core/core/js-validation/js/js-validation.js') }}?v={{ EcommerceHelper::getAssetVersion() }}"></script>
@endpush
