<?php

return [
    'name' => 'Produkter',
    'description' => 'Hantera fysiska och digitala produkter med lager, prissättning och varianter',
    'create' => 'Ny produkt',
    'create_product_type' => [
        'physical' => 'Ny fysisk produkt',
        'digital' => 'Ny digital produkt',
    ],
    'edit' => 'Redigera produkt - :name',
    'form' => [
        'name' => 'Namn',
        'name_placeholder' => 'Produktens namn (Maximalt 120 tecken)',
        'description' => 'Beskrivning',
        'description_placeholder' => 'Kort beskrivning för produkten (Maximalt 400 tecken)',
        'categories' => 'Kategorier',
        'content' => 'Innehåll',
        'price' => 'Pris',
        'currency' => 'Valuta',
        'currency_for_variations_hint' => 'Denna valuta kommer att tillämpas på alla varianter av denna produkt.',
        'quantity' => 'Kvantitet',
        'brand' => 'Varumärke',
        'width' => 'Bredd',
        'height' => 'Höjd',
        'weight' => 'Vikt',
        'date' => [
            'start' => 'Från datum',
            'end' => 'Till datum',
        ],
        'image' => 'Bilder',
        'collections' => 'Produktsamlingar',
        'labels' => 'Etiketter',
        'price_sale' => 'Reapris',
        'product_type' => [
            'title' => 'Produkttyp',
        ],
        'product' => 'Produkt',
        'total' => 'Totalt',
        'sub_total' => 'Delsumma',
        'shipping_fee' => 'Fraktavgift',
        'discount' => 'Rabatt',
        'options' => 'Alternativ',
        'shipping' => [
            'height' => 'Höjd',
            'length' => 'Längd',
            'title' => 'Frakt',
            'weight' => 'Vikt',
            'wide' => 'Bred',
        ],
        'barcode' => 'Streckkod (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Ange streckkod',
        'cost_per_item' => 'Kostnad per artikel',
        'cost_per_item_placeholder' => 'Ange kostnad per artikel',
        'cost_per_item_helper' => 'Kunder kommer inte att se detta pris.',
        'price_includes_tax' => 'Priset inkluderar skatt',
        'price_includes_tax_helper' => 'Markera detta om det angivna priset redan inkluderar skatter. Systemet kommer att beräkna baspriset genom att ta bort skattebeloppet.',
        'stock' => [
            'allow_order_when_out' => 'Tillåt kund att handla när denna produkt är slut i lager',
            'in_stock' => 'I lager',
            'out_stock' => 'Slut i lager',
            'title' => 'Lagerstatus',
        ],
        'storehouse' => [
            'no_storehouse' => 'Ingen lagerhantering',
            'storehouse' => 'Med lagerhantering',
            'title' => 'Lager',
            'quantity' => 'Kvantitet',
        ],
        'tax' => 'Skatt',
        'taxes' => 'Skatter',
        'taxes_helper' => 'Standard skattesats konfigureras i <a href=":url">Inställningar -> Skatt</a>. Om ingen specifik skatt väljs för denna produkt kommer standardsatsen att tillämpas. För att inaktivera skatt för denna produkt, ta bort standardskattesatsen från skattinställningarna.',
        'is_default' => 'Är standard',
        'action' => 'Åtgärd',
        'restock_quantity' => 'Påfyllnadskvantitet',
        'remain' => 'Återstår',
        'choose_discount_period' => 'Välj rabattperiod',
        'cancel' => 'Avbryt',
        'no_results' => 'Inga resultat!',
        'value' => 'Värde',
        'attribute_name' => 'Attributnamn',
        'add_more_attribute' => 'Lägg till fler attribut',
        'continue' => 'Fortsätt',
        'add_new_attributes' => 'Lägg till nya attribut',
        'add_new_attributes_description' => 'Att lägga till nya attribut hjälper produkten att ha många alternativ, som storlek eller färg.',
        'create_product_variations' => ':link för att skapa produktvariationer!',
        'tags' => 'Taggar',
        'write_some_tags' => 'Skriv några taggar',
        'variation_existed' => 'Denna variation finns redan.',
        'no_attributes_selected' => 'Inga attribut valda!',
        'added_variation_success' => 'Lade till variation framgångsrikt!',
        'updated_variation_success' => 'Uppdaterade variation framgångsrikt!',
        'created_all_variation_success' => 'Skapade alla variationer framgångsrikt!',
        'updated_product_attributes_success' => 'Uppdaterade produktattribut framgångsrikt!',
        'stock_status' => 'Lagerstatus',
        'auto_generate_sku' => 'Auto-generera SKU?',
        'featured_image' => 'Utvald bild (valfritt)',
        'product_id' => 'Produkt-ID',
        'price_sale_percent_helper' => 'Rabatt :percent från ursprungligt pris.',
        'minimum_order_quantity' => 'Minsta orderkvantitet',
        'minimum_order_quantity_helper' => 'Minsta kvantitet för att lägga en order, om värdet är 0 finns ingen gräns.',
        'maximum_order_quantity' => 'Maximal orderkvantitet',
        'maximum_order_quantity_helper' => 'Maximal kvantitet för att lägga en order, om värdet är 0 finns ingen gräns.',
        'video' => 'Video',
        'video_file' => 'Fil',
        'video_url' => 'Eller extern video-URL',
        'video_url_help' => 'Ange YouTube eller Vimeo video-URL',
        'enter_video_url' => 'Ange video-URL',
        'video_thumbnail' => 'Videominiatyr',
        'video_thumbnail_help' => 'Välj en miniatyr för videon. Om den inte väljs kommer den automatiskt att hämtas från video-URL:en om tillgänglig.',
        'barcode_existed' => 'Denna streckkod används av en annan produkt. Ange en annan streckkod.',
        'barcode_helper' => 'Måste vara unik för varje produkt.',
        'is_new_until' => 'Ny till',
        'is_new_until_helper' => 'Ange ett datum till när denna produkt ska markeras som "Ny". Lämna tomt för att inte markera som ny baserat på datum.',
    ],
    'price' => 'Pris',
    'quantity' => 'Kvantitet',
    'type' => 'Typ',
    'image' => 'Miniatyr',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'Variations-SKU',
    'brand' => 'Varumärke',
    'cannot_delete' => 'Produkten kunde inte tas bort',
    'product_deleted' => 'Produkt borttagen',
    'product' => 'Produkt',
    'product_collections' => 'Produktsamlingar',
    'products' => 'Produkter',
    'total_products_found' => ':total produkter hittades',
    'total_product_found' => ':total produkt hittades',
    'menu' => 'Produkter',
    'control' => [
        'button_add_image' => 'Lägg till bild',
    ],
    'price_sale' => 'Reapris',
    'price_group_title' => 'Hantera produktpris',
    'store_house_group_title' => 'Hantera lager',
    'shipping_group_title' => 'Hantera frakt',
    'overview' => 'Översikt',
    'attributes' => 'Attribut',
    'product_has_variations' => 'Produkten har variationer',
    'manage_products' => 'Hantera produkter',
    'add_new_product' => 'Lägg till en ny produkt',
    'start_by_adding_new_product' => 'Börja med att lägga till nya produkter.',
    'edit_this_product' => 'Redigera denna produkt',
    'delete' => 'Ta bort',
    'related_products' => 'Relaterade produkter',
    'cross_selling_products' => 'Korsförsäljningsprodukter',
    'up_selling_products' => 'Merförsäljningsprodukter',
    'grouped_products' => 'Grupperade produkter',
    'search_products' => 'Sök produkter',
    'selected_products' => 'Valda produkter',
    'edit_variation_item' => 'Redigera',
    'variations_box_description' => 'Klicka på "Redigera attribut" för att lägga till/ta bort attribut för variation eller klicka på "Lägg till ny variation" för att lägga till variation.',
    'save_changes' => 'Spara ändringar',
    'continue' => 'Fortsätt',
    'edit_attribute' => 'Redigera attribut',
    'select_attribute' => 'Välj attribut',
    'add_new_variation' => 'Lägg till ny variation',
    'edit_variation' => 'Redigera variation',
    'generate_variations' => 'Generera variationer',
    'generate_variations_confirmation' => 'Är du säker på att du vill generera variationer för denna produkt?',
    'delete_variation' => 'Ta bort variation?',
    'delete_variation_confirmation' => 'Är du säker på att du vill ta bort denna variation? Denna åtgärd kan inte ångras.',
    'delete_variations_confirmation' => 'Är du säker på att du vill ta bort dessa variationer? Denna åtgärd kan inte ångras.',
    'product_create_validate_name_required' => 'Vänligen ange produktens namn',
    'product_create_validate_sale_price_max' => 'Rabatten måste vara mindre än det ursprungliga priset',
    'product_create_validate_cost_per_item_max' => 'Kostnaden per artikel måste vara mindre än det ursprungliga priset',
    'product_create_validate_sale_price_required_if' => 'Måste ange en rabatt när du vill schemalägga en kampanj',
    'product_create_validate_end_date_after' => 'Slutdatum måste vara efter startdatum',
    'product_create_validate_start_date_required_if' => 'Rabattens startdatum kan inte lämnas tomt när schemaläggning är valt',
    'product_create_validate_sale_price' => 'Rabatter kan inte lämnas tomma när schemaläggning är valt',
    'stock_statuses' => [
        'in_stock' => 'I lager',
        'out_of_stock' => 'Slut i lager',
        'on_backorder' => 'Restorder',
    ],
    'stock_status' => 'Lagerstatus',
    'processing' => 'Bearbetar...',
    'delete_selected_variations' => 'Ta bort valda variationer',
    'delete_variations' => 'Ta bort variationer',
    'category' => 'Kategori',
    'categories' => 'Kategorier',
    'tags' => 'Taggar',
    'product_price_flash_sale_warning' => 'Denna produkt är i blixtrean <strong>:name</strong> så dess pris är <strong>:price</strong>.',
    'product_price_discount_warning' => 'Denna produkt är på rea <strong>:name</strong> så dess pris är <strong>:price</strong>.',
    'product_image' => 'Produktbild',
    'product_name' => 'Produktnamn',
    'product_link' => 'Produktlänk',
    'types' => [
        'physical' => 'Fysisk',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Digitala bilagor',
        'add' => 'Lägg till bilaga',
        'file_name' => 'Filnamn',
        'file_size' => 'Filstorlek',
        'unsaved' => 'Osparad',
        'add_external_link' => 'Lägg till extern länk',
        'enter_file_name' => 'Ange filnamn',
        'enter_external_link_download' => 'Ange extern nedladdningslänk',
        'enter_file_size' => 'Ange filstorlek',
        'external_link_download' => 'Extern nedladdningslänk',
        'generate_license_code_after_purchasing_product' => 'Aktivera licenskodstilldelning för denna produkt',
        'notify_attachment_updated' => 'Skicka ett e-postmeddelande till kunden när bilagan uppdateras',
        'no_attachments' => 'Inga bilagor ännu. Klicka på knapparna ovan för att lägga till filer.',
    ],
    'license_codes' => [
        'title' => 'Licenskoder',
        'add' => 'Lägg till licenskod',
        'back' => 'Tillbaka till produkt',
        'edit' => 'Redigera licenskod',
        'generate' => 'Generera koder',
        'manage_codes' => 'Hantera licenskoder',
        'management' => 'Licenskodhantering',
        'variation_breadcrumb' => 'Variation: :name',
        'variation_label' => 'Produktvariation',
        'variation_specific_note' => 'Dessa licenskoder är specifika för denna produktvariation. Kunder som köper denna variation kommer att få koder från denna pool.',
        'main_product_note' => 'Denna produkt har variationer. Varje variation kan ha sina egna licenskoder, eller kunder kan få koder från denna huvudproduktpool om variationen inte har några koder.',
        'code' => 'Licenskod',
        'codes' => 'Licenskoder',
        'status' => 'Status',
        'assigned_at' => 'Tilldelad vid',
        'status_available' => 'Tillgänglig',
        'status_used' => 'Använd',
        'statuses' => [
            'available' => 'Tillgänglig',
            'used' => 'Använd',
        ],
        'no_codes' => 'Inga licenskoder hittades. Lägg till några koder eller generera dem automatiskt.',
        'no_codes_warning_title' => 'Inga licenskoder tillgängliga!',
        'no_codes_warning_message' => 'Denna produkt är inställd på "Välj från lista" men har inga tillgängliga licenskoder. Kunder som köper denna produkt kommer att få automatiskt genererade koder istället. Lägg till licenskoder för att säkerställa korrekt funktionalitet.',
        'no_codes_auto_generate' => 'Denna produkt är inställd att auto-generera licenskoder. Inga manuella koder behövs.',
        'used_code_no_actions' => 'Använd kod - inga åtgärder tillgängliga',
        'created_successfully' => 'Licenskod skapad framgångsrikt!',
        'updated_successfully' => 'Licenskod uppdaterad framgångsrikt!',
        'deleted_successfully' => 'Licenskod borttagen framgångsrikt!',
        'generated_successfully' => 'Genererade :count licenskoder framgångsrikt!',
        'duplicates_skipped' => ':count duplicerade koder hoppades över.',
        'generation_incomplete' => 'Varning: Kunde bara generera :generated av :requested begärda koder på grund av dupliceringskonflikter.',
        'cannot_edit_used_code' => 'Kan inte redigera en använd licenskod.',
        'cannot_delete_used_code' => 'Kan inte ta bort en använd licenskod.',
        'show_all' => 'Visa alla',
        'show_less' => 'Visa mindre',
        'more' => 'mer',
        'used_codes_hidden' => ':count använda licenskod(er) är dolda. Du kan visa alla koder på sidan för licenskodhantering.',
        'low_stock_title' => 'Lågt licenskodlager',
        'low_stock_message' => 'Endast :count licenskoder kvar. Överväg att lägga till fler koder för att undvika att få slut.',
        'out_of_stock_title' => 'Slut på licenskoder!',
        'out_of_stock_message' => 'Inga licenskoder tillgängliga. Kunder kommer att få automatiskt genererade koder tills du lägger till fler.',
        'type' => [
            'title' => 'Tilldelningsmetod för licenskod',
            'auto_generate' => 'Auto-generera (Systemet genererar koder automatiskt)',
            'pick_from_list' => 'Välj från lista (Använd förinmatade koder)',
            'description' => 'Välj hur licenskoder ska tilldelas kunder när de köper denna produkt.',
        ],
        'add_modal' => [
            'placeholder' => 't.ex. XXXX-XXXX-XXXX-XXXX',
            'help' => 'Ange en unik licenskod som kommer att tilldelas en kund vid köp.',
        ],
        'generate_modal' => [
            'title' => 'Generera licenskoder',
            'quantity' => 'Kvantitet',
            'format' => 'Format',
            'custom_pattern' => 'Anpassat mönster',
            'pattern_help' => 'Använd # för siffror, A för stora bokstäver, a för små bokstäver',
            'generate' => 'Generera',
        ],
        'errors' => [
            'feature_not_enabled' => 'Licenskodsfunktionen är inte aktiverad. Aktivera den i E-handelsinställningar > Digitala produkter.',
            'digital_products_not_enabled' => 'Digitala produkter är inte aktiverade. Aktivera stöd för digitala produkter först.',
            'product_not_found' => 'Produkten hittades inte.',
            'not_digital_product' => 'Licenskoder är endast tillgängliga för digitala produkter. Denna produkt är inställd som en fysisk produkt.',
            'license_codes_not_enabled_for_product' => 'Licenskodhantering är inte aktiverad för denna produkt. Aktivera "Generera licenskod efter köp av produkt" i produktinställningarna.',
            'cannot_add_codes_auto_generate' => 'Kan inte manuellt lägga till licenskoder till produkter som är inställda att auto-generera. Ändra licenskodtypen till "Välj från lista" först.',
            'cannot_generate_codes_auto_generate' => 'Kan inte manuellt generera licenskoder för produkter som är inställda att auto-generera. Ändra licenskodtypen till "Välj från lista" först.',
        ],
        'bulk_delete' => [
            'button' => 'Ta bort valda',
            'selected' => 'valda',
            'confirm' => 'Är du säker på att du vill ta bort de valda licenskoderna?',
            'deleted_successfully' => ':count licenskod(er) togs bort framgångsrikt.',
            'skipped_used_codes' => ':count använda kod(er) hoppades över.',
            'no_deletable_codes' => 'Inga tillgängliga licenskoder att ta bort hittades. Använda koder kan inte tas bort.',
        ],
        'import' => [
            'name' => 'Importera produktlicenskoder',
            'description' => 'Importera licenskoder för digitala produkter från CSV/Excel-fil.',
            'button' => 'Importera',
            'columns' => [
                'product_id' => 'Produkt-ID eller SKU',
                'license_code' => 'Licenskod',
            ],
        ],
        'copied' => 'Licenskod kopierad till urklipp!',
    ],
    'this_action_will_reload_page' => 'Denna åtgärd kommer att ladda om sidan för att uppdatera datan!',
    'select' => 'Välj',
    'clear_filters' => 'Rensa filter',
    'set_this_variant_as_default' => 'Sätt denna variant som standard',
    'download' => 'Ladda ner',
    'external_link_downloads' => 'Externa länkar',
    'download_available_when_completed' => 'Nedladdningslänkar blir tillgängliga när beställningen är slutförd.',
    'cross_sell_price_type' => [
        'title' => 'Pristyp',
        'fixed' => 'Fast',
        'percent' => 'Procent',
    ],
    'cross_sell_help' => [
        'price' => '* Prisfält',
        'price_description' => 'Ange det belopp du vill minska från det ursprungliga priset. Exempel: Om det ursprungliga priset är 100 kr, ange 20 för att minska priset till 80 kr.',
        'type' => '* Typfält',
        'type_description' => 'Välj rabatttyp: Fast (minska ett specifikt belopp) eller Procent (minska med en procentsats).',
    ],
    'up_sell_price_type' => [
        'title' => 'Pristyp',
        'fixed' => 'Fast',
        'percent' => 'Procent',
    ],
    'up_sell_help' => [
        'price' => '* Prisfält',
        'price_description' => 'Ange det belopp du vill minska från det ursprungliga priset. Exempel: Om det ursprungliga priset är 100 kr, ange 20 för att minska priset till 80 kr.',
        'type' => '* Typfält',
        'type_description' => 'Välj rabatttyp: Fast (minska ett specifikt belopp) eller Procent (minska med en procentsats).',
    ],
    'up_sale' => [
        'title' => 'Köp tillsammans och spara',
        'description' => 'Få specialrabatter när du köper dessa produkter tillsammans',
        'unlock_discount' => 'Lägg till :product i kundvagnen för att låsa upp paketrabatt',
        'multiple_options' => 'Flera alternativ',
        'multiple_options_available' => 'Flera alternativ tillgängliga',
        'select' => 'Välj',
        'selected_items_total' => 'Totalt för valda artiklar:',
        'add_selected_to_cart' => 'Lägg till valda i kundvagnen',
        'bundle_discount_with' => 'Paketrabatt med :product',
        'bundle_with' => 'Paket med :product',
    ],
    'cross_sale' => [
        'title' => 'Ofta köpta tillsammans',
        'description' => 'Kunder som tittade på denna artikel köpte också',
    ],
    'apply_for_all_variations' => 'Tillämpa för alla variationer',
    'export' => [
        'description' => 'Exportera din produktdata till CSV- eller Excel-filer.',
        'total_items' => 'Totalt antal artiklar',
        'total_products' => 'Totalt antal produkter',
        'total_variations' => 'Totalt antal variationer',
        'advanced_options' => 'Avancerade alternativ',
        'use_chunked_export' => 'Använd segmenterad export',
        'use_chunked_export_helper' => 'Bearbeta data i segment för att hantera stora dataset effektivt',
        'include_variations' => 'Inkludera produktvariationer',
        'include_variations_helper' => 'Exportera produktvariationer tillsammans med huvudprodukter',
        'optimize_memory' => 'Optimera minnesanvändning',
        'optimize_memory_helper' => 'Aktivera minnesoptimering för mycket stora exporter',
        'chunk_size' => 'Segmentstorlek',
        'chunk_size_helper' => 'Antal produkter att bearbeta åt gången (50-5000)',
        'use_streaming' => 'Använd streaming-export',
        'use_streaming_helper' => 'Aktivera streaming för mycket stora dataset (aktiveras automatiskt för >10 000 artiklar)',
        'large_dataset_warning_title' => 'Stor produktkatalog upptäckt',
        'large_dataset_warning_message' => 'Din katalog innehåller :count artiklar. På grund av den stora storleken har vissa exportalternativ optimerats för bästa prestanda.',
        'large_dataset_specific_message' => 'För dina :count produkter, använd CSV-format med streaming aktiverat. Systemet kan nu hantera din stora produktkatalog effektivt utan timeout eller minnesproblem.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Krävs)',
        'chunk_label' => 'Bearbetning',
        'chunk_recommended' => '300 produkter/batch',
        'time_label' => 'Uppskattad tid',
        'time_estimate' => '1-3 minuter',
        'pro_tip' => 'Pro Tips:',
        'pro_tip_message' => 'Exporten kommer att fortsätta köra även om din webbläsare visar en laddningsindikator. När den väl startats kommer nedladdningen att börja automatiskt.',
        'large_dataset_tip_1' => 'Excel-format har inaktiverats - använd CSV-format för snabbare och mer tillförlitliga exporter',
        'large_dataset_tip_2' => 'Streaming-läge har aktiverats automatiskt för att förhindra timeout',
        'large_dataset_tip_3' => 'Exportprocessen kan ta 1-3 minuter beroende på din server',
        'large_dataset_recommendation' => 'Rekommenderat: Använd CSV-format med 200-500 segmentstorlek för optimal prestanda.',
        'excel_disabled_for_large_export' => 'Excel-format inte tillgängligt för kataloger över 10 000 artiklar',
        'streaming_auto_enabled' => 'Streaming-läge har aktiverats automatiskt för optimal prestanda med stora dataset.',
        'streaming_enabled_title' => 'Optimerad för stor export',
        'streaming_enabled_message' => 'Streaming-läge är aktivt för att säkerställa smidig export utan minnesproblem.',
        'use_multi_file' => 'Använd flerfilsexport',
        'use_multi_file_helper' => 'Dela upp export i flera filer packade i en ZIP för mycket stora datamängder',
        'multi_file_enabled_title' => 'Flerfilsexport Aktiverad',
        'multi_file_enabled_message' => 'Din export kommer att delas upp i :count filer packade i en ZIP för optimal prestanda.',
        'records_per_file' => 'Poster Per Fil',
        'records_per_file_helper' => 'Antal poster i varje fil vid användning av flerfilsexport',
        'estimated_files' => 'Uppskattade Filer',
        'recommended_range' => 'Rekommenderat intervall',
        'range_large_export' => '200-500 artiklar',
        'range_medium_export' => '300-800 artiklar',
        'range_small_export' => '500-1000 artiklar',
        'export_progress' => 'Exportframsteg',
        'preparing_export' => 'Förbereder export...',
        'items_processed' => ':count artiklar bearbetade',
        'estimated_time_calculating' => 'Uppskattad tid: beräknar...',
        'medium_dataset_detected' => 'Medelstor dataset upptäckt',
        'medium_dataset_message' => 'Du exporterar :count produkter. Överväg att använda segmenterad export för bättre prestanda.',
        'optimal_range' => 'Optimalt intervall',
        'too_small_slow' => 'För liten - kan vara långsam',
        'too_large_timeouts' => 'För stor - kan orsaka timeout',
        'excel_disabled_warning' => 'Excel-format inaktiverat för stora exporter (:count artiklar)',
        'starting_export' => 'Startar export...',
        'processing_data' => 'Bearbetar data...',
        'finalizing_export' => 'Slutför export...',
        'items_processed_suffix' => 'artiklar bearbetade',
        'estimated_time_prefix' => 'Uppskattad tid:',
        'seconds_remaining' => 's kvar',
        'export_completed' => 'Export slutförd!',
        'download_starting' => 'Nedladdning startar...',
    ],
    'import' => [
        'description' => 'Importera din produktdata från CSV- eller Excel-filer.',
        'rules' => [
            'in' => ':attribute måste vara ett av de definierade värdena: :values.',
            'required_string_max' => ':attribute krävs och måste vara en sträng med en maximal längd på :max tecken.',
            'nullable_string' => ':attribute kan lämnas tom eller måste vara en sträng om den anges.',
            'nullable_string_max' => ':attribute kan lämnas tom eller måste vara en sträng med en maximal längd på :max tecken om den anges',
            'nullable_bool' => 'Huruvida :attribute kan lämnas tom eller måste vara ett booleskt värde om det anges.',
            'nullable_numeric_min' => ':attribute kan lämnas tom eller måste vara ett icke-negativt tal om det anges.',
            'nullable_numeric_min_max' => ':attribute kan lämnas tomt eller måste vara ett tal mellan :min och :max om det anges.',
            'nullable_array' => ':attribute kan lämnas tom eller måste anges som en array om det specificeras.',
            'nullable_date_required_if' => ':attribute kan lämnas tom eller måste vara ett giltigt datum om det anges, krävs om :required specificeras.',
            'nullable_date_after' => ':attribute kan lämnas tom eller måste vara ett giltigt datum efter :after om det anges.',
        ],
        'updated_message' => 'Uppdaterade :count produkter framgångsrikt!',
    ],
    'import_products_intro' => 'Eller importera produkter från CSV/Excel',
    'select_attributes' => 'Välj attribut för att skapa variationer:',
    'all' => 'Alla',
    'copy' => 'Kopiera',
    'product_translations' => 'Produktöversättningar',
    'view' => 'Visa produkt - :name',
    'product_information' => 'Produktinformation',
    'total_views' => 'Totalt Antal Visningar',
    'total_orders' => 'Slutförda Beställningar',
    'total_sold' => 'Totalt Sålt',
    'total_revenue' => 'Total Intäkt',
    'pending_orders' => 'Väntande beställningar',
    'pending_revenue' => 'Väntande intäkter',
    'conversion_rate' => 'Konverteringsgrad',
    'total_reviews' => 'Totalt Recensioner',
    'average_rating' => 'Genomsnittligt Betyg',
    'views_by_date' => 'Visningar per Datum (Senaste 30 Dagarna)',
    'recent_orders' => 'Senaste Beställningarna',
    'no_views_data' => 'Inga visningsdata tillgängliga för de senaste 30 dagarna.',
    'no_orders' => 'Inga beställningar än.',
    'date' => 'Datum',
    'views' => 'Visningar',
    'total' => 'Totalt',
    'view_on_frontend' => 'Visa på webbplatsen',
    'select_attribute' => 'Välj :name',
    'all_categories' => 'Alla kategorier',
    'brands' => 'Varumärken',
    'browse_products' => 'Bläddra bland produkter',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Välj produkter att returnera',
    'show_only_discounted_products' => 'Visa endast rabatterade produkter',
    'specification' => 'Specifikation',
    'download_product_with_external_links' => 'Ladda ner produkten ":name" med externa länkar',
    'number_product_available_singular' => ':number produkt tillgänglig',
    'number_products_available_plural' => ':number produkter tillgängliga',
    'cart' => [
        'added_to_cart_success' => ':product har lagts till i din kundvagn.',
        'removed_from_cart_success' => ':product har tagits bort från din kundvagn.',
        'updated_cart_success' => 'Din kundvagn har uppdaterats.',
        'item_not_found' => 'Denna artikel finns inte längre i din kundvagn.',
        'out_of_stock' => 'Tyvärr, :product är för närvarande slut i lager.',
        'max_quantity' => 'Du kan bara lägga till upp till :max artiklar.',
        'max_quantity_detail' => 'Tyvärr kan du bara beställa :quantity enheter av :product åt gången.',
        'select_options' => 'Välj produktalternativ innan du lägger till i kundvagnen.',
        'product_out_of_stock' => 'Tyvärr är denna produkt för närvarande slut i lager.',
        'product_not_exists' => 'Denna produkt är slut i lager eller finns inte längre.',
        'not_enough_quantity' => 'Vissa produkter har inte tillräckligt med lager för uppdatering.',
        'empty_success' => 'Din kundvagn har tömts.',
        'bundle_item_already_in_cart' => 'Denna paketartikel finns redan i din kundvagn. Endast 1 artikel per paketrabatt är tillåten.',
    ],
    'wishlist' => [
        'added_success' => ':product har lagts till i din önskelista.',
        'removed_success' => ':product har tagits bort från din önskelista.',
        'product_not_found' => 'Denna produkt kunde inte hittas.',
        'product_not_in_wishlist' => 'Denna produkt finns inte i din önskelista.',
        'product_not_available' => 'Denna produkt är inte tillgänglig.',
    ],
    'compare' => [
        'added_success' => ':product har lagts till i din jämförelselista.',
        'removed_success' => ':product har tagits bort från din jämförelselista.',
        'product_not_found' => 'Denna produkt kunde inte hittas.',
        'product_not_in_compare' => 'Denna produkt finns inte i din jämförelselista.',
        'already_in_list' => ':product finns redan i din jämförelselista.',
    ],
];
