<?php

return [
    'save_settings' => 'Сохранить настройки',
    'ecommerce' => 'Электронная коммерция',
    'general' => [
        'name' => 'Общие',
        'description' => 'Название магазина, данные компании, контакты и email уведомлений админа',
    ],
    'currency' => [
        'name' => 'Валюты',
        'description' => 'Форматы валют, курсы обмена, автоопределение и разделители десятичных/тысяч',
        'currency_setting_description' => 'Просмотр и обновление валют, используемых на сайте',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Включить автоопределение валюты посетителя',
            'enable_auto_detect_visitor_currency_helper' => 'Автоматически определять и отображать цены в местной валюте посетителя на основе его местоположения. Это обеспечивает более персонализированный опыт покупок.',
            'add_space_between_price_and_currency' => 'Добавить пробел между ценой и валютой',
            'add_space_between_price_and_currency_helper' => 'При включении добавляет пробел между значением цены и символом валюты (например, \"100 USD\" вместо \"100USD\").',
            'thousands_separator' => 'Разделитель тысяч',
            'thousands_separator_helper' => 'Выберите символ для разделения тысяч в отображении цен (например, 1 000 или 1.000 или 1,000).',
            'decimal_separator' => 'Десятичный разделитель',
            'decimal_separator_helper' => 'Выберите символ для разделения десятичных значений в ценах (например, 10,99 или 10.99).',
            'separator_period' => 'Точка (.)',
            'separator_comma' => 'Запятая (,)',
            'separator_space' => 'Пробел ( )',
            'api_key' => 'API ключ обменных курсов',
            'api_key_helper' => 'Получить API ключ обменного курса на :link',
            'update_currency_rates' => 'Обновить курсы валют',
            'use_exchange_rate_from_api' => 'Использовать обменный курс из API',
            'use_exchange_rate_from_api_helper' => 'Включить автоматические обновления курсов валют от настроенного поставщика API. Это гарантирует, что ваши цены всегда актуальны с текущими рыночными курсами.',
            'clear_cache_rates' => 'Очистить кэш курсов',
            'auto_detect_visitor_currency_description' => 'Определяет валюту посетителя на основе языка браузера. Это переопределит выбор валюты по умолчанию.',
            'exchange_rate' => [
                'api_provider' => 'API провайдер',
                'select' => '-- Выбрать --',
                'none' => 'Нет',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'Для валюты по умолчанию обменный курс должен быть равен 1.',
        ],
    ],
    'product' => [
        'name' => 'Товары',
        'description' => 'Отображение остатков, генерация SKU, изображения вариантов, связанные товары и характеристики',
        'product_settings' => 'Настройки товаров',
        'product_settings_description' => 'Настройка правил для товаров',
        'form' => [
            'show_number_of_products' => 'Показывать количество товаров на странице товара',
            'show_number_of_products_helper' => 'Отображать общее количество товаров на странице детализации товара.',
            'show_out_of_stock_products' => 'Показывать товары отсутствующие на складе',
            'show_out_of_stock_products_helper' => 'Если включено, товары отсутствующие на складе будут отображаться на странице списка товаров.',
            'how_to_display_product_variation_images' => 'Как отображать изображения вариаций товаров',
            'how_to_display_product_variation_images_helper' => 'Выберите, показывать только изображения конкретной вариации или включить как изображения вариации, так и основного товара.',
            'only_variation_images' => 'Только изображения вариации',
            'variation_images_and_main_product_images' => 'Изображения вариации и основного товара',
            'enable_product_options' => 'Включить опции товаров',
            'enable_product_options_helper' => 'Позволить товарам иметь настраиваемые опции, такие как размер, цвет и т.д.',
            'is_enabled_cross_sale_products' => 'Включить товары для перекрестных продаж',
            'is_enabled_cross_sale_products_helper' => 'Отображать предложения товаров для перекрестных продаж для стимулирования дополнительных покупок.',
            'is_enabled_related_products' => 'Включить связанные товары',
            'is_enabled_related_products_helper' => 'Показывать связанные товары на основе категории или выбранные администратором в форме товара.',
            'related_products_source' => 'Источник связанных товаров',
            'related_products_source_helper' => 'Когда администратор не выбирает связанные товары в форме товара, показывать связанные товары на основе этого источника.',
            'related_products_source_category' => 'Та же категория',
            'related_products_source_brand' => 'Тот же бренд',
            'trending_products_period' => 'Период популярных товаров',
            'trending_products_period_helper' => 'Выберите период времени для расчета популярных товаров на основе количества просмотров.',
            'trending_products_period_1_day' => 'Последние 24 часа',
            'trending_products_period_3_days' => 'Последние 3 дня',
            'trending_products_period_7_days' => 'Последние 7 дней (1 неделя)',
            'trending_products_period_14_days' => 'Последние 14 дней (2 недели)',
            'trending_products_period_30_days' => 'Последние 30 дней (1 месяц)',
            'trending_products_period_60_days' => 'Последние 60 дней (2 месяца)',
            'trending_products_period_90_days' => 'Последние 90 дней (3 месяца)',
            'auto_generate_product_sku' => 'Автоматически генерировать SKU при создании товара',
            'auto_generate_product_sku_helper' => 'Автоматически генерировать уникальные SKU для новых товаров на основе формата ниже.',
            'product_sku_format' => 'Формат SKU',
            'product_sku_format_helper' => 'Вы можете использовать %s (1 символ строки) или %d (1 цифра) в формате для генерации случайной строки. Например: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Включить спецификацию товара',
            'enable_product_specification_help' => 'Если включено, таблица спецификации товара будет отображаться на странице детализации товара.',
            'make_product_barcode_required' => 'Сделать штрихкод товара обязательным',
            'make_product_barcode_required_helper' => 'Если включено, штрихкод товара будет обязательным при создании товара.',
        ],
    ],
    'product_search' => [
        'name' => 'Поиск товаров',
        'description' => 'Поведение поиска, фильтры по категории/бренду/тегу/атрибутам и фильтрация по ценовому диапазону',
        'product_search_settings' => 'Поиск товаров',
        'product_search_settings_description' => 'Настройка правил для поиска товаров',
        'form' => [
            'search_for_an_exact_phrase' => 'Поиск точной фразы',
            'search_products_by' => 'Поиск товаров по:',
            'enable_filter_products_by_categories' => 'Включить фильтрацию товаров по категориям',
            'enable_filter_products_by_brands' => 'Включить фильтрацию товаров по брендам',
            'enable_filter_products_by_tags' => 'Включить фильтрацию товаров по тегам',
            'number_of_popular_tags_for_filter' => 'Количество популярных тегов для фильтра',
            'number_of_popular_tags_for_filter_placeholder' => 'Введите количество популярных тегов для отображения',
            'number_of_popular_tags_for_filter_helper' => 'Установите максимальное количество популярных тегов для отображения в фильтре. По умолчанию 10.',
            'enable_filter_products_by_attributes' => 'Включить фильтрацию товаров по атрибутам',
            'enable_filter_products_by_price' => 'Включить фильтрацию товаров по цене',
            'max_product_price_for_filter' => 'Максимальная цена товара для фильтра',
            'max_product_price_for_filter_placeholder' => 'Если пусто или ноль, будет получена максимальная цена товара из ваших существующих товаров.',
            'max_product_price_for_filter_helper' => 'Вы можете установить фиксированную цену для этого или она будет динамически получена из максимальной цены ваших существующих товаров. В настоящее время это :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Цифровые товары',
        'description' => 'Скачиваемые товары, лицензионные коды, гостевая оплата цифровых товаров и автозавершение',
        'digital_products_settings' => 'Цифровые товары',
        'digital_products_settings_description' => 'Настройка правил для цифровых товаров',
        'form' => [
            'enable_support_digital_product' => 'Включена ли поддержка цифровых товаров',
            'enable_support_digital_product_helper' => 'Когда включено, система будет поддерживать продажу цифровых товаров, таких как программное обеспечение, электронные книги, музыка и другой загружаемый контент.',
            'allow_guest_checkout_for_digital_products' => 'Разрешить гостевое оформление заказа для цифровых товаров',
            'allow_guest_checkout_for_digital_products_helper' => 'Когда включено, клиенты могут покупать цифровые товары без создания аккаунта. Они получат ссылки для скачивания по электронной почте.',
            'disable_physical_product' => 'Отключить физические товары',
            'disable_physical_product_helper' => 'Когда включено, магазин будет продавать только цифровые товары. Опции физических товаров будут скрыты из форм товаров и оформления заказа.',
            'enable_license_codes_for_digital_products' => 'Включить лицензионные коды для цифровых товаров',
            'auto_complete_digital_orders_after_payment' => 'Автоматически завершать цифровые заказы после оплаты',
            'auto_complete_digital_orders_after_payment_helper' => 'Когда включено, заказы, содержащие только цифровые товары, будут автоматически помечены как завершенные после получения оплаты.',
            'enable_license_codes_for_digital_products_helper' => 'Когда включено, вы можете добавлять лицензионные коды к цифровым товарам. Когда отключено, функциональность лицензионных кодов будет скрыта из форм товаров.',
            'hide_used_license_codes_in_product_form' => 'Скрыть использованные лицензионные коды в форме товара',
            'hide_used_license_codes_in_product_form_helper' => 'Когда включено, использованные лицензионные коды будут скрыты из таблицы лицензионных кодов в форме редактирования товара. Это помогает поддерживать чистоту интерфейса при наличии множества использованных кодов.',
        ],
    ],
    'product_review' => [
        'name' => 'Отзывы о товарах',
        'description' => 'Отзывы клиентов, отображение рейтингов, загрузка изображений и требования одобрения',
        'form' => [
            'enable_review' => 'Включить отзывы о товарах',
            'enable_review_help' => 'Разрешить клиентам оставлять отзывы и оценки товаров. Когда отключено, все функции отзывов будут скрыты из магазина.',
            'allow_customer_upload_image_in_review' => 'Разрешить клиентам загружать изображения в отзывах',
            'allow_customer_upload_image_in_review_help' => 'Когда отключено, клиенты не могут загружать изображения при отправке отзывов',
            'review' => [
                'max_file_size' => 'Максимальный размер файла отзыва (МБ)',
                'max_file_number' => 'Максимальное количество файлов в отзыве',
            ],
            'only_allow_customers_purchased_to_review' => 'Только клиенты, купившие товар, могут оставлять отзывы о товаре',
            'review_need_to_be_approved' => 'Отзыв должен быть одобрен перед показом на странице товара',
            'show_customer_full_name' => 'Показывать полное имя клиента',
            'show_customer_full_name_help' => 'Если не отмечено, имя рецензента будет скрыто и заменено звездочками (***)',
            'hide_rating_when_no_reviews' => 'Скрывать рейтинг при отсутствии отзывов',
            'hide_rating_when_no_reviews_help' => 'Когда включено, рейтинги товаров будут скрыты в списках товаров и на страницах детализации товаров, когда у товара нет отзывов',
            'display_uploaded_customer_review_images_list' => 'Отображать секцию "Изображения от клиентов"',
            'display_uploaded_customer_review_images_list_help' => 'Когда включено, показывает галерею всех загруженных клиентами изображений в верхней части секции отзывов',
        ],
    ],
    'shopping' => [
        'name' => 'Покупки',
        'description' => 'Корзина, список желаний, сравнение, отслеживание заказов, кнопка быстрой покупки и загрузка подтверждения оплаты',
        'general_setting' => 'Общие настройки',
        'return_settings' => 'Настройки возврата',
        'return_settings_description' => 'Настройка правил для настроек возврата',
        'form' => [
            'enable_cart' => 'Включить корзину покупок',
            'enable_cart_helper' => 'Если отключено, кнопка корзины будет удалена, превратив ваш сайт в отображение только каталога.',
            'enable_wishlist' => 'Включить список желаний',
            'enable_wishlist_helper' => 'Если отключено, кнопка списка желаний будет удалена с сайта.',
            'enable_wishlist_sharing' => 'Включить совместное использование списка желаний',
            'shared_wishlist_lifetime' => 'Время жизни общего списка желаний (дни)',
            'shared_wishlist_lifetime_helper' => 'Время жизни общего списка желаний в днях. По истечении этого времени общий список желаний будет удален.',
            'enable_compare' => 'Включить сравнение',
            'enable_compare_helper' => 'Если отключено, кнопка сравнения будет удалена с сайта.',
            'enable_order_tracking' => 'Включить отслеживание заказов',
            'enable_order_tracking_helper' => 'Клиенты могут отслеживать свои заказы, введя код заказа и email/телефон на :url',
            'order_tracking_method' => 'Метод отслеживания заказа',
            'order_tracking_method_helper' => 'Выберите, как клиенты будут отслеживать свои заказы: используя ID заказа + Email или ID заказа + номер телефона.',
            'order_tracking_method_email' => 'ID заказа + Email',
            'order_tracking_method_phone' => 'ID заказа + номер телефона',
            'enable_quick_buy_button' => 'Включить кнопку быстрой покупки',
            'enable_quick_buy_button_helper' => 'Будет показана кнопка "Купить сейчас" на странице списка товаров и детализации. Когда клиенты нажимают на эту кнопку, товар будет добавлен в корзину и произойдет перенаправление на страницу корзины/оформления заказа.',
            'enable_order_auto_confirmed' => 'Автоподтверждение заказа',
            'enable_order_auto_confirmed_helper' => 'Если включено, заказ будет автоматически подтвержден после размещения заказа клиентом.',
            'quick_buy_target' => 'Целевая страница быстрой покупки',
            'checkout_page' => 'Страница оформления заказа',
            'cart_page' => 'Страница корзины',
            'cart_destroy_on_logout' => 'Уничтожать корзину при выходе',
            'cart_destroy_on_logout_helper' => 'Корзина будет уничтожена при выходе клиента из системы.',
            'hide_product_price' => 'Скрыть цену товара',
            'hide_product_price_helper' => 'Эта опция работает только если вы отключили корзину покупок, превратив ваш сайт в отображение только каталога. Если включено, цена товара будет скрыта. Это полезно, когда вы хотите скрыть цену и требуете от клиентов связаться с вами для получения цены.',
            'hide_product_price_when_zero' => 'Скрывать цену товара, если она равна нулю',
            'hide_product_price_when_zero_helper' => 'Если включено, для товаров с ценой 0 цена не будет отображаться в витрине.',
            'enable_payment_proof' => 'Включить загрузку подтверждения платежа',
            'enable_payment_proof_helper' => 'Разрешить клиентам загружать подтверждение платежа для своих заказов. Это полезно для ручных методов оплаты.',
            'enable_guest_payment_proof' => 'Разрешить гостевым клиентам загружать подтверждение платежа',
            'enable_guest_payment_proof_helper' => 'Когда включено, гостевые клиенты могут загружать подтверждение платежа, используя свой токен заказа без входа в систему. Они получат ссылку для загрузки в письме с подтверждением заказа.',
            'payment_proof_payment_methods' => 'Способы оплаты, требующие подтверждения платежа',
            'payment_proof_payment_methods_helper' => 'Выберите, какие способы оплаты должны позволять клиентам загружать подтверждение платежа. Обычно используется для ручных способов оплаты, таких как наложенный платеж и банковский перевод.',
        ],
    ],
    'checkout' => [
        'name' => 'Оформление заказа',
        'panel_description' => 'Гостевая оплата, обязательные поля, лимиты заказов, принятие условий и ограничения по странам',
        'description' => 'Настройка правил для настроек оформления заказа',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Отображать банковскую информацию на странице успешного оформления заказа',
            'mandatory_form_fields_at_checkout' => 'Обязательные поля на странице оформления заказа:',
            'mandatory_form_fields_at_checkout_helper' => 'Выберите, какие поля обязательны при оформлении заказа. Клиенты должны заполнить эти поля для завершения заказа.',
            'hide_form_fields_at_checkout' => 'Скрыть поля клиента на странице оформления заказа:',
            'hide_form_fields_at_checkout_helper' => 'Выберите, какие поля должны быть скрыты на странице оформления заказа. Эти поля не будут видны клиентам.',
            'load_countries_states_cities_from_location_plugin' => 'Загружать страны, области, города из плагина местоположения',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'После изменения этой опции вам нужно обновить все адреса снова. Вы должны установить это один раз.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Затем вам нужно перейти в Инструменты -> Импорт/Экспорт данных для импорта данных о местоположении.',
            'minimum_order_amount' => 'Минимальная сумма заказа для размещения заказа (:currency).',
            'minimum_order_amount_helper' => 'Установите минимальную общую сумму, необходимую для обработки заказа. Заказы ниже этой суммы не будут приняты.',
            'zip_code_enabled' => 'Включить почтовый индекс',
            'zip_code_enabled_helper' => 'Включить или отключить поле почтового индекса в форме адреса доставки.',
            'billing_address_enabled' => 'Включить адрес для выставления счета',
            'billing_address_enabled_helper' => 'Разрешить клиентам вводить отдельный адрес для выставления счета, отличающийся от их адреса доставки.',
            'display_tax_fields_at_checkout_page' => 'Отображать поля налоговой информации на странице оформления заказа',
            'display_tax_fields_at_checkout_page_helper' => 'Если включено, поля налоговой информации будут отображаться для ввода налоговых данных компании для получения счета.',
            'use_city_field_as_field_text' => 'Использовать поле города как поле свободного текста',
            'available_countries' => 'Доступные страны',
            'all' => 'Все',
            'all_helper_text' => 'Если вы снимите отметку со всех стран, это будет применяться ко всем странам.',
            'enable_guest_checkout' => 'Включить гостевое оформление заказа',
            'enable_guest_checkout_helper' => 'Если включено, клиенты могут размещать заказ без создания аккаунта.',
            'recently_viewed' => [
                'enable' => 'Включить недавно просмотренные товары клиентом',
                'enable_helper' => 'Отслеживать и отображать товары, которые клиенты недавно просматривали. Это помогает клиентам легко находить товары, которые их интересовали.',
                'max' => 'Максимальное количество недавно просмотренных товаров клиентом',
                'max_helper_text' => 'Если установлено в 0, ограничений не будет.',
            ],
            'minimum_order_quantity' => 'Минимальное количество для заказа',
            'minimum_order_quantity_helper' => 'Минимальное количество для размещения заказа. Оставьте 0, если не хотите устанавливать это.',
            'maximum_order_quantity' => 'Максимальное количество для заказа',
            'maximum_order_quantity_helper' => 'Максимальное количество для размещения заказа. Оставьте 0, если не хотите устанавливать это.',
            'default_country_at_checkout_page' => 'Страна по умолчанию на странице оформления заказа',
            'default_country_at_checkout_page_placeholder' => 'Выберите страну',
            'default_country_at_checkout_page_help' => 'Если вы выберете страну, она будет выбрана по умолчанию на странице оформления заказа.',
            'checkout_product_quantity_editable' => 'Разрешить клиентам изменять количество товара на странице оформления заказа',
            'checkout_product_quantity_editable_helper' => 'Когда включено, клиенты могут изменять количество товаров прямо на странице оформления заказа без возврата в корзину.',
            'show_terms_and_policy_checkbox' => 'Показывать флажок условий и политики',
            'show_terms_and_policy_checkbox_helper' => 'Если включено, клиенты должны согласиться с условиями и политикой перед размещением заказа. Пожалуйста, сначала настройте URL условий и политики конфиденциальности в Внешний вид -> Опции темы.',
            'terms_and_policy_checkbox_checked_by_default' => 'Флажок условий и политики отмечен по умолчанию',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Если включено, флажок условий и политики будет предварительно отмечен при загрузке формы оформления заказа.',
            'checkout_acceptance_message_enabled' => 'Показывать сообщение о принятии при оформлении заказа',
            'checkout_acceptance_message_enabled_helper' => 'Отображать информационное сообщение, которое информирует клиентов об условиях, с которыми они соглашаются, размещая заказ.',
            'hide_customer_info_at_checkout' => 'Скрыть информацию о клиенте при оформлении заказа',
            'hide_customer_info_at_checkout_helper' => 'Скрыть информацию об аккаунте клиента и кнопку выхода со страницы оформления заказа. Когда включено, вошедшие в систему клиенты не увидят отображаемые детали своего аккаунта.',
        ],
    ],
    'return' => [
        'name' => 'Возврат',
        'description' => 'Настройка правил для настроек возврата',
        'panel_description' => 'Возвраты заказов, частичные возвраты и сроки возврата',
        'form' => [
            'is_enabled_order_return' => 'Включен возврат заказа',
            'allow_partial_return' => 'Разрешить частичный возврат',
            'allow_partial_return_description' => 'Клиент может вернуть несколько товаров, не нужно возвращать все товары в заказе.',
            'returnable_days' => 'Дни для возврата',
            'return_settings_helper' => 'Количество дней, в течение которых клиент может запросить возврат после завершения заказа.',
        ],
    ],
    'invoice' => [
        'name' => 'Счета',
        'description' => 'Данные компании на счетах, нумерация счетов, шрифты PDF и настройки печати',
        'company_settings' => 'Настройка счетов',
        'company_settings_description' => 'Данные компании, нумерация, шрифты PDF и штамп оплаты',
        'form' => [
            'company_name' => 'Название компании',
            'company_name_helper' => 'Название вашей компании или бизнеса, которое будет отображаться на всех счетах, отправляемых клиентам.',
            'company_name_placeholder' => 'ООО \"Акме\"',
            'company_address' => 'Адрес компании',
            'company_address_helper' => 'Полный адрес вашей компании, включая улицу, город, область и страну. Это будет отображаться на счетах.',
            'company_address_placeholder' => 'ул. Тверская, д. 123, офис 100, Москва, 125009, Россия',
            'company_zipcode' => 'Почтовый индекс компании',
            'company_zipcode_helper' => 'Почтовый индекс адреса вашей компании.',
            'company_zipcode_placeholder' => '125009',
            'company_email' => 'Email компании',
            'company_email_helper' => 'Адрес электронной почты для деловых запросов. Клиенты могут использовать его для вопросов, связанных со счетами.',
            'company_email_placeholder' => 'invoice@company.ru',
            'company_phone' => 'Телефон компании',
            'company_phone_helper' => 'Контактный номер телефона, который будет отображаться на счетах для поддержки клиентов.',
            'company_phone_placeholder' => '+7 495 123-45-67',
            'company_logo' => 'Логотип компании',
            'company_logo_helper' => 'Логотип вашей компании, который будет отображаться в верхней части счетов. Рекомендуемый размер: 200x60 пикселей.',
            'company_tax_id' => 'Налоговый ID компании',
            'company_tax_id_helper' => 'Ваш идентификационный налоговый номер компании (ИНН, ОГРН и т.д.) для налогового соответствия.',
            'company_tax_id_placeholder' => 'ИНН: 1234567890',
            'invoice_code_prefix' => 'Префикс кода счета',
            'invoice_code_prefix_helper' => 'Префикс, добавляемый перед номерами счетов (например, \"СЧЁТ-\" создаст коды счетов как СЧЁТ-001, СЧЁТ-002).',
            'invoice_code_prefix_placeholder' => 'СЧЁТ-',
            'using_custom_font_for_invoice' => 'Использование пользовательского шрифта для счета',
            'using_custom_font_for_invoice_helper' => 'Включить для использования пользовательского шрифта Google для PDF счетов вместо шрифта по умолчанию.',
            'invoice_font_family' => 'Семейство шрифтов счета (работает только для латинских языков)',
            'invoice_font_family_helper' => 'Выберите шрифт Google для использования в PDF счетах. Работает только с латинскими наборами символов.',
            'enable_invoice_stamp' => 'Включить печать счета',
            'enable_invoice_stamp_helper' => 'Добавить штамп \"ОПЛАЧЕНО\" на счета при завершении оплаты заказа.',
            'add_language_support' => 'Добавить языковую поддержку',
            'add_language_support_helper' => 'Выберите дополнительную поддержку набора символов для нелатинских языков в PDF счетах.',
            'invoice_processing_library' => 'Библиотека обработки счетов',
            'invoice_processing_library_helper' => 'Выберите библиотеку генерации PDF. DomPDF быстрее, но имеет ограниченные функции. mPDF поддерживает больше языков и функций, но может быть медленнее.',
            'only_latin_languages' => 'Только латинские языки',
            'disable_order_invoice_until_order_confirmed' => 'Отключить счет заказа до подтверждения заказа',
            'disable_order_invoice_until_order_confirmed_helper' => 'При включении счета будут доступны только после подтверждения заказов, а не сразу после размещения.',
            'date_format' => 'Формат даты',
            'date_format_helper' => 'Выберите, как даты будут отображаться на счетах (например, \"F d, Y\" показывает \"Январь 01, 2024\").',
            'languages' => [
                'arabic' => 'Арабский',
                'bangladesh' => 'Бенгальский',
                'chinese' => 'Китайский',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Налог',
        'description' => 'Расчёт налогов, опции отображения и поля счёта при оформлении',
        'enable' => 'Включить налог?',
        'display_product_price_including_taxes' => 'Отображать цену товара включая налоги?',
        'display_tax_description' => 'Отображать налоговую информацию на цене товара?',
        'display_tax_description_help' => 'Показывать текст типа "(Включая X% НДС)" или "(Исключая X% НДС)" рядом с ценами товаров на странице детализации товара.',
        'tax_included_in_products_price' => 'Налог включен в цену товаров',
        'tax_included_in_products_price_description' => 'Налог будет включен в цену товаров',
        'tax_setting' => 'Отображение налогов и оформление',
        'tax_setting_description' => 'Настройте отображение налогов на страницах товаров и оформления заказа',
        'tax_management' => 'Управление налогами',
        'tax_management_description' => 'Просмотр и управление вашими налогами',

        'manage_taxes_info' => 'Для управления налогами и установки ставки налога по умолчанию перейдите в',
        'go_to_taxes' => 'Электронная коммерция → Налоги',        'form' => [
            'enable_tax' => 'Включить налог',
            'display_company_invoice_information_fields_at_checkout_page' => 'Отображать поля информации о счете компании на странице оформления заказа',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Если включено, поля информации о счете компании будут отображаться на странице оформления заказа. Обязательно заполнение полей информации о счете компании.',
            'default_tax_rate' => 'Налоговая ставка по умолчанию',
            'default_tax_rate_description' => 'Важно: она будет применена, если в товаре не выбран налог.',
            'select_tax' => '-- Выбрать --',
            'display_product_price_including_taxes' => 'Добавить налог к отображаемым ценам',
            'display_product_price_including_taxes_helper' => 'Автоматически добавляет налог к ценам товаров в магазине. Напр. товар за $100 с 10% налогом отображается как $110. Не требуется, если "Цена включает налог" уже включено для отдельных товаров.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Клиенты',
        'description' => 'Регистрация, проверка email, варианты входа, удаление аккаунта и поля профиля',
        'customer_setting' => 'Настройки клиентов',
        'customer_setting_description' => 'Настройка настроек клиентов',
        'form' => [
            'enable_customer_registration' => 'Включить регистрацию клиентов',
            'enable_customer_registration_helper' => 'Если отключено, клиенты не смогут регистрировать новые аккаунты. Существующие клиенты все еще могут входить в систему.',
            'verify_customer_email' => 'Подтверждать email клиента',
            'verify_customer_email_helper' => 'Когда включено, ссылка для подтверждения будет отправлена на email клиента, клиенты должны нажать на эту ссылку для подтверждения своего email перед тем, как они смогут войти в систему. Нужно настроить email в Админ -> Настройки -> Email для отправки подтверждения email.',
            'verification_expire_minutes' => 'Время истечения ссылки подтверждения',
            'verification_expire_minutes_helper' => 'Время в минутах, в течение которого ссылка подтверждения email будет действительна. По умолчанию 60 минут (1 час). Максимум 10080 минут (7 дней).',
            'login_using_phone' => 'Вход с номером телефона вместо email',
            'login_option' => 'Опция входа',
            'login_with_email' => 'Вход с email',
            'login_with_phone' => 'Вход с телефоном',
            'login_with_email_or_phone' => 'Вход с email или телефоном',
            'enabled_customer_account_deletion' => 'Включить удаление аккаунта клиента',
            'enabled_customer_account_deletion_helper' => 'Когда включено, клиенты могут удалить свой аккаунт в панели клиента → Настройки аккаунта.',
            'enabled_customer_dob_field' => 'Включить поле даты рождения клиента',
            'enabled_customer_dob_field_helper' => 'Когда включено, клиенты могут вводить свою дату рождения в панели клиента → Настройки аккаунта.',
            'enabled_phone_field_in_registration_form' => 'Включить поле телефона в форме регистрации',
            'enabled_phone_field_in_registration_form_helper' => 'Когда включено, поле телефона будет добавлено в форму регистрации.',
            'make_customer_phone_number_required' => 'Сделать номер телефона клиента обязательным',
            'make_customer_phone_number_required_helper' => 'Когда включено, клиенты должны ввести свой номер телефона при регистрации. Он всегда обязателен для клиентов, входящих в систему с номером телефона.',
            'default_avatar' => 'Аватар по умолчанию',
            'default_avatar_helper' => 'Аватар по умолчанию для клиента, когда у него нет аватара. Если вы не выберете изображение, оно будет сгенерировано с использованием вашего логотипа или первого символа имени клиента.',
            'keep_email_field_in_registration_form' => 'Сохранить поле email в форме регистрации',
            'keep_email_field_in_registration_form_helper' => 'Когда отключено, поле email будет скрыто в форме регистрации, когда опция входа "Вход с телефоном".',
        ],
    ],
    'shipping' => [
        'name' => 'Доставка',
        'description' => 'Правила доставки, поведение бесплатной доставки и порядок отображения вариантов доставки',
        'shipping_rule' => 'Правила доставки',
        'shipping_rule_description' => 'Настройка правил для расчета стоимости доставки',
        'shipping_setting' => 'Настройки доставки',
        'shipping_setting_description' => 'Настройка настроек доставки',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Скрыть другие варианты доставки, если в списке есть бесплатная доставка',
            'disable_shipping_options' => 'Отключить варианты доставки',
            'disable_shipping_options_helper' => 'Варианты доставки будут удалены на странице оформления заказа, клиент не сможет выбирать варианты доставки.',
            'sort_shipping_options_direction' => 'Направление сортировки вариантов доставки',
            'sort_shipping_options_direction_helper' => 'Сортировать варианты доставки по цене от меньшей к большей или от большей к меньшей.',
            'price_lower_to_higher' => 'Цена от меньшей к большей',
            'price_higher_to_lower' => 'Цена от большей к меньшей',
        ],
    ],
    'webhook' => [
        'name' => 'Вебхуки',
        'description' => 'Отправка событий заказов во внешние сервисы через HTTP',
        'webhook_setting' => 'Вебхуки событий заказов',
        'webhook_setting_description' => 'Настройте URL для получения уведомлений при создании, обновлении или отправке заказов',
        'form' => [
            'order_placed_webhook_url' => 'URL веб-хука размещения заказа (метод: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Для получения уведомлений при размещении заказа вы можете настроить внешний URL веб-хука. Если у вас есть внешний URL веб-хука, вы можете ввести этот URL или просто оставить его пустым.',
            'order_updated_webhook_url' => 'URL веб-хука обновления заказа (метод: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Для получения уведомлений при обновлении заказа вы можете настроить внешний URL веб-хука. Это включает изменения статуса, обновления адреса и другие модификации заказа.',
            'shipping_status_updated_webhook_url' => 'URL веб-хука обновления статуса доставки (метод: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Для получения уведомлений при изменении статуса доставки (например, отправлен, доставлен, отменен) вы можете настроить внешний URL веб-хука.',
            'order_completed_webhook_url' => 'URL веб-хука завершения заказа (метод: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Для получения уведомлений при завершении заказа вы можете настроить внешний URL веб-хука.',
            'order_cancelled_webhook_url' => 'URL веб-хука отмены заказа (метод: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Для получения уведомлений при отмене заказа вы можете настроить внешний URL веб-хука.',
            'payment_status_updated_webhook_url' => 'URL веб-хука обновления статуса платежа (метод: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Для получения уведомлений при изменении статуса платежа (например, оплачен, неудачен, возвращен) вы можете настроить внешний URL веб-хука.',
            'abandoned_cart_webhook_url' => 'URL веб-хука заброшенной корзины (метод: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Для получения уведомлений о заброшенных корзинах и последующего контакта с клиентами вы можете настроить внешний URL веб-хука. Уведомления отправляются через настраиваемый период времени.',
        ],
        'test_button' => 'Тестировать веб-хук',
        'test_success' => 'Тест веб-хука успешен! Конечная точка ответила правильно.',
        'test_failed' => 'Тест веб-хука неудачен. Конечная точка не ответила как ожидалось.',
        'test_error' => 'Ошибка теста веб-хука: :error',
        'please_enter_url' => 'Пожалуйста, сначала введите URL веб-хука',
        'testing' => 'Тестирование...',
        'test_failed_title' => 'Тест неудачен!',
        'test_success_title' => 'Тест успешен!',
        'status_code' => 'Код статуса',
        'error_occurred' => 'Произошла ошибка при тестировании веб-хука',
    ],
    'store_locator' => [
        'name' => 'Локаторы магазинов',
        'description' => 'Просмотр и обновление списков ваших сетей',
        'store_locator_description' => 'Все списки ваших сетей, основных магазинов, филиалов и т.д. Местоположения могут использоваться для отслеживания продаж и помощи в настройке налоговых ставок при продаже товаров.',
        'form' => [
            'change_primary_store' => 'изменить локатор магазина по умолчанию',
            'add_location' => 'Добавить местоположение',
            'edit_location' => 'Редактировать местоположение',
            'delete_location' => 'Удалить местоположение',
            'delete_location_confirmation' => 'Вы уверены, что хотите удалить это местоположение? Это действие нельзя отменить.',
            'change_primary_location' => 'Изменить основное местоположение',
            'save_location' => 'Сохранить местоположение',
            'add_new' => 'Добавить новое',
        ],
            'info' => [
            'title' => 'Как работают локаторы магазинов',
            'primary_store' => 'Адрес основного магазина отображается в счетах и используется как адрес возврата по умолчанию для транспортных этикеток.',
            'shipping_location' => 'Магазины, помеченные как "место отправки", могут быть выбраны в качестве склада отправления при создании отправлений.',
            'shipment_selection' => 'При обработке заказов вы можете выбрать, с какого склада отправлять, в зависимости от запасов и местоположения клиента.',
        ],
    ],
    'tracking' => [
        'name' => 'Отслеживание',
        'description' => 'Facebook Pixel, события Google Tag Manager и отслеживание конверсий Google Ads',
        'manage_tracking' => 'Управление отслеживанием',
        'manage_tracking_description' => 'Управление отслеживанием: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Включить Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Перейдите на https://developers.facebook.com/docs/meta-pixel для создания Facebook Pixel. Убедитесь, что ваш пиксель активен и правильно настроен.',
            'facebook_pixel_id' => 'Facebook Pixel ID',
            'facebook_pixel_id_placeholder' => 'Пример: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Включить режим отладки Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Включить режим отладки для записи событий Facebook Pixel в консоль браузера и устранения проблем отслеживания',
            'enable_google_tag_manager_tracking_events' => 'Включить события отслеживания Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Когда включено, события электронной коммерции будут отслеживаться через Google Tag Manager. Убедитесь, что вы настроили Google Tag Manager выше.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel ID должен быть 15-16 цифр (например, 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Торговая площадка',
        'description' => 'Настройки мультивендора, комиссии, регистрация продавцов и настройка выплат',
    ],
    'standard_and_format' => [
        'name' => 'Стандарт и формат',
        'panel_description' => 'Формат кода заказа, единицы веса (кг/фунт) и единицы размера (см/дюйм)',
        'description' => 'Стандарты и форматы используются для расчета таких вещей, как цены товаров, вес доставки и время заказов.',
        'form' => [
            'change_order_format' => 'Редактировать формат кода заказа (необязательно)',
            'change_order_format_description' => 'Код заказа по умолчанию начинается с: номер. Вы можете изменить начальную или конечную строку для создания нужного вам кода заказа, например "DH-: номер" или ": номер-A"',
            'start_with' => 'Начинается с',
            'end_with' => 'Заканчивается на',
            'order_will_be_shown' => 'Ваш код заказа будет показан',
            'weight_unit' => 'Единица веса',
            'height_unit' => 'Единица длины/высоты',
            'weight_unit_gram' => 'Грамм (г)',
            'weight_unit_kilogram' => 'Килограмм (кг)',
            'weight_unit_lb' => 'Фунт (lb)',
            'weight_unit_oz' => 'Унция (oz)',
            'height_unit_cm' => 'Сантиметр (см)',
            'height_unit_m' => 'Метр (м)',
            'height_unit_inch' => 'Дюйм',
        ],
    ],
    'sale_popup' => [
        'name' => 'Всплывающее окно продаж',
        'description' => 'Легко настройте параметры всплывающего окна продаж',
    ],
    'flash_sale' => [
        'name' => 'Скидка-молния',
        'description' => 'Настройте параметры скидки-молнии для предложения ограниченных по времени промо-скидок',
        'enable' => 'Включить функциональность скидки-молнии',
        'enable_helper' => 'Когда включено, вы можете создавать и управлять скидками-молниями со специальными сниженными ценами на ограниченный период времени.',
        'show_sale_count_left' => 'Отображать трекер инвентаря',
        'show_sale_count_left_description' => 'Показывать прогресс-бар с "X продано из Y" для создания срочности и стимулирования быстрых покупок во время скидок-молний.',
    ],
    'payment_method_cod_minimum_amount' => 'Минимальная сумма заказа - :currency (необязательно)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Минимальная сумма заказа - :currency (необязательно)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Отображать банковскую информацию на странице успешного оформления заказа?',
    'invoice_templates' => 'Шаблоны счетов',

    'abandoned_cart' => [
        'name' => 'Брошенные корзины',
        'description' => 'Восстанавливайте потерянные продажи, отправляя автоматические напоминания клиентам, оставившим товары в корзине',
        'panel_description' => 'Настройте автоматические напоминания для клиентов, бросивших корзину',
        'how_it_works' => [
            'title' => 'Как это работает',
            'step1_title' => 'Клиент добавляет товары',
            'step1_description' => 'Клиент добавляет товары в корзину и указывает email.',
            'step2_title' => 'Корзина становится брошенной',
            'step2_description' => 'Если покупка не совершена в течение установленного времени, корзина помечается как брошенная.',
            'step3_title' => 'Отправлено напоминание',
            'step3_description' => 'Автоматические напоминания отправляются для поощрения клиента завершить покупку.',
            'step4_title' => 'Продажа восстановлена',
            'step4_description' => 'Клиент возвращается для завершения заказа, корзина помечается как восстановленная.',
        ],
        'form' => [
            'enable' => 'Включить отслеживание брошенных корзин',
            'enable_helper' => 'При включении система будет отслеживать брошенные корзины и позволит отправлять письма восстановления клиентам.',
            'timing_section' => 'Настройки времени',
            'email_section' => 'Настройки email-напоминаний',
            'cleanup_section' => 'Очистка данных',
            'time_threshold' => 'Порог времени (часы)',
            'time_threshold_helper' => 'Корзина считается брошенной после указанного количества часов неактивности. Рекомендуется: 1-24 часа.',
            'send_email' => 'Отправлять письма восстановления',
            'send_email_helper' => 'Автоматически отправлять письма восстановления клиентам с брошенными корзинами.',
            'max_reminders' => 'Количество напоминаний',
            'max_reminders_helper' => 'Сколько напоминаний отправлять на каждую брошенную корзину. Каждое письмо можно настроить в Шаблонах email.',
            'email_delay' => 'Отправить после (часов)',
            'email_discount' => 'Скидка (%)',
            'email_1_title' => 'Письмо #1 - Дружеское напоминание',
            'email_1_description' => 'Первое мягкое напоминание для поощрения возврата клиента.',
            'email_1_delay_helper' => 'Часов после оставления корзины для отправки первого письма. Рекомендуется: 1-2 часа.',
            'email_2_title' => 'Письмо #2 - Со стимулом',
            'email_2_description' => 'Второе напоминание с предложением скидки для мотивации покупки.',
            'email_2_delay_helper' => 'Часов после оставления корзины для отправки второго письма. Рекомендуется: 24 часа.',
            'email_2_discount_helper' => 'Процент скидки в этом письме. Установите 0 для без скидки.',
            'email_3_title' => 'Письмо #3 - Последний шанс',
            'email_3_description' => 'Финальное напоминание со срочностью и лучшим предложением для закрытия продажи.',
            'email_3_delay_helper' => 'Часов после оставления корзины для отправки последнего письма. Рекомендуется: 72 часа.',
            'email_3_discount_helper' => 'Финальное предложение скидки. Обычно выше чем письмо #2.',
            'cleanup_days' => 'Очистка после (дней)',
            'cleanup_days_helper' => 'Автоматически удалять записи брошенных корзин старше указанного количества дней.',
            'cronjob_not_setup' => '<strong>Cronjob не настроен!</strong> Напоминания о брошенных корзинах требуют правильно настроенного cronjob. <a href=":url">Настроить cronjob сейчас</a>.',
            'cronjob_not_running' => '<strong>Cronjob не работает!</strong> Cronjob, похоже, остановился. Проверьте конфигурацию сервера. <a href=":url">Посмотреть статус cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob работает правильно!</strong> Последняя активность: :time. Ваши напоминания о брошенных корзинах будут обрабатываться автоматически.',
            'email_setup_warning' => '<strong>Важно:</strong> Убедитесь, что настройки email правильно настроены в <a href=":url">Настройки → Email</a>. Отправьте тестовое письмо для проверки работы перед включением этой функции.',
        ],
    ],
];
