<?php

return [
    'name' => 'Товары',
    'description' => 'Управление физическими и цифровыми товарами с инвентаризацией, ценами и вариациями',
    'create' => 'Новый товар',
    'create_product_type' => [
        'physical' => 'Новый физический товар',
        'digital' => 'Новый цифровой товар',
    ],
    'edit' => 'Редактировать товар - :name',
    'form' => [
        'name' => 'Название',
        'name_placeholder' => 'Название товара (Максимум 120 символов)',
        'description' => 'Описание',
        'description_placeholder' => 'Краткое описание товара (Максимум 400 символов)',
        'categories' => 'Категории',
        'content' => 'Содержание',
        'price' => 'Цена',
        'currency' => 'Валюта',
        'currency_for_variations_hint' => 'Эта валюта будет применена ко всем вариациям этого товара.',
        'quantity' => 'Количество',
        'brand' => 'Бренд',
        'width' => 'Ширина',
        'height' => 'Высота',
        'weight' => 'Вес',
        'date' => [
            'start' => 'С даты',
            'end' => 'До даты',
        ],
        'image' => 'Изображения',
        'collections' => 'Коллекции товаров',
        'labels' => 'Метки',
        'price_sale' => 'Цена со скидкой',
        'product_type' => [
            'title' => 'Тип товара',
        ],
        'product' => 'Товар',
        'total' => 'Итого',
        'sub_total' => 'Промежуточный итог',
        'shipping_fee' => 'Стоимость доставки',
        'discount' => 'Скидка',
        'options' => 'Опции',
        'shipping' => [
            'height' => 'Высота',
            'length' => 'Длина',
            'title' => 'Доставка',
            'weight' => 'Вес',
            'wide' => 'Ширина',
        ],
        'barcode' => 'Штрих-код (ISBN, UPC, GTIN и т.д.) ',
        'barcode_placeholder' => 'Введите штрих-код',
        'cost_per_item' => 'Себестоимость единицы',
        'cost_per_item_placeholder' => 'Введите себестоимость единицы',
        'cost_per_item_helper' => 'Покупатели не увидят эту цену.',
        'price_includes_tax' => 'Цена включает налог',
        'price_includes_tax_helper' => 'Установите этот флажок, если введенная цена уже включает налоги. Система рассчитает базовую цену путем вычета суммы налога.',
        'stock' => [
            'allow_order_when_out' => 'Разрешить оформление заказа, когда товар отсутствует на складе',
            'in_stock' => 'В наличии',
            'out_stock' => 'Нет в наличии',
            'title' => 'Статус наличия',
        ],
        'storehouse' => [
            'no_storehouse' => 'Без управления складом',
            'storehouse' => 'С управлением складом',
            'title' => 'Склад',
            'quantity' => 'Количество',
        ],
        'tax' => 'Налог',
        'taxes' => 'Налоги',
        'taxes_helper' => 'Ставка налога по умолчанию настраивается в <a href=":url">Настройки -> Налоги</a>. Если для этого товара не выбран конкретный налог, будет применена ставка по умолчанию. Чтобы отключить налог для этого товара, удалите ставку налога по умолчанию из налоговых настроек.',
        'is_default' => 'По умолчанию',
        'action' => 'Действие',
        'restock_quantity' => 'Количество пополнения',
        'remain' => 'Остаток',
        'choose_discount_period' => 'Выберите период скидки',
        'cancel' => 'Отмена',
        'no_results' => 'Результатов не найдено!',
        'value' => 'Значение',
        'attribute_name' => 'Название атрибута',
        'add_more_attribute' => 'Добавить еще атрибут',
        'continue' => 'Продолжить',
        'add_new_attributes' => 'Добавить новые атрибуты',
        'add_new_attributes_description' => 'Добавление новых атрибутов помогает товару иметь множество опций, таких как размер или цвет.',
        'create_product_variations' => ':link для создания вариаций товара!',
        'tags' => 'Теги',
        'write_some_tags' => 'Напишите несколько тегов',
        'variation_existed' => 'Эта вариация уже существует.',
        'no_attributes_selected' => 'Атрибуты не выбраны!',
        'added_variation_success' => 'Вариация успешно добавлена!',
        'updated_variation_success' => 'Вариация успешно обновлена!',
        'created_all_variation_success' => 'Все вариации успешно созданы!',
        'updated_product_attributes_success' => 'Атрибуты товара успешно обновлены!',
        'stock_status' => 'Статус наличия',
        'auto_generate_sku' => 'Автоматически генерировать SKU?',
        'featured_image' => 'Главное изображение (необязательно)',
        'product_id' => 'ID товара',
        'price_sale_percent_helper' => 'Скидка :percent от первоначальной цены.',
        'minimum_order_quantity' => 'Минимальное количество для заказа',
        'minimum_order_quantity_helper' => 'Минимальное количество для размещения заказа, если значение 0, ограничений нет.',
        'maximum_order_quantity' => 'Максимальное количество для заказа',
        'maximum_order_quantity_helper' => 'Максимальное количество для размещения заказа, если значение 0, ограничений нет.',
        'video' => 'Видео',
        'video_file' => 'Файл',
        'video_url' => 'Или URL внешнего видео',
        'video_url_help' => 'Введите URL видео YouTube или Vimeo',
        'enter_video_url' => 'Введите URL видео',
        'video_thumbnail' => 'Миниатюра видео',
        'video_thumbnail_help' => 'Выберите миниатюру для видео. Если не выбрана, она будет автоматически получена из URL видео, если доступна.',
        'barcode_existed' => 'Этот штрих-код уже используется другим товаром. Пожалуйста, введите другой штрих-код.',
        'barcode_helper' => 'Должен быть уникальным для каждого товара.',
        'is_new_until' => 'Новинка до',
        'is_new_until_helper' => 'Установите дату, до которой этот товар будет отмечен как "Новинка". Оставьте пустым, чтобы не отмечать как новинку на основе даты.',
    ],
    'price' => 'Цена',
    'quantity' => 'Количество',
    'type' => 'Тип',
    'image' => 'Миниатюра',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU вариации',
    'brand' => 'Бренд',
    'cannot_delete' => 'Товар не может быть удален',
    'product_deleted' => 'Товар удален',
    'product' => 'Товар',
    'product_collections' => 'Коллекции товаров',
    'products' => 'Товары',
    'total_products_found' => 'Найдено товаров: :total',
    'total_product_found' => 'Найден товар: :total',
    'menu' => 'Товары',
    'control' => [
        'button_add_image' => 'Добавить изображение',
    ],
    'price_sale' => 'Цена со скидкой',
    'price_group_title' => 'Управление ценой товара',
    'store_house_group_title' => 'Управление складом',
    'shipping_group_title' => 'Управление доставкой',
    'overview' => 'Обзор',
    'attributes' => 'Атрибуты',
    'product_has_variations' => 'Товар имеет вариации',
    'manage_products' => 'Управление товарами',
    'add_new_product' => 'Добавить новый товар',
    'start_by_adding_new_product' => 'Начните с добавления новых товаров.',
    'edit_this_product' => 'Редактировать этот товар',
    'delete' => 'Удалить',
    'related_products' => 'Сопутствующие товары',
    'cross_selling_products' => 'Товары для перекрестных продаж',
    'up_selling_products' => 'Товары для дополнительных продаж',
    'grouped_products' => 'Группированные товары',
    'search_products' => 'Поиск товаров',
    'selected_products' => 'Выбранные товары',
    'edit_variation_item' => 'Редактировать',
    'variations_box_description' => 'Нажмите "Редактировать атрибут", чтобы добавить/удалить атрибуты вариации, или нажмите "Добавить новую вариацию", чтобы добавить вариацию.',
    'save_changes' => 'Сохранить изменения',
    'continue' => 'Продолжить',
    'edit_attribute' => 'Редактировать атрибут',
    'select_attribute' => 'Выбрать атрибут',
    'add_new_variation' => 'Добавить новую вариацию',
    'edit_variation' => 'Редактировать вариацию',
    'generate_variations' => 'Генерировать вариации',
    'generate_variations_confirmation' => 'Вы уверены, что хотите сгенерировать вариации для этого товара?',
    'delete_variation' => 'Удалить вариацию?',
    'delete_variation_confirmation' => 'Вы уверены, что хотите удалить эту вариацию? Это действие невозможно отменить.',
    'delete_variations_confirmation' => 'Вы уверены, что хотите удалить эти вариации? Это действие невозможно отменить.',
    'product_create_validate_name_required' => 'Пожалуйста, введите название товара',
    'product_create_validate_sale_price_max' => 'Скидка должна быть меньше первоначальной цены',
    'product_create_validate_cost_per_item_max' => 'Себестоимость единицы должна быть меньше первоначальной цены',
    'product_create_validate_sale_price_required_if' => 'Необходимо ввести скидку, если вы хотите запланировать акцию',
    'product_create_validate_end_date_after' => 'Дата окончания должна быть после даты начала',
    'product_create_validate_start_date_required_if' => 'Дата начала скидки не может быть пустой, если выбрано планирование',
    'product_create_validate_sale_price' => 'Скидка не может быть пустой, если выбрано планирование',
    'stock_statuses' => [
        'in_stock' => 'В наличии',
        'out_of_stock' => 'Нет в наличии',
        'on_backorder' => 'В ожидании поставки',
    ],
    'stock_status' => 'Статус наличия',
    'processing' => 'Обработка...',
    'delete_selected_variations' => 'Удалить выбранные вариации',
    'delete_variations' => 'Удалить вариации',
    'category' => 'Категория',
    'categories' => 'Категории',
    'tags' => 'Теги',
    'product_price_flash_sale_warning' => 'Этот товар участвует в флеш-распродаже <strong>:name</strong>, поэтому его цена составляет <strong>:price</strong>.',
    'product_price_discount_warning' => 'На этот товар действует скидка <strong>:name</strong>, поэтому его цена составляет <strong>:price</strong>.',
    'product_image' => 'Изображение товара',
    'product_name' => 'Название товара',
    'product_link' => 'Ссылка на товар',
    'types' => [
        'physical' => 'Физический',
        'digital' => 'Цифровой',
    ],
    'digital_attachments' => [
        'title' => 'Цифровые вложения',
        'add' => 'Добавить вложение',
        'file_name' => 'Имя файла',
        'file_size' => 'Размер файла',
        'unsaved' => 'Не сохранено',
        'add_external_link' => 'Добавить внешнюю ссылку',
        'enter_file_name' => 'Введите имя файла',
        'enter_external_link_download' => 'Введите внешнюю ссылку для скачивания',
        'enter_file_size' => 'Введите размер файла',
        'external_link_download' => 'Внешняя ссылка для скачивания',
        'generate_license_code_after_purchasing_product' => 'Включить назначение лицензионного кода для этого товара',
        'notify_attachment_updated' => 'Отправить электронное письмо клиенту при обновлении вложения',
        'no_attachments' => 'Вложений пока нет. Нажмите кнопки выше, чтобы добавить файлы.',
    ],
    'license_codes' => [
        'title' => 'Лицензионные коды',
        'add' => 'Добавить лицензионный код',
        'back' => 'Вернуться к товару',
        'edit' => 'Редактировать лицензионный код',
        'generate' => 'Сгенерировать коды',
        'manage_codes' => 'Управление лицензионными кодами',
        'management' => 'Управление лицензионными кодами',
        'variation_breadcrumb' => 'Вариация: :name',
        'variation_label' => 'Вариация товара',
        'variation_specific_note' => 'Эти лицензионные коды относятся к этой вариации товара. Покупатели, которые приобретут эту вариацию, получат коды из этого пула.',
        'main_product_note' => 'У этого товара есть вариации. Каждая вариация может иметь свои собственные лицензионные коды, или покупатели могут получать коды из этого основного пула товаров, если у вариации нет кодов.',
        'code' => 'Лицензионный код',
        'codes' => 'Лицензионные коды',
        'status' => 'Статус',
        'assigned_at' => 'Назначено',
        'status_available' => 'Доступен',
        'status_used' => 'Использован',
        'statuses' => [
            'available' => 'Доступен',
            'used' => 'Использован',
        ],
        'no_codes' => 'Лицензионные коды не найдены. Добавьте коды или сгенерируйте их автоматически.',
        'no_codes_warning_title' => 'Нет доступных лицензионных кодов!',
        'no_codes_warning_message' => 'Для этого товара установлено "Выбрать из списка", но доступных лицензионных кодов нет. Покупатели, которые приобретут этот товар, получат автоматически сгенерированные коды. Пожалуйста, добавьте лицензионные коды для обеспечения правильной функциональности.',
        'no_codes_auto_generate' => 'Для этого товара установлена автоматическая генерация лицензионных кодов. Ручное добавление кодов не требуется.',
        'used_code_no_actions' => 'Использованный код - действия недоступны',
        'created_successfully' => 'Лицензионный код успешно создан!',
        'updated_successfully' => 'Лицензионный код успешно обновлен!',
        'deleted_successfully' => 'Лицензионный код успешно удален!',
        'generated_successfully' => 'Успешно сгенерировано лицензионных кодов: :count!',
        'duplicates_skipped' => 'Пропущено дубликатов кодов: :count.',
        'generation_incomplete' => 'Предупреждение: Удалось сгенерировать только :generated из :requested запрошенных кодов из-за конфликтов дубликатов.',
        'cannot_edit_used_code' => 'Невозможно редактировать использованный лицензионный код.',
        'cannot_delete_used_code' => 'Невозможно удалить использованный лицензионный код.',
        'show_all' => 'Показать все',
        'show_less' => 'Показать меньше',
        'more' => 'еще',
        'used_codes_hidden' => ':count использованных лицензионных кодов скрыто. Вы можете просмотреть все коды на странице управления лицензионными кодами.',
        'low_stock_title' => 'Низкий запас лицензионных кодов',
        'low_stock_message' => 'Осталось только :count лицензионных кодов. Рассмотрите возможность добавления дополнительных кодов, чтобы избежать их исчерпания.',
        'out_of_stock_title' => 'Лицензионные коды закончились!',
        'out_of_stock_message' => 'Доступных лицензионных кодов нет. Покупатели будут получать автоматически сгенерированные коды, пока вы не добавите новые.',
        'type' => [
            'title' => 'Метод назначения лицензионного кода',
            'auto_generate' => 'Автогенерация (Система генерирует коды автоматически)',
            'pick_from_list' => 'Выбрать из списка (Использовать предварительно введенные коды)',
            'description' => 'Выберите, как должны назначаться лицензионные коды покупателям при покупке этого товара.',
        ],
        'add_modal' => [
            'placeholder' => 'например, XXXX-XXXX-XXXX-XXXX',
            'help' => 'Введите уникальный лицензионный код, который будет назначен покупателю при покупке.',
        ],
        'generate_modal' => [
            'title' => 'Сгенерировать лицензионные коды',
            'quantity' => 'Количество',
            'format' => 'Формат',
            'custom_pattern' => 'Пользовательский шаблон',
            'pattern_help' => 'Используйте # для цифр, A для заглавных букв, a для строчных букв',
            'generate' => 'Сгенерировать',
        ],
        'errors' => [
            'feature_not_enabled' => 'Функция лицензионных кодов не включена. Пожалуйста, включите ее в Настройки электронной коммерции -> Цифровые товары.',
            'digital_products_not_enabled' => 'Цифровые товары не включены. Пожалуйста, сначала включите поддержку цифровых товаров.',
            'product_not_found' => 'Товар не найден.',
            'not_digital_product' => 'Лицензионные коды доступны только для цифровых товаров. Этот товар установлен как физический товар.',
            'license_codes_not_enabled_for_product' => 'Управление лицензионными кодами не включено для этого товара. Пожалуйста, включите "Генерировать лицензионный код после покупки товара" в настройках товара.',
            'cannot_add_codes_auto_generate' => 'Невозможно вручную добавлять лицензионные коды к товарам с автогенерацией. Сначала измените тип лицензионного кода на "Выбрать из списка".',
            'cannot_generate_codes_auto_generate' => 'Невозможно вручную генерировать лицензионные коды для товаров с автогенерацией. Сначала измените тип лицензионного кода на "Выбрать из списка".',
        ],
        'bulk_delete' => [
            'button' => 'Удалить выбранные',
            'selected' => 'выбрано',
            'confirm' => 'Вы уверены, что хотите удалить выбранные лицензионные коды?',
            'deleted_successfully' => 'Успешно удалено лицензионных кодов: :count.',
            'skipped_used_codes' => 'Пропущено использованных кодов: :count.',
            'no_deletable_codes' => 'Не найдено доступных лицензионных кодов для удаления. Использованные коды не могут быть удалены.',
        ],
        'import' => [
            'name' => 'Импорт лицензионных кодов товара',
            'description' => 'Импортируйте лицензионные коды для цифровых товаров из файла CSV/Excel.',
            'button' => 'Импорт',
            'columns' => [
                'product_id' => 'ID товара или SKU',
                'license_code' => 'Лицензионный код',
            ],
        ],
        'copied' => 'Лицензионный код скопирован в буфер обмена!',
    ],
    'this_action_will_reload_page' => 'Это действие перезагрузит страницу для обновления данных!',
    'select' => 'Выбрать',
    'clear_filters' => 'Очистить фильтры',
    'set_this_variant_as_default' => 'Установить этот вариант по умолчанию',
    'download' => 'Скачать',
    'external_link_downloads' => 'Внешние ссылки',
    'download_available_when_completed' => 'Ссылки для скачивания будут доступны после завершения заказа.',
    'cross_sell_price_type' => [
        'title' => 'Тип цены',
        'fixed' => 'Фиксированная',
        'percent' => 'Процент',
    ],
    'cross_sell_help' => [
        'price' => '* Поле цены',
        'price_description' => 'Введите сумму, которую вы хотите вычесть из первоначальной цены. Пример: Если первоначальная цена $100, введите 20, чтобы снизить цену до $80.',
        'type' => '* Поле типа',
        'type_description' => 'Выберите тип скидки: Фиксированная (вычесть определенную сумму) или Процент (вычесть процент).',
    ],
    'up_sell_price_type' => [
        'title' => 'Тип цены',
        'fixed' => 'Фиксированная',
        'percent' => 'Процент',
    ],
    'up_sell_help' => [
        'price' => '* Поле цены',
        'price_description' => 'Введите сумму, которую вы хотите вычесть из первоначальной цены. Пример: Если первоначальная цена $100, введите 20, чтобы снизить цену до $80.',
        'type' => '* Поле типа',
        'type_description' => 'Выберите тип скидки: Фиксированная (вычесть определенную сумму) или Процент (вычесть процент).',
    ],
    'up_sale' => [
        'title' => 'Купите вместе и сэкономьте',
        'description' => 'Получите специальные скидки при покупке этих товаров вместе',
        'unlock_discount' => 'Добавьте :product в корзину, чтобы разблокировать скидку на набор',
        'multiple_options' => 'Несколько вариантов',
        'multiple_options_available' => 'Доступно несколько вариантов',
        'select' => 'Выбрать',
        'selected_items_total' => 'Итого выбранных товаров:',
        'add_selected_to_cart' => 'Добавить выбранное в корзину',
        'bundle_discount_with' => 'Скидка на набор с :product',
        'bundle_with' => 'Набор с :product',
    ],
    'cross_sale' => [
        'title' => 'Часто покупают вместе',
        'description' => 'Покупатели, которые просмотрели этот товар, также купили',
    ],
    'apply_for_all_variations' => 'Применить для всех вариаций',
    'export' => [
        'description' => 'Экспортируйте данные о товарах в файлы CSV или Excel.',
        'total_items' => 'Всего товаров',
        'total_products' => 'Всего товаров',
        'total_variations' => 'Всего вариаций',
        'advanced_options' => 'Дополнительные параметры',
        'use_chunked_export' => 'Использовать фрагментированный экспорт',
        'use_chunked_export_helper' => 'Обрабатывать данные фрагментами для эффективной работы с большими наборами данных',
        'include_variations' => 'Включить вариации товаров',
        'include_variations_helper' => 'Экспортировать вариации товаров вместе с основными товарами',
        'optimize_memory' => 'Оптимизировать использование памяти',
        'optimize_memory_helper' => 'Включить оптимизацию памяти для очень больших экспортов',
        'chunk_size' => 'Размер фрагмента',
        'chunk_size_helper' => 'Количество товаров для обработки за раз (50-5000)',
        'use_streaming' => 'Использовать потоковый экспорт',
        'use_streaming_helper' => 'Включить потоковую передачу для очень больших наборов данных (автоматически включается для >10,000 товаров)',
        'large_dataset_warning_title' => 'Обнаружен большой каталог товаров',
        'large_dataset_warning_message' => 'Ваш каталог содержит :count товаров. Из-за большого размера некоторые параметры экспорта были оптимизированы для лучшей производительности.',
        'large_dataset_specific_message' => 'Для ваших :count товаров используйте формат CSV с включенной потоковой передачей. Система теперь может эффективно обрабатывать ваш большой каталог товаров без таймаутов и проблем с памятью.',
        'format_label' => 'Формат',
        'csv_recommended' => 'CSV (Требуется)',
        'chunk_label' => 'Обработка',
        'chunk_recommended' => '300 товаров/партия',
        'time_label' => 'Ориентировочное время',
        'time_estimate' => '1-3 минуты',
        'pro_tip' => 'Совет:',
        'pro_tip_message' => 'Экспорт будет продолжаться, даже если ваш браузер показывает индикатор загрузки. После запуска загрузка начнется автоматически.',
        'large_dataset_tip_1' => 'Формат Excel был отключен - используйте формат CSV для более быстрого и надежного экспорта',
        'large_dataset_tip_2' => 'Режим потоковой передачи был автоматически включен для предотвращения таймаутов',
        'large_dataset_tip_3' => 'Процесс экспорта может занять 1-3 минуты в зависимости от вашего сервера',
        'large_dataset_recommendation' => 'Рекомендуется: используйте формат CSV с размером фрагмента 200-500 для оптимальной производительности.',
        'excel_disabled_for_large_export' => 'Формат Excel недоступен для каталогов с более чем 10,000 товаров',
        'streaming_auto_enabled' => 'Режим потоковой передачи был автоматически включен для оптимальной производительности с большими наборами данных.',
        'streaming_enabled_title' => 'Оптимизировано для большого экспорта',
        'streaming_enabled_message' => 'Режим потоковой передачи активен для обеспечения плавного экспорта без проблем с памятью.',
        'use_multi_file' => 'Использовать многофайловый экспорт',
        'use_multi_file_helper' => 'Разделить экспорт на несколько файлов, упакованных в ZIP, для очень больших наборов данных',
        'multi_file_enabled_title' => 'Многофайловый экспорт включен',
        'multi_file_enabled_message' => 'Ваш экспорт будет разделен на :count файлов, упакованных в ZIP для оптимальной производительности.',
        'records_per_file' => 'Записей на файл',
        'records_per_file_helper' => 'Количество записей в каждом файле при использовании многофайлового экспорта',
        'estimated_files' => 'Ориентировочное количество файлов',
        'recommended_range' => 'Рекомендуемый диапазон',
        'range_large_export' => '200-500 товаров',
        'range_medium_export' => '300-800 товаров',
        'range_small_export' => '500-1000 товаров',
        'export_progress' => 'Прогресс экспорта',
        'preparing_export' => 'Подготовка экспорта...',
        'items_processed' => 'Обработано товаров: :count',
        'estimated_time_calculating' => 'Ориентировочное время: вычисляется...',
        'medium_dataset_detected' => 'Обнаружен средний набор данных',
        'medium_dataset_message' => 'Вы экспортируете :count товаров. Рассмотрите возможность использования фрагментированного экспорта для лучшей производительности.',
        'optimal_range' => 'Оптимальный диапазон',
        'too_small_slow' => 'Слишком маленький - может быть медленным',
        'too_large_timeouts' => 'Слишком большой - может вызвать таймауты',
        'excel_disabled_warning' => 'Формат Excel отключен для больших экспортов (:count товаров)',
        'starting_export' => 'Запуск экспорта...',
        'processing_data' => 'Обработка данных...',
        'finalizing_export' => 'Завершение экспорта...',
        'items_processed_suffix' => 'товаров обработано',
        'estimated_time_prefix' => 'Ориентировочное время:',
        'seconds_remaining' => 'сек осталось',
        'export_completed' => 'Экспорт завершен!',
        'download_starting' => 'Загрузка начинается...',
    ],
    'import' => [
        'description' => 'Импортируйте данные о товарах из файлов CSV или Excel.',
        'rules' => [
            'in' => ':attribute должен быть одним из определенных значений: :values.',
            'required_string_max' => ':attribute обязателен и должен быть строкой с максимальной длиной :max символов.',
            'nullable_string' => ':attribute может быть пустым или должен быть строкой, если указан.',
            'nullable_string_max' => ':attribute может быть пустым или должен быть строкой с максимальной длиной :max символов, если указан',
            'nullable_bool' => ':attribute может быть пустым или должен быть логическим значением, если указан.',
            'nullable_numeric_min' => ':attribute может быть пустым или должен быть неотрицательным числом, если указан.',
            'nullable_numeric_min_max' => ':attribute может быть пустым или должен быть числом между :min и :max, если указан.',
            'nullable_array' => ':attribute может быть пустым или должен быть предоставлен как массив, если указан.',
            'nullable_date_required_if' => ':attribute может быть пустым или должен быть действительной датой, если указан, обязателен, если указан :required.',
            'nullable_date_after' => ':attribute может быть пустым или должен быть действительной датой после :after, если указан.',
        ],
        'updated_message' => 'Успешно обновлено товаров: :count!',
    ],
    'import_products_intro' => 'Или импортируйте товары из CSV/Excel',
    'select_attributes' => 'Выберите атрибуты для создания вариаций:',
    'all' => 'Все',
    'copy' => 'Копировать',
    'product_translations' => 'Переводы товара',
    'view' => 'Просмотр товара - :name',
    'product_information' => 'Информация о товаре',
    'total_views' => 'Всего просмотров',
    'total_orders' => 'Завершенные заказы',
    'total_sold' => 'Всего продано',
    'total_revenue' => 'Общая выручка',
    'pending_orders' => 'Заказы в ожидании',
    'pending_revenue' => 'Выручка в ожидании',
    'conversion_rate' => 'Коэффициент конверсии',
    'total_reviews' => 'Всего отзывов',
    'average_rating' => 'Средний рейтинг',
    'views_by_date' => 'Просмотры по датам (Последние 30 дней)',
    'recent_orders' => 'Недавние заказы',
    'no_views_data' => 'Данные о просмотрах за последние 30 дней отсутствуют.',
    'no_orders' => 'Заказов пока нет.',
    'date' => 'Дата',
    'views' => 'Просмотры',
    'total' => 'Итого',
    'view_on_frontend' => 'Просмотреть на сайте',
    'select_attribute' => 'Выбрать :name',
    'all_categories' => 'Все категории',
    'brands' => 'Бренды',
    'browse_products' => 'Просмотр товаров',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Выберите товары для возврата',
    'show_only_discounted_products' => 'Показать только товары со скидкой',
    'specification' => 'Характеристики',
    'download_product_with_external_links' => 'Скачать товар ":name" с внешними ссылками',
    'number_product_available_singular' => 'Доступен :number товар',
    'number_products_available_plural' => 'Доступно товаров: :number',
    'cart' => [
        'added_to_cart_success' => ':product добавлен в вашу корзину.',
        'removed_from_cart_success' => ':product удален из вашей корзины.',
        'updated_cart_success' => 'Ваша корзина обновлена.',
        'item_not_found' => 'Этот товар больше не в вашей корзине.',
        'out_of_stock' => 'Извините, :product в настоящее время отсутствует на складе.',
        'max_quantity' => 'Вы можете добавить только до :max товаров.',
        'max_quantity_detail' => 'Извините, вы можете заказать только до :quantity единиц :product за раз.',
        'select_options' => 'Пожалуйста, выберите опции товара перед добавлением в корзину.',
        'product_out_of_stock' => 'Извините, этот товар в настоящее время отсутствует на складе.',
        'product_not_exists' => 'Этот товар отсутствует на складе или больше не существует.',
        'not_enough_quantity' => 'Некоторых товаров недостаточно на складе для обновления.',
        'empty_success' => 'Ваша корзина опустошена.',
        'bundle_item_already_in_cart' => 'Этот товар из набора уже в вашей корзине. Разрешен только 1 товар на скидку набора.',
    ],
    'wishlist' => [
        'added_success' => ':product добавлен в ваш список желаний.',
        'removed_success' => ':product удален из вашего списка желаний.',
        'product_not_found' => 'Этот товар не найден.',
        'product_not_in_wishlist' => 'Этот товар не в вашем списке желаний.',
        'product_not_available' => 'Этот товар недоступен.',
    ],
    'compare' => [
        'added_success' => ':product добавлен в ваш список сравнения.',
        'removed_success' => ':product удален из вашего списка сравнения.',
        'product_not_found' => 'Этот товар не найден.',
        'product_not_in_compare' => 'Этот товар не в вашем списке сравнения.',
        'already_in_list' => ':product уже в вашем списке сравнения.',
    ],
];
