<?php

return [
    'save_settings' => 'Salvar configuração',
    'ecommerce' => 'E-commerce',
    'general' => [
        'name' => 'Geral',
        'description' => 'Store name, company info, contact details, and admin notification emails',
    ],
    'currency' => [
        'name' => 'Moedas',
        'description' => 'Currency formats, exchange rates, auto-detection, and decimal/thousands separators',
        'currency_setting_description' => 'Visualizar e atualizar moedas usadas no site',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Habilitar detecção automática de moeda do visitante',
            'enable_auto_detect_visitor_currency_helper' => 'Detecta automaticamente e exibe preços na moeda local do visitante com base em sua localização. Isso proporciona uma experiência de compra mais personalizada.',
            'add_space_between_price_and_currency' => 'Adicionar um espaço entre preço e moeda',
            'add_space_between_price_and_currency_helper' => 'Quando habilitado, adiciona um espaço entre o valor do preço e o símbolo da moeda (por exemplo, "100 USD" em vez de "100USD").',
            'thousands_separator' => 'Separador de milhares',
            'thousands_separator_helper' => 'Escolha o caractere para separar milhares na exibição de preços (por exemplo, 1.000 ou 1,000 ou 1 000).',
            'decimal_separator' => 'Separador decimal',
            'decimal_separator_helper' => 'Escolha o caractere para separar valores decimais em preços (por exemplo, 10,99 ou 10.99).',
            'separator_period' => 'Ponto (.)',
            'separator_comma' => 'Vírgula (,)',
            'separator_space' => 'Espaço ( )',
            'api_key' => 'Chave da API de taxas de câmbio',
            'api_key_helper' => 'Obtenha a chave da API de taxa de câmbio em :link',
            'update_currency_rates' => 'Atualizar taxas de moeda',
            'use_exchange_rate_from_api' => 'Usar taxa de câmbio da API',
            'use_exchange_rate_from_api_helper' => 'Habilita atualizações automáticas de taxas de câmbio do provedor de API configurado. Isso garante que seus preços estejam sempre atualizados com as taxas de mercado atuais.',
            'clear_cache_rates' => 'Limpar taxas de cache',
            'auto_detect_visitor_currency_description' => 'Detecta a moeda do visitante com base no idioma do navegador. Substituirá a seleção de moeda padrão.',
            'exchange_rate' => [
                'api_provider' => 'Provedor de API',
                'select' => '-- Selecionar --',
                'none' => 'Nenhum',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'ID do App Open Exchange Rates',
            ],
            'default_currency_warning' => 'Para a moeda padrão, a taxa de câmbio deve ser 1.',
        ],
    ],
    'product' => [
        'name' => 'Produtos',
        'description' => 'Stock display, SKU generation, variation images, related products, and specifications',
        'product_settings' => 'Configurações de produtos',
        'product_settings_description' => 'Configurar regras para produtos',
        'form' => [
            'show_number_of_products' => 'Mostrar número de produtos no produto individual',
            'show_number_of_products_helper' => 'Exibir o número total de produtos na página de detalhes do produto.',
            'show_out_of_stock_products' => 'Mostrar produtos fora de estoque',
            'show_out_of_stock_products_helper' => 'Se habilitado, produtos fora de estoque serão exibidos na página de listagem de produtos.',
            'how_to_display_product_variation_images' => 'Como exibir imagens de variação de produto',
            'how_to_display_product_variation_images_helper' => 'Escolha se deseja mostrar apenas imagens específicas de variação ou incluir imagens de variação e do produto principal.',
            'only_variation_images' => 'Apenas imagens de variação',
            'variation_images_and_main_product_images' => 'Imagens de variação e imagens do produto principal',
            'enable_product_options' => 'Habilitar opções de produto',
            'enable_product_options_helper' => 'Permitir que os produtos tenham opções personalizáveis como tamanho, cor, etc.',
            'is_enabled_cross_sale_products' => 'Habilitar produtos de venda cruzada',
            'is_enabled_cross_sale_products_helper' => 'Exibir sugestões de produtos de venda cruzada para incentivar compras adicionais.',
            'is_enabled_related_products' => 'Habilitar produtos relacionados',
            'is_enabled_related_products_helper' => 'Mostrar produtos relacionados com base na categoria ou selecionados pelo administrador no formulário do produto.',
            'related_products_source' => 'Fonte de produtos relacionados',
            'related_products_source_helper' => 'Quando o administrador não seleciona produtos relacionados no formulário do produto, mostrar produtos relacionados com base nesta fonte.',
            'related_products_source_category' => 'Mesma categoria',
            'related_products_source_brand' => 'Mesma marca',
            'trending_products_period' => 'Período de produtos em alta',
            'trending_products_period_helper' => 'Selecione o período de tempo a considerar para calcular produtos em alta com base na contagem de visualizações.',
            'trending_products_period_1_day' => 'Últimas 24 horas',
            'trending_products_period_3_days' => 'Últimos 3 dias',
            'trending_products_period_7_days' => 'Últimos 7 dias (1 semana)',
            'trending_products_period_14_days' => 'Últimos 14 dias (2 semanas)',
            'trending_products_period_30_days' => 'Últimos 30 dias (1 mês)',
            'trending_products_period_60_days' => 'Últimos 60 dias (2 meses)',
            'trending_products_period_90_days' => 'Últimos 90 dias (3 meses)',
            'auto_generate_product_sku' => 'Gerar SKU automaticamente ao criar produto',
            'auto_generate_product_sku_helper' => 'Gera automaticamente SKUs únicos para novos produtos com base no formato abaixo.',
            'product_sku_format' => 'Formato do SKU',
            'product_sku_format_helper' => 'Você pode usar %s (1 caractere de string) ou %d (1 dígito) no formato para gerar string aleatória. Ex: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Habilitar especificação de produto',
            'enable_product_specification_help' => 'Se habilitado, a tabela de especificação do produto será exibida na página de detalhes do produto.',
            'make_product_barcode_required' => 'Tornar código de barras do produto obrigatório',
            'make_product_barcode_required_helper' => 'Se habilitado, o código de barras do produto será obrigatório ao criar um produto.',
        ],
    ],
    'product_search' => [
        'name' => 'Pesquisa de Produtos',
        'description' => 'Search behavior, filters by category/brand/tag/attributes, and price range filtering',
        'product_search_settings' => 'Pesquisa de produtos',
        'product_search_settings_description' => 'Configurar regras para pesquisa de produtos',
        'form' => [
            'search_for_an_exact_phrase' => 'Pesquisar por uma frase exata',
            'search_products_by' => 'Pesquisar produtos por:',
            'enable_filter_products_by_categories' => 'Habilitar filtro de produtos por categorias',
            'enable_filter_products_by_brands' => 'Habilitar filtro de produtos por marcas',
            'enable_filter_products_by_tags' => 'Habilitar filtro de produtos por tags',
            'number_of_popular_tags_for_filter' => 'Número de tags populares para filtro',
            'number_of_popular_tags_for_filter_placeholder' => 'Digite o número de tags populares a exibir',
            'number_of_popular_tags_for_filter_helper' => 'Defina o número máximo de tags populares a exibir no filtro. O padrão é 10.',
            'enable_filter_products_by_attributes' => 'Habilitar filtro de produtos por atributos',
            'enable_filter_products_by_price' => 'Habilitar filtro de produtos por preço',
            'max_product_price_for_filter' => 'Preço máximo do produto para filtro',
            'max_product_price_for_filter_placeholder' => 'Se estiver vazio ou zero, obterá o preço máximo do produto dos seus produtos existentes.',
            'max_product_price_for_filter_helper' => 'Você pode definir um preço fixo para isso ou ele obterá dinamicamente o preço máximo do produto dos seus produtos existentes. Atualmente é :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Produtos Digitais',
        'description' => 'Downloadable products, license codes, guest checkout for digital items, and auto-completion',
        'digital_products_settings' => 'Produtos digitais',
        'digital_products_settings_description' => 'Configurar regras para produtos digitais',
        'form' => [
            'enable_support_digital_product' => 'Está habilitado para suportar produtos digitais',
            'enable_support_digital_product_helper' => 'Quando habilitado, o sistema suportará a venda de produtos digitais como software, e-books, música e outros conteúdos para download.',
            'allow_guest_checkout_for_digital_products' => 'Permitir checkout de convidados para produtos digitais',
            'allow_guest_checkout_for_digital_products_helper' => 'Quando habilitado, os clientes podem comprar produtos digitais sem criar uma conta. Eles receberão links de download por e-mail.',
            'disable_physical_product' => 'Desabilitar produto físico',
            'disable_physical_product_helper' => 'Quando habilitado, a loja venderá apenas produtos digitais. As opções de produtos físicos serão ocultadas dos formulários de produtos e do checkout.',
            'enable_license_codes_for_digital_products' => 'Habilitar códigos de licença para produtos digitais',
            'auto_complete_digital_orders_after_payment' => 'Concluir automaticamente pedidos digitais após o pagamento',
            'auto_complete_digital_orders_after_payment_helper' => 'Quando habilitado, pedidos contendo apenas produtos digitais serão automaticamente marcados como concluídos assim que o pagamento for recebido.',
            'enable_license_codes_for_digital_products_helper' => 'Quando habilitado, você pode adicionar códigos de licença a produtos digitais. Quando desabilitado, a funcionalidade de código de licença será ocultada dos formulários de produtos.',
            'hide_used_license_codes_in_product_form' => 'Ocultar códigos de licença usados no formulário do produto',
            'hide_used_license_codes_in_product_form_helper' => 'Quando habilitado, os códigos de licença usados serão ocultados da tabela de códigos de licença no formulário de edição do produto. Isso ajuda a manter a interface limpa quando você tem muitos códigos usados.',
        ],
    ],
    'product_review' => [
        'name' => 'Avaliações de Produtos',
        'description' => 'Customer reviews, ratings display, image uploads, and approval requirements',
        'form' => [
            'enable_review' => 'Habilitar avaliações de produtos',
            'enable_review_help' => 'Permitir que os clientes deixem avaliações e classificações nos produtos. Quando desabilitado, todos os recursos de avaliação serão ocultados da loja.',
            'allow_customer_upload_image_in_review' => 'Permitir que os clientes enviem imagens nas avaliações',
            'allow_customer_upload_image_in_review_help' => 'Quando desabilitado, os clientes não podem fazer upload de imagens ao enviar avaliações',
            'review' => [
                'max_file_size' => 'Tamanho máximo do arquivo de avaliação (MB)',
                'max_file_number' => 'Número máximo de arquivos de avaliação',
            ],
            'only_allow_customers_purchased_to_review' => 'Apenas clientes que compraram o produto podem avaliar o produto',
            'review_need_to_be_approved' => 'A avaliação precisa ser aprovada antes de ser exibida na página do produto',
            'show_customer_full_name' => 'Mostrar nome completo do cliente',
            'show_customer_full_name_help' => 'Se estiver desmarcado, o nome do cliente que está avaliando será ocultado e substituído por asteriscos (***)',
            'hide_rating_when_no_reviews' => 'Ocultar classificação quando não houver avaliações',
            'hide_rating_when_no_reviews_help' => 'Quando habilitado, as classificações de produtos serão ocultadas nas listagens de produtos e páginas de detalhes do produto quando o produto não tiver avaliações',
            'display_uploaded_customer_review_images_list' => 'Exibir seção "Imagens de clientes"',
            'display_uploaded_customer_review_images_list_help' => 'Quando habilitado, mostra uma galeria de todas as imagens enviadas pelos clientes no topo da seção de avaliações',
        ],
    ],
    'shopping' => [
        'name' => 'Compras',
        'description' => 'Cart, wishlist, compare, order tracking, quick buy button, and payment proof uploads',
        'general_setting' => 'Configurações gerais',
        'return_settings' => 'Configurações de devolução',
        'return_settings_description' => 'Configurar regras para configurações de devolução',
        'form' => [
            'enable_cart' => 'Habilitar carrinho de compras',
            'enable_cart_helper' => 'Se desabilitado, o botão do carrinho será removido, transformando seu site em uma exibição somente de catálogo.',
            'enable_wishlist' => 'Habilitar lista de desejos',
            'enable_wishlist_helper' => 'Se desabilitado, o botão da lista de desejos será removido do site.',
            'enable_wishlist_sharing' => 'Habilitar compartilhamento de lista de desejos',
            'shared_wishlist_lifetime' => 'Tempo de vida da lista de desejos compartilhada (dias)',
            'shared_wishlist_lifetime_helper' => 'O tempo de vida da lista de desejos compartilhada em dias. Após esse tempo, a lista de desejos compartilhada será excluída.',
            'enable_compare' => 'Habilitar comparação',
            'enable_compare_helper' => 'Se desabilitado, o botão de comparação será removido do site.',
            'enable_order_tracking' => 'Habilitar rastreamento de pedidos',
            'enable_order_tracking_helper' => 'Os clientes podem rastrear seus pedidos inserindo o código do pedido e e-mail/telefone em :url',
            'order_tracking_method' => 'Método de rastreamento de pedidos',
            'order_tracking_method_helper' => 'Escolha como os clientes rastrearão seus pedidos: usando ID do Pedido + E-mail ou ID do Pedido + Número de telefone.',
            'order_tracking_method_email' => 'ID do Pedido + E-mail',
            'order_tracking_method_phone' => 'ID do Pedido + Número de telefone',
            'enable_quick_buy_button' => 'Habilitar botão de compra rápida',
            'enable_quick_buy_button_helper' => 'Mostrará um botão Comprar Agora na página de listagem e detalhes do produto. Quando os clientes clicarem neste botão, o produto será adicionado ao carrinho e redirecionado para a página do carrinho/checkout.',
            'enable_order_auto_confirmed' => 'Confirmar pedido automaticamente',
            'enable_order_auto_confirmed_helper' => 'Se habilitado, o pedido será confirmado automaticamente após o cliente fazer um pedido.',
            'quick_buy_target' => 'Página de destino da compra rápida',
            'checkout_page' => 'Página de checkout',
            'cart_page' => 'Página do carrinho',
            'cart_destroy_on_logout' => 'Destruir carrinho ao sair',
            'cart_destroy_on_logout_helper' => 'O carrinho será destruído quando o cliente sair.',
            'hide_product_price' => 'Ocultar preço do produto',
            'hide_product_price_helper' => 'Esta opção só funciona se você desabilitar o carrinho de compras, transformando seu site em uma exibição somente de catálogo. Se habilitado, o preço do produto será ocultado. É útil quando você deseja ocultar o preço e exigir que os clientes entrem em contato com você para obter o preço.',
            'hide_product_price_when_zero' => 'Ocultar preço do produto quando for zero',
            'hide_product_price_when_zero_helper' => 'Se habilitado, produtos com preço 0 não exibirão preço na loja.',
            'enable_payment_proof' => 'Habilitar upload de comprovante de pagamento',
            'enable_payment_proof_helper' => 'Permitir que os clientes façam upload do comprovante de pagamento de seus pedidos. Isso é útil para métodos de pagamento manual.',
            'enable_guest_payment_proof' => 'Permitir que clientes convidados façam upload de comprovante de pagamento',
            'enable_guest_payment_proof_helper' => 'Quando habilitado, clientes convidados podem fazer upload de comprovante de pagamento usando seu token de pedido sem fazer login. Eles receberão o link de upload em seu e-mail de confirmação de pedido.',
            'payment_proof_payment_methods' => 'Métodos de pagamento que requerem comprovante de pagamento',
            'payment_proof_payment_methods_helper' => 'Selecione quais métodos de pagamento devem permitir que os clientes enviem o comprovante de pagamento. Normalmente usado para métodos de pagamento manuais como pagamento na entrega e transferência bancária.',
        ],
    ],
    'checkout' => [
        'name' => 'Checkout',
        'panel_description' => 'Guest checkout, required fields, order limits, terms acceptance, and country restrictions',
        'description' => 'Configurar regras para configurações de checkout',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Exibir informações bancárias na página de sucesso do checkout',
            'mandatory_form_fields_at_checkout' => 'Campos obrigatórios na página de checkout:',
            'mandatory_form_fields_at_checkout_helper' => 'Selecione quais campos são obrigatórios durante o checkout. Os clientes devem preencher esses campos para concluir seu pedido.',
            'hide_form_fields_at_checkout' => 'Ocultar campos do cliente na página de checkout:',
            'hide_form_fields_at_checkout_helper' => 'Selecione quais campos devem ser ocultados na página de checkout. Esses campos não serão visíveis para os clientes.',
            'load_countries_states_cities_from_location_plugin' => 'Carregar países, estados, cidades do plugin de localização',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Após alterar esta opção, você precisa atualizar todos os endereços novamente. Você deve configurá-lo uma vez.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Então você precisa ir em Ferramentas -> Importar/Exportar Dados para importar dados de localização.',
            'minimum_order_amount' => 'Valor mínimo do pedido para fazer um pedido (:currency).',
            'minimum_order_amount_helper' => 'Defina o valor total mínimo necessário para que um pedido seja processado. Pedidos abaixo desse valor não serão aceitos.',
            'zip_code_enabled' => 'Habilitar CEP',
            'zip_code_enabled_helper' => 'Habilitar ou desabilitar o campo de CEP/código postal no formulário de endereço de envio.',
            'billing_address_enabled' => 'Habilitar endereço de cobrança',
            'billing_address_enabled_helper' => 'Permitir que os clientes insiram um endereço de cobrança separado que difere do endereço de envio.',
            'display_tax_fields_at_checkout_page' => 'Exibir campos de informações fiscais na página de checkout',
            'display_tax_fields_at_checkout_page_helper' => 'Se habilitado, os campos de informações fiscais serão exibidos para inserir detalhes fiscais da empresa para receber uma fatura.',
            'use_city_field_as_field_text' => 'Usar campo de cidade como campo de texto livre',
            'available_countries' => 'Países disponíveis',
            'all' => 'Todos',
            'all_helper_text' => 'Se você desmarcar todos os países, será aplicado para todos os países.',
            'enable_guest_checkout' => 'Habilitar checkout de convidados',
            'enable_guest_checkout_helper' => 'Se habilitado, os clientes podem fazer um pedido sem criar uma conta.',
            'recently_viewed' => [
                'enable' => 'Habilitar produtos visualizados recentemente pelo cliente',
                'enable_helper' => 'Rastrear e exibir produtos que os clientes visualizaram recentemente. Isso ajuda os clientes a encontrar facilmente produtos pelos quais estavam interessados.',
                'max' => 'Número máximo de produtos visualizados recentemente pelo cliente',
                'max_helper_text' => 'Se definido como 0, não haverá limite.',
            ],
            'minimum_order_quantity' => 'Quantidade mínima de pedido',
            'minimum_order_quantity_helper' => 'Quantidade mínima para fazer um pedido. Deixe como 0 se não quiser configurá-lo.',
            'maximum_order_quantity' => 'Quantidade máxima de pedido',
            'maximum_order_quantity_helper' => 'Quantidade máxima para fazer um pedido. Deixe como 0 se não quiser configurá-lo.',
            'default_country_at_checkout_page' => 'País padrão na página de checkout',
            'default_country_at_checkout_page_placeholder' => 'Selecione um país',
            'default_country_at_checkout_page_help' => 'Se você selecionar um país, o país será selecionado por padrão na página de checkout.',
            'checkout_product_quantity_editable' => 'Permitir que os clientes alterem a quantidade do produto na página de checkout',
            'checkout_product_quantity_editable_helper' => 'Quando habilitado, os clientes podem modificar a quantidade de produtos diretamente na página de checkout sem retornar ao carrinho.',
            'show_terms_and_policy_checkbox' => 'Mostrar caixa de seleção de termos e política',
            'show_terms_and_policy_checkbox_helper' => 'Se habilitado, os clientes devem concordar com os termos e política antes de fazer um pedido. Por favor, configure a URL de Termos e Política de Privacidade em Aparência -> Opções de tema primeiro.',
            'terms_and_policy_checkbox_checked_by_default' => 'Caixa de seleção de termos e política marcada por padrão',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Se habilitado, a caixa de seleção de termos e política será pré-marcada quando o formulário de checkout for carregado.',
            'checkout_acceptance_message_enabled' => 'Mostrar mensagem de aceitação do checkout',
            'checkout_acceptance_message_enabled_helper' => 'Exibir uma mensagem informativa que informa os clientes sobre os termos aos quais estão concordando ao fazer um pedido.',
            'hide_customer_info_at_checkout' => 'Ocultar informações do cliente no checkout',
            'hide_customer_info_at_checkout_helper' => 'Ocultar as informações da conta do cliente e o botão de logout da página de checkout. Quando habilitado, os clientes conectados não verão os detalhes de sua conta exibidos.',
        ],
    ],
    'return' => [
        'name' => 'Devolução',
        'description' => 'Configurar regras para configurações de devolução',
        'panel_description' => 'Order returns, partial returns, and return time limits',
        'form' => [
            'is_enabled_order_return' => 'Está habilitada a devolução de pedidos',
            'allow_partial_return' => 'Permitir devolução parcial',
            'allow_partial_return_description' => 'O cliente pode devolver alguns produtos, não precisa devolver todos os produtos de um pedido.',
            'returnable_days' => 'Dias para devolução',
            'return_settings_helper' => 'Número de dias que um cliente pode solicitar uma devolução após o pedido ser concluído.',
        ],
    ],
    'invoice' => [
        'name' => 'Faturas',
        'description' => 'Company details on invoices, invoice numbering, PDF fonts, and stamp settings',
        'company_settings' => 'Invoice configuration',
        'company_settings_description' => 'Company info, invoice numbering, PDF fonts, and payment stamp',
        'form' => [
            'company_name' => 'Nome da empresa',
            'company_address' => 'Endereço da empresa',
            'company_zipcode' => 'CEP da empresa',
            'company_email' => 'E-mail da empresa',
            'company_phone' => 'Telefone da empresa',
            'company_logo' => 'Logotipo da empresa',
            'company_tax_id' => 'ID fiscal da empresa',
            'invoice_code_prefix' => 'Prefixo do código da fatura',
            'using_custom_font_for_invoice' => 'Usar fonte personalizada para fatura',
            'invoice_font_family' => 'Família de fontes da fatura (Funciona apenas para idioma latino)',
            'enable_invoice_stamp' => 'Habilitar carimbo de fatura',
            'add_language_support' => 'Adicionar suporte de idioma',
            'invoice_processing_library' => 'Biblioteca de processamento de fatura',
            'only_latin_languages' => 'Apenas idiomas latinos',
            'disable_order_invoice_until_order_confirmed' => 'Desabilitar fatura do pedido até que o pedido seja confirmado',
            'date_format' => 'Formato de data',
            'languages' => [
                'arabic' => 'Árabe',
                'bangladesh' => 'Bengali',
                'chinese' => 'Chinês',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Impostos',
        'description' => 'Tax calculation, display options, and checkout invoice fields',
        'enable' => 'Habilitar impostos?',
        'display_product_price_including_taxes' => 'Exibir preço do produto incluindo impostos?',
        'display_tax_description' => 'Exibir informações fiscais no preço do produto?',
        'display_tax_description_help' => 'Mostrar texto como "(Incluindo X% GST)" ou "(Excluindo X% GST)" ao lado dos preços dos produtos na página de detalhes do produto.',
        'tax_included_in_products_price' => 'Imposto incluído no preço dos produtos',
        'tax_included_in_products_price_description' => 'O imposto será incluído no preço dos produtos',
        'tax_setting' => 'Tax display & checkout',
        'tax_setting_description' => 'Configure how taxes are displayed on products and checkout pages',
        'tax_management' => 'Gerenciamento de impostos',
        'tax_management_description' => 'Visualizar e gerenciar seus impostos',

        'manage_taxes_info' => 'Para gerenciar impostos e definir a taxa de imposto padrão, vá para',
        'go_to_taxes' => 'E-commerce → Impostos',        'form' => [
            'enable_tax' => 'Habilitar impostos',
            'display_company_invoice_information_fields_at_checkout_page' => 'Exibir campos de informações de fatura da empresa na página de checkout',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Se estiver habilitado, os campos de informações de fatura da empresa serão exibidos na página de checkout. É obrigatório preencher os campos de informações de fatura da empresa.',
            'default_tax_rate' => 'Alíquota de imposto padrão',
            'default_tax_rate_description' => 'Importante: será aplicado se nenhum imposto for selecionado no produto.',
            'select_tax' => '-- Selecionar --',
            'display_product_price_including_taxes' => 'Adicionar imposto aos preços exibidos',
            'display_product_price_including_taxes_helper' => 'Adiciona automaticamente imposto aos preços dos produtos na loja. Ex.: um produto de $100 com 10% de imposto é exibido como $110. Não é necessário se "Preço inclui imposto" já estiver ativado em produtos individuais.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Clientes',
        'description' => 'Registration, email verification, login options, account deletion, and profile fields',
        'customer_setting' => 'Configurações de clientes',
        'customer_setting_description' => 'Configurar configurações de clientes',
        'form' => [
            'enable_customer_registration' => 'Habilitar registro de clientes',
            'enable_customer_registration_helper' => 'Se desabilitado, os clientes não poderão registrar novas contas. Clientes existentes ainda podem fazer login.',
            'verify_customer_email' => 'Verificar e-mail do cliente',
            'verify_customer_email_helper' => 'Quando estiver habilitado, um link de verificação será enviado para o e-mail do cliente, os clientes precisam clicar neste link para verificar seu e-mail antes de poder fazer login. Precisa configurar o e-mail em Admin -> Configurações -> E-mail para enviar e-mail de verificação.',
            'verification_expire_minutes' => 'Tempo de expiração do link de verificação',
            'verification_expire_minutes_helper' => 'O tempo em minutos que o link de verificação de e-mail será válido. O padrão é 60 minutos (1 hora). O máximo é 10080 minutos (7 dias).',
            'login_using_phone' => 'Fazer login com número de telefone em vez de e-mail',
            'login_option' => 'Opção de login',
            'login_with_email' => 'Login com e-mail',
            'login_with_phone' => 'Login com telefone',
            'login_with_email_or_phone' => 'Login com e-mail ou telefone',
            'enabled_customer_account_deletion' => 'Habilitar exclusão de conta de cliente',
            'enabled_customer_account_deletion_helper' => 'Quando estiver habilitado, os clientes podem excluir sua conta no painel do cliente → Configurações da conta.',
            'enabled_customer_dob_field' => 'Habilitar campo de data de nascimento do cliente',
            'enabled_customer_dob_field_helper' => 'Quando estiver habilitado, os clientes podem inserir sua data de nascimento no painel do cliente → Configurações da conta.',
            'enabled_phone_field_in_registration_form' => 'Habilitar campo de telefone no formulário de registro',
            'enabled_phone_field_in_registration_form_helper' => 'Quando estiver habilitado, o campo de telefone será adicionado ao formulário de registro.',
            'make_customer_phone_number_required' => 'Tornar número de telefone do cliente obrigatório',
            'make_customer_phone_number_required_helper' => 'Quando habilitado, os clientes devem inserir seu número de telefone durante o registro. É sempre obrigatório para clientes que fazem login com número de telefone.',
            'default_avatar' => 'Avatar padrão',
            'default_avatar_helper' => 'Avatar padrão para o cliente quando ele não tem um avatar. Se você não selecionar nenhuma imagem, ela será gerada usando seu logotipo ou o primeiro caractere do nome do cliente.',
            'keep_email_field_in_registration_form' => 'Manter campo de e-mail no formulário de registro',
            'keep_email_field_in_registration_form_helper' => 'Quando estiver desabilitado, o campo de e-mail ficará oculto no formulário de registro quando a opção de login for "Login com telefone".',
        ],
    ],
    'shipping' => [
        'name' => 'Envio',
        'description' => 'Shipping rules, free shipping behavior, and shipping option display order',
        'shipping_rule' => 'Regras de envio',
        'shipping_rule_description' => 'Configurar regras para calcular taxa de envio',
        'shipping_setting' => 'Configurações de envio',
        'shipping_setting_description' => 'Configurar configurações de envio',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Ocultar outras opções de envio se houver frete grátis na lista',
            'disable_shipping_options' => 'Desabilitar opções de envio',
            'disable_shipping_options_helper' => 'As opções de envio serão removidas na página de checkout, o cliente não poderá selecionar opções de envio.',
            'sort_shipping_options_direction' => 'Ordenar direção das opções de envio',
            'sort_shipping_options_direction_helper' => 'Ordenar opções de envio por preço do menor para o maior ou do maior para o menor.',
            'price_lower_to_higher' => 'Preço do menor para o maior',
            'price_higher_to_lower' => 'Preço do maior para o menor',
        ],
    ],
    'webhook' => [
        'name' => 'Webhooks',
        'description' => 'Send order events to external services via HTTP callbacks',
        'webhook_setting' => 'Order event webhooks',
        'webhook_setting_description' => 'Configure URLs to receive notifications when orders are placed, updated, or shipped',
        'form' => [
            'order_placed_webhook_url' => 'URL do webhook de pedido feito (método: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Para receber notificações quando um pedido for feito, você pode configurar uma URL de webhook externa. Se você tiver uma URL de webhook externa, pode inserir esta URL ou deixá-la vazia.',
            'order_updated_webhook_url' => 'URL do webhook de pedido atualizado (método: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Para receber notificações quando um pedido for atualizado, você pode configurar uma URL de webhook externa. Isso inclui alterações de status, atualizações de endereço e outras modificações de pedidos.',
            'shipping_status_updated_webhook_url' => 'URL do webhook de status de envio atualizado (método: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Para receber notificações quando o status de envio mudar (por exemplo, enviado, entregue, cancelado), você pode configurar uma URL de webhook externa.',
            'order_completed_webhook_url' => 'URL do webhook de pedido concluído (método: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Para receber notificações quando um pedido for concluído, você pode configurar uma URL de webhook externa.',
            'order_cancelled_webhook_url' => 'URL do webhook de pedido cancelado (método: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Para receber notificações quando um pedido for cancelado, você pode configurar uma URL de webhook externa.',
            'payment_status_updated_webhook_url' => 'URL do webhook de status de pagamento atualizado (método: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Para receber notificações quando o status de pagamento mudar (por exemplo, pago, falhou, reembolsado), você pode configurar uma URL de webhook externa.',
            'abandoned_cart_webhook_url' => 'URL do webhook de carrinho abandonado (método: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Para receber notificações quando carrinhos forem abandonados e fazer acompanhamento com os clientes, você pode configurar uma URL de webhook externa. As notificações são enviadas após um período de tempo configurável.',
        ],
        'test_button' => 'Testar Webhook',
        'test_success' => 'Teste de webhook bem-sucedido! O endpoint respondeu corretamente.',
        'test_failed' => 'Teste de webhook falhou. O endpoint não respondeu conforme esperado.',
        'test_error' => 'Erro no teste de webhook: :error',
        'please_enter_url' => 'Por favor, insira uma URL de webhook primeiro',
        'testing' => 'Testando...',
        'test_failed_title' => 'Teste Falhou!',
        'test_success_title' => 'Teste Bem-Sucedido!',
        'status_code' => 'Código de Status',
        'error_occurred' => 'Ocorreu um erro ao testar o webhook',
    ],
    'store_locator' => [
        'name' => 'Localizadores de lojas',
        'description' => 'Visualizar e atualizar as listas de suas cadeias',
        'store_locator_description' => 'Todas as listas de suas cadeias, lojas principais, filiais, etc. As localizações podem ser usadas para rastrear vendas e nos ajudar a configurar alíquotas de impostos para cobrar ao vender produtos.',
        'form' => [
            'change_primary_store' => 'alterar localizador de loja padrão',
            'add_location' => 'Adicionar localização',
            'edit_location' => 'Editar localização',
            'delete_location' => 'Excluir localização',
            'delete_location_confirmation' => 'Tem certeza de que deseja excluir esta localização? Esta ação não pode ser desfeita.',
            'change_primary_location' => 'Alterar localização principal',
            'save_location' => 'Salvar localização',
            'add_new' => 'Adicionar novo',
        ],
            'info' => [
            'title' => 'Como funcionam os localizadores de lojas',
            'primary_store' => 'O endereço da loja principal aparece nas faturas e é usado como endereço de devolução padrão para etiquetas de envio.',
            'shipping_location' => 'As lojas marcadas como "local de envio" podem ser selecionadas como armazém de origem ao criar remessas.',
            'shipment_selection' => 'Ao processar pedidos, você pode escolher de qual armazém enviar com base no estoque e localização do cliente.',
        ],
    ],
    'tracking' => [
        'name' => 'Rastreamento',
        'description' => 'Facebook Pixel, Google Tag Manager events, and Google Ads conversion tracking',
        'manage_tracking' => 'Gerenciar rastreamento',
        'manage_tracking_description' => 'Gerenciar rastreamento: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Habilitar Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Vá para https://developers.facebook.com/docs/meta-pixel para criar Facebook Pixel. Certifique-se de que seu pixel esteja ativo e configurado corretamente.',
            'facebook_pixel_id' => 'ID do Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'Exemplo: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Habilitar Modo de Depuração do Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Habilitar modo de depuração para registrar eventos do Facebook Pixel no console do navegador e solucionar problemas de rastreamento',
            'enable_google_tag_manager_tracking_events' => 'Habilitar Eventos de Rastreamento do Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Quando habilitado, eventos de e-commerce serão rastreados através do Google Tag Manager. Certifique-se de ter configurado o Google Tag Manager acima.',
            'google_ads_conversion_id' => 'ID de Conversão do Google Ads',
            'google_ads_conversion_id_helper' => 'Digite seu ID de conversão do Google Ads (formato: AW-123456789/AbC-D_efG-h1_ijk-lmN) para rastrear conversões de compra na página de agradecimento.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'O ID do Facebook Pixel deve ter 15-16 dígitos (por exemplo, 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Marketplace',
        'description' => 'Multi-vendor settings, commissions, vendor registration, and payout configuration',
    ],
    'standard_and_format' => [
        'name' => 'Padrão e Formato',
        'panel_description' => 'Order code format, weight units (kg/lb), and dimension units (cm/inch)',
        'description' => 'Padrões e formatos são usados para calcular coisas como preços de produtos, pesos de envio e horários de pedidos.',
        'form' => [
            'change_order_format' => 'Editar formato do código do pedido (opcional)',
            'change_order_format_description' => 'O código de pedido padrão começa em: número. Você pode alterar a string inicial ou final para criar o código de pedido que deseja, por exemplo "DH-: número" ou ": número-A"',
            'start_with' => 'Começar com',
            'end_with' => 'Terminar com',
            'order_will_be_shown' => 'Seu código de pedido será exibido',
            'weight_unit' => 'Unidade de peso',
            'height_unit' => 'Unidade de comprimento / altura',
            'weight_unit_gram' => 'Grama (g)',
            'weight_unit_kilogram' => 'Quilograma (kg)',
            'weight_unit_lb' => 'Libra (lb)',
            'weight_unit_oz' => 'Onça (oz)',
            'height_unit_cm' => 'Centímetro (cm)',
            'height_unit_m' => 'Metro (m)',
            'height_unit_inch' => 'Polegada',
        ],
    ],
    'sale_popup' => [
        'name' => 'Popup de Vendas',
        'description' => 'Personalize suas configurações de popup de vendas com facilidade',
    ],
    'flash_sale' => [
        'name' => 'Oferta Relâmpago',
        'description' => 'Configure as configurações de oferta relâmpago para oferecer descontos promocionais por tempo limitado',
        'enable' => 'Habilitar funcionalidade de oferta relâmpago',
        'enable_helper' => 'Quando habilitado, você pode criar e gerenciar ofertas relâmpago com preços especiais com desconto por um período de tempo limitado.',
        'show_sale_count_left' => 'Exibir rastreador de inventário',
        'show_sale_count_left_description' => 'Mostrar uma barra de progresso com "X vendidos de Y" para criar urgência e incentivar compras rápidas durante ofertas relâmpago.',
    ],
    'payment_method_cod_minimum_amount' => 'Valor mínimo do pedido - :currency (Opcional)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Valor mínimo do pedido - :currency (Opcional)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Exibir informações bancárias na página de sucesso do checkout?',
    'invoice_templates' => 'Modelos de fatura',

    'abandoned_cart' => [
        'name' => 'Giỏ hàng bị bỏ rơi',
        'description' => 'Khôi phục doanh số bị mất bằng cách gửi lời nhắc tự động cho khách hàng để lại sản phẩm trong giỏ',
        'panel_description' => 'Thiết lập lời nhắc tự động cho khách hàng bỏ rơi giỏ hàng',
        'how_it_works' => [
            'title' => 'Cách hoạt động',
            'step1_title' => 'Khách hàng thêm sản phẩm',
            'step1_description' => 'Khách hàng thêm sản phẩm vào giỏ hàng và cung cấp địa chỉ email.',
            'step2_title' => 'Giỏ hàng bị bỏ rơi',
            'step2_description' => 'Nếu không có giao dịch mua trong ngưỡng thời gian đã đặt, giỏ hàng được đánh dấu là bị bỏ rơi.',
            'step3_title' => 'Gửi email nhắc nhở',
            'step3_description' => 'Email nhắc nhở tự động được gửi để khuyến khích khách hàng hoàn tất việc mua hàng.',
            'step4_title' => 'Khôi phục doanh số',
            'step4_description' => 'Khách hàng quay lại hoàn tất đơn hàng và giỏ hàng được đánh dấu là đã khôi phục.',
        ],
        'form' => [
            'enable' => 'Bật theo dõi giỏ hàng bị bỏ rơi',
            'enable_helper' => 'Khi được bật, hệ thống sẽ theo dõi giỏ hàng bị bỏ rơi và cho phép bạn gửi email khôi phục cho khách hàng.',
            'timing_section' => 'Cài đặt thời gian',
            'email_section' => 'Cài đặt email nhắc nhở',
            'cleanup_section' => 'Dọn dẹp dữ liệu',
            'time_threshold' => 'Ngưỡng thời gian (giờ)',
            'time_threshold_helper' => 'Giỏ hàng được coi là bị bỏ rơi sau số giờ không hoạt động này. Khuyến nghị: 1-24 giờ.',
            'send_email' => 'Gửi email khôi phục',
            'send_email_helper' => 'Tự động gửi email khôi phục cho khách hàng có giỏ hàng bị bỏ rơi.',
            'max_reminders' => 'Số lượng email nhắc nhở',
            'max_reminders_helper' => 'Số lượng email nhắc nhở gửi cho mỗi giỏ hàng bị bỏ rơi. Mỗi email có thể được tùy chỉnh trong Mẫu Email.',
            'email_delay' => 'Gửi sau (giờ)',
            'email_discount' => 'Giảm giá (%)',
            'email_1_title' => 'Email #1 - Nhắc nhở thân thiện',
            'email_1_description' => 'Lời nhắc nhẹ nhàng đầu tiên để khuyến khích khách hàng quay lại.',
            'email_1_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email đầu tiên. Khuyến nghị: 1-2 giờ.',
            'email_2_title' => 'Email #2 - Kèm ưu đãi',
            'email_2_description' => 'Lời nhắc thứ hai với ưu đãi giảm giá để thúc đẩy mua hàng.',
            'email_2_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email thứ hai. Khuyến nghị: 24 giờ.',
            'email_2_discount_helper' => 'Phần trăm giảm giá để cung cấp trong email này. Đặt 0 nếu không giảm giá.',
            'email_3_title' => 'Email #3 - Cơ hội cuối',
            'email_3_description' => 'Lời nhắc cuối cùng với tính cấp bách và ưu đãi tốt nhất để chốt đơn.',
            'email_3_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email cuối cùng. Khuyến nghị: 72 giờ.',
            'email_3_discount_helper' => 'Phần trăm giảm giá cuối cùng. Thường cao hơn email #2.',
            'cleanup_days' => 'Dọn dẹp sau (ngày)',
            'cleanup_days_helper' => 'Tự động xóa bản ghi giỏ hàng bị bỏ rơi cũ hơn số ngày này.',
            'cronjob_not_setup' => '<strong>Cronjob chưa được cấu hình!</strong> Nhắc nhở giỏ hàng bị bỏ rơi yêu cầu cronjob được cấu hình đúng để hoạt động. <a href=":url">Thiết lập cronjob ngay</a>.',
            'cronjob_not_running' => '<strong>Cronjob không chạy!</strong> Cronjob dường như đã dừng. Vui lòng kiểm tra cấu hình máy chủ của bạn. <a href=":url">Xem trạng thái cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob đang chạy đúng!</strong> Hoạt động cuối: :time. Nhắc nhở giỏ hàng bị bỏ rơi của bạn sẽ được xử lý tự động.',
            'email_setup_warning' => '<strong>Quan trọng:</strong> Đảm bảo cài đặt email của bạn được cấu hình đúng trong <a href=":url">Cài đặt → Email</a>. Gửi email test để xác minh mọi thứ hoạt động trước khi bật tính năng này.',
        ],
    ],
];
