<?php

return [
    'name' => 'Produtos',
    'description' => 'Gerir produtos físicos e digitais com inventário, preços e variações',
    'create' => 'Novo produto',
    'create_product_type' => [
        'physical' => 'Novo produto físico',
        'digital' => 'Novo produto digital',
    ],
    'edit' => 'Editar produto - :name',
    'form' => [
        'name' => 'Nome',
        'name_placeholder' => 'Nome do produto (Máximo 120 caracteres)',
        'description' => 'Descrição',
        'description_placeholder' => 'Descrição curta do produto (Máximo 400 caracteres)',
        'categories' => 'Categorias',
        'content' => 'Conteúdo',
        'price' => 'Preço',
        'currency' => 'Moeda',
        'currency_for_variations_hint' => 'Esta moeda será aplicada a todas as variações deste produto.',
        'quantity' => 'Quantidade',
        'brand' => 'Marca',
        'width' => 'Largura',
        'height' => 'Altura',
        'weight' => 'Peso',
        'date' => [
            'start' => 'Data de início',
            'end' => 'Data de fim',
        ],
        'image' => 'Imagens',
        'collections' => 'Coleções de produtos',
        'labels' => 'Etiquetas',
        'price_sale' => 'Preço de venda',
        'product_type' => [
            'title' => 'Tipo de produto',
        ],
        'product' => 'Produto',
        'total' => 'Total',
        'sub_total' => 'Subtotal',
        'shipping_fee' => 'Taxa de envio',
        'discount' => 'Desconto',
        'options' => 'Opções',
        'shipping' => [
            'height' => 'Altura',
            'length' => 'Comprimento',
            'title' => 'Envio',
            'weight' => 'Peso',
            'wide' => 'Largura',
        ],
        'barcode' => 'Código de barras (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Introduza o código de barras',
        'cost_per_item' => 'Custo por item',
        'cost_per_item_placeholder' => 'Introduza o custo por item',
        'cost_per_item_helper' => 'Os clientes não verão este preço.',
        'price_includes_tax' => 'O preço inclui imposto',
        'price_includes_tax_helper' => 'Marque esta opção se o preço introduzido já inclui impostos. O sistema calculará o preço base removendo o valor do imposto.',
        'stock' => [
            'allow_order_when_out' => 'Permitir que o cliente finalize a compra quando este produto estiver esgotado',
            'in_stock' => 'Em stock',
            'out_stock' => 'Esgotado',
            'title' => 'Estado do stock',
        ],
        'storehouse' => [
            'no_storehouse' => 'Sem gestão de armazém',
            'storehouse' => 'Com gestão de armazém',
            'title' => 'Armazém',
            'quantity' => 'Quantidade',
        ],
        'tax' => 'Imposto',
        'taxes' => 'Impostos',
        'taxes_helper' => 'A taxa de imposto predefinida está configurada em <a href=":url">Definições -> Imposto</a>. Se não for selecionado nenhum imposto específico para este produto, será aplicada a taxa predefinida. Para desativar o imposto para este produto, remova a taxa de imposto predefinida das definições de imposto.',
        'is_default' => 'É predefinido',
        'action' => 'Ação',
        'restock_quantity' => 'Quantidade de reabastecimento',
        'remain' => 'Restante',
        'choose_discount_period' => 'Escolher Período de Desconto',
        'cancel' => 'Cancelar',
        'no_results' => 'Sem resultados!',
        'value' => 'Valor',
        'attribute_name' => 'Nome do atributo',
        'add_more_attribute' => 'Adicionar mais atributos',
        'continue' => 'Continuar',
        'add_new_attributes' => 'Adicionar novos atributos',
        'add_new_attributes_description' => 'Adicionar novos atributos ajuda o produto a ter mais opções, como tamanho ou cor.',
        'create_product_variations' => ':link para criar variações de produto!',
        'tags' => 'Etiquetas',
        'write_some_tags' => 'Escreva algumas etiquetas',
        'variation_existed' => 'Esta variação já existe.',
        'no_attributes_selected' => 'Nenhum atributo selecionado!',
        'added_variation_success' => 'Variação adicionada com sucesso!',
        'updated_variation_success' => 'Variação atualizada com sucesso!',
        'created_all_variation_success' => 'Todas as variações criadas com sucesso!',
        'updated_product_attributes_success' => 'Atributos do produto atualizados com sucesso!',
        'stock_status' => 'Estado do stock',
        'auto_generate_sku' => 'Gerar SKU automaticamente?',
        'featured_image' => 'Imagem de destaque (opcional)',
        'product_id' => 'ID do Produto',
        'price_sale_percent_helper' => 'Desconto de :percent do preço original.',
        'minimum_order_quantity' => 'Quantidade mínima de encomenda',
        'minimum_order_quantity_helper' => 'Quantidade mínima para fazer uma encomenda, se o valor for 0, não há limite.',
        'maximum_order_quantity' => 'Quantidade máxima de encomenda',
        'maximum_order_quantity_helper' => 'Quantidade máxima para fazer uma encomenda, se o valor for 0, não há limite.',
        'video' => 'Vídeo',
        'video_file' => 'Ficheiro',
        'video_url' => 'Ou URL de Vídeo Externo',
        'video_url_help' => 'Introduza o URL do vídeo do YouTube ou Vimeo',
        'enter_video_url' => 'Introduza o URL do vídeo',
        'video_thumbnail' => 'Miniatura do vídeo',
        'video_thumbnail_help' => 'Escolha uma miniatura para o vídeo. Se não for selecionada, será obtida automaticamente do URL do vídeo, se disponível.',
        'barcode_existed' => 'Este código de barras está a ser usado por outro produto. Por favor, introduza outro código de barras.',
        'barcode_helper' => 'Deve ser único para cada produto.',
        'is_new_until' => 'Novo até',
        'is_new_until_helper' => 'Defina uma data até à qual este produto será marcado como "Novo". Deixe vazio para não marcar como novo com base na data.',
    ],
    'price' => 'Preço',
    'quantity' => 'Quantidade',
    'type' => 'Tipo',
    'image' => 'Miniatura',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU da Variação',
    'brand' => 'Marca',
    'cannot_delete' => 'O produto não pôde ser eliminado',
    'product_deleted' => 'Produto eliminado',
    'product' => 'Produto',
    'product_collections' => 'Coleções de produtos',
    'products' => 'Produtos',
    'total_products_found' => ':total produtos encontrados',
    'total_product_found' => ':total produto encontrado',
    'menu' => 'Produtos',
    'control' => [
        'button_add_image' => 'Adicionar imagem',
    ],
    'price_sale' => 'Preço de venda',
    'price_group_title' => 'Gerir preço do produto',
    'store_house_group_title' => 'Gerir armazém',
    'shipping_group_title' => 'Gerir envio',
    'overview' => 'Visão geral',
    'attributes' => 'Atributos',
    'product_has_variations' => 'O produto tem variações',
    'manage_products' => 'Gerir produtos',
    'add_new_product' => 'Adicionar um novo produto',
    'start_by_adding_new_product' => 'Comece por adicionar novos produtos.',
    'edit_this_product' => 'Editar este produto',
    'delete' => 'Eliminar',
    'related_products' => 'Produtos relacionados',
    'cross_selling_products' => 'Produtos de venda cruzada',
    'up_selling_products' => 'Produtos de venda adicional',
    'grouped_products' => 'Produtos agrupados',
    'search_products' => 'Pesquisar produtos',
    'selected_products' => 'Produtos selecionados',
    'edit_variation_item' => 'Editar',
    'variations_box_description' => 'Clique em "Editar atributo" para adicionar/remover atributos da variação ou clique em "Adicionar nova variação" para adicionar variação.',
    'save_changes' => 'Guardar alterações',
    'continue' => 'Continuar',
    'edit_attribute' => 'Editar atributo',
    'select_attribute' => 'Selecionar atributo',
    'add_new_variation' => 'Adicionar nova variação',
    'edit_variation' => 'Editar variação',
    'generate_variations' => 'Gerar variações',
    'generate_variations_confirmation' => 'Tem a certeza de que deseja gerar variações para este produto?',
    'delete_variation' => 'Eliminar variação?',
    'delete_variation_confirmation' => 'Tem a certeza de que deseja eliminar esta variação? Esta ação não pode ser desfeita.',
    'delete_variations_confirmation' => 'Tem a certeza de que deseja eliminar essas variações? Esta ação não pode ser desfeita.',
    'product_create_validate_name_required' => 'Por favor, introduza o nome do produto',
    'product_create_validate_sale_price_max' => 'O desconto deve ser inferior ao preço original',
    'product_create_validate_cost_per_item_max' => 'O custo por item deve ser inferior ao preço original',
    'product_create_validate_sale_price_required_if' => 'Deve introduzir um desconto quando pretende agendar uma promoção',
    'product_create_validate_end_date_after' => 'A data de fim deve ser posterior à data de início',
    'product_create_validate_start_date_required_if' => 'A data de início do desconto não pode ficar em branco quando o agendamento está selecionado',
    'product_create_validate_sale_price' => 'Os descontos não podem ficar em branco quando o agendamento está selecionado',
    'stock_statuses' => [
        'in_stock' => 'Em stock',
        'out_of_stock' => 'Esgotado',
        'on_backorder' => 'Em encomenda',
    ],
    'stock_status' => 'Estado do stock',
    'processing' => 'A processar...',
    'delete_selected_variations' => 'Eliminar variações selecionadas',
    'delete_variations' => 'Eliminar variações',
    'category' => 'Categoria',
    'categories' => 'Categorias',
    'tags' => 'Etiquetas',
    'product_price_flash_sale_warning' => 'Este produto está na promoção relâmpago <strong>:name</strong>, por isso o seu preço é <strong>:price</strong>.',
    'product_price_discount_warning' => 'Este produto está no desconto <strong>:name</strong>, por isso o seu preço é <strong>:price</strong>.',
    'product_image' => 'Imagem do produto',
    'product_name' => 'Nome do produto',
    'product_link' => 'Ligação do produto',
    'types' => [
        'physical' => 'Físico',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Anexos digitais',
        'add' => 'Adicionar Anexo',
        'file_name' => 'Nome do ficheiro',
        'file_size' => 'Tamanho do ficheiro',
        'unsaved' => 'Não guardado',
        'add_external_link' => 'Adicionar ligação externa',
        'enter_file_name' => 'Introduza o nome do ficheiro',
        'enter_external_link_download' => 'Introduza a ligação externa de transferência',
        'enter_file_size' => 'Introduza o tamanho do ficheiro',
        'external_link_download' => 'Ligação externa de transferência',
        'generate_license_code_after_purchasing_product' => 'Ativar atribuição de código de licença para este produto',
        'notify_attachment_updated' => 'Enviar um email ao cliente quando o anexo for atualizado',
        'no_attachments' => 'Ainda não há anexos. Clique nos botões acima para adicionar ficheiros.',
    ],
    'license_codes' => [
        'title' => 'Códigos de Licença',
        'add' => 'Adicionar Código de Licença',
        'back' => 'Voltar ao Produto',
        'edit' => 'Editar Código de Licença',
        'generate' => 'Gerar Códigos',
        'manage_codes' => 'Gerir Códigos de Licença',
        'management' => 'Gestão de Códigos de Licença',
        'variation_breadcrumb' => 'Variação: :name',
        'variation_label' => 'Variação do Produto',
        'variation_specific_note' => 'Estes códigos de licença são específicos para esta variação do produto. Os clientes que comprarem esta variação receberão códigos deste conjunto.',
        'main_product_note' => 'Este produto tem variações. Cada variação pode ter os seus próprios códigos de licença, ou os clientes podem receber códigos deste conjunto do produto principal se a variação não tiver códigos.',
        'code' => 'Código de Licença',
        'codes' => 'Códigos de Licença',
        'status' => 'Estado',
        'assigned_at' => 'Atribuído Em',
        'status_available' => 'Disponível',
        'status_used' => 'Usado',
        'statuses' => [
            'available' => 'Disponível',
            'used' => 'Usado',
        ],
        'no_codes' => 'Nenhum código de licença encontrado. Adicione alguns códigos ou gere-os automaticamente.',
        'no_codes_warning_title' => 'Nenhum Código de Licença Disponível!',
        'no_codes_warning_message' => 'Este produto está definido para "Escolher da Lista" mas não tem códigos de licença disponíveis. Os clientes que comprarem este produto receberão códigos gerados automaticamente. Por favor, adicione códigos de licença para garantir o funcionamento correto.',
        'no_codes_auto_generate' => 'Este produto está definido para gerar códigos de licença automaticamente. Não são necessários códigos manuais.',
        'used_code_no_actions' => 'Código usado - nenhuma ação disponível',
        'created_successfully' => 'Código de licença criado com sucesso!',
        'updated_successfully' => 'Código de licença atualizado com sucesso!',
        'deleted_successfully' => 'Código de licença eliminado com sucesso!',
        'generated_successfully' => ':count códigos de licença gerados com sucesso!',
        'duplicates_skipped' => ':count códigos duplicados foram ignorados.',
        'generation_incomplete' => 'Aviso: Só foi possível gerar :generated de :requested códigos solicitados devido a conflitos de duplicação.',
        'cannot_edit_used_code' => 'Não é possível editar um código de licença usado.',
        'cannot_delete_used_code' => 'Não é possível eliminar um código de licença usado.',
        'show_all' => 'Mostrar todos',
        'show_less' => 'Mostrar menos',
        'more' => 'mais',
        'used_codes_hidden' => ':count código(s) de licença usado(s) estão ocultos. Pode ver todos os códigos na página de Gestão de Códigos de Licença.',
        'low_stock_title' => 'Stock Baixo de Códigos de Licença',
        'low_stock_message' => 'Apenas :count códigos de licença restantes. Considere adicionar mais códigos para evitar ficar sem stock.',
        'out_of_stock_title' => 'Sem Códigos de Licença!',
        'out_of_stock_message' => 'Nenhum código de licença disponível. Os clientes receberão códigos gerados automaticamente até adicionar mais.',
        'type' => [
            'title' => 'Método de Atribuição de Código de Licença',
            'auto_generate' => 'Gerar Automaticamente (O sistema gera códigos automaticamente)',
            'pick_from_list' => 'Escolher da Lista (Usar códigos pré-introduzidos)',
            'description' => 'Escolha como os códigos de licença devem ser atribuídos aos clientes quando comprarem este produto.',
        ],
        'add_modal' => [
            'placeholder' => 'ex., XXXX-XXXX-XXXX-XXXX',
            'help' => 'Introduza um código de licença único que será atribuído a um cliente após a compra.',
        ],
        'generate_modal' => [
            'title' => 'Gerar Códigos de Licença',
            'quantity' => 'Quantidade',
            'format' => 'Formato',
            'custom_pattern' => 'Padrão Personalizado',
            'pattern_help' => 'Use # para números, A para letras maiúsculas, a para letras minúsculas',
            'generate' => 'Gerar',
        ],
        'errors' => [
            'feature_not_enabled' => 'A funcionalidade de códigos de licença não está ativada. Por favor, ative-a em Definições de Comércio Eletrónico > Produtos Digitais.',
            'digital_products_not_enabled' => 'Os produtos digitais não estão ativados. Por favor, ative primeiro o suporte a produtos digitais.',
            'product_not_found' => 'Produto não encontrado.',
            'not_digital_product' => 'Os códigos de licença só estão disponíveis para produtos digitais. Este produto está definido como produto físico.',
            'license_codes_not_enabled_for_product' => 'A gestão de códigos de licença não está ativada para este produto. Por favor, ative "Gerar código de licença após a compra do produto" nas definições do produto.',
            'cannot_add_codes_auto_generate' => 'Não é possível adicionar manualmente códigos de licença a produtos definidos para geração automática. Altere primeiro o tipo de código de licença para "Escolher da Lista".',
            'cannot_generate_codes_auto_generate' => 'Não é possível gerar manualmente códigos de licença para produtos definidos para geração automática. Altere primeiro o tipo de código de licença para "Escolher da Lista".',
        ],
        'bulk_delete' => [
            'button' => 'Eliminar Selecionados',
            'selected' => 'selecionado(s)',
            'confirm' => 'Tem a certeza de que deseja eliminar os códigos de licença selecionados?',
            'deleted_successfully' => ':count código(s) de licença eliminado(s) com sucesso.',
            'skipped_used_codes' => ':count código(s) usado(s) foram ignorados.',
            'no_deletable_codes' => 'Nenhum código de licença disponível encontrado para eliminar. Os códigos usados não podem ser eliminados.',
        ],
        'import' => [
            'name' => 'Importar Códigos de Licença de Produtos',
            'description' => 'Importar códigos de licença para produtos digitais a partir de ficheiro CSV/Excel.',
            'button' => 'Importar',
            'columns' => [
                'product_id' => 'ID do Produto ou SKU',
                'license_code' => 'Código de Licença',
            ],
        ],
        'copied' => 'Código de licença copiado para a área de transferência!',
    ],
    'this_action_will_reload_page' => 'Esta ação irá recarregar a página para atualizar os dados!',
    'select' => 'Selecionar',
    'clear_filters' => 'Limpar filtros',
    'set_this_variant_as_default' => 'Definir esta variante como predefinida',
    'download' => 'Transferir',
    'external_link_downloads' => 'Ligações externas',
    'download_available_when_completed' => 'As ligações de transferência estarão disponíveis quando a encomenda estiver concluída.',
    'cross_sell_price_type' => [
        'title' => 'Tipo de preço',
        'fixed' => 'Fixo',
        'percent' => 'Percentagem',
    ],
    'cross_sell_help' => [
        'price' => '* Campo de preço',
        'price_description' => 'Introduza o valor que deseja reduzir do preço original. Exemplo: Se o preço original é 100€, introduza 20 para reduzir o preço para 80€.',
        'type' => '* Campo de tipo',
        'type_description' => 'Escolha o tipo de desconto: Fixo (reduzir um valor específico) ou Percentagem (reduzir por uma percentagem).',
    ],
    'up_sell_price_type' => [
        'title' => 'Tipo de preço',
        'fixed' => 'Fixo',
        'percent' => 'Percentagem',
    ],
    'up_sell_help' => [
        'price' => '* Campo de preço',
        'price_description' => 'Introduza o valor que deseja reduzir do preço original. Exemplo: Se o preço original é 100€, introduza 20 para reduzir o preço para 80€.',
        'type' => '* Campo de tipo',
        'type_description' => 'Escolha o tipo de desconto: Fixo (reduzir um valor específico) ou Percentagem (reduzir por uma percentagem).',
    ],
    'up_sale' => [
        'title' => 'Compre Junto e Poupe',
        'description' => 'Obtenha descontos especiais ao comprar estes itens juntos',
        'unlock_discount' => 'Adicione :product ao carrinho para desbloquear o desconto do pacote',
        'multiple_options' => 'Múltiplas opções',
        'multiple_options_available' => 'Múltiplas opções disponíveis',
        'select' => 'Selecionar',
        'selected_items_total' => 'Total dos itens selecionados:',
        'add_selected_to_cart' => 'Adicionar Selecionados ao Carrinho',
        'bundle_discount_with' => 'Desconto de pacote com :product',
        'bundle_with' => 'Pacote com :product',
    ],
    'cross_sale' => [
        'title' => 'Frequentemente Comprados Juntos',
        'description' => 'Os clientes que viram este item também compraram',
    ],
    'apply_for_all_variations' => 'Aplicar a todas as variações',
    'export' => [
        'description' => 'Exporte os dados dos seus produtos para ficheiros CSV ou Excel.',
        'total_items' => 'Total de Itens',
        'total_products' => 'Total de Produtos',
        'total_variations' => 'Total de Variações',
        'advanced_options' => 'Opções Avançadas',
        'use_chunked_export' => 'Usar exportação em blocos',
        'use_chunked_export_helper' => 'Processar dados em blocos para gerir grandes conjuntos de dados de forma eficiente',
        'include_variations' => 'Incluir variações de produtos',
        'include_variations_helper' => 'Exportar variações de produtos juntamente com os produtos principais',
        'optimize_memory' => 'Otimizar uso de memória',
        'optimize_memory_helper' => 'Ativar otimização de memória para exportações muito grandes',
        'chunk_size' => 'Tamanho do bloco',
        'chunk_size_helper' => 'Número de produtos a processar de cada vez (50-5000)',
        'use_streaming' => 'Usar exportação em streaming',
        'use_streaming_helper' => 'Ativar streaming para conjuntos de dados muito grandes (ativado automaticamente para >10.000 itens)',
        'large_dataset_warning_title' => 'Catálogo de Produtos Grande Detetado',
        'large_dataset_warning_message' => 'O seu catálogo contém :count itens. Devido ao grande tamanho, algumas opções de exportação foram otimizadas para melhor desempenho.',
        'large_dataset_specific_message' => 'Para os seus :count produtos, use o formato CSV com streaming ativado. O sistema agora pode gerir o seu grande catálogo de produtos de forma eficiente sem timeouts ou problemas de memória.',
        'format_label' => 'Formato',
        'csv_recommended' => 'CSV (Obrigatório)',
        'chunk_label' => 'Processamento',
        'chunk_recommended' => '300 produtos/lote',
        'time_label' => 'Tempo Estimado',
        'time_estimate' => '1-3 minutos',
        'pro_tip' => 'Dica Profissional:',
        'pro_tip_message' => 'A exportação continuará a ser executada mesmo que o seu navegador mostre um indicador de carregamento. Uma vez iniciada, a transferência começará automaticamente.',
        'large_dataset_tip_1' => 'O formato Excel foi desativado - use o formato CSV para exportações mais rápidas e fiáveis',
        'large_dataset_tip_2' => 'O modo de streaming foi ativado automaticamente para evitar timeouts',
        'large_dataset_tip_3' => 'O processo de exportação pode demorar 1-3 minutos dependendo do seu servidor',
        'large_dataset_recommendation' => 'Recomendado: Use o formato CSV com tamanho de bloco de 200-500 para um desempenho ideal.',
        'excel_disabled_for_large_export' => 'Formato Excel não disponível para catálogos com mais de 10.000 itens',
        'streaming_auto_enabled' => 'O modo de streaming foi ativado automaticamente para um desempenho ideal com grandes conjuntos de dados.',
        'streaming_enabled_title' => 'Otimizado para Exportação Grande',
        'streaming_enabled_message' => 'O modo de streaming está ativo para garantir uma exportação suave sem problemas de memória.',
        'use_multi_file' => 'Usar exportação multi-ficheiro',
        'use_multi_file_helper' => 'Dividir a exportação em múltiplos ficheiros empacotados num ZIP para conjuntos de dados muito grandes',
        'multi_file_enabled_title' => 'Exportação Multi-Ficheiro Ativada',
        'multi_file_enabled_message' => 'A sua exportação será dividida em :count ficheiros empacotados num ZIP para um desempenho ideal.',
        'records_per_file' => 'Registos Por Ficheiro',
        'records_per_file_helper' => 'Número de registos em cada ficheiro ao usar exportação multi-ficheiro',
        'estimated_files' => 'Ficheiros Estimados',
        'recommended_range' => 'Intervalo recomendado',
        'range_large_export' => '200-500 itens',
        'range_medium_export' => '300-800 itens',
        'range_small_export' => '500-1000 itens',
        'export_progress' => 'Progresso da Exportação',
        'preparing_export' => 'A preparar exportação...',
        'items_processed' => ':count itens processados',
        'estimated_time_calculating' => 'Tempo estimado: a calcular...',
        'medium_dataset_detected' => 'Conjunto de Dados Médio Detetado',
        'medium_dataset_message' => 'Está a exportar :count produtos. Considere usar exportação em blocos para melhor desempenho.',
        'optimal_range' => 'Intervalo ideal',
        'too_small_slow' => 'Muito pequeno - pode ser lento',
        'too_large_timeouts' => 'Muito grande - pode causar timeouts',
        'excel_disabled_warning' => 'Formato Excel desativado para exportações grandes (:count itens)',
        'starting_export' => 'A Iniciar Exportação...',
        'processing_data' => 'A processar dados...',
        'finalizing_export' => 'A finalizar exportação...',
        'items_processed_suffix' => 'itens processados',
        'estimated_time_prefix' => 'Tempo estimado:',
        'seconds_remaining' => 's restantes',
        'export_completed' => 'Exportação concluída!',
        'download_starting' => 'Transferência a iniciar...',
    ],
    'import' => [
        'description' => 'Importe os dados dos seus produtos a partir de ficheiros CSV ou Excel.',
        'rules' => [
            'in' => ':attribute deve ser um dos valores definidos: :values.',
            'required_string_max' => ':attribute é obrigatório e deve ser uma string com um comprimento máximo de :max caracteres.',
            'nullable_string' => ':attribute pode ficar vazio ou deve ser uma string se fornecido.',
            'nullable_string_max' => ':attribute pode ficar vazio ou deve ser uma string com um comprimento máximo de :max caracteres se fornecido',
            'nullable_bool' => ':attribute pode ficar vazio ou deve ser um valor booleano se fornecido.',
            'nullable_numeric_min' => ':attribute pode ficar vazio ou deve ser um número não negativo se fornecido.',
            'nullable_numeric_min_max' => ':attribute pode ficar vazio ou deve ser um número entre :min e :max se fornecido.',
            'nullable_array' => ':attribute pode ficar vazio ou deve ser fornecido como um array se especificado.',
            'nullable_date_required_if' => ':attribute pode ficar vazio ou deve ser uma data válida se fornecido, obrigatório se :required for especificado.',
            'nullable_date_after' => ':attribute pode ficar vazio ou deve ser uma data válida após :after se fornecido.',
        ],
        'updated_message' => ':count produtos atualizados com sucesso!',
    ],
    'import_products_intro' => 'Ou importe produtos a partir de CSV/Excel',
    'select_attributes' => 'Selecione os atributos para criar variações:',
    'all' => 'Todos',
    'copy' => 'Copiar',
    'product_translations' => 'Traduções do Produto',
    'view' => 'Ver produto - :name',
    'product_information' => 'Informação do Produto',
    'total_views' => 'Total de Visualizações',
    'total_orders' => 'Encomendas Concluídas',
    'total_sold' => 'Total Vendido',
    'total_revenue' => 'Receita Total',
    'pending_orders' => 'Encomendas Pendentes',
    'pending_revenue' => 'Receita Pendente',
    'conversion_rate' => 'Taxa de Conversão',
    'total_reviews' => 'Total de Avaliações',
    'average_rating' => 'Classificação Média',
    'views_by_date' => 'Visualizações por Data (Últimos 30 Dias)',
    'recent_orders' => 'Encomendas Recentes',
    'no_views_data' => 'Nenhum dado de visualizações disponível para os últimos 30 dias.',
    'no_orders' => 'Ainda sem encomendas.',
    'date' => 'Data',
    'views' => 'Visualizações',
    'total' => 'Total',
    'view_on_frontend' => 'Ver no Frontend',
    'select_attribute' => 'Selecionar :name',
    'all_categories' => 'Todas as categorias',
    'brands' => 'Marcas',
    'browse_products' => 'Explorar Produtos',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Selecionar Produtos para Devolver',
    'show_only_discounted_products' => 'Mostrar apenas produtos com desconto',
    'specification' => 'Especificação',
    'download_product_with_external_links' => 'Transferir produto ":name" com ligações externas',
    'number_product_available_singular' => ':number produto disponível',
    'number_products_available_plural' => ':number produtos disponíveis',
    'cart' => [
        'added_to_cart_success' => ':product foi adicionado ao seu carrinho.',
        'removed_from_cart_success' => ':product foi removido do seu carrinho.',
        'updated_cart_success' => 'O seu carrinho foi atualizado.',
        'item_not_found' => 'Este item já não está no seu carrinho.',
        'out_of_stock' => 'Lamentamos, :product está atualmente esgotado.',
        'max_quantity' => 'Só pode adicionar até :max itens.',
        'max_quantity_detail' => 'Lamentamos, só pode encomendar até :quantity unidades de :product de cada vez.',
        'select_options' => 'Por favor, selecione as opções do produto antes de adicionar ao carrinho.',
        'product_out_of_stock' => 'Lamentamos, este produto está atualmente esgotado.',
        'product_not_exists' => 'Este produto está esgotado ou já não existe.',
        'not_enough_quantity' => 'Alguns produtos não têm stock suficiente para atualizar.',
        'empty_success' => 'O seu carrinho foi esvaziado.',
        'bundle_item_already_in_cart' => 'Este item do pacote já está no seu carrinho. Apenas 1 item por desconto de pacote é permitido.',
    ],
    'wishlist' => [
        'added_success' => ':product foi adicionado à sua lista de desejos.',
        'removed_success' => ':product foi removido da sua lista de desejos.',
        'product_not_found' => 'Este produto não foi encontrado.',
        'product_not_in_wishlist' => 'Este produto não está na sua lista de desejos.',
        'product_not_available' => 'Este produto não está disponível.',
    ],
    'compare' => [
        'added_success' => ':product foi adicionado à sua lista de comparação.',
        'removed_success' => ':product foi removido da sua lista de comparação.',
        'product_not_found' => 'Este produto não foi encontrado.',
        'product_not_in_compare' => 'Este produto não está na sua lista de comparação.',
        'already_in_list' => ':product já está na sua lista de comparação.',
    ],
];
