<?php

return [
    'name' => 'Produkty',
    'description' => 'Zarządzaj produktami fizycznymi i cyfrowymi z magazynem, cenami i wariantami',
    'create' => 'Nowy produkt',
    'create_product_type' => [
        'physical' => 'Nowy produkt fizyczny',
        'digital' => 'Nowy produkt cyfrowy',
    ],
    'edit' => 'Edytuj produkt - :name',
    'form' => [
        'name' => 'Nazwa',
        'name_placeholder' => 'Nazwa produktu (Maksymalnie 120 znaków)',
        'description' => 'Opis',
        'description_placeholder' => 'Krótki opis produktu (Maksymalnie 400 znaków)',
        'categories' => 'Kategorie',
        'content' => 'Treść',
        'price' => 'Cena',
        'currency' => 'Waluta',
        'currency_for_variations_hint' => 'Ta waluta będzie stosowana do wszystkich wariantów tego produktu.',
        'quantity' => 'Ilość',
        'brand' => 'Marka',
        'width' => 'Szerokość',
        'height' => 'Wysokość',
        'weight' => 'Waga',
        'date' => [
            'start' => 'Od daty',
            'end' => 'Do daty',
        ],
        'image' => 'Obrazy',
        'collections' => 'Kolekcje produktów',
        'labels' => 'Etykiety',
        'price_sale' => 'Cena promocyjna',
        'product_type' => [
            'title' => 'Typ produktu',
        ],
        'product' => 'Produkt',
        'total' => 'Razem',
        'sub_total' => 'Suma częściowa',
        'shipping_fee' => 'Koszt wysyłki',
        'discount' => 'Rabat',
        'options' => 'Opcje',
        'shipping' => [
            'height' => 'Wysokość',
            'length' => 'Długość',
            'title' => 'Wysyłka',
            'weight' => 'Waga',
            'wide' => 'Szerokość',
        ],
        'barcode' => 'Kod kreskowy (ISBN, UPC, GTIN, itp.) ',
        'barcode_placeholder' => 'Wprowadź kod kreskowy',
        'cost_per_item' => 'Koszt jednostkowy',
        'cost_per_item_placeholder' => 'Wprowadź koszt jednostkowy',
        'cost_per_item_helper' => 'Klienci nie zobaczą tej ceny.',
        'price_includes_tax' => 'Cena zawiera podatek',
        'price_includes_tax_helper' => 'Zaznacz, jeśli wprowadzona cena zawiera już podatki. System obliczy cenę bazową, odejmując kwotę podatku.',
        'stock' => [
            'allow_order_when_out' => 'Pozwól klientom składać zamówienia, gdy produkt jest niedostępny',
            'in_stock' => 'Dostępny',
            'out_stock' => 'Niedostępny',
            'title' => 'Status magazynowy',
        ],
        'storehouse' => [
            'no_storehouse' => 'Bez zarządzania magazynem',
            'storehouse' => 'Z zarządzaniem magazynem',
            'title' => 'Magazyn',
            'quantity' => 'Ilość',
        ],
        'tax' => 'Podatek',
        'taxes' => 'Podatki',
        'taxes_helper' => 'Domyślna stawka podatku jest skonfigurowana w <a href=":url">Ustawienia -> Podatek</a>. Jeśli dla tego produktu nie wybrano konkretnego podatku, zostanie zastosowana domyślna stawka. Aby wyłączyć podatek dla tego produktu, usuń domyślną stawkę podatku z ustawień podatkowych.',
        'is_default' => 'Domyślny',
        'action' => 'Akcja',
        'restock_quantity' => 'Ilość do uzupełnienia',
        'remain' => 'Pozostało',
        'choose_discount_period' => 'Wybierz okres rabatowy',
        'cancel' => 'Anuluj',
        'no_results' => 'Brak wyników!',
        'value' => 'Wartość',
        'attribute_name' => 'Nazwa atrybutu',
        'add_more_attribute' => 'Dodaj więcej atrybutów',
        'continue' => 'Kontynuuj',
        'add_new_attributes' => 'Dodaj nowe atrybuty',
        'add_new_attributes_description' => 'Dodanie nowych atrybutów pozwala produktowi mieć wiele opcji, takich jak rozmiar lub kolor.',
        'create_product_variations' => ':link aby utworzyć warianty produktu!',
        'tags' => 'Tagi',
        'write_some_tags' => 'Wpisz kilka tagów',
        'variation_existed' => 'Ten wariant już istnieje.',
        'no_attributes_selected' => 'Nie wybrano żadnych atrybutów!',
        'added_variation_success' => 'Wariant został pomyślnie dodany!',
        'updated_variation_success' => 'Wariant został pomyślnie zaktualizowany!',
        'created_all_variation_success' => 'Wszystkie warianty zostały pomyślnie utworzone!',
        'updated_product_attributes_success' => 'Atrybuty produktu zostały pomyślnie zaktualizowane!',
        'stock_status' => 'Status magazynowy',
        'auto_generate_sku' => 'Automatycznie generuj SKU?',
        'featured_image' => 'Obraz wyróżniający (opcjonalnie)',
        'product_id' => 'ID produktu',
        'price_sale_percent_helper' => 'Rabat :percent od ceny oryginalnej.',
        'minimum_order_quantity' => 'Minimalna ilość zamówienia',
        'minimum_order_quantity_helper' => 'Minimalna ilość do złożenia zamówienia, jeśli wartość wynosi 0, nie ma limitu.',
        'maximum_order_quantity' => 'Maksymalna ilość zamówienia',
        'maximum_order_quantity_helper' => 'Maksymalna ilość do złożenia zamówienia, jeśli wartość wynosi 0, nie ma limitu.',
        'video' => 'Wideo',
        'video_file' => 'Plik',
        'video_url' => 'Lub zewnętrzny URL wideo',
        'video_url_help' => 'Wprowadź URL wideo z YouTube lub Vimeo',
        'enter_video_url' => 'Wprowadź URL wideo',
        'video_thumbnail' => 'Miniatura wideo',
        'video_thumbnail_help' => 'Wybierz miniaturę dla wideo. Jeśli nie zostanie wybrana, zostanie automatycznie pobrana z URL wideo, jeśli jest dostępna.',
        'barcode_existed' => 'Ten kod kreskowy jest używany przez inny produkt. Proszę wprowadzić inny kod kreskowy.',
        'barcode_helper' => 'Musi być unikalny dla każdego produktu.',
        'is_new_until' => 'Nowy do',
        'is_new_until_helper' => 'Ustaw datę, do której ten produkt będzie oznaczony jako "Nowy". Pozostaw puste, aby nie oznaczać jako nowy na podstawie daty.',
    ],
    'price' => 'Cena',
    'quantity' => 'Ilość',
    'type' => 'Typ',
    'image' => 'Miniatura',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU wariantu',
    'brand' => 'Marka',
    'cannot_delete' => 'Nie można usunąć produktu',
    'product_deleted' => 'Produkt usunięty',
    'product' => 'Produkt',
    'product_collections' => 'Kolekcje produktów',
    'products' => 'Produkty',
    'total_products_found' => 'Znaleziono :total produktów',
    'total_product_found' => 'Znaleziono :total produkt',
    'menu' => 'Produkty',
    'control' => [
        'button_add_image' => 'Dodaj obraz',
    ],
    'price_sale' => 'Cena promocyjna',
    'price_group_title' => 'Zarządzaj ceną produktu',
    'store_house_group_title' => 'Zarządzaj magazynem',
    'shipping_group_title' => 'Zarządzaj wysyłką',
    'overview' => 'Przegląd',
    'attributes' => 'Atrybuty',
    'product_has_variations' => 'Produkt ma warianty',
    'manage_products' => 'Zarządzaj produktami',
    'add_new_product' => 'Dodaj nowy produkt',
    'start_by_adding_new_product' => 'Zacznij od dodania nowych produktów.',
    'edit_this_product' => 'Edytuj ten produkt',
    'delete' => 'Usuń',
    'related_products' => 'Powiązane produkty',
    'cross_selling_products' => 'Produkty cross-selling',
    'up_selling_products' => 'Produkty up-selling',
    'grouped_products' => 'Produkty grupowe',
    'search_products' => 'Szukaj produktów',
    'selected_products' => 'Wybrane produkty',
    'edit_variation_item' => 'Edytuj',
    'variations_box_description' => 'Kliknij "Edytuj atrybut", aby dodać/usunąć atrybuty wariantu lub kliknij "Dodaj nowy wariant", aby dodać wariant.',
    'save_changes' => 'Zapisz zmiany',
    'continue' => 'Kontynuuj',
    'edit_attribute' => 'Edytuj atrybut',
    'select_attribute' => 'Wybierz atrybut',
    'add_new_variation' => 'Dodaj nowy wariant',
    'edit_variation' => 'Edytuj wariant',
    'generate_variations' => 'Generuj warianty',
    'generate_variations_confirmation' => 'Czy na pewno chcesz wygenerować warianty dla tego produktu?',
    'delete_variation' => 'Usunąć wariant?',
    'delete_variation_confirmation' => 'Czy na pewno chcesz usunąć ten wariant? Tej akcji nie można cofnąć.',
    'delete_variations_confirmation' => 'Czy na pewno chcesz usunąć te warianty? Tej akcji nie można cofnąć.',
    'product_create_validate_name_required' => 'Proszę wprowadzić nazwę produktu',
    'product_create_validate_sale_price_max' => 'Rabat musi być mniejszy niż cena oryginalna',
    'product_create_validate_cost_per_item_max' => 'Koszt jednostkowy musi być mniejszy niż cena oryginalna',
    'product_create_validate_sale_price_required_if' => 'Musisz wprowadzić rabat, gdy chcesz zaplanować promocję',
    'product_create_validate_end_date_after' => 'Data końcowa musi być późniejsza niż data początkowa',
    'product_create_validate_start_date_required_if' => 'Data rozpoczęcia rabatu nie może być pusta, gdy wybrano harmonogram',
    'product_create_validate_sale_price' => 'Rabat nie może być pusty, gdy wybrano harmonogram',
    'stock_statuses' => [
        'in_stock' => 'Dostępny',
        'out_of_stock' => 'Niedostępny',
        'on_backorder' => 'Na zamówienie',
    ],
    'stock_status' => 'Status magazynowy',
    'processing' => 'Przetwarzanie...',
    'delete_selected_variations' => 'Usuń wybrane warianty',
    'delete_variations' => 'Usuń warianty',
    'category' => 'Kategoria',
    'categories' => 'Kategorie',
    'tags' => 'Tagi',
    'product_price_flash_sale_warning' => 'Ten produkt jest w wyprzedaży błyskawicznej <strong>:name</strong>, więc jego cena wynosi <strong>:price</strong>.',
    'product_price_discount_warning' => 'Ten produkt jest objęty rabatem <strong>:name</strong>, więc jego cena wynosi <strong>:price</strong>.',
    'product_image' => 'Obraz produktu',
    'product_name' => 'Nazwa produktu',
    'product_link' => 'Link do produktu',
    'types' => [
        'physical' => 'Fizyczny',
        'digital' => 'Cyfrowy',
    ],
    'digital_attachments' => [
        'title' => 'Załączniki cyfrowe',
        'add' => 'Dodaj załącznik',
        'file_name' => 'Nazwa pliku',
        'file_size' => 'Rozmiar pliku',
        'unsaved' => 'Niezapisane',
        'add_external_link' => 'Dodaj zewnętrzny link',
        'enter_file_name' => 'Wprowadź nazwę pliku',
        'enter_external_link_download' => 'Wprowadź zewnętrzny link do pobrania',
        'enter_file_size' => 'Wprowadź rozmiar pliku',
        'external_link_download' => 'Zewnętrzny link do pobrania',
        'generate_license_code_after_purchasing_product' => 'Włącz przypisywanie kodu licencyjnego dla tego produktu',
        'notify_attachment_updated' => 'Wyślij e-mail do klienta, gdy załącznik zostanie zaktualizowany',
        'no_attachments' => 'Brak załączników. Kliknij przyciski powyżej, aby dodać pliki.',
    ],
    'license_codes' => [
        'title' => 'Kody licencyjne',
        'add' => 'Dodaj kod licencyjny',
        'back' => 'Wróć do produktu',
        'edit' => 'Edytuj kod licencyjny',
        'generate' => 'Generuj kody',
        'manage_codes' => 'Zarządzaj kodami licencyjnymi',
        'management' => 'Zarządzanie kodami licencyjnymi',
        'variation_breadcrumb' => 'Wariant: :name',
        'variation_label' => 'Wariant produktu',
        'variation_specific_note' => 'Te kody licencyjne są specyficzne dla tego wariantu produktu. Klienci, którzy zakupią ten wariant, otrzymają kody z tej puli.',
        'main_product_note' => 'Ten produkt ma warianty. Każdy wariant może mieć własne kody licencyjne, lub klienci mogą otrzymać kody z puli głównego produktu, jeśli wariant nie ma kodów.',
        'code' => 'Kod licencyjny',
        'codes' => 'Kody licencyjne',
        'status' => 'Status',
        'assigned_at' => 'Przypisano',
        'status_available' => 'Dostępny',
        'status_used' => 'Wykorzystany',
        'statuses' => [
            'available' => 'Dostępny',
            'used' => 'Wykorzystany',
        ],
        'no_codes' => 'Nie znaleziono kodów licencyjnych. Dodaj kody lub wygeneruj je automatycznie.',
        'no_codes_warning_title' => 'Brak dostępnych kodów licencyjnych!',
        'no_codes_warning_message' => 'Ten produkt jest ustawiony na "Wybierz z listy", ale nie ma dostępnych kodów licencyjnych. Klienci, którzy zakupią ten produkt, otrzymają automatycznie wygenerowane kody. Proszę dodać kody licencyjne, aby zapewnić prawidłowe działanie.',
        'no_codes_auto_generate' => 'Ten produkt jest ustawiony na automatyczne generowanie kodów licencyjnych. Nie są potrzebne ręczne kody.',
        'used_code_no_actions' => 'Wykorzystany kod - brak dostępnych akcji',
        'created_successfully' => 'Kod licencyjny został pomyślnie utworzony!',
        'updated_successfully' => 'Kod licencyjny został pomyślnie zaktualizowany!',
        'deleted_successfully' => 'Kod licencyjny został pomyślnie usunięty!',
        'generated_successfully' => 'Pomyślnie wygenerowano :count kodów licencyjnych!',
        'duplicates_skipped' => 'Pominięto :count zduplikowanych kodów.',
        'generation_incomplete' => 'Ostrzeżenie: Udało się wygenerować tylko :generated z :requested żądanych kodów z powodu konfliktów duplikatów.',
        'cannot_edit_used_code' => 'Nie można edytować wykorzystanego kodu licencyjnego.',
        'cannot_delete_used_code' => 'Nie można usunąć wykorzystanego kodu licencyjnego.',
        'show_all' => 'Pokaż wszystkie',
        'show_less' => 'Pokaż mniej',
        'more' => 'więcej',
        'used_codes_hidden' => ':count wykorzystanych kodów licencyjnych jest ukrytych. Możesz zobaczyć wszystkie kody na stronie Zarządzanie kodami licencyjnymi.',
        'low_stock_title' => 'Niski stan kodów licencyjnych',
        'low_stock_message' => 'Pozostało tylko :count kodów licencyjnych. Rozważ dodanie więcej kodów, aby uniknąć ich wyczerpania.',
        'out_of_stock_title' => 'Brak kodów licencyjnych!',
        'out_of_stock_message' => 'Brak dostępnych kodów licencyjnych. Klienci będą otrzymywać automatycznie wygenerowane kody, dopóki nie dodasz więcej.',
        'type' => [
            'title' => 'Metoda przypisywania kodów licencyjnych',
            'auto_generate' => 'Automatyczne generowanie (System generuje kody automatycznie)',
            'pick_from_list' => 'Wybierz z listy (Użyj wcześniej wprowadzonych kodów)',
            'description' => 'Wybierz, jak kody licencyjne powinny być przypisywane klientom, gdy zakupią ten produkt.',
        ],
        'add_modal' => [
            'placeholder' => 'np. XXXX-XXXX-XXXX-XXXX',
            'help' => 'Wprowadź unikalny kod licencyjny, który zostanie przypisany klientowi po zakupie.',
        ],
        'generate_modal' => [
            'title' => 'Generuj kody licencyjne',
            'quantity' => 'Ilość',
            'format' => 'Format',
            'custom_pattern' => 'Własny wzorzec',
            'pattern_help' => 'Użyj # dla cyfr, A dla wielkich liter, a dla małych liter',
            'generate' => 'Generuj',
        ],
        'errors' => [
            'feature_not_enabled' => 'Funkcja kodów licencyjnych nie jest włączona. Proszę włączyć ją w Ustawienia Ecommerce > Produkty cyfrowe.',
            'digital_products_not_enabled' => 'Produkty cyfrowe nie są włączone. Proszę najpierw włączyć obsługę produktów cyfrowych.',
            'product_not_found' => 'Produkt nie został znaleziony.',
            'not_digital_product' => 'Kody licencyjne są dostępne tylko dla produktów cyfrowych. Ten produkt jest ustawiony jako produkt fizyczny.',
            'license_codes_not_enabled_for_product' => 'Zarządzanie kodami licencyjnymi nie jest włączone dla tego produktu. Proszę włączyć "Generuj kod licencyjny po zakupie produktu" w ustawieniach produktu.',
            'cannot_add_codes_auto_generate' => 'Nie można ręcznie dodawać kodów licencyjnych do produktów ustawionych na automatyczne generowanie. Najpierw zmień typ kodu licencyjnego na "Wybierz z listy".',
            'cannot_generate_codes_auto_generate' => 'Nie można ręcznie generować kodów licencyjnych dla produktów ustawionych na automatyczne generowanie. Najpierw zmień typ kodu licencyjnego na "Wybierz z listy".',
        ],
        'bulk_delete' => [
            'button' => 'Usuń zaznaczone',
            'selected' => 'zaznaczono',
            'confirm' => 'Czy na pewno chcesz usunąć zaznaczone kody licencyjne?',
            'deleted_successfully' => 'Pomyślnie usunięto :count kodów licencyjnych.',
            'skipped_used_codes' => 'Pominięto :count wykorzystanych kodów.',
            'no_deletable_codes' => 'Nie znaleziono dostępnych kodów licencyjnych do usunięcia. Wykorzystane kody nie mogą być usunięte.',
        ],
        'import' => [
            'name' => 'Importuj kody licencyjne produktu',
            'description' => 'Importuj kody licencyjne dla produktów cyfrowych z pliku CSV/Excel.',
            'button' => 'Importuj',
            'columns' => [
                'product_id' => 'ID produktu lub SKU',
                'license_code' => 'Kod licencyjny',
            ],
        ],
        'copied' => 'Kod licencyjny skopiowany do schowka!',
    ],
    'this_action_will_reload_page' => 'Ta akcja spowoduje przeładowanie strony w celu aktualizacji danych!',
    'select' => 'Wybierz',
    'clear_filters' => 'Wyczyść filtry',
    'set_this_variant_as_default' => 'Ustaw ten wariant jako domyślny',
    'download' => 'Pobierz',
    'external_link_downloads' => 'Zewnętrzne linki',
    'download_available_when_completed' => 'Linki do pobrania będą dostępne po zakończeniu zamówienia.',
    'cross_sell_price_type' => [
        'title' => 'Typ ceny',
        'fixed' => 'Stała',
        'percent' => 'Procent',
    ],
    'cross_sell_help' => [
        'price' => '* Pole ceny',
        'price_description' => 'Wprowadź kwotę, którą chcesz odjąć od ceny oryginalnej. Przykład: Jeśli cena oryginalna wynosi 100 zł, wprowadź 20, aby obniżyć cenę do 80 zł.',
        'type' => '* Pole typu',
        'type_description' => 'Wybierz typ rabatu: Stała (obniż o konkretną kwotę) lub Procent (obniż o procent).',
    ],
    'up_sell_price_type' => [
        'title' => 'Typ ceny',
        'fixed' => 'Stała',
        'percent' => 'Procent',
    ],
    'up_sell_help' => [
        'price' => '* Pole ceny',
        'price_description' => 'Wprowadź kwotę, którą chcesz odjąć od ceny oryginalnej. Przykład: Jeśli cena oryginalna wynosi 100 zł, wprowadź 20, aby obniżyć cenę do 80 zł.',
        'type' => '* Pole typu',
        'type_description' => 'Wybierz typ rabatu: Stała (obniż o konkretną kwotę) lub Procent (obniż o procent).',
    ],
    'up_sale' => [
        'title' => 'Kup razem i oszczędź',
        'description' => 'Otrzymaj specjalne rabaty przy zakupie tych produktów razem',
        'unlock_discount' => 'Dodaj :product do koszyka, aby odblokować rabat pakietowy',
        'multiple_options' => 'Wiele opcji',
        'multiple_options_available' => 'Dostępnych jest wiele opcji',
        'select' => 'Wybierz',
        'selected_items_total' => 'Suma wybranych produktów:',
        'add_selected_to_cart' => 'Dodaj wybrane do koszyka',
        'bundle_discount_with' => 'Rabat pakietowy z :product',
        'bundle_with' => 'Pakiet z :product',
    ],
    'cross_sale' => [
        'title' => 'Często kupowane razem',
        'description' => 'Klienci, którzy oglądali ten produkt, kupili również',
    ],
    'apply_for_all_variations' => 'Zastosuj dla wszystkich wariantów',
    'export' => [
        'description' => 'Eksportuj dane produktów do plików CSV lub Excel.',
        'total_items' => 'Łączna liczba pozycji',
        'total_products' => 'Łączna liczba produktów',
        'total_variations' => 'Łączna liczba wariantów',
        'advanced_options' => 'Zaawansowane opcje',
        'use_chunked_export' => 'Użyj eksportu porcjami',
        'use_chunked_export_helper' => 'Przetwarzaj dane porcjami, aby efektywnie obsługiwać duże zbiory danych',
        'include_variations' => 'Uwzględnij warianty produktów',
        'include_variations_helper' => 'Eksportuj warianty produktów wraz z produktami głównymi',
        'optimize_memory' => 'Optymalizuj użycie pamięci',
        'optimize_memory_helper' => 'Włącz optymalizację pamięci dla bardzo dużych eksportów',
        'chunk_size' => 'Rozmiar porcji',
        'chunk_size_helper' => 'Liczba produktów przetwarzanych jednocześnie (50-5000)',
        'use_streaming' => 'Użyj eksportu strumieniowego',
        'use_streaming_helper' => 'Włącz strumieniowanie dla bardzo dużych zbiorów danych (automatycznie włączane dla >10 000 pozycji)',
        'large_dataset_warning_title' => 'Wykryto duży katalog produktów',
        'large_dataset_warning_message' => 'Twój katalog zawiera :count pozycji. Ze względu na duży rozmiar niektóre opcje eksportu zostały zoptymalizowane pod kątem najlepszej wydajności.',
        'large_dataset_specific_message' => 'Dla Twoich :count produktów użyj formatu CSV z włączonym strumieniowaniem. System może teraz efektywnie obsługiwać Twój duży katalog produktów bez przekroczeń czasu lub problemów z pamięcią.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Wymagany)',
        'chunk_label' => 'Przetwarzanie',
        'chunk_recommended' => '300 produktów/partia',
        'time_label' => 'Szacowany czas',
        'time_estimate' => '1-3 minuty',
        'pro_tip' => 'Wskazówka:',
        'pro_tip_message' => 'Eksport będzie kontynuowany nawet jeśli przeglądarka wyświetla wskaźnik ładowania. Po rozpoczęciu pobieranie rozpocznie się automatycznie.',
        'large_dataset_tip_1' => 'Format Excel został wyłączony - użyj formatu CSV dla szybszego i bardziej niezawodnego eksportu',
        'large_dataset_tip_2' => 'Tryb strumieniowania został automatycznie włączony, aby zapobiec przekroczeniu czasu',
        'large_dataset_tip_3' => 'Proces eksportu może trwać 1-3 minuty w zależności od Twojego serwera',
        'large_dataset_recommendation' => 'Zalecane: Użyj formatu CSV z rozmiarem porcji 200-500 dla optymalnej wydajności.',
        'excel_disabled_for_large_export' => 'Format Excel niedostępny dla katalogów powyżej 10 000 pozycji',
        'streaming_auto_enabled' => 'Tryb strumieniowania został automatycznie włączony dla optymalnej wydajności z dużymi zbiorami danych.',
        'streaming_enabled_title' => 'Zoptymalizowano dla dużego eksportu',
        'streaming_enabled_message' => 'Tryb strumieniowania jest aktywny, aby zapewnić płynny eksport bez problemów z pamięcią.',
        'use_multi_file' => 'Użyj eksportu wieloplikowego',
        'use_multi_file_helper' => 'Podziel eksport na wiele plików spakowanych w ZIP dla bardzo dużych zbiorów danych',
        'multi_file_enabled_title' => 'Eksport wieloplikowy włączony',
        'multi_file_enabled_message' => 'Twój eksport zostanie podzielony na :count plików spakowanych w ZIP dla optymalnej wydajności.',
        'records_per_file' => 'Rekordów na plik',
        'records_per_file_helper' => 'Liczba rekordów w każdym pliku przy eksporcie wieloplikowym',
        'estimated_files' => 'Szacowana liczba plików',
        'recommended_range' => 'Zalecany zakres',
        'range_large_export' => '200-500 pozycji',
        'range_medium_export' => '300-800 pozycji',
        'range_small_export' => '500-1000 pozycji',
        'export_progress' => 'Postęp eksportu',
        'preparing_export' => 'Przygotowywanie eksportu...',
        'items_processed' => 'Przetworzono :count pozycji',
        'estimated_time_calculating' => 'Szacowany czas: obliczanie...',
        'medium_dataset_detected' => 'Wykryto średni zbiór danych',
        'medium_dataset_message' => 'Eksportujesz :count produktów. Rozważ użycie eksportu porcjami dla lepszej wydajności.',
        'optimal_range' => 'Optymalny zakres',
        'too_small_slow' => 'Za mały - może być wolny',
        'too_large_timeouts' => 'Za duży - może powodować przekroczenia czasu',
        'excel_disabled_warning' => 'Format Excel wyłączony dla dużych eksportów (:count pozycji)',
        'starting_export' => 'Rozpoczynanie eksportu...',
        'processing_data' => 'Przetwarzanie danych...',
        'finalizing_export' => 'Finalizowanie eksportu...',
        'items_processed_suffix' => 'przetworzonych pozycji',
        'estimated_time_prefix' => 'Szacowany czas:',
        'seconds_remaining' => 's pozostało',
        'export_completed' => 'Eksport zakończony!',
        'download_starting' => 'Rozpoczynanie pobierania...',
    ],
    'import' => [
        'description' => 'Importuj dane produktów z plików CSV lub Excel.',
        'rules' => [
            'in' => ':attribute musi być jedną ze zdefiniowanych wartości: :values.',
            'required_string_max' => ':attribute jest wymagany i musi być ciągiem znaków o maksymalnej długości :max znaków.',
            'nullable_string' => ':attribute może być pusty lub musi być ciągiem znaków, jeśli podany.',
            'nullable_string_max' => ':attribute może być pusty lub musi być ciągiem znaków o maksymalnej długości :max znaków, jeśli podany.',
            'nullable_bool' => ':attribute może być pusty lub musi być wartością logiczną, jeśli podany.',
            'nullable_numeric_min' => ':attribute może być pusty lub musi być liczbą nieujemną, jeśli podany.',
            'nullable_numeric_min_max' => ':attribute może być pusty lub musi być liczbą między :min a :max, jeśli podany.',
            'nullable_array' => ':attribute może być pusty lub musi być podany jako tablica, jeśli określony.',
            'nullable_date_required_if' => ':attribute może być pusty lub musi być prawidłową datą, jeśli podany, wymagany jeśli :required jest określony.',
            'nullable_date_after' => ':attribute może być pusty lub musi być prawidłową datą po :after, jeśli podany.',
        ],
        'updated_message' => 'Pomyślnie zaktualizowano :count produktów!',
    ],
    'import_products_intro' => 'Lub importuj produkty z CSV/Excel',
    'select_attributes' => 'Wybierz atrybuty do utworzenia wariantów:',
    'all' => 'Wszystko',
    'copy' => 'Kopiuj',
    'product_translations' => 'Tłumaczenia produktu',
    'view' => 'Zobacz produkt - :name',
    'product_information' => 'Informacje o produkcie',
    'total_views' => 'Łączne wyświetlenia',
    'total_orders' => 'Zrealizowane zamówienia',
    'total_sold' => 'Łącznie sprzedano',
    'total_revenue' => 'Łączny przychód',
    'pending_orders' => 'Oczekujące zamówienia',
    'pending_revenue' => 'Oczekujący przychód',
    'conversion_rate' => 'Wskaźnik konwersji',
    'total_reviews' => 'Łączne recenzje',
    'average_rating' => 'Średnia ocena',
    'views_by_date' => 'Wyświetlenia według daty (Ostatnie 30 dni)',
    'recent_orders' => 'Ostatnie zamówienia',
    'no_views_data' => 'Brak danych o wyświetleniach z ostatnich 30 dni.',
    'no_orders' => 'Brak zamówień.',
    'date' => 'Data',
    'views' => 'Wyświetlenia',
    'total' => 'Razem',
    'view_on_frontend' => 'Zobacz na stronie',
    'select_attribute' => 'Wybierz :name',
    'all_categories' => 'Wszystkie kategorie',
    'brands' => 'Marki',
    'browse_products' => 'Przeglądaj produkty',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Wybierz produkty do zwrotu',
    'show_only_discounted_products' => 'Pokaż tylko produkty z rabatem',
    'specification' => 'Specyfikacja',
    'download_product_with_external_links' => 'Pobierz produkt ":name" z zewnętrznymi linkami',
    'number_product_available_singular' => ':number produkt dostępny',
    'number_products_available_plural' => ':number produktów dostępnych',
    'cart' => [
        'added_to_cart_success' => ':product został dodany do Twojego koszyka.',
        'removed_from_cart_success' => ':product został usunięty z Twojego koszyka.',
        'updated_cart_success' => 'Twój koszyk został zaktualizowany.',
        'item_not_found' => 'Ten produkt nie znajduje się już w Twoim koszyku.',
        'out_of_stock' => 'Przepraszamy, :product jest obecnie niedostępny.',
        'max_quantity' => 'Możesz dodać tylko do :max sztuk.',
        'max_quantity_detail' => 'Przepraszamy, możesz zamówić tylko do :quantity sztuk :product jednocześnie.',
        'select_options' => 'Proszę wybrać opcje produktu przed dodaniem do koszyka.',
        'product_out_of_stock' => 'Przepraszamy, ten produkt jest obecnie niedostępny.',
        'product_not_exists' => 'Ten produkt jest niedostępny lub już nie istnieje.',
        'not_enough_quantity' => 'Niektóre produkty nie mają wystarczającej ilości na stanie do aktualizacji.',
        'empty_success' => 'Twój koszyk został opróżniony.',
        'bundle_item_already_in_cart' => 'Ten produkt pakietowy jest już w Twoim koszyku. Dozwolony jest tylko 1 produkt na rabat pakietowy.',
    ],
    'wishlist' => [
        'added_success' => ':product został dodany do Twojej listy życzeń.',
        'removed_success' => ':product został usunięty z Twojej listy życzeń.',
        'product_not_found' => 'Nie można znaleźć tego produktu.',
        'product_not_in_wishlist' => 'Ten produkt nie znajduje się na Twojej liście życzeń.',
        'product_not_available' => 'Ten produkt jest niedostępny.',
    ],
    'compare' => [
        'added_success' => ':product został dodany do listy porównania.',
        'removed_success' => ':product został usunięty z listy porównania.',
        'product_not_found' => 'Nie można znaleźć tego produktu.',
        'product_not_in_compare' => 'Ten produkt nie znajduje się na liście porównania.',
        'already_in_list' => ':product jest już na liście porównania.',
    ],
];
