<?php

return [
    'name' => '商品',
    'description' => '在庫、価格、バリエーションを含む物理的およびデジタル商品を管理',
    'create' => '新規商品',
    'create_product_type' => [
        'physical' => '新規物理商品',
        'digital' => '新規デジタル商品',
    ],
    'edit' => '商品を編集 - :name',
    'form' => [
        'name' => '名前',
        'name_placeholder' => '商品名（最大120文字）',
        'description' => '説明',
        'description_placeholder' => '商品の短い説明（最大400文字）',
        'categories' => 'カテゴリ',
        'content' => 'コンテンツ',
        'price' => '価格',
        'currency' => '通貨',
        'currency_for_variations_hint' => 'この通貨はこの商品のすべてのバリエーションに適用されます。',
        'quantity' => '数量',
        'brand' => 'ブランド',
        'width' => '幅',
        'height' => '高さ',
        'weight' => '重量',
        'date' => [
            'start' => '開始日',
            'end' => '終了日',
        ],
        'image' => '画像',
        'collections' => '商品コレクション',
        'labels' => 'ラベル',
        'price_sale' => 'セール価格',
        'product_type' => [
            'title' => '商品タイプ',
        ],
        'product' => '商品',
        'total' => '合計',
        'sub_total' => '小計',
        'shipping_fee' => '送料',
        'discount' => '割引',
        'options' => 'オプション',
        'shipping' => [
            'height' => '高さ',
            'length' => '長さ',
            'title' => '配送',
            'weight' => '重量',
            'wide' => '幅',
        ],
        'barcode' => 'バーコード (ISBN, UPC, GTIN など) ',
        'barcode_placeholder' => 'バーコードを入力',
        'cost_per_item' => '商品あたりのコスト',
        'cost_per_item_placeholder' => '商品あたりのコストを入力',
        'cost_per_item_helper' => 'お客様にはこの価格は表示されません。',
        'price_includes_tax' => '価格に税込み',
        'price_includes_tax_helper' => '入力した価格に既に税金が含まれている場合はチェックしてください。システムは税額を差し引いて基本価格を計算します。',
        'stock' => [
            'allow_order_when_out' => 'この商品が在庫切れでもお客様がチェックアウトできるようにする',
            'in_stock' => '在庫あり',
            'out_stock' => '在庫切れ',
            'title' => '在庫状況',
        ],
        'storehouse' => [
            'no_storehouse' => '倉庫管理なし',
            'storehouse' => '倉庫管理あり',
            'title' => '倉庫',
            'quantity' => '数量',
        ],
        'tax' => '税',
        'taxes' => '税金',
        'taxes_helper' => 'デフォルトの税率は<a href=":url">設定 -> 税</a>で設定されています。この商品に特定の税が選択されていない場合、デフォルトの税率が適用されます。この商品の税を無効にするには、税設定からデフォルトの税率を削除してください。',
        'is_default' => 'デフォルト',
        'action' => 'アクション',
        'restock_quantity' => '補充数量',
        'remain' => '残り',
        'choose_discount_period' => '割引期間を選択',
        'cancel' => 'キャンセル',
        'no_results' => '結果なし！',
        'value' => '値',
        'attribute_name' => '属性名',
        'add_more_attribute' => '属性を追加',
        'continue' => '続行',
        'add_new_attributes' => '新しい属性を追加',
        'add_new_attributes_description' => '新しい属性を追加すると、商品にサイズや色などの多くのオプションを持たせることができます。',
        'create_product_variations' => ':link で商品バリエーションを作成！',
        'tags' => 'タグ',
        'write_some_tags' => 'タグを入力',
        'variation_existed' => 'このバリエーションは既に存在します。',
        'no_attributes_selected' => '属性が選択されていません！',
        'added_variation_success' => 'バリエーションを追加しました！',
        'updated_variation_success' => 'バリエーションを更新しました！',
        'created_all_variation_success' => 'すべてのバリエーションを作成しました！',
        'updated_product_attributes_success' => '商品属性を更新しました！',
        'stock_status' => '在庫状況',
        'auto_generate_sku' => 'SKUを自動生成しますか？',
        'featured_image' => 'アイキャッチ画像（オプション）',
        'product_id' => '商品ID',
        'price_sale_percent_helper' => '元の価格から:percent割引。',
        'minimum_order_quantity' => '最小注文数量',
        'minimum_order_quantity_helper' => '注文するための最小数量、値が0の場合は制限なし。',
        'maximum_order_quantity' => '最大注文数量',
        'maximum_order_quantity_helper' => '注文するための最大数量、値が0の場合は制限なし。',
        'video' => 'ビデオ',
        'video_file' => 'ファイル',
        'video_url' => 'または外部ビデオURL',
        'video_url_help' => 'YouTubeまたはVimeoのビデオURLを入力',
        'enter_video_url' => 'ビデオURLを入力',
        'video_thumbnail' => 'ビデオサムネイル',
        'video_thumbnail_help' => 'ビデオのサムネイルを選択してください。選択しない場合、利用可能であればビデオURLから自動的に取得されます。',
        'barcode_existed' => 'このバーコードは別の商品で使用されています。別のバーコードを入力してください。',
        'barcode_helper' => '各商品で一意である必要があります。',
        'is_new_until' => '新着表示期限',
        'is_new_until_helper' => 'この商品が「新着」としてマークされる期限日を設定します。日付に基づいて新着としてマークしない場合は空のままにしてください。',
    ],
    'price' => '価格',
    'quantity' => '数量',
    'type' => 'タイプ',
    'image' => 'サムネイル',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'バリエーションSKU',
    'brand' => 'ブランド',
    'cannot_delete' => '商品を削除できませんでした',
    'product_deleted' => '商品を削除しました',
    'product' => '商品',
    'product_collections' => '商品コレクション',
    'products' => '商品',
    'total_products_found' => ':total件の商品が見つかりました',
    'total_product_found' => ':total件の商品が見つかりました',
    'menu' => '商品',
    'control' => [
        'button_add_image' => '画像を追加',
    ],
    'price_sale' => 'セール価格',
    'price_group_title' => '商品価格の管理',
    'store_house_group_title' => '倉庫の管理',
    'shipping_group_title' => '配送の管理',
    'overview' => '概要',
    'attributes' => '属性',
    'product_has_variations' => '商品にはバリエーションがあります',
    'manage_products' => '商品を管理',
    'add_new_product' => '新しい商品を追加',
    'start_by_adding_new_product' => '新しい商品を追加して始めましょう。',
    'edit_this_product' => 'この商品を編集',
    'delete' => '削除',
    'related_products' => '関連商品',
    'cross_selling_products' => 'クロスセル商品',
    'up_selling_products' => 'アップセル商品',
    'grouped_products' => 'グループ商品',
    'search_products' => '商品を検索',
    'selected_products' => '選択した商品',
    'edit_variation_item' => '編集',
    'variations_box_description' => '「属性を編集」をクリックしてバリエーションの属性を追加/削除するか、「新しいバリエーションを追加」をクリックしてバリエーションを追加します。',
    'save_changes' => '変更を保存',
    'continue' => '続行',
    'edit_attribute' => '属性を編集',
    'select_attribute' => '属性を選択',
    'add_new_variation' => '新しいバリエーションを追加',
    'edit_variation' => 'バリエーションを編集',
    'generate_variations' => 'バリエーションを生成',
    'generate_variations_confirmation' => 'この商品のバリエーションを生成してもよろしいですか？',
    'delete_variation' => 'バリエーションを削除しますか？',
    'delete_variation_confirmation' => 'このバリエーションを削除してもよろしいですか？この操作は元に戻せません。',
    'delete_variations_confirmation' => 'これらのバリエーションを削除してもよろしいですか？この操作は元に戻せません。',
    'product_create_validate_name_required' => '商品名を入力してください',
    'product_create_validate_sale_price_max' => '割引価格は元の価格より低くする必要があります',
    'product_create_validate_cost_per_item_max' => '商品あたりのコストは元の価格より低くする必要があります',
    'product_create_validate_sale_price_required_if' => 'プロモーションをスケジュールする場合は割引を入力する必要があります',
    'product_create_validate_end_date_after' => '終了日は開始日より後である必要があります',
    'product_create_validate_start_date_required_if' => 'スケジュールが選択されている場合、割引開始日は空にできません',
    'product_create_validate_sale_price' => 'スケジュールが選択されている場合、割引は空にできません',
    'stock_statuses' => [
        'in_stock' => '在庫あり',
        'out_of_stock' => '在庫切れ',
        'on_backorder' => '入荷待ち',
    ],
    'stock_status' => '在庫状況',
    'processing' => '処理中...',
    'delete_selected_variations' => '選択したバリエーションを削除',
    'delete_variations' => 'バリエーションを削除',
    'category' => 'カテゴリ',
    'categories' => 'カテゴリ',
    'tags' => 'タグ',
    'product_price_flash_sale_warning' => 'この商品はフラッシュセール<strong>:name</strong>に含まれているため、価格は<strong>:price</strong>です。',
    'product_price_discount_warning' => 'この商品は割引<strong>:name</strong>に含まれているため、価格は<strong>:price</strong>です。',
    'product_image' => '商品画像',
    'product_name' => '商品名',
    'product_link' => '商品リンク',
    'types' => [
        'physical' => '物理商品',
        'digital' => 'デジタル商品',
    ],
    'digital_attachments' => [
        'title' => 'デジタル添付ファイル',
        'add' => '添付ファイルを追加',
        'file_name' => 'ファイル名',
        'file_size' => 'ファイルサイズ',
        'unsaved' => '未保存',
        'add_external_link' => '外部リンクを追加',
        'enter_file_name' => 'ファイル名を入力',
        'enter_external_link_download' => '外部ダウンロードリンクを入力',
        'enter_file_size' => 'ファイルサイズを入力',
        'external_link_download' => '外部ダウンロードリンク',
        'generate_license_code_after_purchasing_product' => 'この商品のライセンスコード割り当てを有効にする',
        'notify_attachment_updated' => '添付ファイルが更新されたときにお客様にメールを送信する',
        'no_attachments' => 'まだ添付ファイルがありません。上のボタンをクリックしてファイルを追加してください。',
    ],
    'license_codes' => [
        'title' => 'ライセンスコード',
        'add' => 'ライセンスコードを追加',
        'back' => '商品に戻る',
        'edit' => 'ライセンスコードを編集',
        'generate' => 'コードを生成',
        'manage_codes' => 'ライセンスコードを管理',
        'management' => 'ライセンスコード管理',
        'variation_breadcrumb' => 'バリエーション: :name',
        'variation_label' => '商品バリエーション',
        'variation_specific_note' => 'これらのライセンスコードはこの商品バリエーション専用です。このバリエーションを購入したお客様は、このプールからコードを受け取ります。',
        'main_product_note' => 'この商品にはバリエーションがあります。各バリエーションは独自のライセンスコードを持つことができます。バリエーションにコードがない場合、お客様はこのメイン商品プールからコードを受け取ることができます。',
        'code' => 'ライセンスコード',
        'codes' => 'ライセンスコード',
        'status' => 'ステータス',
        'assigned_at' => '割り当て日時',
        'status_available' => '利用可能',
        'status_used' => '使用済み',
        'statuses' => [
            'available' => '利用可能',
            'used' => '使用済み',
        ],
        'no_codes' => 'ライセンスコードが見つかりません。コードを追加するか、自動的に生成してください。',
        'no_codes_warning_title' => '利用可能なライセンスコードがありません！',
        'no_codes_warning_message' => 'この商品は「リストから選択」に設定されていますが、利用可能なライセンスコードがありません。この商品を購入したお客様は、代わりに自動生成されたコードを受け取ります。適切に機能させるためにライセンスコードを追加してください。',
        'no_codes_auto_generate' => 'この商品はライセンスコードを自動生成するように設定されています。手動のコードは不要です。',
        'used_code_no_actions' => '使用済みコード - アクションはありません',
        'created_successfully' => 'ライセンスコードを作成しました！',
        'updated_successfully' => 'ライセンスコードを更新しました！',
        'deleted_successfully' => 'ライセンスコードを削除しました！',
        'generated_successfully' => ':count件のライセンスコードを生成しました！',
        'duplicates_skipped' => ':count件の重複コードがスキップされました。',
        'generation_incomplete' => '警告: 重複の競合により、リクエストされた:requested件のうち:generated件のみ生成できました。',
        'cannot_edit_used_code' => '使用済みのライセンスコードは編集できません。',
        'cannot_delete_used_code' => '使用済みのライセンスコードは削除できません。',
        'show_all' => 'すべて表示',
        'show_less' => '表示を減らす',
        'more' => 'もっと見る',
        'used_codes_hidden' => ':count件の使用済みライセンスコードが非表示になっています。ライセンスコード管理ページですべてのコードを表示できます。',
        'low_stock_title' => 'ライセンスコードの在庫が少なくなっています',
        'low_stock_message' => '残りのライセンスコードは:count件のみです。不足しないようにコードを追加することを検討してください。',
        'out_of_stock_title' => 'ライセンスコードがありません！',
        'out_of_stock_message' => '利用可能なライセンスコードがありません。追加するまでお客様は自動生成されたコードを受け取ります。',
        'type' => [
            'title' => 'ライセンスコード割り当て方法',
            'auto_generate' => '自動生成（システムがコードを自動的に生成）',
            'pick_from_list' => 'リストから選択（事前に入力されたコードを使用）',
            'description' => 'お客様がこの商品を購入したときにライセンスコードをどのように割り当てるかを選択してください。',
        ],
        'add_modal' => [
            'placeholder' => '例: XXXX-XXXX-XXXX-XXXX',
            'help' => '購入時にお客様に割り当てられる一意のライセンスコードを入力してください。',
        ],
        'generate_modal' => [
            'title' => 'ライセンスコードを生成',
            'quantity' => '数量',
            'format' => '形式',
            'custom_pattern' => 'カスタムパターン',
            'pattern_help' => '# は数字、A は大文字、a は小文字を使用',
            'generate' => '生成',
        ],
        'errors' => [
            'feature_not_enabled' => 'ライセンスコード機能が有効になっていません。Eコマース設定 > デジタル商品で有効にしてください。',
            'digital_products_not_enabled' => 'デジタル商品が有効になっていません。先にデジタル商品サポートを有効にしてください。',
            'product_not_found' => '商品が見つかりません。',
            'not_digital_product' => 'ライセンスコードはデジタル商品のみで利用できます。この商品は物理商品として設定されています。',
            'license_codes_not_enabled_for_product' => 'この商品のライセンスコード管理が有効になっていません。商品設定で「商品購入後にライセンスコードを生成」を有効にしてください。',
            'cannot_add_codes_auto_generate' => '自動生成に設定された商品には手動でライセンスコードを追加できません。まずライセンスコードタイプを「リストから選択」に変更してください。',
            'cannot_generate_codes_auto_generate' => '自動生成に設定された商品には手動でライセンスコードを生成できません。まずライセンスコードタイプを「リストから選択」に変更してください。',
        ],
        'bulk_delete' => [
            'button' => '選択を削除',
            'selected' => '選択済み',
            'confirm' => '選択したライセンスコードを削除してもよろしいですか？',
            'deleted_successfully' => ':count件のライセンスコードを削除しました。',
            'skipped_used_codes' => ':count件の使用済みコードがスキップされました。',
            'no_deletable_codes' => '削除可能なライセンスコードが見つかりません。使用済みコードは削除できません。',
        ],
        'import' => [
            'name' => '商品ライセンスコードをインポート',
            'description' => 'CSV/Excelファイルからデジタル商品のライセンスコードをインポートします。',
            'button' => 'インポート',
            'columns' => [
                'product_id' => '商品IDまたはSKU',
                'license_code' => 'ライセンスコード',
            ],
        ],
        'copied' => 'ライセンスコードをクリップボードにコピーしました！',
    ],
    'this_action_will_reload_page' => 'このアクションはページを再読み込みしてデータを更新します！',
    'select' => '選択',
    'clear_filters' => 'フィルターをクリア',
    'set_this_variant_as_default' => 'このバリエーションをデフォルトに設定',
    'download' => 'ダウンロード',
    'external_link_downloads' => '外部リンク',
    'download_available_when_completed' => '注文が完了するとダウンロードリンクが利用可能になります。',
    'cross_sell_price_type' => [
        'title' => '価格タイプ',
        'fixed' => '固定',
        'percent' => 'パーセント',
    ],
    'cross_sell_help' => [
        'price' => '* 価格フィールド',
        'price_description' => '元の価格から減額したい金額を入力してください。例: 元の価格が$100の場合、20を入力すると価格が$80になります。',
        'type' => '* タイプフィールド',
        'type_description' => '割引タイプを選択してください: 固定（特定の金額を減額）またはパーセント（パーセンテージで減額）。',
    ],
    'up_sell_price_type' => [
        'title' => '価格タイプ',
        'fixed' => '固定',
        'percent' => 'パーセント',
    ],
    'up_sell_help' => [
        'price' => '* 価格フィールド',
        'price_description' => '元の価格から減額したい金額を入力してください。例: 元の価格が$100の場合、20を入力すると価格が$80になります。',
        'type' => '* タイプフィールド',
        'type_description' => '割引タイプを選択してください: 固定（特定の金額を減額）またはパーセント（パーセンテージで減額）。',
    ],
    'up_sale' => [
        'title' => 'まとめ買いでお得',
        'description' => 'これらの商品を一緒に購入すると特別割引が適用されます',
        'unlock_discount' => ':productをカートに追加してバンドル割引を解除',
        'multiple_options' => '複数のオプション',
        'multiple_options_available' => '複数のオプションが利用可能',
        'select' => '選択',
        'selected_items_total' => '選択した商品の合計:',
        'add_selected_to_cart' => '選択した商品をカートに追加',
        'bundle_discount_with' => ':productとのバンドル割引',
        'bundle_with' => ':productとのバンドル',
    ],
    'cross_sale' => [
        'title' => '一緒によく購入される商品',
        'description' => 'この商品を見たお客様はこちらも購入しています',
    ],
    'apply_for_all_variations' => 'すべてのバリエーションに適用',
    'export' => [
        'description' => '商品データをCSVまたはExcelファイルにエクスポートします。',
        'total_items' => '合計アイテム数',
        'total_products' => '合計商品数',
        'total_variations' => '合計バリエーション数',
        'advanced_options' => '詳細オプション',
        'use_chunked_export' => 'チャンクエクスポートを使用',
        'use_chunked_export_helper' => '大規模なデータセットを効率的に処理するためにデータをチャンクで処理',
        'include_variations' => '商品バリエーションを含める',
        'include_variations_helper' => 'メイン商品と一緒に商品バリエーションをエクスポート',
        'optimize_memory' => 'メモリ使用量を最適化',
        'optimize_memory_helper' => '非常に大きなエクスポートのためにメモリ最適化を有効にする',
        'chunk_size' => 'チャンクサイズ',
        'chunk_size_helper' => '一度に処理する商品数（50-5000）',
        'use_streaming' => 'ストリーミングエクスポートを使用',
        'use_streaming_helper' => '非常に大きなデータセットにはストリーミングを有効にする（10,000アイテム以上で自動的に有効）',
        'large_dataset_warning_title' => '大規模な商品カタログを検出',
        'large_dataset_warning_message' => 'カタログには:count件のアイテムがあります。サイズが大きいため、一部のエクスポートオプションは最適なパフォーマンスのために最適化されています。',
        'large_dataset_specific_message' => ':count件の商品には、ストリーミングを有効にしたCSV形式を使用してください。システムは、タイムアウトやメモリの問題なく、大規模な商品カタログを効率的に処理できるようになりました。',
        'format_label' => '形式',
        'csv_recommended' => 'CSV（必須）',
        'chunk_label' => '処理',
        'chunk_recommended' => '300商品/バッチ',
        'time_label' => '推定時間',
        'time_estimate' => '1-3分',
        'pro_tip' => 'プロのヒント:',
        'pro_tip_message' => 'ブラウザに読み込みインジケーターが表示されていても、エクスポートは続行されます。開始すると、ダウンロードが自動的に開始されます。',
        'large_dataset_tip_1' => 'Excel形式は無効になっています - より高速で信頼性の高いエクスポートにはCSV形式を使用してください',
        'large_dataset_tip_2' => 'タイムアウトを防ぐためにストリーミングモードが自動的に有効になりました',
        'large_dataset_tip_3' => 'エクスポート処理はサーバーによって1-3分かかる場合があります',
        'large_dataset_recommendation' => '推奨: 最適なパフォーマンスのために、チャンクサイズ200-500のCSV形式を使用してください。',
        'excel_disabled_for_large_export' => '10,000アイテム以上のカタログではExcel形式は利用できません',
        'streaming_auto_enabled' => '大規模なデータセットで最適なパフォーマンスを得るために、ストリーミングモードが自動的に有効になりました。',
        'streaming_enabled_title' => '大規模エクスポート用に最適化',
        'streaming_enabled_message' => 'メモリの問題なくスムーズにエクスポートするために、ストリーミングモードがアクティブです。',
        'use_multi_file' => 'マルチファイルエクスポートを使用',
        'use_multi_file_helper' => '非常に大きなデータセットの場合、エクスポートをZIPにパッケージ化された複数のファイルに分割',
        'multi_file_enabled_title' => 'マルチファイルエクスポートが有効',
        'multi_file_enabled_message' => 'エクスポートは最適なパフォーマンスのためにZIPにパッケージ化された:count件のファイルに分割されます。',
        'records_per_file' => 'ファイルあたりのレコード数',
        'records_per_file_helper' => 'マルチファイルエクスポート使用時の各ファイルのレコード数',
        'estimated_files' => '推定ファイル数',
        'recommended_range' => '推奨範囲',
        'range_large_export' => '200-500アイテム',
        'range_medium_export' => '300-800アイテム',
        'range_small_export' => '500-1000アイテム',
        'export_progress' => 'エクスポート進捗',
        'preparing_export' => 'エクスポートを準備中...',
        'items_processed' => ':count件のアイテムを処理しました',
        'estimated_time_calculating' => '推定時間: 計算中...',
        'medium_dataset_detected' => '中規模データセットを検出',
        'medium_dataset_message' => ':count件の商品をエクスポートしています。より良いパフォーマンスのためにチャンクエクスポートの使用を検討してください。',
        'optimal_range' => '最適範囲',
        'too_small_slow' => '小さすぎる - 遅くなる可能性があります',
        'too_large_timeouts' => '大きすぎる - タイムアウトする可能性があります',
        'excel_disabled_warning' => '大規模エクスポート（:count件のアイテム）ではExcel形式が無効です',
        'starting_export' => 'エクスポートを開始...',
        'processing_data' => 'データを処理中...',
        'finalizing_export' => 'エクスポートを完了中...',
        'items_processed_suffix' => '件のアイテムを処理しました',
        'estimated_time_prefix' => '推定時間:',
        'seconds_remaining' => '秒残り',
        'export_completed' => 'エクスポートが完了しました！',
        'download_starting' => 'ダウンロードを開始...',
    ],
    'import' => [
        'description' => 'CSVまたはExcelファイルから商品データをインポートします。',
        'rules' => [
            'in' => ':attributeは定義された値のいずれかである必要があります: :values。',
            'required_string_max' => ':attributeは必須で、最大:max文字の文字列である必要があります。',
            'nullable_string' => ':attributeは空のままにするか、指定する場合は文字列である必要があります。',
            'nullable_string_max' => ':attributeは空のままにするか、指定する場合は最大:max文字の文字列である必要があります',
            'nullable_bool' => ':attributeは空のままにするか、指定する場合はブール値である必要があります。',
            'nullable_numeric_min' => ':attributeは空のままにするか、指定する場合は0以上の数値である必要があります。',
            'nullable_numeric_min_max' => ':attributeは空のままにするか、指定する場合は:minから:maxの間の数値である必要があります。',
            'nullable_array' => ':attributeは空のままにするか、指定する場合は配列として提供する必要があります。',
            'nullable_date_required_if' => ':attributeは空のままにするか、指定する場合は有効な日付である必要があります。:requiredが指定されている場合は必須です。',
            'nullable_date_after' => ':attributeは空のままにするか、指定する場合は:after以降の有効な日付である必要があります。',
        ],
        'updated_message' => ':count件の商品を更新しました！',
    ],
    'import_products_intro' => 'またはCSV/Excelから商品をインポート',
    'select_attributes' => 'バリエーションを作成する属性を選択:',
    'all' => 'すべて',
    'copy' => 'コピー',
    'product_translations' => '商品翻訳',
    'view' => '商品を表示 - :name',
    'product_information' => '商品情報',
    'total_views' => '総閲覧数',
    'total_orders' => '完了した注文',
    'total_sold' => '総販売数',
    'total_revenue' => '総収益',
    'pending_orders' => '保留中の注文',
    'pending_revenue' => '保留中の収益',
    'conversion_rate' => 'コンバージョン率',
    'total_reviews' => '総レビュー数',
    'average_rating' => '平均評価',
    'views_by_date' => '日付別閲覧数（過去30日間）',
    'recent_orders' => '最近の注文',
    'no_views_data' => '過去30日間の閲覧データはありません。',
    'no_orders' => 'まだ注文はありません。',
    'date' => '日付',
    'views' => '閲覧数',
    'total' => '合計',
    'view_on_frontend' => 'フロントエンドで表示',
    'select_attribute' => ':nameを選択',
    'all_categories' => 'すべてのカテゴリ',
    'brands' => 'ブランド',
    'browse_products' => '商品を閲覧',
    'sku_1' => 'SKU:',
    'select_products_to_return' => '返品する商品を選択',
    'show_only_discounted_products' => '割引商品のみ表示',
    'specification' => '仕様',
    'download_product_with_external_links' => '外部リンク付きの商品「:name」をダウンロード',
    'number_product_available_singular' => ':number件の商品が利用可能',
    'number_products_available_plural' => ':number件の商品が利用可能',
    'cart' => [
        'added_to_cart_success' => ':productをカートに追加しました。',
        'removed_from_cart_success' => ':productをカートから削除しました。',
        'updated_cart_success' => 'カートを更新しました。',
        'item_not_found' => 'このアイテムはカートにありません。',
        'out_of_stock' => '申し訳ありません、:productは現在在庫切れです。',
        'max_quantity' => '最大:max個まで追加できます。',
        'max_quantity_detail' => '申し訳ありません、:productは一度に最大:quantity個まで注文できます。',
        'select_options' => 'カートに追加する前に商品オプションを選択してください。',
        'product_out_of_stock' => '申し訳ありません、この商品は現在在庫切れです。',
        'product_not_exists' => 'この商品は在庫切れか、もう存在しません。',
        'not_enough_quantity' => '一部の商品は更新するのに十分な在庫がありません。',
        'empty_success' => 'カートを空にしました。',
        'bundle_item_already_in_cart' => 'このバンドルアイテムは既にカートにあります。バンドル割引につき1アイテムのみ許可されています。',
    ],
    'wishlist' => [
        'added_success' => ':productをお気に入りに追加しました。',
        'removed_success' => ':productをお気に入りから削除しました。',
        'product_not_found' => 'この商品が見つかりませんでした。',
        'product_not_in_wishlist' => 'この商品はお気に入りに入っていません。',
        'product_not_available' => 'この商品は利用できません。',
    ],
    'compare' => [
        'added_success' => ':productを比較リストに追加しました。',
        'removed_success' => ':productを比較リストから削除しました。',
        'product_not_found' => 'この商品が見つかりませんでした。',
        'product_not_in_compare' => 'この商品は比較リストに入っていません。',
        'already_in_list' => ':productは既に比較リストに入っています。',
    ],
];
