<?php

return [
    'name' => 'Prodotti',
    'description' => 'Gestisci prodotti fisici e digitali con inventario, prezzi e varianti',
    'create' => 'Nuovo prodotto',
    'create_product_type' => [
        'physical' => 'Nuovo prodotto fisico',
        'digital' => 'Nuovo prodotto digitale',
    ],
    'edit' => 'Modifica prodotto - :name',
    'form' => [
        'name' => 'Nome',
        'name_placeholder' => 'Nome del prodotto (Massimo 120 caratteri)',
        'description' => 'Descrizione',
        'description_placeholder' => 'Breve descrizione del prodotto (Massimo 400 caratteri)',
        'categories' => 'Categorie',
        'content' => 'Contenuto',
        'price' => 'Prezzo',
        'currency' => 'Valuta',
        'currency_for_variations_hint' => 'Questa valuta verrà applicata a tutte le varianti di questo prodotto.',
        'quantity' => 'Quantità',
        'brand' => 'Marchio',
        'width' => 'Larghezza',
        'height' => 'Altezza',
        'weight' => 'Peso',
        'date' => [
            'start' => 'Data inizio',
            'end' => 'Data fine',
        ],
        'image' => 'Immagini',
        'collections' => 'Collezioni prodotti',
        'labels' => 'Etichette',
        'price_sale' => 'Prezzo scontato',
        'product_type' => [
            'title' => 'Tipo prodotto',
        ],
        'product' => 'Prodotto',
        'total' => 'Totale',
        'sub_total' => 'Subtotale',
        'shipping_fee' => 'Costo spedizione',
        'discount' => 'Sconto',
        'options' => 'Opzioni',
        'shipping' => [
            'height' => 'Altezza',
            'length' => 'Lunghezza',
            'title' => 'Spedizione',
            'weight' => 'Peso',
            'wide' => 'Larghezza',
        ],
        'barcode' => 'Codice a barre (ISBN, UPC, GTIN, ecc.) ',
        'barcode_placeholder' => 'Inserisci codice a barre',
        'cost_per_item' => 'Costo per articolo',
        'cost_per_item_placeholder' => 'Inserisci costo per articolo',
        'cost_per_item_helper' => 'I clienti non vedranno questo prezzo.',
        'price_includes_tax' => 'Il prezzo include le tasse',
        'price_includes_tax_helper' => 'Seleziona questa opzione se il prezzo inserito include già le tasse. Il sistema calcolerà il prezzo base rimuovendo l\'importo delle tasse.',
        'stock' => [
            'allow_order_when_out' => 'Permetti al cliente di acquistare quando questo prodotto è esaurito',
            'in_stock' => 'Disponibile',
            'out_stock' => 'Esaurito',
            'title' => 'Stato scorte',
        ],
        'storehouse' => [
            'no_storehouse' => 'Nessuna gestione magazzino',
            'storehouse' => 'Con gestione magazzino',
            'title' => 'Magazzino',
            'quantity' => 'Quantità',
        ],
        'tax' => 'Tassa',
        'taxes' => 'Tasse',
        'taxes_helper' => 'L\'aliquota fiscale predefinita è configurata in <a href=":url">Impostazioni -> Tasse</a>. Se non viene selezionata alcuna tassa specifica per questo prodotto, verrà applicata l\'aliquota predefinita. Per disabilitare la tassa per questo prodotto, rimuovi l\'aliquota fiscale predefinita dalle impostazioni fiscali.',
        'is_default' => 'È predefinito',
        'action' => 'Azione',
        'restock_quantity' => 'Quantità rifornimento',
        'remain' => 'Rimanente',
        'choose_discount_period' => 'Scegli Periodo Sconto',
        'cancel' => 'Annulla',
        'no_results' => 'Nessun risultato!',
        'value' => 'Valore',
        'attribute_name' => 'Nome attributo',
        'add_more_attribute' => 'Aggiungi più attributi',
        'continue' => 'Continua',
        'add_new_attributes' => 'Aggiungi nuovi attributi',
        'add_new_attributes_description' => 'Aggiungere nuovi attributi aiuta il prodotto ad avere molte opzioni, come taglia o colore.',
        'create_product_variations' => ':link per creare variazioni prodotto!',
        'tags' => 'Tag',
        'write_some_tags' => 'Scrivi alcuni tag',
        'variation_existed' => 'Questa variazione esiste già.',
        'no_attributes_selected' => 'Nessun attributo selezionato!',
        'added_variation_success' => 'Variazione aggiunta con successo!',
        'updated_variation_success' => 'Variazione aggiornata con successo!',
        'created_all_variation_success' => 'Tutte le variazioni create con successo!',
        'updated_product_attributes_success' => 'Attributi prodotto aggiornati con successo!',
        'stock_status' => 'Stato scorte',
        'auto_generate_sku' => 'Genera automaticamente SKU?',
        'featured_image' => 'Immagine in evidenza (opzionale)',
        'product_id' => 'ID Prodotto',
        'price_sale_percent_helper' => 'Sconto :percent dal prezzo originale.',
        'minimum_order_quantity' => 'Quantità minima ordine',
        'minimum_order_quantity_helper' => 'Quantità minima per effettuare un ordine, se il valore è 0, non c\'è limite.',
        'maximum_order_quantity' => 'Quantità massima ordine',
        'maximum_order_quantity_helper' => 'Quantità massima per effettuare un ordine, se il valore è 0, non c\'è limite.',
        'video' => 'Video',
        'video_file' => 'File',
        'video_url' => 'O URL Video Esterno',
        'video_url_help' => 'Inserisci URL video YouTube o Vimeo',
        'enter_video_url' => 'Inserisci URL video',
        'video_thumbnail' => 'Miniatura video',
        'video_thumbnail_help' => 'Scegli una miniatura per il video. Se non selezionata, verrà automaticamente ottenuta dall\'URL del video se disponibile.',
        'barcode_existed' => 'Questo codice a barre è utilizzato da un altro prodotto. Inserisci un altro codice a barre.',
        'barcode_helper' => 'Deve essere unico per ogni prodotto.',
        'is_new_until' => 'Nuovo fino al',
        'is_new_until_helper' => 'Imposta una data fino alla quale questo prodotto sarà contrassegnato come "Nuovo". Lascia vuoto per non contrassegnare come nuovo in base alla data.',
    ],
    'price' => 'Prezzo',
    'quantity' => 'Quantità',
    'type' => 'Tipo',
    'image' => 'Miniatura',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU Variazione',
    'brand' => 'Marchio',
    'cannot_delete' => 'Il prodotto non può essere eliminato',
    'product_deleted' => 'Prodotto eliminato',
    'product' => 'Prodotto',
    'product_collections' => 'Collezioni prodotti',
    'products' => 'Prodotti',
    'total_products_found' => ':total prodotti trovati',
    'total_product_found' => ':total prodotto trovato',
    'menu' => 'Prodotti',
    'control' => [
        'button_add_image' => 'Aggiungi immagine',
    ],
    'price_sale' => 'Prezzo scontato',
    'price_group_title' => 'Gestisci prezzo prodotto',
    'store_house_group_title' => 'Gestisci magazzino',
    'shipping_group_title' => 'Gestisci spedizione',
    'overview' => 'Panoramica',
    'attributes' => 'Attributi',
    'product_has_variations' => 'Il prodotto ha variazioni',
    'manage_products' => 'Gestisci prodotti',
    'add_new_product' => 'Aggiungi un nuovo prodotto',
    'start_by_adding_new_product' => 'Inizia aggiungendo nuovi prodotti.',
    'edit_this_product' => 'Modifica questo prodotto',
    'delete' => 'Elimina',
    'related_products' => 'Prodotti correlati',
    'cross_selling_products' => 'Prodotti cross-selling',
    'up_selling_products' => 'Prodotti up-selling',
    'grouped_products' => 'Prodotti raggruppati',
    'search_products' => 'Cerca prodotti',
    'selected_products' => 'Prodotti selezionati',
    'edit_variation_item' => 'Modifica',
    'variations_box_description' => 'Clicca su "Modifica attributo" per aggiungere/rimuovere attributi della variazione o clicca su "Aggiungi nuova variazione" per aggiungere variazione.',
    'save_changes' => 'Salva modifiche',
    'continue' => 'Continua',
    'edit_attribute' => 'Modifica attributo',
    'select_attribute' => 'Seleziona attributo',
    'add_new_variation' => 'Aggiungi nuova variazione',
    'edit_variation' => 'Modifica variazione',
    'generate_variations' => 'Genera variazioni',
    'generate_variations_confirmation' => 'Sei sicuro di voler generare variazioni per questo prodotto?',
    'delete_variation' => 'Elimina variazione?',
    'delete_variation_confirmation' => 'Sei sicuro di voler eliminare questa variazione? Questa azione non può essere annullata.',
    'delete_variations_confirmation' => 'Sei sicuro di voler eliminare quelle variazioni? Questa azione non può essere annullata.',
    'product_create_validate_name_required' => 'Inserisci il nome del prodotto',
    'product_create_validate_sale_price_max' => 'Lo sconto deve essere inferiore al prezzo originale',
    'product_create_validate_cost_per_item_max' => 'Il costo per articolo deve essere inferiore al prezzo originale',
    'product_create_validate_sale_price_required_if' => 'Deve inserire uno sconto quando vuoi programmare una promozione',
    'product_create_validate_end_date_after' => 'La data di fine deve essere successiva alla data di inizio',
    'product_create_validate_start_date_required_if' => 'La data di inizio sconto non può essere lasciata vuota quando è selezionata la programmazione',
    'product_create_validate_sale_price' => 'Gli sconti non possono essere lasciati vuoti quando è selezionata la programmazione',
    'stock_statuses' => [
        'in_stock' => 'Disponibile',
        'out_of_stock' => 'Esaurito',
        'on_backorder' => 'In arretrato',
    ],
    'stock_status' => 'Stato scorte',
    'processing' => 'Elaborazione in corso...',
    'delete_selected_variations' => 'Elimina variazioni selezionate',
    'delete_variations' => 'Elimina variazioni',
    'category' => 'Categoria',
    'categories' => 'Categorie',
    'tags' => 'Tag',
    'product_price_flash_sale_warning' => 'Questo prodotto è in vendita flash <strong>:name</strong> quindi il suo prezzo è <strong>:price</strong>.',
    'product_price_discount_warning' => 'Questo prodotto è in sconto <strong>:name</strong> quindi il suo prezzo è <strong>:price</strong>.',
    'product_image' => 'Immagine prodotto',
    'product_name' => 'Nome prodotto',
    'product_link' => 'Link prodotto',
    'types' => [
        'physical' => 'Fisico',
        'digital' => 'Digitale',
    ],
    'digital_attachments' => [
        'title' => 'Allegati digitali',
        'add' => 'Aggiungi Allegato',
        'file_name' => 'Nome file',
        'file_size' => 'Dimensione file',
        'unsaved' => 'Non salvato',
        'add_external_link' => 'Aggiungi link esterno',
        'enter_file_name' => 'Inserisci nome file',
        'enter_external_link_download' => 'Inserisci link esterno download',
        'enter_file_size' => 'Inserisci dimensione file',
        'external_link_download' => 'Link esterno download',
        'generate_license_code_after_purchasing_product' => 'Abilita assegnazione codice licenza per questo prodotto',
        'notify_attachment_updated' => 'Invia email al cliente quando l\'allegato viene aggiornato',
        'no_attachments' => 'Nessun allegato ancora. Clicca i pulsanti sopra per aggiungere file.',
    ],
    'license_codes' => [
        'title' => 'Codici Licenza',
        'add' => 'Aggiungi Codice Licenza',
        'back' => 'Torna al Prodotto',
        'edit' => 'Modifica Codice Licenza',
        'generate' => 'Genera Codici',
        'manage_codes' => 'Gestisci Codici Licenza',
        'management' => 'Gestione Codici Licenza',
        'variation_breadcrumb' => 'Variazione: :name',
        'variation_label' => 'Variazione Prodotto',
        'variation_specific_note' => 'Questi codici licenza sono specifici per questa variazione prodotto. I clienti che acquistano questa variazione riceveranno codici da questo pool.',
        'main_product_note' => 'Questo prodotto ha variazioni. Ogni variazione può avere i propri codici licenza, o i clienti possono ricevere codici da questo pool prodotto principale se la variazione non ha codici.',
        'code' => 'Codice Licenza',
        'codes' => 'Codici Licenza',
        'status' => 'Stato',
        'assigned_at' => 'Assegnato Il',
        'status_available' => 'Disponibile',
        'status_used' => 'Utilizzato',
        'statuses' => [
            'available' => 'Disponibile',
            'used' => 'Utilizzato',
        ],
        'no_codes' => 'Nessun codice licenza trovato. Aggiungi alcuni codici o generali automaticamente.',
        'no_codes_warning_title' => 'Nessun Codice Licenza Disponibile!',
        'no_codes_warning_message' => 'Questo prodotto è impostato su "Scegli dalla Lista" ma non ha codici licenza disponibili. I clienti che acquistano questo prodotto riceveranno codici generati automaticamente invece. Aggiungi codici licenza per garantire la funzionalità corretta.',
        'no_codes_auto_generate' => 'Questo prodotto è impostato per generare automaticamente codici licenza. Non servono codici manuali.',
        'used_code_no_actions' => 'Codice utilizzato - nessuna azione disponibile',
        'created_successfully' => 'Codice licenza creato con successo!',
        'updated_successfully' => 'Codice licenza aggiornato con successo!',
        'deleted_successfully' => 'Codice licenza eliminato con successo!',
        'generated_successfully' => 'Generati :count codici licenza con successo!',
        'duplicates_skipped' => ':count codici duplicati sono stati saltati.',
        'generation_incomplete' => 'Attenzione: È stato possibile generare solo :generated su :requested codici richiesti a causa di conflitti di duplicazione.',
        'cannot_edit_used_code' => 'Impossibile modificare un codice licenza utilizzato.',
        'cannot_delete_used_code' => 'Impossibile eliminare un codice licenza utilizzato.',
        'show_all' => 'Mostra tutto',
        'show_less' => 'Mostra meno',
        'more' => 'altro',
        'used_codes_hidden' => ':count codice/i licenza utilizzato/i sono nascosti. Puoi visualizzare tutti i codici nella pagina Gestione Codici Licenza.',
        'low_stock_title' => 'Scorte Codici Licenza Basse',
        'low_stock_message' => 'Solo :count codici licenza rimanenti. Considera di aggiungere più codici per evitare di rimanere senza.',
        'out_of_stock_title' => 'Codici Licenza Esauriti!',
        'out_of_stock_message' => 'Nessun codice licenza disponibile. I clienti riceveranno codici generati automaticamente finché non ne aggiungi altri.',
        'type' => [
            'title' => 'Metodo Assegnazione Codice Licenza',
            'auto_generate' => 'Genera Automaticamente (Il sistema genera codici automaticamente)',
            'pick_from_list' => 'Scegli dalla Lista (Usa codici pre-inseriti)',
            'description' => 'Scegli come i codici licenza devono essere assegnati ai clienti quando acquistano questo prodotto.',
        ],
        'add_modal' => [
            'placeholder' => 'es., XXXX-XXXX-XXXX-XXXX',
            'help' => 'Inserisci un codice licenza univoco che verrà assegnato a un cliente all\'acquisto.',
        ],
        'generate_modal' => [
            'title' => 'Genera Codici Licenza',
            'quantity' => 'Quantità',
            'format' => 'Formato',
            'custom_pattern' => 'Modello Personalizzato',
            'pattern_help' => 'Usa # per numeri, A per lettere maiuscole, a per lettere minuscole',
            'generate' => 'Genera',
        ],
        'errors' => [
            'feature_not_enabled' => 'La funzione codici licenza non è abilitata. Abilitala in Impostazioni Ecommerce > Prodotti Digitali.',
            'digital_products_not_enabled' => 'I prodotti digitali non sono abilitati. Abilita prima il supporto prodotti digitali.',
            'product_not_found' => 'Prodotto non trovato.',
            'not_digital_product' => 'I codici licenza sono disponibili solo per prodotti digitali. Questo prodotto è impostato come prodotto fisico.',
            'license_codes_not_enabled_for_product' => 'La gestione codici licenza non è abilitata per questo prodotto. Abilita "Genera codice licenza dopo l\'acquisto del prodotto" nelle impostazioni prodotto.',
            'cannot_add_codes_auto_generate' => 'Impossibile aggiungere manualmente codici licenza a prodotti impostati per generazione automatica. Cambia prima il tipo codice licenza a "Scegli dalla Lista".',
            'cannot_generate_codes_auto_generate' => 'Impossibile generare manualmente codici licenza per prodotti impostati per generazione automatica. Cambia prima il tipo codice licenza a "Scegli dalla Lista".',
        ],
        'bulk_delete' => [
            'button' => 'Elimina Selezionati',
            'selected' => 'selezionati',
            'confirm' => 'Sei sicuro di voler eliminare i codici licenza selezionati?',
            'deleted_successfully' => 'Eliminati con successo :count codice/i licenza.',
            'skipped_used_codes' => ':count codice/i utilizzato/i sono stati saltati.',
            'no_deletable_codes' => 'Nessun codice licenza disponibile da eliminare. I codici utilizzati non possono essere eliminati.',
        ],
        'import' => [
            'name' => 'Importa Codici Licenza Prodotto',
            'description' => 'Importa codici licenza per prodotti digitali da file CSV/Excel.',
            'button' => 'Importa',
            'columns' => [
                'product_id' => 'ID Prodotto o SKU',
                'license_code' => 'Codice Licenza',
            ],
        ],
        'copied' => 'Codice licenza copiato negli appunti!',
    ],
    'this_action_will_reload_page' => 'Questa azione ricaricherà la pagina per aggiornare i dati!',
    'select' => 'Seleziona',
    'clear_filters' => 'Cancella filtri',
    'set_this_variant_as_default' => 'Imposta questa variante come predefinita',
    'download' => 'Scarica',
    'external_link_downloads' => 'Link esterni',
    'download_available_when_completed' => 'I link per il download saranno disponibili quando l\'ordine sarà completato.',
    'cross_sell_price_type' => [
        'title' => 'Tipo prezzo',
        'fixed' => 'Fisso',
        'percent' => 'Percentuale',
    ],
    'cross_sell_help' => [
        'price' => '* Campo prezzo',
        'price_description' => 'Inserisci l\'importo che vuoi ridurre dal prezzo originale. Esempio: Se il prezzo originale è €100, inserisci 20 per ridurre il prezzo a €80.',
        'type' => '* Campo tipo',
        'type_description' => 'Scegli il tipo di sconto: Fisso (riduci un importo specifico) o Percentuale (riduci di una percentuale).',
    ],
    'up_sell_price_type' => [
        'title' => 'Tipo prezzo',
        'fixed' => 'Fisso',
        'percent' => 'Percentuale',
    ],
    'up_sell_help' => [
        'price' => '* Campo prezzo',
        'price_description' => 'Inserisci l\'importo che vuoi ridurre dal prezzo originale. Esempio: Se il prezzo originale è €100, inserisci 20 per ridurre il prezzo a €80.',
        'type' => '* Campo tipo',
        'type_description' => 'Scegli il tipo di sconto: Fisso (riduci un importo specifico) o Percentuale (riduci di una percentuale).',
    ],
    'up_sale' => [
        'title' => 'Acquista Insieme e Risparmia',
        'description' => 'Ottieni sconti speciali acquistando questi articoli insieme',
        'unlock_discount' => 'Aggiungi :product al carrello per sbloccare lo sconto bundle',
        'multiple_options' => 'Opzioni multiple',
        'multiple_options_available' => 'Opzioni multiple disponibili',
        'select' => 'Seleziona',
        'selected_items_total' => 'Totale articoli selezionati:',
        'add_selected_to_cart' => 'Aggiungi Selezionati al Carrello',
        'bundle_discount_with' => 'Sconto bundle con :product',
        'bundle_with' => 'Bundle con :product',
    ],
    'cross_sale' => [
        'title' => 'Spesso Acquistati Insieme',
        'description' => 'I clienti che hanno visualizzato questo articolo hanno anche acquistato',
    ],
    'apply_for_all_variations' => 'Applica a tutte le variazioni',
    'export' => [
        'description' => 'Esporta i dati dei tuoi prodotti in file CSV o Excel.',
        'total_items' => 'Articoli Totali',
        'total_products' => 'Prodotti Totali',
        'total_variations' => 'Variazioni Totali',
        'advanced_options' => 'Opzioni Avanzate',
        'use_chunked_export' => 'Usa esportazione frammentata',
        'use_chunked_export_helper' => 'Elabora dati in blocchi per gestire grandi dataset efficientemente',
        'include_variations' => 'Includi variazioni prodotto',
        'include_variations_helper' => 'Esporta variazioni prodotto insieme ai prodotti principali',
        'optimize_memory' => 'Ottimizza uso memoria',
        'optimize_memory_helper' => 'Abilita ottimizzazione memoria per esportazioni molto grandi',
        'chunk_size' => 'Dimensione blocco',
        'chunk_size_helper' => 'Numero di prodotti da elaborare alla volta (50-5000)',
        'use_streaming' => 'Usa esportazione streaming',
        'use_streaming_helper' => 'Abilita streaming per dataset molto grandi (abilitato automaticamente per >10.000 articoli)',
        'large_dataset_warning_title' => 'Rilevato Catalogo Prodotti Grande',
        'large_dataset_warning_message' => 'Il tuo catalogo contiene :count articoli. A causa delle grandi dimensioni, alcune opzioni di esportazione sono state ottimizzate per le migliori prestazioni.',
        'large_dataset_specific_message' => 'Per i tuoi :count prodotti, usa formato CSV con streaming abilitato. Il sistema ora può gestire il tuo grande catalogo prodotti efficientemente senza timeout o problemi di memoria.',
        'format_label' => 'Formato',
        'csv_recommended' => 'CSV (Richiesto)',
        'chunk_label' => 'Elaborazione',
        'chunk_recommended' => '300 prodotti/batch',
        'time_label' => 'Tempo Stimato',
        'time_estimate' => '1-3 minuti',
        'pro_tip' => 'Suggerimento Pro:',
        'pro_tip_message' => 'L\'esportazione continuerà a funzionare anche se il tuo browser mostra un indicatore di caricamento. Una volta avviato, il download inizierà automaticamente.',
        'large_dataset_tip_1' => 'Il formato Excel è stato disabilitato - usa formato CSV per esportazioni più veloci e affidabili',
        'large_dataset_tip_2' => 'La modalità streaming è stata abilitata automaticamente per prevenire timeout',
        'large_dataset_tip_3' => 'Il processo di esportazione può richiedere 1-3 minuti a seconda del tuo server',
        'large_dataset_recommendation' => 'Raccomandato: Usa formato CSV con dimensione blocco 200-500 per prestazioni ottimali.',
        'excel_disabled_for_large_export' => 'Formato Excel non disponibile per cataloghi oltre 10.000 articoli',
        'streaming_auto_enabled' => 'La modalità streaming è stata abilitata automaticamente per prestazioni ottimali con grandi dataset.',
        'streaming_enabled_title' => 'Ottimizzato per Esportazione Grande',
        'streaming_enabled_message' => 'La modalità streaming è attiva per garantire esportazione fluida senza problemi di memoria.',
        'use_multi_file' => 'Usa esportazione multi-file',
        'use_multi_file_helper' => 'Dividi l\'esportazione in più file compressi in un ZIP per dataset molto grandi',
        'multi_file_enabled_title' => 'Esportazione Multi-File Abilitata',
        'multi_file_enabled_message' => 'La tua esportazione sarà divisa in :count file compressi in un ZIP per prestazioni ottimali.',
        'records_per_file' => 'Record per File',
        'records_per_file_helper' => 'Numero di record in ciascun file quando si utilizza l\'esportazione multi-file',
        'estimated_files' => 'File Stimati',
        'recommended_range' => 'Intervallo raccomandato',
        'range_large_export' => '200-500 articoli',
        'range_medium_export' => '300-800 articoli',
        'range_small_export' => '500-1000 articoli',
        'export_progress' => 'Progresso Esportazione',
        'preparing_export' => 'Preparazione esportazione...',
        'items_processed' => ':count articoli elaborati',
        'estimated_time_calculating' => 'Tempo stimato: calcolo in corso...',
        'medium_dataset_detected' => 'Rilevato Dataset Medio',
        'medium_dataset_message' => 'Stai esportando :count prodotti. Considera di usare esportazione frammentata per migliori prestazioni.',
        'optimal_range' => 'Intervallo ottimale',
        'too_small_slow' => 'Troppo piccolo - potrebbe essere lento',
        'too_large_timeouts' => 'Troppo grande - potrebbe causare timeout',
        'excel_disabled_warning' => 'Formato Excel disabilitato per grandi esportazioni (:count articoli)',
        'starting_export' => 'Avvio Esportazione...',
        'processing_data' => 'Elaborazione dati...',
        'finalizing_export' => 'Finalizzazione esportazione...',
        'items_processed_suffix' => 'articoli elaborati',
        'estimated_time_prefix' => 'Tempo stimato:',
        'seconds_remaining' => 's rimanenti',
        'export_completed' => 'Esportazione completata!',
        'download_starting' => 'Download in avvio...',
    ],
    'import' => [
        'description' => 'Importa i dati dei tuoi prodotti da file CSV o Excel.',
        'rules' => [
            'in' => ':attribute deve essere uno dei valori definiti: :values.',
            'required_string_max' => ':attribute è obbligatorio e deve essere una stringa con lunghezza massima di :max caratteri.',
            'nullable_string' => ':attribute può essere lasciato vuoto o deve essere una stringa se fornito.',
            'nullable_string_max' => ':attribute può essere lasciato vuoto o deve essere una stringa con lunghezza massima di :max caratteri se fornito',
            'nullable_bool' => 'Se :attribute può essere lasciato vuoto o deve essere un valore booleano se fornito.',
            'nullable_numeric_min' => ':attribute può essere lasciato vuoto o deve essere un numero non negativo se fornito.',
            'nullable_numeric_min_max' => ':attribute può essere lasciato vuoto o deve essere un numero tra :min e :max se fornito.',
            'nullable_array' => ':attribute può essere lasciato vuoto o deve essere fornito come array se specificato.',
            'nullable_date_required_if' => ':attribute può essere lasciato vuoto o deve essere una data valida se fornito, obbligatorio se :required è specificato.',
            'nullable_date_after' => ':attribute può essere lasciato vuoto o deve essere una data valida dopo :after se fornito.',
        ],
        'updated_message' => 'Aggiornati :count prodotti con successo!',
    ],
    'import_products_intro' => 'O importa prodotti da CSV/Excel',
    'select_attributes' => 'Seleziona attributi per creare variazioni:',
    'all' => 'Tutto',
    'copy' => 'Copia',
    'product_translations' => 'Traduzioni Prodotto',
    'view' => 'Visualizza prodotto - :name',
    'product_information' => 'Informazioni sul Prodotto',
    'total_views' => 'Visualizzazioni Totali',
    'total_orders' => 'Ordini Completati',
    'total_sold' => 'Totale Venduto',
    'total_revenue' => 'Ricavo Totale',
    'pending_orders' => 'Ordini in Sospeso',
    'pending_revenue' => 'Entrate in Sospeso',
    'conversion_rate' => 'Tasso di Conversione',
    'total_reviews' => 'Recensioni Totali',
    'average_rating' => 'Valutazione Media',
    'views_by_date' => 'Visualizzazioni per Data (Ultimi 30 Giorni)',
    'recent_orders' => 'Ordini Recenti',
    'no_views_data' => 'Nessun dato di visualizzazione disponibile per gli ultimi 30 giorni.',
    'no_orders' => 'Nessun ordine ancora.',
    'date' => 'Data',
    'views' => 'Visualizzazioni',
    'total' => 'Totale',
    'view_on_frontend' => 'Visualizza sul Frontend',
    'select_attribute' => 'Seleziona :name',
    'all_categories' => 'Tutte le categorie',
    'brands' => 'Marchi',
    'browse_products' => 'Sfoglia Prodotti',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Seleziona Prodotti da Restituire',
    'show_only_discounted_products' => 'Mostra solo prodotti scontati',
    'specification' => 'Specifiche',
    'download_product_with_external_links' => 'Scarica prodotto ":name" con link esterni',
    'number_product_available_singular' => ':number prodotto disponibile',
    'number_products_available_plural' => ':number prodotti disponibili',
    'cart' => [
        'added_to_cart_success' => ':product è stato aggiunto al carrello.',
        'removed_from_cart_success' => ':product è stato rimosso dal carrello.',
        'updated_cart_success' => 'Il tuo carrello è stato aggiornato.',
        'item_not_found' => 'Questo articolo non è più nel tuo carrello.',
        'out_of_stock' => 'Spiacenti, :product è attualmente esaurito.',
        'max_quantity' => 'Puoi aggiungere al massimo :max articoli.',
        'max_quantity_detail' => 'Spiacenti, puoi ordinare solo :quantity unità di :product alla volta.',
        'select_options' => 'Seleziona le opzioni del prodotto prima di aggiungere al carrello.',
        'product_out_of_stock' => 'Spiacenti, questo prodotto è attualmente esaurito.',
        'product_not_exists' => 'Questo prodotto è esaurito o non esiste più.',
        'not_enough_quantity' => 'Alcuni prodotti non hanno scorte sufficienti per l\'aggiornamento.',
        'empty_success' => 'Il tuo carrello è stato svuotato.',
        'bundle_item_already_in_cart' => 'Questo articolo bundle è già nel tuo carrello. È consentito solo 1 articolo per sconto bundle.',
    ],
    'wishlist' => [
        'added_success' => ':product è stato aggiunto alla tua lista dei desideri.',
        'removed_success' => ':product è stato rimosso dalla tua lista dei desideri.',
        'product_not_found' => 'Questo prodotto non è stato trovato.',
        'product_not_in_wishlist' => 'Questo prodotto non è nella tua lista dei desideri.',
        'product_not_available' => 'Questo prodotto non è disponibile.',
    ],
    'compare' => [
        'added_success' => ':product è stato aggiunto alla tua lista di confronto.',
        'removed_success' => ':product è stato rimosso dalla tua lista di confronto.',
        'product_not_found' => 'Questo prodotto non è stato trovato.',
        'product_not_in_compare' => 'Questo prodotto non è nella tua lista di confronto.',
        'already_in_list' => ':product è già nella tua lista di confronto.',
    ],
];
