<?php

return [
    'save_settings' => 'Guardar configuración',
    'ecommerce' => 'Comercio electrónico',
    'general' => [
        'name' => 'General',
        'description' => 'Nombre de tienda, info de empresa, contacto y correos de notificación admin',
    ],
    'currency' => [
        'name' => 'Monedas',
        'description' => 'Formatos de moneda, tipos de cambio, detección automática y separadores decimales/miles',
        'currency_setting_description' => 'Ver y actualizar monedas utilizadas en el sitio web',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Habilitar detección automática de moneda del visitante',
            'enable_auto_detect_visitor_currency_helper' => 'Detectar automáticamente y mostrar precios en la moneda local del visitante según su ubicación. Esto proporciona una experiencia de compra más personalizada.',
            'add_space_between_price_and_currency' => 'Agregar un espacio entre precio y moneda',
            'add_space_between_price_and_currency_helper' => 'Cuando está habilitado, agrega un espacio entre el valor del precio y el símbolo de moneda (p. ej., \"100 USD\" en lugar de \"100USD\").',
            'thousands_separator' => 'Separador de miles',
            'thousands_separator_helper' => 'Elija el carácter para separar miles en la visualización del precio (p. ej., 1,000 o 1.000 o 1 000).',
            'decimal_separator' => 'Separador decimal',
            'decimal_separator_helper' => 'Elija el carácter para separar valores decimales en los precios (p. ej., 10.99 o 10,99).',
            'separator_period' => 'Punto (.)',
            'separator_comma' => 'Coma (,)',
            'separator_space' => 'Espacio ( )',
            'api_key' => 'Clave API de tipos de cambio',
            'api_key_helper' => 'Obtén la clave API de tipos de cambio en :link',
            'update_currency_rates' => 'Actualizar tipos de cambio',
            'use_exchange_rate_from_api' => 'Usar tipo de cambio de API',
            'use_exchange_rate_from_api_helper' => 'Habilitar actualizaciones automáticas del tipo de cambio de moneda desde el proveedor de API configurado. Esto garantiza que sus precios estén siempre actualizados con las tasas actuales del mercado.',
            'clear_cache_rates' => 'Limpiar caché de tipos',
            'auto_detect_visitor_currency_description' => 'Detecta la moneda del visitante basada en el idioma del navegador. Anulará la selección de moneda predeterminada.',
            'exchange_rate' => [
                'api_provider' => 'Proveedor de API',
                'select' => '-- Seleccionar --',
                'none' => 'Ninguno',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'ID de aplicación Open Exchange Rates',
            ],
            'default_currency_warning' => 'Para la moneda predeterminada, el tipo de cambio debe ser 1.',
        ],
    ],
    'product' => [
        'name' => 'Productos',
        'description' => 'Visualización de stock, generación de SKU, imágenes de variantes, productos relacionados y especificaciones',
        'product_settings' => 'Configuración de producto',
        'product_settings_description' => 'Configurar reglas para producto',
        'form' => [
            'show_number_of_products' => 'Mostrar número de productos en la página individual del producto',
            'show_number_of_products_helper' => 'Mostrar el número total de productos en la página de detalle del producto.',
            'show_out_of_stock_products' => 'Mostrar productos agotados',
            'show_out_of_stock_products_helper' => 'Si está habilitado, los productos agotados se mostrarán en la página de listado de productos.',
            'how_to_display_product_variation_images' => 'Cómo mostrar imágenes de variaciones de producto',
            'how_to_display_product_variation_images_helper' => 'Elige si mostrar solo imágenes específicas de variación o incluir tanto imágenes de variación como del producto principal.',
            'only_variation_images' => 'Solo imágenes de variación',
            'variation_images_and_main_product_images' => 'Imágenes de variación e imágenes del producto principal',
            'enable_product_options' => 'Habilitar opciones de producto',
            'enable_product_options_helper' => 'Permitir que los productos tengan opciones personalizables como tamaño, color, etc.',
            'is_enabled_cross_sale_products' => 'Habilitar productos de venta cruzada',
            'is_enabled_cross_sale_products_helper' => 'Mostrar sugerencias de productos de venta cruzada para fomentar compras adicionales.',
            'is_enabled_related_products' => 'Habilitar productos relacionados',
            'is_enabled_related_products_helper' => 'Mostrar productos relacionados basados en categoría, o seleccionados por el administrador en el formulario de producto.',
            'related_products_source' => 'Fuente de productos relacionados',
            'related_products_source_helper' => 'Cuando el administrador no selecciona productos relacionados en el formulario de producto, mostrar productos relacionados basados en esta fuente.',
            'related_products_source_category' => 'Misma categoría',
            'related_products_source_brand' => 'Misma marca',
            'trending_products_period' => 'Período de productos en tendencia',
            'trending_products_period_helper' => 'Selecciona el período de tiempo a considerar para calcular productos en tendencia basado en el número de visualizaciones.',
            'trending_products_period_1_day' => 'Últimas 24 horas',
            'trending_products_period_3_days' => 'Últimos 3 días',
            'trending_products_period_7_days' => 'Últimos 7 días (1 semana)',
            'trending_products_period_14_days' => 'Últimos 14 días (2 semanas)',
            'trending_products_period_30_days' => 'Últimos 30 días (1 mes)',
            'trending_products_period_60_days' => 'Últimos 60 días (2 meses)',
            'trending_products_period_90_days' => 'Últimos 90 días (3 meses)',
            'auto_generate_product_sku' => 'Generar SKU automáticamente al crear producto',
            'auto_generate_product_sku_helper' => 'Generar automáticamente SKUs únicos para productos nuevos basados en el formato de abajo.',
            'product_sku_format' => 'Formato de SKU',
            'product_sku_format_helper' => 'Puedes usar %s (1 carácter de cadena) o %d (1 dígito) en el formato para generar cadena aleatoria. Ej: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Habilitar especificación de producto',
            'enable_product_specification_help' => 'Si está habilitado, la tabla de especificaciones del producto se mostrará en la página de detalle del producto.',
            'make_product_barcode_required' => 'Hacer código de barras del producto obligatorio',
            'make_product_barcode_required_helper' => 'Si está habilitado, el código de barras del producto será obligatorio al crear un producto.',
        ],
    ],
    'product_search' => [
        'name' => 'Búsqueda de Productos',
        'description' => 'Comportamiento de búsqueda, filtros por categoría/marca/etiqueta/atributos y filtrado por rango de precio',
        'product_search_settings' => 'Búsqueda de productos',
        'product_search_settings_description' => 'Configurar reglas para búsqueda de productos',
        'form' => [
            'search_for_an_exact_phrase' => 'Buscar una frase exacta',
            'search_products_by' => 'Buscar productos por:',
            'enable_filter_products_by_categories' => 'Habilitar filtrar productos por categorías',
            'enable_filter_products_by_brands' => 'Habilitar filtrar productos por marcas',
            'enable_filter_products_by_tags' => 'Habilitar filtrar productos por etiquetas',
            'number_of_popular_tags_for_filter' => 'Número de etiquetas populares para filtro',
            'number_of_popular_tags_for_filter_placeholder' => 'Ingresa el número de etiquetas populares a mostrar',
            'number_of_popular_tags_for_filter_helper' => 'Establece el número máximo de etiquetas populares a mostrar en el filtro. Por defecto es 10.',
            'enable_filter_products_by_attributes' => 'Habilitar filtrar productos por atributos',
            'enable_filter_products_by_price' => 'Habilitar filtrar productos por precio',
            'max_product_price_for_filter' => 'Precio máximo de producto para filtro',
            'max_product_price_for_filter_placeholder' => 'Si está vacío o cero, obtendrá el precio máximo del producto de tus productos existentes.',
            'max_product_price_for_filter_helper' => 'Puedes establecer un precio fijo para esto o obtendrá dinámicamente el precio máximo del producto de tus productos existentes. Actualmente es :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Productos Digitales',
        'description' => 'Productos descargables, códigos de licencia, pago como invitado para artículos digitales y autocompletado',
        'digital_products_settings' => 'Productos digitales',
        'digital_products_settings_description' => 'Configurar reglas para productos digitales',
        'form' => [
            'enable_support_digital_product' => 'Está habilitado el soporte para productos digitales',
            'enable_support_digital_product_helper' => 'Cuando está habilitado, el sistema soportará la venta de productos digitales como software, libros electrónicos, música y otro contenido descargable.',
            'allow_guest_checkout_for_digital_products' => 'Permitir checkout de invitado para productos digitales',
            'allow_guest_checkout_for_digital_products_helper' => 'Cuando está habilitado, los clientes pueden comprar productos digitales sin crear una cuenta. Recibirán enlaces de descarga por correo electrónico.',
            'disable_physical_product' => 'Deshabilitar producto físico',
            'disable_physical_product_helper' => 'Cuando está habilitado, la tienda solo venderá productos digitales. Las opciones de producto físico se ocultarán de los formularios de producto y checkout.',
            'enable_license_codes_for_digital_products' => 'Habilitar códigos de licencia para productos digitales',
            'auto_complete_digital_orders_after_payment' => 'Auto-completar pedidos digitales después del pago',
            'auto_complete_digital_orders_after_payment_helper' => 'Cuando está habilitado, los pedidos que contengan solo productos digitales se marcarán automáticamente como completados una vez que se reciba el pago.',
            'enable_license_codes_for_digital_products_helper' => 'Cuando está habilitado, puedes agregar códigos de licencia a productos digitales. Cuando está deshabilitado, la funcionalidad de código de licencia se ocultará de los formularios de producto.',
            'hide_used_license_codes_in_product_form' => 'Ocultar códigos de licencia usados en formulario de producto',
            'hide_used_license_codes_in_product_form_helper' => 'Cuando está habilitado, los códigos de licencia usados se ocultarán de la tabla de códigos de licencia en el formulario de edición de producto. Esto ayuda a mantener la interfaz limpia cuando tienes muchos códigos usados.',
        ],
    ],
    'product_review' => [
        'name' => 'Reseñas de Productos',
        'description' => 'Reseñas de clientes, visualización de calificaciones, carga de imágenes y requisitos de aprobación',
        'form' => [
            'enable_review' => 'Habilitar reseñas de productos',
            'enable_review_help' => 'Permitir a los clientes dejar reseñas y calificaciones en productos. Cuando está deshabilitado, todas las características de reseñas se ocultarán de la tienda.',
            'allow_customer_upload_image_in_review' => 'Permitir a los clientes subir imágenes en reseñas',
            'allow_customer_upload_image_in_review_help' => 'Cuando está deshabilitado, los clientes no pueden subir imágenes al enviar reseñas',
            'review' => [
                'max_file_size' => 'Tamaño máximo de archivo de reseña (MB)',
                'max_file_number' => 'Número máximo de archivos de reseña',
            ],
            'only_allow_customers_purchased_to_review' => 'Solo clientes que han comprado el producto pueden reseñar el producto',
            'review_need_to_be_approved' => 'La reseña necesita ser aprobada antes de mostrarse en la página del producto',
            'show_customer_full_name' => 'Mostrar nombre completo del cliente',
            'show_customer_full_name_help' => 'Si no está marcado, el nombre del cliente que reseña se ocultará y reemplazará con asteriscos (***)',
            'hide_rating_when_no_reviews' => 'Ocultar calificación cuando no hay reseñas',
            'hide_rating_when_no_reviews_help' => 'Cuando está habilitado, las calificaciones de producto se ocultarán en los listados de productos y páginas de detalle de producto cuando el producto no tenga reseñas',
            'display_uploaded_customer_review_images_list' => 'Mostrar sección "Imágenes de clientes"',
            'display_uploaded_customer_review_images_list_help' => 'Cuando está habilitado, muestra una galería de todas las imágenes subidas por clientes en la parte superior de la sección de reseñas',
        ],
    ],
    'shopping' => [
        'name' => 'Compras',
        'description' => 'Carrito, lista de deseos, comparar, seguimiento de pedidos, botón de compra rápida y subida de comprobante de pago',
        'general_setting' => 'Configuración general',
        'return_settings' => 'Configuración de devoluciones',
        'return_settings_description' => 'Configurar reglas para configuración de devoluciones',
        'form' => [
            'enable_cart' => 'Habilitar carrito de compras',
            'enable_cart_helper' => 'Si está deshabilitado, el botón del carrito se eliminará, convirtiendo tu sitio en una visualización solo de catálogo.',
            'enable_wishlist' => 'Habilitar lista de deseos',
            'enable_wishlist_helper' => 'Si está deshabilitado, el botón de lista de deseos se eliminará del sitio.',
            'enable_wishlist_sharing' => 'Habilitar compartir lista de deseos',
            'shared_wishlist_lifetime' => 'Duración de lista de deseos compartida (días)',
            'shared_wishlist_lifetime_helper' => 'La duración de la lista de deseos compartida en días. Después de este tiempo, la lista de deseos compartida será eliminada.',
            'enable_compare' => 'Habilitar comparar',
            'enable_compare_helper' => 'Si está deshabilitado, el botón de comparar se eliminará del sitio.',
            'enable_order_tracking' => 'Habilitar seguimiento de pedidos',
            'enable_order_tracking_helper' => 'Los clientes pueden rastrear sus pedidos ingresando el código de pedido y correo/teléfono en :url',
            'order_tracking_method' => 'Método de seguimiento de pedidos',
            'order_tracking_method_helper' => 'Elige cómo los clientes rastrearán sus pedidos: usando ID de Pedido + Correo o ID de Pedido + Número de teléfono.',
            'order_tracking_method_email' => 'ID de Pedido + Correo',
            'order_tracking_method_phone' => 'ID de Pedido + Número de teléfono',
            'enable_quick_buy_button' => 'Habilitar botón de compra rápida',
            'enable_quick_buy_button_helper' => 'Mostrará un botón "Comprar Ahora" en el listado de productos y página de detalle. Cuando los clientes hagan clic en este botón, el producto se agregará al carrito y se redirigirá a la página de carrito/checkout.',
            'enable_order_auto_confirmed' => 'Auto confirmar pedido',
            'enable_order_auto_confirmed_helper' => 'Si está habilitado, el pedido se confirmará automáticamente después de que el cliente haga un pedido.',
            'quick_buy_target' => 'Página destino de compra rápida',
            'checkout_page' => 'Página de checkout',
            'cart_page' => 'Página de carrito',
            'cart_destroy_on_logout' => 'Destruir carrito al cerrar sesión',
            'cart_destroy_on_logout_helper' => 'El carrito se destruirá cuando el cliente cierre sesión.',
            'hide_product_price' => 'Ocultar precio del producto',
            'hide_product_price_helper' => 'Esta opción solo funciona si deshabilitas el carrito de compras, convirtiendo tu sitio en una visualización solo de catálogo. Si está habilitado, el precio del producto se ocultará. Es útil cuando quieres ocultar el precio y requerir que los clientes te contacten para el precio.',
            'hide_product_price_when_zero' => 'Ocultar precio del producto cuando sea cero',
            'hide_product_price_when_zero_helper' => 'Si está habilitado, los productos con precio 0 no mostrarán un precio en la tienda.',
            'enable_payment_proof' => 'Habilitar subida de comprobante de pago',
            'enable_payment_proof_helper' => 'Permitir a los clientes subir comprobante de pago para sus pedidos. Esto es útil para métodos de pago manuales.',
            'enable_guest_payment_proof' => 'Permitir a clientes invitados subir comprobante de pago',
            'enable_guest_payment_proof_helper' => 'Cuando está habilitado, los clientes invitados pueden subir comprobante de pago usando su token de pedido sin iniciar sesión. Recibirán el enlace de subida en su correo de confirmación de pedido.',
            'payment_proof_payment_methods' => 'Métodos de pago que requieren comprobante de pago',
            'payment_proof_payment_methods_helper' => 'Seleccione qué métodos de pago deben permitir a los clientes cargar el comprobante de pago. Normalmente se usa para métodos de pago manuales como contra reembolso y transferencia bancaria.',
        ],
    ],
    'checkout' => [
        'name' => 'Checkout',
        'panel_description' => 'Pago como invitado, campos obligatorios, límites de pedido, aceptación de términos y restricciones de país',
        'description' => 'Configurar reglas para configuración de checkout',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Mostrar información bancaria en la página de éxito del checkout',
            'mandatory_form_fields_at_checkout' => 'Campos obligatorios en la página de checkout:',
            'mandatory_form_fields_at_checkout_helper' => 'Selecciona qué campos son requeridos durante el checkout. Los clientes deben llenar estos campos para completar su pedido.',
            'hide_form_fields_at_checkout' => 'Ocultar campos de cliente en página de checkout:',
            'hide_form_fields_at_checkout_helper' => 'Selecciona qué campos deben ocultarse en la página de checkout. Estos campos no serán visibles para los clientes.',
            'load_countries_states_cities_from_location_plugin' => 'Cargar países, estados, ciudades desde plugin de ubicación',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Después de cambiar esta opción, necesitas actualizar todas las direcciones nuevamente. Deberías configurarlo una vez.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Entonces necesitas ir a Herramientas -> Importar/Exportar Datos para importar datos de ubicación.',
            'minimum_order_amount' => 'Monto mínimo de pedido para hacer un pedido (:currency).',
            'minimum_order_amount_helper' => 'Establece el monto total mínimo requerido para que se procese un pedido. Los pedidos por debajo de este monto no serán aceptados.',
            'zip_code_enabled' => 'Habilitar código postal',
            'zip_code_enabled_helper' => 'Habilitar o deshabilitar el campo de código postal en el formulario de dirección de envío.',
            'billing_address_enabled' => 'Habilitar dirección de facturación',
            'billing_address_enabled_helper' => 'Permitir a los clientes ingresar una dirección de facturación separada que difiera de su dirección de envío.',
            'display_tax_fields_at_checkout_page' => 'Mostrar campos de información fiscal en la página de checkout',
            'display_tax_fields_at_checkout_page_helper' => 'Si está habilitado, los campos de información fiscal se mostrarán para ingresar detalles fiscales de la empresa para recibir una factura.',
            'use_city_field_as_field_text' => 'Usar campo de ciudad como campo de texto libre',
            'available_countries' => 'Países disponibles',
            'all' => 'Todos',
            'all_helper_text' => 'Si desmarcas todos los países, se aplicará para todos los países.',
            'enable_guest_checkout' => 'Habilitar checkout de invitado',
            'enable_guest_checkout_helper' => 'Si está habilitado, los clientes pueden hacer un pedido sin crear una cuenta.',
            'recently_viewed' => [
                'enable' => 'Habilitar productos vistos recientemente por el cliente',
                'enable_helper' => 'Rastrear y mostrar productos que los clientes han visto recientemente. Esto ayuda a los clientes a encontrar fácilmente productos en los que estaban interesados.',
                'max' => 'Número máximo de productos vistos recientemente por el cliente',
                'max_helper_text' => 'Si se establece en 0, no habrá límite.',
            ],
            'minimum_order_quantity' => 'Cantidad mínima de pedido',
            'minimum_order_quantity_helper' => 'Cantidad mínima para hacer un pedido. Déjalo en 0 si no quieres establecerlo.',
            'maximum_order_quantity' => 'Cantidad máxima de pedido',
            'maximum_order_quantity_helper' => 'Cantidad máxima para hacer un pedido. Déjalo en 0 si no quieres establecerlo.',
            'default_country_at_checkout_page' => 'País predeterminado en la página de checkout',
            'default_country_at_checkout_page_placeholder' => 'Selecciona un país',
            'default_country_at_checkout_page_help' => 'Si seleccionas un país, el país se seleccionará por defecto en la página de checkout.',
            'checkout_product_quantity_editable' => 'Permitir a los clientes cambiar cantidad de producto en la página de checkout',
            'checkout_product_quantity_editable_helper' => 'Cuando está habilitado, los clientes pueden modificar la cantidad de productos directamente en la página de checkout sin regresar al carrito.',
            'show_terms_and_policy_checkbox' => 'Mostrar checkbox de términos y política',
            'show_terms_and_policy_checkbox_helper' => 'Si está habilitado, los clientes deben aceptar los términos y política antes de hacer un pedido. Por favor configura la URL de Términos y Política de Privacidad en Apariencia -> Opciones de tema primero.',
            'terms_and_policy_checkbox_checked_by_default' => 'Checkbox de términos y política marcado por defecto',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Si está habilitado, el checkbox de términos y política estará pre-marcado cuando se cargue el formulario de checkout.',
            'checkout_acceptance_message_enabled' => 'Mostrar mensaje de aceptación de checkout',
            'checkout_acceptance_message_enabled_helper' => 'Mostrar un mensaje informativo que informa a los clientes sobre los términos que están aceptando al hacer un pedido.',
            'hide_customer_info_at_checkout' => 'Ocultar información del cliente en checkout',
            'hide_customer_info_at_checkout_helper' => 'Ocultar la información de cuenta del cliente y botón de cerrar sesión de la página de checkout. Cuando está habilitado, los clientes con sesión iniciada no verán los detalles de su cuenta mostrados.',
        ],
    ],
    'return' => [
        'name' => 'Devolución',
        'description' => 'Configurar reglas para configuración de devoluciones',
        'panel_description' => 'Devoluciones de pedidos, devoluciones parciales y límites de tiempo de devolución',
        'form' => [
            'is_enabled_order_return' => 'Está habilitada la devolución de pedidos',
            'allow_partial_return' => 'Permitir devolución parcial',
            'allow_partial_return_description' => 'El cliente puede devolver algunos productos, no necesita devolver todos los productos en un pedido.',
            'returnable_days' => 'Días de devolución',
            'return_settings_helper' => 'Número de días que un cliente puede solicitar una devolución después de que el pedido se complete.',
        ],
    ],
    'invoice' => [
        'name' => 'Facturas',
        'description' => 'Detalles de empresa en facturas, numeración de facturas, fuentes PDF y configuración de sello',
        'company_settings' => 'Configuración de facturas',
        'company_settings_description' => 'Info de empresa, numeración, fuentes PDF y sello de pago',
        'form' => [
            'company_name' => 'Nombre de empresa',
            'company_name_placeholder' => 'Acme Corporación',
            'company_name_helper' => 'El nombre de tu empresa o negocio que aparecerá en todas las facturas enviadas a los clientes.',
            'company_address' => 'Dirección de empresa',
            'company_address_placeholder' => 'Calle Principal 123, Suite 100, Madrid, España',
            'company_address_helper' => 'La dirección completa de tu empresa incluyendo calle, ciudad, estado y país. Esto aparecerá en las facturas.',
            'company_zipcode' => 'Código postal de empresa',
            'company_zipcode_placeholder' => '28001',
            'company_zipcode_helper' => 'Código postal para la dirección de tu empresa.',
            'company_email' => 'Correo de empresa',
            'company_email_placeholder' => 'facturacion@empresa.com',
            'company_email_helper' => 'Dirección de correo electrónico para consultas comerciales. Los clientes pueden usar esto para preguntas relacionadas con facturas.',
            'company_phone' => 'Teléfono de empresa',
            'company_phone_placeholder' => '+34 91 123 4567',
            'company_phone_helper' => 'Número de teléfono de contacto que se mostrará en las facturas para soporte al cliente.',
            'company_logo' => 'Logo de empresa',
            'company_logo_helper' => 'El logo de tu empresa que se mostrará en la parte superior de las facturas. Tamaño recomendado: 200x60 píxeles.',
            'company_tax_id' => 'ID fiscal de empresa',
            'company_tax_id_placeholder' => 'CIF/NIF: A12345678',
            'company_tax_id_helper' => 'Tu número de identificación fiscal empresarial (CIF, NIF, VAT, etc.) para cumplimiento tributario.',
            'invoice_code_prefix' => 'Prefijo de código de factura',
            'invoice_code_prefix_placeholder' => 'FACT-',
            'invoice_code_prefix_helper' => 'Prefijo agregado antes de los números de factura (ej., "FACT-" creará códigos de factura como FACT-001, FACT-002).',
            'using_custom_font_for_invoice' => 'Usar fuente personalizada para factura',
            'using_custom_font_for_invoice_helper' => 'Habilitar para usar una fuente de Google personalizada para los PDF de facturas en lugar de la fuente predeterminada.',
            'invoice_font_family' => 'Familia de fuente de factura (Solo funciona para idioma latino)',
            'invoice_font_family_helper' => 'Selecciona una fuente de Google para usar en los PDF de facturas. Solo funciona con conjuntos de caracteres latinos.',
            'enable_invoice_stamp' => 'Habilitar sello de factura',
            'enable_invoice_stamp_helper' => 'Agregar un sello de "PAGADO" a las facturas cuando el pago del pedido esté completado.',
            'add_language_support' => 'Agregar soporte de idioma',
            'add_language_support_helper' => 'Elegir soporte adicional de conjunto de caracteres para idiomas no latinos en facturas PDF.',
            'invoice_processing_library' => 'Biblioteca de procesamiento de facturas',
            'invoice_processing_library_helper' => 'Elige la biblioteca de generación de PDF. DomPDF es más rápido pero tiene características limitadas. mPDF soporta más idiomas y características pero puede ser más lento.',
            'only_latin_languages' => 'Solo idiomas latinos',
            'disable_order_invoice_until_order_confirmed' => 'Deshabilitar factura de pedido hasta que el pedido sea confirmado',
            'disable_order_invoice_until_order_confirmed_helper' => 'Cuando está habilitado, las facturas solo estarán disponibles después de que los pedidos sean confirmados, no inmediatamente después de realizar el pedido.',
            'date_format' => 'Formato de fecha',
            'date_format_helper' => 'Elige cómo se mostrarán las fechas en las facturas (ej., "F d, Y" muestra "Enero 01, 2024").',
            'languages' => [
                'arabic' => 'Árabe',
                'bangladesh' => 'Bengalí',
                'chinese' => 'Chino',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Impuesto',
        'description' => 'Cálculo de impuestos, opciones de visualización y campos de facturación',
        'enable' => '¿Habilitar impuesto?',
        'display_product_price_including_taxes' => '¿Mostrar precio del producto incluyendo impuestos?',
        'display_tax_description' => '¿Mostrar información de impuesto en precio del producto?',
        'display_tax_description_help' => 'Mostrar texto como "(Incluyendo X% IVA)" o "(Excluyendo X% IVA)" junto a los precios de productos en la página de detalle del producto.',
        'tax_included_in_products_price' => 'Impuesto incluido en precio de productos',
        'tax_included_in_products_price_description' => 'El impuesto se incluirá en el precio de productos',
        'tax_setting' => 'Visualización de impuestos y pago',
        'tax_setting_description' => 'Configure cómo se muestran los impuestos en productos y páginas de pago',
        'tax_management' => 'Gestión de impuestos',
        'tax_management_description' => 'Ver y gestionar tus impuestos',

        'manage_taxes_info' => 'Para gestionar impuestos y establecer la tasa de impuesto predeterminada, vaya a',
        'go_to_taxes' => 'Comercio electrónico → Impuestos',        'form' => [
            'enable_tax' => 'Habilitar impuesto',
            'display_company_invoice_information_fields_at_checkout_page' => 'Mostrar campos de información de factura de empresa en la página de checkout',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Si está habilitado, los campos de información de factura de empresa se mostrarán en la página de checkout. Es requerido llenar los campos de información de factura de empresa.',
            'default_tax_rate' => 'Tasa de impuesto predeterminada',
            'default_tax_rate_description' => 'Importante: se aplicará si no se selecciona impuesto en el producto.',
            'select_tax' => '-- Seleccionar --',
            'display_product_price_including_taxes' => 'Agregar impuesto a los precios mostrados',
            'display_product_price_including_taxes_helper' => 'Agrega automáticamente el impuesto a los precios de productos mostrados en la tienda. Ej: un producto de $100 con 10% de impuesto se muestra como $110. No es necesario si "El precio incluye impuesto" ya está activado en productos individuales.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Clientes',
        'description' => 'Registro, verificación de correo, opciones de inicio de sesión, eliminación de cuenta y campos de perfil',
        'customer_setting' => 'Configuración de cliente',
        'customer_setting_description' => 'Configurar configuración de cliente',
        'form' => [
            'enable_customer_registration' => 'Habilitar registro de clientes',
            'enable_customer_registration_helper' => 'Si está deshabilitado, los clientes no podrán registrar nuevas cuentas. Los clientes existentes aún pueden iniciar sesión.',
            'verify_customer_email' => 'Verificar correo electrónico del cliente',
            'verify_customer_email_helper' => 'Cuando está habilitado, se enviará un enlace de verificación al correo del cliente, los clientes necesitan hacer clic en este enlace para verificar su correo antes de poder iniciar sesión. Necesita configurar correo en Admin -> Configuración -> Correo para enviar verificación de correo.',
            'verification_expire_minutes' => 'Tiempo de expiración del enlace de verificación',
            'verification_expire_minutes_helper' => 'El tiempo en minutos que el enlace de verificación de correo será válido. Por defecto es 60 minutos (1 hora). Máximo es 10080 minutos (7 días).',
            'login_using_phone' => 'Iniciar sesión con número de teléfono en lugar de correo',
            'login_option' => 'Opción de inicio de sesión',
            'login_with_email' => 'Iniciar sesión con correo',
            'login_with_phone' => 'Iniciar sesión con teléfono',
            'login_with_email_or_phone' => 'Iniciar sesión con correo o teléfono',
            'enabled_customer_account_deletion' => 'Habilitar eliminación de cuenta de cliente',
            'enabled_customer_account_deletion_helper' => 'Cuando está habilitado, los clientes pueden eliminar su cuenta en panel de cliente → Configuración de cuenta.',
            'enabled_customer_dob_field' => 'Habilitar campo de fecha de nacimiento del cliente',
            'enabled_customer_dob_field_helper' => 'Cuando está habilitado, los clientes pueden ingresar su fecha de nacimiento en panel de cliente → Configuración de cuenta.',
            'enabled_phone_field_in_registration_form' => 'Habilitar campo de teléfono en formulario de registro',
            'enabled_phone_field_in_registration_form_helper' => 'Cuando está habilitado, el campo de teléfono se agregará al formulario de registro.',
            'make_customer_phone_number_required' => 'Hacer número de teléfono de cliente obligatorio',
            'make_customer_phone_number_required_helper' => 'Cuando está habilitado, los clientes deben ingresar su número de teléfono durante el registro. Siempre es requerido para clientes que inician sesión con número de teléfono.',
            'default_avatar' => 'Avatar predeterminado',
            'default_avatar_helper' => 'Avatar predeterminado para cliente cuando no tienen un avatar. Si no seleccionas ninguna imagen, se generará usando tu logo o el primer carácter del nombre del cliente.',
            'keep_email_field_in_registration_form' => 'Mantener campo de correo en formulario de registro',
            'keep_email_field_in_registration_form_helper' => 'Cuando está deshabilitado, el campo de correo se ocultará en el formulario de registro cuando la opción de inicio de sesión sea "Iniciar sesión con teléfono".',
        ],
    ],
    'shipping' => [
        'name' => 'Envío',
        'description' => 'Reglas de envío, comportamiento de envío gratis y orden de visualización de opciones de envío',
        'shipping_rule' => 'Reglas de envío',
        'shipping_rule_description' => 'Configurar reglas para calcular tarifa de envío',
        'shipping_setting' => 'Configuración de envío',
        'shipping_setting_description' => 'Configurar configuración de envío',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Ocultar otras opciones de envío si tiene envío gratis en la lista',
            'disable_shipping_options' => 'Deshabilitar opciones de envío',
            'disable_shipping_options_helper' => 'Las opciones de envío se eliminarán en la página de checkout, el cliente no podrá seleccionar opciones de envío.',
            'sort_shipping_options_direction' => 'Dirección de ordenamiento de opciones de envío',
            'sort_shipping_options_direction_helper' => 'Ordenar opciones de envío por precio de menor a mayor o de mayor a menor.',
            'price_lower_to_higher' => 'Precio de menor a mayor',
            'price_higher_to_lower' => 'Precio de mayor a menor',
        ],
    ],
    'webhook' => [
        'name' => 'Webhooks',
        'description' => 'Enviar eventos de pedidos a servicios externos via HTTP',
        'webhook_setting' => 'Webhooks de eventos de pedidos',
        'webhook_setting_description' => 'Configure URLs para recibir notificaciones cuando se crean, actualizan o envían pedidos',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook de pedido realizado (método: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Para recibir notificaciones cuando se realiza un pedido, puedes configurar una URL webhook externa. Si tienes una URL webhook externa, puedes ingresar esta URL, o simplemente déjala vacía.',
            'order_updated_webhook_url' => 'URL webhook de pedido actualizado (método: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Para recibir notificaciones cuando se actualiza un pedido, puedes configurar una URL webhook externa. Esto incluye cambios de estado, actualizaciones de dirección y otras modificaciones de pedido.',
            'shipping_status_updated_webhook_url' => 'URL webhook de estado de envío actualizado (método: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Para recibir notificaciones cuando cambia el estado de envío (ej., enviado, entregado, cancelado), puedes configurar una URL webhook externa.',
            'order_completed_webhook_url' => 'URL webhook de pedido completado (método: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Para recibir notificaciones cuando se completa un pedido, puedes configurar una URL webhook externa.',
            'order_cancelled_webhook_url' => 'URL webhook de pedido cancelado (método: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Para recibir notificaciones cuando se cancela un pedido, puedes configurar una URL webhook externa.',
            'payment_status_updated_webhook_url' => 'URL webhook de estado de pago actualizado (método: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Para recibir notificaciones cuando cambia el estado de pago (ej., pagado, fallido, reembolsado), puedes configurar una URL webhook externa.',
            'abandoned_cart_webhook_url' => 'URL webhook de carrito abandonado (método: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Para recibir notificaciones cuando los carritos son abandonados y dar seguimiento a los clientes, puedes configurar una URL webhook externa. Las notificaciones se envían después de un período de tiempo configurable.',
        ],
        'test_button' => 'Probar Webhook',
        'test_success' => '¡Prueba de webhook exitosa! El endpoint respondió correctamente.',
        'test_failed' => 'Prueba de webhook falló. El endpoint no respondió como se esperaba.',
        'test_error' => 'Error de prueba de webhook: :error',
        'please_enter_url' => 'Por favor ingresa una URL de webhook primero',
        'testing' => 'Probando...',
        'test_failed_title' => '¡Prueba Fallida!',
        'test_success_title' => '¡Prueba Exitosa!',
        'status_code' => 'Código de Estado',
        'error_occurred' => 'Ocurrió un error mientras se probaba el webhook',
    ],
    'store_locator' => [
        'name' => 'Localizadores de tienda',
        'description' => 'Ver y actualizar las listas de tus cadenas',
        'store_locator_description' => 'Todas las listas de tus cadenas, tiendas principales, sucursales, etc. Las ubicaciones pueden usarse para rastrear ventas y ayudarnos a configurar tasas de impuestos a cobrar al vender productos.',
        'form' => [
            'change_primary_store' => 'cambiar localizador de tienda predeterminado',
            'add_location' => 'Agregar ubicación',
            'edit_location' => 'Editar ubicación',
            'delete_location' => 'Eliminar ubicación',
            'delete_location_confirmation' => '¿Estás seguro de que quieres eliminar esta ubicación? Esta acción no se puede deshacer.',
            'change_primary_location' => 'Cambiar ubicación principal',
            'save_location' => 'Guardar ubicación',
            'add_new' => 'Agregar nuevo',
        ],
        'info' => [
            'title' => 'Cómo funcionan los localizadores de tienda',
            'primary_store' => 'La dirección de la tienda principal aparece en las facturas y se utiliza como dirección de devolución predeterminada para las etiquetas de envío.',
            'shipping_location' => 'Las tiendas marcadas como "ubicación de envío" pueden seleccionarse como almacén de origen al crear envíos.',
            'shipment_selection' => 'Al procesar pedidos, puedes elegir desde qué almacén enviar según el inventario y la ubicación del cliente.',
        ],
    ],
    'tracking' => [
        'name' => 'Seguimiento',
        'description' => 'Facebook Pixel, eventos de Google Tag Manager y seguimiento de conversiones de Google Ads',
        'manage_tracking' => 'Gestionar seguimiento',
        'manage_tracking_description' => 'Gestionar seguimiento: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Habilitar Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Ve a https://developers.facebook.com/docs/meta-pixel para crear Facebook Pixel. Asegúrate de que tu pixel esté activo y configurado correctamente.',
            'facebook_pixel_id' => 'ID de Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'Ejemplo: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Habilitar modo de depuración de Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Habilitar modo de depuración para registrar eventos de Facebook Pixel en la consola del navegador y solucionar problemas de seguimiento',
            'enable_google_tag_manager_tracking_events' => 'Habilitar eventos de seguimiento de Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Cuando está habilitado, los eventos de comercio electrónico se rastrearán a través de Google Tag Manager. Asegúrate de haber configurado Google Tag Manager arriba.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'El ID de Facebook Pixel debe ser de 15-16 dígitos (ej., 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Mercado',
        'description' => 'Configuración de múltiples vendedores, comisiones, registro de vendedores y configuración de pagos',
    ],
    'standard_and_format' => [
        'name' => 'Estándar y Formato',
        'panel_description' => 'Formato de código de pedido, unidades de peso (kg/lb) y unidades de dimensión (cm/pulgadas)',
        'description' => 'Los estándares y formatos se usan para calcular cosas como precios de productos, pesos de envío y tiempos de pedidos.',
        'form' => [
            'change_order_format' => 'Editar formato de código de pedido (opcional)',
            'change_order_format_description' => 'El código de pedido predeterminado comienza en: número. Puedes cambiar la cadena de inicio o fin para crear el código de pedido que quieras, por ejemplo "DH-: número" o ": número-A"',
            'start_with' => 'Comenzar con',
            'end_with' => 'Terminar con',
            'order_will_be_shown' => 'Tu código de pedido se mostrará',
            'weight_unit' => 'Unidad de peso',
            'height_unit' => 'Unidad de longitud / altura',
            'weight_unit_gram' => 'Gramo (g)',
            'weight_unit_kilogram' => 'Kilogramo (kg)',
            'weight_unit_lb' => 'Libra (lb)',
            'weight_unit_oz' => 'Onza (oz)',
            'height_unit_cm' => 'Centímetro (cm)',
            'height_unit_m' => 'Metro (m)',
            'height_unit_inch' => 'Pulgada',
        ],
    ],
    'sale_popup' => [
        'name' => 'Popup de Venta',
        'description' => 'Personaliza tu configuración de popup de venta con facilidad',
    ],
    'flash_sale' => [
        'name' => 'Venta Flash',
        'description' => 'Configurar configuración de venta flash para ofrecer descuentos promocionales por tiempo limitado',
        'enable' => 'Habilitar funcionalidad de venta flash',
        'enable_helper' => 'Cuando está habilitado, puedes crear y gestionar ventas flash con precios especiales con descuento por un período de tiempo limitado.',
        'show_sale_count_left' => 'Mostrar rastreador de inventario',
        'show_sale_count_left_description' => 'Mostrar una barra de progreso con "X vendido de Y" para crear urgencia y alentar compras rápidas durante las ventas flash.',
    ],
    'payment_method_cod_minimum_amount' => 'Monto mínimo de pedido - :currency (Opcional)',
    'payment_method_cod_minimum_amount_helper' => 'Establecer el monto mínimo de pedido requerido para usar el método de pago COD. Déjelo en 0 o vacío si no desea establecer un mínimo.',
    'payment_method_cod_maximum_amount' => 'Monto máximo de pedido - :currency (Opcional)',
    'payment_method_cod_maximum_amount_helper' => 'Establecer el monto máximo de pedido permitido para el método de pago COD. Déjelo en 0 o vacío si no desea establecer un máximo.',
    'payment_method_minimum_amount' => 'Monto mínimo de pedido - :currency (Opcional)',
    'payment_method_minimum_amount_helper' => 'Establecer el monto mínimo de pedido requerido para usar este método de pago. Déjelo en 0 o vacío si no desea establecer un mínimo.',
    'payment_method_maximum_amount' => 'Monto máximo de pedido - :currency (Opcional)',
    'payment_method_maximum_amount_helper' => 'Establecer el monto máximo de pedido permitido para este método de pago. Déjelo en 0 o vacío si no desea establecer un máximo.',
    'payment_method_maximum_amount_error' => 'El monto máximo de pedido para usar el método de pago :payment_method es :amount, ¡necesita eliminar :more para realizar el pedido!',
    'display_bank_info_at_the_checkout_success_page' => '¿Mostrar información bancaria en la página de éxito del checkout?',
    'display_bank_info_at_the_checkout_success_page_helper' => 'Cuando está habilitado, los clientes verán los detalles de su cuenta bancaria en la página de confirmación del pedido después de realizar un pedido. Esto les ayuda a saber dónde transferir el pago.',
    'invoice_templates' => 'Plantillas de facturas',

    'abandoned_cart' => [
        'name' => 'Carritos Abandonados',
        'description' => 'Recupera ventas perdidas enviando recordatorios automáticos a clientes que dejaron artículos en su carrito',
        'panel_description' => 'Configura recordatorios automáticos para clientes que abandonan sus carritos',
        'how_it_works' => [
            'title' => 'Cómo Funciona',
            'step1_title' => 'El cliente agrega artículos',
            'step1_description' => 'El cliente agrega productos a su carrito y proporciona su correo electrónico.',
            'step2_title' => 'El carrito se abandona',
            'step2_description' => 'Si no se realiza una compra dentro del tiempo establecido, el carrito se marca como abandonado.',
            'step3_title' => 'Se envía correo de recordatorio',
            'step3_description' => 'Se envían correos de recordatorio automáticos para animar al cliente a completar su compra.',
            'step4_title' => 'Venta recuperada',
            'step4_description' => 'El cliente regresa para completar su pedido y el carrito se marca como recuperado.',
        ],
        'form' => [
            'enable' => 'Habilitar seguimiento de carritos abandonados',
            'enable_helper' => 'Cuando está habilitado, el sistema rastreará carritos abandonados y te permitirá enviar correos de recuperación a los clientes.',
            'timing_section' => 'Configuración de Tiempo',
            'email_section' => 'Configuración de Correos de Recordatorio',
            'cleanup_section' => 'Limpieza de Datos',
            'time_threshold' => 'Umbral de tiempo (horas)',
            'time_threshold_helper' => 'Un carrito se considera abandonado después de estas horas de inactividad. Recomendado: 1-24 horas.',
            'send_email' => 'Enviar correos de recuperación',
            'send_email_helper' => 'Enviar automáticamente correos de recuperación a clientes con carritos abandonados.',
            'max_reminders' => 'Número de correos de recordatorio',
            'max_reminders_helper' => 'Cuántos correos de recordatorio enviar por carrito abandonado. Cada correo puede personalizarse en Plantillas de Correo.',
            'email_delay' => 'Enviar después de (horas)',
            'email_discount' => 'Descuento (%)',
            'email_1_title' => 'Correo #1 - Recordatorio Amigable',
            'email_1_description' => 'Primer recordatorio suave para animar al cliente a regresar.',
            'email_1_delay_helper' => 'Horas después del abandono del carrito para enviar el primer correo. Recomendado: 1-2 horas.',
            'email_2_title' => 'Correo #2 - Con Incentivo',
            'email_2_description' => 'Segundo recordatorio con oferta de descuento para motivar la compra.',
            'email_2_delay_helper' => 'Horas después del abandono del carrito para enviar el segundo correo. Recomendado: 24 horas.',
            'email_2_discount_helper' => 'Porcentaje de descuento a ofrecer en este correo. Establece 0 para sin descuento.',
            'email_3_title' => 'Correo #3 - Última Oportunidad',
            'email_3_description' => 'Recordatorio final con urgencia y mejor oferta para cerrar la venta.',
            'email_3_delay_helper' => 'Horas después del abandono del carrito para enviar el correo final. Recomendado: 72 horas.',
            'email_3_discount_helper' => 'Oferta de descuento final. Usualmente mayor que el correo #2.',
            'cleanup_days' => 'Limpiar después de (días)',
            'cleanup_days_helper' => 'Eliminar automáticamente registros de carritos abandonados mayores a este número de días.',
            'cronjob_not_setup' => '<strong>¡Cronjob no configurado!</strong> Los recordatorios de carritos abandonados requieren un cronjob correctamente configurado. <a href=":url">Configurar cronjob ahora</a>.',
            'cronjob_not_running' => '<strong>¡Cronjob no está corriendo!</strong> El cronjob parece haberse detenido. Por favor revisa la configuración de tu servidor. <a href=":url">Ver estado del cronjob</a>.',
            'cronjob_working' => '<strong>¡Cronjob funcionando correctamente!</strong> Última actividad: :time. Tus recordatorios de carritos abandonados se procesarán automáticamente.',
            'email_setup_warning' => '<strong>Importante:</strong> Asegúrate de que tu configuración de correo esté correctamente configurada en <a href=":url">Configuración → Correo</a>. Envía un correo de prueba para verificar que todo funciona antes de habilitar esta función.',
        ],
    ],
];
