<?php

return [
    'name' => 'Productos',
    'description' => 'Gestionar productos físicos y digitales con inventario, precios y variaciones',
    'create' => 'Nuevo producto',
    'create_product_type' => [
        'physical' => 'Nuevo producto físico',
        'digital' => 'Nuevo producto digital',
    ],
    'edit' => 'Editar producto - :name',
    'form' => [
        'name' => 'Nombre',
        'name_placeholder' => 'Nombre del producto (Máximo 120 caracteres)',
        'description' => 'Descripción',
        'description_placeholder' => 'Descripción corta del producto (Máximo 400 caracteres)',
        'categories' => 'Categorías',
        'content' => 'Contenido',
        'price' => 'Precio',
        'currency' => 'Moneda',
        'currency_for_variations_hint' => 'Esta moneda se aplicará a todas las variaciones de este producto.',
        'quantity' => 'Cantidad',
        'brand' => 'Marca',
        'width' => 'Ancho',
        'height' => 'Alto',
        'weight' => 'Peso',
        'date' => [
            'start' => 'Desde fecha',
            'end' => 'Hasta fecha',
        ],
        'image' => 'Imágenes',
        'collections' => 'Colecciones de productos',
        'labels' => 'Etiquetas',
        'price_sale' => 'Precio de oferta',
        'product_type' => [
            'title' => 'Tipo de producto',
        ],
        'product' => 'Producto',
        'total' => 'Total',
        'sub_total' => 'Subtotal',
        'shipping_fee' => 'Tarifa de envío',
        'discount' => 'Descuento',
        'options' => 'Opciones',
        'shipping' => [
            'height' => 'Alto',
            'length' => 'Largo',
            'title' => 'Envío',
            'weight' => 'Peso',
            'wide' => 'Ancho',
        ],
        'barcode' => 'Código de barras (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Introducir código de barras',
        'cost_per_item' => 'Costo por artículo',
        'cost_per_item_placeholder' => 'Introducir costo por artículo',
        'cost_per_item_helper' => 'Los clientes no verán este precio.',
        'price_includes_tax' => 'El precio incluye impuestos',
        'price_includes_tax_helper' => 'Marque esto si el precio ingresado ya incluye impuestos. El sistema calculará el precio base eliminando el monto del impuesto.',
        'stock' => [
            'allow_order_when_out' => 'Permitir que el cliente realice el pedido cuando este producto esté agotado',
            'in_stock' => 'En stock',
            'out_stock' => 'Agotado',
            'title' => 'Estado del stock',
        ],
        'storehouse' => [
            'no_storehouse' => 'Sin gestión de almacén',
            'storehouse' => 'Con gestión de almacén',
            'title' => 'Almacén',
            'quantity' => 'Cantidad',
        ],
        'tax' => 'Impuesto',
        'taxes' => 'Impuestos',
        'taxes_helper' => 'La tasa de impuesto predeterminada está configurada en <a href=":url">Configuración -> Impuestos</a>. Si no se selecciona un impuesto específico para este producto, se aplicará la tasa predeterminada. Para deshabilitar el impuesto para este producto, elimine la tasa de impuesto predeterminada de la configuración de impuestos.',
        'is_default' => 'Es predeterminado',
        'action' => 'Acción',
        'restock_quantity' => 'Cantidad de reposición',
        'remain' => 'Restante',
        'choose_discount_period' => 'Elegir período de descuento',
        'cancel' => 'Cancelar',
        'no_results' => '¡Sin resultados!',
        'value' => 'Valor',
        'attribute_name' => 'Nombre del atributo',
        'add_more_attribute' => 'Agregar más atributo',
        'continue' => 'Continuar',
        'add_new_attributes' => 'Agregar nuevos atributos',
        'add_new_attributes_description' => 'Agregar nuevos atributos ayuda al producto a tener muchas opciones, como tamaño o color.',
        'create_product_variations' => '¡:link para crear variaciones de producto!',
        'tags' => 'Etiquetas',
        'write_some_tags' => 'Escribir algunas etiquetas',
        'variation_existed' => 'Esta variación ya existe.',
        'no_attributes_selected' => '¡No se han seleccionado atributos!',
        'added_variation_success' => '¡Variación agregada exitosamente!',
        'updated_variation_success' => '¡Variación actualizada exitosamente!',
        'created_all_variation_success' => '¡Todas las variaciones creadas exitosamente!',
        'updated_product_attributes_success' => '¡Atributos del producto actualizados exitosamente!',
        'stock_status' => 'Estado del stock',
        'auto_generate_sku' => '¿Generar SKU automáticamente?',
        'featured_image' => 'Imagen destacada (opcional)',
        'product_id' => 'ID del producto',
        'price_sale_percent_helper' => 'Descuento de :percent del precio original.',
        'minimum_order_quantity' => 'Cantidad mínima de pedido',
        'minimum_order_quantity_helper' => 'Cantidad mínima para realizar un pedido, si el valor es 0, no hay límite.',
        'maximum_order_quantity' => 'Cantidad máxima de pedido',
        'maximum_order_quantity_helper' => 'Cantidad máxima para realizar un pedido, si el valor es 0, no hay límite.',
        'video' => 'Video',
        'video_file' => 'Archivo',
        'video_url' => 'O URL de video externo',
        'video_url_help' => 'Ingrese la URL del video de YouTube o Vimeo',
        'enter_video_url' => 'Ingrese la URL del video',
        'video_thumbnail' => 'Miniatura del video',
        'video_thumbnail_help' => 'Elija una miniatura para el video. Si no se selecciona, se obtendrá automáticamente de la URL del video si está disponible.',
        'barcode_existed' => 'Este código de barras está siendo utilizado por otro producto. Por favor ingrese otro código de barras.',
        'barcode_helper' => 'Debe ser único para cada producto.',
        'is_new_until' => 'Nuevo hasta',
        'is_new_until_helper' => 'Establezca una fecha hasta la cual este producto se marcará como "Nuevo". Déjelo vacío para no marcar como nuevo según la fecha.',
    ],
    'price' => 'Precio',
    'quantity' => 'Cantidad',
    'type' => 'Tipo',
    'image' => 'Miniatura',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU de variación',
    'brand' => 'Marca',
    'cannot_delete' => 'El producto no pudo ser eliminado',
    'product_deleted' => 'Producto eliminado',
    'product' => 'Producto',
    'product_collections' => 'Colecciones de productos',
    'products' => 'Productos',
    'total_products_found' => ':total productos encontrados',
    'total_product_found' => ':total producto encontrado',
    'menu' => 'Productos',
    'control' => [
        'button_add_image' => 'Agregar imagen',
    ],
    'price_sale' => 'Precio de oferta',
    'price_group_title' => 'Gestionar precio del producto',
    'store_house_group_title' => 'Gestionar almacén',
    'shipping_group_title' => 'Gestionar envío',
    'overview' => 'Resumen',
    'attributes' => 'Atributos',
    'product_has_variations' => 'El producto tiene variaciones',
    'manage_products' => 'Gestionar productos',
    'add_new_product' => 'Agregar un nuevo producto',
    'start_by_adding_new_product' => 'Comience agregando nuevos productos.',
    'edit_this_product' => 'Editar este producto',
    'delete' => 'Eliminar',
    'related_products' => 'Productos relacionados',
    'cross_selling_products' => 'Productos de venta cruzada',
    'up_selling_products' => 'Productos de venta adicional',
    'grouped_products' => 'Productos agrupados',
    'search_products' => 'Buscar productos',
    'selected_products' => 'Productos seleccionados',
    'edit_variation_item' => 'Editar',
    'variations_box_description' => 'Haga clic en "Editar atributo" para agregar/eliminar atributos de variación o haga clic en "Agregar nueva variación" para agregar una variación.',
    'save_changes' => 'Guardar cambios',
    'continue' => 'Continuar',
    'edit_attribute' => 'Editar atributo',
    'select_attribute' => 'Seleccionar atributo',
    'add_new_variation' => 'Agregar nueva variación',
    'edit_variation' => 'Editar variación',
    'generate_variations' => 'Generar variaciones',
    'generate_variations_confirmation' => '¿Está seguro de que desea generar variaciones para este producto?',
    'delete_variation' => '¿Eliminar variación?',
    'delete_variation_confirmation' => '¿Está seguro de que desea eliminar esta variación? Esta acción no se puede deshacer.',
    'delete_variations_confirmation' => '¿Está seguro de que desea eliminar esas variaciones? Esta acción no se puede deshacer.',
    'product_create_validate_name_required' => 'Por favor ingrese el nombre del producto',
    'product_create_validate_sale_price_max' => 'El descuento debe ser menor que el precio original',
    'product_create_validate_cost_per_item_max' => 'El costo por artículo debe ser menor que el precio original',
    'product_create_validate_sale_price_required_if' => 'Debe ingresar un descuento cuando desee programar una promoción',
    'product_create_validate_end_date_after' => 'La fecha de finalización debe ser posterior a la fecha de inicio',
    'product_create_validate_start_date_required_if' => 'La fecha de inicio del descuento no puede quedar en blanco cuando se selecciona la programación',
    'product_create_validate_sale_price' => 'Los descuentos no pueden quedar en blanco cuando se selecciona la programación',
    'stock_statuses' => [
        'in_stock' => 'En stock',
        'out_of_stock' => 'Agotado',
        'on_backorder' => 'En pedido pendiente',
    ],
    'stock_status' => 'Estado del stock',
    'processing' => 'Procesando...',
    'delete_selected_variations' => 'Eliminar variaciones seleccionadas',
    'delete_variations' => 'Eliminar variaciones',
    'category' => 'Categoría',
    'categories' => 'Categorías',
    'tags' => 'Etiquetas',
    'product_price_flash_sale_warning' => 'Este producto está en oferta flash <strong>:name</strong> por lo que su precio es <strong>:price</strong>.',
    'product_price_discount_warning' => 'Este producto está en descuento <strong>:name</strong> por lo que su precio es <strong>:price</strong>.',
    'product_image' => 'Imagen del producto',
    'product_name' => 'Nombre del producto',
    'product_link' => 'Enlace del producto',
    'types' => [
        'physical' => 'Físico',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Archivos adjuntos digitales',
        'add' => 'Agregar adjunto',
        'file_name' => 'Nombre del archivo',
        'file_size' => 'Tamaño del archivo',
        'unsaved' => 'Sin guardar',
        'add_external_link' => 'Agregar enlace externo',
        'enter_file_name' => 'Ingrese el nombre del archivo',
        'enter_external_link_download' => 'Ingrese el enlace de descarga externo',
        'enter_file_size' => 'Ingrese el tamaño del archivo',
        'external_link_download' => 'Enlace de descarga externo',
        'generate_license_code_after_purchasing_product' => 'Habilitar asignación de código de licencia para este producto',
        'notify_attachment_updated' => 'Enviar un correo electrónico al cliente cuando se actualice el adjunto',
        'no_attachments' => 'Sin archivos adjuntos todavía. Haga clic en los botones de arriba para agregar archivos.',
    ],
    'license_codes' => [
        'title' => 'Códigos de licencia',
        'add' => 'Agregar código de licencia',
        'back' => 'Volver al producto',
        'edit' => 'Editar código de licencia',
        'generate' => 'Generar códigos',
        'manage_codes' => 'Gestionar códigos de licencia',
        'management' => 'Gestión de códigos de licencia',
        'variation_breadcrumb' => 'Variación: :name',
        'variation_label' => 'Variación del producto',
        'variation_specific_note' => 'Estos códigos de licencia son específicos para esta variación del producto. Los clientes que compren esta variación recibirán códigos de este grupo.',
        'main_product_note' => 'Este producto tiene variaciones. Cada variación puede tener sus propios códigos de licencia, o los clientes pueden recibir códigos del grupo de productos principales si la variación no tiene códigos.',
        'code' => 'Código de licencia',
        'codes' => 'Códigos de licencia',
        'status' => 'Estado',
        'assigned_at' => 'Asignado el',
        'status_available' => 'Disponible',
        'status_used' => 'Usado',
        'statuses' => [
            'available' => 'Disponible',
            'used' => 'Usado',
        ],
        'no_codes' => 'No se encontraron códigos de licencia. Agregue algunos códigos o genérelos automáticamente.',
        'no_codes_warning_title' => '¡No hay códigos de licencia disponibles!',
        'no_codes_warning_message' => 'Este producto está configurado para "Seleccionar de la lista" pero no tiene códigos de licencia disponibles. Los clientes que compren este producto recibirán códigos generados automáticamente en su lugar. Por favor agregue códigos de licencia para asegurar el funcionamiento adecuado.',
        'no_codes_auto_generate' => 'Este producto está configurado para generar códigos de licencia automáticamente. No se necesitan códigos manuales.',
        'used_code_no_actions' => 'Código usado - no hay acciones disponibles',
        'created_successfully' => '¡Código de licencia creado exitosamente!',
        'updated_successfully' => '¡Código de licencia actualizado exitosamente!',
        'deleted_successfully' => '¡Código de licencia eliminado exitosamente!',
        'generated_successfully' => '¡:count códigos de licencia generados exitosamente!',
        'duplicates_skipped' => ':count códigos duplicados fueron omitidos.',
        'generation_incomplete' => 'Advertencia: Solo se pudieron generar :generated de :requested códigos solicitados debido a conflictos de duplicados.',
        'cannot_edit_used_code' => 'No se puede editar un código de licencia usado.',
        'cannot_delete_used_code' => 'No se puede eliminar un código de licencia usado.',
        'show_all' => 'Mostrar todo',
        'show_less' => 'Mostrar menos',
        'more' => 'más',
        'used_codes_hidden' => ':count código(s) de licencia usado(s) están ocultos. Puede ver todos los códigos en la página de gestión de códigos de licencia.',
        'low_stock_title' => 'Stock bajo de códigos de licencia',
        'low_stock_message' => 'Solo quedan :count códigos de licencia. Considere agregar más códigos para evitar quedarse sin ellos.',
        'out_of_stock_title' => '¡Sin códigos de licencia!',
        'out_of_stock_message' => 'No hay códigos de licencia disponibles. Los clientes recibirán códigos generados automáticamente hasta que agregue más.',
        'type' => [
            'title' => 'Método de asignación de código de licencia',
            'auto_generate' => 'Generar automáticamente (El sistema genera códigos automáticamente)',
            'pick_from_list' => 'Seleccionar de la lista (Usar códigos pre-ingresados)',
            'description' => 'Elija cómo se deben asignar los códigos de licencia a los clientes cuando compren este producto.',
        ],
        'add_modal' => [
            'placeholder' => 'ej., XXXX-XXXX-XXXX-XXXX',
            'help' => 'Ingrese un código de licencia único que se asignará a un cliente al realizar la compra.',
        ],
        'generate_modal' => [
            'title' => 'Generar códigos de licencia',
            'quantity' => 'Cantidad',
            'format' => 'Formato',
            'custom_pattern' => 'Patrón personalizado',
            'pattern_help' => 'Use # para números, A para letras mayúsculas, a para letras minúsculas',
            'generate' => 'Generar',
        ],
        'errors' => [
            'feature_not_enabled' => 'La función de códigos de licencia no está habilitada. Por favor habilítela en Configuración de Ecommerce > Productos digitales.',
            'digital_products_not_enabled' => 'Los productos digitales no están habilitados. Por favor habilite el soporte de productos digitales primero.',
            'product_not_found' => 'Producto no encontrado.',
            'not_digital_product' => 'Los códigos de licencia solo están disponibles para productos digitales. Este producto está configurado como un producto físico.',
            'license_codes_not_enabled_for_product' => 'La gestión de códigos de licencia no está habilitada para este producto. Por favor habilite "Generar código de licencia después de comprar el producto" en la configuración del producto.',
            'cannot_add_codes_auto_generate' => 'No se pueden agregar manualmente códigos de licencia a productos configurados para generar automáticamente. Cambie el tipo de código de licencia a "Seleccionar de la lista" primero.',
            'cannot_generate_codes_auto_generate' => 'No se pueden generar manualmente códigos de licencia para productos configurados para generar automáticamente. Cambie el tipo de código de licencia a "Seleccionar de la lista" primero.',
        ],
        'bulk_delete' => [
            'button' => 'Eliminar seleccionados',
            'selected' => 'seleccionado(s)',
            'confirm' => '¿Está seguro de que desea eliminar los códigos de licencia seleccionados?',
            'deleted_successfully' => ':count código(s) de licencia eliminado(s) exitosamente.',
            'skipped_used_codes' => ':count código(s) usado(s) fueron omitidos.',
            'no_deletable_codes' => 'No se encontraron códigos de licencia disponibles para eliminar. Los códigos usados no pueden ser eliminados.',
        ],
        'import' => [
            'name' => 'Importar códigos de licencia de productos',
            'description' => 'Importar códigos de licencia para productos digitales desde archivo CSV/Excel.',
            'button' => 'Importar',
            'columns' => [
                'product_id' => 'ID o SKU del producto',
                'license_code' => 'Código de licencia',
            ],
        ],
        'copied' => '¡Código de licencia copiado al portapapeles!',
    ],
    'this_action_will_reload_page' => '¡Esta acción recargará la página para actualizar los datos!',
    'select' => 'Seleccionar',
    'clear_filters' => 'Limpiar filtros',
    'set_this_variant_as_default' => 'Establecer esta variante como predeterminada',
    'download' => 'Descargar',
    'external_link_downloads' => 'Enlaces externos',
    'download_available_when_completed' => 'Los enlaces de descarga estarán disponibles cuando el pedido esté completado.',
    'cross_sell_price_type' => [
        'title' => 'Tipo de precio',
        'fixed' => 'Fijo',
        'percent' => 'Porcentaje',
    ],
    'cross_sell_help' => [
        'price' => '* Campo de precio',
        'price_description' => 'Ingrese la cantidad que desea reducir del precio original. Ejemplo: Si el precio original es $100, ingrese 20 para reducir el precio a $80.',
        'type' => '* Campo de tipo',
        'type_description' => 'Elija el tipo de descuento: Fijo (reducir una cantidad específica) o Porcentaje (reducir por un porcentaje).',
    ],
    'up_sell_price_type' => [
        'title' => 'Tipo de precio',
        'fixed' => 'Fijo',
        'percent' => 'Porcentaje',
    ],
    'up_sell_help' => [
        'price' => '* Campo de precio',
        'price_description' => 'Ingrese la cantidad que desea reducir del precio original. Ejemplo: Si el precio original es $100, ingrese 20 para reducir el precio a $80.',
        'type' => '* Campo de tipo',
        'type_description' => 'Elija el tipo de descuento: Fijo (reducir una cantidad específica) o Porcentaje (reducir por un porcentaje).',
    ],
    'up_sale' => [
        'title' => 'Compre junto y ahorre',
        'description' => 'Obtenga descuentos especiales al comprar estos artículos juntos',
        'unlock_discount' => 'Agregue :product al carrito para desbloquear el descuento del paquete',
        'multiple_options' => 'Múltiples opciones',
        'multiple_options_available' => 'Múltiples opciones disponibles',
        'select' => 'Seleccionar',
        'selected_items_total' => 'Total de artículos seleccionados:',
        'add_selected_to_cart' => 'Agregar seleccionados al carrito',
        'bundle_discount_with' => 'Descuento de paquete con :product',
        'bundle_with' => 'Paquete con :product',
    ],
    'cross_sale' => [
        'title' => 'Frecuentemente comprados juntos',
        'description' => 'Los clientes que vieron este artículo también compraron',
    ],
    'apply_for_all_variations' => 'Aplicar para todas las variaciones',
    'export' => [
        'description' => 'Exporte sus datos de productos a archivos CSV o Excel.',
        'total_items' => 'Total de artículos',
        'total_products' => 'Total de productos',
        'total_variations' => 'Total de variaciones',
        'advanced_options' => 'Opciones avanzadas',
        'use_chunked_export' => 'Usar exportación por lotes',
        'use_chunked_export_helper' => 'Procesar datos por lotes para manejar grandes conjuntos de datos de manera eficiente',
        'include_variations' => 'Incluir variaciones de productos',
        'include_variations_helper' => 'Exportar variaciones de productos junto con productos principales',
        'optimize_memory' => 'Optimizar uso de memoria',
        'optimize_memory_helper' => 'Habilitar optimización de memoria para exportaciones muy grandes',
        'chunk_size' => 'Tamaño del lote',
        'chunk_size_helper' => 'Número de productos a procesar a la vez (50-5000)',
        'use_streaming' => 'Usar exportación por streaming',
        'use_streaming_helper' => 'Habilitar streaming para conjuntos de datos muy grandes (habilitado automáticamente para >10,000 artículos)',
        'large_dataset_warning_title' => 'Catálogo de productos grande detectado',
        'large_dataset_warning_message' => 'Su catálogo contiene :count artículos. Debido al gran tamaño, algunas opciones de exportación han sido optimizadas para el mejor rendimiento.',
        'large_dataset_specific_message' => 'Para sus :count productos, use formato CSV con streaming habilitado. El sistema ahora puede manejar su gran catálogo de productos de manera eficiente sin tiempo de espera o problemas de memoria.',
        'format_label' => 'Formato',
        'csv_recommended' => 'CSV (Requerido)',
        'chunk_label' => 'Procesamiento',
        'chunk_recommended' => '300 productos/lote',
        'time_label' => 'Tiempo estimado',
        'time_estimate' => '1-3 minutos',
        'pro_tip' => 'Consejo profesional:',
        'pro_tip_message' => 'La exportación continuará ejecutándose incluso si su navegador muestra un indicador de carga. Una vez iniciado, la descarga comenzará automáticamente.',
        'large_dataset_tip_1' => 'El formato Excel ha sido deshabilitado - use formato CSV para exportaciones más rápidas y confiables',
        'large_dataset_tip_2' => 'El modo streaming se ha habilitado automáticamente para prevenir tiempo de espera',
        'large_dataset_tip_3' => 'El proceso de exportación puede tomar 1-3 minutos dependiendo de su servidor',
        'large_dataset_recommendation' => 'Recomendado: Use formato CSV con tamaño de lote 200-500 para rendimiento óptimo.',
        'excel_disabled_for_large_export' => 'Formato Excel no disponible para catálogos de más de 10,000 artículos',
        'streaming_auto_enabled' => 'El modo streaming se ha habilitado automáticamente para rendimiento óptimo con grandes conjuntos de datos.',
        'streaming_enabled_title' => 'Optimizado para exportación grande',
        'streaming_enabled_message' => 'El modo streaming está activo para asegurar una exportación fluida sin problemas de memoria.',
        'use_multi_file' => 'Usar exportación de múltiples archivos',
        'use_multi_file_helper' => 'Dividir la exportación en múltiples archivos empaquetados en un ZIP para conjuntos de datos muy grandes',
        'multi_file_enabled_title' => 'Exportación de múltiples archivos habilitada',
        'multi_file_enabled_message' => 'Su exportación se dividirá en :count archivos empaquetados en un ZIP para un rendimiento óptimo.',
        'records_per_file' => 'Registros por archivo',
        'records_per_file_helper' => 'Número de registros en cada archivo al usar la exportación de múltiples archivos',
        'estimated_files' => 'Archivos estimados',
        'recommended_range' => 'Rango recomendado',
        'range_large_export' => '200-500 artículos',
        'range_medium_export' => '300-800 artículos',
        'range_small_export' => '500-1000 artículos',
        'export_progress' => 'Progreso de exportación',
        'preparing_export' => 'Preparando exportación...',
        'items_processed' => ':count artículos procesados',
        'estimated_time_calculating' => 'Tiempo estimado: calculando...',
        'medium_dataset_detected' => 'Conjunto de datos mediano detectado',
        'medium_dataset_message' => 'Está exportando :count productos. Considere usar exportación por lotes para mejor rendimiento.',
        'optimal_range' => 'Rango óptimo',
        'too_small_slow' => 'Muy pequeño - puede ser lento',
        'too_large_timeouts' => 'Muy grande - puede causar tiempo de espera',
        'excel_disabled_warning' => 'Formato Excel deshabilitado para grandes exportaciones (:count artículos)',
        'starting_export' => 'Iniciando exportación...',
        'processing_data' => 'Procesando datos...',
        'finalizing_export' => 'Finalizando exportación...',
        'items_processed_suffix' => 'artículos procesados',
        'estimated_time_prefix' => 'Tiempo estimado:',
        'seconds_remaining' => 's restantes',
        'export_completed' => '¡Exportación completada!',
        'download_starting' => 'Iniciando descarga...',
    ],
    'import' => [
        'description' => 'Importe sus datos de productos desde archivos CSV o Excel.',
        'rules' => [
            'in' => ':attribute debe ser uno de los valores definidos: :values.',
            'required_string_max' => ':attribute es requerido y debe ser una cadena con una longitud máxima de :max caracteres.',
            'nullable_string' => ':attribute puede dejarse vacío o debe ser una cadena si se proporciona.',
            'nullable_string_max' => ':attribute puede dejarse vacío o debe ser una cadena con una longitud máxima de :max caracteres si se proporciona',
            'nullable_bool' => ':attribute puede dejarse vacío o debe ser un valor booleano si se proporciona.',
            'nullable_numeric_min' => ':attribute puede dejarse vacío o debe ser un número no negativo si se proporciona.',
            'nullable_numeric_min_max' => ':attribute puede dejarse en blanco o debe ser un número entre :min y :max si se proporciona.',
            'nullable_array' => ':attribute puede dejarse vacío o debe proporcionarse como un array si se especifica.',
            'nullable_date_required_if' => ':attribute puede dejarse vacío o debe ser una fecha válida si se proporciona, requerido si se especifica :required.',
            'nullable_date_after' => ':attribute puede dejarse vacío o debe ser una fecha válida después de :after si se proporciona.',
        ],
        'updated_message' => '¡:count productos actualizados exitosamente!',
    ],
    'import_products_intro' => 'O importar productos desde CSV/Excel',
    'select_attributes' => 'Seleccionar atributos para crear variaciones:',
    'all' => 'Todo',
    'copy' => 'Copiar',
    'product_translations' => 'Traducciones del producto',
    'view' => 'Ver producto - :name',
    'product_information' => 'Información del producto',
    'total_views' => 'Vistas totales',
    'total_orders' => 'Pedidos completados',
    'total_sold' => 'Total vendido',
    'total_revenue' => 'Ingresos totales',
    'pending_orders' => 'Pedidos pendientes',
    'pending_revenue' => 'Ingresos pendientes',
    'conversion_rate' => 'Tasa de conversión',
    'total_reviews' => 'Reseñas totales',
    'average_rating' => 'Calificación promedio',
    'views_by_date' => 'Vistas por fecha (Últimos 30 días)',
    'recent_orders' => 'Pedidos recientes',
    'no_views_data' => 'No hay datos de vistas disponibles para los últimos 30 días.',
    'no_orders' => 'Aún no hay pedidos.',
    'date' => 'Fecha',
    'views' => 'Vistas',
    'total' => 'Total',
    'view_on_frontend' => 'Ver en el frontend',
    'select_attribute' => 'Seleccionar :name',
    'all_categories' => 'Todas las categorías',
    'brands' => 'Marcas',
    'browse_products' => 'Explorar productos',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Seleccionar productos para devolver',
    'show_only_discounted_products' => 'Mostrar solo productos con descuento',
    'specification' => 'Especificación',
    'download_product_with_external_links' => 'Descargar producto ":name" con enlaces externos',
    'number_product_available_singular' => ':number producto disponible',
    'number_products_available_plural' => ':number productos disponibles',
    'cart' => [
        'added_to_cart_success' => ':product ha sido añadido a su carrito.',
        'removed_from_cart_success' => ':product ha sido eliminado de su carrito.',
        'updated_cart_success' => 'Su carrito ha sido actualizado.',
        'item_not_found' => 'Este artículo ya no está en su carrito.',
        'out_of_stock' => 'Lo sentimos, :product está agotado actualmente.',
        'max_quantity' => 'Solo puede añadir hasta :max artículos.',
        'max_quantity_detail' => 'Lo sentimos, solo puede pedir hasta :quantity unidades de :product a la vez.',
        'select_options' => 'Por favor seleccione las opciones del producto antes de añadir al carrito.',
        'product_out_of_stock' => 'Lo sentimos, este producto está agotado actualmente.',
        'product_not_exists' => 'Este producto está agotado o ya no existe.',
        'not_enough_quantity' => 'Algunos productos no tienen suficiente stock para actualizar.',
        'empty_success' => 'Su carrito ha sido vaciado.',
        'bundle_item_already_in_cart' => 'Este artículo del paquete ya está en su carrito. Solo se permite 1 artículo por descuento de paquete.',
    ],
    'wishlist' => [
        'added_success' => ':product ha sido añadido a su lista de deseos.',
        'removed_success' => ':product ha sido eliminado de su lista de deseos.',
        'product_not_found' => 'Este producto no pudo ser encontrado.',
        'product_not_in_wishlist' => 'Este producto no está en su lista de deseos.',
        'product_not_available' => 'Este producto no está disponible.',
    ],
    'compare' => [
        'added_success' => ':product ha sido añadido a su lista de comparación.',
        'removed_success' => ':product ha sido eliminado de su lista de comparación.',
        'product_not_found' => 'Este producto no pudo ser encontrado.',
        'product_not_in_compare' => 'Este producto no está en su lista de comparación.',
        'already_in_list' => ':product ya está en su lista de comparación.',
    ],
];
