<?php

return [
    'save_settings' => 'Einstellungen speichern',
    'ecommerce' => 'E-Commerce',
    'general' => [
        'name' => 'Allgemein',
        'description' => 'Shopname, Firmeninfo, Kontaktdaten und Admin-Benachrichtigungs-E-Mails',
    ],
    'currency' => [
        'name' => 'Währungen',
        'description' => 'Währungsformate, Wechselkurse, Auto-Erkennung und Dezimal-/Tausendertrennzeichen',
        'currency_setting_description' => 'Währungen anzeigen und aktualisieren, die auf der Website verwendet werden',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Automatische Erkennung der Besucherwährung aktivieren',
            'enable_auto_detect_visitor_currency_helper' => 'Automatisch die lokale Währung des Besuchers erkennen und Preise basierend auf seinem Standort anzeigen. Dies bietet ein personalisiertes Einkaufserlebnis.',
            'add_space_between_price_and_currency' => 'Leerzeichen zwischen Preis und Währung hinzufügen',
            'add_space_between_price_and_currency_helper' => 'Wenn aktiviert, wird ein Leerzeichen zwischen Preiswert und Währungssymbol eingefügt (z.B. \"100 USD\" statt \"100USD\").',
            'thousands_separator' => 'Tausendertrennzeichen',
            'thousands_separator_helper' => 'Wählen Sie das Zeichen zur Trennung von Tausenden in der Preisanzeige (z.B. 1.000 oder 1,000 oder 1 000).',
            'decimal_separator' => 'Dezimaltrennzeichen',
            'decimal_separator_helper' => 'Wählen Sie das Zeichen zur Trennung von Dezimalwerten in Preisen (z.B. 10,99 oder 10.99).',
            'separator_period' => 'Punkt (.)',
            'separator_comma' => 'Komma (,)',
            'separator_space' => 'Leerzeichen ( )',
            'api_key' => 'API-Wechselkurs-Schlüssel',
            'api_key_helper' => 'Wechselkurs-API-Schlüssel abrufen auf :link',
            'update_currency_rates' => 'Währungskurse aktualisieren',
            'use_exchange_rate_from_api' => 'Wechselkurs aus API verwenden',
            'use_exchange_rate_from_api_helper' => 'Automatische Aktualisierungen der Wechselkurse vom konfigurierten API-Anbieter aktivieren. Dies stellt sicher, dass Ihre Preise immer mit den aktuellen Marktkursen aktualisiert sind.',
            'clear_cache_rates' => 'Cache-Kurse löschen',
            'auto_detect_visitor_currency_description' => 'Es erkennt die Besucherwährung basierend auf der Browsersprache. Es überschreibt die Standard-Währungsauswahl.',
            'exchange_rate' => [
                'api_provider' => 'API-Anbieter',
                'select' => '-- Auswählen --',
                'none' => 'Keine',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'Für die Standardwährung muss der Wechselkurs 1 sein.',
        ],
    ],
    'product' => [
        'name' => 'Produkte',
        'description' => 'Lageranzeige, SKU-Generierung, Variantenbilder, verwandte Produkte und Spezifikationen',
        'product_settings' => 'Produkteinstellungen',
        'product_settings_description' => 'Regeln für Produkte konfigurieren',
        'form' => [
            'show_number_of_products' => 'Anzahl der Produkte in der Produktansicht anzeigen',
            'show_number_of_products_helper' => 'Die Gesamtanzahl der Produkte auf der Produktdetailseite anzeigen.',
            'show_out_of_stock_products' => 'Nicht vorrätige Produkte anzeigen',
            'show_out_of_stock_products_helper' => 'Wenn aktiviert, werden nicht vorrätige Produkte auf der Produktliste angezeigt.',
            'how_to_display_product_variation_images' => 'Wie Produktvariationsbilder angezeigt werden',
            'how_to_display_product_variation_images_helper' => 'Wählen Sie, ob nur variationsspezifische Bilder oder sowohl Variations- als auch Hauptproduktbilder angezeigt werden.',
            'only_variation_images' => 'Nur Variationsbilder',
            'variation_images_and_main_product_images' => 'Variationsbilder und Hauptproduktbilder',
            'enable_product_options' => 'Produktoptionen aktivieren',
            'enable_product_options_helper' => 'Produkten erlauben, anpassbare Optionen wie Größe, Farbe usw. zu haben.',
            'is_enabled_cross_sale_products' => 'Cross-Sale-Produkte aktivieren',
            'is_enabled_cross_sale_products_helper' => 'Cross-Sale-Produktvorschläge anzeigen, um zusätzliche Käufe zu fördern.',
            'is_enabled_related_products' => 'Verwandte Produkte aktivieren',
            'is_enabled_related_products_helper' => 'Verwandte Produkte basierend auf Kategorie oder vom Admin im Produktformular ausgewählte anzeigen.',
            'related_products_source' => 'Quelle verwandter Produkte',
            'related_products_source_helper' => 'Wenn der Admin keine verwandten Produkte im Produktformular auswählt, verwandte Produkte basierend auf dieser Quelle anzeigen.',
            'related_products_source_category' => 'Gleiche Kategorie',
            'related_products_source_brand' => 'Gleiche Marke',
            'trending_products_period' => 'Zeitraum für Trendprodukte',
            'trending_products_period_helper' => 'Wählen Sie den Zeitraum für die Berechnung von Trendprodukten basierend auf der Aufrufanzahl.',
            'trending_products_period_1_day' => 'Letzten 24 Stunden',
            'trending_products_period_3_days' => 'Letzten 3 Tage',
            'trending_products_period_7_days' => 'Letzten 7 Tage (1 Woche)',
            'trending_products_period_14_days' => 'Letzten 14 Tage (2 Wochen)',
            'trending_products_period_30_days' => 'Letzten 30 Tage (1 Monat)',
            'trending_products_period_60_days' => 'Letzten 60 Tage (2 Monate)',
            'trending_products_period_90_days' => 'Letzten 90 Tage (3 Monate)',
            'auto_generate_product_sku' => 'SKU beim Erstellen von Produkten automatisch generieren',
            'auto_generate_product_sku_helper' => 'Automatisch eindeutige SKUs für neue Produkte basierend auf dem Format unten generieren.',
            'product_sku_format' => 'SKU-Format',
            'product_sku_format_helper' => 'Sie können %s (1 Zeichen) oder %d (1 Ziffer) im Format verwenden, um zufällige Strings zu generieren. Bsp.: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Produktspezifikation aktivieren',
            'enable_product_specification_help' => 'Wenn aktiviert, wird die Produktspezifikationstabelle auf der Produktdetailseite angezeigt.',
            'make_product_barcode_required' => 'Produkt-Barcode erforderlich machen',
            'make_product_barcode_required_helper' => 'Wenn aktiviert, ist der Produkt-Barcode beim Erstellen eines Produkts erforderlich.',
        ],
    ],
    'product_search' => [
        'name' => 'Produktsuche',
        'description' => 'Suchverhalten, Filter nach Kategorie/Marke/Tag/Attributen und Preisbereichsfilterung',
        'product_search_settings' => 'Produktsuche',
        'product_search_settings_description' => 'Regeln für Produktsuche konfigurieren',
        'form' => [
            'search_for_an_exact_phrase' => 'Nach einer genauen Phrase suchen',
            'search_products_by' => 'Produkte suchen nach:',
            'enable_filter_products_by_categories' => 'Filter nach Kategorien aktivieren',
            'enable_filter_products_by_brands' => 'Filter nach Marken aktivieren',
            'enable_filter_products_by_tags' => 'Filter nach Tags aktivieren',
            'number_of_popular_tags_for_filter' => 'Anzahl populärer Tags für Filter',
            'number_of_popular_tags_for_filter_placeholder' => 'Anzahl der anzuzeigenden populären Tags eingeben',
            'number_of_popular_tags_for_filter_helper' => 'Maximale Anzahl populärer Tags im Filter festlegen. Standard ist 10.',
            'enable_filter_products_by_attributes' => 'Filter nach Attributen aktivieren',
            'enable_filter_products_by_price' => 'Filter nach Preis aktivieren',
            'max_product_price_for_filter' => 'Maximaler Produktpreis für Filter',
            'max_product_price_for_filter_placeholder' => 'Wenn leer oder null, wird der maximale Produktpreis aus Ihren vorhandenen Produkten abgerufen.',
            'max_product_price_for_filter_helper' => 'Sie können einen festen Preis dafür festlegen oder er wird dynamisch den maximalen Produktpreis aus Ihren vorhandenen Produkten abrufen. Derzeit ist es :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Digitale Produkte',
        'description' => 'Herunterladbare Produkte, Lizenzcodes, Gastkauf für digitale Artikel und automatische Vervollständigung',
        'digital_products_settings' => 'Digitale Produkte',
        'digital_products_settings_description' => 'Regeln für digitale Produkte konfigurieren',
        'form' => [
            'enable_support_digital_product' => 'Unterstützung für digitale Produkte aktiviert',
            'enable_support_digital_product_helper' => 'Wenn aktiviert, unterstützt das System den Verkauf digitaler Produkte wie Software, E-Books, Musik und andere herunterladbare Inhalte.',
            'allow_guest_checkout_for_digital_products' => 'Gast-Checkout für digitale Produkte erlauben',
            'allow_guest_checkout_for_digital_products_helper' => 'Wenn aktiviert, können Kunden digitale Produkte ohne Kontoerstellung kaufen. Sie erhalten Download-Links per E-Mail.',
            'disable_physical_product' => 'Physische Produkte deaktivieren',
            'disable_physical_product_helper' => 'Wenn aktiviert, verkauft der Shop nur digitale Produkte. Physische Produktoptionen werden in Produktformularen und Checkout ausgeblendet.',
            'enable_license_codes_for_digital_products' => 'Lizenzcodes für digitale Produkte aktivieren',
            'auto_complete_digital_orders_after_payment' => 'Digitale Bestellungen nach Zahlung automatisch abschließen',
            'auto_complete_digital_orders_after_payment_helper' => 'Wenn aktiviert, werden Bestellungen mit nur digitalen Produkten automatisch als abgeschlossen markiert, sobald die Zahlung eingegangen ist.',
            'enable_license_codes_for_digital_products_helper' => 'Wenn aktiviert, können Sie Lizenzcodes zu digitalen Produkten hinzufügen. Wenn deaktiviert, wird die Lizenzcode-Funktionalität in Produktformularen ausgeblendet.',
            'hide_used_license_codes_in_product_form' => 'Verwendete Lizenzcodes im Produktformular ausblenden',
            'hide_used_license_codes_in_product_form_helper' => 'Wenn aktiviert, werden verwendete Lizenzcodes in der Lizenzcodes-Tabelle im Produktbearbeitungsformular ausgeblendet. Dies hilft, die Oberfläche sauber zu halten, wenn Sie viele verwendete Codes haben.',
        ],
    ],
    'product_review' => [
        'name' => 'Produktbewertungen',
        'description' => 'Kundenbewertungen, Bewertungsanzeige, Bild-Uploads und Genehmigungsanforderungen',
        'form' => [
            'enable_review' => 'Produktbewertungen aktivieren',
            'enable_review_help' => 'Kunden erlauben, Bewertungen und Ratings für Produkte zu hinterlassen. Wenn deaktiviert, werden alle Bewertungsfunktionen im Shop ausgeblendet.',
            'allow_customer_upload_image_in_review' => 'Kunden erlauben, Bilder in Bewertungen hochzuladen',
            'allow_customer_upload_image_in_review_help' => 'Wenn deaktiviert, können Kunden beim Einreichen von Bewertungen keine Bilder hochladen',
            'review' => [
                'max_file_size' => 'Maximale Dateigröße für Bewertungen (MB)',
                'max_file_number' => 'Maximale Dateianzahl für Bewertungen',
            ],
            'only_allow_customers_purchased_to_review' => 'Nur Kunden, die das Produkt gekauft haben, können es bewerten',
            'review_need_to_be_approved' => 'Bewertung muss vor Anzeige auf der Produktseite genehmigt werden',
            'show_customer_full_name' => 'Vollständigen Kundennamen anzeigen',
            'show_customer_full_name_help' => 'Wenn nicht markiert, wird der Name des bewertenden Kunden ausgeblendet und durch Sternchen (***) ersetzt',
            'hide_rating_when_no_reviews' => 'Bewertung ausblenden, wenn keine Bewertungen vorhanden sind',
            'hide_rating_when_no_reviews_help' => 'Wenn aktiviert, werden Produktbewertungen in Produktlisten und Produktdetailseiten ausgeblendet, wenn das Produkt keine Bewertungen hat',
            'display_uploaded_customer_review_images_list' => 'Abschnitt "Bilder von Kunden" anzeigen',
            'display_uploaded_customer_review_images_list_help' => 'Wenn aktiviert, wird eine Galerie aller von Kunden hochgeladenen Bilder oben im Bewertungsbereich angezeigt',
        ],
    ],
    'shopping' => [
        'name' => 'Einkaufen',
        'description' => 'Warenkorb, Wunschliste, Vergleich, Bestellverfolgung, Schnellkauf-Button und Zahlungsnachweis-Uploads',
        'general_setting' => 'Allgemeine Einstellungen',
        'return_settings' => 'Rückgabeeinstellungen',
        'return_settings_description' => 'Regeln für Rückgabeeinstellungen konfigurieren',
        'form' => [
            'enable_cart' => 'Einkaufswagen aktivieren',
            'enable_cart_helper' => 'Wenn deaktiviert, wird die Warenkorb-Schaltfläche entfernt und Ihre Site wird zu einer reinen Katalogansicht.',
            'enable_wishlist' => 'Wunschliste aktivieren',
            'enable_wishlist_helper' => 'Wenn deaktiviert, wird die Wunschlisten-Schaltfläche von der Site entfernt.',
            'enable_wishlist_sharing' => 'Wunschlisten-Sharing aktivieren',
            'shared_wishlist_lifetime' => 'Lebensdauer geteilter Wunschliste (Tage)',
            'shared_wishlist_lifetime_helper' => 'Die Lebensdauer der geteilten Wunschliste in Tagen. Nach dieser Zeit wird die geteilte Wunschliste gelöscht.',
            'enable_compare' => 'Vergleichen aktivieren',
            'enable_compare_helper' => 'Wenn deaktiviert, wird die Vergleichen-Schaltfläche von der Site entfernt.',
            'enable_order_tracking' => 'Bestellverfolgung aktivieren',
            'enable_order_tracking_helper' => 'Kunden können ihre Bestellungen verfolgen, indem sie den Bestellcode und E-Mail/Telefon auf :url eingeben',
            'order_tracking_method' => 'Bestellverfolgungsmethode',
            'order_tracking_method_helper' => 'Wählen Sie, wie Kunden ihre Bestellungen verfolgen: mit Bestell-ID + E-Mail oder Bestell-ID + Telefonnummer.',
            'order_tracking_method_email' => 'Bestell-ID + E-Mail',
            'order_tracking_method_phone' => 'Bestell-ID + Telefonnummer',
            'enable_quick_buy_button' => 'Schnellkauf-Schaltfläche aktivieren',
            'enable_quick_buy_button_helper' => 'Zeigt eine "Jetzt kaufen"-Schaltfläche auf der Produktliste und Detailseite. Wenn Kunden darauf klicken, wird das Produkt in den Warenkorb gelegt und zur Warenkorb-/Checkout-Seite weitergeleitet.',
            'enable_order_auto_confirmed' => 'Bestellung automatisch bestätigen',
            'enable_order_auto_confirmed_helper' => 'Wenn aktiviert, wird die Bestellung automatisch bestätigt, nachdem der Kunde eine Bestellung aufgegeben hat.',
            'quick_buy_target' => 'Schnellkauf-Zielseite',
            'checkout_page' => 'Checkout-Seite',
            'cart_page' => 'Warenkorb-Seite',
            'cart_destroy_on_logout' => 'Warenkorb beim Abmelden leeren',
            'cart_destroy_on_logout_helper' => 'Der Warenkorb wird geleert, wenn sich der Kunde abmeldet.',
            'hide_product_price' => 'Produktpreis ausblenden',
            'hide_product_price_helper' => 'Diese Option funktioniert nur, wenn Sie den Einkaufswagen deaktivieren und Ihre Site zu einer reinen Katalogansicht machen. Wenn aktiviert, wird der Produktpreis ausgeblendet. Nützlich, wenn Sie den Preis ausblenden und Kunden auffordern möchten, Sie für den Preis zu kontaktieren.',
            'hide_product_price_when_zero' => 'Produktpreis ausblenden, wenn er null ist',
            'hide_product_price_when_zero_helper' => 'Wenn aktiviert, wird bei Produkten mit Preis 0 kein Preis im Shop angezeigt.',
            'enable_payment_proof' => 'Zahlungsnachweis-Upload aktivieren',
            'enable_payment_proof_helper' => 'Kunden erlauben, Zahlungsnachweise für ihre Bestellungen hochzuladen. Nützlich für manuelle Zahlungsmethoden.',
            'enable_guest_payment_proof' => 'Gästen erlauben, Zahlungsnachweise hochzuladen',
            'enable_guest_payment_proof_helper' => 'Wenn aktiviert, können Gastkunden Zahlungsnachweise mit ihrem Bestelltoken hochladen, ohne sich anzumelden. Sie erhalten den Upload-Link in ihrer Bestellbestätigungs-E-Mail.',
            'payment_proof_payment_methods' => 'Zahlungsmethoden, die einen Zahlungsnachweis erfordern',
            'payment_proof_payment_methods_helper' => 'Wählen Sie aus, welche Zahlungsmethoden Kunden das Hochladen eines Zahlungsnachweises ermöglichen sollen. Wird normalerweise für manuelle Zahlungsmethoden wie Nachnahme und Banküberweisung verwendet.',
        ],
    ],
    'checkout' => [
        'name' => 'Checkout',
        'panel_description' => 'Gastkauf, Pflichtfelder, Bestelllimits, AGB-Akzeptanz und Länderbeschränkungen',
        'description' => 'Regeln für Checkout-Einstellungen konfigurieren',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Bankdaten auf der Checkout-Erfolgsseite anzeigen',
            'mandatory_form_fields_at_checkout' => 'Pflichtfelder auf der Checkout-Seite:',
            'mandatory_form_fields_at_checkout_helper' => 'Wählen Sie, welche Felder während des Checkouts erforderlich sind. Kunden müssen diese Felder ausfüllen, um ihre Bestellung abzuschließen.',
            'hide_form_fields_at_checkout' => 'Kundenfelder auf Checkout-Seite ausblenden:',
            'hide_form_fields_at_checkout_helper' => 'Wählen Sie, welche Felder auf der Checkout-Seite ausgeblendet werden sollen. Diese Felder sind für Kunden nicht sichtbar.',
            'load_countries_states_cities_from_location_plugin' => 'Länder, Bundesländer, Städte aus Standort-Plugin laden',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Nach Änderung dieser Option müssen Sie alle Adressen erneut aktualisieren. Sie sollten dies einmalig einstellen.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Dann müssen Sie zu Tools -> Import/Export Daten gehen, um Standortdaten zu importieren.',
            'minimum_order_amount' => 'Mindestbestellwert für eine Bestellung (:currency).',
            'minimum_order_amount_helper' => 'Mindestgesamtbetrag festlegen, der für die Bearbeitung einer Bestellung erforderlich ist. Bestellungen unter diesem Betrag werden nicht akzeptiert.',
            'zip_code_enabled' => 'Postleitzahl aktivieren',
            'zip_code_enabled_helper' => 'Postleitzahlenfeld im Versandadressformular aktivieren oder deaktivieren.',
            'billing_address_enabled' => 'Rechnungsadresse aktivieren',
            'billing_address_enabled_helper' => 'Kunden erlauben, eine separate Rechnungsadresse einzugeben, die sich von ihrer Versandadresse unterscheidet.',
            'display_tax_fields_at_checkout_page' => 'Steuerinformationsfelder auf der Checkout-Seite anzeigen',
            'display_tax_fields_at_checkout_page_helper' => 'Wenn aktiviert, werden Steuerinformationsfelder für die Eingabe von Firmensteuerdetails zum Erhalt einer Rechnung angezeigt.',
            'use_city_field_as_field_text' => 'Stadtfeld als freies Textfeld verwenden',
            'available_countries' => 'Verfügbare Länder',
            'all' => 'Alle',
            'all_helper_text' => 'Wenn Sie alle Länder abwählen, gilt es für alle Länder.',
            'enable_guest_checkout' => 'Gast-Checkout aktivieren',
            'enable_guest_checkout_helper' => 'Wenn aktiviert, können Kunden eine Bestellung ohne Kontoerstellung aufgeben.',
            'recently_viewed' => [
                'enable' => 'Kürzlich angesehene Produkte für Kunden aktivieren',
                'enable_helper' => 'Produkte verfolgen und anzeigen, die Kunden kürzlich angesehen haben. Dies hilft Kunden, interessante Produkte leicht wiederzufinden.',
                'max' => 'Maximale Anzahl kürzlich angesehener Kundenprodukte',
                'max_helper_text' => 'Wenn auf 0 gesetzt, gibt es keine Begrenzung.',
            ],
            'minimum_order_quantity' => 'Mindestbestellmenge',
            'minimum_order_quantity_helper' => 'Mindestmenge für eine Bestellung. Lassen Sie es bei 0, wenn Sie es nicht festlegen möchten.',
            'maximum_order_quantity' => 'Maximale Bestellmenge',
            'maximum_order_quantity_helper' => 'Maximale Menge für eine Bestellung. Lassen Sie es bei 0, wenn Sie es nicht festlegen möchten.',
            'default_country_at_checkout_page' => 'Standardland auf der Checkout-Seite',
            'default_country_at_checkout_page_placeholder' => 'Land auswählen',
            'default_country_at_checkout_page_help' => 'Wenn Sie ein Land auswählen, wird das Land standardmäßig auf der Checkout-Seite ausgewählt.',
            'checkout_product_quantity_editable' => 'Kunden erlauben, Produktmenge auf der Checkout-Seite zu ändern',
            'checkout_product_quantity_editable_helper' => 'Wenn aktiviert, können Kunden die Menge der Produkte direkt auf der Checkout-Seite ändern, ohne zum Warenkorb zurückzukehren.',
            'show_terms_and_policy_checkbox' => 'AGB und Datenschutz-Checkbox anzeigen',
            'show_terms_and_policy_checkbox_helper' => 'Wenn aktiviert, müssen Kunden den AGB und Datenschutzbestimmungen zustimmen, bevor sie eine Bestellung aufgeben. Bitte richten Sie zuerst die AGB und Datenschutz-URL in Erscheinungsbild -> Theme-Optionen ein.',
            'terms_and_policy_checkbox_checked_by_default' => 'AGB und Datenschutz-Checkbox standardmäßig aktiviert',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Wenn aktiviert, wird die AGB und Datenschutz-Checkbox beim Laden des Checkout-Formulars vorab markiert.',
            'checkout_acceptance_message_enabled' => 'Checkout-Akzeptanznachricht anzeigen',
            'checkout_acceptance_message_enabled_helper' => 'Eine Informationsnachricht anzeigen, die Kunden über die Bedingungen informiert, denen sie durch Aufgabe einer Bestellung zustimmen.',
            'hide_customer_info_at_checkout' => 'Kundeninfo beim Checkout ausblenden',
            'hide_customer_info_at_checkout_helper' => 'Die Kundenkontoinformationen und Abmelde-Schaltfläche von der Checkout-Seite ausblenden. Wenn aktiviert, sehen angemeldete Kunden ihre Kontodetails nicht angezeigt.',
        ],
    ],
    'return' => [
        'name' => 'Rückgabe',
        'description' => 'Regeln für Rückgabeeinstellungen konfigurieren',
        'panel_description' => 'Bestellrückgaben, Teilrückgaben und Rückgabefristen',
        'form' => [
            'is_enabled_order_return' => 'Bestellrückgabe aktiviert',
            'allow_partial_return' => 'Teilrückgabe erlauben',
            'allow_partial_return_description' => 'Kunde kann einige Produkte zurückgeben, muss nicht alle Produkte einer Bestellung zurückgeben.',
            'returnable_days' => 'Rückgabetage',
            'return_settings_helper' => 'Anzahl der Tage, die ein Kunde nach Abschluss der Bestellung eine Rückgabe anfordern kann.',
        ],
    ],
    'invoice' => [
        'name' => 'Rechnungen',
        'description' => 'Firmendetails auf Rechnungen, Rechnungsnummerierung, PDF-Schriften und Stempeleinstellungen',
        'company_settings' => 'Rechnungskonfiguration',
        'company_settings_description' => 'Firmeninfo, Rechnungsnummerierung, PDF-Schriften und Zahlungsstempel',
        'form' => [
            'company_name' => 'Firmenname',
            'company_name_helper' => 'Ihr Firmen- oder Geschäftsname, der auf allen an Kunden gesendeten Rechnungen erscheint.',
            'company_name_placeholder' => 'Acme GmbH',
            'company_address' => 'Firmenadresse',
            'company_address_helper' => 'Die vollständige Adresse Ihres Unternehmens einschließlich Straße, Stadt, Bundesland und Land. Dies wird auf Rechnungen erscheinen.',
            'company_address_placeholder' => 'Hauptstraße 123, Suite 100, 10115 Berlin, Deutschland',
            'company_zipcode' => 'Firmen-Postleitzahl',
            'company_zipcode_helper' => 'Postleitzahl für Ihre Firmenadresse.',
            'company_zipcode_placeholder' => '10115',
            'company_email' => 'Firmen-E-Mail',
            'company_email_helper' => 'E-Mail-Adresse für geschäftliche Anfragen. Kunden können diese für rechnungsbezogene Fragen verwenden.',
            'company_email_placeholder' => 'rechnung@firma.de',
            'company_phone' => 'Firmen-Telefon',
            'company_phone_helper' => 'Kontakttelefonnummer, die auf Rechnungen für den Kundensupport angezeigt wird.',
            'company_phone_placeholder' => '+49 30 12345678',
            'company_logo' => 'Firmenlogo',
            'company_logo_helper' => 'Ihr Firmenlogo, das oben auf den Rechnungen angezeigt wird. Empfohlene Größe: 200x60 Pixel.',
            'company_tax_id' => 'Firmen-Steuer-ID',
            'company_tax_id_helper' => 'Ihre steuerliche Identifikationsnummer (USt-IdNr., Steuernummer usw.) für die Steuereinhaltung.',
            'company_tax_id_placeholder' => 'USt-IdNr: DE123456789',
            'invoice_code_prefix' => 'Rechnungscode-Präfix',
            'invoice_code_prefix_helper' => 'Präfix vor Rechnungsnummern (z.B. \"RECH-\" erstellt Rechnungscodes wie RECH-001, RECH-002).',
            'invoice_code_prefix_placeholder' => 'RECH-',
            'using_custom_font_for_invoice' => 'Benutzerdefinierte Schrift für Rechnung verwenden',
            'using_custom_font_for_invoice_helper' => 'Aktivieren, um eine benutzerdefinierte Google-Schriftart für Rechnungs-PDFs anstelle der Standardschriftart zu verwenden.',
            'invoice_font_family' => 'Rechnungsschriftart (Funktioniert nur für lateinische Sprachen)',
            'invoice_font_family_helper' => 'Wählen Sie eine Google-Schriftart für Rechnungs-PDFs. Funktioniert nur mit lateinischen Zeichensätzen.',
            'enable_invoice_stamp' => 'Rechnungsstempel aktivieren',
            'enable_invoice_stamp_helper' => 'Fügt den Rechnungen einen \"BEZAHLT\"-Stempel hinzu, wenn die Bestellzahlung abgeschlossen ist.',
            'add_language_support' => 'Sprachunterstützung hinzufügen',
            'add_language_support_helper' => 'Wählen Sie zusätzliche Zeichensatzunterstützung für nicht-lateinische Sprachen in Rechnungs-PDFs.',
            'invoice_processing_library' => 'Rechnungsverarbeitungsbibliothek',
            'invoice_processing_library_helper' => 'Wählen Sie die PDF-Generierungsbibliothek. DomPDF ist schneller, hat aber begrenzte Funktionen. mPDF unterstützt mehr Sprachen und Funktionen, kann aber langsamer sein.',
            'only_latin_languages' => 'Nur lateinische Sprachen',
            'disable_order_invoice_until_order_confirmed' => 'Bestellrechnung deaktivieren, bis Bestellung bestätigt ist',
            'disable_order_invoice_until_order_confirmed_helper' => 'Wenn aktiviert, sind Rechnungen erst nach Bestellbestätigung verfügbar, nicht sofort nach Bestellaufgabe.',
            'date_format' => 'Datumsformat',
            'date_format_helper' => 'Wählen Sie, wie Daten auf Rechnungen angezeigt werden (z.B. \"F d, Y\" zeigt \"Januar 01, 2024\").',
            'languages' => [
                'arabic' => 'Arabisch',
                'bangladesh' => 'Bengalisch',
                'chinese' => 'Chinesisch',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Steuer',
        'description' => 'Steuerberechnung, Anzeigeoptionen und Checkout-Rechnungsfelder',
        'enable' => 'Steuer aktivieren?',
        'display_product_price_including_taxes' => 'Produktpreis inklusive Steuern anzeigen?',
        'display_tax_description' => 'Steuerinformationen zum Produktpreis anzeigen?',
        'display_tax_description_help' => 'Text wie "(Inklusive X% MwSt.)" oder "(Exklusive X% MwSt.)" neben Produktpreisen auf der Produktdetailseite anzeigen.',
        'tax_included_in_products_price' => 'Steuer in Produktpreisen enthalten',
        'tax_included_in_products_price_description' => 'Steuer wird in Produktpreisen enthalten sein',
        'tax_setting' => 'Steueranzeige & Checkout',
        'tax_setting_description' => 'Konfigurieren Sie, wie Steuern auf Produkten und Checkout-Seiten angezeigt werden',
        'tax_management' => 'Steuerverwaltung',
        'tax_management_description' => 'Ihre Steuern anzeigen und verwalten',

        'manage_taxes_info' => 'Um Steuern zu verwalten und den Standard-Steuersatz festzulegen, gehen Sie bitte zu',
        'go_to_taxes' => 'E-Commerce → Steuern',        'form' => [
            'enable_tax' => 'Steuer aktivieren',
            'display_company_invoice_information_fields_at_checkout_page' => 'Firmenrechnungsinformationsfelder auf der Checkout-Seite anzeigen',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Wenn aktiviert, werden die Firmenrechnungsinformationsfelder auf der Checkout-Seite angezeigt. Es ist erforderlich, die Firmenrechnungsinformationsfelder auszufüllen.',
            'default_tax_rate' => 'Standard-Steuersatz',
            'default_tax_rate_description' => 'Wichtig: wird angewendet, wenn keine Steuer im Produkt ausgewählt ist.',
            'select_tax' => '-- Auswählen --',
            'display_product_price_including_taxes' => 'Steuer zu angezeigten Preisen hinzufügen',
            'display_product_price_including_taxes_helper' => 'Fügt automatisch Steuer zu den im Shop angezeigten Produktpreisen hinzu. Z.B. wird ein 100 $-Produkt mit 10 % Steuer als 110 $ angezeigt. Nicht erforderlich, wenn „Preis enthält Steuer" bereits bei einzelnen Produkten aktiviert ist.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Kunden',
        'description' => 'Registrierung, E-Mail-Verifizierung, Login-Optionen, Kontolöschung und Profilfelder',
        'customer_setting' => 'Kundeneinstellungen',
        'customer_setting_description' => 'Kundeneinstellungen konfigurieren',
        'form' => [
            'enable_customer_registration' => 'Kundenregistrierung aktivieren',
            'enable_customer_registration_helper' => 'Wenn deaktiviert, können sich Kunden nicht für neue Konten registrieren. Bestehende Kunden können sich weiterhin anmelden.',
            'verify_customer_email' => 'Kunden-E-Mail verifizieren',
            'verify_customer_email_helper' => 'Wenn aktiviert, wird ein Verifizierungslink an die Kunden-E-Mail gesendet. Kunden müssen auf diesen Link klicken, um ihre E-Mail zu verifizieren, bevor sie sich anmelden können. E-Mail-Konfiguration in Admin -> Einstellungen -> E-Mail erforderlich.',
            'verification_expire_minutes' => 'Ablaufzeit des Verifizierungslinks',
            'verification_expire_minutes_helper' => 'Die Zeit in Minuten, in der der E-Mail-Verifizierungslink gültig ist. Standard sind 60 Minuten (1 Stunde). Maximum sind 10080 Minuten (7 Tage).',
            'login_using_phone' => 'Mit Telefonnummer statt E-Mail anmelden',
            'login_option' => 'Anmeldeoption',
            'login_with_email' => 'Mit E-Mail anmelden',
            'login_with_phone' => 'Mit Telefon anmelden',
            'login_with_email_or_phone' => 'Mit E-Mail oder Telefon anmelden',
            'enabled_customer_account_deletion' => 'Kundenkontolöschung aktivieren',
            'enabled_customer_account_deletion_helper' => 'Wenn aktiviert, können Kunden ihr Konto im Kunden-Dashboard → Kontoeinstellungen löschen.',
            'enabled_customer_dob_field' => 'Kunden-Geburtsdatum-Feld aktivieren',
            'enabled_customer_dob_field_helper' => 'Wenn aktiviert, können Kunden ihr Geburtsdatum im Kunden-Dashboard → Kontoeinstellungen eingeben.',
            'enabled_phone_field_in_registration_form' => 'Telefonfeld im Registrierungsformular aktivieren',
            'enabled_phone_field_in_registration_form_helper' => 'Wenn aktiviert, wird das Telefonfeld zum Registrierungsformular hinzugefügt.',
            'make_customer_phone_number_required' => 'Kunden-Telefonnummer erforderlich machen',
            'make_customer_phone_number_required_helper' => 'Wenn aktiviert, müssen Kunden ihre Telefonnummer bei der Registrierung eingeben. Für Kunden, die sich mit Telefonnummer anmelden, ist es immer erforderlich.',
            'default_avatar' => 'Standard-Avatar',
            'default_avatar_helper' => 'Standard-Avatar für Kunden, wenn sie keinen Avatar haben. Wenn Sie kein Bild auswählen, wird es mit Ihrem Logo oder dem ersten Buchstaben des Kundennamens generiert.',
            'keep_email_field_in_registration_form' => 'E-Mail-Feld im Registrierungsformular beibehalten',
            'keep_email_field_in_registration_form_helper' => 'Wenn deaktiviert, wird das E-Mail-Feld im Registrierungsformular ausgeblendet, wenn die Anmeldeoption "Mit Telefon anmelden" ist.',
        ],
    ],
    'shipping' => [
        'name' => 'Versand',
        'description' => 'Versandregeln, Gratisversand-Verhalten und Anzeigereihenfolge der Versandoptionen',
        'shipping_rule' => 'Versandregeln',
        'shipping_rule_description' => 'Regeln zur Berechnung von Versandkosten konfigurieren',
        'shipping_setting' => 'Versandeinstellungen',
        'shipping_setting_description' => 'Versandeinstellungen konfigurieren',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Andere Versandoptionen ausblenden, wenn kostenloser Versand in der Liste ist',
            'disable_shipping_options' => 'Versandoptionen deaktivieren',
            'disable_shipping_options_helper' => 'Versandoptionen werden auf der Checkout-Seite entfernt, Kunde kann keine Versandoptionen auswählen.',
            'sort_shipping_options_direction' => 'Versandoptionen-Sortierrichtung',
            'sort_shipping_options_direction_helper' => 'Versandoptionen nach Preis von niedrig zu hoch oder hoch zu niedrig sortieren.',
            'price_lower_to_higher' => 'Preis niedrig zu hoch',
            'price_higher_to_lower' => 'Preis hoch zu niedrig',
        ],
    ],
    'webhook' => [
        'name' => 'Webhooks',
        'description' => 'Bestellereignisse an externe Dienste per HTTP senden',
        'webhook_setting' => 'Bestellereignis-Webhooks',
        'webhook_setting_description' => 'URLs konfigurieren um Benachrichtigungen zu erhalten wenn Bestellungen aufgegeben, aktualisiert oder versendet werden',
        'form' => [
            'order_placed_webhook_url' => 'Bestellung aufgegeben Webhook-URL (Methode: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Um Benachrichtigungen zu erhalten, wenn eine Bestellung aufgegeben wird, können Sie eine externe Webhook-URL einrichten. Wenn Sie eine externe Webhook-URL haben, können Sie diese URL eingeben oder einfach leer lassen.',
            'order_updated_webhook_url' => 'Bestellung aktualisiert Webhook-URL (Methode: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Um Benachrichtigungen zu erhalten, wenn eine Bestellung aktualisiert wird, können Sie eine externe Webhook-URL einrichten. Dies umfasst Statusänderungen, Adressaktualisierungen und andere Bestelländerungen.',
            'shipping_status_updated_webhook_url' => 'Versandstatus aktualisiert Webhook-URL (Methode: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Um Benachrichtigungen zu erhalten, wenn sich der Versandstatus ändert (z.B. versendet, zugestellt, storniert), können Sie eine externe Webhook-URL einrichten.',
            'order_completed_webhook_url' => 'Bestellung abgeschlossen Webhook-URL (Methode: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Um Benachrichtigungen zu erhalten, wenn eine Bestellung abgeschlossen ist, können Sie eine externe Webhook-URL einrichten.',
            'order_cancelled_webhook_url' => 'Bestellung storniert Webhook-URL (Methode: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Um Benachrichtigungen zu erhalten, wenn eine Bestellung storniert wird, können Sie eine externe Webhook-URL einrichten.',
            'payment_status_updated_webhook_url' => 'Zahlungsstatus aktualisiert Webhook-URL (Methode: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Um Benachrichtigungen zu erhalten, wenn sich der Zahlungsstatus ändert (z.B. bezahlt, fehlgeschlagen, erstattet), können Sie eine externe Webhook-URL einrichten.',
            'abandoned_cart_webhook_url' => 'Verlassener Warenkorb Webhook-URL (Methode: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Um Benachrichtigungen zu erhalten, wenn Warenkörbe verlassen werden und Nachfassen mit Kunden, können Sie eine externe Webhook-URL einrichten. Benachrichtigungen werden nach einer konfigurierbaren Zeitspanne gesendet.',
        ],
        'test_button' => 'Webhook testen',
        'test_success' => 'Webhook-Test erfolgreich! Der Endpunkt hat korrekt geantwortet.',
        'test_failed' => 'Webhook-Test fehlgeschlagen. Der Endpunkt hat nicht wie erwartet geantwortet.',
        'test_error' => 'Webhook-Test-Fehler: :error',
        'please_enter_url' => 'Bitte geben Sie zuerst eine Webhook-URL ein',
        'testing' => 'Teste...',
        'test_failed_title' => 'Test fehlgeschlagen!',
        'test_success_title' => 'Test erfolgreich!',
        'status_code' => 'Statuscode',
        'error_occurred' => 'Beim Testen des Webhooks ist ein Fehler aufgetreten',
    ],
    'store_locator' => [
        'name' => 'Shop-Standorte',
        'description' => 'Die Listen Ihrer Ketten anzeigen und aktualisieren',
        'store_locator_description' => 'Alle Listen Ihrer Ketten, Hauptgeschäfte, Filialen usw. Die Standorte können verwendet werden, um Verkäufe zu verfolgen und uns bei der Konfiguration von Steuersätzen zu helfen, die beim Verkauf von Produkten zu erheben sind.',
        'form' => [
            'change_primary_store' => 'Standard-Shop-Standort ändern',
            'add_location' => 'Standort hinzufügen',
            'edit_location' => 'Standort bearbeiten',
            'delete_location' => 'Standort löschen',
            'delete_location_confirmation' => 'Sind Sie sicher, dass Sie diesen Standort löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
            'change_primary_location' => 'Hauptstandort ändern',
            'save_location' => 'Standort speichern',
            'add_new' => 'Neu hinzufügen',
        ],
        'info' => [
            'title' => 'Wie Shop-Standorte funktionieren',
            'primary_store' => 'Die Adresse des Hauptgeschäfts erscheint auf Rechnungen und wird als Standardrücksendeadresse für Versandetiketten verwendet.',
            'shipping_location' => 'Geschäfte, die als "Versandstandort" markiert sind, können als Ursprungslager beim Erstellen von Sendungen ausgewählt werden.',
            'shipment_selection' => 'Bei der Bearbeitung von Bestellungen können Sie auswählen, von welchem Lager aus versendet werden soll, basierend auf Bestand und Kundenstandort.',
        ],
    ],
    'tracking' => [
        'name' => 'Tracking',
        'description' => 'Facebook Pixel, Google Tag Manager Events und Google Ads Conversion-Tracking',
        'manage_tracking' => 'Tracking verwalten',
        'manage_tracking_description' => 'Tracking verwalten: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Facebook Pixel (Meta Pixel) aktivieren',
            'facebook_pixel_helper' => 'Gehen Sie zu https://developers.facebook.com/docs/meta-pixel, um Facebook Pixel zu erstellen. Stellen Sie sicher, dass Ihr Pixel aktiv und richtig konfiguriert ist.',
            'facebook_pixel_id' => 'Facebook Pixel ID',
            'facebook_pixel_id_placeholder' => 'Beispiel: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Facebook Pixel Debug-Modus aktivieren',
            'facebook_pixel_debug_mode_helper' => 'Debug-Modus aktivieren, um Facebook Pixel-Ereignisse in der Browser-Konsole zu protokollieren und Tracking-Probleme zu beheben',
            'enable_google_tag_manager_tracking_events' => 'Google Tag Manager Tracking-Ereignisse aktivieren',
            'google_tag_manager_tracking_info' => 'Wenn aktiviert, werden E-Commerce-Ereignisse über Google Tag Manager verfolgt. Stellen Sie sicher, dass Sie Google Tag Manager oben konfiguriert haben.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel ID muss 15-16 Ziffern haben (z.B. 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Marktplatz',
        'description' => 'Multi-Vendor-Einstellungen, Provisionen, Verkäuferregistrierung und Auszahlungskonfiguration',
    ],
    'standard_and_format' => [
        'name' => 'Standard & Format',
        'panel_description' => 'Bestellcode-Format, Gewichtseinheiten (kg/lb) und Maßeinheiten (cm/Zoll)',
        'description' => 'Standards und Formate werden verwendet, um Dinge wie Produktpreise, Versandgewichte und Bestellzeiten zu berechnen.',
        'form' => [
            'change_order_format' => 'Bestellcode-Format bearbeiten (optional)',
            'change_order_format_description' => 'Der Standard-Bestellcode beginnt bei: Nummer. Sie können den Start- oder Endstring ändern, um den gewünschten Bestellcode zu erstellen, zum Beispiel "DH-: Nummer" oder ": Nummer-A"',
            'start_with' => 'Beginnen mit',
            'end_with' => 'Enden mit',
            'order_will_be_shown' => 'Ihr Bestellcode wird angezeigt',
            'weight_unit' => 'Gewichtseinheit',
            'height_unit' => 'Längen-/Höheneinheit',
            'weight_unit_gram' => 'Gramm (g)',
            'weight_unit_kilogram' => 'Kilogramm (kg)',
            'weight_unit_lb' => 'Pfund (lb)',
            'weight_unit_oz' => 'Unze (oz)',
            'height_unit_cm' => 'Zentimeter (cm)',
            'height_unit_m' => 'Meter (m)',
            'height_unit_inch' => 'Zoll',
        ],
    ],
    'sale_popup' => [
        'name' => 'Sale Popup',
        'description' => 'Ihre Sale Popup-Einstellungen einfach anpassen',
    ],
    'flash_sale' => [
        'name' => 'Flash Sale',
        'description' => 'Flash Sale-Einstellungen konfigurieren, um zeitlich begrenzte Aktionsrabatte anzubieten',
        'enable' => 'Flash Sale-Funktionalität aktivieren',
        'enable_helper' => 'Wenn aktiviert, können Sie Flash Sales mit besonderen reduzierten Preisen für einen begrenzten Zeitraum erstellen und verwalten.',
        'show_sale_count_left' => 'Lagerbestandsverfolger anzeigen',
        'show_sale_count_left_description' => 'Einen Fortschrittsbalken mit "X verkauft von Y" anzeigen, um Dringlichkeit zu schaffen und schnelle Käufe während Flash Sales zu fördern.',
    ],
    'payment_method_cod_minimum_amount' => 'Mindestbestellwert - :currency (Optional)',
    'payment_method_cod_minimum_amount_helper' => 'Legen Sie den Mindestbestellbetrag fest, um die Zahlungsmethode COD zu verwenden. Lassen Sie es bei 0 oder leer, wenn Sie kein Minimum festlegen möchten.',
    'payment_method_cod_maximum_amount' => 'Maximaler Bestellbetrag - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Legen Sie den maximalen Bestellbetrag für die Zahlungsmethode COD fest. Lassen Sie es bei 0 oder leer, wenn Sie kein Maximum festlegen möchten.',
    'payment_method_minimum_amount' => 'Mindestbestellwert - :currency (Optional)',
    'payment_method_minimum_amount_helper' => 'Legen Sie den Mindestbestellbetrag fest, um diese Zahlungsmethode zu verwenden. Lassen Sie es bei 0 oder leer, wenn Sie kein Minimum festlegen möchten.',
    'payment_method_maximum_amount' => 'Maximaler Bestellbetrag - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Legen Sie den maximalen Bestellbetrag für diese Zahlungsmethode fest. Lassen Sie es bei 0 oder leer, wenn Sie kein Maximum festlegen möchten.',
    'payment_method_maximum_amount_error' => 'Der maximale Bestellbetrag für die Zahlungsmethode :payment_method beträgt :amount. Sie müssen :more entfernen, um zu bestellen!',
    'display_bank_info_at_the_checkout_success_page' => 'Bankdaten auf der Checkout-Erfolgsseite anzeigen?',
    'display_bank_info_at_the_checkout_success_page_helper' => 'Wenn aktiviert, sehen Kunden Ihre Bankverbindung auf der Bestellbestätigungsseite nach der Bestellung. Dies hilft ihnen zu wissen, wohin sie die Zahlung überweisen sollen.',
    'invoice_templates' => 'Rechnungsvorlagen',

    'abandoned_cart' => [
        'name' => 'Verlassene Warenkörbe',
        'description' => 'Verlorene Verkäufe durch automatische Erinnerungen an Kunden zurückgewinnen, die Artikel im Warenkorb gelassen haben',
        'panel_description' => 'Automatische Erinnerungen für Kunden einrichten, die ihren Warenkorb verlassen',
        'how_it_works' => [
            'title' => 'So funktioniert es',
            'step1_title' => 'Kunde fügt Artikel hinzu',
            'step1_description' => 'Der Kunde fügt Produkte in den Warenkorb und gibt seine E-Mail-Adresse an.',
            'step2_title' => 'Warenkorb wird verlassen',
            'step2_description' => 'Wenn innerhalb der festgelegten Zeit kein Kauf erfolgt, wird der Warenkorb als verlassen markiert.',
            'step3_title' => 'Erinnerungs-E-Mail gesendet',
            'step3_description' => 'Automatische E-Mail-Erinnerungen werden gesendet, um den Kunden zum Kaufabschluss zu ermutigen.',
            'step4_title' => 'Verkauf zurückgewonnen',
            'step4_description' => 'Der Kunde kehrt zurück, schließt die Bestellung ab und der Warenkorb wird als wiederhergestellt markiert.',
        ],
        'form' => [
            'enable' => 'Verfolgung verlassener Warenkörbe aktivieren',
            'enable_helper' => 'Bei Aktivierung verfolgt das System verlassene Warenkörbe und ermöglicht das Senden von Wiederherstellungs-E-Mails.',
            'timing_section' => 'Zeiteinstellungen',
            'email_section' => 'E-Mail-Erinnerungseinstellungen',
            'cleanup_section' => 'Datenbereinigung',
            'time_threshold' => 'Zeitschwelle (Stunden)',
            'time_threshold_helper' => 'Ein Warenkorb gilt nach dieser Anzahl von Stunden Inaktivität als verlassen. Empfohlen: 1-24 Stunden.',
            'send_email' => 'Wiederherstellungs-E-Mails senden',
            'send_email_helper' => 'Automatisch Wiederherstellungs-E-Mails an Kunden mit verlassenen Warenkörben senden.',
            'max_reminders' => 'Anzahl der Erinnerungs-E-Mails',
            'max_reminders_helper' => 'Wie viele Erinnerungs-E-Mails pro verlassenem Warenkorb gesendet werden. Jede E-Mail kann in den E-Mail-Vorlagen angepasst werden.',
            'email_delay' => 'Senden nach (Stunden)',
            'email_discount' => 'Rabatt (%)',
            'email_1_title' => 'E-Mail #1 - Freundliche Erinnerung',
            'email_1_description' => 'Erste sanfte Erinnerung, um den Kunden zur Rückkehr zu ermutigen.',
            'email_1_delay_helper' => 'Stunden nach Warenkorbabbruch für die erste E-Mail. Empfohlen: 1-2 Stunden.',
            'email_2_title' => 'E-Mail #2 - Mit Anreiz',
            'email_2_description' => 'Zweite Erinnerung mit Rabattangebot zur Kaufmotivation.',
            'email_2_delay_helper' => 'Stunden nach Warenkorbabbruch für die zweite E-Mail. Empfohlen: 24 Stunden.',
            'email_2_discount_helper' => 'Rabattprozentsatz für diese E-Mail. Auf 0 setzen für keinen Rabatt.',
            'email_3_title' => 'E-Mail #3 - Letzte Chance',
            'email_3_description' => 'Letzte Erinnerung mit Dringlichkeit und bestem Angebot zum Verkaufsabschluss.',
            'email_3_delay_helper' => 'Stunden nach Warenkorbabbruch für die letzte E-Mail. Empfohlen: 72 Stunden.',
            'email_3_discount_helper' => 'Finales Rabattangebot. Normalerweise höher als E-Mail #2.',
            'cleanup_days' => 'Bereinigung nach (Tagen)',
            'cleanup_days_helper' => 'Automatisch Datensätze verlassener Warenkörbe löschen, die älter als diese Anzahl von Tagen sind.',
            'cronjob_not_setup' => '<strong>Cronjob nicht konfiguriert!</strong> Erinnerungen für verlassene Warenkörbe erfordern einen richtig konfigurierten Cronjob. <a href=":url">Cronjob jetzt einrichten</a>.',
            'cronjob_not_running' => '<strong>Cronjob läuft nicht!</strong> Der Cronjob scheint gestoppt zu sein. Bitte überprüfen Sie Ihre Server-Konfiguration. <a href=":url">Cronjob-Status anzeigen</a>.',
            'cronjob_working' => '<strong>Cronjob läuft ordnungsgemäß!</strong> Letzte Aktivität: :time. Ihre Erinnerungen für verlassene Warenkörbe werden automatisch verarbeitet.',
            'email_setup_warning' => '<strong>Wichtig:</strong> Stellen Sie sicher, dass Ihre E-Mail-Einstellungen in <a href=":url">Einstellungen → E-Mail</a> richtig konfiguriert sind. Senden Sie eine Test-E-Mail, um alles zu überprüfen, bevor Sie diese Funktion aktivieren.',
        ],
    ],
];
