<?php

return [
    'name' => 'Produkte',
    'description' => 'Verwalten Sie physische und digitale Produkte mit Lagerbestand, Preisen und Varianten',
    'create' => 'Neues Produkt',
    'create_product_type' => [
        'physical' => 'Neues physisches Produkt',
        'digital' => 'Neues digitales Produkt',
    ],
    'edit' => 'Produkt bearbeiten - :name',
    'form' => [
        'name' => 'Name',
        'name_placeholder' => 'Produktname (Maximal 120 Zeichen)',
        'description' => 'Beschreibung',
        'description_placeholder' => 'Kurze Beschreibung für das Produkt (Maximal 400 Zeichen)',
        'categories' => 'Kategorien',
        'content' => 'Inhalt',
        'price' => 'Preis',
        'currency' => 'Währung',
        'currency_for_variations_hint' => 'Diese Währung wird auf alle Varianten dieses Produkts angewendet.',
        'quantity' => 'Menge',
        'brand' => 'Marke',
        'width' => 'Breite',
        'height' => 'Höhe',
        'weight' => 'Gewicht',
        'date' => [
            'start' => 'Von Datum',
            'end' => 'Bis Datum',
        ],
        'image' => 'Bilder',
        'collections' => 'Produktsammlungen',
        'labels' => 'Labels',
        'price_sale' => 'Verkaufspreis',
        'product_type' => [
            'title' => 'Produkttyp',
        ],
        'product' => 'Produkt',
        'total' => 'Gesamt',
        'sub_total' => 'Zwischensumme',
        'shipping_fee' => 'Versandkosten',
        'discount' => 'Rabatt',
        'options' => 'Optionen',
        'shipping' => [
            'height' => 'Höhe',
            'length' => 'Länge',
            'title' => 'Versand',
            'weight' => 'Gewicht',
            'wide' => 'Breite',
        ],
        'barcode' => 'Barcode (ISBN, UPC, GTIN, usw.) ',
        'barcode_placeholder' => 'Barcode eingeben',
        'cost_per_item' => 'Kosten pro Artikel',
        'cost_per_item_placeholder' => 'Kosten pro Artikel eingeben',
        'cost_per_item_helper' => 'Kunden sehen diesen Preis nicht.',
        'price_includes_tax' => 'Preis inkl. Steuer',
        'price_includes_tax_helper' => 'Aktivieren Sie diese Option, wenn der eingegebene Preis bereits Steuern enthält. Das System berechnet den Basispreis, indem es den Steuerbetrag abzieht.',
        'stock' => [
            'allow_order_when_out' => 'Kunden können bestellen, wenn dieses Produkt nicht vorrätig ist',
            'in_stock' => 'Auf Lager',
            'out_stock' => 'Nicht auf Lager',
            'title' => 'Lagerstatus',
        ],
        'storehouse' => [
            'no_storehouse' => 'Keine Lagerverwaltung',
            'storehouse' => 'Mit Lagerverwaltung',
            'title' => 'Lagerhaus',
            'quantity' => 'Menge',
        ],
        'tax' => 'Steuer',
        'taxes' => 'Steuern',
        'taxes_helper' => 'Der Standardsteuersatz ist in <a href=":url">Einstellungen -> Steuer</a> konfiguriert. Wenn für dieses Produkt keine spezifische Steuer ausgewählt ist, wird der Standardsatz angewendet. Um die Steuer für dieses Produkt zu deaktivieren, entfernen Sie den Standardsteuersatz aus den Steuereinstellungen.',
        'is_default' => 'Ist Standard',
        'action' => 'Aktion',
        'restock_quantity' => 'Nachschubmenge',
        'remain' => 'Verbleibend',
        'choose_discount_period' => 'Rabattzeitraum wählen',
        'cancel' => 'Abbrechen',
        'no_results' => 'Keine Ergebnisse!',
        'value' => 'Wert',
        'attribute_name' => 'Attributname',
        'add_more_attribute' => 'Weiteres Attribut hinzufügen',
        'continue' => 'Fortfahren',
        'add_new_attributes' => 'Neue Attribute hinzufügen',
        'add_new_attributes_description' => 'Neue Attribute hinzufügen, damit das Produkt viele Optionen wie Größe oder Farbe hat.',
        'create_product_variations' => ':link um Produktvarianten zu erstellen!',
        'tags' => 'Tags',
        'write_some_tags' => 'Einige Tags schreiben',
        'variation_existed' => 'Diese Variante existiert bereits.',
        'no_attributes_selected' => 'Keine Attribute ausgewählt!',
        'added_variation_success' => 'Variante erfolgreich hinzugefügt!',
        'updated_variation_success' => 'Variante erfolgreich aktualisiert!',
        'created_all_variation_success' => 'Alle Varianten erfolgreich erstellt!',
        'updated_product_attributes_success' => 'Produktattribute erfolgreich aktualisiert!',
        'stock_status' => 'Lagerstatus',
        'auto_generate_sku' => 'SKU automatisch generieren?',
        'featured_image' => 'Hauptbild (optional)',
        'product_id' => 'Produkt-ID',
        'price_sale_percent_helper' => 'Rabatt :percent vom Originalpreis.',
        'minimum_order_quantity' => 'Mindestbestellmenge',
        'minimum_order_quantity_helper' => 'Mindestmenge für eine Bestellung, wenn der Wert 0 ist, gibt es keine Begrenzung.',
        'maximum_order_quantity' => 'Höchstbestellmenge',
        'maximum_order_quantity_helper' => 'Höchstmenge für eine Bestellung, wenn der Wert 0 ist, gibt es keine Begrenzung.',
        'video' => 'Video',
        'video_file' => 'Datei',
        'video_url' => 'Oder externe Video-URL',
        'video_url_help' => 'YouTube- oder Vimeo-Video-URL eingeben',
        'enter_video_url' => 'Video-URL eingeben',
        'video_thumbnail' => 'Video-Vorschaubild',
        'video_thumbnail_help' => 'Wählen Sie ein Vorschaubild für das Video. Wenn nicht ausgewählt, wird es automatisch von der Video-URL abgerufen, falls verfügbar.',
        'barcode_existed' => 'Dieser Barcode wird von einem anderen Produkt verwendet. Bitte geben Sie einen anderen Barcode ein.',
        'barcode_helper' => 'Muss für jedes Produkt eindeutig sein.',
        'is_new_until' => 'Neu bis',
        'is_new_until_helper' => 'Legen Sie ein Datum fest, bis zu dem dieses Produkt als "Neu" markiert wird. Leer lassen, um nicht als neu basierend auf dem Datum zu markieren.',
    ],
    'price' => 'Preis',
    'quantity' => 'Menge',
    'type' => 'Typ',
    'image' => 'Vorschaubild',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'Varianten-SKU',
    'brand' => 'Marke',
    'cannot_delete' => 'Produkt konnte nicht gelöscht werden',
    'product_deleted' => 'Produkt gelöscht',
    'product' => 'Produkt',
    'product_collections' => 'Produktsammlungen',
    'products' => 'Produkte',
    'total_products_found' => ':total Produkte gefunden',
    'total_product_found' => ':total Produkt gefunden',
    'menu' => 'Produkte',
    'control' => [
        'button_add_image' => 'Bild hinzufügen',
    ],
    'price_sale' => 'Verkaufspreis',
    'price_group_title' => 'Produktpreis verwalten',
    'store_house_group_title' => 'Lagerhaus verwalten',
    'shipping_group_title' => 'Versand verwalten',
    'overview' => 'Übersicht',
    'attributes' => 'Attribute',
    'product_has_variations' => 'Produkt hat Varianten',
    'manage_products' => 'Produkte verwalten',
    'add_new_product' => 'Neues Produkt hinzufügen',
    'start_by_adding_new_product' => 'Beginnen Sie mit dem Hinzufügen neuer Produkte.',
    'edit_this_product' => 'Dieses Produkt bearbeiten',
    'delete' => 'Löschen',
    'related_products' => 'Verwandte Produkte',
    'cross_selling_products' => 'Cross-Selling-Produkte',
    'up_selling_products' => 'Up-Selling-Produkte',
    'grouped_products' => 'Gruppierte Produkte',
    'search_products' => 'Produkte suchen',
    'selected_products' => 'Ausgewählte Produkte',
    'edit_variation_item' => 'Bearbeiten',
    'variations_box_description' => 'Klicken Sie auf "Attribut bearbeiten", um Attribute der Variante hinzuzufügen/zu entfernen, oder klicken Sie auf "Neue Variante hinzufügen", um eine Variante hinzuzufügen.',
    'save_changes' => 'Änderungen speichern',
    'continue' => 'Fortfahren',
    'edit_attribute' => 'Attribut bearbeiten',
    'select_attribute' => 'Attribut auswählen',
    'add_new_variation' => 'Neue Variante hinzufügen',
    'edit_variation' => 'Variante bearbeiten',
    'generate_variations' => 'Varianten generieren',
    'generate_variations_confirmation' => 'Sind Sie sicher, dass Sie Varianten für dieses Produkt generieren möchten?',
    'delete_variation' => 'Variante löschen?',
    'delete_variation_confirmation' => 'Sind Sie sicher, dass Sie diese Variante löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
    'delete_variations_confirmation' => 'Sind Sie sicher, dass Sie diese Varianten löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
    'product_create_validate_name_required' => 'Bitte geben Sie den Produktnamen ein',
    'product_create_validate_sale_price_max' => 'Der Rabatt muss niedriger sein als der Originalpreis',
    'product_create_validate_cost_per_item_max' => 'Die Kosten pro Artikel müssen niedriger sein als der Originalpreis',
    'product_create_validate_sale_price_required_if' => 'Ein Rabatt muss eingegeben werden, wenn Sie eine Aktion planen möchten',
    'product_create_validate_end_date_after' => 'Das Enddatum muss nach dem Startdatum liegen',
    'product_create_validate_start_date_required_if' => 'Das Startdatum für den Rabatt darf nicht leer sein, wenn eine Planung ausgewählt ist',
    'product_create_validate_sale_price' => 'Rabatte dürfen nicht leer sein, wenn eine Planung ausgewählt ist',
    'stock_statuses' => [
        'in_stock' => 'Auf Lager',
        'out_of_stock' => 'Nicht auf Lager',
        'on_backorder' => 'Auf Nachbestellung',
    ],
    'stock_status' => 'Lagerstatus',
    'processing' => 'Wird verarbeitet...',
    'delete_selected_variations' => 'Ausgewählte Varianten löschen',
    'delete_variations' => 'Varianten löschen',
    'category' => 'Kategorie',
    'categories' => 'Kategorien',
    'tags' => 'Tags',
    'product_price_flash_sale_warning' => 'Dieses Produkt ist im Flash-Sale <strong>:name</strong>, daher beträgt der Preis <strong>:price</strong>.',
    'product_price_discount_warning' => 'Dieses Produkt ist im Rabatt <strong>:name</strong>, daher beträgt der Preis <strong>:price</strong>.',
    'product_image' => 'Produktbild',
    'product_name' => 'Produktname',
    'product_link' => 'Produktlink',
    'types' => [
        'physical' => 'Physisch',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Digitale Anhänge',
        'add' => 'Anhang hinzufügen',
        'file_name' => 'Dateiname',
        'file_size' => 'Dateigröße',
        'unsaved' => 'Nicht gespeichert',
        'add_external_link' => 'Externen Link hinzufügen',
        'enter_file_name' => 'Dateiname eingeben',
        'enter_external_link_download' => 'Externen Download-Link eingeben',
        'enter_file_size' => 'Dateigröße eingeben',
        'external_link_download' => 'Externer Download-Link',
        'generate_license_code_after_purchasing_product' => 'Lizenzcodezuweisung für dieses Produkt aktivieren',
        'notify_attachment_updated' => 'E-Mail an Kunden senden, wenn Anhang aktualisiert wird',
        'no_attachments' => 'Noch keine Anhänge. Klicken Sie auf die Schaltflächen oben, um Dateien hinzuzufügen.',
    ],
    'license_codes' => [
        'title' => 'Lizenzcodes',
        'add' => 'Lizenzcode hinzufügen',
        'back' => 'Zurück zum Produkt',
        'edit' => 'Lizenzcode bearbeiten',
        'generate' => 'Codes generieren',
        'manage_codes' => 'Lizenzcodes verwalten',
        'management' => 'Lizenzcodeverwaltung',
        'variation_breadcrumb' => 'Variante: :name',
        'variation_label' => 'Produktvariante',
        'variation_specific_note' => 'Diese Lizenzcodes sind spezifisch für diese Produktvariante. Kunden, die diese Variante kaufen, erhalten Codes aus diesem Pool.',
        'main_product_note' => 'Dieses Produkt hat Varianten. Jede Variante kann ihre eigenen Lizenzcodes haben, oder Kunden können Codes aus diesem Hauptproduktpool erhalten, wenn die Variante keine Codes hat.',
        'code' => 'Lizenzcode',
        'codes' => 'Lizenzcodes',
        'status' => 'Status',
        'assigned_at' => 'Zugewiesen am',
        'status_available' => 'Verfügbar',
        'status_used' => 'Verwendet',
        'statuses' => [
            'available' => 'Verfügbar',
            'used' => 'Verwendet',
        ],
        'no_codes' => 'Keine Lizenzcodes gefunden. Fügen Sie einige Codes hinzu oder generieren Sie sie automatisch.',
        'no_codes_warning_title' => 'Keine Lizenzcodes verfügbar!',
        'no_codes_warning_message' => 'Dieses Produkt ist auf "Aus Liste auswählen" eingestellt, hat aber keine verfügbaren Lizenzcodes. Kunden, die dieses Produkt kaufen, erhalten automatisch generierte Codes. Bitte fügen Sie Lizenzcodes hinzu, um die ordnungsgemäße Funktionalität sicherzustellen.',
        'no_codes_auto_generate' => 'Dieses Produkt ist so eingestellt, dass Lizenzcodes automatisch generiert werden. Keine manuellen Codes erforderlich.',
        'used_code_no_actions' => 'Verwendeter Code - keine Aktionen verfügbar',
        'created_successfully' => 'Lizenzcode erfolgreich erstellt!',
        'updated_successfully' => 'Lizenzcode erfolgreich aktualisiert!',
        'deleted_successfully' => 'Lizenzcode erfolgreich gelöscht!',
        'generated_successfully' => ':count Lizenzcodes erfolgreich generiert!',
        'duplicates_skipped' => ':count doppelte Codes wurden übersprungen.',
        'generation_incomplete' => 'Warnung: Es konnten nur :generated von :requested angeforderten Codes aufgrund von Duplikatkonflikten generiert werden.',
        'cannot_edit_used_code' => 'Ein verwendeter Lizenzcode kann nicht bearbeitet werden.',
        'cannot_delete_used_code' => 'Ein verwendeter Lizenzcode kann nicht gelöscht werden.',
        'show_all' => 'Alle anzeigen',
        'show_less' => 'Weniger anzeigen',
        'more' => 'mehr',
        'used_codes_hidden' => ':count verwendete Lizenzcodes sind ausgeblendet. Sie können alle Codes auf der Lizenzcodeverwaltungsseite anzeigen.',
        'low_stock_title' => 'Niedriger Lizenzcodebestand',
        'low_stock_message' => 'Nur noch :count Lizenzcodes verbleibend. Erwägen Sie, weitere Codes hinzuzufügen, um zu vermeiden, dass sie ausgehen.',
        'out_of_stock_title' => 'Keine Lizenzcodes vorhanden!',
        'out_of_stock_message' => 'Keine Lizenzcodes verfügbar. Kunden erhalten automatisch generierte Codes, bis Sie weitere hinzufügen.',
        'type' => [
            'title' => 'Lizenzcodezuweisungsmethode',
            'auto_generate' => 'Automatisch generieren (System generiert Codes automatisch)',
            'pick_from_list' => 'Aus Liste auswählen (Voreingegebene Codes verwenden)',
            'description' => 'Wählen Sie, wie Lizenzcodes Kunden zugewiesen werden sollen, wenn sie dieses Produkt kaufen.',
        ],
        'add_modal' => [
            'placeholder' => 'z.B. XXXX-XXXX-XXXX-XXXX',
            'help' => 'Geben Sie einen eindeutigen Lizenzcode ein, der einem Kunden beim Kauf zugewiesen wird.',
        ],
        'generate_modal' => [
            'title' => 'Lizenzcodes generieren',
            'quantity' => 'Menge',
            'format' => 'Format',
            'custom_pattern' => 'Benutzerdefiniertes Muster',
            'pattern_help' => 'Verwenden Sie # für Zahlen, A für Großbuchstaben, a für Kleinbuchstaben',
            'generate' => 'Generieren',
        ],
        'errors' => [
            'feature_not_enabled' => 'Die Lizenzcodefunktion ist nicht aktiviert. Bitte aktivieren Sie sie in Ecommerce-Einstellungen -> Digitale Produkte.',
            'digital_products_not_enabled' => 'Digitale Produkte sind nicht aktiviert. Bitte aktivieren Sie zuerst die Unterstützung für digitale Produkte.',
            'product_not_found' => 'Produkt nicht gefunden.',
            'not_digital_product' => 'Lizenzcodes sind nur für digitale Produkte verfügbar. Dieses Produkt ist als physisches Produkt eingestellt.',
            'license_codes_not_enabled_for_product' => 'Die Lizenzcodeverwaltung ist für dieses Produkt nicht aktiviert. Bitte aktivieren Sie "Lizenzcode nach dem Kauf des Produkts generieren" in den Produkteinstellungen.',
            'cannot_add_codes_auto_generate' => 'Lizenzcodes können nicht manuell zu Produkten hinzugefügt werden, die auf automatische Generierung eingestellt sind. Ändern Sie zuerst den Lizenzcodetyp auf "Aus Liste auswählen".',
            'cannot_generate_codes_auto_generate' => 'Lizenzcodes können nicht manuell für Produkte generiert werden, die auf automatische Generierung eingestellt sind. Ändern Sie zuerst den Lizenzcodetyp auf "Aus Liste auswählen".',
        ],
        'bulk_delete' => [
            'button' => 'Ausgewählte löschen',
            'selected' => 'ausgewählt',
            'confirm' => 'Sind Sie sicher, dass Sie die ausgewählten Lizenzcodes löschen möchten?',
            'deleted_successfully' => ':count Lizenzcode(s) erfolgreich gelöscht.',
            'skipped_used_codes' => ':count verwendete Code(s) wurden übersprungen.',
            'no_deletable_codes' => 'Keine verfügbaren Lizenzcodes zum Löschen gefunden. Verwendete Codes können nicht gelöscht werden.',
        ],
        'import' => [
            'name' => 'Produktlizenzcodes importieren',
            'description' => 'Importieren Sie Lizenzcodes für digitale Produkte aus CSV/Excel-Datei.',
            'button' => 'Importieren',
            'columns' => [
                'product_id' => 'Produkt-ID oder SKU',
                'license_code' => 'Lizenzcode',
            ],
        ],
        'copied' => 'Lizenzcode in Zwischenablage kopiert!',
    ],
    'this_action_will_reload_page' => 'Diese Aktion lädt die Seite neu, um die Daten zu aktualisieren!',
    'select' => 'Auswählen',
    'clear_filters' => 'Filter löschen',
    'set_this_variant_as_default' => 'Diese Variante als Standard festlegen',
    'download' => 'Herunterladen',
    'external_link_downloads' => 'Externe Links',
    'download_available_when_completed' => 'Download-Links sind verfügbar, wenn die Bestellung abgeschlossen ist.',
    'cross_sell_price_type' => [
        'title' => 'Preistyp',
        'fixed' => 'Fest',
        'percent' => 'Prozent',
    ],
    'cross_sell_help' => [
        'price' => '* Preisfeld',
        'price_description' => 'Geben Sie den Betrag ein, den Sie vom Originalpreis abziehen möchten. Beispiel: Wenn der Originalpreis 100 € beträgt, geben Sie 20 ein, um den Preis auf 80 € zu reduzieren.',
        'type' => '* Typfeld',
        'type_description' => 'Wählen Sie den Rabatttyp: Fest (einen bestimmten Betrag abziehen) oder Prozent (um einen Prozentsatz reduzieren).',
    ],
    'up_sell_price_type' => [
        'title' => 'Preistyp',
        'fixed' => 'Fest',
        'percent' => 'Prozent',
    ],
    'up_sell_help' => [
        'price' => '* Preisfeld',
        'price_description' => 'Geben Sie den Betrag ein, den Sie vom Originalpreis abziehen möchten. Beispiel: Wenn der Originalpreis 100 € beträgt, geben Sie 20 ein, um den Preis auf 80 € zu reduzieren.',
        'type' => '* Typfeld',
        'type_description' => 'Wählen Sie den Rabatttyp: Fest (einen bestimmten Betrag abziehen) oder Prozent (um einen Prozentsatz reduzieren).',
    ],
    'up_sale' => [
        'title' => 'Zusammen kaufen & sparen',
        'description' => 'Erhalten Sie spezielle Rabatte beim Kauf dieser Artikel zusammen',
        'unlock_discount' => 'Fügen Sie :product zum Warenkorb hinzu, um Bundle-Rabatt freizuschalten',
        'multiple_options' => 'Mehrere Optionen',
        'multiple_options_available' => 'Mehrere Optionen verfügbar',
        'select' => 'Auswählen',
        'selected_items_total' => 'Summe ausgewählter Artikel:',
        'add_selected_to_cart' => 'Ausgewählte zum Warenkorb hinzufügen',
        'bundle_discount_with' => 'Bundle-Rabatt mit :product',
        'bundle_with' => 'Bundle mit :product',
    ],
    'cross_sale' => [
        'title' => 'Häufig zusammen gekauft',
        'description' => 'Kunden, die diesen Artikel angesehen haben, kauften auch',
    ],
    'apply_for_all_variations' => 'Für alle Varianten anwenden',
    'export' => [
        'description' => 'Exportieren Sie Ihre Produktdaten in CSV- oder Excel-Dateien.',
        'total_items' => 'Gesamtartikel',
        'total_products' => 'Gesamtprodukte',
        'total_variations' => 'Gesamtvarianten',
        'advanced_options' => 'Erweiterte Optionen',
        'use_chunked_export' => 'Chunk-Export verwenden',
        'use_chunked_export_helper' => 'Daten in Chunks verarbeiten, um große Datensätze effizient zu verarbeiten',
        'include_variations' => 'Produktvarianten einbeziehen',
        'include_variations_helper' => 'Produktvarianten zusammen mit Hauptprodukten exportieren',
        'optimize_memory' => 'Speichernutzung optimieren',
        'optimize_memory_helper' => 'Speicheroptimierung für sehr große Exporte aktivieren',
        'chunk_size' => 'Chunk-Größe',
        'chunk_size_helper' => 'Anzahl der gleichzeitig zu verarbeitenden Produkte (50-5000)',
        'use_streaming' => 'Streaming-Export verwenden',
        'use_streaming_helper' => 'Streaming für sehr große Datensätze aktivieren (automatisch aktiviert für >10.000 Artikel)',
        'large_dataset_warning_title' => 'Großer Produktkatalog erkannt',
        'large_dataset_warning_message' => 'Ihr Katalog enthält :count Artikel. Aufgrund der großen Größe wurden einige Exportoptionen für beste Leistung optimiert.',
        'large_dataset_specific_message' => 'Für Ihre :count Produkte verwenden Sie das CSV-Format mit aktiviertem Streaming. Das System kann jetzt Ihren großen Produktkatalog effizient ohne Zeitüberschreitungen oder Speicherprobleme verarbeiten.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Erforderlich)',
        'chunk_label' => 'Verarbeitung',
        'chunk_recommended' => '300 Produkte/Batch',
        'time_label' => 'Geschätzte Zeit',
        'time_estimate' => '1-3 Minuten',
        'pro_tip' => 'Profi-Tipp:',
        'pro_tip_message' => 'Der Export läuft weiter, auch wenn Ihr Browser einen Ladeindikator anzeigt. Nach dem Start beginnt der Download automatisch.',
        'large_dataset_tip_1' => 'Excel-Format wurde deaktiviert - verwenden Sie das CSV-Format für schnellere und zuverlässigere Exporte',
        'large_dataset_tip_2' => 'Streaming-Modus wurde automatisch aktiviert, um Zeitüberschreitungen zu verhindern',
        'large_dataset_tip_3' => 'Der Exportvorgang kann je nach Server 1-3 Minuten dauern',
        'large_dataset_recommendation' => 'Empfohlen: Verwenden Sie das CSV-Format mit 200-500 Chunk-Größe für optimale Leistung.',
        'excel_disabled_for_large_export' => 'Excel-Format nicht verfügbar für Kataloge über 10.000 Artikel',
        'streaming_auto_enabled' => 'Streaming-Modus wurde automatisch für optimale Leistung mit großen Datensätzen aktiviert.',
        'streaming_enabled_title' => 'Für großen Export optimiert',
        'streaming_enabled_message' => 'Streaming-Modus ist aktiv, um einen reibungslosen Export ohne Speicherprobleme zu gewährleisten.',
        'use_multi_file' => 'Multi-Datei-Export verwenden',
        'use_multi_file_helper' => 'Export in mehrere Dateien aufteilen, die in einer ZIP-Datei für sehr große Datensätze verpackt sind',
        'multi_file_enabled_title' => 'Multi-Datei-Export aktiviert',
        'multi_file_enabled_message' => 'Ihr Export wird in :count Dateien aufgeteilt, die in einer ZIP-Datei für optimale Leistung verpackt sind.',
        'records_per_file' => 'Datensätze pro Datei',
        'records_per_file_helper' => 'Anzahl der Datensätze in jeder Datei bei Verwendung des Multi-Datei-Exports',
        'estimated_files' => 'Geschätzte Dateien',
        'recommended_range' => 'Empfohlener Bereich',
        'range_large_export' => '200-500 Artikel',
        'range_medium_export' => '300-800 Artikel',
        'range_small_export' => '500-1000 Artikel',
        'export_progress' => 'Exportfortschritt',
        'preparing_export' => 'Export wird vorbereitet...',
        'items_processed' => ':count Artikel verarbeitet',
        'estimated_time_calculating' => 'Geschätzte Zeit: wird berechnet...',
        'medium_dataset_detected' => 'Mittlerer Datensatz erkannt',
        'medium_dataset_message' => 'Sie exportieren :count Produkte. Erwägen Sie die Verwendung des Chunk-Exports für bessere Leistung.',
        'optimal_range' => 'Optimaler Bereich',
        'too_small_slow' => 'Zu klein - kann langsam sein',
        'too_large_timeouts' => 'Zu groß - kann Zeitüberschreitungen verursachen',
        'excel_disabled_warning' => 'Excel-Format für große Exporte deaktiviert (:count Artikel)',
        'starting_export' => 'Export wird gestartet...',
        'processing_data' => 'Daten werden verarbeitet...',
        'finalizing_export' => 'Export wird abgeschlossen...',
        'items_processed_suffix' => 'Artikel verarbeitet',
        'estimated_time_prefix' => 'Geschätzte Zeit:',
        'seconds_remaining' => 's verbleibend',
        'export_completed' => 'Export abgeschlossen!',
        'download_starting' => 'Download wird gestartet...',
    ],
    'import' => [
        'description' => 'Importieren Sie Ihre Produktdaten aus CSV- oder Excel-Dateien.',
        'rules' => [
            'in' => ':attribute muss einer der definierten Werte sein: :values.',
            'required_string_max' => ':attribute ist erforderlich und muss eine Zeichenkette mit einer maximalen Länge von :max Zeichen sein.',
            'nullable_string' => ':attribute kann leer gelassen werden oder muss eine Zeichenkette sein, falls angegeben.',
            'nullable_string_max' => ':attribute kann leer gelassen werden oder muss eine Zeichenkette mit einer maximalen Länge von :max Zeichen sein, falls angegeben',
            'nullable_bool' => 'Ob :attribute leer gelassen werden kann oder ein boolescher Wert sein muss, falls angegeben.',
            'nullable_numeric_min' => ':attribute kann leer gelassen werden oder muss eine nicht-negative Zahl sein, falls angegeben.',
            'nullable_numeric_min_max' => ':attribute kann leer gelassen werden oder muss eine Zahl zwischen :min und :max sein, falls angegeben.',
            'nullable_array' => ':attribute kann leer gelassen werden oder muss als Array angegeben werden, falls angegeben.',
            'nullable_date_required_if' => ':attribute kann leer gelassen werden oder muss ein gültiges Datum sein, falls angegeben, erforderlich wenn :required angegeben ist.',
            'nullable_date_after' => ':attribute kann leer gelassen werden oder muss ein gültiges Datum nach dem :after sein, falls angegeben.',
        ],
        'updated_message' => ':count Produkte erfolgreich aktualisiert!',
    ],
    'import_products_intro' => 'Oder Produkte aus CSV/Excel importieren',
    'select_attributes' => 'Attribute auswählen, um Varianten zu erstellen:',
    'all' => 'Alle',
    'copy' => 'Kopieren',
    'product_translations' => 'Produktübersetzungen',
    'view' => 'Produkt anzeigen - :name',
    'product_information' => 'Produktinformationen',
    'total_views' => 'Gesamtansichten',
    'total_orders' => 'Abgeschlossene Bestellungen',
    'total_sold' => 'Gesamt verkauft',
    'total_revenue' => 'Gesamtumsatz',
    'pending_orders' => 'Ausstehende Bestellungen',
    'pending_revenue' => 'Ausstehender Umsatz',
    'conversion_rate' => 'Conversion-Rate',
    'total_reviews' => 'Gesamtbewertungen',
    'average_rating' => 'Durchschnittliche Bewertung',
    'views_by_date' => 'Ansichten nach Datum (Letzte 30 Tage)',
    'recent_orders' => 'Letzte Bestellungen',
    'no_views_data' => 'Keine Ansichtsdaten für die letzten 30 Tage verfügbar.',
    'no_orders' => 'Noch keine Bestellungen.',
    'date' => 'Datum',
    'views' => 'Ansichten',
    'total' => 'Gesamt',
    'view_on_frontend' => 'Im Frontend anzeigen',
    'select_attribute' => ':name auswählen',
    'all_categories' => 'Alle Kategorien',
    'brands' => 'Marken',
    'browse_products' => 'Produkte durchsuchen',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Produkte zum Zurückgeben auswählen',
    'show_only_discounted_products' => 'Nur reduzierte Produkte anzeigen',
    'specification' => 'Spezifikation',
    'download_product_with_external_links' => 'Produkt ":name" mit externen Links herunterladen',
    'number_product_available_singular' => ':number Produkt verfügbar',
    'number_products_available_plural' => ':number Produkte verfügbar',
    'cart' => [
        'added_to_cart_success' => ':product wurde zu Ihrem Warenkorb hinzugefügt.',
        'removed_from_cart_success' => ':product wurde aus Ihrem Warenkorb entfernt.',
        'updated_cart_success' => 'Ihr Warenkorb wurde aktualisiert.',
        'item_not_found' => 'Dieser Artikel ist nicht mehr in Ihrem Warenkorb.',
        'out_of_stock' => 'Entschuldigung, :product ist derzeit nicht auf Lager.',
        'max_quantity' => 'Sie können nur bis zu :max Artikel hinzufügen.',
        'max_quantity_detail' => 'Entschuldigung, Sie können nur bis zu :quantity Einheiten von :product auf einmal bestellen.',
        'select_options' => 'Bitte wählen Sie Produktoptionen aus, bevor Sie zum Warenkorb hinzufügen.',
        'product_out_of_stock' => 'Entschuldigung, dieses Produkt ist derzeit nicht auf Lager.',
        'product_not_exists' => 'Dieses Produkt ist nicht auf Lager oder existiert nicht mehr.',
        'not_enough_quantity' => 'Einige Produkte haben nicht genug Lagerbestand zum Aktualisieren.',
        'empty_success' => 'Ihr Warenkorb wurde geleert.',
        'bundle_item_already_in_cart' => 'Dieser Bundle-Artikel ist bereits in Ihrem Warenkorb. Nur 1 Artikel pro Bundle-Rabatt ist erlaubt.',
    ],
    'wishlist' => [
        'added_success' => ':product wurde zu Ihrer Wunschliste hinzugefügt.',
        'removed_success' => ':product wurde aus Ihrer Wunschliste entfernt.',
        'product_not_found' => 'Dieses Produkt konnte nicht gefunden werden.',
        'product_not_in_wishlist' => 'Dieses Produkt ist nicht in Ihrer Wunschliste.',
        'product_not_available' => 'Dieses Produkt ist nicht verfügbar.',
    ],
    'compare' => [
        'added_success' => ':product wurde zu Ihrer Vergleichsliste hinzugefügt.',
        'removed_success' => ':product wurde aus Ihrer Vergleichsliste entfernt.',
        'product_not_found' => 'Dieses Produkt konnte nicht gefunden werden.',
        'product_not_in_compare' => 'Dieses Produkt ist nicht in Ihrer Vergleichsliste.',
        'already_in_list' => ':product ist bereits in Ihrer Vergleichsliste.',
    ],
];
