<?php

return [
    'save_settings' => 'Запазване на настройки',
    'ecommerce' => 'Електронна търговия',
    'general' => [
        'name' => 'Общи',
        'description' => 'Име на магазин, фирмена информация, контакти и имейли за известия на админ',
    ],
    'currency' => [
        'name' => 'Валути',
        'description' => 'Валутни формати, обменни курсове, автоматично откриване и десетични/хилядни разделители',
        'currency_setting_description' => 'Преглед и актуализиране на валутите, използвани на уебсайта',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Активиране на автоматично откриване на валутата на посетителя',
            'enable_auto_detect_visitor_currency_helper' => 'Автоматично откриване и показване на цени в местната валута на посетителя въз основа на тяхното местоположение. Това осигурява по-персонализирано пазаруване.',
            'add_space_between_price_and_currency' => 'Добавяне на интервал между цената и валутата',
            'add_space_between_price_and_currency_helper' => 'Когато е активирано, добавя интервал между стойността на цената и символа на валутата (напр. "100 USD" вместо "100USD").',
            'thousands_separator' => 'Разделител за хиляди',
            'thousands_separator_helper' => 'Изберете знака за разделяне на хилядите в показването на цената (напр. 1,000 или 1.000 или 1 000).',
            'decimal_separator' => 'Десетичен разделител',
            'decimal_separator_helper' => 'Изберете знака за разделяне на десетичните стойности в цените (напр. 10.99 или 10,99).',
            'separator_period' => 'Точка (.)',
            'separator_comma' => 'Запетая (,)',
            'separator_space' => 'Интервал ( )',
            'api_key' => 'API ключ за обменни курсове',
            'api_key_helper' => 'Получете API ключ за обменен курс на :link',
            'update_currency_rates' => 'Актуализиране на валутните курсове',
            'use_exchange_rate_from_api' => 'Използване на обменен курс от API',
            'use_exchange_rate_from_api_helper' => 'Активиране на автоматични актуализации на обменния курс на валутата от конфигурирания API доставчик. Това гарантира, че вашите цени винаги са актуални с текущите пазарни курсове.',
            'clear_cache_rates' => 'Изчистване на кеша на курсовете',
            'auto_detect_visitor_currency_description' => 'Той открива валутата на посетителя въз основа на езика на браузъра. Той ще замени избора на валута по подразбиране.',
            'exchange_rate' => [
                'api_provider' => 'API доставчик',
                'select' => '-- Изберете --',
                'none' => 'Няма',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'За валутата по подразбиране обменният курс трябва да бъде 1.',
        ],
    ],
    'product' => [
        'name' => 'Продукти',
        'description' => 'Показване на наличност, генериране на SKU, изображения на варианти, свързани продукти и спецификации',
        'product_settings' => 'Настройки на продуктите',
        'product_settings_description' => 'Конфигуриране на правила за продукт',
        'form' => [
            'show_number_of_products' => 'Показване на броя на продуктите в единичния продукт',
            'show_number_of_products_helper' => 'Показване на общия брой продукти на страницата с подробности за продукта.',
            'show_out_of_stock_products' => 'Показване на изчерпани продукти',
            'show_out_of_stock_products_helper' => 'Ако е активирано, изчерпаните продукти ще бъдат показани на страницата със списък на продуктите.',
            'how_to_display_product_variation_images' => 'Как да се показват изображенията на вариациите на продукта',
            'how_to_display_product_variation_images_helper' => 'Изберете дали да показвате само изображения, специфични за вариацията, или да включите както изображения на вариацията, така и основните изображения на продукта.',
            'only_variation_images' => 'Само изображения на вариацията',
            'variation_images_and_main_product_images' => 'Изображения на вариацията и основни изображения на продукта',
            'enable_product_options' => 'Активиране на опции за продукти',
            'enable_product_options_helper' => 'Позволете на продуктите да имат персонализируеми опции като размер, цвят и др.',
            'is_enabled_cross_sale_products' => 'Активиране на кръстосани продажби',
            'is_enabled_cross_sale_products_helper' => 'Показване на предложения за продукти за кръстосани продажби, за да насърчите допълнителни покупки.',
            'is_enabled_related_products' => 'Активиране на свързани продукти',
            'is_enabled_related_products_helper' => 'Показване на свързани продукти въз основа на категория или избрани от администратора във формата на продукта.',
            'related_products_source' => 'Източник на свързани продукти',
            'related_products_source_helper' => 'Когато администраторът не избере свързани продукти във формата на продукта, покажете свързани продукти въз основа на този източник.',
            'related_products_source_category' => 'Същата категория',
            'related_products_source_brand' => 'Същата марка',
            'trending_products_period' => 'Период на популярни продукти',
            'trending_products_period_helper' => 'Изберете времевия период, който да се вземе предвид за изчисляване на популярни продукти въз основа на броя на прегледите.',
            'trending_products_period_1_day' => 'Последните 24 часа',
            'trending_products_period_3_days' => 'Последните 3 дни',
            'trending_products_period_7_days' => 'Последните 7 дни (1 седмица)',
            'trending_products_period_14_days' => 'Последните 14 дни (2 седмици)',
            'trending_products_period_30_days' => 'Последните 30 дни (1 месец)',
            'trending_products_period_60_days' => 'Последните 60 дни (2 месеца)',
            'trending_products_period_90_days' => 'Последните 90 дни (3 месеца)',
            'auto_generate_product_sku' => 'Автоматично генериране на SKU при създаване на продукт',
            'auto_generate_product_sku_helper' => 'Автоматично генериране на уникални SKU за нови продукти въз основа на формата по-долу.',
            'product_sku_format' => 'Формат на SKU',
            'product_sku_format_helper' => 'Можете да използвате %s (1 низов знак) или %d (1 цифра) във формата, за да генерирате случаен низ. Напр.: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Активиране на спецификация на продукта',
            'enable_product_specification_help' => 'Ако е активирано, таблицата със спецификации на продукта ще бъде показана на страницата с подробности за продукта.',
            'make_product_barcode_required' => 'Направете баркода на продукта задължителен',
            'make_product_barcode_required_helper' => 'Ако е активирано, баркодът на продукта ще бъде задължителен при създаване на продукт.',
        ],
    ],
    'product_search' => [
        'name' => 'Търсене на продукти',
        'description' => 'Поведение на търсене, филтри по категория/марка/таг/атрибути и филтриране по ценови диапазон',
        'product_search_settings' => 'Търсене на продукти',
        'product_search_settings_description' => 'Конфигуриране на правила за търсене на продукти',
        'form' => [
            'search_for_an_exact_phrase' => 'Търсене на точна фраза',
            'search_products_by' => 'Търсене на продукти по:',
            'enable_filter_products_by_categories' => 'Активиране на филтриране на продукти по категории',
            'enable_filter_products_by_brands' => 'Активиране на филтриране на продукти по марки',
            'enable_filter_products_by_tags' => 'Активиране на филтриране на продукти по тагове',
            'number_of_popular_tags_for_filter' => 'Брой популярни тагове за филтър',
            'number_of_popular_tags_for_filter_placeholder' => 'Въведете броя на популярните тагове за показване',
            'number_of_popular_tags_for_filter_helper' => 'Задайте максималния брой популярни тагове за показване във филтъра. По подразбиране е 10.',
            'enable_filter_products_by_attributes' => 'Активиране на филтриране на продукти по атрибути',
            'enable_filter_products_by_price' => 'Активиране на филтриране на продукти по цена',
            'max_product_price_for_filter' => 'Максимална цена на продукт за филтър',
            'max_product_price_for_filter_placeholder' => 'Ако е празно или нула, ще се вземе максималната цена на продукта от вашите съществуващи продукти.',
            'max_product_price_for_filter_helper' => 'Можете да зададете фиксирана цена за това или динамично ще се вземе максималната цена на продукта от вашите съществуващи продукти. В момента тя е :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Дигитални продукти',
        'description' => 'Продукти за изтегляне, лицензионни кодове, плащане като гост за дигитални продукти и автоматично завършване',
        'digital_products_settings' => 'Дигитални продукти',
        'digital_products_settings_description' => 'Конфигуриране на правила за дигитални продукти',
        'form' => [
            'enable_support_digital_product' => 'Активирана ли е поддръжката на дигитални продукти',
            'enable_support_digital_product_helper' => 'Когато е активирано, системата ще поддържа продажба на дигитални продукти като софтуер, електронни книги, музика и друго съдържание за изтегляне.',
            'allow_guest_checkout_for_digital_products' => 'Позволи плащане като гост за дигитални продукти',
            'allow_guest_checkout_for_digital_products_helper' => 'Когато е активирано, клиентите могат да закупуват дигитални продукти без да създават акаунт. Те ще получат връзки за изтегляне по имейл.',
            'disable_physical_product' => 'Деактивиране на физически продукт',
            'disable_physical_product_helper' => 'Когато е активирано, магазинът ще продава само дигитални продукти. Опциите за физически продукти ще бъдат скрити от формите на продуктите и плащането.',
            'enable_license_codes_for_digital_products' => 'Активиране на лицензни кодове за дигитални продукти',
            'auto_complete_digital_orders_after_payment' => 'Автоматично завършване на дигитални поръчки след плащане',
            'auto_complete_digital_orders_after_payment_helper' => 'Когато е активирано, поръчките, съдържащи само дигитални продукти, ще бъдат автоматично маркирани като завършени след получаване на плащането.',
            'enable_license_codes_for_digital_products_helper' => 'Когато е активирано, можете да добавяте лицензни кодове към дигитални продукти. Когато е деактивирано, функцията за лицензни кодове ще бъде скрита от формите на продуктите.',
            'hide_used_license_codes_in_product_form' => 'Скриване на използваните лицензни кодове във формата на продукта',
            'hide_used_license_codes_in_product_form_helper' => 'Когато е активирано, използваните лицензни кодове ще бъдат скрити от таблицата с лицензни кодове във формата за редактиране на продукт. Това помага да се поддържа чист интерфейс, когато имате много използвани кодове.',
        ],
    ],
    'product_review' => [
        'name' => 'Отзиви за продукти',
        'description' => 'Клиентски отзиви, показване на оценки, качване на изображения и изисквания за одобрение',
        'form' => [
            'enable_review' => 'Активиране на отзиви за продукти',
            'enable_review_help' => 'Позволете на клиентите да оставят отзиви и оценки за продуктите. Когато е деактивирано, всички функции за отзиви ще бъдат скрити от магазина.',
            'allow_customer_upload_image_in_review' => 'Позволи на клиентите да качват изображения в отзиви',
            'allow_customer_upload_image_in_review_help' => 'Когато е деактивирано, клиентите не могат да качват изображения при подаване на отзиви',
            'review' => [
                'max_file_size' => 'Максимален размер на файл за отзив (MB)',
                'max_file_number' => 'Максимален брой файлове за отзив',
            ],
            'only_allow_customers_purchased_to_review' => 'Само клиенти, които са закупили продукта, могат да оставят отзив за продукта',
            'review_need_to_be_approved' => 'Отзивът трябва да бъде одобрен преди да се покаже на страницата на продукта',
            'show_customer_full_name' => 'Показване на пълното име на клиента',
            'show_customer_full_name_help' => 'Ако не е отметнато, името на клиента, оставящ отзив, ще бъде скрито и заменено със звездички (***)',
            'hide_rating_when_no_reviews' => 'Скриване на оценката, когато няма отзиви',
            'hide_rating_when_no_reviews_help' => 'Когато е активирано, оценките на продукти ще бъдат скрити в списъците с продукти и страниците с подробности за продукта, когато продуктът няма отзиви',
            'display_uploaded_customer_review_images_list' => 'Показване на раздел "Изображения от клиенти"',
            'display_uploaded_customer_review_images_list_help' => 'Когато е активирано, показва галерия на всички качени от клиенти изображения в горната част на раздела с отзиви',
        ],
    ],
    'shopping' => [
        'name' => 'Пазаруване',
        'description' => 'Количка, списък с желания, сравнение, проследяване на поръчки, бутон за бърза покупка и качване на доказателство за плащане',
        'general_setting' => 'Общи настройки',
        'return_settings' => 'Настройки за връщане',
        'return_settings_description' => 'Конфигуриране на правила за настройки за връщане',
        'form' => [
            'enable_cart' => 'Активиране на количка за пазаруване',
            'enable_cart_helper' => 'Ако е деактивирано, бутонът за количка ще бъде премахнат, превръщайки вашия сайт в каталог само за показване.',
            'enable_wishlist' => 'Активиране на списък с желания',
            'enable_wishlist_helper' => 'Ако е деактивирано, бутонът за списък с желания ще бъде премахнат от сайта.',
            'enable_wishlist_sharing' => 'Активиране на споделяне на списък с желания',
            'shared_wishlist_lifetime' => 'Срок на споделения списък с желания (дни)',
            'shared_wishlist_lifetime_helper' => 'Срокът на споделения списък с желания в дни. След това време споделеният списък с желания ще бъде изтрит.',
            'enable_compare' => 'Активиране на сравнение',
            'enable_compare_helper' => 'Ако е деактивирано, бутонът за сравнение ще бъде премахнат от сайта.',
            'enable_order_tracking' => 'Активиране на проследяване на поръчки',
            'enable_order_tracking_helper' => 'Клиентите могат да проследяват своите поръчки, като въведат кода на поръчката и имейл/телефон на :url',
            'order_tracking_method' => 'Метод на проследяване на поръчки',
            'order_tracking_method_helper' => 'Изберете как клиентите ще проследяват своите поръчки: използвайки ID на поръчка + Имейл или ID на поръчка + Телефонен номер.',
            'order_tracking_method_email' => 'ID на поръчка + Имейл',
            'order_tracking_method_phone' => 'ID на поръчка + Телефонен номер',
            'enable_quick_buy_button' => 'Активиране на бутон за бързо закупуване',
            'enable_quick_buy_button_helper' => 'Ще се покаже бутон "Купи сега" на страницата със списък на продуктите и страницата с подробности. Когато клиентите щракнат върху този бутон, продуктът ще бъде добавен в количката и пренасочен към страницата за количка/плащане.',
            'enable_order_auto_confirmed' => 'Автоматично потвърждаване на поръчка',
            'enable_order_auto_confirmed_helper' => 'Ако е активирано, поръчката ще бъде автоматично потвърдена след като клиентът направи поръчка.',
            'quick_buy_target' => 'Целева страница за бързо закупуване',
            'checkout_page' => 'Страница за плащане',
            'cart_page' => 'Страница за количка',
            'cart_destroy_on_logout' => 'Унищожаване на количката при излизане',
            'cart_destroy_on_logout_helper' => 'Количката ще бъде унищожена, когато клиентът излезе.',
            'hide_product_price' => 'Скриване на цената на продукта',
            'hide_product_price_helper' => 'Тази опция работи само ако деактивирате количката за пазаруване, превръщайки вашия сайт в каталог само за показване. Ако е активирано, цената на продукта ще бъде скрита. Това е полезно, когато искате да скриете цената и да изисквате от клиентите да се свържат с вас за цената.',
            'hide_product_price_when_zero' => 'Скриване на цената на продукта, когато е нула',
            'hide_product_price_when_zero_helper' => 'Ако е включено, продукти с цена 0 няма да показват цена във витрината.',
            'enable_payment_proof' => 'Активиране на качване на доказателство за плащане',
            'enable_payment_proof_helper' => 'Позволете на клиентите да качват доказателство за плащане за техните поръчки. Това е полезно за методи за ръчно плащане.',
            'enable_guest_payment_proof' => 'Позволи на клиенти гости да качват доказателство за плащане',
            'enable_guest_payment_proof_helper' => 'Когато е активирано, клиенти гости могат да качват доказателство за плащане, използвайки техния токен за поръчка без да влизат. Те ще получат връзката за качване в имейла за потвърждение на поръчката.',
            'payment_proof_payment_methods' => 'Методи на плащане, изискващи доказателство за плащане',
            'payment_proof_payment_methods_helper' => 'Изберете кои методи на плащане трябва да позволяват на клиентите да качват доказателство за плащане. Обикновено се използва за ръчни методи на плащане като наложен платеж и банков превод.',
        ],
    ],
    'checkout' => [
        'name' => 'Плащане',
        'panel_description' => 'Плащане като гост, задължителни полета, лимити на поръчки, приемане на условия и ограничения по държави',
        'description' => 'Конфигуриране на правила за настройки на плащане',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Показване на банкова информация на страницата за успешно плащане',
            'mandatory_form_fields_at_checkout' => 'Задължителни полета на страницата за плащане:',
            'mandatory_form_fields_at_checkout_helper' => 'Изберете кои полета са задължителни по време на плащане. Клиентите трябва да попълнят тези полета, за да завършат поръчката си.',
            'hide_form_fields_at_checkout' => 'Скриване на полета за клиенти на страницата за плащане:',
            'hide_form_fields_at_checkout_helper' => 'Изберете кои полета трябва да бъдат скрити на страницата за плащане. Тези полета няма да бъдат видими за клиентите.',
            'load_countries_states_cities_from_location_plugin' => 'Зареждане на държави, щати, градове от приставка за местоположение',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'След промяна на тази опция, трябва да актуализирате всички адреси отново. Трябва да го зададете веднъж.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'След това трябва да отидете на Инструменти -> Импортиране/Експортиране на данни, за да импортирате данни за местоположение.',
            'minimum_order_amount' => 'Минимална сума на поръчка за направа на поръчка (:currency).',
            'minimum_order_amount_helper' => 'Задайте минималната обща сума, необходима за обработка на поръчка. Поръчки под тази сума няма да бъдат приети.',
            'zip_code_enabled' => 'Активиране на пощенски код',
            'zip_code_enabled_helper' => 'Активиране или деактивиране на полето за пощенски код във формата за адрес за доставка.',
            'billing_address_enabled' => 'Активиране на адрес за фактуриране',
            'billing_address_enabled_helper' => 'Позволете на клиентите да въведат отделен адрес за фактуриране, който се различава от техния адрес за доставка.',
            'display_tax_fields_at_checkout_page' => 'Показване на полета за данъчна информация на страницата за плащане',
            'display_tax_fields_at_checkout_page_helper' => 'Ако е активирано, полетата за данъчна информация ще бъдат показани за въвеждане на данъчни данни на компанията, за да се получи фактура.',
            'use_city_field_as_field_text' => 'Използване на полето за град като текстово поле',
            'available_countries' => 'Налични държави',
            'all' => 'Всички',
            'all_helper_text' => 'Ако премахнете отметката от всички държави, то ще се приложи за всички държави.',
            'enable_guest_checkout' => 'Активиране на плащане като гост',
            'enable_guest_checkout_helper' => 'Ако е активирано, клиентите могат да направят поръчка без да създават акаунт.',
            'recently_viewed' => [
                'enable' => 'Активиране на наскоро преглеждани продукти на клиента',
                'enable_helper' => 'Проследявайте и показвайте продукти, които клиентите са преглеждали наскоро. Това помага на клиентите лесно да намерят продукти, които са ги интересували.',
                'max' => 'Максимален брой наскоро преглеждани продукти на клиента',
                'max_helper_text' => 'Ако е зададено на 0, няма да има ограничение.',
            ],
            'minimum_order_quantity' => 'Минимално количество на поръчка',
            'minimum_order_quantity_helper' => 'Минимално количество за направа на поръчка. Оставете го на 0, ако не искате да го зададете.',
            'maximum_order_quantity' => 'Максимално количество на поръчка',
            'maximum_order_quantity_helper' => 'Максимално количество за направа на поръчка. Оставете го на 0, ако не искате да го зададете.',
            'default_country_at_checkout_page' => 'Държава по подразбиране на страницата за плащане',
            'default_country_at_checkout_page_placeholder' => 'Изберете държава',
            'default_country_at_checkout_page_help' => 'Ако изберете държава, тя ще бъде избрана по подразбиране на страницата за плащане.',
            'checkout_product_quantity_editable' => 'Позволи на клиентите да променят количеството на продукта на страницата за плащане',
            'checkout_product_quantity_editable_helper' => 'Когато е активирано, клиентите могат да променят количеството на продуктите директно на страницата за плащане без да се връщат в количката.',
            'show_terms_and_policy_checkbox' => 'Показване на квадратче за условия и политика',
            'show_terms_and_policy_checkbox_helper' => 'Ако е активирано, клиентите трябва да се съгласят с условията и политиката преди да направят поръчка. Моля, настройте URL на условията и политиката за поверителност в Външен вид -> Опции на темата първо.',
            'terms_and_policy_checkbox_checked_by_default' => 'Квадратче за условия и политика отметнато по подразбиране',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Ако е активирано, квадратчето за условия и политика ще бъде предварително отметнато, когато се зареди формата за плащане.',
            'checkout_acceptance_message_enabled' => 'Показване на съобщение за приемане при плащане',
            'checkout_acceptance_message_enabled_helper' => 'Показване на информационно съобщение, което информира клиентите за условията, с които се съгласяват, като направят поръчка.',
            'hide_customer_info_at_checkout' => 'Скриване на информацията за клиента при плащане',
            'hide_customer_info_at_checkout_helper' => 'Скриване на информацията за акаунта на клиента и бутона за излизане от страницата за плащане. Когато е активирано, влезлите клиенти няма да видят данните на техния акаунт.',
        ],
    ],
    'return' => [
        'name' => 'Връщане',
        'description' => 'Конфигуриране на правила за настройки за връщане',
        'panel_description' => 'Връщане на поръчки, частични връщания и срокове за връщане',
        'form' => [
            'is_enabled_order_return' => 'Активирано ли е връщане на поръчка',
            'allow_partial_return' => 'Позволи частично връщане',
            'allow_partial_return_description' => 'Клиентът може да върне няколко продукта, без да е необходимо да връща всички продукти в поръчка.',
            'returnable_days' => 'Дни за връщане',
            'return_settings_helper' => 'Брой дни, през които клиентът може да поиска връщане след завършване на поръчката.',
        ],
    ],
    'invoice' => [
        'name' => 'Фактури',
        'description' => 'Фирмени данни на фактури, номериране на фактури, PDF шрифтове и настройки на печат',
        'company_settings' => 'Invoice configuration',
        'company_settings_description' => 'Company info, invoice numbering, PDF fonts, and payment stamp',
        'form' => [
            'company_name' => 'Име на компанията',
            'company_address' => 'Адрес на компанията',
            'company_zipcode' => 'Пощенски код на компанията',
            'company_email' => 'Имейл на компанията',
            'company_phone' => 'Телефон на компанията',
            'company_logo' => 'Лого на компанията',
            'company_tax_id' => 'Данъчен номер на компанията',
            'invoice_code_prefix' => 'Префикс на код на фактура',
            'using_custom_font_for_invoice' => 'Използване на персонализиран шрифт за фактура',
            'invoice_font_family' => 'Семейство шрифтове на фактура (Работи само за латински език)',
            'enable_invoice_stamp' => 'Активиране на печат на фактура',
            'add_language_support' => 'Добавяне на езикова поддръжка',
            'invoice_processing_library' => 'Библиотека за обработка на фактури',
            'only_latin_languages' => 'Само латински езици',
            'disable_order_invoice_until_order_confirmed' => 'Деактивиране на фактура за поръчка до потвърждаване на поръчката',
            'date_format' => 'Формат на дата',
            'languages' => [
                'arabic' => 'Арабски',
                'bangladesh' => 'Бенгалски',
                'chinese' => 'Китайски',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Данък',
        'description' => 'Tax calculation, display options, and checkout invoice fields',
        'enable' => 'Активиране на данък?',
        'display_product_price_including_taxes' => 'Показване на цената на продукта с включени данъци?',
        'display_tax_description' => 'Показване на данъчна информация върху цената на продукта?',
        'display_tax_description_help' => 'Показване на текст като "(Включително X% ДДС)" или "(Изключващо X% ДДС)" до цените на продуктите на страницата с подробности за продукта.',
        'tax_included_in_products_price' => 'Данъкът е включен в цените на продуктите',
        'tax_included_in_products_price_description' => 'Данъкът ще бъде включен в цените на продуктите',
        'tax_setting' => 'Tax display & checkout',
        'tax_setting_description' => 'Configure how taxes are displayed on products and checkout pages',
        'tax_management' => 'Управление на данъци',
        'tax_management_description' => 'Преглед и управление на вашите данъци',

        'manage_taxes_info' => 'За да управлявате данъците и да зададете данъчна ставка по подразбиране, моля, отидете на',
        'go_to_taxes' => 'Електронна търговия → Данъци',        'form' => [
            'enable_tax' => 'Активиране на данък',
            'display_company_invoice_information_fields_at_checkout_page' => 'Показване на полета за информация за фактура на компанията на страницата за плащане',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Ако е активирано, полетата за информация за фактура на компанията ще бъдат показани на страницата за плащане. Необходимо е да се попълни информацията за фактура на компанията.',
            'default_tax_rate' => 'Данъчна ставка по подразбиране',
            'default_tax_rate_description' => 'Важно: тя ще се приложи, ако не е избран данък в продукта.',
            'select_tax' => '-- Изберете --',
            'display_product_price_including_taxes' => 'Добавяне на данък към показваните цени',
            'display_product_price_including_taxes_helper' => 'Автоматично добавя данък към цените на продуктите в магазина. Напр. продукт за $100 с 10% данък се показва като $110. Не е необходимо, ако "Цената включва данък" е активирано за отделните продукти.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Клиенти',
        'description' => 'Регистрация, имейл верификация, опции за вход, изтриване на акаунт и полета на профила',
        'customer_setting' => 'Настройки на клиент',
        'customer_setting_description' => 'Конфигуриране на настройки на клиент',
        'form' => [
            'enable_customer_registration' => 'Активиране на регистрация на клиент',
            'enable_customer_registration_helper' => 'Ако е деактивирано, клиентите няма да могат да регистрират нови акаунти. Съществуващите клиенти все още могат да влизат.',
            'verify_customer_email' => 'Проверка на имейла на клиента',
            'verify_customer_email_helper' => 'Когато е активирано, ще бъде изпратена връзка за проверка на имейла на клиента, клиентите трябва да щракнат върху тази връзка, за да проверят своя имейл, преди да могат да влязат. Необходимо е да конфигурирате имейл в Админ -> Настройки -> Имейл, за да изпращате имейл за проверка.',
            'verification_expire_minutes' => 'Срок на валидност на връзката за проверка',
            'verification_expire_minutes_helper' => 'Времето в минути, през което връзката за проверка на имейла ще бъде валидна. По подразбиране е 60 минути (1 час). Максимум е 10080 минути (7 дни).',
            'login_using_phone' => 'Влизане с телефонен номер вместо имейл',
            'login_option' => 'Опция за влизане',
            'login_with_email' => 'Влизане с имейл',
            'login_with_phone' => 'Влизане с телефон',
            'login_with_email_or_phone' => 'Влизане с имейл или телефон',
            'enabled_customer_account_deletion' => 'Активиране на изтриване на акаунт на клиент',
            'enabled_customer_account_deletion_helper' => 'Когато е активирано, клиентите могат да изтрият своя акаунт в табло на клиента → Настройки на акаунта.',
            'enabled_customer_dob_field' => 'Активиране на поле за дата на раждане на клиента',
            'enabled_customer_dob_field_helper' => 'Когато е активирано, клиентите могат да въведат своята дата на раждане в табло на клиента → Настройки на акаунта.',
            'enabled_phone_field_in_registration_form' => 'Активиране на поле за телефон във формата за регистрация',
            'enabled_phone_field_in_registration_form_helper' => 'Когато е активирано, полето за телефон ще бъде добавено към формата за регистрация.',
            'make_customer_phone_number_required' => 'Направете телефонния номер на клиента задължителен',
            'make_customer_phone_number_required_helper' => 'Когато е активирано, клиентите трябва да въведат своя телефонен номер по време на регистрация. Той винаги е задължителен за клиенти, които влизат с телефонен номер.',
            'default_avatar' => 'Аватар по подразбиране',
            'default_avatar_helper' => 'Аватар по подразбиране за клиент, когато нямат аватар. Ако не изберете изображение, то ще бъде генерирано с използване на вашето лого или първия знак от името на клиента.',
            'keep_email_field_in_registration_form' => 'Запазване на полето за имейл във формата за регистрация',
            'keep_email_field_in_registration_form_helper' => 'Когато е деактивирано, полето за имейл ще бъде скрито във формата за регистрация, когато опцията за влизане е "Влизане с телефон".',
        ],
    ],
    'shipping' => [
        'name' => 'Доставка',
        'description' => 'Правила за доставка, поведение на безплатна доставка и ред на показване на опции за доставка',
        'shipping_rule' => 'Правила за доставка',
        'shipping_rule_description' => 'Конфигуриране на правила за изчисляване на такса за доставка',
        'shipping_setting' => 'Настройки за доставка',
        'shipping_setting_description' => 'Конфигуриране на настройки за доставка',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Скриване на други опции за доставка, ако има безплатна доставка в списъка',
            'disable_shipping_options' => 'Деактивиране на опции за доставка',
            'disable_shipping_options_helper' => 'Опциите за доставка ще бъдат премахнати на страницата за плащане, клиентът няма да може да избере опции за доставка.',
            'sort_shipping_options_direction' => 'Посока на сортиране на опциите за доставка',
            'sort_shipping_options_direction_helper' => 'Сортиране на опциите за доставка по цена от по-ниска към по-висока или от по-висока към по-ниска.',
            'price_lower_to_higher' => 'Цена от по-ниска към по-висока',
            'price_higher_to_lower' => 'Цена от по-висока към по-ниска',
        ],
    ],
    'webhook' => [
        'name' => 'Webhooks',
        'description' => 'Send order events to external services via HTTP callbacks',
        'webhook_setting' => 'Order event webhooks',
        'webhook_setting_description' => 'Configure URLs to receive notifications when orders are placed, updated, or shipped',
        'form' => [
            'order_placed_webhook_url' => 'URL на webhook за направена поръчка (метод: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'За да получавате известия, когато е направена поръчка, можете да настроите външен URL на webhook. Ако имате външен URL на webhook, можете да въведете този URL или просто да го оставите празен.',
            'order_updated_webhook_url' => 'URL на webhook за актуализирана поръчка (метод: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'За да получавате известия, когато поръчка е актуализирана, можете да настроите външен URL на webhook. Това включва промени в статуса, актуализации на адреса и други модификации на поръчката.',
            'shipping_status_updated_webhook_url' => 'URL на webhook за актуализиран статус на доставка (метод: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'За да получавате известия, когато статусът на доставката се променя (напр. изпратено, доставено, отменено), можете да настроите външен URL на webhook.',
            'order_completed_webhook_url' => 'URL на webhook за завършена поръчка (метод: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'За да получавате известия, когато поръчка е завършена, можете да настроите външен URL на webhook.',
            'order_cancelled_webhook_url' => 'URL на webhook за отменена поръчка (метод: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'За да получавате известия, когато поръчка е отменена, можете да настроите външен URL на webhook.',
            'payment_status_updated_webhook_url' => 'URL на webhook за актуализиран статус на плащане (метод: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'За да получавате известия, когато статусът на плащането се променя (напр. платено, неуспешно, възстановено), можете да настроите външен URL на webhook.',
            'abandoned_cart_webhook_url' => 'URL на webhook за изоставена количка (метод: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'За да получавате известия, когато количките са изоставени и да проследявате клиентите, можете да настроите външен URL на webhook. Известията се изпращат след конфигурируем период от време.',
        ],
        'test_button' => 'Тест на Webhook',
        'test_success' => 'Тестът на webhook е успешен! Крайната точка отговори правилно.',
        'test_failed' => 'Тестът на webhook се провали. Крайната точка не отговори както се очакваше.',
        'test_error' => 'Грешка при теста на webhook: :error',
        'please_enter_url' => 'Моля, първо въведете URL на webhook',
        'testing' => 'Тестване...',
        'test_failed_title' => 'Тестът се провали!',
        'test_success_title' => 'Тестът е успешен!',
        'status_code' => 'Код на статус',
        'error_occurred' => 'Възникна грешка при тестване на webhook',
    ],
    'store_locator' => [
        'name' => 'Локатори на магазини',
        'description' => 'Преглед и актуализиране на списъците на вашите вериги',
        'store_locator_description' => 'Всички списъци на вашите вериги, основни магазини, клонове и др. Местоположенията могат да се използват за проследяване на продажбите и за да ни помогнат да конфигурираме данъчните ставки, които да се начисляват при продажба на продукти.',
        'form' => [
            'change_primary_store' => 'промяна на локатора на магазина по подразбиране',
            'add_location' => 'Добавяне на местоположение',
            'edit_location' => 'Редактиране на местоположение',
            'delete_location' => 'Изтриване на местоположение',
            'delete_location_confirmation' => 'Сигурни ли сте, че искате да изтриете това местоположение? Това действие не може да бъде отменено.',
            'change_primary_location' => 'Промяна на основно местоположение',
            'save_location' => 'Запазване на местоположение',
            'add_new' => 'Добавяне на ново',
        ],
        'info' => [
            'title' => 'Как работят локаторите на магазини',
            'primary_store' => 'Адресът на основния магазин се появява във фактури и се използва като адрес за връщане по подразбиране за етикети за доставка.',
            'shipping_location' => 'Магазините, маркирани като "място за доставка", могат да бъдат избрани като склад на произход при създаване на пратки.',
            'shipment_selection' => 'При обработка на поръчки можете да изберете от кой склад да изпратите въз основа на наличност и местоположение на клиента.',
        ],
    ],
    'tracking' => [
        'name' => 'Проследяване',
        'description' => 'Facebook Pixel, събития на Google Tag Manager и проследяване на конверсии в Google Ads',
        'manage_tracking' => 'Управление на проследяване',
        'manage_tracking_description' => 'Управление на проследяване: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Активиране на Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Отидете на https://developers.facebook.com/docs/meta-pixel, за да създадете Facebook Pixel. Уверете се, че вашият пиксел е активен и правилно конфигуриран.',
            'facebook_pixel_id' => 'Facebook Pixel ID',
            'facebook_pixel_id_placeholder' => 'Пример: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Активиране на режим за отстраняване на грешки на Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Активирайте режима за отстраняване на грешки, за да регистрирате събитията на Facebook Pixel в конзолата на браузъра и да отстраните проблеми с проследяването',
            'enable_google_tag_manager_tracking_events' => 'Активиране на събития за проследяване на Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Когато е активирано, събитията на електронната търговия ще бъдат проследявани чрез Google Tag Manager. Уверете се, че сте конфигурирали Google Tag Manager по-горе.',
            'google_ads_conversion_id' => 'Google Ads Conversion ID',
            'google_ads_conversion_id_helper' => 'Въведете вашия ID на конверсия на Google Ads (формат: AW-123456789/AbC-D_efG-h1_ijk-lmN), за да проследявате конверсиите от покупки на страницата за благодарност.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel ID трябва да бъде 15-16 цифри (напр. 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Пазар',
        'description' => 'Настройки за много продавачи, комисионни, регистрация на продавачи и конфигурация на плащания',
    ],
    'standard_and_format' => [
        'name' => 'Стандарт и формат',
        'panel_description' => 'Формат на код на поръчка, единици за тегло (кг/фунт) и единици за размери (см/инч)',
        'description' => 'Стандартите и форматите се използват за изчисляване на неща като цени на продукти, тегла на доставка и времена на поръчки.',
        'form' => [
            'change_order_format' => 'Редактиране на формата на код на поръчка (по избор)',
            'change_order_format_description' => 'Кодът на поръчка по подразбиране започва от: номер. Можете да промените началния или крайния низ, за да създадете кода на поръчка, който искате, например "DH-: номер" или ": номер-A"',
            'start_with' => 'Започва с',
            'end_with' => 'Завършва с',
            'order_will_be_shown' => 'Вашият код на поръчка ще бъде показан',
            'weight_unit' => 'Единица за тегло',
            'height_unit' => 'Единица дължина / височина',
            'weight_unit_gram' => 'Грам (g)',
            'weight_unit_kilogram' => 'Килограм (kg)',
            'weight_unit_lb' => 'Фунт (lb)',
            'weight_unit_oz' => 'Унция (oz)',
            'height_unit_cm' => 'Сантиметър (cm)',
            'height_unit_m' => 'Метър (m)',
            'height_unit_inch' => 'Инч',
        ],
    ],
    'sale_popup' => [
        'name' => 'Изскачащ прозорец за разпродажба',
        'description' => 'Персонализирайте настройките на вашия изскачащ прозорец за разпродажба с лекота',
    ],
    'flash_sale' => [
        'name' => 'Светкавична разпродажба',
        'description' => 'Конфигуриране на настройките за светкавична разпродажба, за да предложите промоционални отстъпки с ограничено време',
        'enable' => 'Активиране на функцията за светкавична разпродажба',
        'enable_helper' => 'Когато е активирано, можете да създавате и управлявате светкавични разпродажби със специални намалени цени за ограничен период от време.',
        'show_sale_count_left' => 'Показване на проследяване на инвентара',
        'show_sale_count_left_description' => 'Показване на лента за напредък с "X продадени от Y", за да създадете спешност и да насърчите бързите покупки по време на светкавични разпродажби.',
    ],
    'payment_method_cod_minimum_amount' => 'Минимална сума на поръчка - :currency (По избор)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Минимална сума на поръчка - :currency (По избор)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Показване на банкова информация на страницата за успешно плащане?',
    'invoice_templates' => 'Шаблони за фактури',

    'abandoned_cart' => [
        'name' => 'Giỏ hàng bị bỏ rơi',
        'description' => 'Khôi phục doanh số bị mất bằng cách gửi lời nhắc tự động cho khách hàng để lại sản phẩm trong giỏ',
        'panel_description' => 'Thiết lập lời nhắc tự động cho khách hàng bỏ rơi giỏ hàng',
        'how_it_works' => [
            'title' => 'Cách hoạt động',
            'step1_title' => 'Khách hàng thêm sản phẩm',
            'step1_description' => 'Khách hàng thêm sản phẩm vào giỏ hàng và cung cấp địa chỉ email.',
            'step2_title' => 'Giỏ hàng bị bỏ rơi',
            'step2_description' => 'Nếu không có giao dịch mua trong ngưỡng thời gian đã đặt, giỏ hàng được đánh dấu là bị bỏ rơi.',
            'step3_title' => 'Gửi email nhắc nhở',
            'step3_description' => 'Email nhắc nhở tự động được gửi để khuyến khích khách hàng hoàn tất việc mua hàng.',
            'step4_title' => 'Khôi phục doanh số',
            'step4_description' => 'Khách hàng quay lại hoàn tất đơn hàng và giỏ hàng được đánh dấu là đã khôi phục.',
        ],
        'form' => [
            'enable' => 'Bật theo dõi giỏ hàng bị bỏ rơi',
            'enable_helper' => 'Khi được bật, hệ thống sẽ theo dõi giỏ hàng bị bỏ rơi và cho phép bạn gửi email khôi phục cho khách hàng.',
            'timing_section' => 'Cài đặt thời gian',
            'email_section' => 'Cài đặt email nhắc nhở',
            'cleanup_section' => 'Dọn dẹp dữ liệu',
            'time_threshold' => 'Ngưỡng thời gian (giờ)',
            'time_threshold_helper' => 'Giỏ hàng được coi là bị bỏ rơi sau số giờ không hoạt động này. Khuyến nghị: 1-24 giờ.',
            'send_email' => 'Gửi email khôi phục',
            'send_email_helper' => 'Tự động gửi email khôi phục cho khách hàng có giỏ hàng bị bỏ rơi.',
            'max_reminders' => 'Số lượng email nhắc nhở',
            'max_reminders_helper' => 'Số lượng email nhắc nhở gửi cho mỗi giỏ hàng bị bỏ rơi. Mỗi email có thể được tùy chỉnh trong Mẫu Email.',
            'email_delay' => 'Gửi sau (giờ)',
            'email_discount' => 'Giảm giá (%)',
            'email_1_title' => 'Email #1 - Nhắc nhở thân thiện',
            'email_1_description' => 'Lời nhắc nhẹ nhàng đầu tiên để khuyến khích khách hàng quay lại.',
            'email_1_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email đầu tiên. Khuyến nghị: 1-2 giờ.',
            'email_2_title' => 'Email #2 - Kèm ưu đãi',
            'email_2_description' => 'Lời nhắc thứ hai với ưu đãi giảm giá để thúc đẩy mua hàng.',
            'email_2_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email thứ hai. Khuyến nghị: 24 giờ.',
            'email_2_discount_helper' => 'Phần trăm giảm giá để cung cấp trong email này. Đặt 0 nếu không giảm giá.',
            'email_3_title' => 'Email #3 - Cơ hội cuối',
            'email_3_description' => 'Lời nhắc cuối cùng với tính cấp bách và ưu đãi tốt nhất để chốt đơn.',
            'email_3_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email cuối cùng. Khuyến nghị: 72 giờ.',
            'email_3_discount_helper' => 'Phần trăm giảm giá cuối cùng. Thường cao hơn email #2.',
            'cleanup_days' => 'Dọn dẹp sau (ngày)',
            'cleanup_days_helper' => 'Tự động xóa bản ghi giỏ hàng bị bỏ rơi cũ hơn số ngày này.',
            'cronjob_not_setup' => '<strong>Cronjob chưa được cấu hình!</strong> Nhắc nhở giỏ hàng bị bỏ rơi yêu cầu cronjob được cấu hình đúng để hoạt động. <a href=":url">Thiết lập cronjob ngay</a>.',
            'cronjob_not_running' => '<strong>Cronjob không chạy!</strong> Cronjob dường như đã dừng. Vui lòng kiểm tra cấu hình máy chủ của bạn. <a href=":url">Xem trạng thái cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob đang chạy đúng!</strong> Hoạt động cuối: :time. Nhắc nhở giỏ hàng bị bỏ rơi của bạn sẽ được xử lý tự động.',
            'email_setup_warning' => '<strong>Quan trọng:</strong> Đảm bảo cài đặt email của bạn được cấu hình đúng trong <a href=":url">Cài đặt → Email</a>. Gửi email test để xác minh mọi thứ hoạt động trước khi bật tính năng này.',
        ],
    ],
];
