<?php

return [
    'name' => 'المنتجات',
    'description' => 'إدارة المنتجات المادية والرقمية مع المخزون والتسعير والتنوعات',
    'create' => 'منتج جديد',
    'create_product_type' => [
        'physical' => 'منتج مادي جديد',
        'digital' => 'منتج رقمي جديد',
    ],
    'edit' => 'تعديل المنتج - :name',
    'form' => [
        'name' => 'الاسم',
        'name_placeholder' => 'اسم المنتج (بحد أقصى 120 حرفاً)',
        'description' => 'الوصف',
        'description_placeholder' => 'وصف قصير للمنتج (بحد أقصى 400 حرف)',
        'categories' => 'الفئات',
        'content' => 'المحتوى',
        'price' => 'السعر',
        'currency' => 'العملة',
        'currency_for_variations_hint' => 'سيتم تطبيق هذه العملة على جميع تنوعات هذا المنتج.',
        'quantity' => 'الكمية',
        'brand' => 'العلامة التجارية',
        'width' => 'العرض',
        'height' => 'الارتفاع',
        'weight' => 'الوزن',
        'date' => [
            'start' => 'من تاريخ',
            'end' => 'إلى تاريخ',
        ],
        'image' => 'الصور',
        'collections' => 'مجموعات المنتجات',
        'labels' => 'التسميات',
        'price_sale' => 'سعر البيع',
        'product_type' => [
            'title' => 'نوع المنتج',
        ],
        'product' => 'المنتج',
        'total' => 'المجموع',
        'sub_total' => 'المجموع الفرعي',
        'shipping_fee' => 'رسوم الشحن',
        'discount' => 'الخصم',
        'options' => 'الخيارات',
        'shipping' => [
            'height' => 'الارتفاع',
            'length' => 'الطول',
            'title' => 'الشحن',
            'weight' => 'الوزن',
            'wide' => 'العرض',
        ],
        'barcode' => 'الباركود (ISBN, UPC, GTIN، إلخ.) ',
        'barcode_placeholder' => 'أدخل الباركود',
        'cost_per_item' => 'التكلفة لكل عنصر',
        'cost_per_item_placeholder' => 'أدخل التكلفة لكل عنصر',
        'cost_per_item_helper' => 'لن يرى العملاء هذا السعر.',
        'price_includes_tax' => 'السعر يشمل الضريبة',
        'price_includes_tax_helper' => 'ضع علامة إذا كان السعر المدخل يشمل الضرائب بالفعل. سيقوم النظام بحساب السعر الأساسي عن طريق إزالة مبلغ الضريبة.',
        'stock' => [
            'allow_order_when_out' => 'السماح للعميل بالشراء عندما يكون المنتج غير متوفر',
            'in_stock' => 'متوفر',
            'out_stock' => 'غير متوفر',
            'title' => 'حالة المخزون',
        ],
        'storehouse' => [
            'no_storehouse' => 'بدون إدارة المستودع',
            'storehouse' => 'مع إدارة المستودع',
            'title' => 'المستودع',
            'quantity' => 'الكمية',
        ],
        'tax' => 'الضريبة',
        'taxes' => 'الضرائب',
        'taxes_helper' => 'معدل الضريبة الافتراضي مكون في <a href=":url">الإعدادات -> الضريبة</a>. إذا لم يتم تحديد ضريبة محددة لهذا المنتج، سيتم تطبيق المعدل الافتراضي. لتعطيل الضريبة لهذا المنتج، قم بإزالة معدل الضريبة الافتراضي من إعدادات الضريبة.',
        'is_default' => 'افتراضي',
        'action' => 'الإجراء',
        'restock_quantity' => 'كمية إعادة التخزين',
        'remain' => 'المتبقي',
        'choose_discount_period' => 'اختر فترة الخصم',
        'cancel' => 'إلغاء',
        'no_results' => 'لا توجد نتائج!',
        'value' => 'القيمة',
        'attribute_name' => 'اسم السمة',
        'add_more_attribute' => 'إضافة المزيد من السمات',
        'continue' => 'متابعة',
        'add_new_attributes' => 'إضافة سمات جديدة',
        'add_new_attributes_description' => 'إضافة سمات جديدة تساعد المنتج على امتلاك العديد من الخيارات، مثل الحجم أو اللون.',
        'create_product_variations' => ':link لإنشاء تنوعات المنتج!',
        'tags' => 'الوسوم',
        'write_some_tags' => 'اكتب بعض الوسوم',
        'variation_existed' => 'هذا التنوع موجود بالفعل.',
        'no_attributes_selected' => 'لم يتم تحديد أي سمات!',
        'added_variation_success' => 'تمت إضافة التنوع بنجاح!',
        'updated_variation_success' => 'تم تحديث التنوع بنجاح!',
        'created_all_variation_success' => 'تم إنشاء جميع التنوعات بنجاح!',
        'updated_product_attributes_success' => 'تم تحديث سمات المنتج بنجاح!',
        'stock_status' => 'حالة المخزون',
        'auto_generate_sku' => 'توليد SKU تلقائياً؟',
        'featured_image' => 'الصورة المميزة (اختياري)',
        'product_id' => 'معرف المنتج',
        'price_sale_percent_helper' => 'خصم :percent من السعر الأصلي.',
        'minimum_order_quantity' => 'الحد الأدنى لكمية الطلب',
        'minimum_order_quantity_helper' => 'الحد الأدنى من الكمية لتقديم طلب، إذا كانت القيمة 0، لا يوجد حد.',
        'maximum_order_quantity' => 'الحد الأقصى لكمية الطلب',
        'maximum_order_quantity_helper' => 'الحد الأقصى للكمية لتقديم طلب، إذا كانت القيمة 0، لا يوجد حد.',
        'video' => 'الفيديو',
        'video_file' => 'الملف',
        'video_url' => 'أو رابط الفيديو الخارجي',
        'video_url_help' => 'أدخل رابط فيديو YouTube أو Vimeo',
        'enter_video_url' => 'أدخل رابط الفيديو',
        'video_thumbnail' => 'صورة مصغرة للفيديو',
        'video_thumbnail_help' => 'اختر صورة مصغرة للفيديو. إذا لم يتم تحديدها، سيتم الحصول عليها تلقائياً من رابط الفيديو إذا كان متاحاً.',
        'barcode_existed' => 'هذا الباركود مستخدم من قبل منتج آخر. الرجاء إدخال باركود آخر.',
        'barcode_helper' => 'يجب أن يكون فريداً لكل منتج.',
        'is_new_until' => 'جديد حتى',
        'is_new_until_helper' => 'حدد تاريخاً يتم حتى وصوله وضع علامة على هذا المنتج بأنه "جديد". اتركه فارغاً لعدم وضع علامة جديد بناءً على التاريخ.',
    ],
    'price' => 'السعر',
    'quantity' => 'الكمية',
    'type' => 'النوع',
    'image' => 'الصورة المصغرة',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU التنوع',
    'brand' => 'العلامة التجارية',
    'cannot_delete' => 'تعذر حذف المنتج',
    'product_deleted' => 'تم حذف المنتج',
    'product' => 'المنتج',
    'product_collections' => 'مجموعات المنتجات',
    'products' => 'المنتجات',
    'total_products_found' => 'تم العثور على :total منتج',
    'total_product_found' => 'تم العثور على :total منتج',
    'menu' => 'المنتجات',
    'control' => [
        'button_add_image' => 'إضافة صورة',
    ],
    'price_sale' => 'سعر البيع',
    'price_group_title' => 'إدارة سعر المنتج',
    'store_house_group_title' => 'إدارة المستودع',
    'shipping_group_title' => 'إدارة الشحن',
    'overview' => 'نظرة عامة',
    'attributes' => 'السمات',
    'product_has_variations' => 'المنتج لديه تنوعات',
    'manage_products' => 'إدارة المنتجات',
    'add_new_product' => 'إضافة منتج جديد',
    'start_by_adding_new_product' => 'ابدأ بإضافة منتجات جديدة.',
    'edit_this_product' => 'تعديل هذا المنتج',
    'delete' => 'حذف',
    'related_products' => 'المنتجات ذات الصلة',
    'cross_selling_products' => 'منتجات البيع المتقاطع',
    'up_selling_products' => 'منتجات البيع الإضافي',
    'grouped_products' => 'المنتجات المجمعة',
    'search_products' => 'البحث عن المنتجات',
    'selected_products' => 'المنتجات المحددة',
    'edit_variation_item' => 'تعديل',
    'variations_box_description' => 'انقر على "تعديل السمة" لإضافة/إزالة سمات التنوع أو انقر على "إضافة تنوع جديد" لإضافة تنوع.',
    'save_changes' => 'حفظ التغييرات',
    'continue' => 'متابعة',
    'edit_attribute' => 'تعديل السمة',
    'select_attribute' => 'اختر السمة',
    'add_new_variation' => 'إضافة تنوع جديد',
    'edit_variation' => 'تعديل التنوع',
    'generate_variations' => 'توليد التنوعات',
    'generate_variations_confirmation' => 'هل أنت متأكد من أنك تريد توليد تنوعات لهذا المنتج؟',
    'delete_variation' => 'حذف التنوع؟',
    'delete_variation_confirmation' => 'هل أنت متأكد من أنك تريد حذف هذا التنوع؟ لا يمكن التراجع عن هذا الإجراء.',
    'delete_variations_confirmation' => 'هل أنت متأكد من أنك تريد حذف هذه التنوعات؟ لا يمكن التراجع عن هذا الإجراء.',
    'product_create_validate_name_required' => 'الرجاء إدخال اسم المنتج',
    'product_create_validate_sale_price_max' => 'يجب أن يكون الخصم أقل من السعر الأصلي',
    'product_create_validate_cost_per_item_max' => 'يجب أن تكون التكلفة لكل عنصر أقل من السعر الأصلي',
    'product_create_validate_sale_price_required_if' => 'يجب إدخال خصم عندما تريد جدولة عرض ترويجي',
    'product_create_validate_end_date_after' => 'يجب أن يكون تاريخ الانتهاء بعد تاريخ البداية',
    'product_create_validate_start_date_required_if' => 'لا يمكن ترك تاريخ بداية الخصم فارغاً عندما يتم تحديد الجدولة',
    'product_create_validate_sale_price' => 'لا يمكن ترك الخصومات فارغة عندما يتم تحديد الجدولة',
    'stock_statuses' => [
        'in_stock' => 'متوفر',
        'out_of_stock' => 'غير متوفر',
        'on_backorder' => 'طلب مسبق',
    ],
    'stock_status' => 'حالة المخزون',
    'processing' => 'جاري المعالجة...',
    'delete_selected_variations' => 'حذف التنوعات المحددة',
    'delete_variations' => 'حذف التنوعات',
    'category' => 'الفئة',
    'categories' => 'الفئات',
    'tags' => 'الوسوم',
    'product_price_flash_sale_warning' => 'هذا المنتج في تخفيض سريع <strong>:name</strong> لذا سعره <strong>:price</strong>.',
    'product_price_discount_warning' => 'هذا المنتج في خصم <strong>:name</strong> لذا سعره <strong>:price</strong>.',
    'product_image' => 'صورة المنتج',
    'product_name' => 'اسم المنتج',
    'product_link' => 'رابط المنتج',
    'types' => [
        'physical' => 'مادي',
        'digital' => 'رقمي',
    ],
    'digital_attachments' => [
        'title' => 'المرفقات الرقمية',
        'add' => 'إضافة مرفق',
        'file_name' => 'اسم الملف',
        'file_size' => 'حجم الملف',
        'unsaved' => 'غير محفوظ',
        'add_external_link' => 'إضافة رابط خارجي',
        'enter_file_name' => 'أدخل اسم الملف',
        'enter_external_link_download' => 'أدخل رابط التنزيل الخارجي',
        'enter_file_size' => 'أدخل حجم الملف',
        'external_link_download' => 'رابط التنزيل الخارجي',
        'generate_license_code_after_purchasing_product' => 'تفعيل تعيين كود الترخيص لهذا المنتج',
        'notify_attachment_updated' => 'إرسال بريد إلكتروني للعميل عند تحديث المرفق',
        'no_attachments' => 'لا توجد مرفقات بعد. انقر على الأزرار أعلاه لإضافة ملفات.',
    ],
    'license_codes' => [
        'title' => 'أكواد الترخيص',
        'add' => 'إضافة كود ترخيص',
        'back' => 'العودة إلى المنتج',
        'edit' => 'تعديل كود الترخيص',
        'generate' => 'توليد الأكواد',
        'manage_codes' => 'إدارة أكواد الترخيص',
        'management' => 'إدارة أكواد الترخيص',
        'variation_breadcrumb' => 'التنوع: :name',
        'variation_label' => 'تنوع المنتج',
        'variation_specific_note' => 'أكواد الترخيص هذه خاصة بهذا التنوع من المنتج. سيحصل العملاء الذين يشترون هذا التنوع على أكواد من هذا المخزن.',
        'main_product_note' => 'هذا المنتج لديه تنوعات. يمكن أن يكون لكل تنوع أكواد ترخيص خاصة به، أو يمكن للعملاء الحصول على أكواد من مخزن المنتج الرئيسي إذا لم يكن للتنوع أكواد.',
        'code' => 'كود الترخيص',
        'codes' => 'أكواد الترخيص',
        'status' => 'الحالة',
        'assigned_at' => 'تم التعيين في',
        'status_available' => 'متاح',
        'status_used' => 'مستخدم',
        'statuses' => [
            'available' => 'متاح',
            'used' => 'مستخدم',
        ],
        'no_codes' => 'لم يتم العثور على أكواد ترخيص. أضف بعض الأكواد أو قم بتوليدها تلقائياً.',
        'no_codes_warning_title' => 'لا توجد أكواد ترخيص متاحة!',
        'no_codes_warning_message' => 'هذا المنتج مضبوط على "الاختيار من القائمة" لكن لا توجد أكواد ترخيص متاحة. سيحصل العملاء الذين يشترون هذا المنتج على أكواد مولدة تلقائياً بدلاً من ذلك. الرجاء إضافة أكواد ترخيص لضمان الوظيفة الصحيحة.',
        'no_codes_auto_generate' => 'هذا المنتج مضبوط على توليد أكواد الترخيص تلقائياً. لا حاجة لأكواد يدوية.',
        'used_code_no_actions' => 'كود مستخدم - لا توجد إجراءات متاحة',
        'created_successfully' => 'تم إنشاء كود الترخيص بنجاح!',
        'updated_successfully' => 'تم تحديث كود الترخيص بنجاح!',
        'deleted_successfully' => 'تم حذف كود الترخيص بنجاح!',
        'generated_successfully' => 'تم توليد :count أكواد ترخيص بنجاح!',
        'duplicates_skipped' => 'تم تخطي :count أكواد مكررة.',
        'generation_incomplete' => 'تحذير: تم توليد :generated فقط من أصل :requested الأكواد المطلوبة بسبب تعارضات التكرار.',
        'cannot_edit_used_code' => 'لا يمكن تعديل كود ترخيص مستخدم.',
        'cannot_delete_used_code' => 'لا يمكن حذف كود ترخيص مستخدم.',
        'show_all' => 'عرض الكل',
        'show_less' => 'عرض أقل',
        'more' => 'المزيد',
        'used_codes_hidden' => ':count كود ترخيص مستخدم مخفي. يمكنك عرض جميع الأكواد في صفحة إدارة أكواد الترخيص.',
        'low_stock_title' => 'مخزون أكواد الترخيص منخفض',
        'low_stock_message' => 'يتبقى :count أكواد ترخيص فقط. فكر في إضافة المزيد من الأكواد لتجنب نفادها.',
        'out_of_stock_title' => 'نفدت أكواد الترخيص!',
        'out_of_stock_message' => 'لا توجد أكواد ترخيص متاحة. سيحصل العملاء على أكواد مولدة تلقائياً حتى تضيف المزيد.',
        'type' => [
            'title' => 'طريقة تعيين كود الترخيص',
            'auto_generate' => 'توليد تلقائي (يقوم النظام بتوليد الأكواد تلقائياً)',
            'pick_from_list' => 'الاختيار من القائمة (استخدام الأكواد المدخلة مسبقاً)',
            'description' => 'اختر كيفية تعيين أكواد الترخيص للعملاء عند شراء هذا المنتج.',
        ],
        'add_modal' => [
            'placeholder' => 'مثال، XXXX-XXXX-XXXX-XXXX',
            'help' => 'أدخل كود ترخيص فريد سيتم تعيينه للعميل عند الشراء.',
        ],
        'generate_modal' => [
            'title' => 'توليد أكواد الترخيص',
            'quantity' => 'الكمية',
            'format' => 'التنسيق',
            'custom_pattern' => 'نمط مخصص',
            'pattern_help' => 'استخدم # للأرقام، A للأحرف الكبيرة، a للأحرف الصغيرة',
            'generate' => 'توليد',
        ],
        'errors' => [
            'feature_not_enabled' => 'ميزة أكواد الترخيص غير مفعلة. الرجاء تفعيلها في إعدادات التجارة الإلكترونية -> المنتجات الرقمية.',
            'digital_products_not_enabled' => 'المنتجات الرقمية غير مفعلة. الرجاء تفعيل دعم المنتجات الرقمية أولاً.',
            'product_not_found' => 'المنتج غير موجود.',
            'not_digital_product' => 'أكواد الترخيص متاحة فقط للمنتجات الرقمية. هذا المنتج مضبوط كمنتج مادي.',
            'license_codes_not_enabled_for_product' => 'إدارة أكواد الترخيص غير مفعلة لهذا المنتج. الرجاء تفعيل "توليد كود الترخيص بعد شراء المنتج" في إعدادات المنتج.',
            'cannot_add_codes_auto_generate' => 'لا يمكن إضافة أكواد ترخيص يدوياً للمنتجات المضبوطة على التوليد التلقائي. قم بتغيير نوع كود الترخيص إلى "الاختيار من القائمة" أولاً.',
            'cannot_generate_codes_auto_generate' => 'لا يمكن توليد أكواد ترخيص يدوياً للمنتجات المضبوطة على التوليد التلقائي. قم بتغيير نوع كود الترخيص إلى "الاختيار من القائمة" أولاً.',
        ],
        'bulk_delete' => [
            'button' => 'حذف المحدد',
            'selected' => 'محدد',
            'confirm' => 'هل أنت متأكد من أنك تريد حذف أكواد الترخيص المحددة؟',
            'deleted_successfully' => 'تم حذف :count كود ترخيص بنجاح.',
            'skipped_used_codes' => 'تم تخطي :count أكواد مستخدمة.',
            'no_deletable_codes' => 'لم يتم العثور على أكواد ترخيص متاحة للحذف. لا يمكن حذف الأكواد المستخدمة.',
        ],
        'import' => [
            'name' => 'استيراد أكواد ترخيص المنتج',
            'description' => 'استيراد أكواد الترخيص للمنتجات الرقمية من ملف CSV/Excel.',
            'button' => 'استيراد',
            'columns' => [
                'product_id' => 'معرف المنتج أو SKU',
                'license_code' => 'كود الترخيص',
            ],
        ],
        'copied' => 'تم نسخ كود الترخيص إلى الحافظة!',
    ],
    'this_action_will_reload_page' => 'سيقوم هذا الإجراء بإعادة تحميل الصفحة لتحديث البيانات!',
    'select' => 'اختر',
    'clear_filters' => 'مسح الفلاتر',
    'set_this_variant_as_default' => 'تعيين هذا المتغير كافتراضي',
    'download' => 'تنزيل',
    'external_link_downloads' => 'الروابط الخارجية',
    'download_available_when_completed' => 'ستكون روابط التنزيل متاحة عند اكتمال الطلب.',
    'cross_sell_price_type' => [
        'title' => 'نوع السعر',
        'fixed' => 'ثابت',
        'percent' => 'نسبة مئوية',
    ],
    'cross_sell_help' => [
        'price' => '* حقل السعر',
        'price_description' => 'أدخل المبلغ الذي تريد تخفيضه من السعر الأصلي. مثال: إذا كان السعر الأصلي 100 دولار، أدخل 20 لتقليل السعر إلى 80 دولار.',
        'type' => '* حقل النوع',
        'type_description' => 'اختر نوع الخصم: ثابت (تخفيض مبلغ محدد) أو نسبة مئوية (تخفيض بنسبة مئوية).',
    ],
    'up_sell_price_type' => [
        'title' => 'نوع السعر',
        'fixed' => 'ثابت',
        'percent' => 'نسبة مئوية',
    ],
    'up_sell_help' => [
        'price' => '* حقل السعر',
        'price_description' => 'أدخل المبلغ الذي تريد تخفيضه من السعر الأصلي. مثال: إذا كان السعر الأصلي 100 دولار، أدخل 20 لتقليل السعر إلى 80 دولار.',
        'type' => '* حقل النوع',
        'type_description' => 'اختر نوع الخصم: ثابت (تخفيض مبلغ محدد) أو نسبة مئوية (تخفيض بنسبة مئوية).',
    ],
    'up_sale' => [
        'title' => 'اشترِ معاً ووفر',
        'description' => 'احصل على خصومات خاصة عند شراء هذه العناصر معاً',
        'unlock_discount' => 'أضف :product إلى السلة لفتح خصم الحزمة',
        'multiple_options' => 'خيارات متعددة',
        'multiple_options_available' => 'خيارات متعددة متاحة',
        'select' => 'اختر',
        'selected_items_total' => 'إجمالي العناصر المحددة:',
        'add_selected_to_cart' => 'إضافة المحدد إلى السلة',
        'bundle_discount_with' => 'خصم الحزمة مع :product',
        'bundle_with' => 'حزمة مع :product',
    ],
    'cross_sale' => [
        'title' => 'المشتراة معاً بشكل متكرر',
        'description' => 'العملاء الذين شاهدوا هذا العنصر اشتروا أيضاً',
    ],
    'apply_for_all_variations' => 'تطبيق على جميع التنوعات',
    'export' => [
        'description' => 'تصدير بيانات المنتج إلى ملفات CSV أو Excel.',
        'total_items' => 'إجمالي العناصر',
        'total_products' => 'إجمالي المنتجات',
        'total_variations' => 'إجمالي التنوعات',
        'advanced_options' => 'خيارات متقدمة',
        'use_chunked_export' => 'استخدام التصدير المجزأ',
        'use_chunked_export_helper' => 'معالجة البيانات في أجزاء للتعامل مع مجموعات البيانات الكبيرة بكفاءة',
        'include_variations' => 'تضمين تنوعات المنتج',
        'include_variations_helper' => 'تصدير تنوعات المنتج مع المنتجات الرئيسية',
        'optimize_memory' => 'تحسين استخدام الذاكرة',
        'optimize_memory_helper' => 'تفعيل تحسين الذاكرة للتصديرات الكبيرة جداً',
        'chunk_size' => 'حجم الجزء',
        'chunk_size_helper' => 'عدد المنتجات للمعالجة في كل مرة (50-5000)',
        'use_streaming' => 'استخدام التصدير المتدفق',
        'use_streaming_helper' => 'تفعيل البث لمجموعات البيانات الكبيرة جداً (يتم تفعيله تلقائياً لأكثر من 10,000 عنصر)',
        'large_dataset_warning_title' => 'تم اكتشاف كتالوج منتجات كبير',
        'large_dataset_warning_message' => 'يحتوي الكتالوج الخاص بك على :count عنصر. بسبب الحجم الكبير، تم تحسين بعض خيارات التصدير للحصول على أفضل أداء.',
        'large_dataset_specific_message' => 'بالنسبة لمنتجاتك البالغة :count، استخدم تنسيق CSV مع تفعيل البث. يمكن للنظام الآن التعامل مع كتالوج منتجاتك الكبير بكفاءة دون مهلة أو مشاكل في الذاكرة.',
        'format_label' => 'التنسيق',
        'csv_recommended' => 'CSV (مطلوب)',
        'chunk_label' => 'المعالجة',
        'chunk_recommended' => '300 منتج/دفعة',
        'time_label' => 'الوقت المقدر',
        'time_estimate' => '1-3 دقائق',
        'pro_tip' => 'نصيحة احترافية:',
        'pro_tip_message' => 'سيستمر التصدير في العمل حتى لو أظهر متصفحك مؤشر تحميل. بمجرد البدء، سيبدأ التنزيل تلقائياً.',
        'large_dataset_tip_1' => 'تم تعطيل تنسيق Excel - استخدم تنسيق CSV للحصول على تصديرات أسرع وأكثر موثوقية',
        'large_dataset_tip_2' => 'تم تفعيل وضع البث تلقائياً لمنع المهلة',
        'large_dataset_tip_3' => 'قد تستغرق عملية التصدير 1-3 دقائق حسب الخادم الخاص بك',
        'large_dataset_recommendation' => 'موصى به: استخدام تنسيق CSV مع حجم جزء 200-500 للحصول على أداء أمثل.',
        'excel_disabled_for_large_export' => 'تنسيق Excel غير متاح للكتالوجات التي تزيد عن 10,000 عنصر',
        'streaming_auto_enabled' => 'تم تفعيل وضع البث تلقائياً للحصول على أداء أمثل مع مجموعات البيانات الكبيرة.',
        'streaming_enabled_title' => 'محسّن للتصدير الكبير',
        'streaming_enabled_message' => 'وضع البث نشط لضمان تصدير سلس دون مشاكل في الذاكرة.',
        'use_multi_file' => 'استخدام التصدير متعدد الملفات',
        'use_multi_file_helper' => 'تقسيم التصدير إلى ملفات متعددة معبأة في ZIP لمجموعات البيانات الكبيرة جداً',
        'multi_file_enabled_title' => 'تم تفعيل التصدير متعدد الملفات',
        'multi_file_enabled_message' => 'سيتم تقسيم التصدير الخاص بك إلى :count ملفات معبأة في ZIP للحصول على أداء أمثل.',
        'records_per_file' => 'السجلات لكل ملف',
        'records_per_file_helper' => 'عدد السجلات في كل ملف عند استخدام التصدير متعدد الملفات',
        'estimated_files' => 'الملفات المقدرة',
        'recommended_range' => 'النطاق الموصى به',
        'range_large_export' => '200-500 عنصر',
        'range_medium_export' => '300-800 عنصر',
        'range_small_export' => '500-1000 عنصر',
        'export_progress' => 'تقدم التصدير',
        'preparing_export' => 'جاري تحضير التصدير...',
        'items_processed' => 'تمت معالجة :count عنصر',
        'estimated_time_calculating' => 'الوقت المقدر: جاري الحساب...',
        'medium_dataset_detected' => 'تم اكتشاف مجموعة بيانات متوسطة',
        'medium_dataset_message' => 'أنت تصدر :count منتج. فكر في استخدام التصدير المجزأ للحصول على أداء أفضل.',
        'optimal_range' => 'النطاق الأمثل',
        'too_small_slow' => 'صغير جداً - قد يكون بطيئاً',
        'too_large_timeouts' => 'كبير جداً - قد يسبب مهلة',
        'excel_disabled_warning' => 'تنسيق Excel معطل للتصديرات الكبيرة (:count عنصر)',
        'starting_export' => 'بدء التصدير...',
        'processing_data' => 'معالجة البيانات...',
        'finalizing_export' => 'إنهاء التصدير...',
        'items_processed_suffix' => 'عنصر تمت معالجته',
        'estimated_time_prefix' => 'الوقت المقدر:',
        'seconds_remaining' => 'ثانية متبقية',
        'export_completed' => 'اكتمل التصدير!',
        'download_starting' => 'بدء التنزيل...',
    ],
    'import' => [
        'description' => 'استيراد بيانات المنتج من ملفات CSV أو Excel.',
        'rules' => [
            'in' => 'يجب أن يكون :attribute أحد القيم المحددة: :values.',
            'required_string_max' => ':attribute مطلوب ويجب أن يكون نصاً بحد أقصى :max حرف.',
            'nullable_string' => 'يمكن ترك :attribute فارغاً أو يجب أن يكون نصاً إذا تم توفيره.',
            'nullable_string_max' => 'يمكن ترك :attribute فارغاً أو يجب أن يكون نصاً بحد أقصى :max حرف إذا تم توفيره',
            'nullable_bool' => 'يمكن ترك :attribute فارغاً أو يجب أن يكون قيمة منطقية إذا تم توفيره.',
            'nullable_numeric_min' => 'يمكن ترك :attribute فارغاً أو يجب أن يكون رقماً غير سالب إذا تم توفيره.',
            'nullable_numeric_min_max' => 'يمكن ترك :attribute فارغاً أو يجب أن يكون رقماً بين :min و :max إذا تم توفيره.',
            'nullable_array' => 'يمكن ترك :attribute فارغاً أو يجب توفيره كمصفوفة إذا تم تحديده.',
            'nullable_date_required_if' => 'يمكن ترك :attribute فارغاً أو يجب أن يكون تاريخاً صالحاً إذا تم توفيره، مطلوب إذا تم تحديد :required.',
            'nullable_date_after' => 'يمكن ترك :attribute فارغاً أو يجب أن يكون تاريخاً صالحاً بعد :after إذا تم توفيره.',
        ],
        'updated_message' => 'تم تحديث :count منتج بنجاح!',
    ],
    'import_products_intro' => 'أو استيراد المنتجات من CSV/Excel',
    'select_attributes' => 'اختر السمات لإنشاء التنوعات:',
    'all' => 'الكل',
    'copy' => 'نسخ',
    'product_translations' => 'ترجمات المنتج',
    'view' => 'عرض المنتج - :name',
    'product_information' => 'معلومات المنتج',
    'total_views' => 'إجمالي المشاهدات',
    'total_orders' => 'الطلبات المكتملة',
    'total_sold' => 'إجمالي المبيعات',
    'total_revenue' => 'إجمالي الإيرادات',
    'pending_orders' => 'الطلبات المعلقة',
    'pending_revenue' => 'الإيرادات المعلقة',
    'conversion_rate' => 'معدل التحويل',
    'total_reviews' => 'إجمالي التقييمات',
    'average_rating' => 'متوسط التقييم',
    'views_by_date' => 'المشاهدات حسب التاريخ (آخر 30 يوم)',
    'recent_orders' => 'الطلبات الأخيرة',
    'no_views_data' => 'لا توجد بيانات مشاهدات متاحة لآخر 30 يوم.',
    'no_orders' => 'لا توجد طلبات بعد.',
    'date' => 'التاريخ',
    'views' => 'المشاهدات',
    'total' => 'المجموع',
    'view_on_frontend' => 'عرض في الواجهة الأمامية',
    'select_attribute' => 'اختر :name',
    'all_categories' => 'جميع الفئات',
    'brands' => 'العلامات التجارية',
    'browse_products' => 'تصفح المنتجات',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'اختر المنتجات للإرجاع',
    'show_only_discounted_products' => 'عرض المنتجات المخفضة فقط',
    'specification' => 'المواصفات',
    'download_product_with_external_links' => 'تنزيل المنتج ":name" مع الروابط الخارجية',
    'number_product_available_singular' => ':number منتج متاح',
    'number_products_available_plural' => ':number منتج متاح',
    'cart' => [
        'added_to_cart_success' => 'تمت إضافة :product إلى سلة التسوق.',
        'removed_from_cart_success' => 'تمت إزالة :product من سلة التسوق.',
        'updated_cart_success' => 'تم تحديث سلة التسوق الخاصة بك.',
        'item_not_found' => 'هذا العنصر لم يعد في سلة التسوق الخاصة بك.',
        'out_of_stock' => 'عذراً، :product غير متوفر حالياً.',
        'max_quantity' => 'يمكنك إضافة :max عنصر كحد أقصى.',
        'max_quantity_detail' => 'عذراً، يمكنك طلب :quantity وحدة فقط من :product كحد أقصى في المرة الواحدة.',
        'select_options' => 'الرجاء تحديد خيارات المنتج قبل الإضافة إلى السلة.',
        'product_out_of_stock' => 'عذراً، هذا المنتج غير متوفر حالياً.',
        'product_not_exists' => 'هذا المنتج غير متوفر أو لم يعد موجوداً.',
        'not_enough_quantity' => 'بعض المنتجات ليس لديها مخزون كافٍ للتحديث.',
        'empty_success' => 'تم إفراغ سلة التسوق الخاصة بك.',
        'bundle_item_already_in_cart' => 'عنصر الحزمة هذا موجود بالفعل في سلة التسوق الخاصة بك. يُسمح بعنصر واحد فقط لكل خصم حزمة.',
    ],
    'wishlist' => [
        'added_success' => 'تمت إضافة :product إلى قائمة الرغبات الخاصة بك.',
        'removed_success' => 'تمت إزالة :product من قائمة الرغبات الخاصة بك.',
        'product_not_found' => 'تعذر العثور على هذا المنتج.',
        'product_not_in_wishlist' => 'هذا المنتج ليس في قائمة الرغبات الخاصة بك.',
        'product_not_available' => 'هذا المنتج غير متاح.',
    ],
    'compare' => [
        'added_success' => 'تمت إضافة :product إلى قائمة المقارنة الخاصة بك.',
        'removed_success' => 'تمت إزالة :product من قائمة المقارنة الخاصة بك.',
        'product_not_found' => 'تعذر العثور على هذا المنتج.',
        'product_not_in_compare' => 'هذا المنتج ليس في قائمة المقارنة الخاصة بك.',
        'already_in_list' => ':product موجود بالفعل في قائمة المقارنة الخاصة بك.',
    ],
];
