<?php

return [
    'name' => 'Themes',
    'theme' => 'Theme',
    'author' => 'Author',
    'version' => 'Version',
    'active_success' => 'Activate theme :name successfully!',
    'active' => 'Active',
    'activated' => 'Activated',
    'appearance' => 'Appearance',
    'theme_options' => 'Theme Options',
    'save_changes' => 'Save Changes',
    'custom_css' => 'Custom CSS',
    'custom_js' => 'Custom JS',
    'custom_header_js' => 'Header JS',
    'custom_header_js_placeholder' => 'JS in header of page, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;',
    'custom_body_js' => 'Body JS',
    'custom_body_js_placeholder' => 'JS in body of page, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;',
    'custom_footer_js' => 'Footer JS',
    'custom_footer_js_placeholder' => 'JS in footer of page, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;',
    'custom_html' => 'Custom HTML',
    'custom_header_html' => 'Header HTML',
    'custom_header_html_placeholder' => 'HTML in header of page, no special tags: script, style, iframe...',
    'custom_body_html' => 'Body HTML',
    'custom_body_html_placeholder' => 'HTML in body of page, no special tags: script, style, iframe...',
    'custom_footer_html' => 'Footer HTML',
    'custom_footer_html_placeholder' => 'HTML in footer of page, no special tags: script, style, iframe...',
    'remove_theme_success' => 'Remove theme successfully!',
    'theme_is_not_existed' => 'This theme is not existed!',
    'remove' => 'Remove',
    'remove_theme' => 'Remove theme',
    'remove_theme_confirm_message' => 'Do you really want to remove this theme?',
    'remove_theme_confirm_yes' => 'Yes, remove it!',
    'total_themes' => 'Total themes',
    'add_new' => 'Add new',
    'no_themes' => 'No themes found',
    'no_themes_description' => 'There are no themes installed in your system.',
    'theme_activated_already' => 'Theme ":name" is activated already!',
    'theme_inherit_not_found' => 'The inherit theme ":name" is not found!',
    'missing_json_file' => 'Missing file theme.json!',
    'theme_invalid' => 'Theme is valid!',
    'published_assets_success' => 'Publish assets for :themes successfully!',
    'cannot_remove_theme' => 'Cannot remove activated theme, please activate another theme before removing ":name"!',
    'cannot_remove_inherit_theme' => 'Cannot remove theme ":name" because it is inherited by current theme!',
    'theme_deleted' => 'Theme ":name" has been destroyed.',
    'removed_assets' => 'Remove assets of a theme :name successfully!',
    'go_to_dashboard' => 'Go to dashboard',
    'theme_option_general' => 'General',
    'theme_option_general_description' => 'General settings',
    'theme_option_seo_open_graph_image' => 'SEO default Open Graph image',
    'theme_option_seo_open_graph_image_helper' => 'Default Open Graph image when sharing on social networks. If not set, it will get from theme options logo in Admin -> Appearance -> Theme Options -> Logo. That image type must be PNG, JPG or GIF, do not use modern image type such as WebP or Avif. The image dimensions must be at least 200x200 pixels.',
    'theme_option_seo_index' => 'SEO Index',
    'theme_option_seo_index_helper' => 'When "No Index" is selected, search engines are blocked from indexing the site, preventing it from appearing in search engine results.',
    'seo_index_options' => [
        'index' => 'Index',
        'no_index' => 'No Index',
    ],
    'theme_option_logo' => 'Logo',
    'theme_option_favicon' => 'Favicon',
    'theme_option_favicon_type' => 'Favicon Type',
    'theme_option_breadcrumb' => 'Breadcrumb',
    'folder_is_not_writeable' => 'Cannot write files! Folder :name is not writable. Please chmod to make it writable!',
    'breadcrumb_enabled' => 'Enable breadcrumb?',
    'themes' => 'Themes',
    'child_of' => 'Child of ":theme"',
    'typography' => 'Typography',
    'typography_font_family' => ':name Font',
    'typography_font_size' => ':name Font Size',
    'typography_font_size_helper' => 'Font size in pixels. The default value is :default.',
    'robots_txt_editor' => 'Robots.txt Editor',
    'robots_txt_content' => 'Robots.txt Content',
    'robots_txt_not_writable' => 'Cannot write robots.txt file! Please chmod to make it writable! (Your robots.txt file is located at :path)',
    'robots_txt_content_helper' => 'After saved, you can check your robots.txt here: :link',
    'robots_txt_sitemap_suggestion' => '<strong>Tip:</strong> You can link to your sitemap in your robots.txt content by adding: <code>Sitemap: :sitemap_url</code>',
    'robots_txt_file' => 'Upload robots.txt file',
    'robots_txt_file_helper' => 'If you want to upload a robots.txt file, please select it here.',
    'email_template_logo_helper_text' => 'If don\'t set, it will get from theme options logo in Admin -> Appearance -> Theme Options -> Logo.',
    'settings' => [
        'website_tracking' => [
            'title' => 'Website Tracking',
            'description' => 'Choose your preferred analytics and tracking method. Only one option can be active at a time.',
            'google_tag_manager' => 'Google Tag Manager (Recommended)',
            'google_tag_manager_description' => 'Best for managing multiple tracking services (Google Analytics, Facebook Pixel, etc.) in one place. Provides a user-friendly interface without coding.',
            'google_tag_id' => 'Google Analytics Only',
            'google_tag_id_description' => 'Simple setup for basic Google Analytics tracking. Choose this if you only need Google Analytics and nothing else.',
            'google_tag_id_placeholder' => 'Example: G-123ABC4567',
            'custom_tracking' => 'Custom Tracking Code',
            'custom_tracking_description' => 'For advanced users who need to add custom tracking scripts (Matomo, Plausible, Fathom, etc.) or have specific requirements.',
            'gtm_container_id' => 'GTM Container ID',
            'gtm_container_id_placeholder' => 'GTM-XXXXXXX',
            'gtm_container_id_helper' => 'Enter your GTM Container ID (e.g., GTM-N7MK3KH2). Find this in the top right corner of your Google Tag Manager dashboard.',
            'google_tag_id_helper' => 'Enter your Google Analytics 4 Measurement ID. Find this in Google Analytics under Admin → Data Streams → Your Stream → Measurement ID.',
            'custom_tracking_instruction' => 'Add your tracking scripts following the standard two-part installation pattern used by most analytics services.',
            'custom_tracking_header_js' => 'Step 1: Header tracking script',
            'custom_tracking_header_js_helper' => 'Paste the tracking script that goes in the &lt;head&gt; section of your pages. Include the complete code with &lt;script&gt; tags.',
            'custom_tracking_body_html' => 'Step 2: Body tracking code (Optional)',
            'custom_tracking_body_html_helper' => 'Paste any noscript or additional code that goes after the opening &lt;body&gt; tag. Leave empty if not required.',
            'gtm_debug_mode' => 'Enable GTM Debug Mode',
            'gtm_debug_mode_helper' => 'Enable debug mode to log GTM events to browser console and troubleshoot tracking issues. Disable in production for better performance.',
            'setup_instructions' => 'Setup Instructions',
            'verification_title' => 'How to Verify Your Setup',
            'common_mistakes' => 'Common Mistakes:',
            'common_issues' => 'Common Issues:',
            'best_practices' => 'Best Practices:',
            'gtm' => [
                'create_account' => 'Create GTM Account:',
                'go_to' => 'Go to',
                'create_container' => 'and create a new container for your website',
                'find_container_id' => 'Find Container ID:',
                'copy_container_id' => 'After creating, copy the Container ID (format: GTM-XXXXXXX) from the top right corner',
                'paste_id_below' => 'Paste ID Below:',
                'enter_container_id' => 'Enter your Container ID in the field below and save',
                'configure_tags' => 'Configure Tags:',
                'add_analytics_tags' => 'Add your analytics tags (Google Analytics, Facebook Pixel, etc.) in the GTM dashboard',
                'publish_container' => 'Publish Container:',
                'click_submit' => 'Click "Submit" in GTM to publish your changes',
                'adding_ga4_title' => 'Adding GA4 Tracking with GTM',
                'adding_ga4_description' => 'After setting up your GTM container, add Google Analytics 4 tracking:',
                'ga4_step_1' => 'In GTM → click Tags → New → Tag Configuration',
                'ga4_step_2' => 'Choose Google Analytics: GA4 Configuration',
                'ga4_step_3' => 'Enter your GA4 Measurement ID (get this from Google Analytics → Admin → Data Streams → Web → Measurement ID)',
                'ga4_step_4' => 'Set Trigger → choose All Pages (so it fires on every page)',
                'ga4_step_5' => 'Save the tag and Publish your GTM container',
                'ga4_example' => 'Example:',
                'check_preview_mode' => 'Check GTM Preview Mode:',
                'enable_preview' => 'In GTM dashboard, click "Preview" to enable debugging',
                'verify_tag_assistant' => 'Verify Tag Assistant:',
                'install_tag_assistant_prefix' => 'Install',
                'google_tag_assistant' => 'Google Tag Assistant',
                'install_tag_assistant_suffix' => 'Chrome extension to verify tags are firing',
                'console_instructions' => 'Press F12, go to Console tab, look for GTM messages',
                'issue_tags_not_firing' => 'Tags Not Firing:',
                'issue_tags_not_firing_solution' => 'Make sure you published your container in GTM',
                'issue_wrong_container' => 'Wrong Container:',
                'issue_wrong_container_solution' => 'Verify you\'re using the correct Container ID for this domain',
            ],
            'ga' => [
                'create_property' => 'Create GA4 Property:',
                'go_to' => 'Go to',
                'google_analytics' => 'Google Analytics',
                'create_new_property' => 'and create a new GA4 property',
                'find_measurement_id' => 'Find Measurement ID:',
                'navigate_to_streams' => 'Navigate to Admin → Data Streams → Select your stream → Copy the Measurement ID (format: G-XXXXXXXXXX)',
                'paste_id_below' => 'Paste ID Below:',
                'enter_measurement_id' => 'Enter your Measurement ID in the field below and save',
                'verify_setup' => 'Verify Setup:',
                'check_realtime' => 'Check "Realtime" report in Google Analytics after saving',
                'mistake_property_id' => 'Using Property ID instead of Measurement ID',
                'mistake_ua_id' => 'Using old Universal Analytics ID (UA-XXXXX-X) - these are deprecated',
                'mistake_data_delay' => 'Not waiting 24-48 hours for data to appear in reports',
                'check_realtime_report' => 'Check Realtime Report:',
                'navigate_realtime' => 'Go to Google Analytics → Reports → Realtime → Overview',
                'wait_for_data' => 'Wait for Data:',
                'see_visit_seconds' => 'You should see your visit within 30 seconds',
                'console_network_instructions' => 'Press F12, Network tab, filter by "google-analytics" to see if requests are sent',
                'issue_no_data' => 'No Data Appearing:',
                'issue_no_data_solution' => 'Wait 24-48 hours for full reports (Realtime works immediately)',
                'issue_wrong_format' => 'Wrong ID Format:',
                'issue_wrong_format_solution' => 'Must be G-XXXXXXXXXX not UA-XXXXX-X',
                'issue_multiple_ids' => 'Multiple IDs:',
                'issue_multiple_ids_solution' => 'Only use one ID field - GA4 Measurement ID (starts with G-)',
            ],
            'custom' => [
                'popular_services' => 'Popular Analytics Services:',
                'matomo' => 'Matomo:',
                'matomo_instructions' => 'Copy the JavaScript tracking code from Settings → Tracking Code',
                'plausible' => 'Plausible:',
                'plausible_instructions' => 'Copy the script tag from Settings → General',
                'fathom' => 'Fathom:',
                'fathom_instructions' => 'Get your site code from Settings → Sites',
                'facebook_pixel' => 'Facebook Pixel:',
                'facebook_pixel_instructions' => 'Copy the base code from Events Manager',
                'hotjar' => 'Hotjar:',
                'hotjar_instructions' => 'Copy the tracking code from Settings → Sites & Organizations',
                'practice_two_part' => 'Most services provide a two-part installation: Header script + Optional body code',
                'practice_complete_code' => 'Always paste the complete code including &lt;script&gt; tags',
                'practice_test_incognito' => 'Test in incognito mode after saving to verify tracking works',
                'practice_check_console' => 'Use browser console (F12) to check for JavaScript errors',
                'console_instructions' => 'Press F12, go to Console tab, look for your tracking service messages',
                'verify_network' => 'Verify Network Requests:',
                'network_instructions' => 'In F12 Network tab, look for requests to your analytics provider',
                'check_dashboard' => 'Check Provider Dashboard:',
                'dashboard_instructions' => 'Most services have a realtime or debug view',
                'issue_js_errors' => 'JavaScript Errors:',
                'issue_js_errors_solution' => 'Check browser console for syntax errors in your code',
                'issue_missing_tags' => 'Missing Script Tags:',
                'issue_missing_tags_solution' => 'Ensure your code includes &lt;script&gt; and &lt;/script&gt; tags',
                'issue_incomplete_code' => 'Incomplete Code:',
                'issue_incomplete_code_solution' => 'Copy the entire tracking code from your provider, not just part of it',
                'issue_wrong_placement' => 'Wrong Placement:',
                'issue_wrong_placement_solution' => 'Header script goes in header field, body code goes in body field',
                'issue_quotes' => 'Quotes Issues:',
                'issue_quotes_solution' => 'Make sure quotes in your code are properly formatted',
            ],
            'verification' => [
                'save_config' => 'Save Configuration:',
                'click_save_button' => 'Click Save Changes button below',
                'visit_website' => 'Visit Your Website:',
                'open_incognito' => 'Open your website in a new incognito/private window',
                'check_console' => 'Check Browser Console:',
            ],
            'issue_ad_blocker' => 'Blocked by Ad Blocker:',
            'issue_ad_blocker_solution' => 'Test in incognito mode without extensions',
            'issue_caching' => 'Caching Issues:',
            'issue_caching_solution' => 'Clear browser cache or test in incognito mode',
        ],
    ],
    'term_and_privacy_policy_url' => 'Terms and Privacy Policy URL',
    'site_title_separator' => 'SEO title separator',
    'no_meta_keywords' => "Meta keywords was removed by Google, you don't need to add meta keywords to your website. Learn more: :link",
    'validation' => [
        'gtm_container_id_format' => 'GTM Container ID must be in format GTM-XXXXXX (e.g., GTM-N7MK3KH2)',
        'google_tag_id_format' => 'Google Analytics ID must be in format G-XXXXXXXXXX (e.g., G-123ABC4567) or UA-XXXX-X',
        'google_tracking_id_format' => 'Invalid tracking ID format. Must be GTM-XXXXXX, G-XXXXXXXXXX, or UA-XXXX-X',
    ],
    'lazy_load_images_helper' => 'Enable lazy load images to improve page load time.',
    'common' => [
        'yes' => 'Yes',
        'no' => 'No',
        'default' => 'Default',
        'name' => 'Name',
        'icon' => 'Icon',
        'url' => 'URL',
        'color' => 'Color',
        'background_color' => 'Background color',
        'width' => 'Width',
        'height' => 'Height',
        'address' => 'Address',
        'unknown' => 'Unknown',
        'dash' => '- (dash)',
        'pipe' => '| (pipe)',
        'home' => 'Home',
        'none' => '-- None --',
        'share_on_social' => 'Share on :social',
        'copy_link' => 'Copy link',
        'take_me_home' => 'Take me home',
        'content' => 'Content',
        'html_code' => 'HTML code',
    ],
    'shortcodes' => [
        'youtube_video' => 'YouTube video',
        'add_youtube_video' => 'Add YouTube video',
        'youtube_url' => 'YouTube URL',
        'google_maps' => 'Google Maps',
        'add_google_maps_iframe' => 'Add Google Maps iframe',
    ],
    'preloader' => [
        'enable' => 'Enable Preloader?',
        'version' => 'Preloader Version',
    ],
    'facebook' => [
        'integration' => 'Facebook Integration',
        'page_id' => 'Facebook page ID',
        'page_id_helper' => 'You can get fan page ID using this site :link',
        'enable_comment' => 'Enable Facebook comment in post detail page?',
        'app_id' => 'Facebook App ID',
        'app_id_helper' => 'You can create your app in :link',
        'admins' => 'Facebook Admins',
        'admin_id' => 'Facebook Admin ID',
        'admins_helper' => 'Facebook admins to manage comments :link',
    ],
    'social_links' => [
        'title' => 'Social Links',
        'label' => 'Social Links',
        'icon_image_override' => 'Icon Image (It will override icon above if set)',
    ],
    'copyright' => [
        'label' => 'Copyright',
        'placeholder' => 'Change copyright',
        'helper' => 'Copyright on footer of site. Using %Y to display current year.',
    ],
    'lazy_load' => [
        'label' => 'Lazy load images',
        'placeholder_image' => 'Lazy load placeholder image (250x250px)',
        'placeholder_image_helper' => 'This image will be used as placeholder for lazy load images. The best size for this image is 250x250px.',
    ],
    'social_sharing' => [
        'title' => 'Social Sharing',
        'buttons' => 'Social sharing buttons',
        'social' => 'Social',
        'facebook' => 'Facebook',
        'x_twitter' => 'X (Twitter)',
        'linkedin' => 'LinkedIn',
        'pinterest' => 'Pinterest',
        'whatsapp' => 'WhatsApp',
        'telegram' => 'Telegram',
        'email' => 'Email',
        'icon_image_override' => 'Icon image (It will override icon above if set)',
    ],
    'date_format' => [
        'label' => 'Date format',
        'helper' => 'Choose date format for your front theme.',
    ],
    'logo_height' => [
        'label' => 'Logo height (px)',
        'helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'toast_notification' => [
        'title' => 'Toast Notification',
        'position' => 'Position',
        'position_top' => 'Top',
        'position_bottom' => 'Bottom',
        'alignment' => 'Alignment',
        'alignment_left' => 'Left',
        'alignment_right' => 'Right',
        'alignment_center' => 'Center',
        'offset_x' => 'Offset X (px)',
        'offset_y' => 'Offset Y (px)',
        'offset_helper' => 'Offset from the edge of the screen in pixels.',
        'timeout' => 'Timeout (ms)',
        'timeout_helper' => 'Duration in milliseconds before notification auto-hides. Default: 5000ms (5 seconds).',
        'success_icon' => 'Success Icon',
        'success_icon_helper' => 'Icon displayed for success messages.',
        'error_icon' => 'Error Icon',
        'error_icon_helper' => 'Icon displayed for error messages.',
    ],
    'errors' => [
        '404_page_not_found' => '404 Page Not Found',
        'page_not_found' => 'Page could not be found',
        'page_not_found_description' => 'The page you are looking for could not be found.',
        'page_not_found_back_home' => 'Please try again in a few minutes, or alternatively return to the homepage by <a href=":link">clicking here</a>.',
        '500_internal_server_error' => '500 Internal Server Error',
        'internal_server_error' => 'Internal Server Error',
        'internal_server_error_description' => 'Something is broken. Please let us know what you were doing when this error occurred. We will fix it as soon as possible. Sorry for any inconvenience caused.',
        '503_service_unavailable' => '503 Service Unavailable',
        'temporarily_down' => 'Temporarily down for maintenance',
        'maintenance_description' => 'Sorry, we are doing some maintenance. Please check back soon.',
        'maintenance_admin_note' => 'If you are the administrator and you can\'t access your site after enabling maintenance mode, just need to delete file <strong>storage/framework/down</strong> to turn-off maintenance mode.',
        'need_help_contact' => 'If you need help, contact us at :mail.',
    ],
    'widgets' => [
        'edit_this_widget' => 'Edit this widget',
    ],
    'shortcode_labels' => [
        'edit_this_shortcode' => 'Edit this shortcode',
    ],
    'media_shortcode' => [
        'title' => 'Media',
        'description' => 'Add responsive media content',
        'url' => 'Media URL',
        'url_placeholder' => 'https://www.youtube.com/watch?v=SlPhMPnQ58k',
        'width' => 'Width',
        'height' => 'Height',
        'center' => 'Center',
        'margin_top' => 'Margin Top',
        'margin_bottom' => 'Margin Bottom',
        'margin_start' => 'Margin Start',
        'margin_start_helper' => 'Margin at the start of the element (left in LTR, right in RTL)',
        'margin_end' => 'Margin End',
        'margin_end_helper' => 'Margin at the end of the element (right in LTR, left in RTL)',
    ],
    'audio_shortcode' => [
        'title' => 'Audio',
        'description' => 'Add audio player',
        'url' => 'Audio URL',
        'type' => 'Audio Type',
    ],
    'custom_html_shortcode' => [
        'title' => 'Custom HTML',
        'description' => 'Add custom HTML code',
    ],
    'iframe_shortcode' => [
        'title' => 'Iframe Embed',
        'description' => 'Embed external content via iframe',
        'field_title' => 'Title',
        'field_title_placeholder' => 'e.g. Google Map',
        'field_title_helper' => 'Used for accessibility purposes to describe the content of the frame.',
        'full_iframe_code' => 'Full Iframe Code (raw HTML)',
        'full_iframe_code_helper' => 'Paste your raw HTML &lt;iframe&gt; tag here. If this field is filled, the options below will be ignored.',
        'iframe_url' => 'Iframe URL',
        'iframe_url_helper' => 'The URL of the page you want to embed.',
        'id' => 'ID',
        'id_placeholder' => 'e.g. my-widget-id',
        'id_helper' => 'The HTML attributes id for the iframe.',
        'class' => 'Class',
        'class_placeholder' => 'e.g. my-custom-class',
        'class_helper' => 'The HTML attributes class for the iframe.',
        'width' => 'Width',
        'width_helper' => 'The width of the iframe.',
        'height' => 'Height',
        'height_helper' => 'The height of the iframe.',
        'name' => 'Name',
        'name_placeholder' => 'e.g. my-widget-name',
        'name_helper' => 'The HTML attributes name for the iframe.',
        'allow_fullscreen' => 'Allow Fullscreen',
        'allow_fullscreen_helper' => 'Whether to allow the iframe to be displayed in full screen.',
    ],
    'typography_primary' => 'Primary Font',
    'admin_appearance' => [
        'show_admin_bar' => 'Show admin bar for logged-in admins, even in the front site',
        'show_admin_bar_helper' => 'Display a quick access admin toolbar at the top of the website when logged in as an administrator',
        'show_guidelines' => 'Show guidelines',
        'show_guidelines_helper' => 'Display edit buttons for shortcodes (UI blocks) on the frontend when logged in as an administrator. Useful for quick editing of content blocks',
    ],
];
