-- MySQL dump 10.13  Distrib 8.4.4, for macos15 (arm64)
--
-- Host: 127.0.0.1    Database: ninico
-- ------------------------------------------------------
-- Server version	8.4.4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'IJ82UAWHNQOadLwZJAF9zQL1ljhP3q4W',1,'2026-02-09 00:18:30','2026-02-09 00:18:30','2026-02-09 00:18:30');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'New Modern & Stylist <br> Crafts','2028-02-09 07:18:46',NULL,'IYHICPADQD5X','sliders/banner-slider-01.jpg','/products',0,1,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(2,'Popular Energy with our <br> newest collection','2031-02-09 07:18:46',NULL,'R4YAV9FECJUS','sliders/banner-slider-02.jpg','/products',0,2,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(3,'Winter <br> Exclusive In','2028-02-09 07:18:46',NULL,'QPTCBJBOJOSY','banners/banner-offer-01.jpg','/products',0,3,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(4,'50% Offer','2028-02-09 07:18:46',NULL,'T2VFLDYYIJEH','banners/banner-offer-02.jpg','/products',0,4,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(5,'New Modern & Stylist <br> Crafts','2031-02-09 07:18:46',NULL,'JO7LLJHFH1RO','banners/banner-03-01.jpg','/products',0,5,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(6,'Lamp <br> Collections','2028-02-09 07:18:46',NULL,'L8GDJUBVD2TQ','banners/banner-03-02.jpg','/products',0,6,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(7,'Minimal Chair','2027-02-09 07:18:46',NULL,'PXJPAXLOCVRS','banners/banner-03-03.jpg','/products',0,7,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(8,'100% Fresh Product <br> Every Hour','2028-02-09 07:18:46',NULL,'EMRCINED6AX9','sliders/slider-05-banner-1.jpg','/products',0,8,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL),(9,'100% Fresh Product <br> Every Hour','2028-02-09 07:18:46',NULL,'JVMDAIB9HO2I','sliders/slider-05-banner-1.jpg','/products',0,9,'published','2026-02-09 00:18:46','2026-02-09 00:18:46',1,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','<strong>Welcome to our international shop! Enjoy free shipping on orders $100 & up</strong>',1,'Shop now','/',0,1,'2026-02-09 07:19:20',NULL,1,'2026-02-09 00:19:20','2026-02-09 00:19:20'),(2,'Announcement 2','<strong>Trendy 25 silver jewelry, save up 35% off today</strong>',1,'Shop now','/',0,1,'2026-02-09 07:19:20',NULL,1,'2026-02-09 00:19:20','2026-02-09 00:19:20'),(3,'Announcement 3','<strong>Black Friday and Cyber Monday 2023 Deals for Motion Designers, grab it now!</strong>',1,'Shop now','/',0,1,'2026-02-09 07:19:20',NULL,1,'2026-02-09 00:19:20','2026-02-09 00:19:20');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Ecommerce',0,'Explore our collection of articles and insights in this category.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2026-02-09 00:18:37','2026-02-09 00:18:37'),(2,'Fashion',0,'Explore our collection of articles and insights in this category.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2026-02-09 00:18:37','2026-02-09 00:18:37'),(3,'Electronic',0,'Explore our collection of articles and insights in this category.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2026-02-09 00:18:37','2026-02-09 00:18:37'),(4,'Commercial',0,'Explore our collection of articles and insights in this category.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2026-02-09 00:18:37','2026-02-09 00:18:37');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`),
  KEY `idx_categories_trans_categories_id` (`categories_id`),
  KEY `idx_categories_trans_category_lang` (`categories_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`),
  KEY `idx_cities_name` (`name`),
  KEY `idx_cities_state_status` (`state_id`,`status`),
  KEY `idx_cities_status` (`status`),
  KEY `idx_cities_state_id` (`state_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`),
  KEY `idx_cities_trans_city_lang` (`cities_id`,`lang_code`),
  KEY `idx_cities_trans_name` (`name`),
  KEY `idx_cities_trans_cities_id` (`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`),
  KEY `idx_contact_cfo_trans_cfo_id` (`contact_custom_field_options_id`),
  KEY `idx_contact_cfo_trans_cfo_lang` (`contact_custom_field_options_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`),
  KEY `idx_contact_cf_trans_cf_id` (`contact_custom_fields_id`),
  KEY `idx_contact_cf_trans_cf_lang` (`contact_custom_fields_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_countries_name` (`name`),
  KEY `idx_countries_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`),
  KEY `idx_countries_trans_country_lang` (`countries_id`,`lang_code`),
  KEY `idx_countries_trans_name` (`name`),
  KEY `idx_countries_trans_countries_id` (`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `device_tokens`
--

DROP TABLE IF EXISTS `device_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `device_tokens_token_unique` (`token`),
  KEY `device_tokens_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `device_tokens_platform_is_active_index` (`platform`,`is_active`),
  KEY `device_tokens_is_active_index` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `device_tokens`
--

LOCK TABLES `device_tokens` WRITE;
/*!40000 ALTER TABLE `device_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_abandoned_carts`
--

DROP TABLE IF EXISTS `ec_abandoned_carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_abandoned_carts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `session_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cart_data` json NOT NULL,
  `total_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `items_count` int NOT NULL DEFAULT '0',
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abandoned_at` timestamp NULL DEFAULT NULL,
  `reminder_sent_at` timestamp NULL DEFAULT NULL,
  `reminders_sent` int NOT NULL DEFAULT '0',
  `last_email_sequence` tinyint unsigned NOT NULL DEFAULT '0',
  `recovery_token` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unsubscribed_at` timestamp NULL DEFAULT NULL,
  `is_recovered` tinyint(1) NOT NULL DEFAULT '0',
  `recovered_at` timestamp NULL DEFAULT NULL,
  `recovered_order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_abandoned_carts_recovery_token_unique` (`recovery_token`),
  UNIQUE KEY `ec_abandoned_carts_unsubscribe_token_unique` (`unsubscribe_token`),
  KEY `ec_abandoned_carts_abandoned_at_is_recovered_index` (`abandoned_at`,`is_recovered`),
  KEY `ec_abandoned_carts_created_at_is_recovered_index` (`created_at`,`is_recovered`),
  KEY `ec_abandoned_carts_customer_id_index` (`customer_id`),
  KEY `ec_abandoned_carts_session_id_index` (`session_id`),
  KEY `ec_abandoned_carts_email_index` (`email`),
  KEY `ec_abandoned_carts_recovered_order_id_index` (`recovered_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_abandoned_carts`
--

LOCK TABLES `ec_abandoned_carts` WRITE;
/*!40000 ALTER TABLE `ec_abandoned_carts` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_abandoned_carts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'Fashion live',NULL,NULL,'brands/brand-01.png','published',0,1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(2,'Hand crafted',NULL,NULL,'brands/brand-02.png','published',1,1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(3,'Mestonix',NULL,NULL,'brands/brand-03.png','published',2,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(4,'Sunshine',NULL,NULL,'brands/brand-04.png','published',3,1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(5,'Pure',NULL,NULL,'brands/brand-05.png','published',4,1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(6,'Anfold',NULL,NULL,'brands/brand-06.png','published',5,0,'2026-02-09 00:18:48','2026-02-09 00:18:48');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`),
  KEY `idx_brands_fk` (`ec_brands_id`),
  KEY `idx_brands_brands_lang` (`ec_brands_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`),
  KEY `ec_cart_customer_instance_index` (`customer_id`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `number_format_style` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'western',
  `space_between_price_and_currency` tinyint(1) NOT NULL DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,'western',0,0,1,1,'2026-02-09 00:18:30','2026-02-09 00:18:30'),(2,'EUR','€',0,2,'western',0,1,0,0.84,'2026-02-09 00:18:30','2026-02-09 00:18:30'),(3,'VND','₫',0,0,'western',0,2,0,23203,'2026-02-09 00:18:30','2026-02-09 00:18:30'),(4,'NGN','₦',1,2,'western',0,2,0,895.52,'2026-02-09 00:18:30','2026-02-09 00:18:30');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'John Smith','customer@botble.com','+17028288455','DE','New York','Miami','456 Oak Avenue',1,1,'2026-02-09 00:19:14','2026-02-09 00:19:14','77001'),(2,'John Smith','customer@botble.com','+15601668613','DE','Illinois','Miami','789 Pine Road',1,0,'2026-02-09 00:19:14','2026-02-09 00:19:14','60601'),(3,'Sarah Johnson','john.smith@botble.com','+16097650776','AU','New York','Miami','123 Main Street',2,1,'2026-02-09 00:19:14','2026-02-09 00:19:14','33101'),(4,'Sarah Johnson','john.smith@botble.com','+16899788489','FR','California','Houston','321 Elm Boulevard',2,0,'2026-02-09 00:19:14','2026-02-09 00:19:14','60601'),(5,'Michael Brown','michael.brown@example.com','+15705888032','FR','Pennsylvania','New York City','654 Maple Drive',3,1,'2026-02-09 00:19:14','2026-02-09 00:19:14','10001'),(6,'Emily Davis','emily.davis@example.com','+15187082297','DE','California','Chicago','654 Maple Drive',4,1,'2026-02-09 00:19:15','2026-02-09 00:19:15','60601'),(7,'David Wilson','david.wilson@example.com','+13939718610','FR','Pennsylvania','Miami','789 Pine Road',5,1,'2026-02-09 00:19:15','2026-02-09 00:19:15','60601'),(8,'Jessica Taylor','jessica.taylor@example.com','+13304664580','US','New York','Chicago','321 Elm Boulevard',6,1,'2026-02-09 00:19:15','2026-02-09 00:19:15','33101'),(9,'Robert Anderson','robert.anderson@example.com','+17204179914','CA','Texas','New York City','789 Pine Road',7,1,'2026-02-09 00:19:15','2026-02-09 00:19:15','19101'),(10,'Amanda Thomas','amanda.thomas@example.com','+18500658161','US','Florida','Houston','123 Main Street',8,1,'2026-02-09 00:19:16','2026-02-09 00:19:16','60601'),(11,'William Martinez','william.martinez@example.com','+14627941902','DE','California','Houston','321 Elm Boulevard',9,1,'2026-02-09 00:19:16','2026-02-09 00:19:16','33101'),(12,'Jennifer Garcia','jennifer.garcia@example.com','+18909513639','AU','New York','Miami','987 Cedar Lane',10,1,'2026-02-09 00:19:16','2026-02-09 00:19:16','10001');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_deletion_requests`
--

DROP TABLE IF EXISTS `ec_customer_deletion_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_deletion_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `verification_code` varchar(6) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_expires_at` timestamp NULL DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting_for_confirmation',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `confirmed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customer_deletion_requests_token_unique` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_deletion_requests`
--

LOCK TABLES `ec_customer_deletion_requests` WRITE;
/*!40000 ALTER TABLE `ec_customer_deletion_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_deletion_requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`customer_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `tax_class` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'regular',
  `tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'John Smith','customer@botble.com','$2y$12$M1tU2pgRPbPh7kPGsTD7ZOIdhqucalAnpP9UYg.HrP5s0s2MPa.Fm','customers/7.jpg','1996-02-07','regular',NULL,'+17399082405',NULL,'2026-02-09 00:19:14','2026-02-09 00:19:14','2026-02-09 07:19:14',NULL,'activated',NULL),(2,'Sarah Johnson','john.smith@botble.com','$2y$12$PQF0p6Iw7whbJXIVNl.boOUDCS18oQXmPNKASSgaoAeBJwmVCANOS','customers/7.jpg','1998-01-11','regular',NULL,'+15462174991',NULL,'2026-02-09 00:19:14','2026-02-09 00:19:14','2026-02-09 07:19:14',NULL,'activated',NULL),(3,'Michael Brown','michael.brown@example.com','$2y$12$pFCvXAbeZrItt/PXTDq9VePb2ilG94POHBGBM4/MAS/lVq7aGgmUy','customers/1.jpg','1988-01-20','regular',NULL,'+15546675852',NULL,'2026-02-09 00:19:14','2026-02-09 00:19:14','2026-02-09 07:19:14',NULL,'activated',NULL),(4,'Emily Davis','emily.davis@example.com','$2y$12$LK5uekKsULleg2tODZoxCe2z4odiglF7/3lwK37b0Irow2VNhXTEm','customers/2.jpg','1998-01-11','regular',NULL,'+14923355221',NULL,'2026-02-09 00:19:15','2026-02-09 00:19:15','2026-02-09 07:19:15',NULL,'activated',NULL),(5,'David Wilson','david.wilson@example.com','$2y$12$YpyEXB0JQIsZHMRwfkkHOOO2vT1SNbBmRaIznqAdmKM8twNKOR8Vy','customers/3.jpg','2003-01-31','regular',NULL,'+16366519231',NULL,'2026-02-09 00:19:15','2026-02-09 00:19:15','2026-02-09 07:19:15',NULL,'activated',NULL),(6,'Jessica Taylor','jessica.taylor@example.com','$2y$12$3j6LeF3ydVmD9/TsqC/ZU.qQ3qe5xeZ7aA/SLu9HrHZSWHdbS1zIy','customers/4.jpg','2001-01-20','regular',NULL,'+14359574469',NULL,'2026-02-09 00:19:15','2026-02-09 00:19:15','2026-02-09 07:19:15',NULL,'activated',NULL),(7,'Robert Anderson','robert.anderson@example.com','$2y$12$dfX5Hl1u6CPk67NsbVLjLuXydXjgQqT8MztPWNc0p6JoDMkRvzYTu','customers/5.jpg','1987-02-07','regular',NULL,'+12719822533',NULL,'2026-02-09 00:19:15','2026-02-09 00:19:15','2026-02-09 07:19:15',NULL,'activated',NULL),(8,'Amanda Thomas','amanda.thomas@example.com','$2y$12$qw1dtsFe0BQotSKQ5sbPtu2keRMvgevTWUMBk17GcH.qAcCtpa7/.','customers/6.jpg','1976-02-01','regular',NULL,'+17994191878',NULL,'2026-02-09 00:19:16','2026-02-09 00:19:16','2026-02-09 07:19:16',NULL,'activated',NULL),(9,'William Martinez','william.martinez@example.com','$2y$12$4QOYq6vqmCT/xESgOWDxsuCc8edsR62dFT5k0aYlsobVaPh8tZiGi','customers/7.jpg','1978-01-10','regular',NULL,'+13384520293',NULL,'2026-02-09 00:19:16','2026-02-09 00:19:16','2026-02-09 07:19:16',NULL,'activated',NULL),(10,'Jennifer Garcia','jennifer.garcia@example.com','$2y$12$.Ul.BSs0Tm5.YPLUVEFaTOx6.Pu3jwgT/sEpa8eKEOsOjbMnpiV1m','customers/8.jpg','1991-01-19','regular',NULL,'+18473984935',NULL,'2026-02-09 00:19:16','2026-02-09 00:19:16','2026-02-09 07:19:16',NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `can_use_with_flash_sale` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','4KDSJQ6EVVOL','2026-02-08 07:19:18','2026-03-06 07:19:18',NULL,0,882,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(2,'Discount 2','9KMRLZ2NUNGB','2026-02-08 07:19:18','2026-02-18 07:19:18',NULL,0,68,'coupon',0,0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(3,'Discount 3','N5Q80AIWPIMS','2026-02-08 07:19:18','2026-02-14 07:19:18',NULL,0,227,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(4,'Discount 4','YA4MZFJ3SRF5','2026-02-08 07:19:18','2026-02-28 07:19:18',NULL,0,52,'coupon',0,0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(5,'Discount 5','QQORNGOTBJAL','2026-02-08 07:19:18',NULL,NULL,0,849,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(6,'Discount 6','O5W93EJ6OWEL','2026-02-08 07:19:18','2026-02-24 07:19:18',NULL,0,315,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(7,'Discount 7','VVOGZVMHOIHO','2026-02-08 07:19:18','2026-03-05 07:19:18',NULL,0,692,'coupon',0,0,NULL,NULL,'amount','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(8,'Discount 8','NEITQLQSKCY1','2026-02-08 07:19:18',NULL,NULL,0,257,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(9,'Discount 9','YNTKXW6JO54O','2026-02-08 07:19:18',NULL,NULL,0,76,'coupon',0,0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(10,'Discount 10','GJN6N1ANV4DR','2026-02-08 07:19:18','2026-02-18 07:19:18',NULL,0,795,'coupon',0,0,NULL,NULL,'amount','all-orders',NULL,0,1,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0',
  KEY `ec_flash_sale_products_product_id_flash_sale_id_index` (`product_id`,`flash_sale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,155.75,17,1),(1,2,293.94,10,2),(1,3,238.05,8,3),(1,4,149.76,10,4),(1,5,180.19,8,4),(1,6,143.1,20,2),(1,7,234.33,7,1),(1,8,69.015,12,3),(1,9,120.96,20,5),(1,10,170.1,13,3),(2,1,100,10,5);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2026-09-26 00:00:00','published','2026-02-09 00:19:18','2026-02-09 00:19:18'),(2,'Cosmetics Sale','2027-05-12 00:00:00','published','2026-02-09 00:19:18','2026-02-09 00:19:18');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`),
  KEY `idx_flash_sales_fk` (`ec_flash_sales_id`),
  KEY `idx_flash_sales_flash_sales_lang` (`ec_flash_sales_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(2,1,'2 Year',10,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(3,1,'3 Year',20,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(4,2,'4GB',0,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(5,2,'8GB',10,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(6,2,'16GB',20,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(7,3,'Core i5',0,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(8,3,'Core i7',10,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(9,3,'Core i9',20,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(10,4,'128GB',0,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(11,4,'256GB',10,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(12,4,'512GB',20,9999,0,'2026-02-09 00:18:48','2026-02-09 00:18:48');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`),
  KEY `idx_global_option_value_fk` (`ec_global_option_value_id`),
  KEY `idx_global_option_value_global_option_value_lang` (`ec_global_option_value_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2026-02-09 00:18:48','2026-02-09 00:18:48');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`),
  KEY `idx_global_options_fk` (`ec_global_options_id`),
  KEY `idx_global_options_global_options_lang` (`ec_global_options_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_item_tax_components`
--

DROP TABLE IF EXISTS `ec_invoice_item_tax_components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_item_tax_components` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_item_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `jurisdiction` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_iitc_invoice_item` (`invoice_item_id`),
  CONSTRAINT `ec_invoice_item_tax_components_invoice_item_id_foreign` FOREIGN KEY (`invoice_item_id`) REFERENCES `ec_invoice_items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_item_tax_components`
--

LOCK TABLES `ec_invoice_item_tax_components` WRITE;
/*!40000 ALTER TABLE `ec_invoice_item_tax_components` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_invoice_item_tax_components` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`),
  KEY `ec_invoices_reference_id_reference_type_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`),
  KEY `idx_option_value_fk` (`ec_option_value_id`),
  KEY `idx_option_value_option_value_lang` (`ec_option_value_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`),
  KEY `idx_options_fk` (`ec_options_id`),
  KEY `idx_options_options_lang` (`ec_options_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_addresses_order_id_type_unique` (`order_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_metadata`
--

DROP TABLE IF EXISTS `ec_order_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_metadata` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_metadata_order_id_meta_key_index` (`order_id`,`meta_key`),
  KEY `ec_order_metadata_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_metadata`
--

LOCK TABLES `ec_order_metadata` WRITE;
/*!40000 ALTER TABLE `ec_order_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT '0.00',
  `tax_breakdown` json DEFAULT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double DEFAULT '0',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` text COLLATE utf8mb4_unicode_ci,
  `downloaded_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_product_order_id_product_id_index` (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product_tax_components`
--

DROP TABLE IF EXISTS `ec_order_product_tax_components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product_tax_components` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_product_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` decimal(8,4) NOT NULL DEFAULT '0.0000',
  `amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `jurisdiction` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_opt_order_product` (`order_product_id`),
  KEY `idx_opt_order_product_code` (`order_product_id`,`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product_tax_components`
--

LOCK TABLES `ec_order_product_tax_components` WRITE;
/*!40000 ALTER TABLE `ec_order_product_tax_components` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_product_tax_components` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_histories`
--

DROP TABLE IF EXISTS `ec_order_return_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_return_id` bigint unsigned NOT NULL,
  `action` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_histories`
--

LOCK TABLES `ec_order_return_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_return_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `images` json DEFAULT NULL,
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT '0.00',
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `cancellation_reason` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancellation_reason_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `proof_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`),
  KEY `ec_orders_status_created_at_index` (`status`,`created_at`),
  KEY `ec_orders_user_id_is_finished_index` (`user_id`,`is_finished`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2026-02-09 00:18:48','2026-02-09 00:18:48',1),(2,'Size','size','text',1,1,1,'published',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`),
  KEY `idx_product_attribute_sets_fk` (`ec_product_attribute_sets_id`),
  KEY `idx_product_attribute_sets_product_attribute_sets_lang` (`ec_product_attribute_sets_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`),
  KEY `idx_attribute_set_id` (`attribute_set_id`),
  KEY `idx_attribute_set_order_id` (`attribute_set_id`,`order`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(2,1,'Blue','blue','#333333',NULL,0,2,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(3,1,'Red','red','#DA323F',NULL,0,3,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(4,1,'Black','black','#2F366C',NULL,0,4,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(6,2,'S','s',NULL,NULL,1,1,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(7,2,'M','m',NULL,NULL,0,2,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(8,2,'L','l',NULL,NULL,0,3,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(9,2,'XL','xl',NULL,NULL,0,4,'2026-02-09 00:18:48','2026-02-09 00:18:48'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2026-02-09 00:18:48','2026-02-09 00:18:48');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`),
  KEY `idx_product_attributes_fk` (`ec_product_attributes_id`),
  KEY `idx_product_attributes_product_attributes_lang` (`ec_product_attributes_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`),
  KEY `idx_categories_status_order` (`status`,`order`),
  KEY `idx_categories_order` (`order`),
  KEY `ec_product_categories_slug_index` (`slug`),
  KEY `idx_ec_product_categories_status` (`status`),
  KEY `idx_ec_product_categories_parent_id` (`parent_id`),
  KEY `idx_ec_product_categories_status_parent_order` (`status`,`parent_id`,`order`),
  KEY `idx_ec_product_categories_is_featured` (`is_featured`),
  KEY `idx_ec_product_categories_name` (`name`),
  KEY `idx_ec_product_categories_slug` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Pro Glasses',NULL,0,NULL,'published',0,'banners/banner-2-01.jpg',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(2,'Casual Shoes',NULL,0,NULL,'published',0,'banners/banner-2-02.jpg',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(3,'Winter Jacket',NULL,2,NULL,'published',0,'banners/banner-2-03.jpg',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(4,'New Added',NULL,2,NULL,'published',0,'banners/banner-2-04.jpg',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(5,'Wooden',NULL,2,NULL,'published',0,NULL,1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(6,'Furniture',NULL,2,NULL,'published',0,NULL,1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(7,'Clock',NULL,2,NULL,'published',0,NULL,1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(8,'Gifts',NULL,2,NULL,'published',0,NULL,1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(9,'Crafts',NULL,2,NULL,'published',0,NULL,1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(10,'Gift Sets',NULL,0,NULL,'published',0,'features/feature-icon-01.png',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(11,'Plastic Gifts',NULL,0,NULL,'published',0,'features/feature-icon-02.png',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(12,'Handy Cream',NULL,0,NULL,'published',0,'features/feature-icon-03.png',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(13,'Cosmetics',NULL,0,NULL,'published',0,'features/feature-icon-04.png',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(14,'Silk Accessories',NULL,0,NULL,'published',0,'features/feature-icon-05.png',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(15,'Finest Skincare Lotions',NULL,0,NULL,'published',0,'features/feature-icon-06.png',1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(16,'Bags & Purses',NULL,0,NULL,'published',0,NULL,1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL),(17,'Sunglasses',NULL,0,NULL,'published',0,NULL,1,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`),
  KEY `idx_product_categories_fk` (`ec_product_categories_id`),
  KEY `idx_product_categories_product_categories_lang` (`ec_product_categories_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`),
  KEY `idx_product_category` (`product_id`,`category_id`),
  KEY `idx_product_id_category_id` (`product_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,18),(1,25),(1,28),(1,70),(2,15),(2,35),(3,2),(4,22),(4,26),(4,36),(4,43),(4,47),(4,48),(4,65),(5,6),(5,21),(5,23),(6,9),(6,32),(6,57),(6,60),(6,63),(7,19),(7,24),(7,33),(7,34),(7,41),(7,50),(7,56),(7,59),(7,71),(7,72),(8,5),(8,8),(8,46),(8,49),(9,4),(9,11),(9,31),(9,38),(9,39),(9,44),(10,14),(10,17),(10,30),(10,42),(10,54),(10,55),(10,64),(11,12),(11,40),(11,45),(11,51),(11,66),(11,67),(11,74),(12,3),(12,13),(12,29),(12,37),(12,62),(12,69),(13,10),(13,27),(13,53),(13,58),(13,68),(13,73),(14,1),(14,7),(14,16),(14,20),(14,52),(14,61),(14,75);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`),
  KEY `idx_product_id_collection_id` (`product_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,1),(1,2),(1,3),(1,5),(1,10),(1,11),(1,12),(1,16),(1,17),(1,21),(1,23),(1,24),(1,25),(1,26),(1,31),(1,37),(1,39),(1,41),(1,43),(1,44),(1,46),(1,47),(1,48),(1,49),(1,56),(1,58),(1,59),(1,66),(1,67),(1,68),(1,70),(2,14),(2,18),(2,20),(2,22),(2,27),(2,30),(2,33),(2,35),(2,38),(2,42),(2,45),(2,50),(2,54),(2,57),(2,60),(2,62),(2,64),(2,65),(2,72),(2,74),(2,75),(3,4),(3,6),(3,7),(3,8),(3,9),(3,13),(3,15),(3,19),(3,28),(3,29),(3,32),(3,34),(3,36),(3,40),(3,51),(3,52),(3,53),(3,55),(3,61),(3,63),(3,69),(3,71),(3,73);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'New Arrival','new-arrival',NULL,NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48',0),(2,'Best Sellers','best-sellers',NULL,NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48',0),(3,'Special Offer','special-offer',NULL,NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48',0),(4,'Reactive Providence Hair Color','reactive-providence-hair-color',NULL,'banners/thumb-01.jpg','published','2026-02-09 00:18:48','2026-02-09 00:18:48',0),(5,'New Modern &amp; Stylist Makeup','new-modern-stylist-makeup',NULL,'banners/thumb-02.jpg','published','2026-02-09 00:18:48','2026-02-09 00:18:48',0),(6,'Intensive Glow C+ Serum','intensive-glow-c-serum',NULL,'banners/thumb-03.jpg','published','2026-02-09 00:18:48','2026-02-09 00:18:48',0),(7,'Vogue','vogue',NULL,'banners/thumb-04.jpg','published','2026-02-09 00:18:48','2026-02-09 00:18:48',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`),
  KEY `idx_product_collections_fk` (`ec_product_collections_id`),
  KEY `idx_product_collections_product_collections_lang` (`ec_product_collections_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`),
  KEY `idx_product_cross_sale` (`from_product_id`,`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,11,0,0.00,'fixed',1),(1,12,0,0.00,'fixed',1),(1,31,0,0.00,'fixed',1),(1,35,0,0.00,'fixed',1),(2,16,0,0.00,'fixed',1),(2,25,0,0.00,'fixed',1),(2,55,0,0.00,'fixed',1),(2,73,0,0.00,'fixed',1),(3,14,0,0.00,'fixed',1),(3,17,0,0.00,'fixed',1),(3,42,0,0.00,'fixed',1),(3,59,0,0.00,'fixed',1),(4,8,0,0.00,'fixed',1),(4,34,0,0.00,'fixed',1),(4,43,0,0.00,'fixed',1),(4,46,0,0.00,'fixed',1),(5,3,0,0.00,'fixed',1),(5,6,0,0.00,'fixed',1),(5,20,0,0.00,'fixed',1),(5,68,0,0.00,'fixed',1),(6,22,0,0.00,'fixed',1),(6,36,0,0.00,'fixed',1),(6,45,0,0.00,'fixed',1),(6,68,0,0.00,'fixed',1),(7,8,0,0.00,'fixed',1),(7,40,0,0.00,'fixed',1),(7,56,0,0.00,'fixed',1),(7,57,0,0.00,'fixed',1),(8,33,0,0.00,'fixed',1),(8,60,0,0.00,'fixed',1),(8,64,0,0.00,'fixed',1),(8,71,0,0.00,'fixed',1),(9,12,0,0.00,'fixed',1),(9,42,0,0.00,'fixed',1),(9,43,0,0.00,'fixed',1),(9,46,0,0.00,'fixed',1),(10,52,0,0.00,'fixed',1),(10,56,0,0.00,'fixed',1),(10,63,0,0.00,'fixed',1),(10,72,0,0.00,'fixed',1),(11,1,0,0.00,'fixed',1),(11,17,0,0.00,'fixed',1),(11,39,0,0.00,'fixed',1),(11,53,0,0.00,'fixed',1),(12,46,0,0.00,'fixed',1),(12,56,0,0.00,'fixed',1),(12,71,0,0.00,'fixed',1),(12,73,0,0.00,'fixed',1),(13,1,0,0.00,'fixed',1),(13,70,0,0.00,'fixed',1),(13,75,0,0.00,'fixed',1),(14,7,0,0.00,'fixed',1),(14,15,0,0.00,'fixed',1),(14,50,0,0.00,'fixed',1),(14,70,0,0.00,'fixed',1),(15,1,0,0.00,'fixed',1),(15,6,0,0.00,'fixed',1),(15,25,0,0.00,'fixed',1),(15,59,0,0.00,'fixed',1),(16,3,0,0.00,'fixed',1),(16,8,0,0.00,'fixed',1),(16,11,0,0.00,'fixed',1),(16,42,0,0.00,'fixed',1),(17,14,0,0.00,'fixed',1),(17,25,0,0.00,'fixed',1),(17,49,0,0.00,'fixed',1),(17,54,0,0.00,'fixed',1),(18,17,0,0.00,'fixed',1),(18,27,0,0.00,'fixed',1),(18,30,0,0.00,'fixed',1),(18,41,0,0.00,'fixed',1),(19,5,0,0.00,'fixed',1),(19,9,0,0.00,'fixed',1),(19,58,0,0.00,'fixed',1),(19,61,0,0.00,'fixed',1),(20,7,0,0.00,'fixed',1),(20,18,0,0.00,'fixed',1),(20,44,0,0.00,'fixed',1),(20,66,0,0.00,'fixed',1),(21,36,0,0.00,'fixed',1),(21,37,0,0.00,'fixed',1),(21,56,0,0.00,'fixed',1),(21,73,0,0.00,'fixed',1),(22,9,0,0.00,'fixed',1),(22,17,0,0.00,'fixed',1),(22,49,0,0.00,'fixed',1),(22,57,0,0.00,'fixed',1),(23,3,0,0.00,'fixed',1),(23,4,0,0.00,'fixed',1),(23,52,0,0.00,'fixed',1),(23,58,0,0.00,'fixed',1),(24,6,0,0.00,'fixed',1),(24,29,0,0.00,'fixed',1),(24,55,0,0.00,'fixed',1),(24,56,0,0.00,'fixed',1),(25,15,0,0.00,'fixed',1),(25,45,0,0.00,'fixed',1),(25,52,0,0.00,'fixed',1),(25,73,0,0.00,'fixed',1),(26,22,0,0.00,'fixed',1),(26,24,0,0.00,'fixed',1),(26,46,0,0.00,'fixed',1),(26,55,0,0.00,'fixed',1),(27,35,0,0.00,'fixed',1),(27,43,0,0.00,'fixed',1),(27,53,0,0.00,'fixed',1),(27,71,0,0.00,'fixed',1),(28,8,0,0.00,'fixed',1),(28,31,0,0.00,'fixed',1),(28,41,0,0.00,'fixed',1),(28,42,0,0.00,'fixed',1),(29,3,0,0.00,'fixed',1),(29,22,0,0.00,'fixed',1),(29,68,0,0.00,'fixed',1),(29,73,0,0.00,'fixed',1),(30,9,0,0.00,'fixed',1),(30,25,0,0.00,'fixed',1),(30,44,0,0.00,'fixed',1),(30,67,0,0.00,'fixed',1),(31,1,0,0.00,'fixed',1),(31,23,0,0.00,'fixed',1),(31,48,0,0.00,'fixed',1),(31,70,0,0.00,'fixed',1),(32,2,0,0.00,'fixed',1),(32,12,0,0.00,'fixed',1),(32,42,0,0.00,'fixed',1),(32,43,0,0.00,'fixed',1),(33,2,0,0.00,'fixed',1),(33,15,0,0.00,'fixed',1),(33,54,0,0.00,'fixed',1),(33,62,0,0.00,'fixed',1),(34,18,0,0.00,'fixed',1),(34,41,0,0.00,'fixed',1),(34,47,0,0.00,'fixed',1),(34,68,0,0.00,'fixed',1),(35,9,0,0.00,'fixed',1),(35,26,0,0.00,'fixed',1),(35,31,0,0.00,'fixed',1),(35,32,0,0.00,'fixed',1),(36,4,0,0.00,'fixed',1),(36,18,0,0.00,'fixed',1),(36,38,0,0.00,'fixed',1),(36,51,0,0.00,'fixed',1),(37,16,0,0.00,'fixed',1),(37,32,0,0.00,'fixed',1),(37,52,0,0.00,'fixed',1),(37,56,0,0.00,'fixed',1),(38,20,0,0.00,'fixed',1),(38,59,0,0.00,'fixed',1),(38,62,0,0.00,'fixed',1),(38,63,0,0.00,'fixed',1),(39,18,0,0.00,'fixed',1),(39,29,0,0.00,'fixed',1),(39,43,0,0.00,'fixed',1),(39,55,0,0.00,'fixed',1),(40,14,0,0.00,'fixed',1),(40,39,0,0.00,'fixed',1),(40,47,0,0.00,'fixed',1),(40,73,0,0.00,'fixed',1),(41,5,0,0.00,'fixed',1),(41,58,0,0.00,'fixed',1),(41,74,0,0.00,'fixed',1),(42,33,0,0.00,'fixed',1),(42,39,0,0.00,'fixed',1),(42,49,0,0.00,'fixed',1),(42,50,0,0.00,'fixed',1),(43,20,0,0.00,'fixed',1),(43,33,0,0.00,'fixed',1),(43,34,0,0.00,'fixed',1),(43,67,0,0.00,'fixed',1),(44,5,0,0.00,'fixed',1),(44,31,0,0.00,'fixed',1),(44,39,0,0.00,'fixed',1),(44,43,0,0.00,'fixed',1),(45,4,0,0.00,'fixed',1),(45,30,0,0.00,'fixed',1),(45,51,0,0.00,'fixed',1),(45,66,0,0.00,'fixed',1),(46,19,0,0.00,'fixed',1),(46,39,0,0.00,'fixed',1),(46,51,0,0.00,'fixed',1),(47,18,0,0.00,'fixed',1),(47,23,0,0.00,'fixed',1),(47,31,0,0.00,'fixed',1),(47,56,0,0.00,'fixed',1),(48,39,0,0.00,'fixed',1),(48,46,0,0.00,'fixed',1),(48,53,0,0.00,'fixed',1),(48,56,0,0.00,'fixed',1),(49,11,0,0.00,'fixed',1),(49,16,0,0.00,'fixed',1),(49,34,0,0.00,'fixed',1),(49,57,0,0.00,'fixed',1),(50,4,0,0.00,'fixed',1),(50,29,0,0.00,'fixed',1),(50,31,0,0.00,'fixed',1),(50,62,0,0.00,'fixed',1),(51,22,0,0.00,'fixed',1),(51,36,0,0.00,'fixed',1),(51,45,0,0.00,'fixed',1),(51,47,0,0.00,'fixed',1),(52,6,0,0.00,'fixed',1),(52,9,0,0.00,'fixed',1),(52,25,0,0.00,'fixed',1),(53,13,0,0.00,'fixed',1),(53,41,0,0.00,'fixed',1),(53,47,0,0.00,'fixed',1),(53,52,0,0.00,'fixed',1),(54,17,0,0.00,'fixed',1),(54,23,0,0.00,'fixed',1),(54,39,0,0.00,'fixed',1),(54,75,0,0.00,'fixed',1),(55,16,0,0.00,'fixed',1),(55,20,0,0.00,'fixed',1),(55,29,0,0.00,'fixed',1),(55,56,0,0.00,'fixed',1),(56,9,0,0.00,'fixed',1),(56,16,0,0.00,'fixed',1),(56,18,0,0.00,'fixed',1),(56,66,0,0.00,'fixed',1),(57,6,0,0.00,'fixed',1),(57,29,0,0.00,'fixed',1),(57,36,0,0.00,'fixed',1),(57,63,0,0.00,'fixed',1),(58,7,0,0.00,'fixed',1),(58,13,0,0.00,'fixed',1),(58,40,0,0.00,'fixed',1),(58,73,0,0.00,'fixed',1),(59,46,0,0.00,'fixed',1),(59,53,0,0.00,'fixed',1),(59,60,0,0.00,'fixed',1),(59,71,0,0.00,'fixed',1),(60,13,0,0.00,'fixed',1),(60,23,0,0.00,'fixed',1),(60,30,0,0.00,'fixed',1),(60,54,0,0.00,'fixed',1),(61,9,0,0.00,'fixed',1),(61,34,0,0.00,'fixed',1),(61,38,0,0.00,'fixed',1),(61,47,0,0.00,'fixed',1),(62,10,0,0.00,'fixed',1),(62,20,0,0.00,'fixed',1),(62,25,0,0.00,'fixed',1),(62,42,0,0.00,'fixed',1),(63,11,0,0.00,'fixed',1),(63,20,0,0.00,'fixed',1),(63,67,0,0.00,'fixed',1),(63,74,0,0.00,'fixed',1),(64,7,0,0.00,'fixed',1),(64,9,0,0.00,'fixed',1),(64,41,0,0.00,'fixed',1),(64,65,0,0.00,'fixed',1),(65,30,0,0.00,'fixed',1),(65,38,0,0.00,'fixed',1),(65,42,0,0.00,'fixed',1),(65,49,0,0.00,'fixed',1),(66,13,0,0.00,'fixed',1),(66,15,0,0.00,'fixed',1),(66,32,0,0.00,'fixed',1),(66,47,0,0.00,'fixed',1),(67,18,0,0.00,'fixed',1),(67,36,0,0.00,'fixed',1),(67,53,0,0.00,'fixed',1),(67,57,0,0.00,'fixed',1),(68,20,0,0.00,'fixed',1),(68,44,0,0.00,'fixed',1),(68,45,0,0.00,'fixed',1),(68,58,0,0.00,'fixed',1),(69,6,0,0.00,'fixed',1),(69,14,0,0.00,'fixed',1),(69,23,0,0.00,'fixed',1),(69,58,0,0.00,'fixed',1),(70,13,0,0.00,'fixed',1),(70,22,0,0.00,'fixed',1),(70,26,0,0.00,'fixed',1),(70,40,0,0.00,'fixed',1),(71,40,0,0.00,'fixed',1),(71,42,0,0.00,'fixed',1),(71,48,0,0.00,'fixed',1),(71,74,0,0.00,'fixed',1),(72,9,0,0.00,'fixed',1),(72,24,0,0.00,'fixed',1),(72,30,0,0.00,'fixed',1),(72,54,0,0.00,'fixed',1),(73,1,0,0.00,'fixed',1),(73,40,0,0.00,'fixed',1),(73,66,0,0.00,'fixed',1),(73,74,0,0.00,'fixed',1),(74,2,0,0.00,'fixed',1),(74,7,0,0.00,'fixed',1),(74,46,0,0.00,'fixed',1),(74,57,0,0.00,'fixed',1),(75,1,0,0.00,'fixed',1),(75,44,0,0.00,'fixed',1),(75,49,0,0.00,'fixed',1),(75,67,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=376 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,76,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(2,76,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(3,76,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(4,76,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(5,76,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(6,76,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(7,77,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(8,77,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(9,77,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(10,77,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(11,77,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(12,77,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(13,78,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(14,78,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(15,78,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(16,78,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(17,78,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(18,78,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(19,83,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(20,83,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(21,83,'ecommerce/digital-product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(22,83,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(23,83,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(24,84,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(25,84,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(26,84,'ecommerce/digital-product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(27,84,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(28,84,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(29,94,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(30,94,'ecommerce/digital-product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(31,94,'ecommerce/digital-product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(32,94,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(33,94,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(34,94,'ecommerce/digital-product-files/product-56.jpg','{\"filename\":\"product-56.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-56.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-56\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(35,94,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(36,94,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(37,94,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(38,94,'ecommerce/digital-product-files/product-77.jpg','{\"filename\":\"product-77.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-77.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-77\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(39,94,'ecommerce/digital-product-files/product-81.jpg','{\"filename\":\"product-81.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-81.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-81\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(40,94,'ecommerce/digital-product-files/product-86.jpg','{\"filename\":\"product-86.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-86.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-86\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(41,95,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(42,95,'ecommerce/digital-product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(43,95,'ecommerce/digital-product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(44,95,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(45,95,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(46,95,'ecommerce/digital-product-files/product-56.jpg','{\"filename\":\"product-56.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-56.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-56\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(47,95,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(48,95,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(49,95,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(50,95,'ecommerce/digital-product-files/product-77.jpg','{\"filename\":\"product-77.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-77.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-77\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(51,95,'ecommerce/digital-product-files/product-81.jpg','{\"filename\":\"product-81.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-81.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-81\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(52,95,'ecommerce/digital-product-files/product-86.jpg','{\"filename\":\"product-86.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-86.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:01\",\"name\":\"product-86\",\"extension\":\"jpg\"}','2026-02-09 00:19:01','2026-02-09 00:19:01'),(53,103,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(54,103,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(55,103,'ecommerce/digital-product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(56,103,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(57,103,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(58,103,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(59,103,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(60,103,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(61,103,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(62,103,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(63,103,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(64,103,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(65,104,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(66,104,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(67,104,'ecommerce/digital-product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(68,104,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(69,104,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(70,104,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(71,104,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(72,104,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(73,104,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(74,104,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(75,104,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(76,104,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(77,105,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(78,105,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(79,105,'ecommerce/digital-product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(80,105,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(81,105,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(82,105,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(83,105,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(84,105,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(85,105,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(86,105,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(87,105,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(88,105,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(89,115,'ecommerce/digital-product-files/product-55.jpg','{\"filename\":\"product-55.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-55.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-55\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(90,115,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(91,115,'ecommerce/digital-product-files/product-73.jpg','{\"filename\":\"product-73.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-73.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-73\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(92,115,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(93,115,'ecommerce/digital-product-files/product-77.jpg','{\"filename\":\"product-77.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-77.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-77\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(94,116,'ecommerce/digital-product-files/product-55.jpg','{\"filename\":\"product-55.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-55.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-55\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(95,116,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(96,116,'ecommerce/digital-product-files/product-73.jpg','{\"filename\":\"product-73.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-73.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-73\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(97,116,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(98,116,'ecommerce/digital-product-files/product-77.jpg','{\"filename\":\"product-77.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-77.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:02\",\"name\":\"product-77\",\"extension\":\"jpg\"}','2026-02-09 00:19:02','2026-02-09 00:19:02'),(99,122,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(100,122,'ecommerce/digital-product-files/product-35.jpg','{\"filename\":\"product-35.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-35.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-35\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(101,122,'ecommerce/digital-product-files/product-37.jpg','{\"filename\":\"product-37.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-37.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-37\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(102,122,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(103,122,'ecommerce/digital-product-files/product-66.jpg','{\"filename\":\"product-66.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-66.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-66\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(104,122,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(105,122,'ecommerce/digital-product-files/product-89.jpg','{\"filename\":\"product-89.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-89.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-89\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(106,123,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(107,123,'ecommerce/digital-product-files/product-35.jpg','{\"filename\":\"product-35.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-35.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-35\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(108,123,'ecommerce/digital-product-files/product-37.jpg','{\"filename\":\"product-37.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-37.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-37\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(109,123,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(110,123,'ecommerce/digital-product-files/product-66.jpg','{\"filename\":\"product-66.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-66.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-66\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(111,123,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(112,123,'ecommerce/digital-product-files/product-89.jpg','{\"filename\":\"product-89.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-89.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-89\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(113,133,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(114,133,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(115,133,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(116,133,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(117,133,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(118,133,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(119,133,'ecommerce/digital-product-files/product-54.jpg','{\"filename\":\"product-54.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-54.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-54\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(120,133,'ecommerce/digital-product-files/product-57.jpg','{\"filename\":\"product-57.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-57.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-57\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(121,133,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(122,133,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(123,133,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(124,134,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(125,134,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(126,134,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(127,134,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(128,134,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(129,134,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(130,134,'ecommerce/digital-product-files/product-54.jpg','{\"filename\":\"product-54.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-54.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-54\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(131,134,'ecommerce/digital-product-files/product-57.jpg','{\"filename\":\"product-57.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-57.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-57\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(132,134,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(133,134,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(134,134,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(135,135,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(136,135,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(137,135,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(138,135,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(139,135,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(140,135,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(141,135,'ecommerce/digital-product-files/product-54.jpg','{\"filename\":\"product-54.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-54.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-54\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(142,135,'ecommerce/digital-product-files/product-57.jpg','{\"filename\":\"product-57.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-57.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-57\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(143,135,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(144,135,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(145,135,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:03\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:03','2026-02-09 00:19:03'),(146,136,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(147,136,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(148,136,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(149,136,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(150,136,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(151,136,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(152,136,'ecommerce/digital-product-files/product-54.jpg','{\"filename\":\"product-54.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-54.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-54\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(153,136,'ecommerce/digital-product-files/product-57.jpg','{\"filename\":\"product-57.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-57.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-57\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(154,136,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(155,136,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(156,136,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(157,146,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(158,146,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(159,146,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(160,146,'ecommerce/digital-product-files/product-29.jpg','{\"filename\":\"product-29.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-29.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-29\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(161,146,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(162,146,'ecommerce/digital-product-files/product-45.jpg','{\"filename\":\"product-45.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-45.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-45\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(163,146,'ecommerce/digital-product-files/product-68.jpg','{\"filename\":\"product-68.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-68.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-68\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(164,147,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(165,147,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(166,147,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(167,147,'ecommerce/digital-product-files/product-29.jpg','{\"filename\":\"product-29.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-29.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-29\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(168,147,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(169,147,'ecommerce/digital-product-files/product-45.jpg','{\"filename\":\"product-45.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-45.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-45\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(170,147,'ecommerce/digital-product-files/product-68.jpg','{\"filename\":\"product-68.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-68.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:04\",\"name\":\"product-68\",\"extension\":\"jpg\"}','2026-02-09 00:19:04','2026-02-09 00:19:04'),(171,157,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(172,157,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(173,157,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(174,157,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(175,157,'ecommerce/digital-product-files/product-61.jpg','{\"filename\":\"product-61.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-61.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-61\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(176,157,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(177,157,'ecommerce/digital-product-files/product-85.jpg','{\"filename\":\"product-85.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-85.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-85\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(178,158,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(179,158,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(180,158,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(181,158,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(182,158,'ecommerce/digital-product-files/product-61.jpg','{\"filename\":\"product-61.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-61.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-61\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(183,158,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(184,158,'ecommerce/digital-product-files/product-85.jpg','{\"filename\":\"product-85.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-85.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-85\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(185,164,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(186,164,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(187,164,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(188,164,'ecommerce/digital-product-files/product-27.jpg','{\"filename\":\"product-27.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-27.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-27\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(189,164,'ecommerce/digital-product-files/product-45.jpg','{\"filename\":\"product-45.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-45.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-45\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(190,164,'ecommerce/digital-product-files/product-58.jpg','{\"filename\":\"product-58.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-58.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-58\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(191,164,'ecommerce/digital-product-files/product-69.jpg','{\"filename\":\"product-69.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-69.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-69\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(192,165,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(193,165,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(194,165,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(195,165,'ecommerce/digital-product-files/product-27.jpg','{\"filename\":\"product-27.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-27.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-27\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(196,165,'ecommerce/digital-product-files/product-45.jpg','{\"filename\":\"product-45.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-45.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-45\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(197,165,'ecommerce/digital-product-files/product-58.jpg','{\"filename\":\"product-58.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-58.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-58\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(198,165,'ecommerce/digital-product-files/product-69.jpg','{\"filename\":\"product-69.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-69.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-69\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(199,176,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(200,176,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(201,176,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(202,176,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(203,176,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(204,176,'ecommerce/digital-product-files/product-40.jpg','{\"filename\":\"product-40.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-40.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-40\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(205,176,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(206,176,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(207,176,'ecommerce/digital-product-files/product-77.jpg','{\"filename\":\"product-77.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-77.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-77\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(208,177,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(209,177,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(210,177,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(211,177,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(212,177,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(213,177,'ecommerce/digital-product-files/product-40.jpg','{\"filename\":\"product-40.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-40.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-40\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(214,177,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(215,177,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(216,177,'ecommerce/digital-product-files/product-77.jpg','{\"filename\":\"product-77.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-77.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:05\",\"name\":\"product-77\",\"extension\":\"jpg\"}','2026-02-09 00:19:05','2026-02-09 00:19:05'),(217,186,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(218,186,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(219,186,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(220,186,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(221,186,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(222,187,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(223,187,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(224,187,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(225,187,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(226,187,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(227,188,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(228,188,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(229,188,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(230,188,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(231,188,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(232,196,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(233,196,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(234,196,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(235,196,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(236,196,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(237,196,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(238,196,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(239,196,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(240,196,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(241,196,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(242,197,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(243,197,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(244,197,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(245,197,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(246,197,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(247,197,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(248,197,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(249,197,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(250,197,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(251,197,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:06\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:06','2026-02-09 00:19:06'),(252,198,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(253,198,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(254,198,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(255,198,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(256,198,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(257,198,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(258,198,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(259,198,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(260,198,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(261,198,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(262,204,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(263,204,'ecommerce/digital-product-files/product-22.jpg','{\"filename\":\"product-22.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-22.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-22\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(264,204,'ecommerce/digital-product-files/product-30.jpg','{\"filename\":\"product-30.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-30.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-30\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(265,204,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(266,204,'ecommerce/digital-product-files/product-41.jpg','{\"filename\":\"product-41.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-41.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-41\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(267,204,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(268,204,'ecommerce/digital-product-files/product-63.jpg','{\"filename\":\"product-63.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-63.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-63\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(269,204,'ecommerce/digital-product-files/product-86.jpg','{\"filename\":\"product-86.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-86.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-86\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(270,205,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(271,205,'ecommerce/digital-product-files/product-22.jpg','{\"filename\":\"product-22.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-22.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-22\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(272,205,'ecommerce/digital-product-files/product-30.jpg','{\"filename\":\"product-30.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-30.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-30\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(273,205,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(274,205,'ecommerce/digital-product-files/product-41.jpg','{\"filename\":\"product-41.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-41.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-41\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(275,205,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(276,205,'ecommerce/digital-product-files/product-63.jpg','{\"filename\":\"product-63.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-63.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-63\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(277,205,'ecommerce/digital-product-files/product-86.jpg','{\"filename\":\"product-86.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-86.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-86\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(278,214,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(279,214,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(280,214,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(281,214,'ecommerce/digital-product-files/product-22.jpg','{\"filename\":\"product-22.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-22.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-22\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(282,214,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(283,214,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(284,214,'ecommerce/digital-product-files/product-53.jpg','{\"filename\":\"product-53.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-53.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-53\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(285,214,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(286,214,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(287,214,'ecommerce/digital-product-files/product-90.jpg','{\"filename\":\"product-90.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-90.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-90\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(288,214,'ecommerce/digital-product-files/product-92.jpg','{\"filename\":\"product-92.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-92.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-92\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(289,215,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(290,215,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(291,215,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(292,215,'ecommerce/digital-product-files/product-22.jpg','{\"filename\":\"product-22.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-22.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-22\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(293,215,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(294,215,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(295,215,'ecommerce/digital-product-files/product-53.jpg','{\"filename\":\"product-53.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-53.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-53\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(296,215,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(297,215,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(298,215,'ecommerce/digital-product-files/product-90.jpg','{\"filename\":\"product-90.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-90.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-90\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(299,215,'ecommerce/digital-product-files/product-92.jpg','{\"filename\":\"product-92.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-92.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-92\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(300,216,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(301,216,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:07\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2026-02-09 00:19:07','2026-02-09 00:19:07'),(302,216,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(303,216,'ecommerce/digital-product-files/product-22.jpg','{\"filename\":\"product-22.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-22.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-22\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(304,216,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(305,216,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(306,216,'ecommerce/digital-product-files/product-53.jpg','{\"filename\":\"product-53.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-53.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-53\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(307,216,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(308,216,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(309,216,'ecommerce/digital-product-files/product-90.jpg','{\"filename\":\"product-90.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-90.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-90\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(310,216,'ecommerce/digital-product-files/product-92.jpg','{\"filename\":\"product-92.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-92.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-92\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(311,224,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(312,224,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(313,224,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(314,224,'ecommerce/digital-product-files/product-63.jpg','{\"filename\":\"product-63.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-63.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-63\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(315,224,'ecommerce/digital-product-files/product-93.jpg','{\"filename\":\"product-93.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-93.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-93\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(316,225,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(317,225,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(318,225,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(319,225,'ecommerce/digital-product-files/product-63.jpg','{\"filename\":\"product-63.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-63.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-63\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(320,225,'ecommerce/digital-product-files/product-93.jpg','{\"filename\":\"product-93.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-93.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-93\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(321,232,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(322,232,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(323,232,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(324,232,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(325,232,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(326,232,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(327,232,'ecommerce/digital-product-files/product-45.jpg','{\"filename\":\"product-45.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-45.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-45\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(328,232,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(329,232,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(330,232,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(331,232,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(332,233,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(333,233,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(334,233,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(335,233,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(336,233,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(337,233,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(338,233,'ecommerce/digital-product-files/product-45.jpg','{\"filename\":\"product-45.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-45.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-45\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(339,233,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(340,233,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(341,233,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(342,233,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(343,234,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(344,234,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(345,234,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(346,234,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(347,234,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(348,234,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(349,234,'ecommerce/digital-product-files/product-45.jpg','{\"filename\":\"product-45.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-45.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-45\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(350,234,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(351,234,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(352,234,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(353,234,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:08\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2026-02-09 00:19:08','2026-02-09 00:19:08'),(354,244,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(355,244,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(356,244,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(357,244,'ecommerce/digital-product-files/product-53.jpg','{\"filename\":\"product-53.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-53.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-53\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(358,244,'ecommerce/digital-product-files/product-69.jpg','{\"filename\":\"product-69.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-69.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-69\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(359,245,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(360,245,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(361,245,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(362,245,'ecommerce/digital-product-files/product-53.jpg','{\"filename\":\"product-53.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-53.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-53\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(363,245,'ecommerce/digital-product-files/product-69.jpg','{\"filename\":\"product-69.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-69.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-69\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(364,252,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(365,252,'ecommerce/digital-product-files/product-15.jpg','{\"filename\":\"product-15.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-15.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-15\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(366,252,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(367,252,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(368,252,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(369,252,'ecommerce/digital-product-files/product-56.jpg','{\"filename\":\"product-56.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-56.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-56\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(370,252,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(371,252,'ecommerce/digital-product-files/product-61.jpg','{\"filename\":\"product-61.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-61.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-61\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(372,252,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(373,252,'ecommerce/digital-product-files/product-73.jpg','{\"filename\":\"product-73.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-73.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-73\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(374,252,'ecommerce/digital-product-files/product-81.jpg','{\"filename\":\"product-81.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-81.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-81\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09'),(375,252,'ecommerce/digital-product-files/product-90.jpg','{\"filename\":\"product-90.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-90.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2026-02-09 07:19:09\",\"name\":\"product-90\",\"extension\":\"jpg\"}','2026-02-09 00:19:09','2026-02-09 00:19:09');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,7),(1,14),(1,35),(1,63),(1,70),(2,28),(2,49),(3,21),(3,42),(3,56);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `text_color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_labels_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#d71e2d','published','2026-02-09 00:18:48','2026-02-09 00:18:48','#ffffff'),(2,'New','#02856e','published','2026-02-09 00:18:48','2026-02-09 00:18:48','#ffffff'),(3,'Sale','#fe9931','published','2026-02-09 00:18:48','2026-02-09 00:18:48','#ffffff');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`),
  KEY `idx_product_labels_fk` (`ec_product_labels_id`),
  KEY `idx_product_labels_product_labels_lang` (`ec_product_labels_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_license_codes`
--

DROP TABLE IF EXISTS `ec_product_license_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_license_codes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `license_code` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `assigned_order_product_id` bigint unsigned DEFAULT NULL,
  `assigned_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_license_codes_product_id_status_index` (`product_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_license_codes`
--

LOCK TABLES `ec_product_license_codes` WRITE;
/*!40000 ALTER TABLE `ec_product_license_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_license_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_specification_attribute`
--

DROP TABLE IF EXISTS `ec_product_specification_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_specification_attribute` (
  `product_id` bigint unsigned NOT NULL,
  `attribute_id` bigint unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `order` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_specification_attribute`
--

LOCK TABLES `ec_product_specification_attribute` WRITE;
/*!40000 ALTER TABLE `ec_product_specification_attribute` DISABLE KEYS */;
INSERT INTO `ec_product_specification_attribute` VALUES (1,6,'49.63 cm',0,0),(1,7,'4.8 cm',0,0),(1,8,'2560x1440',0,0),(2,6,'36.84 cm',0,0),(2,7,'41.58 cm',0,0),(2,8,'2560x1440',0,0),(3,1,'7.43 cm',0,0),(3,2,'49.83 cm',0,0),(3,3,'22.61 cm',0,0),(3,4,'63.26 cm',0,0),(3,5,'75.83 cm',0,0),(4,1,'22.68 cm',0,0),(4,2,'35.55 cm',0,0),(4,3,'35.38 cm',0,0),(4,4,'85.31 cm',0,0),(4,5,'42.37 cm',0,0),(5,6,'17.21 cm',0,0),(5,7,'85.25 cm',0,0),(5,8,'1920x1080',0,0),(6,6,'6.09 cm',0,0),(6,7,'66.53 cm',0,0),(6,8,'2560x1440',0,0),(7,6,'47.54 cm',0,0),(7,7,'20.22 cm',0,0),(7,8,'1920x1080',0,0),(8,1,'67.37 cm',0,0),(8,2,'90.27 cm',0,0),(8,3,'78.43 cm',0,0),(8,4,'29.97 cm',0,0),(8,5,'74.45 cm',0,0),(9,6,'34.94 cm',0,0),(9,7,'44.77 cm',0,0),(9,8,'1920x1080',0,0),(10,1,'92.96 cm',0,0),(10,2,'30.88 cm',0,0),(10,3,'16.11 cm',0,0),(10,4,'38.91 cm',0,0),(10,5,'19.96 cm',0,0),(11,6,'50.4 cm',0,0),(11,7,'4.83 cm',0,0),(11,8,'2560x1440',0,0),(12,1,'97.89 cm',0,0),(12,2,'73.46 cm',0,0),(12,3,'30.44 cm',0,0),(12,4,'70.3 cm',0,0),(12,5,'47.61 cm',0,0),(13,1,'77.03 cm',0,0),(13,2,'48.68 cm',0,0),(13,3,'38.55 cm',0,0),(13,4,'19.38 cm',0,0),(13,5,'13.26 cm',0,0),(14,1,'88.33 cm',0,0),(14,2,'25.99 cm',0,0),(14,3,'63.1 cm',0,0),(14,4,'27.21 cm',0,0),(14,5,'20.42 cm',0,0),(15,1,'52.6 cm',0,0),(15,2,'32.34 cm',0,0),(15,3,'87.13 cm',0,0),(15,4,'46.45 cm',0,0),(15,5,'4.26 cm',0,0),(16,6,'37.75 cm',0,0),(16,7,'60.3 cm',0,0),(16,8,'2560x1440',0,0),(17,1,'27.93 cm',0,0),(17,2,'24.97 cm',0,0),(17,3,'48.37 cm',0,0),(17,4,'8.79 cm',0,0),(17,5,'82.25 cm',0,0),(18,1,'20.72 cm',0,0),(18,2,'70.64 cm',0,0),(18,3,'37.38 cm',0,0),(18,4,'61.57 cm',0,0),(18,5,'5.9 cm',0,0),(19,1,'43.73 cm',0,0),(19,2,'50.11 cm',0,0),(19,3,'64.65 cm',0,0),(19,4,'15.97 cm',0,0),(19,5,'1.85 cm',0,0),(20,6,'90.39 cm',0,0),(20,7,'5.36 cm',0,0),(20,8,'3840x2160',0,0),(21,1,'24.07 cm',0,0),(21,2,'18.29 cm',0,0),(21,3,'27.21 cm',0,0),(21,4,'84.14 cm',0,0),(21,5,'91.7 cm',0,0),(22,6,'39.56 cm',0,0),(22,7,'30.03 cm',0,0),(22,8,'2560x1440',0,0),(23,1,'42.57 cm',0,0),(23,2,'89.08 cm',0,0),(23,3,'56.62 cm',0,0),(23,4,'91.77 cm',0,0),(23,5,'8.41 cm',0,0),(24,1,'8.05 cm',0,0),(24,2,'82.95 cm',0,0),(24,3,'20.73 cm',0,0),(24,4,'76.98 cm',0,0),(24,5,'68.24 cm',0,0),(25,1,'99.69 cm',0,0),(25,2,'3.77 cm',0,0),(25,3,'45.09 cm',0,0),(25,4,'36.9 cm',0,0),(25,5,'34.8 cm',0,0),(26,1,'91.13 cm',0,0),(26,2,'68.49 cm',0,0),(26,3,'77.04 cm',0,0),(26,4,'6.57 cm',0,0),(26,5,'83.95 cm',0,0),(27,6,'35.23 cm',0,0),(27,7,'87.24 cm',0,0),(27,8,'1920x1080',0,0),(28,1,'78.98 cm',0,0),(28,2,'46.76 cm',0,0),(28,3,'54.39 cm',0,0),(28,4,'43.88 cm',0,0),(28,5,'50.86 cm',0,0),(29,1,'34.93 cm',0,0),(29,2,'95.64 cm',0,0),(29,3,'97.37 cm',0,0),(29,4,'66.06 cm',0,0),(29,5,'91.97 cm',0,0),(30,6,'36.91 cm',0,0),(30,7,'37.6 cm',0,0),(30,8,'1920x1080',0,0),(31,1,'52.87 cm',0,0),(31,2,'76.15 cm',0,0),(31,3,'77.35 cm',0,0),(31,4,'87.82 cm',0,0),(31,5,'24.57 cm',0,0),(32,1,'50.9 cm',0,0),(32,2,'11.08 cm',0,0),(32,3,'61.58 cm',0,0),(32,4,'98.08 cm',0,0),(32,5,'73.18 cm',0,0),(33,6,'90.03 cm',0,0),(33,7,'93.43 cm',0,0),(33,8,'3840x2160',0,0),(34,1,'78.54 cm',0,0),(34,2,'2.46 cm',0,0),(34,3,'89.24 cm',0,0),(34,4,'1.75 cm',0,0),(34,5,'56.13 cm',0,0),(35,1,'95.07 cm',0,0),(35,2,'59.88 cm',0,0),(35,3,'73.27 cm',0,0),(35,4,'32.54 cm',0,0),(35,5,'10.92 cm',0,0),(36,1,'74.94 cm',0,0),(36,2,'75.4 cm',0,0),(36,3,'5.08 cm',0,0),(36,4,'86.37 cm',0,0),(36,5,'79.99 cm',0,0),(37,1,'60.68 cm',0,0),(37,2,'88.77 cm',0,0),(37,3,'12.3 cm',0,0),(37,4,'10.1 cm',0,0),(37,5,'48.99 cm',0,0),(38,6,'7.64 cm',0,0),(38,7,'28.53 cm',0,0),(38,8,'1920x1080',0,0),(39,6,'82.94 cm',0,0),(39,7,'72.97 cm',0,0),(39,8,'1920x1080',0,0),(40,6,'69.1 cm',0,0),(40,7,'88.75 cm',0,0),(40,8,'1920x1080',0,0),(41,6,'14.22 cm',0,0),(41,7,'79.96 cm',0,0),(41,8,'1920x1080',0,0),(42,1,'75.8 cm',0,0),(42,2,'61.32 cm',0,0),(42,3,'52.31 cm',0,0),(42,4,'21.11 cm',0,0),(42,5,'54.09 cm',0,0),(43,1,'1.55 cm',0,0),(43,2,'27.34 cm',0,0),(43,3,'68.88 cm',0,0),(43,4,'15.39 cm',0,0),(43,5,'99.61 cm',0,0),(44,6,'95.66 cm',0,0),(44,7,'44.44 cm',0,0),(44,8,'2560x1440',0,0),(45,6,'96.33 cm',0,0),(45,7,'4.95 cm',0,0),(45,8,'3840x2160',0,0),(46,1,'32.25 cm',0,0),(46,2,'99.52 cm',0,0),(46,3,'32.22 cm',0,0),(46,4,'10.55 cm',0,0),(46,5,'94.44 cm',0,0),(47,6,'50.88 cm',0,0),(47,7,'9.49 cm',0,0),(47,8,'2560x1440',0,0),(48,1,'73.7 cm',0,0),(48,2,'97.07 cm',0,0),(48,3,'25.45 cm',0,0),(48,4,'81.38 cm',0,0),(48,5,'4.62 cm',0,0),(49,6,'37.68 cm',0,0),(49,7,'73.99 cm',0,0),(49,8,'3840x2160',0,0),(50,6,'41.92 cm',0,0),(50,7,'95.08 cm',0,0),(50,8,'1920x1080',0,0),(51,1,'20.44 cm',0,0),(51,2,'8.9 cm',0,0),(51,3,'44.29 cm',0,0),(51,4,'78.38 cm',0,0),(51,5,'43.87 cm',0,0),(52,1,'13.69 cm',0,0),(52,2,'65.43 cm',0,0),(52,3,'39.3 cm',0,0),(52,4,'85.27 cm',0,0),(52,5,'40.12 cm',0,0),(53,6,'91.18 cm',0,0),(53,7,'58.95 cm',0,0),(53,8,'3840x2160',0,0),(54,1,'39.12 cm',0,0),(54,2,'1.26 cm',0,0),(54,3,'23.53 cm',0,0),(54,4,'42.22 cm',0,0),(54,5,'26.97 cm',0,0),(55,1,'54.05 cm',0,0),(55,2,'13.83 cm',0,0),(55,3,'41.61 cm',0,0),(55,4,'78.92 cm',0,0),(55,5,'4.27 cm',0,0),(56,1,'26.53 cm',0,0),(56,2,'24.73 cm',0,0),(56,3,'59.15 cm',0,0),(56,4,'7.15 cm',0,0),(56,5,'25.99 cm',0,0),(57,1,'72.11 cm',0,0),(57,2,'47.68 cm',0,0),(57,3,'30.07 cm',0,0),(57,4,'91.79 cm',0,0),(57,5,'76.67 cm',0,0),(58,6,'40.74 cm',0,0),(58,7,'12.52 cm',0,0),(58,8,'2560x1440',0,0),(59,1,'63.47 cm',0,0),(59,2,'26.69 cm',0,0),(59,3,'55.44 cm',0,0),(59,4,'66.87 cm',0,0),(59,5,'55.98 cm',0,0),(60,1,'38 cm',0,0),(60,2,'34.18 cm',0,0),(60,3,'52.18 cm',0,0),(60,4,'43.22 cm',0,0),(60,5,'19.23 cm',0,0),(61,6,'20.46 cm',0,0),(61,7,'24.91 cm',0,0),(61,8,'2560x1440',0,0),(62,6,'15.92 cm',0,0),(62,7,'62.94 cm',0,0),(62,8,'1920x1080',0,0),(63,6,'34.66 cm',0,0),(63,7,'75.72 cm',0,0),(63,8,'3840x2160',0,0),(64,1,'43.49 cm',0,0),(64,2,'88.19 cm',0,0),(64,3,'95.41 cm',0,0),(64,4,'91.89 cm',0,0),(64,5,'63.22 cm',0,0),(65,6,'73.89 cm',0,0),(65,7,'31.65 cm',0,0),(65,8,'2560x1440',0,0),(66,1,'92.27 cm',0,0),(66,2,'73.93 cm',0,0),(66,3,'72.46 cm',0,0),(66,4,'92.68 cm',0,0),(66,5,'60.41 cm',0,0),(67,6,'4.61 cm',0,0),(67,7,'52.39 cm',0,0),(67,8,'3840x2160',0,0),(68,6,'13.48 cm',0,0),(68,7,'45.6 cm',0,0),(68,8,'2560x1440',0,0),(69,6,'57.83 cm',0,0),(69,7,'38.71 cm',0,0),(69,8,'1920x1080',0,0),(70,6,'14.94 cm',0,0),(70,7,'80.72 cm',0,0),(70,8,'1920x1080',0,0),(71,1,'97.8 cm',0,0),(71,2,'73.22 cm',0,0),(71,3,'73.36 cm',0,0),(71,4,'43.78 cm',0,0),(71,5,'34.61 cm',0,0),(72,1,'44.02 cm',0,0),(72,2,'86.44 cm',0,0),(72,3,'93.88 cm',0,0),(72,4,'36.61 cm',0,0),(72,5,'76.31 cm',0,0),(73,6,'51.26 cm',0,0),(73,7,'55 cm',0,0),(73,8,'3840x2160',0,0),(74,6,'56.44 cm',0,0),(74,7,'61.7 cm',0,0),(74,8,'3840x2160',0,0),(75,1,'19.26 cm',0,0),(75,2,'48.03 cm',0,0),(75,3,'99.76 cm',0,0),(75,4,'66.38 cm',0,0),(75,5,'81.51 cm',0,0);
/*!40000 ALTER TABLE `ec_product_specification_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_specification_attribute_translations`
--

DROP TABLE IF EXISTS `ec_product_specification_attribute_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_specification_attribute_translations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `attribute_id` bigint unsigned NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `psat_unique` (`product_id`,`attribute_id`,`lang_code`),
  KEY `psat_product_attribute_index` (`product_id`,`attribute_id`),
  KEY `psat_product_id_index` (`product_id`),
  KEY `psat_attribute_id_index` (`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_specification_attribute_translations`
--

LOCK TABLES `ec_product_specification_attribute_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_specification_attribute_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_specification_attribute_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,3),(1,4),(2,3),(2,5),(3,2),(3,4),(3,6),(4,1),(4,4),(4,6),(5,3),(5,5),(6,2),(6,3),(6,6),(7,1),(7,2),(7,5),(8,2),(8,5),(8,6),(9,1),(9,3),(10,2),(10,4),(10,5),(11,2),(11,3),(11,5),(12,5),(12,6),(13,3),(13,6),(14,2),(14,5),(15,1),(15,3),(16,1),(16,3),(16,5),(17,2),(17,6),(18,2),(18,3),(19,2),(19,3),(20,2),(20,4),(20,5),(21,5),(21,6),(22,1),(22,3),(22,6),(23,3),(23,5),(24,2),(24,4),(24,5),(25,1),(25,2),(25,5),(26,3),(26,4),(27,1),(27,5),(28,1),(28,2),(28,6),(29,2),(29,4),(29,5),(30,3),(30,4),(30,5),(31,1),(31,4),(32,4),(32,5),(32,6),(33,1),(33,3),(34,3),(35,1),(35,4),(35,5),(36,3),(36,6),(37,1),(37,5),(38,1),(38,4),(39,2),(39,3),(39,6),(40,2),(40,3),(40,4),(41,5),(41,6),(42,2),(42,3),(42,5),(43,2),(44,1),(44,3),(44,4),(45,2),(45,5),(45,6),(46,4),(46,5),(47,1),(47,4),(48,1),(48,2),(48,3),(49,3),(49,4),(49,5),(50,3),(50,6),(51,3),(51,4),(52,2),(52,3),(53,2),(53,4),(53,5),(54,2),(54,3),(54,5),(55,1),(55,5),(56,1),(56,2),(56,6),(57,2),(57,4),(57,6),(58,1),(58,2),(59,1),(59,2),(59,3),(60,3),(60,5),(61,1),(61,4),(62,1),(62,2),(63,1),(63,5),(64,1),(64,3),(64,5),(65,3),(65,5),(65,6),(66,2),(66,3),(66,4),(67,2),(67,4),(67,5),(68,2),(68,4),(68,6),(69,2),(69,5),(70,3),(70,4),(71,2),(71,3),(71,5),(72,5),(72,6),(73,2),(73,5),(74,4),(74,5),(75,1),(75,6);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(2,'Mobile',NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(3,'Iphone',NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(4,'Printer',NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(5,'Office',NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(6,'IT',NULL,'published','2026-02-09 00:18:48','2026-02-09 00:18:48');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`),
  KEY `idx_product_tags_fk` (`ec_product_tags_id`),
  KEY `idx_product_tags_product_tags_lang` (`ec_product_tags_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_up_sale_relations` VALUES (1,2,0,32.00,'fixed',1),(1,65,0,20.00,'percent',1),(2,49,0,15.00,'percent',1),(2,58,0,14.00,'percent',1),(3,19,0,23.00,'fixed',1),(3,73,0,14.00,'fixed',1),(4,9,0,16.00,'percent',1),(5,68,0,6.00,'percent',1),(5,73,0,20.00,'fixed',1),(6,27,0,10.00,'percent',1),(6,72,0,50.00,'fixed',1),(7,12,0,16.00,'percent',1),(7,71,0,10.00,'percent',1),(8,2,0,12.00,'fixed',1),(8,71,0,12.00,'percent',1),(9,30,0,9.00,'percent',1),(9,35,0,9.00,'percent',1),(10,55,0,17.00,'fixed',1),(10,70,0,13.00,'percent',1),(11,1,0,17.00,'fixed',1),(11,8,0,17.00,'percent',1),(12,25,0,35.00,'fixed',1),(12,73,0,23.00,'fixed',1),(13,26,0,44.00,'fixed',1),(13,69,0,25.00,'fixed',1),(14,9,0,9.00,'fixed',1),(14,16,0,25.00,'fixed',1),(15,41,0,18.00,'fixed',1),(15,47,0,16.00,'percent',1),(16,17,0,8.00,'percent',1),(16,57,0,41.00,'fixed',1),(17,30,0,21.00,'fixed',1),(17,32,0,22.00,'fixed',1),(18,35,0,6.00,'percent',1),(18,40,0,14.00,'percent',1),(19,26,0,31.00,'fixed',1),(19,28,0,8.00,'percent',1),(20,15,0,17.00,'fixed',1),(20,73,0,24.00,'fixed',1),(21,11,0,17.00,'percent',1),(21,27,0,11.00,'percent',1),(22,23,0,16.00,'percent',1),(22,49,0,10.00,'percent',1),(23,25,0,17.00,'fixed',1),(23,56,0,18.00,'percent',1),(24,26,0,44.00,'fixed',1),(24,51,0,10.00,'percent',1),(25,21,0,19.00,'fixed',1),(25,75,0,18.00,'percent',1),(26,57,0,50.00,'fixed',1),(26,74,0,7.00,'percent',1),(27,41,0,29.00,'fixed',1),(27,66,0,17.00,'percent',1),(28,4,0,13.00,'percent',1),(28,21,0,13.00,'percent',1),(29,16,0,15.00,'fixed',1),(29,24,0,7.00,'percent',1),(30,24,0,44.00,'fixed',1),(30,64,0,42.00,'fixed',1),(31,47,0,32.00,'fixed',1),(31,62,0,12.00,'percent',1),(32,33,0,26.00,'fixed',1),(33,60,0,16.00,'percent',1),(33,66,0,13.00,'percent',1),(34,11,0,32.00,'fixed',1),(34,17,0,7.00,'percent',1),(35,17,0,36.00,'fixed',1),(35,34,0,42.00,'fixed',1),(36,19,0,7.00,'percent',1),(36,52,0,6.00,'percent',1),(37,32,0,9.00,'percent',1),(38,15,0,25.00,'fixed',1),(38,63,0,8.00,'percent',1),(39,44,0,14.00,'percent',1),(39,55,0,26.00,'fixed',1),(40,25,0,14.00,'percent',1),(40,28,0,15.00,'fixed',1),(41,30,0,16.00,'percent',1),(41,75,0,28.00,'fixed',1),(42,27,0,19.00,'fixed',1),(42,39,0,13.00,'percent',1),(43,45,0,33.00,'fixed',1),(43,56,0,10.00,'percent',1),(44,31,0,22.00,'fixed',1),(44,33,0,30.00,'fixed',1),(45,22,0,39.00,'fixed',1),(45,48,0,35.00,'fixed',1),(46,53,0,39.00,'fixed',1),(46,55,0,10.00,'fixed',1),(47,34,0,5.00,'percent',1),(47,49,0,19.00,'percent',1),(48,22,0,6.00,'percent',1),(48,74,0,13.00,'percent',1),(49,37,0,25.00,'fixed',1),(49,45,0,15.00,'percent',1),(50,4,0,12.00,'percent',1),(50,21,0,5.00,'percent',1),(51,36,0,5.00,'percent',1),(51,60,0,42.00,'fixed',1),(52,65,0,20.00,'percent',1),(52,69,0,7.00,'percent',1),(53,6,0,16.00,'percent',1),(53,42,0,18.00,'percent',1),(54,38,0,7.00,'percent',1),(54,62,0,8.00,'percent',1),(55,17,0,19.00,'fixed',1),(55,33,0,18.00,'percent',1),(56,46,0,44.00,'fixed',1),(56,68,0,23.00,'fixed',1),(57,16,0,19.00,'percent',1),(57,55,0,29.00,'fixed',1),(58,53,0,20.00,'percent',1),(58,64,0,8.00,'fixed',1),(59,15,0,16.00,'percent',1),(59,50,0,15.00,'percent',1),(60,3,0,30.00,'fixed',1),(60,55,0,19.00,'percent',1),(61,2,0,32.00,'fixed',1),(61,25,0,20.00,'percent',1),(62,7,0,40.00,'fixed',1),(62,72,0,39.00,'fixed',1),(63,23,0,14.00,'percent',1),(63,62,0,16.00,'fixed',1),(64,25,0,13.00,'percent',1),(64,58,0,5.00,'percent',1),(65,16,0,16.00,'percent',1),(65,68,0,10.00,'percent',1),(66,8,0,20.00,'percent',1),(66,56,0,27.00,'fixed',1),(67,4,0,17.00,'percent',1),(67,56,0,33.00,'fixed',1),(68,16,0,10.00,'fixed',1),(68,57,0,16.00,'percent',1),(69,48,0,5.00,'percent',1),(69,64,0,32.00,'fixed',1),(70,22,0,39.00,'fixed',1),(70,30,0,20.00,'percent',1),(71,20,0,40.00,'fixed',1),(71,75,0,7.00,'percent',1),(72,43,0,17.00,'percent',1),(72,62,0,27.00,'fixed',1),(73,24,0,19.00,'percent',1),(73,31,0,17.00,'fixed',1),(74,63,0,19.00,'percent',1),(74,65,0,6.00,'percent',1),(75,35,0,18.00,'percent',1),(75,54,0,12.00,'percent',1);
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variation_items_attribute_id_variation_id_unique` (`attribute_id`,`variation_id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`),
  KEY `idx_variation_id` (`variation_id`),
  KEY `idx_variation_attribute_covering` (`variation_id`,`attribute_id`),
  KEY `ec_product_variation_items_variation_id_attribute_id_index` (`variation_id`,`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=365 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (3,1,2),(17,1,9),(49,1,25),(77,1,39),(95,1,48),(97,1,49),(105,1,53),(123,1,62),(125,1,63),(127,1,64),(137,1,69),(147,1,74),(171,1,86),(175,1,88),(187,1,94),(189,1,95),(193,1,97),(199,1,100),(207,1,104),(211,1,106),(215,1,108),(239,1,120),(241,1,121),(245,1,123),(251,1,126),(269,1,135),(273,1,137),(291,1,146),(293,1,147),(305,1,153),(325,1,163),(329,1,165),(331,1,166),(341,1,171),(359,1,180),(363,1,182),(19,2,10),(39,2,20),(41,2,21),(47,2,24),(53,2,27),(59,2,30),(69,2,35),(73,2,37),(75,2,38),(89,2,45),(99,2,50),(143,2,72),(149,2,75),(173,2,87),(177,2,89),(191,2,96),(195,2,98),(209,2,105),(217,2,109),(235,2,118),(253,2,127),(263,2,132),(277,2,139),(279,2,140),(281,2,141),(285,2,143),(295,2,148),(343,2,172),(345,2,173),(351,2,176),(353,2,177),(357,2,179),(5,3,3),(9,3,5),(21,3,11),(25,3,13),(37,3,19),(51,3,26),(61,3,31),(67,3,34),(79,3,40),(81,3,41),(83,3,42),(87,3,44),(111,3,56),(129,3,65),(131,3,66),(133,3,67),(141,3,71),(151,3,76),(161,3,81),(181,3,91),(183,3,92),(225,3,113),(227,3,114),(255,3,128),(265,3,133),(283,3,142),(299,3,150),(301,3,151),(311,3,156),(319,3,160),(327,3,164),(339,3,170),(347,3,174),(355,3,178),(11,4,6),(13,4,7),(15,4,8),(23,4,12),(27,4,14),(31,4,16),(43,4,22),(45,4,23),(57,4,29),(63,4,32),(71,4,36),(91,4,46),(101,4,51),(103,4,52),(107,4,54),(109,4,55),(117,4,59),(135,4,68),(139,4,70),(145,4,73),(159,4,80),(165,4,83),(169,4,85),(185,4,93),(203,4,102),(221,4,111),(237,4,119),(247,4,124),(249,4,125),(257,4,129),(267,4,134),(303,4,152),(307,4,154),(317,4,159),(333,4,167),(337,4,169),(349,4,175),(361,4,181),(1,5,1),(7,5,4),(29,5,15),(33,5,17),(35,5,18),(55,5,28),(65,5,33),(85,5,43),(93,5,47),(113,5,57),(115,5,58),(119,5,60),(121,5,61),(153,5,77),(155,5,78),(157,5,79),(163,5,82),(167,5,84),(179,5,90),(197,5,99),(201,5,101),(205,5,103),(213,5,107),(219,5,110),(223,5,112),(229,5,115),(231,5,116),(233,5,117),(243,5,122),(259,5,130),(261,5,131),(271,5,136),(275,5,138),(287,5,144),(289,5,145),(297,5,149),(309,5,155),(313,5,157),(315,5,158),(321,5,161),(323,5,162),(335,5,168),(8,6,4),(12,6,6),(16,6,8),(72,6,36),(74,6,37),(76,6,38),(90,6,45),(114,6,57),(118,6,59),(130,6,65),(132,6,66),(162,6,81),(166,6,83),(186,6,93),(194,6,97),(198,6,99),(214,6,107),(220,6,110),(228,6,114),(232,6,116),(240,6,120),(246,6,123),(250,6,125),(258,6,129),(260,6,130),(270,6,135),(276,6,138),(296,6,148),(308,6,154),(310,6,155),(314,6,157),(338,6,169),(344,6,172),(348,6,174),(354,6,177),(360,6,180),(26,7,13),(28,7,14),(30,7,15),(32,7,16),(36,7,18),(38,7,19),(46,7,23),(54,7,27),(60,7,30),(66,7,33),(92,7,46),(124,7,62),(160,7,80),(170,7,85),(176,7,88),(182,7,91),(190,7,95),(192,7,96),(200,7,100),(204,7,102),(212,7,106),(234,7,117),(236,7,118),(238,7,119),(252,7,126),(254,7,127),(266,7,133),(272,7,136),(278,7,139),(294,7,147),(318,7,159),(324,7,162),(334,7,167),(346,7,173),(350,7,175),(6,8,3),(22,8,11),(40,8,20),(42,8,21),(44,8,22),(50,8,25),(52,8,26),(62,8,31),(68,8,34),(78,8,39),(108,8,54),(110,8,55),(128,8,64),(136,8,68),(142,8,71),(146,8,73),(156,8,78),(168,8,84),(174,8,87),(178,8,89),(180,8,90),(202,8,101),(248,8,124),(264,8,132),(268,8,134),(284,8,142),(300,8,150),(306,8,153),(312,8,156),(316,8,158),(330,8,165),(342,8,171),(352,8,176),(356,8,178),(2,9,1),(4,9,2),(18,9,9),(48,9,24),(56,9,28),(64,9,32),(70,9,35),(80,9,40),(84,9,42),(98,9,49),(100,9,50),(106,9,53),(126,9,63),(138,9,69),(140,9,70),(144,9,72),(148,9,74),(150,9,75),(152,9,76),(154,9,77),(164,9,82),(172,9,86),(184,9,92),(196,9,98),(208,9,104),(216,9,108),(222,9,111),(224,9,112),(230,9,115),(242,9,121),(280,9,140),(286,9,143),(288,9,144),(320,9,160),(322,9,161),(328,9,164),(332,9,166),(336,9,168),(340,9,170),(358,9,179),(10,10,5),(14,10,7),(20,10,10),(24,10,12),(34,10,17),(58,10,29),(82,10,41),(86,10,43),(88,10,44),(94,10,47),(96,10,48),(102,10,51),(104,10,52),(112,10,56),(116,10,58),(120,10,60),(122,10,61),(134,10,67),(158,10,79),(188,10,94),(206,10,103),(210,10,105),(218,10,109),(226,10,113),(244,10,122),(256,10,128),(262,10,131),(274,10,137),(282,10,141),(290,10,145),(292,10,146),(298,10,149),(302,10,151),(304,10,152),(326,10,163),(362,10,181),(364,10,182);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`),
  KEY `idx_configurable_product_id` (`configurable_product_id`),
  KEY `idx_product_variations_config` (`configurable_product_id`,`is_default`),
  KEY `ec_product_variations_product_id_index` (`product_id`),
  KEY `ec_product_variations_configurable_product_id_index` (`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,76,1,1),(2,77,1,0),(3,78,1,0),(4,79,2,1),(5,80,3,1),(6,81,3,0),(7,82,4,1),(8,83,5,1),(9,84,5,0),(10,85,6,1),(11,86,6,0),(12,87,6,0),(13,88,6,0),(14,89,6,0),(15,90,7,1),(16,91,7,0),(17,92,8,1),(18,93,8,0),(19,94,9,1),(20,95,9,0),(21,96,10,1),(22,97,10,0),(23,98,11,1),(24,99,11,0),(25,100,11,0),(26,101,12,1),(27,102,12,0),(28,103,13,1),(29,104,13,0),(30,105,13,0),(31,106,14,1),(32,107,14,0),(33,108,14,0),(34,109,15,1),(35,110,15,0),(36,111,15,0),(37,112,16,1),(38,113,16,0),(39,114,16,0),(40,115,17,1),(41,116,17,0),(42,117,18,1),(43,118,18,0),(44,119,18,0),(45,120,19,1),(46,121,20,1),(47,122,21,1),(48,123,21,0),(49,124,22,1),(50,125,22,0),(51,126,22,0),(52,127,23,1),(53,128,23,0),(54,129,23,0),(55,130,24,1),(56,131,24,0),(57,132,24,0),(58,133,25,1),(59,134,25,0),(60,135,25,0),(61,136,25,0),(62,137,26,1),(63,138,26,0),(64,139,27,1),(65,140,27,0),(66,141,27,0),(67,142,27,0),(68,143,28,1),(69,144,28,0),(70,145,28,0),(71,146,29,1),(72,147,29,0),(73,148,30,1),(74,149,30,0),(75,150,31,1),(76,151,31,0),(77,152,31,0),(78,153,32,1),(79,154,32,0),(80,155,32,0),(81,156,32,0),(82,157,33,1),(83,158,33,0),(84,159,34,1),(85,160,35,1),(86,161,36,1),(87,162,36,0),(88,163,36,0),(89,164,37,1),(90,165,37,0),(91,166,38,1),(92,167,38,0),(93,168,38,0),(94,169,39,1),(95,170,39,0),(96,171,39,0),(97,172,39,0),(98,173,39,0),(99,174,40,1),(100,175,40,0),(101,176,41,1),(102,177,41,0),(103,178,42,1),(104,179,42,0),(105,180,42,0),(106,181,43,1),(107,182,43,0),(108,183,44,1),(109,184,44,0),(110,185,44,0),(111,186,45,1),(112,187,45,0),(113,188,45,0),(114,189,46,1),(115,190,47,1),(116,191,47,0),(117,192,47,0),(118,193,48,1),(119,194,48,0),(120,195,48,0),(121,196,49,1),(122,197,49,0),(123,198,49,0),(124,199,50,1),(125,200,51,1),(126,201,52,1),(127,202,52,0),(128,203,52,0),(129,204,53,1),(130,205,53,0),(131,206,54,1),(132,207,54,0),(133,208,54,0),(134,209,55,1),(135,210,55,0),(136,211,55,0),(137,212,56,1),(138,213,56,0),(139,214,57,1),(140,215,57,0),(141,216,57,0),(142,217,58,1),(143,218,58,0),(144,219,59,1),(145,220,59,0),(146,221,59,0),(147,222,59,0),(148,223,60,1),(149,224,61,1),(150,225,61,0),(151,226,62,1),(152,227,63,1),(153,228,63,0),(154,229,64,1),(155,230,64,0),(156,231,64,0),(157,232,65,1),(158,233,65,0),(159,234,65,0),(160,235,66,1),(161,236,66,0),(162,237,66,0),(163,238,67,1),(164,239,67,0),(165,240,67,0),(166,241,68,1),(167,242,68,0),(168,243,68,0),(169,244,69,1),(170,245,69,0),(171,246,70,1),(172,247,70,0),(173,248,71,1),(174,249,71,0),(175,250,71,0),(176,251,72,1),(177,252,73,1),(178,253,74,1),(179,254,75,1),(180,255,75,0),(181,256,75,0),(182,257,75,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2026-02-09',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(1,24,0),(2,24,0),(1,25,0),(2,25,0),(1,26,0),(2,26,0),(1,27,0),(2,27,0),(1,28,0),(2,28,0),(1,29,0),(2,29,0),(1,30,0),(2,30,0),(1,31,0),(2,31,0),(1,32,0),(2,32,0),(1,33,0),(2,33,0),(1,34,0),(2,34,0),(1,35,0),(2,35,0),(1,36,0),(2,36,0),(1,37,0),(2,37,0),(1,38,0),(2,38,0),(1,39,0),(2,39,0),(1,40,0),(2,40,0),(1,41,0),(2,41,0),(1,42,0),(2,42,0),(1,43,0),(2,43,0),(1,44,0),(2,44,0),(1,45,0),(2,45,0),(1,46,0),(2,46,0),(1,47,0),(2,47,0),(1,48,0),(2,48,0),(1,49,0),(2,49,0),(1,50,0),(2,50,0),(1,51,0),(2,51,0),(1,52,0),(2,52,0),(1,53,0),(2,53,0),(1,54,0),(2,54,0),(1,55,0),(2,55,0),(1,56,0),(2,56,0),(1,57,0),(2,57,0),(1,58,0),(2,58,0),(1,59,0),(2,59,0),(1,60,0),(2,60,0),(1,61,0),(2,61,0),(1,62,0),(2,62,0),(1,63,0),(2,63,0),(1,64,0),(2,64,0),(1,65,0),(2,65,0),(1,66,0),(2,66,0),(1,67,0),(2,67,0),(1,68,0),(2,68,0),(1,69,0),(2,69,0),(1,70,0),(2,70,0),(1,71,0),(2,71,0),(1,72,0),(2,72,0),(1,73,0),(2,73,0),(1,74,0),(2,74,0),(1,75,0),(2,75,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `video_media` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `stock_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `is_new_until` date DEFAULT NULL,
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `variations_count` int unsigned NOT NULL DEFAULT '0',
  `reviews_count` int unsigned NOT NULL DEFAULT '0',
  `reviews_avg` decimal(3,2) NOT NULL DEFAULT '0.00',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double DEFAULT NULL,
  `wide` double DEFAULT NULL,
  `height` double DEFAULT NULL,
  `weight` double DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `tax_class` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'standard',
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `currency_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_includes_tax` tinyint(1) NOT NULL DEFAULT '0',
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  `license_code_type` enum('auto_generate','pick_from_list') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'auto_generate',
  `minimum_order_quantity` int unsigned DEFAULT '0',
  `maximum_order_quantity` int unsigned DEFAULT '0',
  `notify_attachment_updated` tinyint(1) NOT NULL DEFAULT '0',
  `specification_table_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`),
  KEY `idx_products_export` (`id`,`is_variation`),
  KEY `idx_variation_name_id` (`is_variation`,`name`,`id`),
  KEY `ec_products_variations_count_index` (`variations_count`),
  KEY `ec_products_slug_index` (`slug`),
  KEY `idx_products_status_variation` (`status`,`is_variation`,`id`),
  KEY `idx_products_price_sale` (`sale_type`,`sale_price`,`price`),
  KEY `idx_products_order_created` (`order`,`created_at`),
  KEY `idx_products_stock` (`with_storehouse_management`,`stock_status`,`quantity`),
  KEY `ec_products_reviews_count_index` (`reviews_count`),
  KEY `ec_products_reviews_avg_index` (`reviews_avg`),
  KEY `ec_products_status_is_variation_index` (`status`,`is_variation`),
  KEY `ec_products_storehouse_quantity_index` (`with_storehouse_management`,`quantity`),
  KEY `ec_products_currency_code_index` (`currency_code`)
) ENGINE=InnoDB AUTO_INCREMENT=258 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Miko Wooden Bluetooth Speaker',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-2.jpg\",\"products\\/product-12.jpg\",\"products\\/product-51.jpg\",\"products\\/product-67.jpg\",\"products\\/product-80.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-190-A0',0,10,0,1,'in_stock',1,NULL,3,0,3,9,3.44,0,445,NULL,NULL,NULL,20,18,12,671,NULL,'standard',84469,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(2,'Gorgeous Wooden Gloves',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-13.jpg\",\"products\\/product-25.jpg\",\"products\\/product-33.jpg\",\"products\\/product-45.jpg\",\"products\\/product-58.jpg\"]',NULL,'NC-163-A0',0,11,0,1,'in_stock',1,NULL,4,0,1,10,3.00,0,414,NULL,NULL,NULL,20,18,18,795,NULL,'standard',189848,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(3,'Pinkol Enormous Granite Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-16.jpg\",\"products\\/product-23.jpg\",\"products\\/product-25.jpg\",\"products\\/product-42.jpg\",\"products\\/product-47.jpg\",\"products\\/product-48.jpg\",\"products\\/product-49.jpg\",\"products\\/product-51.jpg\",\"products\\/product-55.jpg\",\"products\\/product-78.jpg\",\"products\\/product-85.jpg\",\"products\\/product-86.jpg\"]',NULL,'NC-188-A0',0,16,0,1,'in_stock',1,NULL,6,0,2,9,3.22,0,345,NULL,NULL,NULL,18,20,10,857,NULL,'standard',98294,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(4,'Gorgeous Aluminum Table',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-7.jpg\",\"products\\/product-9.jpg\",\"products\\/product-13.jpg\",\"products\\/product-24.jpg\",\"products\\/product-25.jpg\",\"products\\/product-44.jpg\",\"products\\/product-53.jpg\",\"products\\/product-59.jpg\",\"products\\/product-75.jpg\",\"products\\/product-85.jpg\"]',NULL,'NC-144-A0',0,20,0,1,'in_stock',1,NULL,2,0,1,8,3.25,0,234,187.2,NULL,NULL,17,18,10,762,NULL,'standard',18148,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(5,'Evo Lightweight Granite Shirt',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-8.jpg\",\"products\\/product-15.jpg\",\"products\\/product-38.jpg\",\"products\\/product-91.jpg\"]',NULL,'NC-132-A0',0,15,0,1,'in_stock',1,NULL,6,0,2,10,2.60,0,487,NULL,NULL,NULL,15,12,18,837,NULL,'standard',178218,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(6,'CLCo. Incredible Paper Car',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-3.jpg\",\"products\\/product-4.jpg\",\"products\\/product-8.jpg\",\"products\\/product-11.jpg\",\"products\\/product-24.jpg\",\"products\\/product-56.jpg\",\"products\\/product-58.jpg\",\"products\\/product-75.jpg\",\"products\\/product-82.jpg\"]',NULL,'NC-129-A0',0,10,0,1,'in_stock',1,NULL,5,0,5,10,2.40,0,270,NULL,NULL,NULL,14,12,11,535,NULL,'standard',50945,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(7,'Progash Durable Granite Hat',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-7.jpg\",\"products\\/product-19.jpg\",\"products\\/product-29.jpg\",\"products\\/product-32.jpg\",\"products\\/product-37.jpg\",\"products\\/product-56.jpg\",\"products\\/product-87.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-163-A0',0,12,0,1,'in_stock',0,NULL,4,0,2,8,3.25,0,321,NULL,NULL,NULL,19,20,12,654,NULL,'standard',76267,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(8,'Purab Enormous Miranda Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-17.jpg\",\"products\\/product-37.jpg\",\"products\\/product-53.jpg\",\"products\\/product-68.jpg\",\"products\\/product-83.jpg\"]',NULL,'NC-125-A0',0,14,0,1,'in_stock',0,NULL,4,0,2,10,2.90,0,214,160.5,NULL,NULL,12,18,12,671,NULL,'standard',148288,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(9,'Miklonda Co. Crafted Candles',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-3.jpg\",\"products\\/product-15.jpg\",\"products\\/product-16.jpg\",\"products\\/product-51.jpg\",\"products\\/product-56.jpg\",\"products\\/product-60.jpg\",\"products\\/product-70.jpg\",\"products\\/product-75.jpg\",\"products\\/product-77.jpg\",\"products\\/product-81.jpg\",\"products\\/product-86.jpg\"]',NULL,'NC-194-A0',0,18,0,1,'in_stock',1,NULL,1,0,2,10,2.50,0,336,NULL,NULL,NULL,16,10,14,638,NULL,'standard',140066,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(10,'Pinkol Enormous Granite Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-7.jpg\",\"products\\/product-21.jpg\",\"products\\/product-33.jpg\",\"products\\/product-64.jpg\",\"products\\/product-69.jpg\",\"products\\/product-73.jpg\",\"products\\/product-79.jpg\",\"products\\/product-91.jpg\",\"products\\/product-95.jpg\"]',NULL,'NC-161-A0',0,15,0,1,'in_stock',1,NULL,6,0,2,10,3.10,0,243,NULL,NULL,NULL,20,15,18,790,NULL,'standard',138035,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(11,'Dual Camera 20MP',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-6.jpg\",\"products\\/product-22.jpg\",\"products\\/product-44.jpg\",\"products\\/product-49.jpg\",\"products\\/product-58.jpg\",\"products\\/product-76.jpg\",\"products\\/product-79.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-111-A0',0,18,0,1,'in_stock',0,NULL,5,0,3,10,3.50,0,313,NULL,NULL,NULL,10,10,12,566,NULL,'standard',164005,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(12,'Smart Watches',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-8.jpg\",\"products\\/product-11.jpg\",\"products\\/product-15.jpg\",\"products\\/product-29.jpg\",\"products\\/product-45.jpg\",\"products\\/product-50.jpg\",\"products\\/product-63.jpg\",\"products\\/product-80.jpg\",\"products\\/product-89.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-152-A0',0,16,0,1,'in_stock',1,NULL,7,0,2,10,2.80,0,469,356.44,NULL,NULL,16,10,14,693,NULL,'standard',195092,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(13,'Beat Headphone',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-8.jpg\",\"products\\/product-19.jpg\",\"products\\/product-36.jpg\",\"products\\/product-38.jpg\",\"products\\/product-46.jpg\",\"products\\/product-62.jpg\",\"products\\/product-65.jpg\",\"products\\/product-78.jpg\",\"products\\/product-80.jpg\",\"products\\/product-82.jpg\",\"products\\/product-95.jpg\"]',NULL,'NC-119-A0',0,19,0,1,'in_stock',0,NULL,2,0,3,9,3.11,0,333,NULL,NULL,NULL,19,18,14,657,NULL,'standard',1772,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(14,'Red &amp; Black Headphone',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-6.jpg\",\"products\\/product-17.jpg\",\"products\\/product-19.jpg\",\"products\\/product-22.jpg\",\"products\\/product-42.jpg\",\"products\\/product-44.jpg\",\"products\\/product-68.jpg\",\"products\\/product-87.jpg\",\"products\\/product-88.jpg\"]',NULL,'NC-151-A0',0,20,0,1,'in_stock',0,NULL,6,0,3,10,2.80,0,344,NULL,NULL,NULL,19,20,10,518,NULL,'standard',172717,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(15,'Smart Watch External',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-8.jpg\",\"products\\/product-23.jpg\",\"products\\/product-24.jpg\",\"products\\/product-44.jpg\",\"products\\/product-51.jpg\",\"products\\/product-52.jpg\",\"products\\/product-56.jpg\",\"products\\/product-63.jpg\",\"products\\/product-76.jpg\",\"products\\/product-81.jpg\",\"products\\/product-83.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-153-A0',0,11,0,1,'in_stock',1,NULL,7,0,3,8,2.38,0,459,NULL,NULL,NULL,11,20,19,747,NULL,'standard',184254,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(16,'Nikon HD camera',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-24.jpg\",\"products\\/product-25.jpg\",\"products\\/product-55.jpg\",\"products\\/product-82.jpg\",\"products\\/product-88.jpg\",\"products\\/product-92.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-172-A0',0,13,0,1,'in_stock',1,NULL,7,0,3,9,3.22,0,269,234.03,NULL,NULL,14,10,19,663,NULL,'standard',54022,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(17,'Audio Equipment',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-55.jpg\",\"products\\/product-62.jpg\",\"products\\/product-73.jpg\",\"products\\/product-75.jpg\",\"products\\/product-77.jpg\"]',NULL,'NC-101-A0',0,11,0,1,'in_stock',1,NULL,5,0,2,9,2.67,0,403,NULL,NULL,NULL,17,16,13,787,NULL,'standard',184738,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(18,'Smart Televisions',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-12.jpg\",\"products\\/product-15.jpg\",\"products\\/product-19.jpg\",\"products\\/product-40.jpg\",\"products\\/product-66.jpg\"]',NULL,'NC-162-A0',0,10,0,1,'in_stock',0,NULL,4,0,3,10,3.40,0,469,NULL,NULL,NULL,20,19,17,899,NULL,'standard',152581,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(19,'Samsung Smart Phone',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-15.jpg\",\"products\\/product-33.jpg\",\"products\\/product-55.jpg\",\"products\\/product-61.jpg\",\"products\\/product-65.jpg\",\"products\\/product-71.jpg\",\"products\\/product-87.jpg\",\"products\\/product-94.jpg\"]',NULL,'NC-102-A0',0,15,0,1,'in_stock',1,NULL,3,0,1,10,2.40,0,382,NULL,NULL,NULL,15,11,16,642,NULL,'standard',15035,'2026-02-09 00:18:59','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(20,'Herschel Leather Duffle Bag In Brown Color',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-13.jpg\",\"products\\/product-30.jpg\",\"products\\/product-63.jpg\",\"products\\/product-83.jpg\",\"products\\/product-90.jpg\"]',NULL,'NC-150-A0',0,16,0,1,'in_stock',0,NULL,5,0,1,8,2.00,0,396,285.12,NULL,NULL,14,15,20,609,NULL,'standard',95348,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(21,'Xbox One Wireless Controller Black Color',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-14.jpg\",\"products\\/product-35.jpg\",\"products\\/product-37.jpg\",\"products\\/product-47.jpg\",\"products\\/product-66.jpg\",\"products\\/product-70.jpg\",\"products\\/product-89.jpg\"]',NULL,'NC-168-A0',0,17,0,1,'in_stock',0,NULL,1,0,2,9,3.44,0,429,NULL,NULL,NULL,13,14,18,521,NULL,'standard',144486,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(22,'EPSION Plaster Printer',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-6.jpg\",\"products\\/product-13.jpg\",\"products\\/product-15.jpg\",\"products\\/product-46.jpg\",\"products\\/product-55.jpg\",\"products\\/product-72.jpg\",\"products\\/product-88.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-190-A0',0,16,0,1,'in_stock',1,NULL,4,0,3,8,3.00,0,494,NULL,NULL,NULL,19,11,15,612,NULL,'standard',167282,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(23,'Sound Intone I65 Earphone White Version',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-10.jpg\",\"products\\/product-23.jpg\",\"products\\/product-31.jpg\",\"products\\/product-44.jpg\",\"products\\/product-63.jpg\",\"products\\/product-64.jpg\",\"products\\/product-76.jpg\"]',NULL,'NC-166-A0',0,10,0,1,'in_stock',0,NULL,4,0,3,8,3.38,0,352,NULL,NULL,NULL,11,13,18,745,NULL,'standard',63480,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(24,'B&amp;O Play Mini Bluetooth Speaker',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-4.jpg\",\"products\\/product-5.jpg\",\"products\\/product-38.jpg\",\"products\\/product-42.jpg\",\"products\\/product-64.jpg\",\"products\\/product-66.jpg\",\"products\\/product-75.jpg\",\"products\\/product-80.jpg\",\"products\\/product-94.jpg\"]',NULL,'NC-156-A0',0,12,0,1,'in_stock',0,NULL,4,0,3,10,3.30,0,208,147.68,NULL,NULL,15,14,15,822,NULL,'standard',171817,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(25,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-2.jpg\",\"products\\/product-9.jpg\",\"products\\/product-10.jpg\",\"products\\/product-16.jpg\",\"products\\/product-25.jpg\",\"products\\/product-38.jpg\",\"products\\/product-54.jpg\",\"products\\/product-57.jpg\",\"products\\/product-65.jpg\",\"products\\/product-75.jpg\",\"products\\/product-76.jpg\"]',NULL,'NC-103-A0',0,11,0,1,'in_stock',0,NULL,7,0,4,9,2.56,0,262,NULL,NULL,NULL,10,15,18,743,NULL,'standard',175940,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(26,'Apple MacBook Air Retina 12-Inch Laptop',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-3.jpg\",\"products\\/product-20.jpg\",\"products\\/product-28.jpg\",\"products\\/product-31.jpg\",\"products\\/product-32.jpg\"]',NULL,'NC-180-A0',0,17,0,1,'in_stock',0,NULL,1,0,2,10,2.30,0,394,NULL,NULL,NULL,16,15,15,737,NULL,'standard',104006,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(27,'Samsung Gear VR Virtual Reality Headset',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-2.jpg\",\"products\\/product-7.jpg\",\"products\\/product-29.jpg\",\"products\\/product-53.jpg\",\"products\\/product-62.jpg\",\"products\\/product-77.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-190-A0',0,15,0,1,'in_stock',1,NULL,6,0,4,9,3.67,0,401,NULL,NULL,NULL,14,18,15,644,NULL,'standard',161559,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(28,'Aveeno Moisturizing Body Shower 450ml',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-18.jpg\",\"products\\/product-36.jpg\",\"products\\/product-39.jpg\",\"products\\/product-61.jpg\",\"products\\/product-73.jpg\",\"products\\/product-75.jpg\",\"products\\/product-80.jpg\",\"products\\/product-83.jpg\",\"products\\/product-90.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-181-A0',0,17,0,1,'in_stock',0,NULL,5,0,3,10,3.40,0,305,256.2,NULL,NULL,18,17,19,519,NULL,'standard',1302,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(29,'NYX Beauty Couton Pallete Makeup 12',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-4.jpg\",\"products\\/product-18.jpg\",\"products\\/product-25.jpg\",\"products\\/product-29.jpg\",\"products\\/product-42.jpg\",\"products\\/product-45.jpg\",\"products\\/product-68.jpg\"]',NULL,'NC-138-A0',0,19,0,1,'in_stock',0,NULL,3,0,2,9,3.89,0,306,NULL,NULL,NULL,19,10,13,598,NULL,'standard',99623,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(30,'NYX Beauty Couton Pallete Makeup 12',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-5.jpg\",\"products\\/product-27.jpg\",\"products\\/product-34.jpg\",\"products\\/product-54.jpg\",\"products\\/product-56.jpg\",\"products\\/product-60.jpg\",\"products\\/product-66.jpg\",\"products\\/product-71.jpg\",\"products\\/product-86.jpg\"]',NULL,'NC-163-A0',0,15,0,1,'in_stock',1,NULL,3,0,2,10,3.10,0,474,NULL,NULL,NULL,11,16,14,629,NULL,'standard',50520,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(31,'MVMTH Classical Leather Watch In Black',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-19.jpg\",\"products\\/product-21.jpg\",\"products\\/product-23.jpg\",\"products\\/product-30.jpg\",\"products\\/product-31.jpg\",\"products\\/product-64.jpg\",\"products\\/product-65.jpg\",\"products\\/product-72.jpg\",\"products\\/product-84.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-147-A0',0,17,0,1,'in_stock',1,NULL,4,0,3,10,2.60,0,500,NULL,NULL,NULL,12,15,13,646,NULL,'standard',196606,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(32,'Baxter Care Hair Kit For Bearded Mens',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-7.jpg\",\"products\\/product-15.jpg\",\"products\\/product-21.jpg\",\"products\\/product-33.jpg\",\"products\\/product-49.jpg\",\"products\\/product-52.jpg\",\"products\\/product-62.jpg\",\"products\\/product-68.jpg\",\"products\\/product-75.jpg\",\"products\\/product-76.jpg\",\"products\\/product-89.jpg\"]',NULL,'NC-128-A0',0,12,0,1,'in_stock',1,NULL,5,0,4,9,3.44,0,413,322.14,NULL,NULL,15,16,20,856,NULL,'standard',110516,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(33,'Ciate Palemore Lipstick Bold Red Color',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-8.jpg\",\"products\\/product-18.jpg\",\"products\\/product-43.jpg\",\"products\\/product-60.jpg\",\"products\\/product-61.jpg\",\"products\\/product-76.jpg\",\"products\\/product-85.jpg\"]',NULL,'NC-174-A0',0,10,0,1,'in_stock',1,NULL,3,0,2,10,3.00,0,383,NULL,NULL,NULL,15,13,18,698,NULL,'standard',50166,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(34,'Vimto Squash Remix Apple 1.5 Litres',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-25.jpg\",\"products\\/product-26.jpg\",\"products\\/product-35.jpg\",\"products\\/product-43.jpg\",\"products\\/product-50.jpg\",\"products\\/product-54.jpg\",\"products\\/product-55.jpg\",\"products\\/product-78.jpg\"]',NULL,'NC-170-A0',0,12,0,1,'in_stock',1,NULL,3,0,1,10,3.50,0,237,NULL,NULL,NULL,16,10,17,659,NULL,'standard',130106,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(35,'Crock Pot Slow Cooker',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-10.jpg\",\"products\\/product-21.jpg\",\"products\\/product-27.jpg\",\"products\\/product-28.jpg\",\"products\\/product-30.jpg\",\"products\\/product-40.jpg\",\"products\\/product-71.jpg\",\"products\\/product-83.jpg\",\"products\\/product-85.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-121-A0',0,12,0,1,'in_stock',0,NULL,3,0,1,9,2.56,0,303,NULL,NULL,NULL,19,13,13,509,NULL,'standard',196030,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(36,'Taylors of Harrogate Yorkshire Coffee',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-4.jpg\",\"products\\/product-6.jpg\",\"products\\/product-8.jpg\",\"products\\/product-50.jpg\",\"products\\/product-53.jpg\",\"products\\/product-58.jpg\",\"products\\/product-68.jpg\",\"products\\/product-72.jpg\",\"products\\/product-78.jpg\",\"products\\/product-81.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-116-A0',0,15,0,1,'in_stock',0,NULL,2,0,3,10,3.20,0,270,218.7,NULL,NULL,12,11,12,691,NULL,'standard',161440,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(37,'Soft Mochi &amp; Galeto Ice Cream',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-6.jpg\",\"products\\/product-12.jpg\",\"products\\/product-26.jpg\",\"products\\/product-27.jpg\",\"products\\/product-45.jpg\",\"products\\/product-58.jpg\",\"products\\/product-69.jpg\"]',NULL,'NC-154-A0',0,11,0,1,'in_stock',1,NULL,2,0,2,10,3.20,0,296,NULL,NULL,NULL,10,17,16,797,NULL,'standard',57676,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(38,'Naked Noodle Egg Noodles Singapore',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-2.jpg\",\"products\\/product-9.jpg\",\"products\\/product-19.jpg\",\"products\\/product-30.jpg\",\"products\\/product-37.jpg\",\"products\\/product-64.jpg\",\"products\\/product-69.jpg\",\"products\\/product-72.jpg\",\"products\\/product-76.jpg\",\"products\\/product-78.jpg\",\"products\\/product-85.jpg\"]',NULL,'NC-196-A0',0,10,0,1,'in_stock',1,NULL,6,0,3,8,3.25,0,350,NULL,NULL,NULL,13,12,19,554,NULL,'standard',35836,'2026-02-09 00:18:59','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(39,'Saute Pan Silver',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-9.jpg\",\"products\\/product-14.jpg\",\"products\\/product-35.jpg\",\"products\\/product-42.jpg\",\"products\\/product-60.jpg\",\"products\\/product-74.jpg\",\"products\\/product-82.jpg\",\"products\\/product-85.jpg\"]',NULL,'NC-193-A0',0,14,0,1,'in_stock',1,NULL,6,0,5,9,2.78,0,326,NULL,NULL,NULL,13,13,15,839,NULL,'standard',32266,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(40,'Bar S – Classic Bun Length Franks',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-11.jpg\",\"products\\/product-25.jpg\",\"products\\/product-30.jpg\",\"products\\/product-38.jpg\",\"products\\/product-61.jpg\",\"products\\/product-68.jpg\",\"products\\/product-70.jpg\",\"products\\/product-76.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-188-A0',0,18,0,1,'in_stock',0,NULL,5,0,2,9,3.89,0,353,292.99,NULL,NULL,20,13,17,868,NULL,'standard',199953,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(41,'Broccoli Crowns',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-12.jpg\",\"products\\/product-18.jpg\",\"products\\/product-20.jpg\",\"products\\/product-23.jpg\",\"products\\/product-40.jpg\",\"products\\/product-51.jpg\",\"products\\/product-67.jpg\",\"products\\/product-77.jpg\"]',NULL,'NC-176-A0',0,20,0,1,'in_stock',1,NULL,1,0,2,8,3.13,0,396,NULL,NULL,NULL,13,15,20,794,NULL,'standard',100727,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(42,'Slimming World Vegan Mac Greens',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-11.jpg\",\"products\\/product-43.jpg\",\"products\\/product-47.jpg\",\"products\\/product-66.jpg\",\"products\\/product-72.jpg\"]',NULL,'NC-137-A0',0,18,0,1,'in_stock',0,NULL,5,0,3,9,3.56,0,223,NULL,NULL,NULL,11,15,11,639,NULL,'standard',29555,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(43,'Häagen-Dazs Salted Caramel',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-12.jpg\",\"products\\/product-18.jpg\",\"products\\/product-30.jpg\",\"products\\/product-31.jpg\",\"products\\/product-41.jpg\",\"products\\/product-45.jpg\",\"products\\/product-57.jpg\",\"products\\/product-58.jpg\",\"products\\/product-72.jpg\",\"products\\/product-90.jpg\"]',NULL,'NC-179-A0',0,11,0,1,'in_stock',0,NULL,7,0,2,9,3.67,0,361,NULL,NULL,NULL,12,15,11,880,NULL,'standard',33030,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(44,'Iceland 3 Solo Exotic Burst',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-6.jpg\",\"products\\/product-9.jpg\",\"products\\/product-15.jpg\",\"products\\/product-17.jpg\",\"products\\/product-25.jpg\",\"products\\/product-28.jpg\",\"products\\/product-42.jpg\",\"products\\/product-46.jpg\",\"products\\/product-58.jpg\",\"products\\/product-68.jpg\",\"products\\/product-70.jpg\"]',NULL,'NC-128-A0',0,19,0,1,'in_stock',0,NULL,6,0,3,10,2.70,0,377,335.53,NULL,NULL,17,12,16,834,NULL,'standard',54183,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(45,'Extreme Budweiser Light Can',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-32.jpg\",\"products\\/product-49.jpg\",\"products\\/product-67.jpg\",\"products\\/product-70.jpg\"]',NULL,'NC-192-A0',0,12,0,1,'in_stock',0,NULL,2,0,3,9,3.22,0,488,NULL,NULL,NULL,16,12,18,653,NULL,'standard',108276,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(46,'Iceland Macaroni Cheese Traybake',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-13.jpg\",\"products\\/product-39.jpg\",\"products\\/product-54.jpg\",\"products\\/product-76.jpg\",\"products\\/product-80.jpg\",\"products\\/product-88.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-102-A0',0,13,0,1,'in_stock',1,NULL,5,0,1,10,2.40,0,483,NULL,NULL,NULL,12,11,13,892,NULL,'standard',114836,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(47,'Dolmio Bolognese Pasta Sauce',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-6.jpg\",\"products\\/product-31.jpg\",\"products\\/product-34.jpg\",\"products\\/product-43.jpg\",\"products\\/product-54.jpg\",\"products\\/product-57.jpg\",\"products\\/product-74.jpg\",\"products\\/product-78.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-139-A0',0,11,0,1,'in_stock',1,NULL,5,0,3,9,2.89,0,340,NULL,NULL,NULL,11,14,15,874,NULL,'standard',120980,'2026-02-09 00:19:00','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(48,'Sitema BakeIT Plastic Box',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-3.jpg\",\"products\\/product-13.jpg\",\"products\\/product-17.jpg\",\"products\\/product-31.jpg\",\"products\\/product-44.jpg\",\"products\\/product-53.jpg\",\"products\\/product-55.jpg\",\"products\\/product-61.jpg\",\"products\\/product-68.jpg\",\"products\\/product-90.jpg\"]',NULL,'NC-188-A0',0,19,0,1,'in_stock',1,NULL,1,0,3,9,4.22,0,399,323.19,NULL,NULL,18,11,17,728,NULL,'standard',48158,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(49,'Wayfair Basics Dinner Plate Storage',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-10.jpg\",\"products\\/product-14.jpg\",\"products\\/product-20.jpg\",\"products\\/product-25.jpg\",\"products\\/product-31.jpg\",\"products\\/product-33.jpg\",\"products\\/product-47.jpg\",\"products\\/product-59.jpg\",\"products\\/product-75.jpg\",\"products\\/product-76.jpg\"]',NULL,'NC-121-A0',0,10,0,1,'in_stock',1,NULL,5,0,3,10,2.60,0,355,NULL,NULL,NULL,16,10,13,684,NULL,'standard',5974,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(50,'Miko The Panda Water Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-3.jpg\",\"products\\/product-11.jpg\",\"products\\/product-15.jpg\",\"products\\/product-16.jpg\",\"products\\/product-21.jpg\",\"products\\/product-27.jpg\",\"products\\/product-42.jpg\",\"products\\/product-60.jpg\",\"products\\/product-65.jpg\",\"products\\/product-75.jpg\",\"products\\/product-85.jpg\",\"products\\/product-88.jpg\"]',NULL,'NC-181-A0',0,12,0,1,'in_stock',1,NULL,5,0,1,10,3.00,0,233,NULL,NULL,NULL,15,16,10,814,NULL,'standard',5286,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(51,'Sesame Seed Bread',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-23.jpg\",\"products\\/product-37.jpg\",\"products\\/product-64.jpg\",\"products\\/product-77.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-105-A0',0,20,0,1,'in_stock',1,NULL,7,0,1,10,3.00,0,407,NULL,NULL,NULL,17,20,10,780,NULL,'standard',74746,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(52,'Morrisons The Best Beef',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-6.jpg\",\"products\\/product-13.jpg\",\"products\\/product-18.jpg\",\"products\\/product-19.jpg\",\"products\\/product-20.jpg\",\"products\\/product-24.jpg\",\"products\\/product-26.jpg\",\"products\\/product-58.jpg\",\"products\\/product-62.jpg\",\"products\\/product-76.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-168-A0',0,20,0,1,'in_stock',0,NULL,7,0,3,10,2.90,0,439,338.03,NULL,NULL,17,18,19,820,NULL,'standard',151973,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(53,'Avocado, Hass Large',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-22.jpg\",\"products\\/product-30.jpg\",\"products\\/product-33.jpg\",\"products\\/product-41.jpg\",\"products\\/product-60.jpg\",\"products\\/product-63.jpg\",\"products\\/product-86.jpg\"]',NULL,'NC-129-A0',0,15,0,1,'in_stock',0,NULL,2,0,2,10,3.30,0,222,NULL,NULL,NULL,15,11,14,567,NULL,'standard',99512,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(54,'Italia Beef Lasagne',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-4.jpg\",\"products\\/product-7.jpg\",\"products\\/product-26.jpg\",\"products\\/product-32.jpg\",\"products\\/product-36.jpg\",\"products\\/product-38.jpg\",\"products\\/product-41.jpg\",\"products\\/product-55.jpg\",\"products\\/product-59.jpg\",\"products\\/product-72.jpg\",\"products\\/product-88.jpg\"]',NULL,'NC-163-A0',0,18,0,1,'in_stock',1,NULL,3,0,3,9,2.89,0,399,NULL,NULL,NULL,17,19,20,863,NULL,'standard',75257,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(55,'Maxwell House Classic Roast Mocha',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-12.jpg\",\"products\\/product-13.jpg\",\"products\\/product-43.jpg\",\"products\\/product-44.jpg\",\"products\\/product-62.jpg\",\"products\\/product-64.jpg\",\"products\\/product-66.jpg\",\"products\\/product-69.jpg\",\"products\\/product-76.jpg\",\"products\\/product-77.jpg\"]',NULL,'NC-190-A0',0,13,0,1,'in_stock',0,NULL,4,0,3,9,3.00,0,325,NULL,NULL,NULL,12,19,18,751,NULL,'standard',38514,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(56,'Bottled Pure Water 500ml',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-14.jpg\",\"products\\/product-19.jpg\",\"products\\/product-25.jpg\",\"products\\/product-32.jpg\",\"products\\/product-64.jpg\",\"products\\/product-73.jpg\",\"products\\/product-82.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-147-A0',0,11,0,1,'in_stock',1,NULL,1,0,2,9,3.00,0,302,250.66,NULL,NULL,17,13,14,888,NULL,'standard',11863,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(57,'Famart Farmhouse Soft White',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-16.jpg\",\"products\\/product-17.jpg\",\"products\\/product-22.jpg\",\"products\\/product-36.jpg\",\"products\\/product-38.jpg\",\"products\\/product-53.jpg\",\"products\\/product-76.jpg\",\"products\\/product-87.jpg\",\"products\\/product-90.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-111-A0',0,13,0,1,'in_stock',1,NULL,3,0,3,10,3.10,0,283,NULL,NULL,NULL,20,14,20,645,NULL,'standard',143751,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(58,'Coca-Cola Original Taste',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-16.jpg\",\"products\\/product-56.jpg\",\"products\\/product-73.jpg\",\"products\\/product-75.jpg\",\"products\\/product-91.jpg\"]',NULL,'NC-110-A0',0,11,0,1,'in_stock',1,NULL,5,0,2,10,2.70,0,317,NULL,NULL,NULL,13,19,13,604,NULL,'standard',192264,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(59,'Casillero Diablo Cabernet Sauvignon',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-3.jpg\",\"products\\/product-63.jpg\",\"products\\/product-65.jpg\",\"products\\/product-66.jpg\",\"products\\/product-68.jpg\",\"products\\/product-84.jpg\",\"products\\/product-89.jpg\"]',NULL,'NC-188-A0',0,12,0,1,'in_stock',1,NULL,7,0,4,10,3.90,0,212,NULL,NULL,NULL,10,18,18,837,NULL,'standard',101382,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(60,'Arla Organic Free Range Milk',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-2.jpg\",\"products\\/product-22.jpg\",\"products\\/product-35.jpg\",\"products\\/product-46.jpg\",\"products\\/product-56.jpg\",\"products\\/product-66.jpg\",\"products\\/product-67.jpg\",\"products\\/product-68.jpg\",\"products\\/product-69.jpg\",\"products\\/product-73.jpg\",\"products\\/product-74.jpg\",\"products\\/product-89.jpg\"]',NULL,'NC-114-A0',0,20,0,1,'in_stock',0,NULL,2,0,1,9,3.56,0,318,228.96,NULL,NULL,12,12,16,772,NULL,'standard',151412,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(61,'Aptamil Follow On Baby Milk',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-9.jpg\",\"products\\/product-13.jpg\",\"products\\/product-14.jpg\",\"products\\/product-63.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-120-A0',0,14,0,1,'in_stock',0,NULL,2,0,2,10,3.10,0,473,NULL,NULL,NULL,17,10,14,580,NULL,'standard',135856,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(62,'Cuisinart Chef’S Classic Hard-Anodized',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-15.jpg\",\"products\\/product-20.jpg\",\"products\\/product-23.jpg\",\"products\\/product-26.jpg\",\"products\\/product-43.jpg\",\"products\\/product-45.jpg\",\"products\\/product-51.jpg\",\"products\\/product-56.jpg\",\"products\\/product-76.jpg\",\"products\\/product-92.jpg\",\"products\\/product-93.jpg\",\"products\\/product-94.jpg\"]',NULL,'NC-132-A0',0,14,0,1,'in_stock',0,NULL,7,0,1,10,3.50,0,349,NULL,NULL,NULL,20,20,20,533,NULL,'standard',112156,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(63,'Corn, Yellow Sweet',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-15.jpg\",\"products\\/product-16.jpg\",\"products\\/product-45.jpg\",\"products\\/product-51.jpg\",\"products\\/product-65.jpg\"]',NULL,'NC-170-A0',0,20,0,1,'in_stock',1,NULL,3,0,2,9,2.89,0,255,NULL,NULL,NULL,16,10,17,900,NULL,'standard',128899,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(64,'Hobnobs The Nobbly Biscuit',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-25.jpg\",\"products\\/product-26.jpg\",\"products\\/product-55.jpg\",\"products\\/product-93.jpg\",\"products\\/product-94.jpg\"]',NULL,'NC-155-A0',0,15,0,1,'in_stock',0,NULL,1,0,3,8,2.88,0,487,399.34,NULL,NULL,14,15,19,538,NULL,'standard',107934,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(65,'Honest Organic Still Lemonade',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-1.jpg\",\"products\\/product-10.jpg\",\"products\\/product-17.jpg\",\"products\\/product-18.jpg\",\"products\\/product-20.jpg\",\"products\\/product-26.jpg\",\"products\\/product-45.jpg\",\"products\\/product-51.jpg\",\"products\\/product-74.jpg\",\"products\\/product-78.jpg\",\"products\\/product-82.jpg\"]',NULL,'NC-157-A0',0,10,0,1,'in_stock',1,NULL,6,0,3,10,3.60,0,292,NULL,NULL,NULL,14,18,19,508,NULL,'standard',134655,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(66,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-13.jpg\",\"products\\/product-48.jpg\",\"products\\/product-49.jpg\",\"products\\/product-81.jpg\",\"products\\/product-87.jpg\",\"products\\/product-88.jpg\"]',NULL,'NC-122-A0',0,15,0,1,'in_stock',0,NULL,5,0,3,10,2.80,0,294,NULL,NULL,NULL,10,20,18,776,NULL,'standard',133614,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(67,'Iceland 6 Hot Cross Buns',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-10.jpg\",\"products\\/product-13.jpg\",\"products\\/product-50.jpg\",\"products\\/product-63.jpg\",\"products\\/product-77.jpg\",\"products\\/product-79.jpg\",\"products\\/product-82.jpg\"]',NULL,'NC-130-A0',0,16,0,1,'in_stock',0,NULL,4,0,3,8,2.50,0,269,NULL,NULL,NULL,16,14,12,757,NULL,'standard',89783,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(68,'Iceland Luxury 4 Panini Rolls',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-2.jpg\",\"products\\/product-27.jpg\",\"products\\/product-46.jpg\",\"products\\/product-47.jpg\",\"products\\/product-51.jpg\",\"products\\/product-56.jpg\",\"products\\/product-61.jpg\",\"products\\/product-87.jpg\",\"products\\/product-89.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-136-A0',0,15,0,1,'in_stock',0,NULL,5,0,3,9,3.56,0,469,379.89,NULL,NULL,20,19,16,587,NULL,'standard',39253,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(69,'Iceland Soft Scoop Vanilla',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-4.jpg\",\"products\\/product-6.jpg\",\"products\\/product-8.jpg\",\"products\\/product-53.jpg\",\"products\\/product-69.jpg\"]',NULL,'NC-193-A0',0,20,0,1,'in_stock',0,NULL,2,0,2,9,3.22,0,441,NULL,NULL,NULL,14,11,13,579,NULL,'standard',91931,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(70,'Iceland Spaghetti Bolognese',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-15.jpg\",\"products\\/product-22.jpg\",\"products\\/product-57.jpg\",\"products\\/product-63.jpg\",\"products\\/product-64.jpg\",\"products\\/product-73.jpg\",\"products\\/product-82.jpg\",\"products\\/product-91.jpg\"]',NULL,'NC-126-A0',0,11,0,1,'in_stock',0,NULL,5,0,2,10,2.90,0,356,NULL,NULL,NULL,16,13,12,825,NULL,'standard',75735,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(71,'Kellogg’s Coco Pops Cereal',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-19.jpg\",\"products\\/product-35.jpg\",\"products\\/product-60.jpg\",\"products\\/product-65.jpg\",\"products\\/product-74.jpg\",\"products\\/product-76.jpg\",\"products\\/product-88.jpg\",\"products\\/product-89.jpg\"]',NULL,'NC-119-A0',0,13,0,1,'in_stock',1,NULL,5,0,3,10,3.70,0,233,NULL,NULL,NULL,19,16,17,817,NULL,'standard',172210,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(72,'Kit Kat Chunky Milk Chocolate',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-4.jpg\",\"products\\/product-25.jpg\",\"products\\/product-39.jpg\",\"products\\/product-46.jpg\",\"products\\/product-55.jpg\",\"products\\/product-94.jpg\"]',NULL,'NC-183-A0',0,19,0,1,'in_stock',1,NULL,4,0,1,10,3.50,0,436,305.2,NULL,NULL,20,17,18,638,NULL,'standard',63315,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(73,'Large Green Bell Pepper',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-4.jpg\",\"products\\/product-15.jpg\",\"products\\/product-39.jpg\",\"products\\/product-43.jpg\",\"products\\/product-50.jpg\",\"products\\/product-56.jpg\",\"products\\/product-60.jpg\",\"products\\/product-61.jpg\",\"products\\/product-62.jpg\",\"products\\/product-73.jpg\",\"products\\/product-81.jpg\",\"products\\/product-90.jpg\"]',NULL,'NC-183-A0',0,13,0,1,'in_stock',1,NULL,3,0,1,10,2.70,0,495,NULL,NULL,NULL,10,14,16,854,NULL,'standard',146361,'2026-02-09 00:19:00','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(74,'Pice 94w Beasley Journal',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-3.jpg\",\"products\\/product-4.jpg\",\"products\\/product-8.jpg\",\"products\\/product-18.jpg\",\"products\\/product-59.jpg\",\"products\\/product-89.jpg\",\"products\\/product-93.jpg\"]',NULL,'NC-186-A0',0,18,0,1,'in_stock',0,NULL,3,0,1,10,3.20,0,251,NULL,NULL,NULL,20,12,12,542,NULL,'standard',70779,'2026-02-09 00:19:01','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,2),(75,'Province Piece Glass Drinking Glass',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-7.jpg\",\"products\\/product-8.jpg\",\"products\\/product-9.jpg\",\"products\\/product-31.jpg\",\"products\\/product-48.jpg\",\"products\\/product-50.jpg\",\"products\\/product-54.jpg\",\"products\\/product-67.jpg\",\"products\\/product-81.jpg\"]',NULL,'NC-109-A0',0,11,0,1,'in_stock',0,NULL,5,0,4,9,3.00,0,322,NULL,NULL,NULL,12,14,16,876,NULL,'standard',190903,'2026-02-09 00:19:01','2026-02-09 00:19:13',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,1),(76,'Miko Wooden Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-190-A0',0,10,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,445,NULL,NULL,NULL,20,18,12,671,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(77,'Miko Wooden Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-190-A0-A1',0,10,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,445,NULL,NULL,NULL,20,18,12,671,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(78,'Miko Wooden Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-51.jpg\"]',NULL,'NC-190-A0-A2',0,10,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,445,NULL,NULL,NULL,20,18,12,671,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(79,'Gorgeous Wooden Gloves',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-163-A0',0,11,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,414,NULL,NULL,NULL,20,18,18,795,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(80,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-16.jpg\"]',NULL,'NC-188-A0',0,16,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,345,NULL,NULL,NULL,18,20,10,857,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(81,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-188-A0-A1',0,16,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,345,NULL,NULL,NULL,18,20,10,857,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(82,'Gorgeous Aluminum Table',NULL,NULL,NULL,'published','[\"products\\/product-7.jpg\"]',NULL,'NC-144-A0',0,20,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,234,187.2,NULL,NULL,17,18,10,762,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(83,'Evo Lightweight Granite Shirt',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-132-A0',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,487,NULL,NULL,NULL,15,12,18,837,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(84,'Evo Lightweight Granite Shirt',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-132-A0-A1',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,487,NULL,NULL,NULL,15,12,18,837,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(85,'CLCo. Incredible Paper Car',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-129-A0',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,270,NULL,NULL,NULL,14,12,11,535,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(86,'CLCo. Incredible Paper Car',NULL,NULL,NULL,'published','[\"products\\/product-3.jpg\"]',NULL,'NC-129-A0-A1',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,270,NULL,NULL,NULL,14,12,11,535,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(87,'CLCo. Incredible Paper Car',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-129-A0-A2',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,270,NULL,NULL,NULL,14,12,11,535,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(88,'CLCo. Incredible Paper Car',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-129-A0-A3',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,270,NULL,NULL,NULL,14,12,11,535,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(89,'CLCo. Incredible Paper Car',NULL,NULL,NULL,'published','[\"products\\/product-11.jpg\"]',NULL,'NC-129-A0-A4',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,270,NULL,NULL,NULL,14,12,11,535,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(90,'Progash Durable Granite Hat',NULL,NULL,NULL,'published','[\"products\\/product-7.jpg\"]',NULL,'NC-163-A0',0,12,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,321,NULL,NULL,NULL,19,20,12,654,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(91,'Progash Durable Granite Hat',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-163-A0-A1',0,12,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,321,NULL,NULL,NULL,19,20,12,654,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(92,'Purab Enormous Miranda Bottle',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-125-A0',0,14,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,214,160.5,NULL,NULL,12,18,12,671,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(93,'Purab Enormous Miranda Bottle',NULL,NULL,NULL,'published','[\"products\\/product-37.jpg\"]',NULL,'NC-125-A0-A1',0,14,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,214,177.62,NULL,NULL,12,18,12,671,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(94,'Miklonda Co. Crafted Candles',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-194-A0',0,18,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,336,NULL,NULL,NULL,16,10,14,638,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(95,'Miklonda Co. Crafted Candles',NULL,NULL,NULL,'published','[\"products\\/product-3.jpg\"]',NULL,'NC-194-A0-A1',0,18,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,336,NULL,NULL,NULL,16,10,14,638,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(96,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-7.jpg\"]',NULL,'NC-161-A0',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,243,NULL,NULL,NULL,20,15,18,790,NULL,'standard',0,'2026-02-09 00:19:01','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(97,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-21.jpg\"]',NULL,'NC-161-A0-A1',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,243,NULL,NULL,NULL,20,15,18,790,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(98,'Dual Camera 20MP',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-111-A0',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,313,NULL,NULL,NULL,10,10,12,566,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(99,'Dual Camera 20MP',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-111-A0-A1',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,313,NULL,NULL,NULL,10,10,12,566,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(100,'Dual Camera 20MP',NULL,NULL,NULL,'published','[\"products\\/product-22.jpg\"]',NULL,'NC-111-A0-A2',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,313,NULL,NULL,NULL,10,10,12,566,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(101,'Smart Watches',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-152-A0',0,16,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,469,356.44,NULL,NULL,16,10,14,693,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(102,'Smart Watches',NULL,NULL,NULL,'published','[\"products\\/product-11.jpg\"]',NULL,'NC-152-A0-A1',0,16,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,469,356.44,NULL,NULL,16,10,14,693,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(103,'Beat Headphone',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-119-A0',0,19,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,333,NULL,NULL,NULL,19,18,14,657,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(104,'Beat Headphone',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-119-A0-A1',0,19,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,333,NULL,NULL,NULL,19,18,14,657,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(105,'Beat Headphone',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-119-A0-A2',0,19,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,333,NULL,NULL,NULL,19,18,14,657,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(106,'Red & Black Headphone',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-151-A0',0,20,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,344,NULL,NULL,NULL,19,20,10,518,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(107,'Red & Black Headphone',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-151-A0-A1',0,20,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,344,NULL,NULL,NULL,19,20,10,518,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(108,'Red & Black Headphone',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-151-A0-A2',0,20,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,344,NULL,NULL,NULL,19,20,10,518,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(109,'Smart Watch External',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-153-A0',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,459,NULL,NULL,NULL,11,20,19,747,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(110,'Smart Watch External',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-153-A0-A1',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,459,NULL,NULL,NULL,11,20,19,747,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(111,'Smart Watch External',NULL,NULL,NULL,'published','[\"products\\/product-24.jpg\"]',NULL,'NC-153-A0-A2',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,459,NULL,NULL,NULL,11,20,19,747,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(112,'Nikon HD camera',NULL,NULL,NULL,'published','[\"products\\/product-24.jpg\"]',NULL,'NC-172-A0',0,13,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,269,234.03,NULL,NULL,14,10,19,663,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(113,'Nikon HD camera',NULL,NULL,NULL,'published','[\"products\\/product-25.jpg\"]',NULL,'NC-172-A0-A1',0,13,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,269,220.58,NULL,NULL,14,10,19,663,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(114,'Nikon HD camera',NULL,NULL,NULL,'published','[\"products\\/product-55.jpg\"]',NULL,'NC-172-A0-A2',0,13,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,269,201.75,NULL,NULL,14,10,19,663,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(115,'Audio Equipment',NULL,NULL,NULL,'published','[\"products\\/product-55.jpg\"]',NULL,'NC-101-A0',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,403,NULL,NULL,NULL,17,16,13,787,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(116,'Audio Equipment',NULL,NULL,NULL,'published','[\"products\\/product-62.jpg\"]',NULL,'NC-101-A0-A1',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,403,NULL,NULL,NULL,17,16,13,787,NULL,'standard',0,'2026-02-09 00:19:02','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(117,'Smart Televisions',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-162-A0',0,10,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,469,NULL,NULL,NULL,20,19,17,899,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(118,'Smart Televisions',NULL,NULL,NULL,'published','[\"products\\/product-15.jpg\"]',NULL,'NC-162-A0-A1',0,10,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,469,NULL,NULL,NULL,20,19,17,899,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(119,'Smart Televisions',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-162-A0-A2',0,10,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,469,NULL,NULL,NULL,20,19,17,899,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(120,'Samsung Smart Phone',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-102-A0',0,15,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,382,NULL,NULL,NULL,15,11,16,642,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:10',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(121,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-150-A0',0,16,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,396,285.12,NULL,NULL,14,15,20,609,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(122,'Xbox One Wireless Controller Black Color',NULL,NULL,NULL,'published','[\"products\\/product-14.jpg\"]',NULL,'NC-168-A0',0,17,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,429,NULL,NULL,NULL,13,14,18,521,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(123,'Xbox One Wireless Controller Black Color',NULL,NULL,NULL,'published','[\"products\\/product-35.jpg\"]',NULL,'NC-168-A0-A1',0,17,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,429,NULL,NULL,NULL,13,14,18,521,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(124,'EPSION Plaster Printer',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-190-A0',0,16,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,494,NULL,NULL,NULL,19,11,15,612,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(125,'EPSION Plaster Printer',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-190-A0-A1',0,16,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,494,NULL,NULL,NULL,19,11,15,612,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(126,'EPSION Plaster Printer',NULL,NULL,NULL,'published','[\"products\\/product-15.jpg\"]',NULL,'NC-190-A0-A2',0,16,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,494,NULL,NULL,NULL,19,11,15,612,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(127,'Sound Intone I65 Earphone White Version',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-166-A0',0,10,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,352,NULL,NULL,NULL,11,13,18,745,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(128,'Sound Intone I65 Earphone White Version',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-166-A0-A1',0,10,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,352,NULL,NULL,NULL,11,13,18,745,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(129,'Sound Intone I65 Earphone White Version',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-166-A0-A2',0,10,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,352,NULL,NULL,NULL,11,13,18,745,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(130,'B&O Play Mini Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-156-A0',0,12,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,208,147.68,NULL,NULL,15,14,15,822,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(131,'B&O Play Mini Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-156-A0-A1',0,12,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,208,153.92,NULL,NULL,15,14,15,822,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(132,'B&O Play Mini Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-38.jpg\"]',NULL,'NC-156-A0-A2',0,12,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,208,172.64,NULL,NULL,15,14,15,822,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(133,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-103-A0',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,262,NULL,NULL,NULL,10,15,18,743,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(134,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-103-A0-A1',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,262,NULL,NULL,NULL,10,15,18,743,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(135,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-103-A0-A2',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,262,NULL,NULL,NULL,10,15,18,743,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(136,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-16.jpg\"]',NULL,'NC-103-A0-A3',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,262,NULL,NULL,NULL,10,15,18,743,NULL,'standard',0,'2026-02-09 00:19:03','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(137,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-3.jpg\"]',NULL,'NC-180-A0',0,17,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,394,NULL,NULL,NULL,16,15,15,737,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(138,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-20.jpg\"]',NULL,'NC-180-A0-A1',0,17,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,394,NULL,NULL,NULL,16,15,15,737,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(139,'Samsung Gear VR Virtual Reality Headset',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-190-A0',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,401,NULL,NULL,NULL,14,18,15,644,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(140,'Samsung Gear VR Virtual Reality Headset',NULL,NULL,NULL,'published','[\"products\\/product-7.jpg\"]',NULL,'NC-190-A0-A1',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,401,NULL,NULL,NULL,14,18,15,644,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(141,'Samsung Gear VR Virtual Reality Headset',NULL,NULL,NULL,'published','[\"products\\/product-29.jpg\"]',NULL,'NC-190-A0-A2',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,401,NULL,NULL,NULL,14,18,15,644,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(142,'Samsung Gear VR Virtual Reality Headset',NULL,NULL,NULL,'published','[\"products\\/product-53.jpg\"]',NULL,'NC-190-A0-A3',0,15,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,401,NULL,NULL,NULL,14,18,15,644,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(143,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL,NULL,'published','[\"products\\/product-18.jpg\"]',NULL,'NC-181-A0',0,17,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,305,256.2,NULL,NULL,18,17,19,519,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(144,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL,NULL,'published','[\"products\\/product-36.jpg\"]',NULL,'NC-181-A0-A1',0,17,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,305,253.15,NULL,NULL,18,17,19,519,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(145,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL,NULL,'published','[\"products\\/product-39.jpg\"]',NULL,'NC-181-A0-A2',0,17,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,305,253.15,NULL,NULL,18,17,19,519,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(146,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-138-A0',0,19,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,306,NULL,NULL,NULL,19,10,13,598,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(147,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-18.jpg\"]',NULL,'NC-138-A0-A1',0,19,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,306,NULL,NULL,NULL,19,10,13,598,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(148,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-163-A0',0,15,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,474,NULL,NULL,NULL,11,16,14,629,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(149,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-163-A0-A1',0,15,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,474,NULL,NULL,NULL,11,16,14,629,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(150,'MVMTH Classical Leather Watch In Black',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-147-A0',0,17,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,500,NULL,NULL,NULL,12,15,13,646,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(151,'MVMTH Classical Leather Watch In Black',NULL,NULL,NULL,'published','[\"products\\/product-21.jpg\"]',NULL,'NC-147-A0-A1',0,17,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,500,NULL,NULL,NULL,12,15,13,646,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(152,'MVMTH Classical Leather Watch In Black',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-147-A0-A2',0,17,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,500,NULL,NULL,NULL,12,15,13,646,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(153,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-128-A0',0,12,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,413,322.14,NULL,NULL,15,16,20,856,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(154,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,NULL,'published','[\"products\\/product-7.jpg\"]',NULL,'NC-128-A0-A1',0,12,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,413,301.49,NULL,NULL,15,16,20,856,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(155,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,NULL,'published','[\"products\\/product-15.jpg\"]',NULL,'NC-128-A0-A2',0,12,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,413,363.44,NULL,NULL,15,16,20,856,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(156,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,NULL,'published','[\"products\\/product-21.jpg\"]',NULL,'NC-128-A0-A3',0,12,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,413,342.79,NULL,NULL,15,16,20,856,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(157,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-174-A0',0,10,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,383,NULL,NULL,NULL,15,13,18,698,NULL,'standard',0,'2026-02-09 00:19:04','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(158,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,NULL,'published','[\"products\\/product-18.jpg\"]',NULL,'NC-174-A0-A1',0,10,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,383,NULL,NULL,NULL,15,13,18,698,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(159,'Vimto Squash Remix Apple 1.5 Litres',NULL,NULL,NULL,'published','[\"products\\/product-25.jpg\"]',NULL,'NC-170-A0',0,12,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,237,NULL,NULL,NULL,16,10,17,659,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(160,'Crock Pot Slow Cooker',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-121-A0',0,12,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,303,NULL,NULL,NULL,19,13,13,509,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(161,'Taylors of Harrogate Yorkshire Coffee',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-116-A0',0,15,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,270,218.7,NULL,NULL,12,11,12,691,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(162,'Taylors of Harrogate Yorkshire Coffee',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-116-A0-A1',0,15,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,270,191.7,NULL,NULL,12,11,12,691,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(163,'Taylors of Harrogate Yorkshire Coffee',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-116-A0-A2',0,15,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,270,213.3,NULL,NULL,12,11,12,691,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(164,'Soft Mochi & Galeto Ice Cream',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-154-A0',0,11,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,296,NULL,NULL,NULL,10,17,16,797,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(165,'Soft Mochi & Galeto Ice Cream',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-154-A0-A1',0,11,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,296,NULL,NULL,NULL,10,17,16,797,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(166,'Naked Noodle Egg Noodles Singapore',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-196-A0',0,10,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,350,NULL,NULL,NULL,13,12,19,554,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(167,'Naked Noodle Egg Noodles Singapore',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-196-A0-A1',0,10,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,350,NULL,NULL,NULL,13,12,19,554,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(168,'Naked Noodle Egg Noodles Singapore',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-196-A0-A2',0,10,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,350,NULL,NULL,NULL,13,12,19,554,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(169,'Saute Pan Silver',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-193-A0',0,14,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,326,NULL,NULL,NULL,13,13,15,839,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(170,'Saute Pan Silver',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-193-A0-A1',0,14,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,326,NULL,NULL,NULL,13,13,15,839,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(171,'Saute Pan Silver',NULL,NULL,NULL,'published','[\"products\\/product-14.jpg\"]',NULL,'NC-193-A0-A2',0,14,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,326,NULL,NULL,NULL,13,13,15,839,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(172,'Saute Pan Silver',NULL,NULL,NULL,'published','[\"products\\/product-35.jpg\"]',NULL,'NC-193-A0-A3',0,14,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,326,NULL,NULL,NULL,13,13,15,839,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(173,'Saute Pan Silver',NULL,NULL,NULL,'published','[\"products\\/product-42.jpg\"]',NULL,'NC-193-A0-A4',0,14,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,326,NULL,NULL,NULL,13,13,15,839,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(174,'Bar S – Classic Bun Length Franks',NULL,NULL,NULL,'published','[\"products\\/product-11.jpg\"]',NULL,'NC-188-A0',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,353,292.99,NULL,NULL,20,13,17,868,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(175,'Bar S – Classic Bun Length Franks',NULL,NULL,NULL,'published','[\"products\\/product-25.jpg\"]',NULL,'NC-188-A0-A1',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,353,257.69,NULL,NULL,20,13,17,868,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(176,'Broccoli Crowns',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-176-A0',0,20,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,396,NULL,NULL,NULL,13,15,20,794,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(177,'Broccoli Crowns',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-176-A0-A1',0,20,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,396,NULL,NULL,NULL,13,15,20,794,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(178,'Slimming World Vegan Mac Greens',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-137-A0',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,223,NULL,NULL,NULL,11,15,11,639,NULL,'standard',0,'2026-02-09 00:19:05','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(179,'Slimming World Vegan Mac Greens',NULL,NULL,NULL,'published','[\"products\\/product-11.jpg\"]',NULL,'NC-137-A0-A1',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,223,NULL,NULL,NULL,11,15,11,639,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(180,'Slimming World Vegan Mac Greens',NULL,NULL,NULL,'published','[\"products\\/product-43.jpg\"]',NULL,'NC-137-A0-A2',0,18,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,223,NULL,NULL,NULL,11,15,11,639,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(181,'Häagen-Dazs Salted Caramel',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-179-A0',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,361,NULL,NULL,NULL,12,15,11,880,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(182,'Häagen-Dazs Salted Caramel',NULL,NULL,NULL,'published','[\"products\\/product-18.jpg\"]',NULL,'NC-179-A0-A1',0,11,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,361,NULL,NULL,NULL,12,15,11,880,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(183,'Iceland 3 Solo Exotic Burst',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-128-A0',0,19,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,377,335.53,NULL,NULL,17,12,16,834,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(184,'Iceland 3 Solo Exotic Burst',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-128-A0-A1',0,19,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,377,339.3,NULL,NULL,17,12,16,834,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(185,'Iceland 3 Solo Exotic Burst',NULL,NULL,NULL,'published','[\"products\\/product-15.jpg\"]',NULL,'NC-128-A0-A2',0,19,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,377,301.6,NULL,NULL,17,12,16,834,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(186,'Extreme Budweiser Light Can',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-192-A0',0,12,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,488,NULL,NULL,NULL,16,12,18,653,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(187,'Extreme Budweiser Light Can',NULL,NULL,NULL,'published','[\"products\\/product-32.jpg\"]',NULL,'NC-192-A0-A1',0,12,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,488,NULL,NULL,NULL,16,12,18,653,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(188,'Extreme Budweiser Light Can',NULL,NULL,NULL,'published','[\"products\\/product-49.jpg\"]',NULL,'NC-192-A0-A2',0,12,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,488,NULL,NULL,NULL,16,12,18,653,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(189,'Iceland Macaroni Cheese Traybake',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-102-A0',0,13,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,483,NULL,NULL,NULL,12,11,13,892,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(190,'Dolmio Bolognese Pasta Sauce',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-139-A0',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,340,NULL,NULL,NULL,11,14,15,874,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(191,'Dolmio Bolognese Pasta Sauce',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-139-A0-A1',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,340,NULL,NULL,NULL,11,14,15,874,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(192,'Dolmio Bolognese Pasta Sauce',NULL,NULL,NULL,'published','[\"products\\/product-34.jpg\"]',NULL,'NC-139-A0-A2',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,340,NULL,NULL,NULL,11,14,15,874,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:11',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(193,'Sitema BakeIT Plastic Box',NULL,NULL,NULL,'published','[\"products\\/product-3.jpg\"]',NULL,'NC-188-A0',0,19,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,399,323.19,NULL,NULL,18,11,17,728,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(194,'Sitema BakeIT Plastic Box',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-188-A0-A1',0,19,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,399,319.2,NULL,NULL,18,11,17,728,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(195,'Sitema BakeIT Plastic Box',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-188-A0-A2',0,19,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,399,299.25,NULL,NULL,18,11,17,728,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(196,'Wayfair Basics Dinner Plate Storage',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-121-A0',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,355,NULL,NULL,NULL,16,10,13,684,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(197,'Wayfair Basics Dinner Plate Storage',NULL,NULL,NULL,'published','[\"products\\/product-14.jpg\"]',NULL,'NC-121-A0-A1',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,355,NULL,NULL,NULL,16,10,13,684,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(198,'Wayfair Basics Dinner Plate Storage',NULL,NULL,NULL,'published','[\"products\\/product-20.jpg\"]',NULL,'NC-121-A0-A2',0,10,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,355,NULL,NULL,NULL,16,10,13,684,NULL,'standard',0,'2026-02-09 00:19:06','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(199,'Miko The Panda Water Bottle',NULL,NULL,NULL,'published','[\"products\\/product-3.jpg\"]',NULL,'NC-181-A0',0,12,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,233,NULL,NULL,NULL,15,16,10,814,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(200,'Sesame Seed Bread',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-105-A0',0,20,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,407,NULL,NULL,NULL,17,20,10,780,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(201,'Morrisons The Best Beef',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-168-A0',0,20,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,439,338.03,NULL,NULL,17,18,19,820,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(202,'Morrisons The Best Beef',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-168-A0-A1',0,20,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,439,364.37,NULL,NULL,17,18,19,820,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(203,'Morrisons The Best Beef',NULL,NULL,NULL,'published','[\"products\\/product-18.jpg\"]',NULL,'NC-168-A0-A2',0,20,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,439,333.64,NULL,NULL,17,18,19,820,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(204,'Avocado, Hass Large',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-129-A0',0,15,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,222,NULL,NULL,NULL,15,11,14,567,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(205,'Avocado, Hass Large',NULL,NULL,NULL,'published','[\"products\\/product-22.jpg\"]',NULL,'NC-129-A0-A1',0,15,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,222,NULL,NULL,NULL,15,11,14,567,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(206,'Italia Beef Lasagne',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-163-A0',0,18,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,399,NULL,NULL,NULL,17,19,20,863,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(207,'Italia Beef Lasagne',NULL,NULL,NULL,'published','[\"products\\/product-7.jpg\"]',NULL,'NC-163-A0-A1',0,18,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,399,NULL,NULL,NULL,17,19,20,863,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(208,'Italia Beef Lasagne',NULL,NULL,NULL,'published','[\"products\\/product-26.jpg\"]',NULL,'NC-163-A0-A2',0,18,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,399,NULL,NULL,NULL,17,19,20,863,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(209,'Maxwell House Classic Roast Mocha',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-190-A0',0,13,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,325,NULL,NULL,NULL,12,19,18,751,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(210,'Maxwell House Classic Roast Mocha',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-190-A0-A1',0,13,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,325,NULL,NULL,NULL,12,19,18,751,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(211,'Maxwell House Classic Roast Mocha',NULL,NULL,NULL,'published','[\"products\\/product-43.jpg\"]',NULL,'NC-190-A0-A2',0,13,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,325,NULL,NULL,NULL,12,19,18,751,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(212,'Bottled Pure Water 500ml',NULL,NULL,NULL,'published','[\"products\\/product-14.jpg\"]',NULL,'NC-147-A0',0,11,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,302,250.66,NULL,NULL,17,13,14,888,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(213,'Bottled Pure Water 500ml',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-147-A0-A1',0,11,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,302,268.78,NULL,NULL,17,13,14,888,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(214,'Famart Farmhouse Soft White',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-111-A0',0,13,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,283,NULL,NULL,NULL,20,14,20,645,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(215,'Famart Farmhouse Soft White',NULL,NULL,NULL,'published','[\"products\\/product-16.jpg\"]',NULL,'NC-111-A0-A1',0,13,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,283,NULL,NULL,NULL,20,14,20,645,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(216,'Famart Farmhouse Soft White',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-111-A0-A2',0,13,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,283,NULL,NULL,NULL,20,14,20,645,NULL,'standard',0,'2026-02-09 00:19:07','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(217,'Coca-Cola Original Taste',NULL,NULL,NULL,'published','[\"products\\/product-16.jpg\"]',NULL,'NC-110-A0',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,317,NULL,NULL,NULL,13,19,13,604,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(218,'Coca-Cola Original Taste',NULL,NULL,NULL,'published','[\"products\\/product-56.jpg\"]',NULL,'NC-110-A0-A1',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,317,NULL,NULL,NULL,13,19,13,604,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(219,'Casillero Diablo Cabernet Sauvignon',NULL,NULL,NULL,'published','[\"products\\/product-3.jpg\"]',NULL,'NC-188-A0',0,12,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,212,NULL,NULL,NULL,10,18,18,837,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(220,'Casillero Diablo Cabernet Sauvignon',NULL,NULL,NULL,'published','[\"products\\/product-63.jpg\"]',NULL,'NC-188-A0-A1',0,12,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,212,NULL,NULL,NULL,10,18,18,837,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(221,'Casillero Diablo Cabernet Sauvignon',NULL,NULL,NULL,'published','[\"products\\/product-65.jpg\"]',NULL,'NC-188-A0-A2',0,12,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,212,NULL,NULL,NULL,10,18,18,837,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(222,'Casillero Diablo Cabernet Sauvignon',NULL,NULL,NULL,'published','[\"products\\/product-66.jpg\"]',NULL,'NC-188-A0-A3',0,12,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,212,NULL,NULL,NULL,10,18,18,837,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(223,'Arla Organic Free Range Milk',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-114-A0',0,20,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,318,228.96,NULL,NULL,12,12,16,772,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(224,'Aptamil Follow On Baby Milk',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-120-A0',0,14,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,473,NULL,NULL,NULL,17,10,14,580,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(225,'Aptamil Follow On Baby Milk',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-120-A0-A1',0,14,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,473,NULL,NULL,NULL,17,10,14,580,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(226,'Cuisinart Chef’S Classic Hard-Anodized',NULL,NULL,NULL,'published','[\"products\\/product-15.jpg\"]',NULL,'NC-132-A0',0,14,0,1,'in_stock',0,NULL,7,1,0,0,0.00,0,349,NULL,NULL,NULL,20,20,20,533,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(227,'Corn, Yellow Sweet',NULL,NULL,NULL,'published','[\"products\\/product-15.jpg\"]',NULL,'NC-170-A0',0,20,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,255,NULL,NULL,NULL,16,10,17,900,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(228,'Corn, Yellow Sweet',NULL,NULL,NULL,'published','[\"products\\/product-16.jpg\"]',NULL,'NC-170-A0-A1',0,20,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,255,NULL,NULL,NULL,16,10,17,900,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(229,'Hobnobs The Nobbly Biscuit',NULL,NULL,NULL,'published','[\"products\\/product-25.jpg\"]',NULL,'NC-155-A0',0,15,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,487,399.34,NULL,NULL,14,15,19,538,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(230,'Hobnobs The Nobbly Biscuit',NULL,NULL,NULL,'published','[\"products\\/product-26.jpg\"]',NULL,'NC-155-A0-A1',0,15,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,487,394.47,NULL,NULL,14,15,19,538,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(231,'Hobnobs The Nobbly Biscuit',NULL,NULL,NULL,'published','[\"products\\/product-55.jpg\"]',NULL,'NC-155-A0-A2',0,15,0,1,'in_stock',0,NULL,1,1,0,0,0.00,0,487,428.56,NULL,NULL,14,15,19,538,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(232,'Honest Organic Still Lemonade',NULL,NULL,NULL,'published','[\"products\\/product-1.jpg\"]',NULL,'NC-157-A0',0,10,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,292,NULL,NULL,NULL,14,18,19,508,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(233,'Honest Organic Still Lemonade',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-157-A0-A1',0,10,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,292,NULL,NULL,NULL,14,18,19,508,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(234,'Honest Organic Still Lemonade',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-157-A0-A2',0,10,0,1,'in_stock',0,NULL,6,1,0,0,0.00,0,292,NULL,NULL,NULL,14,18,19,508,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(235,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-122-A0',0,15,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,294,NULL,NULL,NULL,10,20,18,776,NULL,'standard',0,'2026-02-09 00:19:08','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(236,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,NULL,NULL,'published','[\"products\\/product-48.jpg\"]',NULL,'NC-122-A0-A1',0,15,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,294,NULL,NULL,NULL,10,20,18,776,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(237,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,NULL,NULL,'published','[\"products\\/product-49.jpg\"]',NULL,'NC-122-A0-A2',0,15,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,294,NULL,NULL,NULL,10,20,18,776,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(238,'Iceland 6 Hot Cross Buns',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-130-A0',0,16,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,269,NULL,NULL,NULL,16,14,12,757,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(239,'Iceland 6 Hot Cross Buns',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-130-A0-A1',0,16,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,269,NULL,NULL,NULL,16,14,12,757,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(240,'Iceland 6 Hot Cross Buns',NULL,NULL,NULL,'published','[\"products\\/product-50.jpg\"]',NULL,'NC-130-A0-A2',0,16,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,269,NULL,NULL,NULL,16,14,12,757,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(241,'Iceland Luxury 4 Panini Rolls',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-136-A0',0,15,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,469,379.89,NULL,NULL,20,19,16,587,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(242,'Iceland Luxury 4 Panini Rolls',NULL,NULL,NULL,'published','[\"products\\/product-27.jpg\"]',NULL,'NC-136-A0-A1',0,15,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,469,342.37,NULL,NULL,20,19,16,587,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(243,'Iceland Luxury 4 Panini Rolls',NULL,NULL,NULL,'published','[\"products\\/product-46.jpg\"]',NULL,'NC-136-A0-A2',0,15,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,469,351.75,NULL,NULL,20,19,16,587,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(244,'Iceland Soft Scoop Vanilla',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-193-A0',0,20,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,441,NULL,NULL,NULL,14,11,13,579,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(245,'Iceland Soft Scoop Vanilla',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-193-A0-A1',0,20,0,1,'in_stock',0,NULL,2,1,0,0,0.00,0,441,NULL,NULL,NULL,14,11,13,579,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(246,'Iceland Spaghetti Bolognese',NULL,NULL,NULL,'published','[\"products\\/product-15.jpg\"]',NULL,'NC-126-A0',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,356,NULL,NULL,NULL,16,13,12,825,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(247,'Iceland Spaghetti Bolognese',NULL,NULL,NULL,'published','[\"products\\/product-22.jpg\"]',NULL,'NC-126-A0-A1',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,356,NULL,NULL,NULL,16,13,12,825,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(248,'Kellogg’s Coco Pops Cereal',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-119-A0',0,13,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,233,NULL,NULL,NULL,19,16,17,817,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(249,'Kellogg’s Coco Pops Cereal',NULL,NULL,NULL,'published','[\"products\\/product-35.jpg\"]',NULL,'NC-119-A0-A1',0,13,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,233,NULL,NULL,NULL,19,16,17,817,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(250,'Kellogg’s Coco Pops Cereal',NULL,NULL,NULL,'published','[\"products\\/product-60.jpg\"]',NULL,'NC-119-A0-A2',0,13,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,233,NULL,NULL,NULL,19,16,17,817,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(251,'Kit Kat Chunky Milk Chocolate',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-183-A0',0,19,0,1,'in_stock',0,NULL,4,1,0,0,0.00,0,436,305.2,NULL,NULL,20,17,18,638,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(252,'Large Green Bell Pepper',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-183-A0',0,13,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,495,NULL,NULL,NULL,10,14,16,854,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(253,'Pice 94w Beasley Journal',NULL,NULL,NULL,'published','[\"products\\/product-3.jpg\"]',NULL,'NC-186-A0',0,18,0,1,'in_stock',0,NULL,3,1,0,0,0.00,0,251,NULL,NULL,NULL,20,12,12,542,NULL,'standard',0,'2026-02-09 00:19:09','2026-02-09 00:19:12',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(254,'Province Piece Glass Drinking Glass',NULL,NULL,NULL,'published','[\"products\\/product-7.jpg\"]',NULL,'NC-109-A0',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,322,NULL,NULL,NULL,12,14,16,876,NULL,'standard',0,'2026-02-09 00:19:10','2026-02-09 00:19:13',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(255,'Province Piece Glass Drinking Glass',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-109-A0-A1',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,322,NULL,NULL,NULL,12,14,16,876,NULL,'standard',0,'2026-02-09 00:19:10','2026-02-09 00:19:13',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(256,'Province Piece Glass Drinking Glass',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-109-A0-A2',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,322,NULL,NULL,NULL,12,14,16,876,NULL,'standard',0,'2026-02-09 00:19:10','2026-02-09 00:19:13',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(257,'Province Piece Glass Drinking Glass',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-109-A0-A3',0,11,0,1,'in_stock',0,NULL,5,1,0,0,0.00,0,322,NULL,NULL,NULL,12,14,16,876,NULL,'standard',0,'2026-02-09 00:19:10','2026-02-09 00:19:13',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,NULL,0,0,'auto_generate',0,0,0,NULL);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`),
  KEY `idx_products_fk` (`ec_products_id`),
  KEY `idx_products_products_lang` (`ec_products_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_unique` (`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`),
  KEY `ec_reviews_product_id_status_index` (`product_id`,`status`),
  KEY `ec_reviews_customer_id_status_index` (`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=705 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,2,NULL,NULL,41,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(2,1,NULL,NULL,54,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(3,3,NULL,NULL,74,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(4,4,NULL,NULL,27,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(5,7,NULL,NULL,21,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(6,4,NULL,NULL,23,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(7,10,NULL,NULL,40,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(8,2,NULL,NULL,67,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(9,2,NULL,NULL,65,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(10,8,NULL,NULL,73,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(11,5,NULL,NULL,18,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(12,8,NULL,NULL,52,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(13,9,NULL,NULL,13,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(14,1,NULL,NULL,33,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(15,4,NULL,NULL,72,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(16,6,NULL,NULL,55,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(17,3,NULL,NULL,58,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(18,7,NULL,NULL,35,1,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(19,3,NULL,NULL,3,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(20,8,NULL,NULL,62,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(21,8,NULL,NULL,7,1,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(22,6,NULL,NULL,39,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(23,8,NULL,NULL,54,3,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(24,8,NULL,NULL,5,1,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(25,3,NULL,NULL,33,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(26,9,NULL,NULL,34,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(27,2,NULL,NULL,14,3,'Clean & perfect source code','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(28,6,NULL,NULL,57,5,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(29,1,NULL,NULL,61,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(30,5,NULL,NULL,6,2,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(31,5,NULL,NULL,24,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(32,6,NULL,NULL,61,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(33,6,NULL,NULL,67,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(34,1,NULL,NULL,41,4,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(35,9,NULL,NULL,35,1,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(36,6,NULL,NULL,13,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(37,7,NULL,NULL,13,3,'Clean & perfect source code','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(38,1,NULL,NULL,30,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(39,10,NULL,NULL,16,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(40,5,NULL,NULL,55,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(41,10,NULL,NULL,14,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(42,1,NULL,NULL,67,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(43,2,NULL,NULL,44,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(44,9,NULL,NULL,24,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(45,6,NULL,NULL,63,4,'Clean & perfect source code','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(46,10,NULL,NULL,27,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(47,6,NULL,NULL,31,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(48,3,NULL,NULL,17,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(49,1,NULL,NULL,58,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(50,4,NULL,NULL,28,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(51,4,NULL,NULL,70,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(52,3,NULL,NULL,32,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(53,3,NULL,NULL,40,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(54,4,NULL,NULL,21,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(55,8,NULL,NULL,17,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(56,10,NULL,NULL,18,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(57,1,NULL,NULL,18,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(58,2,NULL,NULL,70,3,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(59,2,NULL,NULL,13,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(60,8,NULL,NULL,13,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(61,2,NULL,NULL,69,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(62,1,NULL,NULL,6,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(63,8,NULL,NULL,38,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(64,8,NULL,NULL,33,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(65,8,NULL,NULL,67,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(66,5,NULL,NULL,27,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(67,8,NULL,NULL,23,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(68,8,NULL,NULL,51,3,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(69,10,NULL,NULL,30,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(70,5,NULL,NULL,11,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(71,5,NULL,NULL,65,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(72,5,NULL,NULL,19,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(73,6,NULL,NULL,38,2,'Clean & perfect source code','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(74,3,NULL,NULL,31,2,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(75,9,NULL,NULL,66,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(76,10,NULL,NULL,55,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(77,2,NULL,NULL,23,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(78,4,NULL,NULL,13,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(79,4,NULL,NULL,55,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(80,2,NULL,NULL,24,4,'Clean & perfect source code','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(81,4,NULL,NULL,48,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(82,1,NULL,NULL,32,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(83,4,NULL,NULL,31,2,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(84,3,NULL,NULL,2,3,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(85,7,NULL,NULL,32,2,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(86,5,NULL,NULL,50,2,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(87,9,NULL,NULL,27,3,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(88,5,NULL,NULL,33,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(89,1,NULL,NULL,11,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(90,3,NULL,NULL,63,1,'Clean & perfect source code','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(91,7,NULL,NULL,25,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(92,2,NULL,NULL,34,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(93,7,NULL,NULL,30,2,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(94,7,NULL,NULL,40,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(95,7,NULL,NULL,9,2,'Best ecommerce CMS online store!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(96,9,NULL,NULL,74,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(97,9,NULL,NULL,56,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(98,3,NULL,NULL,5,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(99,10,NULL,NULL,28,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(100,4,NULL,NULL,8,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(101,5,NULL,NULL,5,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(102,1,NULL,NULL,49,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(103,4,NULL,NULL,52,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:16','2026-02-09 00:19:16',NULL),(104,9,NULL,NULL,33,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(105,6,NULL,NULL,66,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(106,9,NULL,NULL,15,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(107,10,NULL,NULL,37,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(108,8,NULL,NULL,48,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(109,3,NULL,NULL,10,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(110,6,NULL,NULL,54,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(111,2,NULL,NULL,33,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(112,6,NULL,NULL,12,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(113,3,NULL,NULL,25,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(114,2,NULL,NULL,27,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(115,6,NULL,NULL,9,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(116,3,NULL,NULL,13,5,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(117,5,NULL,NULL,13,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(118,1,NULL,NULL,46,2,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(119,6,NULL,NULL,6,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(120,5,NULL,NULL,70,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(121,3,NULL,NULL,1,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(122,3,NULL,NULL,54,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(123,1,NULL,NULL,14,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(124,9,NULL,NULL,38,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(125,1,NULL,NULL,38,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(126,2,NULL,NULL,21,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(127,8,NULL,NULL,57,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(128,4,NULL,NULL,42,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(129,3,NULL,NULL,55,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(130,5,NULL,NULL,28,2,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(131,10,NULL,NULL,44,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(132,4,NULL,NULL,32,4,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(133,10,NULL,NULL,25,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(134,1,NULL,NULL,15,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(135,6,NULL,NULL,8,1,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(136,9,NULL,NULL,2,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(137,4,NULL,NULL,63,4,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(138,5,NULL,NULL,43,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(139,2,NULL,NULL,58,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(140,1,NULL,NULL,39,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(141,7,NULL,NULL,16,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(142,4,NULL,NULL,41,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(143,1,NULL,NULL,35,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(144,5,NULL,NULL,9,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(145,10,NULL,NULL,46,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(146,9,NULL,NULL,47,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(147,4,NULL,NULL,40,1,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(148,9,NULL,NULL,4,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(149,3,NULL,NULL,27,2,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(150,4,NULL,NULL,29,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(151,3,NULL,NULL,38,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(152,6,NULL,NULL,64,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(153,8,NULL,NULL,32,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(154,7,NULL,NULL,29,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(155,9,NULL,NULL,52,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(156,1,NULL,NULL,62,3,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(157,5,NULL,NULL,46,3,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(158,9,NULL,NULL,11,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(159,2,NULL,NULL,71,3,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(160,5,NULL,NULL,45,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(161,3,NULL,NULL,71,5,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(162,4,NULL,NULL,11,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(163,1,NULL,NULL,7,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(164,7,NULL,NULL,61,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(165,7,NULL,NULL,28,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(166,5,NULL,NULL,8,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(167,3,NULL,NULL,44,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(168,2,NULL,NULL,48,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(169,6,NULL,NULL,44,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(170,9,NULL,NULL,7,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(171,2,NULL,NULL,60,4,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(172,1,NULL,NULL,47,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(173,6,NULL,NULL,70,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(174,9,NULL,NULL,72,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(175,2,NULL,NULL,37,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(176,7,NULL,NULL,18,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(177,10,NULL,NULL,17,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(178,1,NULL,NULL,34,1,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(179,2,NULL,NULL,36,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(180,3,NULL,NULL,50,3,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(181,7,NULL,NULL,72,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(182,8,NULL,NULL,44,2,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(183,7,NULL,NULL,22,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(184,7,NULL,NULL,69,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(185,1,NULL,NULL,57,3,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(186,10,NULL,NULL,45,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(187,8,NULL,NULL,1,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(188,8,NULL,NULL,3,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(189,4,NULL,NULL,20,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(190,4,NULL,NULL,33,5,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(191,10,NULL,NULL,3,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(192,9,NULL,NULL,49,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(193,2,NULL,NULL,12,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(194,1,NULL,NULL,8,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(195,8,NULL,NULL,30,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(196,2,NULL,NULL,11,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(197,2,NULL,NULL,43,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(198,5,NULL,NULL,14,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(199,6,NULL,NULL,58,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(200,1,NULL,NULL,12,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(201,7,NULL,NULL,71,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(202,2,NULL,NULL,9,1,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(203,7,NULL,NULL,1,1,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(204,10,NULL,NULL,75,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(205,4,NULL,NULL,45,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(206,8,NULL,NULL,26,4,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(207,9,NULL,NULL,29,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(208,6,NULL,NULL,40,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(209,8,NULL,NULL,56,1,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(210,5,NULL,NULL,44,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(211,9,NULL,NULL,65,3,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(212,10,NULL,NULL,43,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(213,8,NULL,NULL,46,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(214,7,NULL,NULL,23,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(215,7,NULL,NULL,75,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(216,4,NULL,NULL,22,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(217,5,NULL,NULL,20,4,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(218,8,NULL,NULL,69,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(219,3,NULL,NULL,56,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(220,8,NULL,NULL,14,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(221,4,NULL,NULL,7,3,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(222,8,NULL,NULL,25,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(223,1,NULL,NULL,24,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(224,2,NULL,NULL,49,4,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(225,2,NULL,NULL,46,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(226,3,NULL,NULL,37,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(227,10,NULL,NULL,11,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(228,6,NULL,NULL,7,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(229,5,NULL,NULL,2,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(230,8,NULL,NULL,74,5,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(231,8,NULL,NULL,53,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(232,1,NULL,NULL,43,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(233,1,NULL,NULL,60,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(234,7,NULL,NULL,54,1,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(235,4,NULL,NULL,68,3,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(236,7,NULL,NULL,42,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(237,1,NULL,NULL,5,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(238,9,NULL,NULL,69,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(239,10,NULL,NULL,66,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(240,2,NULL,NULL,55,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(241,9,NULL,NULL,22,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(242,4,NULL,NULL,56,3,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(243,6,NULL,NULL,19,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(244,6,NULL,NULL,46,5,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(245,2,NULL,NULL,75,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(246,6,NULL,NULL,2,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(247,8,NULL,NULL,50,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(248,8,NULL,NULL,8,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(249,10,NULL,NULL,49,1,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(250,6,NULL,NULL,33,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(251,7,NULL,NULL,12,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(252,5,NULL,NULL,21,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(253,3,NULL,NULL,36,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(254,10,NULL,NULL,8,3,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(255,5,NULL,NULL,54,3,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(256,5,NULL,NULL,35,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(257,3,NULL,NULL,22,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(258,3,NULL,NULL,64,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(259,9,NULL,NULL,1,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(260,1,NULL,NULL,3,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(261,5,NULL,NULL,62,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(262,8,NULL,NULL,75,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(263,7,NULL,NULL,10,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(264,3,NULL,NULL,16,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(265,3,NULL,NULL,19,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(266,1,NULL,NULL,23,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(267,3,NULL,NULL,61,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(268,9,NULL,NULL,54,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(269,1,NULL,NULL,74,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(270,7,NULL,NULL,36,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(271,4,NULL,NULL,71,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(272,2,NULL,NULL,63,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(273,5,NULL,NULL,69,3,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(274,4,NULL,NULL,74,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(275,5,NULL,NULL,73,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(276,6,NULL,NULL,41,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(277,9,NULL,NULL,50,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(278,4,NULL,NULL,60,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(279,10,NULL,NULL,29,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(280,10,NULL,NULL,2,5,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(281,6,NULL,NULL,24,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(282,2,NULL,NULL,28,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(283,8,NULL,NULL,27,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(284,5,NULL,NULL,22,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(285,3,NULL,NULL,45,2,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(286,1,NULL,NULL,20,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(287,9,NULL,NULL,73,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(288,6,NULL,NULL,14,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(289,9,NULL,NULL,44,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(290,6,NULL,NULL,17,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(291,8,NULL,NULL,58,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(292,9,NULL,NULL,14,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(293,7,NULL,NULL,26,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(294,4,NULL,NULL,36,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(295,3,NULL,NULL,30,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(296,8,NULL,NULL,2,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(297,9,NULL,NULL,18,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(298,3,NULL,NULL,24,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(299,4,NULL,NULL,49,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(300,5,NULL,NULL,51,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(301,8,NULL,NULL,70,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(302,1,NULL,NULL,69,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(303,4,NULL,NULL,57,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(304,9,NULL,NULL,6,1,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(305,2,NULL,NULL,39,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(306,3,NULL,NULL,51,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(307,3,NULL,NULL,9,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(308,9,NULL,NULL,9,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(309,10,NULL,NULL,63,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(310,10,NULL,NULL,65,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(311,4,NULL,NULL,26,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(312,4,NULL,NULL,25,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(313,9,NULL,NULL,59,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(314,7,NULL,NULL,11,3,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(315,9,NULL,NULL,48,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(316,5,NULL,NULL,10,5,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(317,1,NULL,NULL,44,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(318,1,NULL,NULL,65,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(319,6,NULL,NULL,59,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(320,3,NULL,NULL,43,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(321,10,NULL,NULL,9,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(322,9,NULL,NULL,21,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(323,5,NULL,NULL,37,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(324,6,NULL,NULL,62,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(325,4,NULL,NULL,66,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(326,6,NULL,NULL,26,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(327,4,NULL,NULL,43,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(328,2,NULL,NULL,42,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(329,3,NULL,NULL,72,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(330,4,NULL,NULL,30,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(331,5,NULL,NULL,72,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(332,2,NULL,NULL,16,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(333,8,NULL,NULL,42,4,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(334,2,NULL,NULL,62,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(335,4,NULL,NULL,14,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(336,8,NULL,NULL,65,1,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(337,7,NULL,NULL,7,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(338,7,NULL,NULL,59,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(339,4,NULL,NULL,75,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(340,9,NULL,NULL,42,5,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(341,5,NULL,NULL,66,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(342,8,NULL,NULL,43,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(343,8,NULL,NULL,45,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(344,8,NULL,NULL,24,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(345,4,NULL,NULL,65,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(346,4,NULL,NULL,38,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(347,5,NULL,NULL,49,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(348,4,NULL,NULL,64,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(349,4,NULL,NULL,9,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(350,10,NULL,NULL,35,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(351,6,NULL,NULL,30,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(352,6,NULL,NULL,47,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(353,6,NULL,NULL,53,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(354,6,NULL,NULL,37,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(355,5,NULL,NULL,16,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(356,9,NULL,NULL,3,5,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(357,2,NULL,NULL,7,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(358,10,NULL,NULL,70,3,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(359,9,NULL,NULL,41,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(360,3,NULL,NULL,46,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(361,3,NULL,NULL,41,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(362,7,NULL,NULL,34,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(363,10,NULL,NULL,42,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(364,1,NULL,NULL,56,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(365,2,NULL,NULL,51,4,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(366,4,NULL,NULL,44,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(367,3,NULL,NULL,11,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(368,6,NULL,NULL,29,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(369,8,NULL,NULL,19,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(370,8,NULL,NULL,11,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(371,4,NULL,NULL,17,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(372,10,NULL,NULL,21,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(373,10,NULL,NULL,36,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(374,2,NULL,NULL,50,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(375,10,NULL,NULL,64,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(376,7,NULL,NULL,62,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(377,6,NULL,NULL,16,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(378,10,NULL,NULL,13,1,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(379,3,NULL,NULL,34,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(380,9,NULL,NULL,36,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(381,9,NULL,NULL,60,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(382,3,NULL,NULL,49,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(383,2,NULL,NULL,40,5,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(384,1,NULL,NULL,68,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(385,4,NULL,NULL,16,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(386,3,NULL,NULL,42,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(387,7,NULL,NULL,47,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(388,10,NULL,NULL,6,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(389,2,NULL,NULL,18,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(390,4,NULL,NULL,12,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(391,5,NULL,NULL,40,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(392,2,NULL,NULL,72,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(393,2,NULL,NULL,6,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(394,9,NULL,NULL,31,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(395,8,NULL,NULL,71,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(396,3,NULL,NULL,53,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(397,1,NULL,NULL,19,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(398,10,NULL,NULL,69,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(399,6,NULL,NULL,22,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(400,10,NULL,NULL,39,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(401,3,NULL,NULL,52,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(402,4,NULL,NULL,19,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(403,1,NULL,NULL,40,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(404,6,NULL,NULL,49,5,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(405,3,NULL,NULL,28,5,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(406,1,NULL,NULL,48,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(407,7,NULL,NULL,38,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(408,7,NULL,NULL,6,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(409,2,NULL,NULL,59,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(410,1,NULL,NULL,28,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(411,8,NULL,NULL,55,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(412,10,NULL,NULL,38,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(413,8,NULL,NULL,49,3,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(414,10,NULL,NULL,33,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(415,3,NULL,NULL,62,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(416,8,NULL,NULL,40,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(417,5,NULL,NULL,67,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(418,10,NULL,NULL,47,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(419,7,NULL,NULL,15,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(420,7,NULL,NULL,63,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(421,6,NULL,NULL,27,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(422,5,NULL,NULL,36,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(423,6,NULL,NULL,18,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(424,7,NULL,NULL,3,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(425,6,NULL,NULL,3,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(426,7,NULL,NULL,24,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(427,5,NULL,NULL,17,1,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(428,6,NULL,NULL,56,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(429,2,NULL,NULL,17,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(430,8,NULL,NULL,61,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(431,7,NULL,NULL,55,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(432,7,NULL,NULL,5,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(433,6,NULL,NULL,34,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(434,7,NULL,NULL,48,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(435,5,NULL,NULL,4,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(436,6,NULL,NULL,45,4,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(437,9,NULL,NULL,61,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(438,8,NULL,NULL,10,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(439,6,NULL,NULL,11,3,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(440,10,NULL,NULL,20,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(441,1,NULL,NULL,70,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(442,9,NULL,NULL,58,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(443,3,NULL,NULL,59,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(444,6,NULL,NULL,71,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(445,1,NULL,NULL,25,3,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(446,10,NULL,NULL,51,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(447,7,NULL,NULL,73,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(448,9,NULL,NULL,39,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(449,3,NULL,NULL,8,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(450,6,NULL,NULL,15,1,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(451,7,NULL,NULL,46,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(452,10,NULL,NULL,41,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(453,7,NULL,NULL,4,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(454,2,NULL,NULL,31,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(455,10,NULL,NULL,34,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(456,2,NULL,NULL,64,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(457,4,NULL,NULL,54,1,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(458,10,NULL,NULL,48,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(459,10,NULL,NULL,57,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(460,9,NULL,NULL,32,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(461,3,NULL,NULL,73,1,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(462,1,NULL,NULL,72,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(463,2,NULL,NULL,29,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(464,6,NULL,NULL,20,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(465,7,NULL,NULL,53,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(466,8,NULL,NULL,63,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(467,1,NULL,NULL,2,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(468,5,NULL,NULL,1,3,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(469,8,NULL,NULL,47,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(470,7,NULL,NULL,50,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(471,1,NULL,NULL,53,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(472,9,NULL,NULL,55,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(473,8,NULL,NULL,72,4,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(474,2,NULL,NULL,1,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(475,7,NULL,NULL,8,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(476,10,NULL,NULL,50,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(477,7,NULL,NULL,33,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(478,6,NULL,NULL,43,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(479,2,NULL,NULL,57,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(480,4,NULL,NULL,4,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(481,4,NULL,NULL,50,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(482,1,NULL,NULL,45,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(483,8,NULL,NULL,4,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(484,2,NULL,NULL,66,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(485,3,NULL,NULL,20,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(486,8,NULL,NULL,21,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(487,8,NULL,NULL,12,3,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(488,10,NULL,NULL,1,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(489,9,NULL,NULL,5,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(490,2,NULL,NULL,26,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(491,3,NULL,NULL,57,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(492,4,NULL,NULL,6,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(493,8,NULL,NULL,37,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(494,9,NULL,NULL,26,1,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(495,7,NULL,NULL,67,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(496,10,NULL,NULL,67,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(497,1,NULL,NULL,21,4,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(498,4,NULL,NULL,73,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(499,5,NULL,NULL,29,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(500,6,NULL,NULL,32,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(501,9,NULL,NULL,51,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(502,1,NULL,NULL,27,5,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(503,10,NULL,NULL,31,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(504,6,NULL,NULL,74,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(505,1,NULL,NULL,26,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(506,3,NULL,NULL,47,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(507,2,NULL,NULL,8,3,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(508,1,NULL,NULL,16,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(509,5,NULL,NULL,39,2,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(510,2,NULL,NULL,47,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(511,6,NULL,NULL,51,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(512,2,NULL,NULL,53,2,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(513,10,NULL,NULL,19,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(514,8,NULL,NULL,34,1,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(515,1,NULL,NULL,73,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(516,9,NULL,NULL,70,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(517,6,NULL,NULL,52,2,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(518,7,NULL,NULL,57,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(519,9,NULL,NULL,75,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(520,6,NULL,NULL,36,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(521,6,NULL,NULL,72,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(522,10,NULL,NULL,58,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(523,1,NULL,NULL,9,1,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(524,8,NULL,NULL,59,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(525,5,NULL,NULL,42,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(526,5,NULL,NULL,30,3,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(527,10,NULL,NULL,53,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(528,10,NULL,NULL,72,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(529,5,NULL,NULL,63,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(530,1,NULL,NULL,75,3,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(531,1,NULL,NULL,42,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(532,10,NULL,NULL,59,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(533,6,NULL,NULL,69,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(534,4,NULL,NULL,59,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(535,7,NULL,NULL,56,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(536,4,NULL,NULL,58,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(537,2,NULL,NULL,32,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(538,7,NULL,NULL,41,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(539,7,NULL,NULL,17,5,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(540,9,NULL,NULL,68,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(541,1,NULL,NULL,51,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(542,4,NULL,NULL,18,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(543,7,NULL,NULL,58,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(544,7,NULL,NULL,66,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(545,8,NULL,NULL,36,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(546,5,NULL,NULL,53,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(547,5,NULL,NULL,58,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(548,4,NULL,NULL,62,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(549,1,NULL,NULL,59,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(550,10,NULL,NULL,5,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(551,6,NULL,NULL,10,3,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(552,8,NULL,NULL,60,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(553,3,NULL,NULL,70,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(554,7,NULL,NULL,39,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(555,5,NULL,NULL,74,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(556,8,NULL,NULL,18,3,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(557,10,NULL,NULL,52,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(558,7,NULL,NULL,70,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(559,6,NULL,NULL,65,5,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(560,5,NULL,NULL,47,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(561,4,NULL,NULL,10,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(562,9,NULL,NULL,37,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(563,10,NULL,NULL,12,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(564,10,NULL,NULL,10,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(565,8,NULL,NULL,22,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(566,3,NULL,NULL,21,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(567,5,NULL,NULL,3,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(568,7,NULL,NULL,43,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(569,9,NULL,NULL,8,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(570,9,NULL,NULL,10,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(571,1,NULL,NULL,66,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(572,8,NULL,NULL,28,2,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(573,8,NULL,NULL,64,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(574,2,NULL,NULL,2,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(575,2,NULL,NULL,61,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(576,1,NULL,NULL,10,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(577,4,NULL,NULL,35,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(578,9,NULL,NULL,53,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(579,9,NULL,NULL,20,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(580,10,NULL,NULL,15,5,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(581,3,NULL,NULL,26,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(582,5,NULL,NULL,32,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(583,7,NULL,NULL,14,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(584,8,NULL,NULL,31,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(585,8,NULL,NULL,35,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(586,10,NULL,NULL,68,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(587,4,NULL,NULL,51,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(588,6,NULL,NULL,75,2,'Clean & perfect source code','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(589,3,NULL,NULL,4,4,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(590,9,NULL,NULL,19,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(591,1,NULL,NULL,50,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(592,5,NULL,NULL,59,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(593,1,NULL,NULL,37,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(594,1,NULL,NULL,52,1,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(595,8,NULL,NULL,15,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(596,3,NULL,NULL,66,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(597,5,NULL,NULL,61,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(598,6,NULL,NULL,23,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(599,3,NULL,NULL,18,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(600,10,NULL,NULL,62,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(601,2,NULL,NULL,15,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(602,5,NULL,NULL,31,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(603,6,NULL,NULL,73,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(604,7,NULL,NULL,60,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(605,9,NULL,NULL,23,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:17','2026-02-09 00:19:17',NULL),(606,7,NULL,NULL,44,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(607,3,NULL,NULL,15,3,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(608,4,NULL,NULL,39,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(609,2,NULL,NULL,30,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(610,2,NULL,NULL,74,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(611,5,NULL,NULL,12,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(612,5,NULL,NULL,7,1,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(613,7,NULL,NULL,68,4,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(614,2,NULL,NULL,19,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(615,2,NULL,NULL,22,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(616,3,NULL,NULL,14,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(617,7,NULL,NULL,65,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(618,6,NULL,NULL,50,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(619,5,NULL,NULL,68,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(620,7,NULL,NULL,2,3,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(621,7,NULL,NULL,51,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(622,7,NULL,NULL,37,3,'Best ecommerce CMS online store!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(623,7,NULL,NULL,20,2,'Best ecommerce CMS online store!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(624,9,NULL,NULL,45,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(625,2,NULL,NULL,10,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(626,9,NULL,NULL,46,1,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(627,9,NULL,NULL,12,4,'Clean & perfect source code','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(628,8,NULL,NULL,66,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(629,8,NULL,NULL,29,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(630,10,NULL,NULL,74,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(631,6,NULL,NULL,1,5,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(632,4,NULL,NULL,53,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(633,2,NULL,NULL,35,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(634,4,NULL,NULL,67,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(635,6,NULL,NULL,28,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(636,5,NULL,NULL,71,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(637,3,NULL,NULL,60,5,'Clean & perfect source code','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(638,7,NULL,NULL,31,3,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(639,4,NULL,NULL,37,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(640,9,NULL,NULL,57,2,'Clean & perfect source code','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(641,10,NULL,NULL,23,2,'Clean & perfect source code','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(642,2,NULL,NULL,54,2,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(643,7,NULL,NULL,19,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(644,5,NULL,NULL,60,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(645,1,NULL,NULL,71,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(646,4,NULL,NULL,24,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(647,9,NULL,NULL,28,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(648,1,NULL,NULL,31,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(649,9,NULL,NULL,63,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(650,5,NULL,NULL,25,1,'Best ecommerce CMS online store!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(651,8,NULL,NULL,6,3,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(652,5,NULL,NULL,57,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(653,6,NULL,NULL,60,4,'Best ecommerce CMS online store!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(654,4,NULL,NULL,46,4,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(655,3,NULL,NULL,69,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(656,6,NULL,NULL,5,3,'Clean & perfect source code','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(657,9,NULL,NULL,25,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(658,2,NULL,NULL,3,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(659,7,NULL,NULL,74,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(660,5,NULL,NULL,64,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(661,1,NULL,NULL,4,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(662,8,NULL,NULL,39,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(663,3,NULL,NULL,65,5,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(664,6,NULL,NULL,48,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(665,1,NULL,NULL,29,4,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(666,3,NULL,NULL,68,3,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(667,5,NULL,NULL,56,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(668,1,NULL,NULL,36,2,'Clean & perfect source code','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(669,10,NULL,NULL,24,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(670,9,NULL,NULL,30,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(671,2,NULL,NULL,56,4,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(672,5,NULL,NULL,52,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(673,5,NULL,NULL,26,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(674,3,NULL,NULL,6,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(675,2,NULL,NULL,4,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(676,3,NULL,NULL,75,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(677,9,NULL,NULL,71,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(678,10,NULL,NULL,73,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(679,1,NULL,NULL,1,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(680,9,NULL,NULL,17,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(681,7,NULL,NULL,52,2,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(682,10,NULL,NULL,26,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(683,4,NULL,NULL,61,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(684,1,NULL,NULL,64,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(685,2,NULL,NULL,52,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(686,3,NULL,NULL,48,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(687,8,NULL,NULL,68,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(688,10,NULL,NULL,71,2,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(689,2,NULL,NULL,5,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(690,10,NULL,NULL,61,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(691,4,NULL,NULL,2,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(692,5,NULL,NULL,34,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(693,9,NULL,NULL,62,4,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(694,4,NULL,NULL,5,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(695,7,NULL,NULL,45,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(696,7,NULL,NULL,49,2,'Clean & perfect source code','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(697,8,NULL,NULL,16,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(698,2,NULL,NULL,25,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(699,2,NULL,NULL,73,5,'Best ecommerce CMS online store!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(700,6,NULL,NULL,35,1,'Good app, good backup service and support. Good documentation.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(701,4,NULL,NULL,34,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(702,3,NULL,NULL,12,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(703,8,NULL,NULL,9,2,'Best ecommerce CMS online store!','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(704,2,NULL,NULL,68,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL);
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shared_wishlists`
--

DROP TABLE IF EXISTS `ec_shared_wishlists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shared_wishlists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_ids` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_shared_wishlists_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shared_wishlists`
--

LOCK TABLES `ec_shared_wishlists` WRITE;
/*!40000 ALTER TABLE `ec_shared_wishlists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shared_wishlists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double DEFAULT '0',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `customer_delivered_confirmed_at` timestamp NULL DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_shipments_order_id_unique` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2026-02-09 00:18:46','2026-02-09 00:18:46');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code_from` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code_to` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_zip_range` (`zip_code_from`,`zip_code_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',1000.00,NULL,0.00,'2026-02-09 00:18:46','2026-02-09 00:18:46'),(2,'Flat Rate',1,'based_on_price',0.00,NULL,20.00,'2026-02-09 00:18:46','2026-02-09 00:18:46'),(3,'Local Pickup',1,'based_on_price',0.00,NULL,0.00,'2026-02-09 00:18:46','2026-02-09 00:18:46');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_attributes`
--

DROP TABLE IF EXISTS `ec_specification_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `default_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_specification_attributes_author_type_author_id_index` (`author_type`,`author_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_attributes`
--

LOCK TABLES `ec_specification_attributes` WRITE;
/*!40000 ALTER TABLE `ec_specification_attributes` DISABLE KEYS */;
INSERT INTO `ec_specification_attributes` VALUES (1,1,'Height','text',NULL,NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(2,1,'Width','text',NULL,NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(3,1,'Weight','text',NULL,NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(4,2,'Power','text',NULL,NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(5,2,'Speed','text',NULL,NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(6,3,'Battery Life','text',NULL,NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(7,4,'Screen Size','text',NULL,NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(8,4,'Resolution','select','[\"1920x1080\",\"2560x1440\",\"3840x2160\"]',NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL);
/*!40000 ALTER TABLE `ec_specification_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_attributes_translations`
--

DROP TABLE IF EXISTS `ec_specification_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_attributes_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_specification_attributes_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `default_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_specification_attributes_id`),
  KEY `idx_specification_attributes_fk` (`ec_specification_attributes_id`),
  KEY `idx_specification_attributes_specification_attributes_lang` (`ec_specification_attributes_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_attributes_translations`
--

LOCK TABLES `ec_specification_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_specification_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_specification_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_groups`
--

DROP TABLE IF EXISTS `ec_specification_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_groups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_specification_groups_author_type_author_id_index` (`author_type`,`author_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_groups`
--

LOCK TABLES `ec_specification_groups` WRITE;
/*!40000 ALTER TABLE `ec_specification_groups` DISABLE KEYS */;
INSERT INTO `ec_specification_groups` VALUES (1,'Dimensions',NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(2,'Performance',NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(3,'Battery',NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(4,'Display',NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL);
/*!40000 ALTER TABLE `ec_specification_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_groups_translations`
--

DROP TABLE IF EXISTS `ec_specification_groups_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_groups_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_specification_groups_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_specification_groups_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_groups_translations`
--

LOCK TABLES `ec_specification_groups_translations` WRITE;
/*!40000 ALTER TABLE `ec_specification_groups_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_specification_groups_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_table_group`
--

DROP TABLE IF EXISTS `ec_specification_table_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_table_group` (
  `table_id` bigint unsigned NOT NULL,
  `group_id` bigint unsigned NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`table_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_table_group`
--

LOCK TABLES `ec_specification_table_group` WRITE;
/*!40000 ALTER TABLE `ec_specification_table_group` DISABLE KEYS */;
INSERT INTO `ec_specification_table_group` VALUES (1,1,0),(1,2,0),(2,3,0),(2,4,0);
/*!40000 ALTER TABLE `ec_specification_table_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_tables`
--

DROP TABLE IF EXISTS `ec_specification_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_tables` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_specification_tables_author_type_author_id_index` (`author_type`,`author_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_tables`
--

LOCK TABLES `ec_specification_tables` WRITE;
/*!40000 ALTER TABLE `ec_specification_tables` DISABLE KEYS */;
INSERT INTO `ec_specification_tables` VALUES (1,'General Specification',NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL),(2,'Technical Specification',NULL,'2026-02-09 00:19:10','2026-02-09 00:19:10',NULL,NULL);
/*!40000 ALTER TABLE `ec_specification_tables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_tables_translations`
--

DROP TABLE IF EXISTS `ec_specification_tables_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_tables_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_specification_tables_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_specification_tables_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_tables_translations`
--

LOCK TABLES `ec_specification_tables_translations` WRITE;
/*!40000 ALTER TABLE `ec_specification_tables_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_specification_tables_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(1,6),(1,7),(1,8),(1,9),(1,10),(1,11),(1,12),(1,13),(1,14),(1,15),(1,16),(1,17),(1,18),(1,19),(1,20),(1,21),(1,22),(1,23),(1,24),(1,25),(1,26),(1,27),(1,28),(1,29),(1,30),(1,31),(1,32),(1,33),(1,34),(1,35),(1,36),(1,37),(1,38),(1,39),(1,40),(1,41),(1,42),(1,43),(1,44),(1,45),(1,46),(1,47),(1,48),(1,49),(1,50),(1,51),(1,52),(1,53),(1,54),(1,55),(1,56),(1,57),(1,58),(1,59),(1,60),(1,61),(1,62),(1,63),(1,64),(1,65),(1,66),(1,67),(1,68),(1,69),(1,70),(1,71),(1,72),(1,73),(1,74),(1,75);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10,1,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(2,'None',0,2,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(3,'Import Tax',15,3,'published','2026-02-09 00:18:48','2026-02-09 00:18:48');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes_translations`
--

DROP TABLE IF EXISTS `ec_taxes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_taxes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_taxes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes_translations`
--

LOCK TABLES `ec_taxes_translations` WRITE;
/*!40000 ALTER TABLE `ec_taxes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_taxes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`customer_id`,`product_id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Ordering Process',0,'published','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL),(2,'Product Returns',1,'published','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL),(3,'Product Availability',2,'published','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`),
  KEY `idx_faq_cat_trans_faq_cat_id` (`faq_categories_id`),
  KEY `idx_faq_cat_trans_faq_cat_lang` (`faq_categories_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'How do I place an order?','To place an order, navigate to the product page, select the desired options, and click the \"Add to Cart\" button.',2,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(2,'What are the shipping options?','We offer standard and expedited shipping options. Shipping costs and delivery times vary based on your location and chosen shipping method.',1,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(3,'How can I return a product?','If you are not satisfied with your purchase, you can initiate a return within 30 days of receiving the product. Contact our customer service for further instructions.',2,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(4,'What payment methods do you accept?','We accept major credit cards, PayPal, and other secure payment methods.',1,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(5,'How can I update my account information?','Log in to your account and go to the \"Account Settings\" page to update your information, including your password and shipping address.',3,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(6,'Are there any ongoing promotions or discounts?','Check our \"Promotions\" page for information on current discounts, special offers, and ongoing promotions.',1,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(7,'Is the product in stock?','Product availability is indicated on each product page. If a product is out of stock, you may choose to be notified when it becomes available.',2,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(8,'How is my personal information secured?','We take the security and privacy of your information seriously. Our website uses encryption technology to protect your personal data.',3,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(9,'How do I get technical support?','For technical issues or assistance, contact our customer support team through the \"Contact Us\" page, and we will help you resolve any problems.',1,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(10,'Do you offer international shipping?','Yes, we offer international shipping to many countries. Shipping costs and delivery times vary based on the destination.',2,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(11,'Can I purchase a gift card?','Yes, we offer gift cards of varying denominations. Gift cards can be purchased on our website and make for a great gift for friends and family.',1,'published','2026-02-09 00:18:48','2026-02-09 00:18:48'),(12,'What is the warranty on your products?','Our products come with a standard warranty. Check the product documentation or contact our customer service for details on specific product warranties.',3,'published','2026-02-09 00:18:48','2026-02-09 00:18:48');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`),
  KEY `idx_faqs_trans_faqs_id` (`faqs_id`),
  KEY `idx_faqs_trans_faq_lang` (`faqs_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Perfect','A beautiful collection of images showcasing memorable moments and stunning visuals.',1,0,'galleries/1.jpg',1,'published','2026-02-09 00:19:19','2026-02-09 00:19:19'),(2,'New Day','A beautiful collection of images showcasing memorable moments and stunning visuals.',1,0,'galleries/2.jpg',1,'published','2026-02-09 00:19:19','2026-02-09 00:19:19'),(3,'Happy Day','A beautiful collection of images showcasing memorable moments and stunning visuals.',1,0,'galleries/3.jpg',1,'published','2026-02-09 00:19:19','2026-02-09 00:19:19'),(4,'Nature','A beautiful collection of images showcasing memorable moments and stunning visuals.',1,0,'galleries/4.jpg',1,'published','2026-02-09 00:19:19','2026-02-09 00:19:19'),(5,'Morning','A beautiful collection of images showcasing memorable moments and stunning visuals.',1,0,'galleries/5.jpg',1,'published','2026-02-09 00:19:19','2026-02-09 00:19:19'),(6,'Photography','A beautiful collection of images showcasing memorable moments and stunning visuals.',1,0,'galleries/6.jpg',1,'published','2026-02-09 00:19:19','2026-02-09 00:19:19');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`),
  KEY `idx_galleries_trans_galleries_id` (`galleries_id`),
  KEY `idx_galleries_trans_gallery_lang` (`galleries_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"A stunning capture of natural beauty that showcases the perfect blend of light and shadow.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"This breathtaking moment frozen in time represents the essence of artistic photography.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"An exquisite composition that brings together vibrant colors and exceptional detail.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"A masterpiece of visual storytelling that speaks to the heart and soul of the viewer.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Captured with precision and artistry, this image embodies the spirit of creative expression.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"A remarkable display of photographic excellence that transcends ordinary imagery.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2026-02-09 00:19:19','2026-02-09 00:19:19'),(2,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"A stunning capture of natural beauty that showcases the perfect blend of light and shadow.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"This breathtaking moment frozen in time represents the essence of artistic photography.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"An exquisite composition that brings together vibrant colors and exceptional detail.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"A masterpiece of visual storytelling that speaks to the heart and soul of the viewer.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Captured with precision and artistry, this image embodies the spirit of creative expression.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"A remarkable display of photographic excellence that transcends ordinary imagery.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2026-02-09 00:19:19','2026-02-09 00:19:19'),(3,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"A stunning capture of natural beauty that showcases the perfect blend of light and shadow.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"This breathtaking moment frozen in time represents the essence of artistic photography.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"An exquisite composition that brings together vibrant colors and exceptional detail.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"A masterpiece of visual storytelling that speaks to the heart and soul of the viewer.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Captured with precision and artistry, this image embodies the spirit of creative expression.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"A remarkable display of photographic excellence that transcends ordinary imagery.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2026-02-09 00:19:19','2026-02-09 00:19:19'),(4,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"A stunning capture of natural beauty that showcases the perfect blend of light and shadow.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"This breathtaking moment frozen in time represents the essence of artistic photography.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"An exquisite composition that brings together vibrant colors and exceptional detail.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"A masterpiece of visual storytelling that speaks to the heart and soul of the viewer.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Captured with precision and artistry, this image embodies the spirit of creative expression.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"A remarkable display of photographic excellence that transcends ordinary imagery.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2026-02-09 00:19:19','2026-02-09 00:19:19'),(5,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"A stunning capture of natural beauty that showcases the perfect blend of light and shadow.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"This breathtaking moment frozen in time represents the essence of artistic photography.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"An exquisite composition that brings together vibrant colors and exceptional detail.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"A masterpiece of visual storytelling that speaks to the heart and soul of the viewer.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Captured with precision and artistry, this image embodies the spirit of creative expression.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"A remarkable display of photographic excellence that transcends ordinary imagery.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2026-02-09 00:19:19','2026-02-09 00:19:19'),(6,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"A stunning capture of natural beauty that showcases the perfect blend of light and shadow.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"This breathtaking moment frozen in time represents the essence of artistic photography.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"An exquisite composition that brings together vibrant colors and exceptional detail.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"A masterpiece of visual storytelling that speaks to the heart and soul of the viewer.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Captured with precision and artistry, this image embodies the spirit of creative expression.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"A remarkable display of photographic excellence that transcends ordinary imagery.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2026-02-09 00:19:19','2026-02-09 00:19:19');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`),
  KEY `idx_gallery_meta_trans_gm_id` (`gallery_meta_id`),
  KEY `idx_gallery_meta_trans_gm_lang` (`gallery_meta_id`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','6e8af8981dbcf65f5de3812904d99574',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','664b1cba48bdc69b3012b444d9cf240e',2,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(3,'en_US','1ac35a7451f0c94b3b30ddaaf0341c45',3,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(4,'en_US','8871dddfcf664e911bbee24b189398ca',4,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(5,'en_US','9a01653bc60e0ec2d0206f9d47c92033',5,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(6,'en_US','0394d504f5e1e640f395f83b6cf762e2',1,'Botble\\Menu\\Models\\MenuLocation'),(7,'en_US','d765e5383414d75090437eca3dd831c9',1,'Botble\\Menu\\Models\\Menu'),(8,'en_US','0095683a37487f65f9d460de8623ecdd',2,'Botble\\Menu\\Models\\MenuLocation'),(9,'en_US','022559b18fedc27993f661a40ce26bd9',2,'Botble\\Menu\\Models\\Menu'),(10,'en_US','1efce2d10fc65c70b8a5fb7977cef893',3,'Botble\\Menu\\Models\\MenuLocation'),(11,'en_US','625fd7e826a787ddb7b6f3072f280fb5',3,'Botble\\Menu\\Models\\Menu'),(12,'en_US','3cbc953d69930601302caab562110656',4,'Botble\\Menu\\Models\\MenuLocation'),(13,'en_US','c827a844238ec1f18494647d4e6a2228',4,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=285 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'f-app','f-app',1,'image/jpeg',617,'general/f-app.jpg','[]','2026-02-09 00:18:30','2026-02-09 00:18:30',NULL,'public'),(2,0,'f-brand-icon-01','f-brand-icon-01',1,'image/png',448,'general/f-brand-icon-01.png','[]','2026-02-09 00:18:30','2026-02-09 00:18:30',NULL,'public'),(3,0,'f-google','f-google',1,'image/jpeg',617,'general/f-google.jpg','[]','2026-02-09 00:18:31','2026-02-09 00:18:31',NULL,'public'),(4,0,'favicon','favicon',1,'image/png',15233,'general/favicon.png','[]','2026-02-09 00:18:31','2026-02-09 00:18:31',NULL,'public'),(5,0,'logo-white','logo-white',1,'image/png',860,'general/logo-white.png','[]','2026-02-09 00:18:31','2026-02-09 00:18:31',NULL,'public'),(6,0,'logo','logo',1,'image/png',934,'general/logo.png','[]','2026-02-09 00:18:31','2026-02-09 00:18:31',NULL,'public'),(7,0,'newsletter-popup','newsletter-popup',1,'image/png',28834,'general/newsletter-popup.png','[]','2026-02-09 00:18:32','2026-02-09 00:18:32',NULL,'public'),(8,0,'cod','cod',2,'image/png',12121,'payments/cod.png','[]','2026-02-09 00:18:32','2026-02-09 00:18:32',NULL,'public'),(9,0,'bank-transfer','bank-transfer',2,'image/png',29089,'payments/bank-transfer.png','[]','2026-02-09 00:18:32','2026-02-09 00:18:32',NULL,'public'),(10,0,'stripe','stripe',2,'image/webp',7516,'payments/stripe.webp','[]','2026-02-09 00:18:33','2026-02-09 00:18:33',NULL,'public'),(11,0,'paypal','paypal',2,'image/png',3001,'payments/paypal.png','[]','2026-02-09 00:18:33','2026-02-09 00:18:33',NULL,'public'),(12,0,'mollie','mollie',2,'image/png',8968,'payments/mollie.png','[]','2026-02-09 00:18:33','2026-02-09 00:18:33',NULL,'public'),(13,0,'paystack','paystack',2,'image/png',31015,'payments/paystack.png','[]','2026-02-09 00:18:33','2026-02-09 00:18:33',NULL,'public'),(14,0,'razorpay','razorpay',2,'image/png',8489,'payments/razorpay.png','[]','2026-02-09 00:18:34','2026-02-09 00:18:34',NULL,'public'),(15,0,'sslcommerz','sslcommerz',2,'image/png',3482,'payments/sslcommerz.png','[]','2026-02-09 00:18:34','2026-02-09 00:18:34',NULL,'public'),(16,0,'1','1',3,'image/jpeg',3319,'blog/1.jpg','[]','2026-02-09 00:18:34','2026-02-09 00:18:34',NULL,'public'),(17,0,'10','10',3,'image/jpeg',3319,'blog/10.jpg','[]','2026-02-09 00:18:34','2026-02-09 00:18:34',NULL,'public'),(18,0,'11','11',3,'image/jpeg',3319,'blog/11.jpg','[]','2026-02-09 00:18:34','2026-02-09 00:18:34',NULL,'public'),(19,0,'2','2',3,'image/jpeg',3319,'blog/2.jpg','[]','2026-02-09 00:18:35','2026-02-09 00:18:35',NULL,'public'),(20,0,'3','3',3,'image/jpeg',3319,'blog/3.jpg','[]','2026-02-09 00:18:35','2026-02-09 00:18:35',NULL,'public'),(21,0,'4','4',3,'image/jpeg',3319,'blog/4.jpg','[]','2026-02-09 00:18:35','2026-02-09 00:18:35',NULL,'public'),(22,0,'5','5',3,'image/jpeg',3319,'blog/5.jpg','[]','2026-02-09 00:18:35','2026-02-09 00:18:35',NULL,'public'),(23,0,'6','6',3,'image/jpeg',3319,'blog/6.jpg','[]','2026-02-09 00:18:35','2026-02-09 00:18:35',NULL,'public'),(24,0,'7','7',3,'image/jpeg',3319,'blog/7.jpg','[]','2026-02-09 00:18:35','2026-02-09 00:18:35',NULL,'public'),(25,0,'8','8',3,'image/jpeg',3319,'blog/8.jpg','[]','2026-02-09 00:18:35','2026-02-09 00:18:35',NULL,'public'),(26,0,'9','9',3,'image/jpeg',3319,'blog/9.jpg','[]','2026-02-09 00:18:36','2026-02-09 00:18:36',NULL,'public'),(27,0,'blog-in-01','blog-in-01',3,'image/jpeg',9623,'blog/blog-in-01.jpg','[]','2026-02-09 00:18:36','2026-02-09 00:18:36',NULL,'public'),(28,0,'blog-in-02','blog-in-02',3,'image/jpeg',9623,'blog/blog-in-02.jpg','[]','2026-02-09 00:18:36','2026-02-09 00:18:36',NULL,'public'),(29,0,'blog-in-03','blog-in-03',3,'image/jpeg',9623,'blog/blog-in-03.jpg','[]','2026-02-09 00:18:36','2026-02-09 00:18:36',NULL,'public'),(30,0,'blog-in-04','blog-in-04',3,'image/jpeg',9623,'blog/blog-in-04.jpg','[]','2026-02-09 00:18:36','2026-02-09 00:18:36',NULL,'public'),(31,0,'blog-in-05','blog-in-05',3,'image/jpeg',9623,'blog/blog-in-05.jpg','[]','2026-02-09 00:18:36','2026-02-09 00:18:36',NULL,'public'),(32,0,'blog-in-06','blog-in-06',3,'image/jpeg',9623,'blog/blog-in-06.jpg','[]','2026-02-09 00:18:37','2026-02-09 00:18:37',NULL,'public'),(33,0,'blog-sm-1','blog-sm-1',3,'image/jpeg',9623,'blog/blog-sm-1.jpg','[]','2026-02-09 00:18:37','2026-02-09 00:18:37',NULL,'public'),(34,0,'blog-sm-2','blog-sm-2',3,'image/jpeg',9623,'blog/blog-sm-2.jpg','[]','2026-02-09 00:18:37','2026-02-09 00:18:37',NULL,'public'),(35,0,'blog-sm-3','blog-sm-3',3,'image/jpeg',9623,'blog/blog-sm-3.jpg','[]','2026-02-09 00:18:37','2026-02-09 00:18:37',NULL,'public'),(36,0,'blog-sm-4','blog-sm-4',3,'image/jpeg',9623,'blog/blog-sm-4.jpg','[]','2026-02-09 00:18:37','2026-02-09 00:18:37',NULL,'public'),(37,0,'comment-1','comment-1',3,'image/jpeg',9803,'blog/comment-1.jpg','[]','2026-02-09 00:18:37','2026-02-09 00:18:37',NULL,'public'),(38,0,'comment-2','comment-2',3,'image/jpeg',9803,'blog/comment-2.jpg','[]','2026-02-09 00:18:37','2026-02-09 00:18:37',NULL,'public'),(39,0,'location-1','location-1',4,'image/png',5309,'shop/location-1.png','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(40,0,'location-2','location-2',4,'image/png',5309,'shop/location-2.png','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(41,0,'location-3','location-3',4,'image/png',5309,'shop/location-3.png','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(42,0,'location-4','location-4',4,'image/png',5309,'shop/location-4.png','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(43,0,'login_bg','login_bg',4,'image/jpeg',5443,'shop/login-bg.jpg','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(44,0,'reviewer-01','reviewer-01',4,'image/png',1070,'shop/reviewer-01.png','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(45,0,'reviewer-02','reviewer-02',4,'image/png',1070,'shop/reviewer-02.png','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(46,0,'reviewer-03','reviewer-03',4,'image/png',1070,'shop/reviewer-03.png','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(47,0,'s-thumb-01','s-thumb-01',4,'image/jpeg',2813,'shop/s-thumb-01.jpg','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(48,0,'s-thumb-02','s-thumb-02',4,'image/jpeg',2813,'shop/s-thumb-02.jpg','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(49,0,'s-thumb-03','s-thumb-03',4,'image/jpeg',2813,'shop/s-thumb-03.jpg','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(50,0,'s-thumb-04','s-thumb-04',4,'image/jpeg',2813,'shop/s-thumb-04.jpg','[]','2026-02-09 00:18:38','2026-02-09 00:18:38',NULL,'public'),(51,0,'s-thumb-05','s-thumb-05',4,'image/jpeg',2813,'shop/s-thumb-05.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(52,0,'s-thumb-06','s-thumb-06',4,'image/jpeg',2813,'shop/s-thumb-06.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(53,0,'sign_bg','sign_bg',4,'image/jpeg',5443,'shop/sign-bg.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(54,0,'track_bg','track_bg',4,'image/jpeg',6224,'shop/track-bg.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(55,0,'w-product-01','w-product-01',4,'image/jpeg',5528,'shop/w-product-01.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(56,0,'w-product-02','w-product-02',4,'image/jpeg',5528,'shop/w-product-02.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(57,0,'w-product-03','w-product-03',4,'image/jpeg',5528,'shop/w-product-03.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(58,0,'w-product-04','w-product-04',4,'image/jpeg',5528,'shop/w-product-04.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(59,0,'w-product-05','w-product-05',4,'image/jpeg',5528,'shop/w-product-05.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(60,0,'about-banner-1','about-banner-1',5,'image/jpeg',8335,'banners/about-banner-1.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(61,0,'about-banner-2','about-banner-2',5,'image/jpeg',8335,'banners/about-banner-2.jpg','[]','2026-02-09 00:18:39','2026-02-09 00:18:39',NULL,'public'),(62,0,'about-img-1','about-img-1',5,'image/jpeg',8914,'banners/about-img-1.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(63,0,'about-img-2','about-img-2',5,'image/jpeg',8914,'banners/about-img-2.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(64,0,'about-img-3','about-img-3',5,'image/png',6373,'banners/about-img-3.png','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(65,0,'banner-03-01','banner-03-01',5,'image/jpeg',6612,'banners/banner-03-01.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(66,0,'banner-03-02','banner-03-02',5,'image/jpeg',5283,'banners/banner-03-02.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(67,0,'banner-03-03','banner-03-03',5,'image/jpeg',5077,'banners/banner-03-03.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(68,0,'banner-2-01','banner-2-01',5,'image/jpeg',5452,'banners/banner-2-01.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(69,0,'banner-2-02','banner-2-02',5,'image/jpeg',5452,'banners/banner-2-02.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(70,0,'banner-2-03','banner-2-03',5,'image/jpeg',12296,'banners/banner-2-03.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(71,0,'banner-2-04','banner-2-04',5,'image/jpeg',7318,'banners/banner-2-04.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(72,0,'banner-bg-05','banner-bg-05',5,'image/jpeg',23672,'banners/banner-bg-05.jpg','[]','2026-02-09 00:18:40','2026-02-09 00:18:40',NULL,'public'),(73,0,'banner-offer-01','banner-offer-01',5,'image/jpeg',10330,'banners/banner-offer-01.jpg','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(74,0,'banner-offer-02','banner-offer-02',5,'image/jpeg',9086,'banners/banner-offer-02.jpg','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(75,0,'breadcrumb-01','breadcrumb-01',5,'image/jpeg',5276,'banners/breadcrumb-01.jpg','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(76,0,'coming-soon','coming-soon',5,'image/jpeg',27345,'banners/coming-soon.jpg','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(77,0,'login-bg','login-bg',5,'image/jpeg',5443,'banners/login-bg.jpg','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(78,0,'product-shape-01','product-shape-01',5,'image/png',3220,'banners/product-shape-01.png','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(79,0,'product-shape-02','product-shape-02',5,'image/png',2285,'banners/product-shape-02.png','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(80,0,'sign-bg','sign-bg',5,'image/jpeg',5443,'banners/sign-bg.jpg','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(81,0,'thumb-01','thumb-01',5,'image/jpeg',16230,'banners/thumb-01.jpg','[]','2026-02-09 00:18:41','2026-02-09 00:18:41',NULL,'public'),(82,0,'thumb-02','thumb-02',5,'image/jpeg',7655,'banners/thumb-02.jpg','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(83,0,'thumb-03','thumb-03',5,'image/jpeg',7655,'banners/thumb-03.jpg','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(84,0,'thumb-04','thumb-04',5,'image/jpeg',16230,'banners/thumb-04.jpg','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(85,0,'track-bg','track-bg',5,'image/jpeg',6224,'banners/track-bg.jpg','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(86,0,'box','box',6,'image/png',949,'icons/box.png','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(87,0,'car','car',6,'image/png',855,'icons/car.png','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(88,0,'cash-on-delivery','cash-on-delivery',6,'image/png',2426,'icons/cash-on-delivery.png','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(89,0,'cat-icon-01','cat-icon-01',6,'image/png',146,'icons/cat-icon-01.png','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(90,0,'cat-icon-02','cat-icon-02',6,'image/png',164,'icons/cat-icon-02.png','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(91,0,'cat-icon-03','cat-icon-03',6,'image/png',164,'icons/cat-icon-03.png','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(92,0,'cat-icon-04','cat-icon-04',6,'image/png',160,'icons/cat-icon-04.png','[]','2026-02-09 00:18:42','2026-02-09 00:18:42',NULL,'public'),(93,0,'cat-icon-05','cat-icon-05',6,'image/png',151,'icons/cat-icon-05.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(94,0,'cat-icon-06','cat-icon-06',6,'image/png',1665,'icons/cat-icon-06.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(95,0,'error','error',6,'image/png',3971,'icons/error.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(96,0,'fast-delivery','fast-delivery',6,'image/png',3347,'icons/fast-delivery.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(97,0,'hours','hours',6,'image/png',1034,'icons/hours.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(98,0,'lang-flag','lang-flag',6,'image/png',1602,'icons/lang-flag.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(99,0,'payment','payment',6,'image/png',800,'icons/payment.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(100,0,'product-det-1','product-det-1',6,'image/png',974,'icons/product-det-1.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(101,0,'product-det-2','product-det-2',6,'image/png',1080,'icons/product-det-2.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(102,0,'product-det-3','product-det-3',6,'image/png',735,'icons/product-det-3.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(103,0,'product-det-4','product-det-4',6,'image/png',1202,'icons/product-det-4.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(104,0,'support','support',6,'image/png',3574,'icons/support.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(105,0,'title-shape-02','title-shape-02',6,'image/jpeg',737,'icons/title-shape-02.jpg','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(106,0,'track-1','track-1',6,'image/png',339,'icons/track-1.png','[]','2026-02-09 00:18:43','2026-02-09 00:18:43',NULL,'public'),(107,0,'verified','verified',6,'image/png',2564,'icons/verified.png','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(108,0,'banner-1','banner-1',7,'image/jpeg',9766,'sliders/banner-1.jpg','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(109,0,'banner-2','banner-2',7,'image/jpeg',9766,'sliders/banner-2.jpg','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(110,0,'banner-3','banner-3',7,'image/jpeg',9766,'sliders/banner-3.jpg','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(111,0,'banner-slider-01','banner-slider-01',7,'image/jpeg',4081,'sliders/banner-slider-01.jpg','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(112,0,'banner-slider-02','banner-slider-02',7,'image/jpeg',4081,'sliders/banner-slider-02.jpg','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(113,0,'fasion-tag-01','fasion-tag-01',7,'image/png',2647,'sliders/fasion-tag-01.png','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(114,0,'fasion-tag-02','fasion-tag-02',7,'image/png',2675,'sliders/fasion-tag-02.png','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(115,0,'fasion-tag-03','fasion-tag-03',7,'image/png',2675,'sliders/fasion-tag-03.png','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(116,0,'slider-01','slider-01',7,'image/png',13507,'sliders/slider-01.png','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(117,0,'slider-02','slider-02',7,'image/png',13507,'sliders/slider-02.png','[]','2026-02-09 00:18:44','2026-02-09 00:18:44',NULL,'public'),(118,0,'slider-03','slider-03',7,'image/png',13507,'sliders/slider-03.png','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(119,0,'slider-04','slider-04',7,'image/png',11780,'sliders/slider-04.png','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(120,0,'slider-05-banner-1','slider-05-banner-1',7,'image/jpeg',3724,'sliders/slider-05-banner-1.jpg','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(121,0,'slider-05-banner-2','slider-05-banner-2',7,'image/jpeg',3724,'sliders/slider-05-banner-2.jpg','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(122,0,'slider-05-bg-1','slider-05-bg-1',7,'image/jpeg',11103,'sliders/slider-05-bg-1.jpg','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(123,0,'slider-05-bg-2','slider-05-bg-2',7,'image/jpeg',11103,'sliders/slider-05-bg-2.jpg','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(124,0,'slider-05-bg-3','slider-05-bg-3',7,'image/jpeg',11103,'sliders/slider-05-bg-3.jpg','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(125,0,'slider-05-bg-4','slider-05-bg-4',7,'image/jpeg',11103,'sliders/slider-05-bg-4.jpg','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(126,0,'slider-05','slider-05',7,'image/png',11780,'sliders/slider-05.png','[]','2026-02-09 00:18:45','2026-02-09 00:18:45',NULL,'public'),(127,0,'slider-06','slider-06',7,'image/png',11780,'sliders/slider-06.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(128,0,'slider-bg-04','slider-bg-04',7,'image/png',7941,'sliders/slider-bg-04.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(129,0,'slider-bg-05','slider-bg-05',7,'image/png',7941,'sliders/slider-bg-05.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(130,0,'slider-bg-06','slider-bg-06',7,'image/png',7941,'sliders/slider-bg-06.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(131,0,'video-bg-01','video-bg-01',7,'image/jpeg',14217,'sliders/video-bg-01.jpg','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(132,0,'brand-01','brand-01',8,'image/png',630,'brands/brand-01.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(133,0,'brand-02','brand-02',8,'image/png',630,'brands/brand-02.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(134,0,'brand-03','brand-03',8,'image/png',630,'brands/brand-03.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(135,0,'brand-04','brand-04',8,'image/png',630,'brands/brand-04.png','[]','2026-02-09 00:18:46','2026-02-09 00:18:46',NULL,'public'),(136,0,'brand-05','brand-05',8,'image/png',630,'brands/brand-05.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(137,0,'brand-06','brand-06',8,'image/png',630,'brands/brand-06.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(138,0,'brand-w-01','brand-w-01',8,'image/png',630,'brands/brand-w-01.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(139,0,'brand-w-02','brand-w-02',8,'image/png',630,'brands/brand-w-02.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(140,0,'brand-w-03','brand-w-03',8,'image/png',630,'brands/brand-w-03.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(141,0,'brand-w-04','brand-w-04',8,'image/png',630,'brands/brand-w-04.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(142,0,'brand-w-05','brand-w-05',8,'image/png',630,'brands/brand-w-05.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(143,0,'brand-w-06','brand-w-06',8,'image/png',630,'brands/brand-w-06.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(144,0,'pla-brand-01','pla-brand-01',8,'image/png',630,'brands/pla-brand-01.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(145,0,'pla-brand-02','pla-brand-02',8,'image/png',630,'brands/pla-brand-02.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(146,0,'pla-brand-03','pla-brand-03',8,'image/png',630,'brands/pla-brand-03.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(147,0,'pla-brand-04','pla-brand-04',8,'image/png',630,'brands/pla-brand-04.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(148,0,'pla-brand-05','pla-brand-05',8,'image/png',630,'brands/pla-brand-05.png','[]','2026-02-09 00:18:47','2026-02-09 00:18:47',NULL,'public'),(149,0,'pla-brand-06','pla-brand-06',8,'image/png',630,'brands/pla-brand-06.png','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(150,0,'feature-icon-01','feature-icon-01',9,'image/png',2082,'features/feature-icon-01.png','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(151,0,'feature-icon-02','feature-icon-02',9,'image/png',1941,'features/feature-icon-02.png','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(152,0,'feature-icon-03','feature-icon-03',9,'image/png',2535,'features/feature-icon-03.png','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(153,0,'feature-icon-04','feature-icon-04',9,'image/png',1158,'features/feature-icon-04.png','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(154,0,'feature-icon-05','feature-icon-05',9,'image/png',1887,'features/feature-icon-05.png','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(155,0,'feature-icon-06','feature-icon-06',9,'image/png',1666,'features/feature-icon-06.png','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(156,0,'pla-product-01','pla-product-01',10,'image/jpeg',9803,'products/pla-product-01.jpg','[]','2026-02-09 00:18:48','2026-02-09 00:18:48',NULL,'public'),(157,0,'pla-product-02','pla-product-02',10,'image/jpeg',9803,'products/pla-product-02.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(158,0,'pla-product-03','pla-product-03',10,'image/jpeg',9803,'products/pla-product-03.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(159,0,'pla-product-04','pla-product-04',10,'image/jpeg',9803,'products/pla-product-04.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(160,0,'product-1','product-1',10,'image/jpeg',9803,'products/product-1.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(161,0,'product-10','product-10',10,'image/jpeg',9803,'products/product-10.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(162,0,'product-11','product-11',10,'image/jpeg',9803,'products/product-11.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(163,0,'product-12','product-12',10,'image/jpeg',9803,'products/product-12.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(164,0,'product-13','product-13',10,'image/jpeg',9803,'products/product-13.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(165,0,'product-14','product-14',10,'image/jpeg',9803,'products/product-14.jpg','[]','2026-02-09 00:18:49','2026-02-09 00:18:49',NULL,'public'),(166,0,'product-15','product-15',10,'image/jpeg',9803,'products/product-15.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(167,0,'product-16','product-16',10,'image/jpeg',9803,'products/product-16.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(168,0,'product-17','product-17',10,'image/jpeg',9803,'products/product-17.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(169,0,'product-18','product-18',10,'image/jpeg',9803,'products/product-18.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(170,0,'product-19','product-19',10,'image/jpeg',9803,'products/product-19.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(171,0,'product-2','product-2',10,'image/jpeg',9803,'products/product-2.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(172,0,'product-20','product-20',10,'image/jpeg',9803,'products/product-20.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(173,0,'product-21','product-21',10,'image/jpeg',9803,'products/product-21.jpg','[]','2026-02-09 00:18:50','2026-02-09 00:18:50',NULL,'public'),(174,0,'product-22','product-22',10,'image/jpeg',9803,'products/product-22.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(175,0,'product-23','product-23',10,'image/jpeg',9803,'products/product-23.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(176,0,'product-24','product-24',10,'image/jpeg',9803,'products/product-24.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(177,0,'product-25','product-25',10,'image/jpeg',9803,'products/product-25.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(178,0,'product-26','product-26',10,'image/jpeg',9803,'products/product-26.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(179,0,'product-27','product-27',10,'image/jpeg',9803,'products/product-27.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(180,0,'product-28','product-28',10,'image/jpeg',9803,'products/product-28.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(181,0,'product-29','product-29',10,'image/jpeg',9803,'products/product-29.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(182,0,'product-3','product-3',10,'image/jpeg',9803,'products/product-3.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(183,0,'product-30','product-30',10,'image/jpeg',9803,'products/product-30.jpg','[]','2026-02-09 00:18:51','2026-02-09 00:18:51',NULL,'public'),(184,0,'product-31','product-31',10,'image/jpeg',9803,'products/product-31.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(185,0,'product-32','product-32',10,'image/jpeg',9803,'products/product-32.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(186,0,'product-33','product-33',10,'image/jpeg',9803,'products/product-33.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(187,0,'product-34','product-34',10,'image/jpeg',9803,'products/product-34.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(188,0,'product-35','product-35',10,'image/jpeg',9803,'products/product-35.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(189,0,'product-36','product-36',10,'image/jpeg',9803,'products/product-36.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(190,0,'product-37','product-37',10,'image/jpeg',9803,'products/product-37.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(191,0,'product-38','product-38',10,'image/jpeg',9803,'products/product-38.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(192,0,'product-39','product-39',10,'image/jpeg',9803,'products/product-39.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(193,0,'product-4','product-4',10,'image/jpeg',9803,'products/product-4.jpg','[]','2026-02-09 00:18:52','2026-02-09 00:18:52',NULL,'public'),(194,0,'product-40','product-40',10,'image/jpeg',9803,'products/product-40.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(195,0,'product-41','product-41',10,'image/jpeg',9803,'products/product-41.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(196,0,'product-42','product-42',10,'image/jpeg',9803,'products/product-42.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(197,0,'product-43','product-43',10,'image/jpeg',9803,'products/product-43.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(198,0,'product-44','product-44',10,'image/jpeg',9803,'products/product-44.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(199,0,'product-45','product-45',10,'image/jpeg',9803,'products/product-45.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(200,0,'product-46','product-46',10,'image/jpeg',9803,'products/product-46.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(201,0,'product-47','product-47',10,'image/jpeg',9803,'products/product-47.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(202,0,'product-48','product-48',10,'image/jpeg',9803,'products/product-48.jpg','[]','2026-02-09 00:18:53','2026-02-09 00:18:53',NULL,'public'),(203,0,'product-49','product-49',10,'image/jpeg',9803,'products/product-49.jpg','[]','2026-02-09 00:18:54','2026-02-09 00:18:54',NULL,'public'),(204,0,'product-5','product-5',10,'image/jpeg',9803,'products/product-5.jpg','[]','2026-02-09 00:18:54','2026-02-09 00:18:54',NULL,'public'),(205,0,'product-50','product-50',10,'image/jpeg',9803,'products/product-50.jpg','[]','2026-02-09 00:18:54','2026-02-09 00:18:54',NULL,'public'),(206,0,'product-51','product-51',10,'image/jpeg',9803,'products/product-51.jpg','[]','2026-02-09 00:18:54','2026-02-09 00:18:54',NULL,'public'),(207,0,'product-52','product-52',10,'image/jpeg',9803,'products/product-52.jpg','[]','2026-02-09 00:18:54','2026-02-09 00:18:54',NULL,'public'),(208,0,'product-53','product-53',10,'image/jpeg',9803,'products/product-53.jpg','[]','2026-02-09 00:18:54','2026-02-09 00:18:54',NULL,'public'),(209,0,'product-54','product-54',10,'image/jpeg',9803,'products/product-54.jpg','[]','2026-02-09 00:18:54','2026-02-09 00:18:54',NULL,'public'),(210,0,'product-55','product-55',10,'image/jpeg',9803,'products/product-55.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(211,0,'product-56','product-56',10,'image/jpeg',9803,'products/product-56.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(212,0,'product-57','product-57',10,'image/jpeg',9803,'products/product-57.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(213,0,'product-58','product-58',10,'image/jpeg',9803,'products/product-58.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(214,0,'product-59','product-59',10,'image/jpeg',9803,'products/product-59.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(215,0,'product-6','product-6',10,'image/jpeg',9803,'products/product-6.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(216,0,'product-60','product-60',10,'image/jpeg',9803,'products/product-60.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(217,0,'product-61','product-61',10,'image/jpeg',9803,'products/product-61.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(218,0,'product-62','product-62',10,'image/jpeg',9803,'products/product-62.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(219,0,'product-63','product-63',10,'image/jpeg',9803,'products/product-63.jpg','[]','2026-02-09 00:18:55','2026-02-09 00:18:55',NULL,'public'),(220,0,'product-64','product-64',10,'image/jpeg',9803,'products/product-64.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(221,0,'product-65','product-65',10,'image/jpeg',9803,'products/product-65.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(222,0,'product-66','product-66',10,'image/jpeg',9803,'products/product-66.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(223,0,'product-67','product-67',10,'image/jpeg',9803,'products/product-67.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(224,0,'product-68','product-68',10,'image/jpeg',9803,'products/product-68.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(225,0,'product-69','product-69',10,'image/jpeg',9803,'products/product-69.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(226,0,'product-7','product-7',10,'image/jpeg',9803,'products/product-7.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(227,0,'product-70','product-70',10,'image/jpeg',9803,'products/product-70.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(228,0,'product-71','product-71',10,'image/jpeg',9803,'products/product-71.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(229,0,'product-72','product-72',10,'image/jpeg',9803,'products/product-72.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(230,0,'product-73','product-73',10,'image/jpeg',9803,'products/product-73.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(231,0,'product-74','product-74',10,'image/jpeg',9803,'products/product-74.jpg','[]','2026-02-09 00:18:56','2026-02-09 00:18:56',NULL,'public'),(232,0,'product-75','product-75',10,'image/jpeg',9803,'products/product-75.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(233,0,'product-76','product-76',10,'image/jpeg',9803,'products/product-76.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(234,0,'product-77','product-77',10,'image/jpeg',9803,'products/product-77.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(235,0,'product-78','product-78',10,'image/jpeg',9803,'products/product-78.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(236,0,'product-79','product-79',10,'image/jpeg',9803,'products/product-79.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(237,0,'product-8','product-8',10,'image/jpeg',9803,'products/product-8.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(238,0,'product-80','product-80',10,'image/jpeg',9803,'products/product-80.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(239,0,'product-81','product-81',10,'image/jpeg',9803,'products/product-81.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(240,0,'product-82','product-82',10,'image/jpeg',9803,'products/product-82.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(241,0,'product-83','product-83',10,'image/jpeg',9803,'products/product-83.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(242,0,'product-84','product-84',10,'image/jpeg',9803,'products/product-84.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(243,0,'product-85','product-85',10,'image/jpeg',9803,'products/product-85.jpg','[]','2026-02-09 00:18:57','2026-02-09 00:18:57',NULL,'public'),(244,0,'product-86','product-86',10,'image/jpeg',9803,'products/product-86.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(245,0,'product-87','product-87',10,'image/jpeg',9803,'products/product-87.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(246,0,'product-88','product-88',10,'image/jpeg',9803,'products/product-88.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(247,0,'product-89','product-89',10,'image/jpeg',9803,'products/product-89.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(248,0,'product-9','product-9',10,'image/jpeg',9803,'products/product-9.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(249,0,'product-90','product-90',10,'image/jpeg',9803,'products/product-90.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(250,0,'product-91','product-91',10,'image/jpeg',9803,'products/product-91.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(251,0,'product-92','product-92',10,'image/jpeg',9803,'products/product-92.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(252,0,'product-93','product-93',10,'image/jpeg',9803,'products/product-93.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(253,0,'product-94','product-94',10,'image/jpeg',9803,'products/product-94.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(254,0,'product-95','product-95',10,'image/jpeg',9803,'products/product-95.jpg','[]','2026-02-09 00:18:58','2026-02-09 00:18:58',NULL,'public'),(255,0,'1','1',11,'image/jpeg',9803,'customers/1.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(256,0,'10','10',11,'image/jpeg',9803,'customers/10.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(257,0,'2','2',11,'image/jpeg',9803,'customers/2.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(258,0,'3','3',11,'image/jpeg',9803,'customers/3.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(259,0,'4','4',11,'image/jpeg',9803,'customers/4.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(260,0,'5','5',11,'image/jpeg',9803,'customers/5.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(261,0,'6','6',11,'image/jpeg',9803,'customers/6.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(262,0,'7','7',11,'image/jpeg',9803,'customers/7.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(263,0,'8','8',11,'image/jpeg',9803,'customers/8.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(264,0,'9','9',11,'image/jpeg',9803,'customers/9.jpg','[]','2026-02-09 00:19:13','2026-02-09 00:19:13',NULL,'public'),(265,0,'1','1',12,'image/jpeg',9803,'galleries/1.jpg','[]','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL,'public'),(266,0,'2','2',12,'image/jpeg',9803,'galleries/2.jpg','[]','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL,'public'),(267,0,'3','3',12,'image/jpeg',9803,'galleries/3.jpg','[]','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL,'public'),(268,0,'4','4',12,'image/jpeg',9803,'galleries/4.jpg','[]','2026-02-09 00:19:18','2026-02-09 00:19:18',NULL,'public'),(269,0,'5','5',12,'image/jpeg',9803,'galleries/5.jpg','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(270,0,'6','6',12,'image/jpeg',9803,'galleries/6.jpg','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(278,0,'avatar-1','avatar-1',14,'image/png',674,'testimonials/avatar-1.png','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(279,0,'avatar-2','avatar-2',14,'image/png',674,'testimonials/avatar-2.png','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(280,0,'avatar-3','avatar-3',14,'image/png',674,'testimonials/avatar-3.png','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(281,0,'team-1','team-1',14,'image/jpeg',6202,'testimonials/team-1.jpg','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(282,0,'team-2','team-2',14,'image/jpeg',6202,'testimonials/team-2.jpg','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(283,0,'team-3','team-3',14,'image/jpeg',6202,'testimonials/team-3.jpg','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public'),(284,0,'team-4','team-4',14,'image/jpeg',6202,'testimonials/team-4.jpg','[]','2026-02-09 00:19:19','2026-02-09 00:19:19',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'general',NULL,'general',0,'2026-02-09 00:18:30','2026-02-09 00:18:30',NULL),(2,0,'payments',NULL,'payments',0,'2026-02-09 00:18:32','2026-02-09 00:18:32',NULL),(3,0,'blog',NULL,'blog',0,'2026-02-09 00:18:34','2026-02-09 00:18:34',NULL),(4,0,'shop',NULL,'shop',0,'2026-02-09 00:18:38','2026-02-09 00:18:38',NULL),(5,0,'banners',NULL,'banners',0,'2026-02-09 00:18:39','2026-02-09 00:18:39',NULL),(6,0,'icons',NULL,'icons',0,'2026-02-09 00:18:42','2026-02-09 00:18:42',NULL),(7,0,'sliders',NULL,'sliders',0,'2026-02-09 00:18:44','2026-02-09 00:18:44',NULL),(8,0,'brands',NULL,'brands',0,'2026-02-09 00:18:46','2026-02-09 00:18:46',NULL),(9,0,'features',NULL,'features',0,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL),(10,0,'products',NULL,'products',0,'2026-02-09 00:18:48','2026-02-09 00:18:48',NULL),(11,0,'customers',NULL,'customers',0,'2026-02-09 00:19:13','2026-02-09 00:19:13',NULL),(12,0,'galleries',NULL,'galleries',0,'2026-02-09 00:19:18','2026-02-09 00:19:18',NULL),(14,0,'testimonials',NULL,'testimonials',0,'2026-02-09 00:19:19','2026-02-09 00:19:19',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2026-02-09 00:19:18','2026-02-09 00:19:18'),(2,2,'information','2026-02-09 00:19:18','2026-02-09 00:19:18'),(3,3,'my-account','2026-02-09 00:19:18','2026-02-09 00:19:18'),(4,4,'social-network','2026-02-09 00:19:18','2026-02-09 00:19:18');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(2,1,1,1,'Botble\\Page\\Models\\Page','/',NULL,0,'Wooden Home',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(3,1,1,2,'Botble\\Page\\Models\\Page','/fashion-home',NULL,1,'Fashion Home',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(4,1,1,3,'Botble\\Page\\Models\\Page','/furniture-home',NULL,2,'Furniture Home',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(5,1,1,4,'Botble\\Page\\Models\\Page','/cosmetics-home',NULL,3,'Cosmetics Home',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(6,1,1,5,'Botble\\Page\\Models\\Page','/food-grocery-home',NULL,4,'Food Grocery',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(7,1,0,NULL,NULL,'/',NULL,1,'Shop',NULL,'_self',1,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(8,1,7,NULL,NULL,'/products',NULL,0,'Shop Grid',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,1,'Shop List',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(10,1,7,NULL,NULL,'',NULL,2,'Shop Detail',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(11,1,7,10,'Botble\\Page\\Models\\Page','/store-locator',NULL,3,'Shop Location',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(12,1,7,NULL,NULL,'/cart',NULL,4,'Cart',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(13,1,7,NULL,NULL,'/wishlist',NULL,5,'Wishlist',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(14,1,0,NULL,NULL,'/',NULL,2,'Pages',NULL,'_self',1,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(15,1,14,NULL,NULL,'/orders/tracking',NULL,0,'Order Tracking',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(16,1,14,7,'Botble\\Page\\Models\\Page','/about',NULL,1,'About',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(17,1,14,NULL,NULL,'/register',NULL,2,'Sign up',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(18,1,14,NULL,NULL,'/login',NULL,3,'Login',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(19,1,14,NULL,NULL,'/404',NULL,4,'404 / Error',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(20,1,14,9,'Botble\\Page\\Models\\Page','/coming-soon',NULL,5,'Coming soon',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(21,1,0,NULL,NULL,'/',NULL,3,'Blog',NULL,'_self',1,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(22,1,21,6,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(23,1,21,NULL,NULL,'',NULL,1,'Blog Detail',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(24,1,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,4,'Contact',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(25,2,0,NULL,NULL,'/',NULL,0,'Custom Service',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(26,2,0,11,'Botble\\Page\\Models\\Page','/faqs',NULL,1,'FAQs',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(27,2,0,NULL,NULL,'orders/tracking',NULL,2,'Order Tracking',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(28,2,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,3,'Contact',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(29,2,0,NULL,NULL,'/',NULL,4,'Events',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(30,3,0,NULL,NULL,'/',NULL,0,'Delivery Information',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(31,3,0,NULL,NULL,'/',NULL,1,'Privacy Policy',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(32,3,0,NULL,NULL,'/',NULL,2,'Discount',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(33,3,0,NULL,NULL,'/',NULL,3,'Custom Service',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(34,3,0,NULL,NULL,'/',NULL,4,'Terms & Condition',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(35,4,0,NULL,NULL,'https://facebook.com','ti ti-brand-facebook',0,'Facebook',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(36,4,0,NULL,NULL,'https://dribbble.com','ti ti-brand-dribbble',1,'Dribble',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(37,4,0,NULL,NULL,'https://x.com','ti ti-brand-x',2,'X (Twitter)',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(38,4,0,NULL,NULL,'https://behance.com','ti ti-brand-behance',3,'Behance',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18'),(39,4,0,NULL,NULL,'https://youtube.com','ti ti-brand-youtube',4,'YouTube',NULL,'_self',0,'2026-02-09 00:19:18','2026-02-09 00:19:18');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2026-02-09 00:19:18','2026-02-09 00:19:18'),(2,'Information','information','published','2026-02-09 00:19:18','2026-02-09 00:19:18'),(3,'My Account','my-account','published','2026-02-09 00:19:18','2026-02-09 00:19:18'),(4,'Social Network','social-network','published','2026-02-09 00:19:18','2026-02-09 00:19:18');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'header_style','[\"collapsed\"]',1,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(2,'customize_footer','[\"custom\"]',2,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(3,'footer_background_color','[\"#040404\"]',2,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(4,'footer_text_color','[\"#fff\"]',2,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(5,'footer_text_muted_color','[\"#a0a0a0\"]',2,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(6,'footer_logo','[\"general\\/logo-white.png\"]',2,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(7,'footer_border_color','[\"#282828\"]',2,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(8,'footer_bottom_background_color','[\"#040404\"]',2,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(9,'customize_footer','[\"custom\"]',3,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(10,'footer_bottom_background_color','[\"#f8f8f8\"]',3,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(11,'header_style','[\"centered-logo\"]',4,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(12,'customize_footer','[\"custom\"]',4,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(13,'footer_background_color','[\"#F7EFEC\"]',4,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(14,'footer_bottom_background_color','[\"#F7EFEC\"]',4,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(15,'customize_footer','[\"custom\"]',5,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(16,'footer_background_color','[\"#F7EFEC\"]',5,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(17,'footer_bottom_background_color','[\"#F7EFEC\"]',5,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(18,'customize_footer','[\"custom\"]',7,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(19,'footer_background_color','[\"#040404\"]',7,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(20,'footer_text_color','[\"#fff\"]',7,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(21,'footer_text_muted_color','[\"#a0a0a0\"]',7,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(22,'footer_logo','[\"general\\/logo-white.png\"]',7,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(23,'footer_border_color','[\"#282828\"]',7,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(24,'footer_bottom_background_color','[\"#040404\"]',7,'Botble\\Page\\Models\\Page','2026-02-09 00:18:39','2026-02-09 00:18:39'),(25,'subtitle','[\"Accessories\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(26,'action_label','[\"Shop Now\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(27,'subtitle','[\"Accessories\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(28,'action_label','[\"Shop Now\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(29,'subtitle','[\"Accessories\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(30,'action_label','[\"Shop Now\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(31,'subtitle','[\"Winter\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(32,'action_label','[\"Shop Now\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(33,'subtitle','[\"Winter\"]',5,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(34,'action_label','[\"Shop Now\"]',5,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(35,'subtitle','[\"Winter\"]',6,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(36,'action_label','[\"Shop Now\"]',6,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(37,'subtitle','[null]',7,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(38,'action_label','[\"Shop Now\"]',7,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(39,'subtitle','[\"New Modern Stylist Fashionable Women\'s Wear holder\"]',8,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(40,'action_label','[\"Shop Now\"]',8,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(41,'subtitle','[\"New Modern Stylist Fashionable Women\'s Wear holder\"]',9,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(42,'action_label','[\"Shop Now\"]',9,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(43,'subtitle','[null]',10,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(44,'action_label','[\"Shop Now\"]',10,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(45,'subtitle','[null]',11,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(46,'action_label','[\"Shop Now\"]',11,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(47,'subtitle','[null]',12,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(48,'action_label','[\"Shop Now\"]',12,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(49,'subtitle','[null]',13,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(50,'action_label','[\"Shop Now\"]',13,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(51,'subtitle','[null]',14,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(52,'action_label','[\"Shop Now\"]',14,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(53,'subtitle','[null]',15,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(54,'action_label','[\"Shop Now\"]',15,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2026-02-09 00:18:46','2026-02-09 00:18:46'),(55,'subtitle','[\"Collection\"]',3,'Botble\\Ads\\Models\\Ads','2026-02-09 00:18:46','2026-02-09 00:18:46'),(56,'subtitle','[\"New Modern Stylist Fashionable <br> Women\'s Wear holder\"]',4,'Botble\\Ads\\Models\\Ads','2026-02-09 00:18:46','2026-02-09 00:18:46'),(57,'subtitle','[\"Furniture\"]',5,'Botble\\Ads\\Models\\Ads','2026-02-09 00:18:46','2026-02-09 00:18:46'),(58,'subtitle','[\"100 Added\"]',6,'Botble\\Ads\\Models\\Ads','2026-02-09 00:18:46','2026-02-09 00:18:46'),(59,'subtitle','[\"-60% Offer\"]',7,'Botble\\Ads\\Models\\Ads','2026-02-09 00:18:46','2026-02-09 00:18:46'),(60,'subtitle','[\"Best Bakery Products\"]',8,'Botble\\Ads\\Models\\Ads','2026-02-09 00:18:46','2026-02-09 00:18:46'),(61,'subtitle','[\"Best Bakery Products\"]',9,'Botble\\Ads\\Models\\Ads','2026-02-09 00:18:46','2026-02-09 00:18:46'),(62,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',1,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(63,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',2,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(64,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',3,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(65,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',4,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(66,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',5,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(67,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',6,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(68,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',7,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(69,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',8,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(70,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',9,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(71,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',10,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(72,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',11,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(73,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',12,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(74,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',13,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(75,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',14,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(76,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',15,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(77,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',16,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(78,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',17,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(79,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',18,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(80,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',19,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(81,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',20,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(82,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',21,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(83,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',22,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(84,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',23,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(85,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',24,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(86,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',25,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(87,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',26,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(88,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',27,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(89,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',28,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(90,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',29,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(91,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',30,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(92,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',31,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(93,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',32,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(94,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',33,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(95,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',34,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(96,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',35,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(97,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',36,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(98,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',37,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:18:59','2026-02-09 00:18:59'),(99,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',38,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(100,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',39,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(101,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',40,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(102,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',41,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(103,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',42,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(104,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',43,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(105,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',44,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(106,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',45,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(107,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',46,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(108,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',47,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(109,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',48,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(110,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',49,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(111,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',50,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(112,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',51,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(113,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',52,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(114,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',53,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(115,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',54,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(116,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',55,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(117,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',56,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(118,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',57,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(119,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',58,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(120,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',59,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(121,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',60,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(122,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',61,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(123,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',62,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(124,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',63,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(125,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',64,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(126,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',65,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(127,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',66,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(128,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',67,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(129,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',68,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(130,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',69,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(131,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',70,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(132,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',71,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(133,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',72,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:00','2026-02-09 00:19:00'),(134,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',73,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:01','2026-02-09 00:19:01'),(135,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',74,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:01','2026-02-09 00:19:01'),(136,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',75,'Botble\\Ecommerce\\Models\\Product','2026-02-09 00:19:01','2026-02-09 00:19:01'),(137,'title','[\"Satisfied client testimonial\"]',1,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20'),(138,'star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20'),(139,'title','[\"98% of residents recommend us\"]',2,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20'),(140,'star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20'),(141,'title','[\"Our success stories\"]',3,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20'),(142,'star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20'),(143,'title','[\"This is simply unbelievable\"]',4,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20'),(144,'star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2026-02-09 00:19:20','2026-02-09 00:19:20');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=296 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2016_06_10_230148_create_acl_tables',1),(7,'2016_06_14_230857_create_menus_table',1),(8,'2016_06_28_221418_create_pages_table',1),(9,'2016_10_05_074239_create_setting_table',1),(10,'2016_11_28_032840_create_dashboard_widget_tables',1),(11,'2016_12_16_084601_create_widgets_table',1),(12,'2017_05_09_070343_create_media_tables',1),(13,'2017_11_03_070450_create_slug_table',1),(14,'2019_01_05_053554_create_jobs_table',1),(15,'2019_08_19_000000_create_failed_jobs_table',1),(16,'2019_12_14_000001_create_personal_access_tokens_table',1),(17,'2022_04_20_100851_add_index_to_media_table',1),(18,'2022_04_20_101046_add_index_to_menu_table',1),(19,'2022_07_10_034813_move_lang_folder_to_root',1),(20,'2022_08_04_051940_add_missing_column_expires_at',1),(21,'2022_09_01_000001_create_admin_notifications_tables',1),(22,'2022_10_14_024629_drop_column_is_featured',1),(23,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(24,'2022_12_02_093615_update_slug_index_columns',1),(25,'2023_01_30_024431_add_alt_to_media_table',1),(26,'2023_02_16_042611_drop_table_password_resets',1),(27,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(28,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(29,'2023_08_21_090810_make_page_content_nullable',1),(30,'2023_08_26_080444_fix_missing_copyright_widget',1),(31,'2023_09_07_025340_activate_mollie_and_sale_popup_plugin',1),(32,'2023_09_14_021936_update_index_for_slugs_table',1),(33,'2023_10_27_023808_update_page_metabox',1),(34,'2023_11_22_071805_migrate_header_messages_to_announcements_table',1),(35,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(36,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(37,'2024_03_25_000000_migrate_rename_shortcode_contact_box_to_contact_form',1),(38,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(39,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(40,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(41,'2024_07_12_100000_change_random_hash_for_media',1),(42,'2024_09_30_024515_create_sessions_table',1),(43,'2024_12_01_000000_add_indexes_to_pages_translations_table',1),(44,'2024_12_01_000000_add_key_prefix_index_to_slugs_table',1),(45,'2024_12_19_000001_create_device_tokens_table',1),(46,'2024_12_19_000002_create_push_notifications_table',1),(47,'2024_12_19_000003_create_push_notification_recipients_table',1),(48,'2024_12_30_000001_create_user_settings_table',1),(49,'2025_07_06_030754_add_phone_to_users_table',1),(50,'2025_07_31_add_performance_indexes_to_slugs_table',1),(51,'2025_11_10_000000_cleanup_duplicate_widgets',1),(52,'2025_11_30_100000_add_sessions_invalidated_at_to_users_table',1),(53,'2020_11_18_150916_ads_create_ads_table',2),(54,'2021_12_02_035301_add_ads_translations_table',2),(55,'2023_04_17_062645_add_open_in_new_tab',2),(56,'2023_11_07_023805_add_tablet_mobile_image',2),(57,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',2),(58,'2025_04_21_000000_add_tablet_mobile_image_to_ads_translations_table',2),(59,'2024_04_27_100730_improve_analytics_setting',3),(60,'2023_08_11_060908_create_announcements_table',4),(61,'2025_02_11_153025_add_action_label_to_announcement_translations',4),(62,'2015_06_29_025744_create_audit_history',5),(63,'2023_11_14_033417_change_request_column_in_table_audit_histories',5),(64,'2025_05_05_000001_add_user_type_to_audit_histories_table',5),(65,'2025_11_07_000001_add_actor_type_to_audit_histories_table',5),(66,'2015_06_18_033822_create_blog_table',6),(67,'2021_02_16_092633_remove_default_value_for_author_type',6),(68,'2021_12_03_030600_create_blog_translations',6),(69,'2022_04_19_113923_add_index_to_table_posts',6),(70,'2023_08_29_074620_make_column_author_id_nullable',6),(71,'2024_07_30_091615_fix_order_column_in_categories_table',6),(72,'2024_12_01_000000_add_indexes_to_blog_translations_tables',6),(73,'2025_01_06_033807_add_default_value_for_categories_author_type',6),(74,'2016_06_17_091537_create_contacts_table',7),(75,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',7),(76,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',7),(77,'2024_03_25_000001_update_captcha_settings_for_contact',7),(78,'2024_04_19_063914_create_custom_fields_table',7),(79,'2024_12_01_000000_add_indexes_to_contact_translations_tables',7),(80,'2020_03_05_041139_create_ecommerce_tables',8),(81,'2021_01_01_044147_ecommerce_create_flash_sale_table',8),(82,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',8),(83,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',8),(84,'2021_02_18_073505_update_table_ec_reviews',8),(85,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',8),(86,'2021_03_10_025153_change_column_tax_amount',8),(87,'2021_03_20_033103_add_column_availability_to_table_ec_products',8),(88,'2021_04_28_074008_ecommerce_create_product_label_table',8),(89,'2021_05_31_173037_ecommerce_create_ec_products_translations',8),(90,'2021_08_17_105016_remove_column_currency_id_in_some_tables',8),(91,'2021_08_30_142128_add_images_column_to_ec_reviews_table',8),(92,'2021_10_04_030050_add_column_created_by_to_table_ec_products',8),(93,'2021_10_05_122616_add_status_column_to_ec_customers_table',8),(94,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',8),(95,'2021_11_23_071403_correct_languages_for_product_variations',8),(96,'2021_11_28_031808_add_product_tags_translations',8),(97,'2021_12_01_031123_add_featured_image_to_ec_products',8),(98,'2022_01_01_033107_update_table_ec_shipments',8),(99,'2022_02_16_042457_improve_product_attribute_sets',8),(100,'2022_03_22_075758_correct_product_name',8),(101,'2022_04_19_113334_add_index_to_ec_products',8),(102,'2022_04_28_144405_remove_unused_table',8),(103,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',8),(104,'2022_05_18_143720_add_index_to_table_ec_product_categories',8),(105,'2022_06_16_095633_add_index_to_some_tables',8),(106,'2022_06_30_035148_create_order_referrals_table',8),(107,'2022_07_24_153815_add_completed_at_to_ec_orders_table',8),(108,'2022_08_14_032836_create_ec_order_returns_table',8),(109,'2022_08_14_033554_create_ec_order_return_items_table',8),(110,'2022_08_15_040324_add_billing_address',8),(111,'2022_08_30_091114_support_digital_products_table',8),(112,'2022_09_13_095744_create_options_table',8),(113,'2022_09_13_104347_create_option_value_table',8),(114,'2022_10_05_163518_alter_table_ec_order_product',8),(115,'2022_10_12_041517_create_invoices_table',8),(116,'2022_10_12_142226_update_orders_table',8),(117,'2022_10_13_024916_update_table_order_returns',8),(118,'2022_10_21_030830_update_columns_in_ec_shipments_table',8),(119,'2022_10_28_021046_update_columns_in_ec_shipments_table',8),(120,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',8),(121,'2022_11_19_041643_add_ec_tax_product_table',8),(122,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',8),(123,'2022_12_17_041532_fix_address_in_order_invoice',8),(124,'2022_12_26_070329_create_ec_product_views_table',8),(125,'2023_01_04_033051_fix_product_categories',8),(126,'2023_01_09_050400_add_ec_global_options_translations_table',8),(127,'2023_01_10_093754_add_missing_option_value_id',8),(128,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',8),(129,'2023_01_26_021854_add_ec_customer_used_coupons_table',8),(130,'2023_02_08_015900_update_options_column_in_ec_order_product_table',8),(131,'2023_02_27_095752_remove_duplicate_reviews',8),(132,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',8),(133,'2023_04_21_082427_create_ec_product_categorizables_table',8),(134,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',8),(135,'2023_05_17_025812_fix_invoice_issue',8),(136,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',8),(137,'2023_05_27_144611_fix_exchange_rate_setting',8),(138,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',8),(139,'2023_06_30_042512_create_ec_order_tax_information_table',8),(140,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',8),(141,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',8),(142,'2023_08_15_064505_create_ec_tax_rules_table',8),(143,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',8),(144,'2023_08_22_094114_drop_unique_for_barcode',8),(145,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',8),(146,'2023_09_07_094312_add_index_to_product_sku_and_translations',8),(147,'2023_09_19_024955_create_discount_product_categories_table',8),(148,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',8),(149,'2023_11_22_154643_add_unique_in_table_ec_products_variations',8),(150,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',8),(151,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',8),(152,'2023_12_25_040604_ec_create_review_replies_table',8),(153,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',8),(154,'2024_01_16_070706_fix_translation_tables',8),(155,'2024_01_23_075227_add_proof_file_to_ec_orders_table',8),(156,'2024_03_26_041531_add_cancel_reason_to_ec_orders_table',8),(157,'2024_03_27_062402_create_ec_customer_deletion_requests_table',8),(158,'2024_03_29_042242_migrate_old_captcha_settings',8),(159,'2024_03_29_093946_create_ec_order_return_histories_table',8),(160,'2024_04_01_063523_add_customer_columns_to_ec_reviews_table',8),(161,'2024_04_15_092654_migrate_ecommerce_google_tag_manager_code_setting',8),(162,'2024_04_16_035713_add_min_max_order_quantity_columns_to_products_table',8),(163,'2024_05_07_073153_improve_table_wishlist',8),(164,'2024_05_07_093703_add_missing_zip_code_into_table_store_locators',8),(165,'2024_05_15_021503_fix_invoice_path',8),(166,'2024_06_20_160724_create_ec_shared_wishlists_table',8),(167,'2024_06_28_025104_add_notify_attachment_updated_column_to_ec_products_table',8),(168,'2024_07_03_030900_add_downloaded_at_column_to_ec_order_product_table',8),(169,'2024_07_14_071826_make_customer_email_nullable',8),(170,'2024_07_15_104916_add_video_media_column_to_ec_products_table',8),(171,'2024_07_26_052530_add_percentage_to_tax_rules_table',8),(172,'2024_08_14_123028_add_customer_delivered_confirmed_at_column_to_ec_shipments_table',8),(173,'2024_08_19_132849_create_specification_tables',8),(174,'2024_09_07_060744_add_author_column_to_specification_tables',8),(175,'2024_09_14_064023_add_can_use_with_flash_sale_column_to_ec_discounts_table',8),(176,'2024_09_25_073928_remove_wrong_product_slugs',8),(177,'2024_12_01_000000_add_indexes_to_ecommerce_translations_tables',8),(178,'2025_01_10_000000_fix_order_invoice_rounding_issues',8),(179,'2025_01_15_050230_migrate_old_theme_options',8),(180,'2025_01_15_optimize_products_export_index',8),(181,'2025_01_17_082713_correct_column_barcode_and_cost_per_item_to_product_table',8),(182,'2025_01_24_044641_migrate_old_country_data',8),(183,'2025_01_28_233602_add_private_notes_into_ec_orders_table',8),(184,'2025_02_13_021247_add_tax_translations',8),(185,'2025_02_24_152621_add_text_color_to_product_labels_table',8),(186,'2025_04_12_000001_add_payment_fee_to_ec_orders_table',8),(187,'2025_04_12_000002_add_payment_fee_to_ec_invoices_table',8),(188,'2025_05_05_092036_make_user_id_and_tax_amount_nullable',8),(189,'2025_05_15_082342_drop_email_unique_index_in_ec_customers_table',8),(190,'2025_06_07_081731_add_translations_for_specification_groups_and_tables',8),(191,'2025_06_17_091813_increase_note_in_shipments_table',8),(192,'2025_06_24_000001_create_ec_product_license_codes_table',8),(193,'2025_06_24_080427_add_license_code_type_to_products_table',8),(194,'2025_07_06_062402_create_ec_customer_deletion_requests_table',8),(195,'2025_07_07_161729_change_license_code_to_text_in_ec_product_license_codes_table',8),(196,'2025_07_08_162756_increase_license_code_column_size_in_ec_order_product_table',8),(197,'2025_07_09_000001_add_customer_address_fields_to_ec_invoices_table',8),(198,'2025_07_15_090809_create_ec_abandoned_carts_table',8),(199,'2025_07_24_120510_increase_barcode_column_length_in_ec_products_table',8),(200,'2025_07_31_133600_add_performance_indexes_to_ec_product_categories_table',8),(201,'2025_08_01_161205_optimize_product_variation_query_indexes',8),(202,'2025_08_08_145059_correct_tax_amount_in_order_and_invoice_tables',8),(203,'2025_09_05_025247_create_ec_product_specification_attribute_translations_table',8),(204,'2025_09_08_025516_add_variations_count_to_ec_products_table',8),(205,'2025_09_08_080248_add_slug_column_to_ec_product_categories_table',8),(206,'2025_09_08_080330_add_slug_column_to_ec_product_categories_translations_table',8),(207,'2025_09_08_080443_populate_slug_column_for_product_categories',8),(208,'2025_09_08_081216_add_slug_column_to_ec_products_table',8),(209,'2025_09_08_081237_add_slug_column_to_ec_products_translations_table',8),(210,'2025_09_08_081321_populate_slug_column_for_products',8),(211,'2025_09_10_073321_add_performance_indexes_to_ecommerce_tables',8),(212,'2025_09_18_093922_fix_tax_rounding_in_order_products_and_invoices',8),(213,'2025_09_21_030756_add_reviews_cache_to_ec_products_table',8),(214,'2025_09_30_090432_add_performance_indexes_to_ec_product_categories_table',8),(215,'2025_10_10_090331_add_number_format_style_to_ec_currencies_table',8),(216,'2025_10_10_092235_add_space_between_price_and_currency_to_ec_currencies_table',8),(217,'2025_10_11_074318_add_price_includes_tax_to_ec_products_table',8),(218,'2025_10_13_043527_generate_slugs_for_product_collections',8),(219,'2025_10_22_020518_add_verification_code_to_ec_customer_deletion_requests_table',8),(220,'2025_10_22_090000_remove_duplicate_order_addresses',8),(221,'2025_10_28_133220_add_unique_order_id_to_shipments_table',8),(222,'2025_10_28_134738_fix_order_payment_shipment_discount_data_issues',8),(223,'2025_11_05_032148_add_performance_indexes_to_ecommerce_tables',8),(224,'2025_11_10_100000_create_ec_order_metadata_table',8),(225,'2025_11_12_100000_improve_ec_customer_recently_viewed_products_table',8),(226,'2025_11_18_214150_add_covering_indexes_to_product_relation_tables',8),(227,'2025_12_02_045049_add_index_to_product_labels_table',8),(228,'2025_12_12_150000_add_sequence_columns_to_abandoned_carts',8),(229,'2025_12_16_160000_add_is_new_until_to_ec_products_table',8),(230,'2025_12_28_000628_add_images_column_to_ec_order_returns_table',8),(231,'2026_01_05_162601_update_missing_slugs_for_ec_product_categories_table',8),(232,'2026_01_09_024811_add_currency_code_to_ec_products_table',8),(233,'2026_01_11_221755_add_price_columns_to_ec_product_up_sale_relations_table',8),(234,'2026_01_14_035001_add_customer_id_to_ec_cart_table',8),(235,'2026_01_26_084750_add_customer_id_to_ec_review_replies_table',8),(236,'2026_01_31_144854_add_zip_code_range_to_ec_shipping_rule_items_table',8),(237,'2026_02_02_090000_create_ec_order_product_tax_components_table',8),(238,'2026_02_02_090001_create_ec_invoice_item_tax_components_table',8),(239,'2026_02_02_090002_add_tax_class_to_ec_customers_table',8),(240,'2026_02_02_090003_add_tax_class_to_ec_products_table',8),(241,'2026_02_02_090004_add_tax_breakdown_to_ec_order_product_table',8),(242,'2026_02_03_090000_drop_foreign_key_from_ec_order_product_tax_components_table',8),(243,'2026_02_07_090000_remove_duplicate_product_variation_records',8),(244,'2018_07_09_221238_create_faq_table',9),(245,'2021_12_03_082134_create_faq_translations',9),(246,'2023_11_17_063408_add_description_column_to_faq_categories_table',9),(247,'2024_12_01_000000_add_indexes_to_faq_translations_tables',9),(248,'2016_10_13_150201_create_galleries_table',10),(249,'2021_12_03_082953_create_gallery_translations',10),(250,'2022_04_30_034048_create_gallery_meta_translations_table',10),(251,'2023_08_29_075308_make_column_user_id_nullable',10),(252,'2024_12_01_000000_add_indexes_to_gallery_translations_tables',10),(253,'2016_10_03_032336_create_languages_table',11),(254,'2023_09_14_022423_add_index_for_language_table',11),(255,'2021_10_25_021023_fix-priority-load-for-language-advanced',12),(256,'2021_12_03_075608_create_page_translations',12),(257,'2023_07_06_011444_create_slug_translations_table',12),(258,'2024_12_01_000000_add_indexes_to_slugs_translations_table',12),(259,'2019_11_18_061011_create_country_table',13),(260,'2021_12_03_084118_create_location_translations',13),(261,'2021_12_03_094518_migrate_old_location_data',13),(262,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',13),(263,'2022_01_16_085908_improve_plugin_location',13),(264,'2022_08_04_052122_delete_location_backup_tables',13),(265,'2023_04_23_061847_increase_state_translations_abbreviation_column',13),(266,'2023_07_26_041451_add_more_columns_to_location_table',13),(267,'2023_07_27_041451_add_more_columns_to_location_translation_table',13),(268,'2023_08_15_073307_drop_unique_in_states_cities_translations',13),(269,'2023_10_21_065016_make_state_id_in_table_cities_nullable',13),(270,'2024_08_17_094600_add_image_into_countries',13),(271,'2025_01_08_093652_add_zip_code_to_cities',13),(272,'2025_07_31_083459_add_indexes_for_location_search_performance',13),(273,'2017_10_24_154832_create_newsletter_table',14),(274,'2024_03_25_000001_update_captcha_settings_for_newsletter',14),(275,'2017_05_18_080441_create_payment_tables',15),(276,'2021_03_27_144913_add_customer_type_into_table_payments',15),(277,'2021_05_24_034720_make_column_currency_nullable',15),(278,'2021_08_09_161302_add_metadata_column_to_payments_table',15),(279,'2021_10_19_020859_update_metadata_field',15),(280,'2022_06_28_151901_activate_paypal_stripe_plugin',15),(281,'2022_07_07_153354_update_charge_id_in_table_payments',15),(282,'2024_07_04_083133_create_payment_logs_table',15),(283,'2025_04_12_000003_add_payment_fee_to_payments_table',15),(284,'2025_05_22_000001_add_payment_fee_type_to_settings_table',15),(285,'2017_07_11_140018_create_simple_slider_table',16),(286,'2026_01_10_000001_add_status_to_simple_slider_items_table',16),(287,'2025_04_08_040931_create_social_logins_table',17),(288,'2022_11_02_092723_team_create_team_table',18),(289,'2023_08_11_094574_update_team_table',18),(290,'2023_11_30_085354_add_missing_description_to_team',18),(291,'2024_10_02_030027_add_more_columns_to_teams_translations_table',18),(292,'2018_07_09_214610_create_testimonial_table',19),(293,'2021_12_03_083642_create_testimonials_translations',19),(294,'2016_10_07_193005_create_translations_table',20),(295,'2023_12_12_105220_drop_translations_table',20);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Wooden Home','[simple-slider key=\"slider-home-1\" style=\"wooden\" ads_1=\"IYHICPADQD5X\" ads_2=\"R4YAV9FECJUS\"][/simple-slider][product-categories title=&quot;Top &lt;span&gt;Categories&lt;/span&gt;&quot; category_ids=&quot;10,11,12,13,14,15&quot; style=&quot;wooden&quot; enable_lazy_loading=&quot;yes&quot;][/product-categories][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][deal-product flash_sale_id=\"1\" style=\"wooden\" enable_lazy_loading=\"yes\"][/deal-product][gallery title=\"ninico-shop\" limit=\"6\" subtitle=\"Follow On\" enable_lazy_loading=\"yes\"][/gallery]',1,NULL,'full-width',NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(2,'Fashion Home','[simple-slider key=\"slider-home-2\" style=\"fashion\"][/simple-slider][product-categories title=&quot;Top &lt;span&gt;Categories&lt;/span&gt;&quot; category_ids=&quot;1,2,3,4&quot; style=&quot;fashion&quot; enable_lazy_loading=&quot;yes&quot;][/product-categories][products style=&quot;fashion&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][theme-ads key_1=\"QPTCBJBOJOSY\" key_2=\"T2VFLDYYIJEH\" enable_lazy_loading=\"yes\"][/theme-ads][featured-posts title=\"Popular Posts\" limit=\"4\" enable_lazy_loading=\"yes\"][/featured-posts][brands title=\"Happy Sponsors\" quantity=\"6\" name_1=\"Bustle\" image_1=\"brands/brand-01.png\" link_1=\"#\" name_2=\"Bazaar\" image_2=\"brands/brand-02.png\" link_2=\"#\" name_3=\"goop\" image_3=\"brands/brand-03.png\" link_3=\"#\" name_4=\"Brit + Co\" image_4=\"brands/brand-04.png\" link_4=\"#\" name_5=\"The Coveteur\" image_5=\"brands/brand-05.png\" link_5=\"#\" name_6=\"allure\" image_6=\"brands/brand-06.png\" link_6=\"#\" enable_lazy_loading=\"yes\"][/brands]',1,NULL,'full-width',NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(3,'Furniture Home','[simple-slider key=\"slider-furniture\" style=\"furniture\"][/simple-slider][services quantity=\"4\" title_1=\"Free shipping\" description_1=\"Free shipping on orders over.\" image_1=\"icons/box.png\" title_2=\"Free Returns\" description_2=\"30-days free return policy\" image_2=\"icons/car.png\" title_3=\"Secured Payments\" description_3=\"We accept all major credit cards\" image_3=\"icons/payment.png\" title_4=\"Customer Service\" description_4=\"Top notch customer service\" image_4=\"icons/hours.png\" enable_lazy_loading=\"yes\"][/services][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][theme-ads style=\"furniture\" key_1=\"JO7LLJHFH1RO\" key_2=\"L8GDJUBVD2TQ\" key_3=\"PXJPAXLOCVRS\" enable_lazy_loading=\"yes\"][/theme-ads][deal-product flash_sale_id=\"1\" enable_lazy_loading=\"yes\"][/deal-product][products-slide title=\"Top Sell In Month\" limit=\"5\" type=\"trending\" enable_lazy_loading=\"yes\"][/products-slide][brands title=\"Happy Sponsors\" background_color=\"#040404\" quantity=\"6\" name_1=\"Bustle\" image_1=\"brands/brand-w-01.png\" link_1=\"https://www.bustle.com\" name_2=\"Bazaar\" image_2=\"brands/brand-w-02.png\" link_2=\"https://www.harpersbazaar.com\" name_3=\"Goop\" image_3=\"brands/brand-w-03.png\" link_3=\"https://goop.com/\" name_4=\"Brit + Co\" image_4=\"brands/brand-w-04.png\" link_4=\"https://www.brit.co\" name_5=\"The Couture Club\" image_5=\"brands/brand-w-05.png\" link_5=\"https://www.thecoutureclub.com\" name_6=\"Allure\" image_6=\"brands/brand-w-06.png\" link_6=\"https://www.allure.com\" enable_lazy_loading=\"yes\"][/brands][featured-posts title=\"Blog & Insights\" limit=\"4\" type=\"popular\" url=\"/blog\" enable_lazy_loading=\"yes\"][/featured-posts]',1,NULL,'full-width',NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(4,'Cosmetics Home','[simple-slider key=\"slider-cosmetics\" style=\"cosmetics\"][/simple-slider][brands background_color=\"#F7EFEC\" quantity=\"6\" name_1=\"Bustle\" image_1=\"brands/pla-brand-01.png\" link_1=\"https://www.bustle.com\" name_2=\"Bazaar\" image_2=\"brands/pla-brand-02.png\" link_2=\"https://www.harpersbazaar.com\" name_3=\"Goop\" image_3=\"brands/pla-brand-03.png\" link_3=\"https://goop.com/\" name_4=\"Brit + Co\" image_4=\"brands/pla-brand-04.png\" link_4=\"https://www.brit.co\" name_5=\"The Couture Club\" image_5=\"brands/pla-brand-05.png\" link_5=\"https://www.thecoutureclub.com\" name_6=\"Allure\" image_6=\"brands/pla-brand-06.png\" link_6=\"https://www.allure.com\" enable_lazy_loading=\"yes\"][/brands][product-collections collection_ids=\"4,5,6,7\" enable_lazy_loading=\"yes\"][/product-collections][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;4&quot; enable_lazy_loading=&quot;yes&quot;][/products][product-categories category_ids=\"10,11,12,13,14,15\" style=\"cosmetics\" enable_lazy_loading=\"yes\"][/product-categories][deal-product flash_sale_id=\"1\" style=\"cosmetics\" marque_text=\"Great Deal Of The Day Shop Now\" marque_highlight_text=\"Shop Now\" marque_highlight_url=\"/products\" highlight_background=\"blog/9.jpg\" enable_lazy_loading=\"yes\"][/deal-product][testimonials title=\"User Feedbacks\" limit=\"3\" enable_lazy_loading=\"yes\"][/testimonials][featured-posts title=\"Blog & Insights\" limit=\"4\" type=\"popular\" url=\"/blog\" enable_lazy_loading=\"yes\"][/featured-posts]',1,NULL,'full-width',NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(5,'Food Grocery Home','[simple-slider key=\"slider-grocery\" style=\"grocery\" ads_1=\"EMRCINED6AX9\" ads_2=\"JVMDAIB9HO2I\" background_image=\"banners/banner-bg-05.jpg\"][/simple-slider][services quantity=\"4\" title_1=\"Free shipping\" description_1=\"Free shipping on orders over.\" image_1=\"icons/box.png\" title_2=\"Free Returns\" description_2=\"30-days free return policy\" image_2=\"icons/car.png\" title_3=\"Secured Payments\" description_3=\"We accept all major credit cards\" image_3=\"icons/payment.png\" title_4=\"Customer Service\" description_4=\"Top notch customer service\" image_4=\"icons/hours.png\" enable_lazy_loading=\"yes\"][/services][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][deal-product flash_sale_id=\"1\" style=\"cosmetics\" enable_lazy_loading=\"yes\"][/deal-product][products-by-categories category_ids=\"2,3,6,11\" number_of_products=\"4\" enable_lazy_loading=\"yes\"][/products-by-categories][testimonials title=\"User Feedbacks\" limit=\"3\" background_color=\"#F7EFEC\" card_color=\"#FFFFFF\" enable_lazy_loading=\"yes\"][/testimonials][featured-posts title=\"Blog & Insights\" limit=\"4\" url=\"/blog\" enable_lazy_loading=\"yes\"][/featured-posts]',1,NULL,'full-width',NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(6,'Blog',NULL,1,NULL,NULL,NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(7,'About','[about image_1=\"banners/about-img-1.jpg\" image_2=\"banners/about-img-2.jpg\" logo=\"banners/about-img-3.png\" title=\"About Our Story\" subtitle=\"About Us\" story_text_1=\"Publish your eCommerce site quickly with our easy-to-use store builder— no coding required. Migrate your items from your point of sale system or turn your Instagram feed into a shopping site and start selling fast. Square Online works for all kinds of businesses—retail, restaurants, services without costly customization or add ons. Get orders to your customers in lots of ways by offering shipping, pickup, delivery, and even QR code ordering.\" story_text_2=\"Expand your reach and sell more using seamless integrations with Google, Instagram, Facebook, and more. Built- in SEO tools make it easy for shoppers to find your business on search engines. Get access to the entire suite of integrated Square solutions to help you run your business. Integration between Square Online and all Square point of sale systems makes inventory management easy. Subscribe to Square Marketing and easily send email promotions to your customers using the contact information.\" list_item_1=\"Orders go right to your restaurant point of sale, KDS, and kitchen\" list_item_url_1=\"#\" list_item_2=\"Provide in-person pickup, & delivery by professional couriers\" list_item_url_2=\"#\" list_item_3=\"Offer in-person diners self-serve, contactless ordering via QR codes.\" list_item_url_3=\"#\" enable_lazy_loading=\"yes\"][/about][team title=\"Meet With Team\" subtitle=\"Team\" team_ids=\"1,2,3,4\"][/team][features quantity=\"2\" title_1=\"Solutions that work together\" subtitle_1=\"Features #01\" description_1=\"Publish your eCommerce site quickly with our easy-to-use store builder— no coding required. Migrate your items from your point of sale system or turn your Instagram feed into a shopping site and start selling fast. Square Online works for all kinds of businesses—retail, restaurants, services.\" image_1=\"banners/about-banner-1.jpg\" button_label_1=\"Get In Touch\" button_url_1=\"#\" title_2=\"All kinds of payments securely\" subtitle_2=\"Features #02\" description_2=\"Publish your eCommerce site quickly with our easy-to-use store builder— no coding required. Migrate your items from your point of sale system or turn your Instagram feed into a shopping site and start selling fast. Square Online works for all kinds of businesses—retail, restaurants, services.\" image_2=\"banners/about-banner-2.jpg\" button_label_2=\"Contact With Us\" button_url_2=\"#\" enable_lazy_loading=\"yes\"][/features]',1,NULL,'default',NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(8,'Contact','[contact-box title=\"Get In Touch\" address=\"24/26 Strait Bargate, Boston, PE21, United Kingdom\" phone=\" +098 (905) 786 897 8\" email=\"ninico@example.com\" hours=\"10 am - 10 pm EST, 7 days a week\" show_contact_form=\"1\" button_label_1=\"Get Support On Call\" button_url_1=\"#\" button_icon_1=\"fa fa-headphones-alt\" button_label_2=\"Get Direction\" button_url_2=\"#\" button_icon_2=\"fa fa-map-marker-alt\"][/contact-box][google-map]24/26 Strait Bargate, Boston, PE21, United Kingdom[/google-map]',1,NULL,NULL,NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(9,'Coming soon','[coming-soon title=\"We are Coming Soon\" subtitle=\"Coming Soon!\" time=\"2025-10-24\" background_image=\"banners/coming-soon.jpg\" logo_style=\"general/logo-white.png\" show_subscribe_form=\"1\"][/coming-soon]',1,NULL,'blank',NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(10,'Store Locator','[shop-location quantity=\"4\" name_1=\"Baldwin Hills Crenshaw Plaza\" address_1=\"24/26 Strait Bargate, Boston, PE21, United Kingdom\" phone_1=\"+098 (905) 786 897 8\" hours_1=\"10 am - 10 pm EST, 7 days a week\" image_1=\"shop/location-1.png\" name_2=\"Ninico Hills Crenshaw Plaza\" address_2=\" 36/26 Strait Bargate, Boston, PE21, United Kingdom\" phone_2=\"+098 112 786 897 8\" hours_2=\"9 am - 10 pm EST, 5 days a week\" image_2=\"shop/location-2.png\" name_3=\"Vegas BGM Crenshaw Plaza\" address_3=\"40/26 Strait Bargate, Vegas, PE21, United Kingdom\" phone_3=\" +098 (905) 786 897 8\" hours_3=\"10 am - 10 pm EST, 7 days a week\" image_3=\"shop/location-3.png\" name_4=\"Bargate Cine Crenshaw Plaza\" address_4=\"38/26 Strait Bargate, Point, PE21, United Kingdom\" phone_4=\"6 - 146 - 389 - 5748\" hours_4=\"10 am - 10 pm EST, 7 days a week\" image_4=\"shop/location-4.png\" enable_lazy_loading=\"yes\"][/shop-location][google-map]New York, USA[/google-map]',1,NULL,NULL,NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39'),(11,'FAQs','[faqs category_ids=\"1,2,3\"][/faqs]',1,NULL,NULL,NULL,'published','2026-02-09 00:18:39','2026-02-09 00:18:39');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (2,1),(4,1),(3,2),(4,2),(1,3),(2,3),(3,4),(2,5),(1,5),(3,6),(2,6),(4,7),(1,8),(4,8),(4,9),(1,9),(2,10),(3,10),(3,11),(4,11);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (5,1),(3,1),(4,2),(2,2),(2,3),(4,3),(4,4),(1,4),(5,4),(2,5),(3,5),(1,5),(4,6),(5,6),(3,6),(4,7),(5,7),(3,8),(1,8),(4,9),(3,9),(1,10),(5,10),(4,10),(3,11),(2,11);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','Discover the latest insights, trends, and expert analysis in this comprehensive article that covers key aspects of the topic.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/blog/blog-in-01.jpg\" /></p>\n\n<p><br />\n    &nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/blog/blog-in-02.jpg\" /></p>\n\n<p><br />\n    &nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/blog/blog-in-03.jpg\" /></p>\n\n<p><br />\n    &nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" src=\"/storage/blog/blog-in-04.jpg\" /></p>\n\n<p><br />\n    &nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" src=\"/storage/blog/blog-in-05.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'blog/1.jpg',995,NULL,'2026-02-09 00:18:37','2026-02-09 00:18:37'),(2,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','Discover the latest insights, trends, and expert analysis in this comprehensive article that covers key aspects of the topic.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.<