<?php

return [
    'name' => 'Nyhetsbrev',
    'newsletter_form' => 'Nyhetsbrevformulär',
    'description' => 'Visa och ta bort nyhetsbrevprenumeranter',
    'settings' => [
        'email' => [
            'templates' => [
                'title' => 'Nyhetsbrev',
                'description' => 'Konfigurera e-postmallar för nyhetsbrev',
                'to_admin' => [
                    'title' => 'E-post skickat till administratör',
                    'description' => 'Mall för att skicka e-post till administratör',
                    'subject' => 'Ny användare har prenumererat på ditt nyhetsbrev',
                    'newsletter_email' => 'E-post för användare som prenumererar på nyhetsbrev',
                ],
                'to_user' => [
                    'title' => 'E-post skickat till användare',
                    'description' => 'Mall för att skicka e-post till prenumerant',
                    'subject' => '{{ site_title }}: Prenumeration bekräftad!',
                    'newsletter_name' => 'Fullständigt namn på användare som prenumererar på nyhetsbrev',
                    'newsletter_email' => 'E-post för användare som prenumererar på nyhetsbrev',
                    'newsletter_unsubscribe_link' => 'Länk för att avsluta prenumeration på nyhetsbrev',
                    'newsletter_unsubscribe_url' => 'URL för att avsluta prenumeration på nyhetsbrev',
                ],
            ],
        ],
        'title' => 'Nyhetsbrev',
        'panel_description' => 'Visa och uppdatera nyhetsbrevsinställningar',
        'description' => 'Inställningar för nyhetsbrev (automatisk sändning av nyhetsbrev via e-post till SendGrid, Mailchimp... när någon registrerar sig för nyhetsbrev på webbplatsen).',
        'mailchimp_api_key' => 'Mailchimp API-nyckel',
        'mailchimp_api_key_helper' => 'Ange din Mailchimp API-nyckel för att automatiskt synkronisera nyhetsbrevsprenumeranter. Hämta din API-nyckel från Mailchimp: Konto → Extra → API-nycklar → Skapa en nyckel.',
        'mailchimp_api_key_instruction' => 'För att få din API-nyckel: Logga in på Mailchimp → Klicka på ditt profilnamn → Konto → Extra → API-nycklar → Skapa en nyckel. <a href="https://mailchimp.com/help/about-api-keys/" target="_blank" rel="noopener">Läs mer</a>',
        'mailchimp_list_id' => 'Mailchimp list-ID',
        'mailchimp_list_id_helper' => 'Ange ditt Mailchimp Audience (List) ID där prenumeranter kommer att läggas till.',
        'mailchimp_list' => 'Mailchimp-lista',
        'mailchimp_list_helper' => 'Välj Mailchimp-publiklistan där nya prenumeranter automatiskt läggs till.',
        'sendgrid_api_key' => 'Sendgrid API-nyckel',
        'sendgrid_api_key_helper' => 'Ange din SendGrid API-nyckel för att automatiskt synkronisera nyhetsbrevsprenumeranter. API-nyckeln måste ha "Marketing"-behörigheter aktiverade.',
        'sendgrid_api_key_instruction' => 'För att skapa en API-nyckel: Logga in på SendGrid → Inställningar → API-nycklar → Skapa API-nyckel → Välj "Begränsad åtkomst" → Aktivera "Marketing"-behörigheter. <a href="https://docs.sendgrid.com/ui/account-and-settings/api-keys" target="_blank" rel="noopener">Läs mer</a>',
        'sendgrid_list_id' => 'Sendgrid list-ID',
        'sendgrid_list_id_helper' => 'Ange ditt SendGrid kontaktliste-ID där prenumeranter kommer att läggas till.',
        'sendgrid_list' => 'Sendgrid-lista',
        'sendgrid_list_helper' => 'Välj SendGrid-kontaktlistan där nya prenumeranter automatiskt läggs till.',
        'enable_newsletter_contacts_list_api' => 'Aktivera API för nyhetsbrevskontaktlista?',
        'enable_newsletter_contacts_list_api_helper' => 'När aktiverad kommer nya nyhetsbrevsprenumeranter automatiskt att synkroniseras med din e-postmarknadsföringstjänst (Mailchimp eller SendGrid). Detta gör att du kan hantera och skicka kampanjer via din föredragna plattform.',
    ],
    'statuses' => [
        'subscribed' => 'Prenumererad',
        'unsubscribed' => 'Avprenumererad',
    ],
    'email_templates' => [
        // Admin email template
        'admin_new_subscriber_title' => 'Ny prenumerant',
        'admin_new_subscriber_message' => 'Ny användare har prenumererat på ditt nyhetsbrev:',

        // Subscriber email template
        'subscriber_success_title' => 'Prenumeration lyckades',
        'subscriber_thank_you_message' => 'Tack för att du prenumererar på vårt nyhetsbrev!',
        'subscriber_unsubscribe_instruction' => 'För att avsluta prenumeration på nyhetsbrev, klicka på :newsletter_unsubscribe_link',
    ],

    'enter_your_email' => 'Ange din e-post',
    'subscribe' => 'Prenumerera',
    'newsletter_popup' => 'Nyhetsbrev Popup',
    'enable_newsletter_popup' => 'Aktivera popup för nyhetsbrev',
    'popup_image' => 'Desktop Image',
    'popup_image_helper' => 'For devices with width from 1200px and above.',
    'popup_tablet_image' => 'Tablet Image',
    'popup_tablet_image_helper' => 'For devices with width from 768px to 1199px. If empty, will use the desktop image.',
    'popup_mobile_image' => 'Mobile Image',
    'popup_mobile_image_helper' => 'For devices with width less than 768px. If empty, will use the tablet image.',
    'popup_title' => 'Popup-titel',
    'popup_subtitle' => 'Popup-undertext',
    'popup_description' => 'Popup-beskrivning',
    'popup_delay_seconds' => 'Popup-fördröjning (sekunder)',
    'popup_delay_helper' => 'Fördröjningstiden innan nyhetsbrevets popup visas efter att sidan har laddats. ',
    'display_on_pages' => 'Visas på sidorna',
    'homepage' => 'Hemsida',
    'all_pages' => 'Alla sidor',
    'subscribe_success' => 'Prenumerera på nyhetsbrevet framgångsrikt!',
    'unsubscribe_success' => 'Avsluta prenumerationen på nyhetsbrevet framgångsrikt',
    'email_not_exist_or_unsubscribed' => 'Din e-post finns inte i systemet eller så har du redan avslutat prenumerationen!',
    'email_address' => 'E-postadress',
    'dont_show_popup_again' => 'Visa inte denna popup igen',
    'here' => 'här',
];
