<?php

return [
    'name' => 'Локації',
    'all_states' => 'Усі області',
    'abbreviation' => 'Скорочення',
    'abbreviation_placeholder' => 'Напр.: CA',
    'enums' => [
        'import_type' => [
            'country' => 'Країна',
            'state' => 'Область',
            'city' => 'Місто',
        ],
    ],
    'export' => [
        'total' => 'Всього локацій',
        'total_countries' => 'Всього країн',
        'total_states' => 'Всього областей',
        'total_cities' => 'Всього міст',
        'description' => 'Експортуйте дані про локації, такі як країни, області та міста.',
        'import_type' => 'Тип імпорту',
        'all_types' => 'Всі типи',
        'all_status' => 'Всі статуси',
        'use_chunked_export' => 'Використовувати сегментований експорт',
        'use_chunked_export_helper' => 'Обробляє дані частинами для великих експортних файлів. Рекомендується для наборів даних, що перевищують 1 000 записів.',
        'optimize_memory' => 'Оптимізувати використання пам\'яті',
        'optimize_memory_helper' => 'Зменшує використання пам\'яті за допомогою покрокової обробки. Рекомендується для обмеженої пам\'яті сервера.',
        'use_streaming' => 'Використовувати потокову передачу',
        'use_streaming_helper' => 'Записує дані безпосередньо в файл замість зберігання в пам\'яті. Найкраще для дуже великих експортів.',
        'streaming_enabled_title' => 'Потокова передача увімкнена',
        'streaming_enabled_message' => 'Дані будуть передаватися безпосередньо в файл для оптимальної ефективності.',
        'chunk_size' => 'Розмір частини',
        'chunk_size_helper' => 'Кількість рядків, що обробляються за один раз. Менші значення використовують менше пам\'яті, але можуть уповільнити експорт.',
        'recommended_range' => 'Рекомендований діапазон',
        'optimal_range' => 'Оптимальний діапазон',
        'too_small_slow' => 'Занадто малі значення можуть уповільнити обробку',
        'too_large_timeouts' => 'Занадто великі значення можуть викликати тайм-аути',
        'range_large_export' => '500-2000 для великих експортів',
        'range_medium_export' => '200-1000 для середніх експортів',
        'range_small_export' => '100-500 для малих експортів',
        'large_dataset_title' => 'Виявлено великий набір даних',
        'large_dataset_message' => 'Через розмір ваших даних експорт може зайняти деякий час. Це нормальний процес і забезпечує стабільність.',
        'large_dataset_warning_title' => 'Великий експорт',
        'large_dataset_specific_message' => 'Ви експортуєте більше :count записів. Ця операція може зайняти кілька хвилин.',
        'format_label' => 'Формат',
        'csv_recommended' => 'CSV (рекомендовано для великих наборів даних)',
        'chunk_label' => 'Розмір частини',
        'chunk_recommended' => ':size рядків (рекомендовано)',
        'time_label' => 'Приблизний час',
        'time_estimate' => '~:minutes хвилин',
        'pro_tip' => 'Професійна порада',
        'pro_tip_message' => 'Формат CSV пропонує кращу продуктивність і сумісність для великих експортів. Ви можете імпортувати його в Excel або Google Sheets.',
        'medium_dataset_detected' => 'Виявлено середній набір даних',
        'medium_dataset_message' => 'Цей експорт може зайняти кілька секунд. Для оптимальної продуктивності ми рекомендуємо налаштування сегментованого експорту.',
        'excel_disabled_warning' => 'Excel експорт недоступний для наборів даних, що перевищують :count записів. Будь ласка, використовуйте формат CSV.',
    ],
    'import' => [
        'description' => 'Легко імпортуйте дані про локації з наявних даних або завантажуючи файл CSV/Excel.',
        'rules' => [
            'name' => 'Назва локації є обов\'язковою і не повинна перевищувати 120 символів.',
            'slug' => 'ЧПУ локації, якщо надається, не повинна перевищувати 120 символів.',
            'import_type' => 'Тип імпорту є обов\'язковим і повинен бути одним з попередньо визначених значень.',
            'order' => 'Порядок локації, якщо надається, повинен бути додатним цілим числом від 0 до 127.',
            'abbreviation' => 'Скорочення локації, якщо надається, не повинно перевищувати 10 символів.',
            'status' => 'Статус локації є обов\'язковим і повинен бути одним з попередньо визначених значень.',
            'country' => 'Поле країни є обов\'язковим, якщо тип імпорту є область або місто.',
            'state' => 'Поле області є обов\'язковим, якщо тип імпорту є місто.',
            'nationality' => 'Національність локації, якщо надається, не повинна перевищувати 120 символів.',
        ],
    ],
];
