<?php

return [
    'name' => 'Lokasi',
    'all_states' => 'Semua negara bagian',
    'slug' => 'Slug',
    'abbreviation' => 'Singkatan',
    'abbreviation_placeholder' => 'Contoh: CA',
    'import_type' => [
        'country' => 'Negara',
        'state' => 'Negara Bagian',
        'city' => 'Kota',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Negara',
            'state' => 'Negara Bagian',
            'city' => 'Kota',
        ],
    ],
    'export' => [
        'total' => 'Total Lokasi',
        'total_countries' => 'Total Negara',
        'total_states' => 'Total Negara Bagian',
        'total_cities' => 'Total Kota',
        'description' => 'Ekspor data lokasi Anda seperti negara, negara bagian, dan kota.',
        'import_type' => 'Jenis Lokasi',
        'all_types' => 'Semua jenis',
        'all_status' => 'Semua status',
        'use_chunked_export' => 'Gunakan ekspor terbagi',
        'use_chunked_export_helper' => 'Proses data dalam batch yang lebih kecil untuk menghindari masalah memori dengan dataset besar.',
        'optimize_memory' => 'Optimalkan penggunaan memori',
        'optimize_memory_helper' => 'Muat hanya kolom yang diperlukan dan bebaskan memori secara berkala selama ekspor.',
        'use_streaming' => 'Gunakan mode streaming',
        'use_streaming_helper' => 'Streaming data langsung ke file tanpa memuat semuanya ke memori. Direkomendasikan untuk dataset yang sangat besar.',
        'streaming_enabled_title' => 'Mode streaming diaktifkan',
        'streaming_enabled_message' => 'Data akan di-streaming langsung ke file untuk penggunaan memori yang optimal.',
        'chunk_size' => 'Ukuran batch',
        'chunk_size_helper' => 'Jumlah record yang akan diproses di setiap batch. Nilai yang lebih rendah menggunakan memori lebih sedikit tetapi memakan waktu lebih lama.',
        'recommended_range' => 'Rentang yang direkomendasikan',
        'optimal_range' => 'Optimal',
        'too_small_slow' => 'Terlalu kecil (lebih lambat)',
        'too_large_timeouts' => 'Terlalu besar (mungkin timeout)',
        'range_large_export' => '150-300 record',
        'range_medium_export' => '200-500 record',
        'range_small_export' => '300-700 record',
        'large_dataset_title' => 'Dataset besar terdeteksi',
        'large_dataset_message' => 'Mode ekspor yang dioptimalkan diaktifkan secara otomatis untuk performa yang lebih baik.',
        'large_dataset_warning_title' => 'Rekomendasi Ekspor Dataset Besar',
        'large_dataset_specific_message' => 'Anda mengekspor :count lokasi. Untuk performa optimal, kami merekomendasikan menggunakan format CSV dengan ekspor terbagi.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Direkomendasikan)',
        'chunk_label' => 'Ukuran Batch',
        'chunk_recommended' => '150-300 record',
        'time_label' => 'Estimasi Waktu',
        'time_estimate' => '2-5 menit',
        'pro_tip' => 'Tips Pro:',
        'pro_tip_message' => 'Anda dapat memfilter berdasarkan jenis lokasi (negara/negara bagian/kota) untuk mengekspor data spesifik.',
        'medium_dataset_detected' => 'Dataset sedang terdeteksi',
        'medium_dataset_message' => 'Mengekspor :count lokasi. Ekspor seharusnya selesai dalam 1-2 menit.',
        'excel_disabled_warning' => 'Format Excel tidak direkomendasikan untuk dataset besar (:count+ record). Gunakan CSV sebagai gantinya.',
    ],
    'import' => [
        'description' => 'Impor data lokasi dengan mudah dari data yang tersedia atau dengan mengunggah file CSV/Excel.',
        'rules' => [
            'name' => 'Nama lokasi wajib diisi dan tidak boleh melebihi 120 karakter.',
            'slug' => 'Slug lokasi, jika disediakan, tidak boleh melebihi 120 karakter.',
            'import_type' => 'Jenis impor wajib diisi dan harus salah satu dari nilai yang telah ditentukan.',
            'order' => 'Urutan lokasi, jika disediakan, harus berupa bilangan bulat positif antara 0 dan 127.',
            'abbreviation' => 'Singkatan lokasi, jika disediakan, tidak boleh melebihi 10 karakter.',
            'status' => 'Status lokasi wajib diisi dan harus salah satu dari nilai yang telah ditentukan.',
            'country' => 'Bidang negara wajib diisi jika jenis impor adalah negara bagian atau kota.',
            'state' => 'Bidang negara bagian wajib diisi jika jenis impor adalah kota.',
            'nationality' => 'Kewarganegaraan lokasi, jika disediakan, tidak boleh melebihi 120 karakter.',
        ],
    ],
];
