<?php

return [
    'name' => 'Emplacements',
    'all_states' => 'Tous les états',
    'abbreviation' => 'Abréviation',
    'abbreviation_placeholder' => 'Par exemple : CA',
    'import_type' => [
        'country' => 'Pays',
        'state' => 'État',
        'city' => 'Ville',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Pays',
            'state' => 'État',
            'city' => 'Ville',
        ],
    ],
    'export' => [
        'total' => 'Nombre total d\'emplacements',
        'total_countries' => 'Total des pays',
        'total_states' => 'Total des États',
        'total_cities' => 'Total des villes',
        'description' => 'Exportez vos données de localisation telles que les pays, les États et les villes.',
        'import_type' => 'Type d\'emplacement',
        'all_types' => 'Tous les types',
        'all_status' => 'Tous les statuts',
        'use_chunked_export' => 'Utiliser l\'exportation fragmentée',
        'use_chunked_export_helper' => 'Traiter les données par petits lots pour éviter les problèmes de mémoire avec de grands ensembles de données.',
        'optimize_memory' => 'Optimiser l\'utilisation de la mémoire',
        'optimize_memory_helper' => 'Charger uniquement les colonnes nécessaires et libérer périodiquement la mémoire pendant l\'exportation.',
        'use_streaming' => 'Utiliser le mode streaming',
        'use_streaming_helper' => 'Diffuser les données directement dans le fichier sans tout charger en mémoire. Recommandé pour les très grands ensembles de données.',
        'streaming_enabled_title' => 'Mode streaming activé',
        'streaming_enabled_message' => 'Les données seront diffusées directement dans le fichier pour une utilisation optimale de la mémoire.',
        'chunk_size' => 'Taille du fragment',
        'chunk_size_helper' => 'Nombre d\'enregistrements à traiter dans chaque lot. Des valeurs plus faibles utilisent moins de mémoire mais prennent plus de temps.',
        'recommended_range' => 'Plage recommandée',
        'optimal_range' => 'Optimal',
        'too_small_slow' => 'Trop petit (plus lent)',
        'too_large_timeouts' => 'Trop grand (peut expirer)',
        'range_large_export' => '150-300 enregistrements',
        'range_medium_export' => '200-500 enregistrements',
        'range_small_export' => '300-700 enregistrements',
        'large_dataset_title' => 'Grand ensemble de données détecté',
        'large_dataset_message' => 'Le mode d\'exportation optimisé a été activé automatiquement pour de meilleures performances.',
        'large_dataset_warning_title' => 'Recommandations d\'exportation de grand ensemble de données',
        'large_dataset_specific_message' => 'Vous exportez :count emplacements. Pour des performances optimales, nous recommandons d\'utiliser le format CSV avec une exportation fragmentée.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Recommandé)',
        'chunk_label' => 'Taille du fragment',
        'chunk_recommended' => '150-300 enregistrements',
        'time_label' => 'Temps estimé',
        'time_estimate' => '2-5 minutes',
        'pro_tip' => 'Astuce pro :',
        'pro_tip_message' => 'Vous pouvez filtrer par type d\'emplacement (pays/état/ville) pour exporter des données spécifiques.',
        'medium_dataset_detected' => 'Ensemble de données moyen détecté',
        'medium_dataset_message' => 'Exportation de :count emplacements. L\'exportation devrait se terminer dans 1-2 minutes.',
        'excel_disabled_warning' => 'Le format Excel n\'est pas recommandé pour les grands ensembles de données (:count+ enregistrements). Utilisez plutôt CSV.',
    ],
    'import' => [
        'description' => 'Importez facilement des données de localisation à partir des données disponibles ou en téléchargeant un fichier CSV/Excel.',
        'rules' => [
            'name' => 'Le nom du lieu est obligatoire et ne doit pas dépasser 120 caractères.',
            'slug' => 'Le slug de l\'emplacement, s\'il est fourni, ne doit pas dépasser 120 caractères.',
            'import_type' => 'Le type d\'import est obligatoire et doit faire partie des valeurs prédéfinies.',
            'order' => 'L\'ordre de localisation, s\'il est fourni, doit être un entier positif compris entre 0 et 127.',
            'abbreviation' => 'L\'abréviation du lieu, si elle est fournie, ne doit pas dépasser 10 caractères.',
            'status' => 'Le statut de l\'emplacement est obligatoire et doit faire partie des valeurs prédéfinies.',
            'country' => 'Le champ Pays est obligatoire si le type d\'importation est un État ou une ville.',
            'state' => 'Le champ état est obligatoire si le type d\'import est ville.',
            'nationality' => 'La nationalité du lieu, si elle est fournie, ne doit pas dépasser 120 caractères.',
        ],
    ],
    'slug' => 'Slug',
];
