<?php

return [
    'name' => 'Ubicaciones',
    'all_states' => 'Todos los Estados',
    'abbreviation' => 'Abreviatura',
    'abbreviation_placeholder' => 'Por ejemplo: CA',
    'import_type' => [
        'country' => 'País',
        'state' => 'Estado',
        'city' => 'Ciudad',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'País',
            'state' => 'Estado',
            'city' => 'Ciudad',
        ],
    ],
    'export' => [
        'total' => 'Ubicaciones totales',
        'total_countries' => 'Países totales',
        'total_states' => 'Estados totales',
        'total_cities' => 'Ciudades totales',
        'description' => 'Exporte sus datos de ubicación como países, estados y ciudades.',
        'import_type' => 'Tipo de ubicación',
        'all_types' => 'Todos los tipos',
        'all_status' => 'Todos los estados',
        'use_chunked_export' => 'Usar exportación fragmentada',
        'use_chunked_export_helper' => 'Procesar datos en lotes más pequeños para evitar problemas de memoria con conjuntos de datos grandes.',
        'optimize_memory' => 'Optimizar uso de memoria',
        'optimize_memory_helper' => 'Cargar solo las columnas necesarias y liberar memoria periódicamente durante la exportación.',
        'use_streaming' => 'Usar modo de transmisión',
        'use_streaming_helper' => 'Transmitir datos directamente al archivo sin cargar todo en la memoria. Recomendado para conjuntos de datos muy grandes.',
        'streaming_enabled_title' => 'Modo de transmisión activado',
        'streaming_enabled_message' => 'Los datos se transmitirán directamente al archivo para un uso óptimo de la memoria.',
        'chunk_size' => 'Tamaño del fragmento',
        'chunk_size_helper' => 'Número de registros a procesar en cada lote. Los valores más bajos usan menos memoria pero tardan más.',
        'recommended_range' => 'Rango recomendado',
        'optimal_range' => 'Óptimo',
        'too_small_slow' => 'Demasiado pequeño (más lento)',
        'too_large_timeouts' => 'Demasiado grande (puede agotar el tiempo)',
        'range_large_export' => '150-300 registros',
        'range_medium_export' => '200-500 registros',
        'range_small_export' => '300-700 registros',
        'large_dataset_title' => 'Conjunto de datos grande detectado',
        'large_dataset_message' => 'Modo de exportación optimizado habilitado automáticamente para un mejor rendimiento.',
        'large_dataset_warning_title' => 'Recomendaciones de exportación de conjunto de datos grande',
        'large_dataset_specific_message' => 'Está exportando :count ubicaciones. Para un rendimiento óptimo, recomendamos usar formato CSV con exportación fragmentada.',
        'format_label' => 'Formato',
        'csv_recommended' => 'CSV (Recomendado)',
        'chunk_label' => 'Tamaño del fragmento',
        'chunk_recommended' => '150-300 registros',
        'time_label' => 'Tiempo estimado',
        'time_estimate' => '2-5 minutos',
        'pro_tip' => 'Consejo profesional:',
        'pro_tip_message' => 'Puede filtrar por tipo de ubicación (país/estado/ciudad) para exportar datos específicos.',
        'medium_dataset_detected' => 'Conjunto de datos mediano detectado',
        'medium_dataset_message' => 'Exportando :count ubicaciones. La exportación debería completarse en 1-2 minutos.',
        'excel_disabled_warning' => 'El formato Excel no se recomienda para conjuntos de datos grandes (:count+ registros). Use CSV en su lugar.',
    ],
    'import' => [
        'description' => 'Importe datos de ubicación fácilmente desde los datos disponibles o cargando un archivo CSV/Excel.',
        'rules' => [
            'name' => 'El nombre de la ubicación es obligatorio y no debe exceder los 120 caracteres.',
            'slug' => 'El slug de la ubicación, si se proporciona, no debe exceder los 120 caracteres.',
            'import_type' => 'El tipo de importación es obligatorio y debe ser uno de los valores predefinidos.',
            'order' => 'El orden de la ubicación, si se proporciona, debe ser un número entero positivo entre 0 y 127.',
            'abbreviation' => 'La abreviatura de la ubicación, si se proporciona, no debe exceder los 10 caracteres.',
            'status' => 'El estado de la ubicación es obligatorio y debe ser uno de los valores predefinidos.',
            'country' => 'El campo país es obligatorio si el tipo de importación es estado o ciudad.',
            'state' => 'El campo estado es obligatorio si el tipo de importación es ciudad.',
            'nationality' => 'La nacionalidad de la ubicación, si se proporciona, no debe exceder los 120 caracteres.',
        ],
    ],
];
