@php
    Assets::addScriptsDirectly('vendor/core/plugins/ecommerce/js/product-option.js');

    $refLang = request()->input('ref_lang');
    $isDefaultLanguage = !defined('LANGUAGE_ADVANCED_MODULE_SCREEN_NAME') || !$refLang || $refLang == Language::getDefaultLocaleCode();

    $withRelations = ['values'];

    if (!$isDefaultLanguage) {
        $withRelations = array_merge($withRelations, ['translations', 'values.translations']);
    }

    $product = $product->loadMissing([
        'options' => function ($query) use ($withRelations) {
            return $query->with($withRelations);
        },
    ]);
    $oldOption = old('options', []) ?? [];
    $currentProductOption = $product->options;
    if (! empty($currentProductOption) && $currentProductOption instanceof ArrayAccess) {
        foreach ($currentProductOption as $key => $option) {
            $optionName = $option->name;

            if (!$isDefaultLanguage && $refLang) {
                $translation = $option->translations?->firstWhere('lang_code', $refLang);
                if ($translation && $translation->name) {
                    $optionName = $translation->name;
                }
            }

            $currentProductOption[$key]['name'] = $optionName;

            if ($option->values && $option->values->isNotEmpty()) {
                foreach ($option->values as $valueKey => $value) {
                    $optionValue = $value->option_value;

                    if (!$isDefaultLanguage && $refLang) {
                        $valueTranslation = $value->translations?->firstWhere('lang_code', $refLang);
                        if ($valueTranslation && $valueTranslation->option_value) {
                            $optionValue = $valueTranslation->option_value;
                        }
                    }

                    $currentProductOption[$key]['values'][$valueKey]['option_value'] = $optionValue;
                }
            }
        }
    }

    if (! empty($oldOption)) {
        $currentProductOption = $oldOption;
    }
@endphp

@push('header')
    <script>
        window.productOptions = {
            productOptionLang: {!! Js::from(trans('plugins/ecommerce::product-option')) !!},
            coreBaseLang: {!! Js::from(trans('core/base::forms')) !!},
            currentProductOption: {!! Js::from($currentProductOption) !!},
            options: {!! Js::from($options) !!},
            routes: {!! Js::from($routes) !!},
            isDefaultLanguage: {{ (int) $isDefaultLanguage }}
        }
    </script>
@endpush

<div class="product-option-form-wrap">
    <div class="product-option-form-group">
        <div class="product-option-form-body">
            <input
                name="has_product_options"
                type="hidden"
                value="1"
            >
            <div
                class="accordion"
                id="accordion-product-option"
            ></div>
        </div>
        <div class="row">
            @if ($isDefaultLanguage)
                <div class="col col-12 col-md-4 mb-3 mb-md-0">
                    <x-core::button
                        type="button"
                        class="add-new-option"
                        id="add-new-option"
                    >
                        {{ trans('plugins/ecommerce::product-option.add_new_option') }}
                    </x-core::button>
                </div>
                @if (! empty($globalOptions))
                    <div class="col ms-auto ms-md-0 col-12 col-md-8">
                        <div class="d-flex gap-2 align-items-start justify-content-start justify-content-md-end">
                            <x-core::form.select
                                id="global-option"
                                :options="[0 => trans('plugins/ecommerce::product-option.select_global_option')] + $globalOptions"
                            />
                            <x-core::button
                                type="button"
                                class="add-from-global-option"
                            >
                                {{ trans('plugins/ecommerce::product-option.add_global_option') }}
                            </x-core::button>
                        </div>
                    </div>
                @endif
            @else
                <div class="col ms-auto ms-md-0 col-12">
                    <div class="text-muted">
                        <x-core::icon name="ti ti-info-circle" class="me-1" />
                        {{ trans('plugins/ecommerce::product-option.no_global_options') }}
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@push('footer')
    <x-core::custom-template id="template-option-values-of-field">
        <div class="table-mobile-responsive">
            <table class="table table-bordered setting-option mt-3">
                <thead>
                <tr>
                    @if ($isDefaultLanguage)
                        <th scope="col">__priceLabel__</th>
                        <th scope="col" colspan="2">__priceTypeLabel__</th>
                    @endif
                </tr>
                </thead>
                <tbody>
                <tr>
                    <input type="hidden" name="options[__index__][values][0][id]" value="__id__" />
                    @if ($isDefaultLanguage)
                        <td data-content="__priceLabel__">
                            <input type="number" name="options[__index__][values][0][affect_price]" class="form-control option-label" value="__affectPrice__" placeholder="__affectPriceLabel__"/>
                        </td>
                        <td data-content="__priceTypeLabel__">
                            <select class="form-select" name="options[__index__][values][0][affect_type]">
                                <option value="0" __selectedFixed__> __fixedLang__</option>
                                <option value="1" __selectedPercent__> __percentLang__</option>
                            </select>
                        </td>
                    @endif
                </tr>
                </tbody>
            </table>
        </div>
    </x-core::custom-template>
    <x-core::custom-template id="template-option-type-array">
        <div class="table-mobile-responsive">
            <table class="table table-bordered setting-option mt-3">
                <thead>
                <tr class="option-row">
                    @if ($isDefaultLanguage)
                        <th scope="col">#</th>
                    @endif
                    <th scope="col">__label__</th>
                    @if ($isDefaultLanguage)
                        <th scope="col">__priceLabel__</th>
                        <th scope="col" colspan="2">__priceTypeLabel__</th>
                    @endif
                </tr>
                </thead>
                <tbody>
                __optionValue__
                </tbody>
            </table>
        </div>
    </x-core::custom-template>

    <x-core::custom-template id="template-option-type-value">
        <tr data-index="__key__">
            @if ($isDefaultLanguage)
                <td class="align-middle text-center d-none d-md-block">
                    <x-core::icon name="ti ti-arrows-sort" />
                    <input type="hidden" class="option-value-order" value="__order__" name="options[__index__][values][__key__][order]">
                </td>
            @endif
            <td data-content="__label__">
                <input type="hidden" class="option-value-order" value="__id__" name="options[__index__][values][__key__][id]">
                <input type="text" name="options[__index__][values][__key__][option_value]" class="form-control option-label" value="__option_value_input__" placeholder="__labelPlaceholder__" />
            </td>
            @if ($isDefaultLanguage)
                <td class="align-middle" data-content="__priceLabel__">
                    <input type="number" name="options[__index__][values][__key__][affect_price]" class="form-control affect_price" value="__affectPrice__" placeholder="__affectPriceLabel__" />
                </td>
                <td class="align-middle" data-content="__priceTypeLabel__">
                    <select class="form-select affect_type" name="options[__index__][values][__key__][affect_type]">
                        <option value="0" __selectedFixed__> __fixedLang__ </option>
                        <option value="1" __selectedPercent__> __percentLang__ </option>
                    </select>
                </td>
                <td class="align-middle" style="width: 50px;">
                    <button class="btn btn-default remove-row" type="button"><x-core::icon name="ti ti-trash" /></button>
                </td>
            @endif
        </tr>
    </x-core::custom-template>

    <x-core::custom-template id="template-option">
        <div class="accordion-item mb-3" data-index="__index__" data-product-option-index="__index__">
            <input type="hidden" name="options[__index__][id]" value="__id__" />
            <input type="hidden" class="option-order" name="options[__index__][order]" value="__order__" />
            <h2 class="accordion-header" id="product-option-__index__">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-product-option-__index__" aria-expanded="true" aria-controls="product-option-__index__">
                    __optionName__
                </button>
            </h2>
            <div id="collapse-product-option-__index__" class="accordion-collapse collapse-product-option show" aria-labelledby="product-option-__id__" data-bs-parent="#accordion-product-option">
                <div class="accordion-body">
                    <div class="row align-items-end">
                        <div class="col col-12 col-md-3 mb-3 mb-md-0">
                            <x-core::form.label>__nameLabel__</x-core::form.label>
                            <input type="text" name="options[__index__][name]" class="form-control option-name" value="__option_name__" placeholder="__namePlaceHolder__">
                        </div>
                        @if ($isDefaultLanguage)
                            <div class="col col-12 col-md-3 mb-3 mb-md-0">
                                <x-core::form.label>__optionTypeLabel__</x-core::form.label>
                                <select name="options[__index__][option_type]" id="" class="form-select option-type">
                                    __optionTypeOption__
                                </select>
                            </div>
                            <div class="col col-12 col-md-3 mb-3 mb-md-0">
                                <div class="mb-3">
                                    <x-core::form.label class="sr-only">__requiredLabel__</x-core::form.label>
                                    <x-core::form.checkbox
                                        label="__requiredLabel__"
                                        id="required-__index__"
                                        name="options[__index__][required]"
                                        class="option-required"
                                        value="1"
                                        __checked__=""
                                    />
                                </div>
                            </div>
                            <div class="col col-12 col-md-3 text-md-end">
                                <x-core::button
                                    type="button"
                                    color="danger"
                                    data-index="__index__"
                                    class="remove-option"
                                    icon="ti ti-trash"
                                    :icon-only="true"
                                />
                            </div>
                        @endif
                    </div>
                    <div class="option-value-wrapper option-value-sortable">
                        __optionValueSortable__
                    </div>
                </div>
            </div>
        </div>
    </x-core::custom-template>
@endpush
