<?php

return [
    'name' => '产品',
    'description' => '管理实体和数字产品的库存、定价和变体',
    'create' => '新建产品',
    'create_product_type' => [
        'physical' => '新建实体产品',
        'digital' => '新建数字产品',
    ],
    'edit' => '编辑产品 - :name',
    'form' => [
        'name' => '名称',
        'name_placeholder' => '产品名称(最多120个字符)',
        'description' => '描述',
        'description_placeholder' => '产品简短描述(最多400个字符)',
        'categories' => '分类',
        'content' => '内容',
        'price' => '价格',
        'currency' => '货币',
        'currency_for_variations_hint' => '此货币将应用于此产品的所有变体。',
        'quantity' => '数量',
        'brand' => '品牌',
        'width' => '宽度',
        'height' => '高度',
        'weight' => '重量',
        'date' => [
            'start' => '开始日期',
            'end' => '结束日期',
        ],
        'image' => '图片',
        'collections' => '产品系列',
        'labels' => '标签',
        'price_sale' => '促销价',
        'product_type' => [
            'title' => '产品类型',
        ],
        'product' => '产品',
        'total' => '总计',
        'sub_total' => '小计',
        'shipping_fee' => '运费',
        'discount' => '折扣',
        'options' => '选项',
        'shipping' => [
            'height' => '高度',
            'length' => '长度',
            'title' => '运输',
            'weight' => '重量',
            'wide' => '宽度',
        ],
        'barcode' => '条形码(ISBN、UPC、GTIN等)',
        'barcode_placeholder' => '输入条形码',
        'cost_per_item' => '单位成本',
        'cost_per_item_placeholder' => '输入单位成本',
        'cost_per_item_helper' => '客户不会看到此价格。',
        'price_includes_tax' => '价格含税',
        'price_includes_tax_helper' => '如果输入的价格已包含税费,请勾选此项。系统将通过扣除税额来计算基础价格。',
        'stock' => [
            'allow_order_when_out' => '允许客户在此产品缺货时结账',
            'in_stock' => '有货',
            'out_stock' => '缺货',
            'title' => '库存状态',
        ],
        'storehouse' => [
            'no_storehouse' => '无仓库管理',
            'storehouse' => '有仓库管理',
            'title' => '仓库',
            'quantity' => '数量',
        ],
        'tax' => '税费',
        'taxes' => '税费',
        'taxes_helper' => '默认税率在<a href=":url">设置 -> 税费</a>中配置。如果未为此产品选择特定税费,将应用默认税率。要禁用此产品的税费,请从税费设置中删除默认税率。',
        'is_default' => '是默认',
        'action' => '操作',
        'restock_quantity' => '补货数量',
        'remain' => '剩余',
        'choose_discount_period' => '选择折扣期限',
        'cancel' => '取消',
        'no_results' => '无结果!',
        'value' => '值',
        'attribute_name' => '属性名称',
        'add_more_attribute' => '添加更多属性',
        'continue' => '继续',
        'add_new_attributes' => '添加新属性',
        'add_new_attributes_description' => '添加新属性可以让产品拥有多种选项,如尺寸或颜色。',
        'create_product_variations' => ':link 创建产品变体!',
        'tags' => '标签',
        'write_some_tags' => '写一些标签',
        'variation_existed' => '此变体已存在。',
        'no_attributes_selected' => '未选择属性!',
        'added_variation_success' => '添加变体成功!',
        'updated_variation_success' => '更新变体成功!',
        'created_all_variation_success' => '创建所有变体成功!',
        'updated_product_attributes_success' => '更新产品属性成功!',
        'stock_status' => '库存状态',
        'auto_generate_sku' => '自动生成SKU?',
        'featured_image' => '特色图片(可选)',
        'product_id' => '产品ID',
        'price_sale_percent_helper' => '从原价折扣:percent。',
        'minimum_order_quantity' => '最小订购数量',
        'minimum_order_quantity_helper' => '下单的最小数量,如果值为0,则没有限制。',
        'maximum_order_quantity' => '最大订购数量',
        'maximum_order_quantity_helper' => '下单的最大数量,如果值为0,则没有限制。',
        'video' => '视频',
        'video_file' => '文件',
        'video_url' => '或外部视频URL',
        'video_url_help' => '输入YouTube或Vimeo视频URL',
        'enter_video_url' => '输入视频URL',
        'video_thumbnail' => '视频缩略图',
        'video_thumbnail_help' => '选择视频的缩略图。如果未选择,将自动从视频URL获取(如果可用)。',
        'barcode_existed' => '此条形码正被另一个产品使用。请输入另一个条形码。',
        'barcode_helper' => '每个产品必须唯一。',
        'is_new_until' => '新品截止日期',
        'is_new_until_helper' => '设置一个日期,在该日期之前,此产品将被标记为"新品"。留空则不根据日期标记为新品。',
    ],
    'price' => '价格',
    'quantity' => '数量',
    'type' => '类型',
    'image' => '缩略图',
    'sku' => 'SKU',
    'sku_line' => 'SKU::sku',
    'variation_sku' => '变体SKU',
    'brand' => '品牌',
    'cannot_delete' => '无法删除产品',
    'product_deleted' => '产品已删除',
    'product' => '产品',
    'product_collections' => '产品系列',
    'products' => '产品',
    'total_products_found' => '找到:total个产品',
    'total_product_found' => '找到:total个产品',
    'menu' => '产品',
    'control' => [
        'button_add_image' => '添加图片',
    ],
    'price_sale' => '促销价',
    'price_group_title' => '管理产品价格',
    'store_house_group_title' => '管理仓库',
    'shipping_group_title' => '管理运输',
    'overview' => '概览',
    'attributes' => '属性',
    'product_has_variations' => '产品有变体',
    'manage_products' => '管理产品',
    'add_new_product' => '添加新产品',
    'start_by_adding_new_product' => '从添加新产品开始。',
    'edit_this_product' => '编辑此产品',
    'delete' => '删除',
    'related_products' => '相关产品',
    'cross_selling_products' => '交叉销售产品',
    'up_selling_products' => '向上销售产品',
    'grouped_products' => '分组产品',
    'search_products' => '搜索产品',
    'selected_products' => '已选产品',
    'edit_variation_item' => '编辑',
    'variations_box_description' => '点击"编辑属性"添加/删除变体属性,或点击"添加新变体"添加变体。',
    'save_changes' => '保存更改',
    'continue' => '继续',
    'edit_attribute' => '编辑属性',
    'select_attribute' => '选择属性',
    'add_new_variation' => '添加新变体',
    'edit_variation' => '编辑变体',
    'generate_variations' => '生成变体',
    'generate_variations_confirmation' => '您确定要为此产品生成变体吗?',
    'delete_variation' => '删除变体?',
    'delete_variation_confirmation' => '您确定要删除此变体吗?此操作无法撤销。',
    'delete_variations_confirmation' => '您确定要删除这些变体吗?此操作无法撤销。',
    'product_create_validate_name_required' => '请输入产品名称',
    'product_create_validate_sale_price_max' => '折扣必须少于原价',
    'product_create_validate_cost_per_item_max' => '单位成本必须少于原价',
    'product_create_validate_sale_price_required_if' => '要安排促销时必须输入折扣',
    'product_create_validate_end_date_after' => '结束日期必须晚于开始日期',
    'product_create_validate_start_date_required_if' => '选择安排时,折扣开始日期不能留空',
    'product_create_validate_sale_price' => '选择安排时,折扣不能留空',
    'stock_statuses' => [
        'in_stock' => '有货',
        'out_of_stock' => '缺货',
        'on_backorder' => '延期交货',
    ],
    'stock_status' => '库存状态',
    'processing' => '处理中...',
    'delete_selected_variations' => '删除选定的变体',
    'delete_variations' => '删除变体',
    'category' => '分类',
    'categories' => '分类',
    'tags' => '标签',
    'product_price_flash_sale_warning' => '此产品在限时抢购<strong>:name</strong>中,价格为<strong>:price</strong>。',
    'product_price_discount_warning' => '此产品在折扣<strong>:name</strong>中,价格为<strong>:price</strong>。',
    'product_image' => '产品图片',
    'product_name' => '产品名称',
    'product_link' => '产品链接',
    'types' => [
        'physical' => '实体',
        'digital' => '数字',
    ],
    'digital_attachments' => [
        'title' => '数字附件',
        'add' => '添加附件',
        'file_name' => '文件名',
        'file_size' => '文件大小',
        'unsaved' => '未保存',
        'add_external_link' => '添加外部链接',
        'enter_file_name' => '输入文件名',
        'enter_external_link_download' => '输入外部下载链接',
        'enter_file_size' => '输入文件大小',
        'external_link_download' => '外部下载链接',
        'generate_license_code_after_purchasing_product' => '为此产品启用许可证代码分配',
        'notify_attachment_updated' => '附件更新时向客户发送电子邮件',
        'no_attachments' => '还没有附件。点击上面的按钮添加文件。',
    ],
    'license_codes' => [
        'title' => '许可证代码',
        'add' => '添加许可证代码',
        'back' => '返回产品',
        'edit' => '编辑许可证代码',
        'generate' => '生成代码',
        'manage_codes' => '管理许可证代码',
        'management' => '许可证代码管理',
        'variation_breadcrumb' => '变体::name',
        'variation_label' => '产品变体',
        'variation_specific_note' => '这些许可证代码专属于此产品变体。购买此变体的客户将从此池中获得代码。',
        'main_product_note' => '此产品有变体。每个变体可以有自己的许可证代码,如果变体没有代码,客户可以从此主产品池中获得代码。',
        'code' => '许可证代码',
        'codes' => '许可证代码',
        'status' => '状态',
        'assigned_at' => '分配时间',
        'status_available' => '可用',
        'status_used' => '已使用',
        'statuses' => [
            'available' => '可用',
            'used' => '已使用',
        ],
        'no_codes' => '未找到许可证代码。添加一些代码或自动生成它们。',
        'no_codes_warning_title' => '没有可用的许可证代码!',
        'no_codes_warning_message' => '此产品设置为"从列表中选择",但没有可用的许可证代码。购买此产品的客户将收到自动生成的代码。请添加许可证代码以确保正常功能。',
        'no_codes_auto_generate' => '此产品设置为自动生成许可证代码。无需手动代码。',
        'used_code_no_actions' => '已使用的代码 - 无可用操作',
        'created_successfully' => '许可证代码创建成功!',
        'updated_successfully' => '许可证代码更新成功!',
        'deleted_successfully' => '许可证代码删除成功!',
        'generated_successfully' => '成功生成:count个许可证代码!',
        'duplicates_skipped' => ':count个重复代码已跳过。',
        'generation_incomplete' => '警告:由于重复冲突,只能生成:generated个,共请求:requested个代码。',
        'cannot_edit_used_code' => '无法编辑已使用的许可证代码。',
        'cannot_delete_used_code' => '无法删除已使用的许可证代码。',
        'show_all' => '显示全部',
        'show_less' => '显示更少',
        'more' => '更多',
        'used_codes_hidden' => ':count个已使用的许可证代码已隐藏。您可以在许可证代码管理页面查看所有代码。',
        'low_stock_title' => '许可证代码库存不足',
        'low_stock_message' => '仅剩:count个许可证代码。考虑添加更多代码以避免用尽。',
        'out_of_stock_title' => '许可证代码已用完!',
        'out_of_stock_message' => '没有可用的许可证代码。在您添加更多代码之前,客户将收到自动生成的代码。',
        'type' => [
            'title' => '许可证代码分配方法',
            'auto_generate' => '自动生成(系统自动生成代码)',
            'pick_from_list' => '从列表中选择(使用预先输入的代码)',
            'description' => '选择客户购买此产品时如何分配许可证代码。',
        ],
        'add_modal' => [
            'placeholder' => '例如,XXXX-XXXX-XXXX-XXXX',
            'help' => '输入一个唯一的许可证代码,将在购买时分配给客户。',
        ],
        'generate_modal' => [
            'title' => '生成许可证代码',
            'quantity' => '数量',
            'format' => '格式',
            'custom_pattern' => '自定义模式',
            'pattern_help' => '使用#表示数字,A表示大写字母,a表示小写字母',
            'generate' => '生成',
        ],
        'errors' => [
            'feature_not_enabled' => '许可证代码功能未启用。请在电子商务设置 -> 数字产品中启用它。',
            'digital_products_not_enabled' => '数字产品未启用。请先启用数字产品支持。',
            'product_not_found' => '未找到产品。',
            'not_digital_product' => '许可证代码仅适用于数字产品。此产品设置为实体产品。',
            'license_codes_not_enabled_for_product' => '此产品未启用许可证代码管理。请在产品设置中启用"购买产品后生成许可证代码"。',
            'cannot_add_codes_auto_generate' => '无法手动添加许可证代码到设置为自动生成的产品。请先将许可证代码类型更改为"从列表中选择"。',
            'cannot_generate_codes_auto_generate' => '无法手动生成设置为自动生成的产品的许可证代码。请先将许可证代码类型更改为"从列表中选择"。',
        ],
        'bulk_delete' => [
            'button' => '删除选定',
            'selected' => '已选',
            'confirm' => '您确定要删除选定的许可证代码吗?',
            'deleted_successfully' => '成功删除:count个许可证代码。',
            'skipped_used_codes' => ':count个已使用的代码已跳过。',
            'no_deletable_codes' => '未找到可删除的可用许可证代码。已使用的代码无法删除。',
        ],
        'import' => [
            'name' => '导入产品许可证代码',
            'description' => '从CSV/Excel文件导入数字产品的许可证代码。',
            'button' => '导入',
            'columns' => [
                'product_id' => '产品ID或SKU',
                'license_code' => '许可证代码',
            ],
        ],
        'copied' => '许可证代码已复制到剪贴板!',
    ],
    'this_action_will_reload_page' => '此操作将重新加载页面以更新数据!',
    'select' => '选择',
    'clear_filters' => '清除筛选',
    'set_this_variant_as_default' => '将此变体设置为默认',
    'download' => '下载',
    'external_link_downloads' => '外部链接',
    'download_available_when_completed' => '订单完成后将提供下载链接。',
    'cross_sell_price_type' => [
        'title' => '价格类型',
        'fixed' => '固定',
        'percent' => '百分比',
    ],
    'cross_sell_help' => [
        'price' => '* 价格字段',
        'price_description' => '输入您想从原价中减少的金额。例如:如果原价是$100,输入20将价格降至$80。',
        'type' => '* 类型字段',
        'type_description' => '选择折扣类型:固定(减少特定金额)或百分比(按百分比减少)。',
    ],
    'up_sell_price_type' => [
        'title' => '价格类型',
        'fixed' => '固定',
        'percent' => '百分比',
    ],
    'up_sell_help' => [
        'price' => '* 价格字段',
        'price_description' => '输入您想从原价中减少的金额。例如:如果原价是$100,输入20将价格降至$80。',
        'type' => '* 类型字段',
        'type_description' => '选择折扣类型:固定(减少特定金额)或百分比(按百分比减少)。',
    ],
    'up_sale' => [
        'title' => '一起购买并节省',
        'description' => '一起购买这些商品可获得特别折扣',
        'unlock_discount' => '将:product添加到购物车以解锁套装折扣',
        'multiple_options' => '多个选项',
        'multiple_options_available' => '有多个选项可用',
        'select' => '选择',
        'selected_items_total' => '选定商品总计:',
        'add_selected_to_cart' => '将选定商品添加到购物车',
        'bundle_discount_with' => '与:product的套装折扣',
        'bundle_with' => '与:product的套装',
    ],
    'cross_sale' => [
        'title' => '经常一起购买',
        'description' => '查看此商品的客户还购买了',
    ],
    'apply_for_all_variations' => '应用于所有变体',
    'export' => [
        'description' => '将您的产品数据导出到CSV或Excel文件。',
        'total_items' => '总项目',
        'total_products' => '总产品',
        'total_variations' => '总变体',
        'advanced_options' => '高级选项',
        'use_chunked_export' => '使用分块导出',
        'use_chunked_export_helper' => '分块处理数据以高效处理大型数据集',
        'include_variations' => '包含产品变体',
        'include_variations_helper' => '与主产品一起导出产品变体',
        'optimize_memory' => '优化内存使用',
        'optimize_memory_helper' => '为非常大的导出启用内存优化',
        'chunk_size' => '块大小',
        'chunk_size_helper' => '一次处理的产品数量(50-5000)',
        'use_streaming' => '使用流式导出',
        'use_streaming_helper' => '为非常大的数据集启用流式传输(超过10,000项时自动启用)',
        'large_dataset_warning_title' => '检测到大型产品目录',
        'large_dataset_warning_message' => '您的目录包含:count个项目。由于规模较大,某些导出选项已针对最佳性能进行了优化。',
        'large_dataset_specific_message' => '对于您的:count个产品,请使用启用流式传输的CSV格式。系统现在可以高效处理您的大型产品目录,而不会出现超时或内存问题。',
        'format_label' => '格式',
        'csv_recommended' => 'CSV(必需)',
        'chunk_label' => '处理',
        'chunk_recommended' => '300个产品/批次',
        'time_label' => '预计时间',
        'time_estimate' => '1-3分钟',
        'pro_tip' => '专业提示:',
        'pro_tip_message' => '即使您的浏览器显示加载指示器,导出也会继续运行。一旦开始,下载将自动开始。',
        'large_dataset_tip_1' => 'Excel格式已禁用 - 使用CSV格式进行更快、更可靠的导出',
        'large_dataset_tip_2' => '流式模式已自动启用以防止超时',
        'large_dataset_tip_3' => '导出过程可能需要1-3分钟,具体取决于您的服务器',
        'large_dataset_recommendation' => '建议:使用CSV格式,块大小为200-500以获得最佳性能。',
        'excel_disabled_for_large_export' => '超过10,000个项目的目录不可用Excel格式',
        'streaming_auto_enabled' => '流式模式已自动启用,以在大型数据集下获得最佳性能。',
        'streaming_enabled_title' => '针对大型导出进行了优化',
        'streaming_enabled_message' => '流式模式已激活,以确保顺畅导出而不会出现内存问题。',
        'use_multi_file' => '使用多文件导出',
        'use_multi_file_helper' => '将导出拆分为打包在ZIP中的多个文件,用于非常大的数据集',
        'multi_file_enabled_title' => '多文件导出已启用',
        'multi_file_enabled_message' => '您的导出将被拆分为打包在ZIP中的:count个文件,以获得最佳性能。',
        'records_per_file' => '每个文件的记录数',
        'records_per_file_helper' => '使用多文件导出时每个文件中的记录数',
        'estimated_files' => '预计文件数',
        'recommended_range' => '建议范围',
        'range_large_export' => '200-500项',
        'range_medium_export' => '300-800项',
        'range_small_export' => '500-1000项',
        'export_progress' => '导出进度',
        'preparing_export' => '准备导出...',
        'items_processed' => '已处理:count个项目',
        'estimated_time_calculating' => '预计时间:计算中...',
        'medium_dataset_detected' => '检测到中型数据集',
        'medium_dataset_message' => '您正在导出:count个产品。考虑使用分块导出以获得更好的性能。',
        'optimal_range' => '最佳范围',
        'too_small_slow' => '太小 - 可能很慢',
        'too_large_timeouts' => '太大 - 可能导致超时',
        'excel_disabled_warning' => '大型导出禁用Excel格式(:count个项目)',
        'starting_export' => '开始导出...',
        'processing_data' => '处理数据...',
        'finalizing_export' => '完成导出...',
        'items_processed_suffix' => '已处理项目',
        'estimated_time_prefix' => '预计时间:',
        'seconds_remaining' => '秒剩余',
        'export_completed' => '导出完成!',
        'download_starting' => '下载开始...',
    ],
    'import' => [
        'description' => '从CSV或Excel文件导入您的产品数据。',
        'rules' => [
            'in' => ':attribute必须是定义值之一::values。',
            'required_string_max' => ':attribute是必需的,必须是最大长度为:max个字符的字符串。',
            'nullable_string' => ':attribute可以留空,或者如果提供则必须是字符串。',
            'nullable_string_max' => ':attribute可以留空,或者如果提供则必须是最大长度为:max个字符的字符串',
            'nullable_bool' => ':attribute可以留空,或者如果提供则必须是布尔值。',
            'nullable_numeric_min' => ':attribute可以留空,或者如果提供则必须是非负数。',
            'nullable_numeric_min_max' => ':attribute可以留空,或者如果提供则必须是:min和:max之间的数字。',
            'nullable_array' => ':attribute可以留空,或者如果指定则必须作为数组提供。',
            'nullable_date_required_if' => ':attribute可以留空,或者如果提供则必须是有效日期,如果指定:required则必需。',
            'nullable_date_after' => ':attribute可以留空,或者如果提供则必须是:after之后的有效日期。',
        ],
        'updated_message' => '成功更新:count个产品!',
    ],
    'import_products_intro' => '或从CSV/Excel导入产品',
    'select_attributes' => '选择属性以创建变体:',
    'all' => '全部',
    'copy' => '复制',
    'product_translations' => '产品翻译',
    'view' => '查看产品 - :name',
    'product_information' => '产品信息',
    'total_views' => '总浏览量',
    'total_orders' => '已完成订单',
    'total_sold' => '总销量',
    'total_revenue' => '总收入',
    'pending_orders' => '待处理订单',
    'pending_revenue' => '待处理收入',
    'conversion_rate' => '转化率',
    'total_reviews' => '总评论数',
    'average_rating' => '平均评分',
    'views_by_date' => '按日期的浏览量(最近30天)',
    'recent_orders' => '最近订单',
    'no_views_data' => '最近30天没有浏览数据。',
    'no_orders' => '还没有订单。',
    'date' => '日期',
    'views' => '浏览量',
    'total' => '总计',
    'view_on_frontend' => '在前台查看',
    'select_attribute' => '选择:name',
    'all_categories' => '所有分类',
    'brands' => '品牌',
    'browse_products' => '浏览产品',
    'sku_1' => 'SKU:',
    'select_products_to_return' => '选择要退货的产品',
    'show_only_discounted_products' => '仅显示折扣产品',
    'specification' => '规格',
    'download_product_with_external_links' => '下载带有外部链接的产品":name"',
    'number_product_available_singular' => ':number个产品可用',
    'number_products_available_plural' => ':number个产品可用',
    'cart' => [
        'added_to_cart_success' => ':product已添加到您的购物车。',
        'removed_from_cart_success' => ':product已从您的购物车中删除。',
        'updated_cart_success' => '您的购物车已更新。',
        'item_not_found' => '此商品不再在您的购物车中。',
        'out_of_stock' => '抱歉,:product目前缺货。',
        'max_quantity' => '您最多只能添加:max件商品。',
        'max_quantity_detail' => '抱歉,您一次最多只能订购:quantity个单位的:product。',
        'select_options' => '请在添加到购物车之前选择产品选项。',
        'product_out_of_stock' => '抱歉,此产品目前缺货。',
        'product_not_exists' => '此产品缺货或不再存在。',
        'not_enough_quantity' => '某些产品没有足够的库存来更新。',
        'empty_success' => '您的购物车已清空。',
        'bundle_item_already_in_cart' => '此套装商品已在您的购物车中。每个套装折扣只允许1件商品。',
    ],
    'wishlist' => [
        'added_success' => ':product已添加到您的愿望清单。',
        'removed_success' => ':product已从您的愿望清单中删除。',
        'product_not_found' => '找不到此产品。',
        'product_not_in_wishlist' => '此产品不在您的愿望清单中。',
        'product_not_available' => '此产品不可用。',
    ],
    'compare' => [
        'added_success' => ':product已添加到您的比较列表。',
        'removed_success' => ':product已从您的比较列表中删除。',
        'product_not_found' => '找不到此产品。',
        'product_not_in_compare' => '此产品不在您的比较列表中。',
        'already_in_list' => ':product已在您的比较列表中。',
    ],
];
