<?php

return [
    'name' => 'Produkty',
    'description' => 'Spravujte fyzické a digitálne produkty so skladom, cenami a variáciami',
    'create' => 'Nový produkt',
    'create_product_type' => [
        'physical' => 'Nový fyzický produkt',
        'digital' => 'Nový digitálny produkt',
    ],
    'edit' => 'Upraviť produkt - :name',
    'form' => [
        'name' => 'Názov',
        'name_placeholder' => 'Názov produktu (Maximálne 120 znakov)',
        'description' => 'Popis',
        'description_placeholder' => 'Krátky popis produktu (Maximálne 400 znakov)',
        'categories' => 'Kategórie',
        'content' => 'Obsah',
        'price' => 'Cena',
        'currency' => 'Mena',
        'currency_for_variations_hint' => 'Táto mena sa použije na všetky variácie tohto produktu.',
        'quantity' => 'Množstvo',
        'brand' => 'Značka',
        'width' => 'Šírka',
        'height' => 'Výška',
        'weight' => 'Hmotnosť',
        'date' => [
            'start' => 'Od dátumu',
            'end' => 'Do dátumu',
        ],
        'image' => 'Obrázky',
        'collections' => 'Kolekcie produktov',
        'labels' => 'Štítky',
        'price_sale' => 'Akčná cena',
        'product_type' => [
            'title' => 'Typ produktu',
        ],
        'product' => 'Produkt',
        'total' => 'Celkom',
        'sub_total' => 'Medzisúčet',
        'shipping_fee' => 'Poštovné',
        'discount' => 'Zľava',
        'options' => 'Možnosti',
        'shipping' => [
            'height' => 'Výška',
            'length' => 'Dĺžka',
            'title' => 'Doprava',
            'weight' => 'Hmotnosť',
            'wide' => 'Šírka',
        ],
        'barcode' => 'Čiarový kód (ISBN, UPC, GTIN, atď.) ',
        'barcode_placeholder' => 'Zadajte čiarový kód',
        'cost_per_item' => 'Náklady na položku',
        'cost_per_item_placeholder' => 'Zadajte náklady na položku',
        'cost_per_item_helper' => 'Zákazníci túto cenu neuvidia.',
        'price_includes_tax' => 'Cena zahŕňa daň',
        'price_includes_tax_helper' => 'Zaškrtnite, ak zadaná cena už zahŕňa dane. Systém vypočíta základnú cenu odpočítaním dane.',
        'stock' => [
            'allow_order_when_out' => 'Povoliť objednávku zákazníkovi, keď je produkt vypredaný',
            'in_stock' => 'Skladom',
            'out_stock' => 'Vypredané',
            'title' => 'Stav skladu',
        ],
        'storehouse' => [
            'no_storehouse' => 'Bez správy skladu',
            'storehouse' => 'So správou skladu',
            'title' => 'Sklad',
            'quantity' => 'Množstvo',
        ],
        'tax' => 'Daň',
        'taxes' => 'Dane',
        'taxes_helper' => 'Predvolená sadzba dane je nakonfigurovaná v <a href=":url">Nastavenia -> Daň</a>. Ak pre tento produkt nie je vybraná žiadna konkrétna daň, použije sa predvolená sadzba. Ak chcete pre tento produkt zakázať daň, odstráňte predvolenú sadzbu dane z nastavení dane.',
        'is_default' => 'Je predvolený',
        'action' => 'Akcia',
        'restock_quantity' => 'Doplniť množstvo',
        'remain' => 'Zostáva',
        'choose_discount_period' => 'Vyberte obdobie zľavy',
        'cancel' => 'Zrušiť',
        'no_results' => 'Žiadne výsledky!',
        'value' => 'Hodnota',
        'attribute_name' => 'Názov atribútu',
        'add_more_attribute' => 'Pridať ďalší atribút',
        'continue' => 'Pokračovať',
        'add_new_attributes' => 'Pridať nové atribúty',
        'add_new_attributes_description' => 'Pridanie nových atribútov pomáha produktu mať viac možností, ako je veľkosť alebo farba.',
        'create_product_variations' => ':link na vytvorenie variácií produktu!',
        'tags' => 'Štítky',
        'write_some_tags' => 'Napíšte nejaké štítky',
        'variation_existed' => 'Táto variácia už existuje.',
        'no_attributes_selected' => 'Neboli vybrané žiadne atribúty!',
        'added_variation_success' => 'Variácia bola úspešne pridaná!',
        'updated_variation_success' => 'Variácia bola úspešne aktualizovaná!',
        'created_all_variation_success' => 'Všetky variácie boli úspešne vytvorené!',
        'updated_product_attributes_success' => 'Atribúty produktu boli úspešne aktualizované!',
        'stock_status' => 'Stav skladu',
        'auto_generate_sku' => 'Automaticky generovať SKU?',
        'featured_image' => 'Hlavný obrázok (voliteľné)',
        'product_id' => 'ID produktu',
        'price_sale_percent_helper' => 'Zľava :percent z pôvodnej ceny.',
        'minimum_order_quantity' => 'Minimálne množstvo objednávky',
        'minimum_order_quantity_helper' => 'Minimálne množstvo na zadanie objednávky, ak je hodnota 0, nie je žiadny limit.',
        'maximum_order_quantity' => 'Maximálne množstvo objednávky',
        'maximum_order_quantity_helper' => 'Maximálne množstvo na zadanie objednávky, ak je hodnota 0, nie je žiadny limit.',
        'video' => 'Video',
        'video_file' => 'Súbor',
        'video_url' => 'Alebo externá URL videa',
        'video_url_help' => 'Zadajte URL videa z YouTube alebo Vimeo',
        'enter_video_url' => 'Zadajte URL videa',
        'video_thumbnail' => 'Náhľad videa',
        'video_thumbnail_help' => 'Vyberte náhľad pre video. Ak nie je vybraný, automaticky sa získa z URL videa, ak je k dispozícii.',
        'barcode_existed' => 'Tento čiarový kód už používa iný produkt. Prosím, zadajte iný čiarový kód.',
        'barcode_helper' => 'Musí byť jedinečný pre každý produkt.',
        'is_new_until' => 'Nový do',
        'is_new_until_helper' => 'Nastavte dátum, do ktorého bude tento produkt označený ako "Nový". Nechajte prázdne, ak nechcete označovať ako nový na základe dátumu.',
    ],
    'price' => 'Cena',
    'quantity' => 'Množstvo',
    'type' => 'Typ',
    'image' => 'Náhľad',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU variácie',
    'brand' => 'Značka',
    'cannot_delete' => 'Produkt sa nepodarilo odstrániť',
    'product_deleted' => 'Produkt bol odstránený',
    'product' => 'Produkt',
    'product_collections' => 'Kolekcie produktov',
    'products' => 'Produkty',
    'total_products_found' => 'Nájdených :total produktov',
    'total_product_found' => 'Nájdený :total produkt',
    'menu' => 'Produkty',
    'control' => [
        'button_add_image' => 'Pridať obrázok',
    ],
    'price_sale' => 'Akčná cena',
    'price_group_title' => 'Správa ceny produktu',
    'store_house_group_title' => 'Správa skladu',
    'shipping_group_title' => 'Správa dopravy',
    'overview' => 'Prehľad',
    'attributes' => 'Atribúty',
    'product_has_variations' => 'Produkt má variácie',
    'manage_products' => 'Spravovať produkty',
    'add_new_product' => 'Pridať nový produkt',
    'start_by_adding_new_product' => 'Začnite pridaním nových produktov.',
    'edit_this_product' => 'Upraviť tento produkt',
    'delete' => 'Odstrániť',
    'related_products' => 'Súvisiace produkty',
    'cross_selling_products' => 'Krížovo predávané produkty',
    'up_selling_products' => 'Dodatočne predávané produkty',
    'grouped_products' => 'Zoskupené produkty',
    'search_products' => 'Hľadať produkty',
    'selected_products' => 'Vybrané produkty',
    'edit_variation_item' => 'Upraviť',
    'variations_box_description' => 'Kliknite na "Upraviť atribút" pre pridanie/odstránenie atribútov variácie alebo kliknite na "Pridať novú variáciu" pre pridanie variácie.',
    'save_changes' => 'Uložiť zmeny',
    'continue' => 'Pokračovať',
    'edit_attribute' => 'Upraviť atribút',
    'select_attribute' => 'Vybrať atribút',
    'add_new_variation' => 'Pridať novú variáciu',
    'edit_variation' => 'Upraviť variáciu',
    'generate_variations' => 'Generovať variácie',
    'generate_variations_confirmation' => 'Ste si istí, že chcete generovať variácie pre tento produkt?',
    'delete_variation' => 'Odstrániť variáciu?',
    'delete_variation_confirmation' => 'Ste si istí, že chcete odstrániť túto variáciu? Túto akciu nie je možné vrátiť späť.',
    'delete_variations_confirmation' => 'Ste si istí, že chcete odstrániť tieto variácie? Túto akciu nie je možné vrátiť späť.',
    'product_create_validate_name_required' => 'Prosím, zadajte názov produktu',
    'product_create_validate_sale_price_max' => 'Zľava musí byť nižšia ako pôvodná cena',
    'product_create_validate_cost_per_item_max' => 'Náklady na položku musia byť nižšie ako pôvodná cena',
    'product_create_validate_sale_price_required_if' => 'Musíte zadať zľavu, keď chcete naplánovať akciu',
    'product_create_validate_end_date_after' => 'Dátum ukončenia musí byť po dátume začiatku',
    'product_create_validate_start_date_required_if' => 'Dátum začiatku zľavy nemôže byť prázdny, keď je vybraté plánovanie',
    'product_create_validate_sale_price' => 'Zľavy nemôžu byť prázdne, keď je vybraté plánovanie',
    'stock_statuses' => [
        'in_stock' => 'Skladom',
        'out_of_stock' => 'Vypredané',
        'on_backorder' => 'Na objednávku',
    ],
    'stock_status' => 'Stav skladu',
    'processing' => 'Spracováva sa...',
    'delete_selected_variations' => 'Odstrániť vybrané variácie',
    'delete_variations' => 'Odstrániť variácie',
    'category' => 'Kategória',
    'categories' => 'Kategórie',
    'tags' => 'Štítky',
    'product_price_flash_sale_warning' => 'Tento produkt je v bleskovom výpredaji <strong>:name</strong>, takže jeho cena je <strong>:price</strong>.',
    'product_price_discount_warning' => 'Tento produkt je v zľave <strong>:name</strong>, takže jeho cena je <strong>:price</strong>.',
    'product_image' => 'Obrázok produktu',
    'product_name' => 'Názov produktu',
    'product_link' => 'Odkaz na produkt',
    'types' => [
        'physical' => 'Fyzický',
        'digital' => 'Digitálny',
    ],
    'digital_attachments' => [
        'title' => 'Digitálne prílohy',
        'add' => 'Pridať prílohu',
        'file_name' => 'Názov súboru',
        'file_size' => 'Veľkosť súboru',
        'unsaved' => 'Neuložené',
        'add_external_link' => 'Pridať externý odkaz',
        'enter_file_name' => 'Zadajte názov súboru',
        'enter_external_link_download' => 'Zadajte externý odkaz na stiahnutie',
        'enter_file_size' => 'Zadajte veľkosť súboru',
        'external_link_download' => 'Externý odkaz na stiahnutie',
        'generate_license_code_after_purchasing_product' => 'Povoliť pridelenie licenčného kódu pre tento produkt',
        'notify_attachment_updated' => 'Poslať e-mail zákazníkovi, keď je príloha aktualizovaná',
        'no_attachments' => 'Zatiaľ žiadne prílohy. Kliknite na tlačidlá vyššie pre pridanie súborov.',
    ],
    'license_codes' => [
        'title' => 'Licenčné kódy',
        'add' => 'Pridať licenčný kód',
        'back' => 'Späť na produkt',
        'edit' => 'Upraviť licenčný kód',
        'generate' => 'Generovať kódy',
        'manage_codes' => 'Spravovať licenčné kódy',
        'management' => 'Správa licenčných kódov',
        'variation_breadcrumb' => 'Variácia: :name',
        'variation_label' => 'Variácia produktu',
        'variation_specific_note' => 'Tieto licenčné kódy sú špecifické pre túto variáciu produktu. Zákazníci, ktorí si zakúpia túto variáciu, dostanú kódy z tohto zoznamu.',
        'main_product_note' => 'Tento produkt má variácie. Každá variácia môže mať svoje vlastné licenčné kódy, alebo zákazníci môžu dostať kódy z tohto hlavného zoznamu produktu, ak variácia nemá žiadne kódy.',
        'code' => 'Licenčný kód',
        'codes' => 'Licenčné kódy',
        'status' => 'Stav',
        'assigned_at' => 'Pridelené dňa',
        'status_available' => 'Dostupný',
        'status_used' => 'Použitý',
        'statuses' => [
            'available' => 'Dostupný',
            'used' => 'Použitý',
        ],
        'no_codes' => 'Neboli nájdené žiadne licenčné kódy. Pridajte nejaké kódy alebo ich automaticky vygenerujte.',
        'no_codes_warning_title' => 'Žiadne dostupné licenčné kódy!',
        'no_codes_warning_message' => 'Tento produkt je nastavený na "Vybrať zo zoznamu", ale nemá žiadne dostupné licenčné kódy. Zákazníci, ktorí si zakúpia tento produkt, dostanú automaticky generované kódy. Prosím, pridajte licenčné kódy pre správnu funkčnosť.',
        'no_codes_auto_generate' => 'Tento produkt je nastavený na automatické generovanie licenčných kódov. Manuálne kódy nie sú potrebné.',
        'used_code_no_actions' => 'Použitý kód - žiadne akcie nie sú dostupné',
        'created_successfully' => 'Licenčný kód bol úspešne vytvorený!',
        'updated_successfully' => 'Licenčný kód bol úspešne aktualizovaný!',
        'deleted_successfully' => 'Licenčný kód bol úspešne odstránený!',
        'generated_successfully' => 'Úspešne vygenerovaných :count licenčných kódov!',
        'duplicates_skipped' => ':count duplicitných kódov bolo preskočených.',
        'generation_incomplete' => 'Upozornenie: Podarilo sa vygenerovať iba :generated z :requested požadovaných kódov kvôli konfliktom s duplicitami.',
        'cannot_edit_used_code' => 'Nie je možné upraviť použitý licenčný kód.',
        'cannot_delete_used_code' => 'Nie je možné odstrániť použitý licenčný kód.',
        'show_all' => 'Zobraziť všetko',
        'show_less' => 'Zobraziť menej',
        'more' => 'viac',
        'used_codes_hidden' => ':count použitých licenčných kódov je skrytých. Všetky kódy môžete zobraziť na stránke Správa licenčných kódov.',
        'low_stock_title' => 'Nízky stav licenčných kódov',
        'low_stock_message' => 'Zostáva iba :count licenčných kódov. Zvážte pridanie ďalších kódov, aby ste sa vyhli ich vyčerpaniu.',
        'out_of_stock_title' => 'Licenčné kódy vypredané!',
        'out_of_stock_message' => 'Žiadne licenčné kódy nie sú dostupné. Zákazníci budú dostávať automaticky generované kódy, kým nepridáte ďalšie.',
        'type' => [
            'title' => 'Spôsob pridelenia licenčného kódu',
            'auto_generate' => 'Automaticky generovať (Systém automaticky generuje kódy)',
            'pick_from_list' => 'Vybrať zo zoznamu (Použiť vopred zadané kódy)',
            'description' => 'Vyberte, ako sa majú licenčné kódy prideľovať zákazníkom pri zakúpení tohto produktu.',
        ],
        'add_modal' => [
            'placeholder' => 'napr. XXXX-XXXX-XXXX-XXXX',
            'help' => 'Zadajte jedinečný licenčný kód, ktorý bude pridelený zákazníkovi po nákupe.',
        ],
        'generate_modal' => [
            'title' => 'Generovať licenčné kódy',
            'quantity' => 'Množstvo',
            'format' => 'Formát',
            'custom_pattern' => 'Vlastný vzor',
            'pattern_help' => 'Použite # pre čísla, A pre veľké písmená, a pre malé písmená',
            'generate' => 'Generovať',
        ],
        'errors' => [
            'feature_not_enabled' => 'Funkcia licenčných kódov nie je povolená. Prosím, povoľte ju v Nastavenia e-commerce > Digitálne produkty.',
            'digital_products_not_enabled' => 'Digitálne produkty nie sú povolené. Prosím, najprv povoľte podporu digitálnych produktov.',
            'product_not_found' => 'Produkt nebol nájdený.',
            'not_digital_product' => 'Licenčné kódy sú dostupné iba pre digitálne produkty. Tento produkt je nastavený ako fyzický produkt.',
            'license_codes_not_enabled_for_product' => 'Správa licenčných kódov nie je pre tento produkt povolená. Prosím, povoľte "Generovať licenčný kód po zakúpení produktu" v nastaveniach produktu.',
            'cannot_add_codes_auto_generate' => 'Nie je možné manuálne pridať licenčné kódy k produktom nastaveným na automatické generovanie. Najprv zmeňte typ licenčného kódu na "Vybrať zo zoznamu".',
            'cannot_generate_codes_auto_generate' => 'Nie je možné manuálne generovať licenčné kódy pre produkty nastavené na automatické generovanie. Najprv zmeňte typ licenčného kódu na "Vybrať zo zoznamu".',
        ],
        'bulk_delete' => [
            'button' => 'Odstrániť vybrané',
            'selected' => 'vybraných',
            'confirm' => 'Ste si istí, že chcete odstrániť vybrané licenčné kódy?',
            'deleted_successfully' => 'Úspešne odstránených :count licenčných kódov.',
            'skipped_used_codes' => ':count použitých kódov bolo preskočených.',
            'no_deletable_codes' => 'Neboli nájdené žiadne dostupné licenčné kódy na odstránenie. Použité kódy nie je možné odstrániť.',
        ],
        'import' => [
            'name' => 'Importovať licenčné kódy produktov',
            'description' => 'Importujte licenčné kódy pre digitálne produkty zo súboru CSV/Excel.',
            'button' => 'Importovať',
            'columns' => [
                'product_id' => 'ID produktu alebo SKU',
                'license_code' => 'Licenčný kód',
            ],
        ],
        'copied' => 'Licenčný kód bol skopírovaný do schránky!',
    ],
    'this_action_will_reload_page' => 'Táto akcia znovu načíta stránku pre aktualizáciu dát!',
    'select' => 'Vybrať',
    'clear_filters' => 'Vymazať filtre',
    'set_this_variant_as_default' => 'Nastaviť túto variáciu ako predvolenú',
    'download' => 'Stiahnuť',
    'external_link_downloads' => 'Externé odkazy',
    'download_available_when_completed' => 'Odkazy na stiahnutie budú dostupné po dokončení objednávky.',
    'cross_sell_price_type' => [
        'title' => 'Typ ceny',
        'fixed' => 'Pevná',
        'percent' => 'Percento',
    ],
    'cross_sell_help' => [
        'price' => '* Pole ceny',
        'price_description' => 'Zadajte sumu, ktorú chcete odpočítať z pôvodnej ceny. Príklad: Ak je pôvodná cena 100 €, zadajte 20 pre zníženie ceny na 80 €.',
        'type' => '* Pole typu',
        'type_description' => 'Vyberte typ zľavy: Pevná (odpočítať konkrétnu sumu) alebo Percento (odpočítať percento).',
    ],
    'up_sell_price_type' => [
        'title' => 'Typ ceny',
        'fixed' => 'Pevná',
        'percent' => 'Percento',
    ],
    'up_sell_help' => [
        'price' => '* Pole ceny',
        'price_description' => 'Zadajte sumu, ktorú chcete odpočítať z pôvodnej ceny. Príklad: Ak je pôvodná cena 100 €, zadajte 20 pre zníženie ceny na 80 €.',
        'type' => '* Pole typu',
        'type_description' => 'Vyberte typ zľavy: Pevná (odpočítať konkrétnu sumu) alebo Percento (odpočítať percento).',
    ],
    'up_sale' => [
        'title' => 'Kúpte spolu a ušetrite',
        'description' => 'Získajte špeciálne zľavy pri spoločnom nákupe týchto položiek',
        'unlock_discount' => 'Pridajte :product do košíka pre odomknutie zľavy na balík',
        'multiple_options' => 'Viacero možností',
        'multiple_options_available' => 'Dostupných viacero možností',
        'select' => 'Vybrať',
        'selected_items_total' => 'Celkom za vybrané položky:',
        'add_selected_to_cart' => 'Pridať vybrané do košíka',
        'bundle_discount_with' => 'Zľava na balík s :product',
        'bundle_with' => 'Balík s :product',
    ],
    'cross_sale' => [
        'title' => 'Často kupované spolu',
        'description' => 'Zákazníci, ktorí si prezreli túto položku, tiež kúpili',
    ],
    'apply_for_all_variations' => 'Použiť na všetky variácie',
    'export' => [
        'description' => 'Exportujte údaje o produktoch do súborov CSV alebo Excel.',
        'total_items' => 'Celkom položiek',
        'total_products' => 'Celkom produktov',
        'total_variations' => 'Celkom variácií',
        'advanced_options' => 'Pokročilé možnosti',
        'use_chunked_export' => 'Použiť export po častiach',
        'use_chunked_export_helper' => 'Spracovať dáta po častiach pre efektívne spracovanie veľkých súborov dát',
        'include_variations' => 'Zahrnúť variácie produktov',
        'include_variations_helper' => 'Exportovať variácie produktov spolu s hlavnými produktmi',
        'optimize_memory' => 'Optimalizovať využitie pamäte',
        'optimize_memory_helper' => 'Povoliť optimalizáciu pamäte pre veľmi veľké exporty',
        'chunk_size' => 'Veľkosť časti',
        'chunk_size_helper' => 'Počet produktov na spracovanie naraz (50-5000)',
        'use_streaming' => 'Použiť streamovací export',
        'use_streaming_helper' => 'Povoliť streamovanie pre veľmi veľké súbory dát (automaticky povolené pre >10 000 položiek)',
        'large_dataset_warning_title' => 'Zistený veľký katalóg produktov',
        'large_dataset_warning_message' => 'Váš katalóg obsahuje :count položiek. Kvôli veľkej veľkosti boli niektoré možnosti exportu optimalizované pre najlepší výkon.',
        'large_dataset_specific_message' => 'Pre vašich :count produktov použite formát CSV so zapnutým streamovaním. Systém teraz dokáže efektívne spracovať váš veľký katalóg produktov bez časových limitov alebo problémov s pamäťou.',
        'format_label' => 'Formát',
        'csv_recommended' => 'CSV (Vyžadované)',
        'chunk_label' => 'Spracovanie',
        'chunk_recommended' => '300 produktov/dávka',
        'time_label' => 'Odhadovaný čas',
        'time_estimate' => '1-3 minúty',
        'pro_tip' => 'Tip:',
        'pro_tip_message' => 'Export bude pokračovať aj keď váš prehliadač zobrazuje indikátor načítavania. Po spustení sa sťahovanie začne automaticky.',
        'large_dataset_tip_1' => 'Formát Excel bol zakázaný - použite formát CSV pre rýchlejšie a spoľahlivejšie exporty',
        'large_dataset_tip_2' => 'Režim streamovania bol automaticky povolený pre prevenciu časových limitov',
        'large_dataset_tip_3' => 'Proces exportu môže trvať 1-3 minúty v závislosti od vášho servera',
        'large_dataset_recommendation' => 'Odporúčané: Použite formát CSV s veľkosťou časti 200-500 pre optimálny výkon.',
        'excel_disabled_for_large_export' => 'Formát Excel nie je dostupný pre katalógy nad 10 000 položiek',
        'streaming_auto_enabled' => 'Režim streamovania bol automaticky povolený pre optimálny výkon s veľkými súbormi dát.',
        'streaming_enabled_title' => 'Optimalizované pre veľký export',
        'streaming_enabled_message' => 'Režim streamovania je aktívny pre zabezpečenie plynulého exportu bez problémov s pamäťou.',
        'use_multi_file' => 'Použiť export do viacerých súborov',
        'use_multi_file_helper' => 'Rozdeliť export do viacerých súborov zabalených v ZIP pre veľmi veľké súbory dát',
        'multi_file_enabled_title' => 'Export do viacerých súborov povolený',
        'multi_file_enabled_message' => 'Váš export bude rozdelený do :count súborov zabalených v ZIP pre optimálny výkon.',
        'records_per_file' => 'Záznamov na súbor',
        'records_per_file_helper' => 'Počet záznamov v každom súbore pri použití exportu do viacerých súborov',
        'estimated_files' => 'Odhadovaný počet súborov',
        'recommended_range' => 'Odporúčaný rozsah',
        'range_large_export' => '200-500 položiek',
        'range_medium_export' => '300-800 položiek',
        'range_small_export' => '500-1000 položiek',
        'export_progress' => 'Priebeh exportu',
        'preparing_export' => 'Príprava exportu...',
        'items_processed' => 'Spracovaných :count položiek',
        'estimated_time_calculating' => 'Odhadovaný čas: počíta sa...',
        'medium_dataset_detected' => 'Zistený stredný súbor dát',
        'medium_dataset_message' => 'Exportujete :count produktov. Zvážte použitie exportu po častiach pre lepší výkon.',
        'optimal_range' => 'Optimálny rozsah',
        'too_small_slow' => 'Príliš malý - môže byť pomalý',
        'too_large_timeouts' => 'Príliš veľký - môže spôsobiť časové limity',
        'excel_disabled_warning' => 'Formát Excel zakázaný pre veľké exporty (:count položiek)',
        'starting_export' => 'Spúšťa sa export...',
        'processing_data' => 'Spracovávajú sa dáta...',
        'finalizing_export' => 'Dokončuje sa export...',
        'items_processed_suffix' => 'položiek spracovaných',
        'estimated_time_prefix' => 'Odhadovaný čas:',
        'seconds_remaining' => 's zostáva',
        'export_completed' => 'Export dokončený!',
        'download_starting' => 'Sťahovanie sa začína...',
    ],
    'import' => [
        'description' => 'Importujte údaje o produktoch zo súborov CSV alebo Excel.',
        'rules' => [
            'in' => ':attribute musí byť jedna z definovaných hodnôt: :values.',
            'required_string_max' => ':attribute je povinný a musí byť reťazec s maximálnou dĺžkou :max znakov.',
            'nullable_string' => ':attribute môže byť prázdny alebo musí byť reťazec, ak je zadaný.',
            'nullable_string_max' => ':attribute môže byť prázdny alebo musí byť reťazec s maximálnou dĺžkou :max znakov, ak je zadaný',
            'nullable_bool' => ':attribute môže byť prázdny alebo musí byť booleovská hodnota, ak je zadaný.',
            'nullable_numeric_min' => ':attribute môže byť prázdny alebo musí byť nezáporné číslo, ak je zadaný.',
            'nullable_numeric_min_max' => ':attribute môže byť prázdny alebo musí byť číslo medzi :min a :max, ak je zadaný.',
            'nullable_array' => ':attribute môže byť prázdny alebo musí byť zadaný ako pole, ak je špecifikovaný.',
            'nullable_date_required_if' => ':attribute môže byť prázdny alebo musí byť platný dátum, ak je zadaný, povinný ak je špecifikovaný :required.',
            'nullable_date_after' => ':attribute môže byť prázdny alebo musí byť platný dátum po :after, ak je zadaný.',
        ],
        'updated_message' => 'Úspešne aktualizovaných :count produktov!',
    ],
    'import_products_intro' => 'Alebo importujte produkty z CSV/Excel',
    'select_attributes' => 'Vyberte atribúty pre vytvorenie variácií:',
    'all' => 'Všetko',
    'copy' => 'Kopírovať',
    'product_translations' => 'Preklady produktov',
    'view' => 'Zobraziť produkt - :name',
    'product_information' => 'Informácie o produkte',
    'total_views' => 'Celkom zobrazení',
    'total_orders' => 'Dokončené objednávky',
    'total_sold' => 'Celkom predané',
    'total_revenue' => 'Celkové tržby',
    'pending_orders' => 'Čakajúce objednávky',
    'pending_revenue' => 'Čakajúce tržby',
    'conversion_rate' => 'Miera konverzie',
    'total_reviews' => 'Celkom recenzií',
    'average_rating' => 'Priemerné hodnotenie',
    'views_by_date' => 'Zobrazenia podľa dátumu (Posledných 30 dní)',
    'recent_orders' => 'Nedávne objednávky',
    'no_views_data' => 'Žiadne údaje o zobrazeniach za posledných 30 dní.',
    'no_orders' => 'Zatiaľ žiadne objednávky.',
    'date' => 'Dátum',
    'views' => 'Zobrazenia',
    'total' => 'Celkom',
    'view_on_frontend' => 'Zobraziť na webe',
    'select_attribute' => 'Vybrať :name',
    'all_categories' => 'Všetky kategórie',
    'brands' => 'Značky',
    'browse_products' => 'Prehliadať produkty',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Vyberte produkty na vrátenie',
    'show_only_discounted_products' => 'Zobraziť iba zľavnené produkty',
    'specification' => 'Špecifikácia',
    'download_product_with_external_links' => 'Stiahnuť produkt ":name" s externými odkazmi',
    'number_product_available_singular' => ':number produkt dostupný',
    'number_products_available_plural' => ':number produktov dostupných',
    'cart' => [
        'added_to_cart_success' => ':product bol pridaný do vášho košíka.',
        'removed_from_cart_success' => ':product bol odstránený z vášho košíka.',
        'updated_cart_success' => 'Váš košík bol aktualizovaný.',
        'item_not_found' => 'Táto položka už nie je vo vašom košíku.',
        'out_of_stock' => 'Ľutujeme, :product je momentálne vypredaný.',
        'max_quantity' => 'Môžete pridať maximálne :max položiek.',
        'max_quantity_detail' => 'Ľutujeme, môžete objednať maximálne :quantity kusov :product naraz.',
        'select_options' => 'Prosím, vyberte možnosti produktu pred pridaním do košíka.',
        'product_out_of_stock' => 'Ľutujeme, tento produkt je momentálne vypredaný.',
        'product_not_exists' => 'Tento produkt je vypredaný alebo už neexistuje.',
        'not_enough_quantity' => 'Niektoré produkty nemajú dostatok zásob na aktualizáciu.',
        'empty_success' => 'Váš košík bol vyprázdnený.',
        'bundle_item_already_in_cart' => 'Táto položka z balíka je už vo vašom košíku. Na zľavu na balík je povolená iba 1 položka.',
    ],
    'wishlist' => [
        'added_success' => ':product bol pridaný do vášho zoznamu prianí.',
        'removed_success' => ':product bol odstránený z vášho zoznamu prianí.',
        'product_not_found' => 'Tento produkt sa nepodarilo nájsť.',
        'product_not_in_wishlist' => 'Tento produkt nie je vo vašom zozname prianí.',
        'product_not_available' => 'Tento produkt nie je dostupný.',
    ],
    'compare' => [
        'added_success' => ':product bol pridaný do vášho porovnávacieho zoznamu.',
        'removed_success' => ':product bol odstránený z vášho porovnávacieho zoznamu.',
        'product_not_found' => 'Tento produkt sa nepodarilo nájsť.',
        'product_not_in_compare' => 'Tento produkt nie je vo vašom porovnávacom zozname.',
        'already_in_list' => ':product je už vo vašom porovnávacom zozname.',
    ],
];
