<?php

return [
    'name' => 'Produkter',
    'description' => 'Administrer fysiske og digitale produkter med lager, priser og varianter',
    'create' => 'Nytt produkt',
    'create_product_type' => [
        'physical' => 'Nytt fysisk produkt',
        'digital' => 'Nytt digitalt produkt',
    ],
    'edit' => 'Rediger produkt - :name',
    'form' => [
        'name' => 'Navn',
        'name_placeholder' => 'Produktnavn (Maksimum 120 tegn)',
        'description' => 'Beskrivelse',
        'description_placeholder' => 'Kort beskrivelse av produkt (Maksimum 400 tegn)',
        'categories' => 'Kategorier',
        'content' => 'Innhold',
        'price' => 'Pris',
        'currency' => 'Valuta',
        'currency_for_variations_hint' => 'Denne valutaen vil bli brukt for alle varianter av dette produktet.',
        'quantity' => 'Antall',
        'brand' => 'Merke',
        'width' => 'Bredde',
        'height' => 'Hoyde',
        'weight' => 'Vekt',
        'date' => [
            'start' => 'Fra dato',
            'end' => 'Til dato',
        ],
        'image' => 'Bilder',
        'collections' => 'Produktsamlinger',
        'labels' => 'Etiketter',
        'price_sale' => 'Salgspris',
        'product_type' => [
            'title' => 'Produkttype',
        ],
        'product' => 'Produkt',
        'total' => 'Total',
        'sub_total' => 'Delsum',
        'shipping_fee' => 'Fraktgebyr',
        'discount' => 'Rabatt',
        'options' => 'Alternativer',
        'shipping' => [
            'height' => 'Hoyde',
            'length' => 'Lengde',
            'title' => 'Frakt',
            'weight' => 'Vekt',
            'wide' => 'Bredde',
        ],
        'barcode' => 'Strekkode (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Skriv inn strekkode',
        'cost_per_item' => 'Kostnad per vare',
        'cost_per_item_placeholder' => 'Skriv inn kostnad per vare',
        'cost_per_item_helper' => 'Kunder vil ikke se denne prisen.',
        'price_includes_tax' => 'Prisen inkluderer avgift',
        'price_includes_tax_helper' => 'Merk av dette hvis den angitte prisen allerede inkluderer avgifter. Systemet vil beregne grunnprisen ved a fjerne avgiftsbelopet.',
        'stock' => [
            'allow_order_when_out' => 'Tillat kunde a bestille nar dette produktet er utsolgt',
            'in_stock' => 'Pa lager',
            'out_stock' => 'Utsolgt',
            'title' => 'Lagerstatus',
        ],
        'storehouse' => [
            'no_storehouse' => 'Ingen lagerstyring',
            'storehouse' => 'Med lagerstyring',
            'title' => 'Lager',
            'quantity' => 'Antall',
        ],
        'tax' => 'Mva',
        'taxes' => 'Mva',
        'taxes_helper' => 'Standard mva-sats er konfigurert i <a href=":url">Innstillinger -> Mva</a>. Hvis ingen spesifikk mva er valgt for dette produktet, vil standardsatsen bli brukt. For a deaktivere mva for dette produktet, fjern standard mva-sats fra mva-innstillingene.',
        'is_default' => 'Er standard',
        'action' => 'Handling',
        'restock_quantity' => 'Pafyllingsantall',
        'remain' => 'Gjenstar',
        'choose_discount_period' => 'Velg rabattperiode',
        'cancel' => 'Avbryt',
        'no_results' => 'Ingen resultater!',
        'value' => 'Verdi',
        'attribute_name' => 'Attributtnavn',
        'add_more_attribute' => 'Legg til flere attributter',
        'continue' => 'Fortsett',
        'add_new_attributes' => 'Legg til nye attributter',
        'add_new_attributes_description' => 'A legge til nye attributter hjelper produktet med a ha mange alternativer, som storrelse eller farge.',
        'create_product_variations' => ':link for a opprette produktvarianter!',
        'tags' => 'Tagger',
        'write_some_tags' => 'Skriv noen tagger',
        'variation_existed' => 'Denne varianten finnes allerede.',
        'no_attributes_selected' => 'Ingen attributter valgt!',
        'added_variation_success' => 'Lagt til variant vellykket!',
        'updated_variation_success' => 'Oppdatert variant vellykket!',
        'created_all_variation_success' => 'Opprettet alle varianter vellykket!',
        'updated_product_attributes_success' => 'Oppdatert produktattributter vellykket!',
        'stock_status' => 'Lagerstatus',
        'auto_generate_sku' => 'Autogenerer SKU?',
        'featured_image' => 'Fremhevet bilde (valgfritt)',
        'product_id' => 'Produkt-ID',
        'price_sale_percent_helper' => 'Rabatt :percent fra originalpris.',
        'minimum_order_quantity' => 'Minimum bestillingsantall',
        'minimum_order_quantity_helper' => 'Minimumsantall for a legge inn en bestilling, hvis verdien er 0, er det ingen grense.',
        'maximum_order_quantity' => 'Maksimum bestillingsantall',
        'maximum_order_quantity_helper' => 'Maksimumsantall for a legge inn en bestilling, hvis verdien er 0, er det ingen grense.',
        'video' => 'Video',
        'video_file' => 'Fil',
        'video_url' => 'Eller ekstern video-URL',
        'video_url_help' => 'Skriv inn YouTube eller Vimeo video-URL',
        'enter_video_url' => 'Skriv inn video-URL',
        'video_thumbnail' => 'Video-miniatyrbilde',
        'video_thumbnail_help' => 'Velg et miniatyrbilde for videoen. Hvis ikke valgt, vil det automatisk hentes fra video-URL hvis tilgjengelig.',
        'barcode_existed' => 'Denne strekkoden brukes av et annet produkt. Vennligst skriv inn en annen strekkode.',
        'barcode_helper' => 'Ma vaere unik for hvert produkt.',
        'is_new_until' => 'Ny til',
        'is_new_until_helper' => 'Angi en dato til nar dette produktet skal merkes som "Nytt". La sta tomt for ikke a merke som nytt basert pa dato.',
    ],
    'price' => 'Pris',
    'quantity' => 'Antall',
    'type' => 'Type',
    'image' => 'Miniatyrbilde',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'Variant-SKU',
    'brand' => 'Merke',
    'cannot_delete' => 'Produktet kunne ikke slettes',
    'product_deleted' => 'Produktet er slettet',
    'product' => 'Produkt',
    'product_collections' => 'Produktsamlinger',
    'products' => 'Produkter',
    'total_products_found' => ':total produkter funnet',
    'total_product_found' => ':total produkt funnet',
    'menu' => 'Produkter',
    'control' => [
        'button_add_image' => 'Legg til bilde',
    ],
    'price_sale' => 'Salgspris',
    'price_group_title' => 'Administrer produktpris',
    'store_house_group_title' => 'Administrer lager',
    'shipping_group_title' => 'Administrer frakt',
    'overview' => 'Oversikt',
    'attributes' => 'Attributter',
    'product_has_variations' => 'Produktet har varianter',
    'manage_products' => 'Administrer produkter',
    'add_new_product' => 'Legg til nytt produkt',
    'start_by_adding_new_product' => 'Start med a legge til nye produkter.',
    'edit_this_product' => 'Rediger dette produktet',
    'delete' => 'Slett',
    'related_products' => 'Relaterte produkter',
    'cross_selling_products' => 'Krysssalgsprodukter',
    'up_selling_products' => 'Oppsalgsprodukter',
    'grouped_products' => 'Grupperte produkter',
    'search_products' => 'Sok produkter',
    'selected_products' => 'Valgte produkter',
    'edit_variation_item' => 'Rediger',
    'variations_box_description' => 'Klikk pa "Rediger attributt" for a legge til/fjerne attributter for variant eller klikk pa "Legg til ny variant" for a legge til variant.',
    'save_changes' => 'Lagre endringer',
    'continue' => 'Fortsett',
    'edit_attribute' => 'Rediger attributt',
    'select_attribute' => 'Velg attributt',
    'add_new_variation' => 'Legg til ny variant',
    'edit_variation' => 'Rediger variant',
    'generate_variations' => 'Generer varianter',
    'generate_variations_confirmation' => 'Er du sikker pa at du vil generere varianter for dette produktet?',
    'delete_variation' => 'Slett variant?',
    'delete_variation_confirmation' => 'Er du sikker pa at du vil slette denne varianten? Denne handlingen kan ikke angres.',
    'delete_variations_confirmation' => 'Er du sikker pa at du vil slette disse variantene? Denne handlingen kan ikke angres.',
    'product_create_validate_name_required' => 'Vennligst skriv inn produktnavn',
    'product_create_validate_sale_price_max' => 'Rabatten ma vaere mindre enn originalprisen',
    'product_create_validate_cost_per_item_max' => 'Kostnad per vare ma vaere mindre enn originalprisen',
    'product_create_validate_sale_price_required_if' => 'Ma skrive inn rabatt nar du vil planlegge en kampanje',
    'product_create_validate_end_date_after' => 'Sluttdato ma vaere etter startdato',
    'product_create_validate_start_date_required_if' => 'Rabattstartdato kan ikke vaere tom nar planlegging er valgt',
    'product_create_validate_sale_price' => 'Rabatter kan ikke vaere tomme nar planlegging er valgt',
    'stock_statuses' => [
        'in_stock' => 'Pa lager',
        'out_of_stock' => 'Utsolgt',
        'on_backorder' => 'Pa restordre',
    ],
    'stock_status' => 'Lagerstatus',
    'processing' => 'Behandler...',
    'delete_selected_variations' => 'Slett valgte varianter',
    'delete_variations' => 'Slett varianter',
    'category' => 'Kategori',
    'categories' => 'Kategorier',
    'tags' => 'Tagger',
    'product_price_flash_sale_warning' => 'Dette produktet er i flash-salg <strong>:name</strong> sa prisen er <strong>:price</strong>.',
    'product_price_discount_warning' => 'Dette produktet er i rabatt <strong>:name</strong> sa prisen er <strong>:price</strong>.',
    'product_image' => 'Produktbilde',
    'product_name' => 'Produktnavn',
    'product_link' => 'Produktlenke',
    'types' => [
        'physical' => 'Fysisk',
        'digital' => 'Digitalt',
    ],
    'digital_attachments' => [
        'title' => 'Digitale vedlegg',
        'add' => 'Legg til vedlegg',
        'file_name' => 'Filnavn',
        'file_size' => 'Filstorrelse',
        'unsaved' => 'Ikke lagret',
        'add_external_link' => 'Legg til ekstern lenke',
        'enter_file_name' => 'Skriv inn filnavn',
        'enter_external_link_download' => 'Skriv inn ekstern nedlastingslenke',
        'enter_file_size' => 'Skriv inn filstorrelse',
        'external_link_download' => 'Ekstern nedlastingslenke',
        'generate_license_code_after_purchasing_product' => 'Aktiver tildeling av lisenskode for dette produktet',
        'notify_attachment_updated' => 'Send e-post til kunde nar vedlegg oppdateres',
        'no_attachments' => 'Ingen vedlegg enna. Klikk pa knappene ovenfor for a legge til filer.',
    ],
    'license_codes' => [
        'title' => 'Lisenskoder',
        'add' => 'Legg til lisenskode',
        'back' => 'Tilbake til produkt',
        'edit' => 'Rediger lisenskode',
        'generate' => 'Generer koder',
        'manage_codes' => 'Administrer lisenskoder',
        'management' => 'Lisenskodeadministrasjon',
        'variation_breadcrumb' => 'Variant: :name',
        'variation_label' => 'Produktvariant',
        'variation_specific_note' => 'Disse lisenskodene er spesifikke for denne produktvarianten. Kunder som kjoper denne varianten vil motta koder fra dette settet.',
        'main_product_note' => 'Dette produktet har varianter. Hver variant kan ha sine egne lisenskoder, eller kunder kan motta koder fra dette hovedproduktet hvis varianten ikke har koder.',
        'code' => 'Lisenskode',
        'codes' => 'Lisenskoder',
        'status' => 'Status',
        'assigned_at' => 'Tildelt',
        'status_available' => 'Tilgjengelig',
        'status_used' => 'Brukt',
        'statuses' => [
            'available' => 'Tilgjengelig',
            'used' => 'Brukt',
        ],
        'no_codes' => 'Ingen lisenskoder funnet. Legg til noen koder eller generer dem automatisk.',
        'no_codes_warning_title' => 'Ingen lisenskoder tilgjengelig!',
        'no_codes_warning_message' => 'Dette produktet er satt til "Velg fra liste" men har ingen tilgjengelige lisenskoder. Kunder som kjoper dette produktet vil motta autogenererte koder i stedet. Vennligst legg til lisenskoder for a sikre riktig funksjonalitet.',
        'no_codes_auto_generate' => 'Dette produktet er satt til a autogenerere lisenskoder. Ingen manuelle koder nodvendig.',
        'used_code_no_actions' => 'Brukt kode - ingen handlinger tilgjengelig',
        'created_successfully' => 'Lisenskode opprettet vellykket!',
        'updated_successfully' => 'Lisenskode oppdatert vellykket!',
        'deleted_successfully' => 'Lisenskode slettet vellykket!',
        'generated_successfully' => 'Genererte :count lisenskoder vellykket!',
        'duplicates_skipped' => ':count dupliserte koder ble hoppet over.',
        'generation_incomplete' => 'Advarsel: Kunne bare generere :generated av :requested foresporte koder pa grunn av duplikatkonflikter.',
        'cannot_edit_used_code' => 'Kan ikke redigere en brukt lisenskode.',
        'cannot_delete_used_code' => 'Kan ikke slette en brukt lisenskode.',
        'show_all' => 'Vis alle',
        'show_less' => 'Vis mindre',
        'more' => 'mer',
        'used_codes_hidden' => ':count brukt(e) lisenskode(r) er skjult. Du kan se alle koder pa siden for lisenskodeadministrasjon.',
        'low_stock_title' => 'Lav beholdning av lisenskoder',
        'low_stock_message' => 'Kun :count lisenskoder gjenstar. Vurder a legge til flere koder for a unnga a ga tom.',
        'out_of_stock_title' => 'Tom for lisenskoder!',
        'out_of_stock_message' => 'Ingen lisenskoder tilgjengelig. Kunder vil motta autogenererte koder til du legger til flere.',
        'type' => [
            'title' => 'Tildelingsmetode for lisenskode',
            'auto_generate' => 'Autogenerer (Systemet genererer koder automatisk)',
            'pick_from_list' => 'Velg fra liste (Bruk forhandsinnforte koder)',
            'description' => 'Velg hvordan lisenskoder skal tildeles kunder nar de kjoper dette produktet.',
        ],
        'add_modal' => [
            'placeholder' => 'f.eks. XXXX-XXXX-XXXX-XXXX',
            'help' => 'Skriv inn en unik lisenskode som vil bli tildelt en kunde ved kjop.',
        ],
        'generate_modal' => [
            'title' => 'Generer lisenskoder',
            'quantity' => 'Antall',
            'format' => 'Format',
            'custom_pattern' => 'Tilpasset monster',
            'pattern_help' => 'Bruk # for tall, A for store bokstaver, a for sma bokstaver',
            'generate' => 'Generer',
        ],
        'errors' => [
            'feature_not_enabled' => 'Lisenskodefunksjonen er ikke aktivert. Vennligst aktiver den i E-handelsinnstillinger > Digitale produkter.',
            'digital_products_not_enabled' => 'Digitale produkter er ikke aktivert. Vennligst aktiver stotte for digitale produkter forst.',
            'product_not_found' => 'Produktet ikke funnet.',
            'not_digital_product' => 'Lisenskoder er kun tilgjengelige for digitale produkter. Dette produktet er satt som fysisk produkt.',
            'license_codes_not_enabled_for_product' => 'Lisenskodeadministrasjon er ikke aktivert for dette produktet. Vennligst aktiver "Generer lisenskode etter kjop av produkt" i produktinnstillingene.',
            'cannot_add_codes_auto_generate' => 'Kan ikke manuelt legge til lisenskoder til produkter satt til autogenerering. Endre lisenskodetype til "Velg fra liste" forst.',
            'cannot_generate_codes_auto_generate' => 'Kan ikke manuelt generere lisenskoder for produkter satt til autogenerering. Endre lisenskodetype til "Velg fra liste" forst.',
        ],
        'bulk_delete' => [
            'button' => 'Slett valgte',
            'selected' => 'valgt',
            'confirm' => 'Er du sikker pa at du vil slette de valgte lisenskodene?',
            'deleted_successfully' => ':count lisenskode(r) slettet vellykket.',
            'skipped_used_codes' => ':count brukte kode(r) ble hoppet over.',
            'no_deletable_codes' => 'Ingen tilgjengelige lisenskoder funnet a slette. Brukte koder kan ikke slettes.',
        ],
        'import' => [
            'name' => 'Importer produktlisenskoder',
            'description' => 'Importer lisenskoder for digitale produkter fra CSV/Excel-fil.',
            'button' => 'Importer',
            'columns' => [
                'product_id' => 'Produkt-ID eller SKU',
                'license_code' => 'Lisenskode',
            ],
        ],
        'copied' => 'Lisenskode kopiert til utklippstavle!',
    ],
    'this_action_will_reload_page' => 'Denne handlingen vil laste siden pa nytt for a oppdatere dataene!',
    'select' => 'Velg',
    'clear_filters' => 'Fjern filtre',
    'set_this_variant_as_default' => 'Sett denne varianten som standard',
    'download' => 'Last ned',
    'external_link_downloads' => 'Eksterne lenker',
    'download_available_when_completed' => 'Nedlastingslenker blir tilgjengelige nar bestillingen er fullfort.',
    'cross_sell_price_type' => [
        'title' => 'Pristype',
        'fixed' => 'Fast',
        'percent' => 'Prosent',
    ],
    'cross_sell_help' => [
        'price' => '* Prisfelt',
        'price_description' => 'Skriv inn belopet du vil redusere fra originalprisen. Eksempel: Hvis originalprisen er 1000 kr, skriv inn 200 for a redusere prisen til 800 kr.',
        'type' => '* Typefelt',
        'type_description' => 'Velg rabatttype: Fast (reduser et spesifikt belop) eller Prosent (reduser med en prosentandel).',
    ],
    'up_sell_price_type' => [
        'title' => 'Pristype',
        'fixed' => 'Fast',
        'percent' => 'Prosent',
    ],
    'up_sell_help' => [
        'price' => '* Prisfelt',
        'price_description' => 'Skriv inn belopet du vil redusere fra originalprisen. Eksempel: Hvis originalprisen er 1000 kr, skriv inn 200 for a redusere prisen til 800 kr.',
        'type' => '* Typefelt',
        'type_description' => 'Velg rabatttype: Fast (reduser et spesifikt belop) eller Prosent (reduser med en prosentandel).',
    ],
    'up_sale' => [
        'title' => 'Kjop sammen og spar',
        'description' => 'Fa spesielle rabatter nar du kjoper disse varene sammen',
        'unlock_discount' => 'Legg til :product i handlekurven for a lase opp bundelrabatt',
        'multiple_options' => 'Flere alternativer',
        'multiple_options_available' => 'Flere alternativer tilgjengelig',
        'select' => 'Velg',
        'selected_items_total' => 'Totalt valgte varer:',
        'add_selected_to_cart' => 'Legg valgte til handlekurv',
        'bundle_discount_with' => 'Bundelrabatt med :product',
        'bundle_with' => 'Bundel med :product',
    ],
    'cross_sale' => [
        'title' => 'Ofte kjopt sammen',
        'description' => 'Kunder som sa pa denne varen kjopte ogsa',
    ],
    'apply_for_all_variations' => 'Bruk for alle varianter',
    'export' => [
        'description' => 'Eksporter produktdataene dine til CSV- eller Excel-filer.',
        'total_items' => 'Totale elementer',
        'total_products' => 'Totale produkter',
        'total_variations' => 'Totale varianter',
        'advanced_options' => 'Avanserte alternativer',
        'use_chunked_export' => 'Bruk delt eksport',
        'use_chunked_export_helper' => 'Behandle data i deler for a handtere store datasett effektivt',
        'include_variations' => 'Inkluder produktvarianter',
        'include_variations_helper' => 'Eksporter produktvarianter sammen med hovedprodukter',
        'optimize_memory' => 'Optimaliser minnebruk',
        'optimize_memory_helper' => 'Aktiver minneoptimalisering for svaert store eksporter',
        'chunk_size' => 'Delstorrelse',
        'chunk_size_helper' => 'Antall produkter som skal behandles om gangen (50-5000)',
        'use_streaming' => 'Bruk strommeeksport',
        'use_streaming_helper' => 'Aktiver stromming for svaert store datasett (aktiveres automatisk for >10 000 elementer)',
        'large_dataset_warning_title' => 'Stort produktkatalog oppdaget',
        'large_dataset_warning_message' => 'Katalogen din inneholder :count elementer. Pa grunn av storrelsen har noen eksportalternativer blitt optimalisert for best ytelse.',
        'large_dataset_specific_message' => 'For :count produkter, bruk CSV-format med stromming aktivert. Systemet kan na handtere ditt store produktkatalog effektivt uten tidsavbrudd eller minneproblemer.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (pakrevd)',
        'chunk_label' => 'Behandling',
        'chunk_recommended' => '300 produkter/batch',
        'time_label' => 'Estimert tid',
        'time_estimate' => '1-3 minutter',
        'pro_tip' => 'Pro-tips:',
        'pro_tip_message' => 'Eksporten vil fortsette selv om nettleseren viser en laste-indikator. Nar den er startet, vil nedlastingen begynne automatisk.',
        'large_dataset_tip_1' => 'Excel-format er deaktivert - bruk CSV-format for raskere og mer palitelige eksporter',
        'large_dataset_tip_2' => 'Strommemodus er automatisk aktivert for a forhindre tidsavbrudd',
        'large_dataset_tip_3' => 'Eksportprosess kan ta 1-3 minutter avhengig av serveren',
        'large_dataset_recommendation' => 'Anbefalt: Bruk CSV-format med 200-500 delstorrelse for optimal ytelse.',
        'excel_disabled_for_large_export' => 'Excel-format ikke tilgjengelig for kataloger over 10 000 elementer',
        'streaming_auto_enabled' => 'Strommemodus er automatisk aktivert for optimal ytelse med store datasett.',
        'streaming_enabled_title' => 'Optimalisert for stor eksport',
        'streaming_enabled_message' => 'Strommemodus er aktiv for a sikre jevn eksport uten minneproblemer.',
        'use_multi_file' => 'Bruk flerfilseksport',
        'use_multi_file_helper' => 'Del eksport i flere filer pakket i en ZIP for svaert store datasett',
        'multi_file_enabled_title' => 'Flerfilseksport aktivert',
        'multi_file_enabled_message' => 'Eksporten vil bli delt i :count filer pakket i en ZIP for optimal ytelse.',
        'records_per_file' => 'Poster per fil',
        'records_per_file_helper' => 'Antall poster i hver fil ved bruk av flerfilseksport',
        'estimated_files' => 'Estimerte filer',
        'recommended_range' => 'Anbefalt omrade',
        'range_large_export' => '200-500 elementer',
        'range_medium_export' => '300-800 elementer',
        'range_small_export' => '500-1000 elementer',
        'export_progress' => 'Eksportfremdrift',
        'preparing_export' => 'Forbereder eksport...',
        'items_processed' => ':count elementer behandlet',
        'estimated_time_calculating' => 'Estimert tid: beregner...',
        'medium_dataset_detected' => 'Middels datasett oppdaget',
        'medium_dataset_message' => 'Du eksporterer :count produkter. Vurder a bruke delt eksport for bedre ytelse.',
        'optimal_range' => 'Optimalt omrade',
        'too_small_slow' => 'For lite - kan vaere tregt',
        'too_large_timeouts' => 'For stort - kan forasake tidsavbrudd',
        'excel_disabled_warning' => 'Excel-format deaktivert for store eksporter (:count elementer)',
        'starting_export' => 'Starter eksport...',
        'processing_data' => 'Behandler data...',
        'finalizing_export' => 'Fullforer eksport...',
        'items_processed_suffix' => 'elementer behandlet',
        'estimated_time_prefix' => 'Estimert tid:',
        'seconds_remaining' => 's gjenstar',
        'export_completed' => 'Eksport fullfort!',
        'download_starting' => 'Nedlasting starter...',
    ],
    'import' => [
        'description' => 'Importer produktdataene dine fra CSV- eller Excel-filer.',
        'rules' => [
            'in' => ':attribute ma vaere en av de definerte verdiene: :values.',
            'required_string_max' => ':attribute er pakrevd og ma vaere en streng med maksimum lengde :max tegn.',
            'nullable_string' => ':attribute kan vaere tom eller ma vaere en streng hvis angitt.',
            'nullable_string_max' => ':attribute kan vaere tom eller ma vaere en streng med maksimum lengde :max tegn hvis angitt',
            'nullable_bool' => 'Om :attribute kan vaere tom eller ma vaere en boolsk verdi hvis angitt.',
            'nullable_numeric_min' => ':attribute kan vaere tom eller ma vaere et ikke-negativt tall hvis angitt.',
            'nullable_numeric_min_max' => ':attribute kan vaere tom eller ma vaere et tall mellom :min og :max hvis angitt.',
            'nullable_array' => ':attribute kan vaere tom eller ma angis som en array hvis spesifisert.',
            'nullable_date_required_if' => ':attribute kan vaere tom eller ma vaere en gyldig dato hvis angitt, pakrevd hvis :required er spesifisert.',
            'nullable_date_after' => ':attribute kan vaere tom eller ma vaere en gyldig dato etter :after hvis angitt.',
        ],
        'updated_message' => 'Oppdaterte :count produkt(er) vellykket!',
    ],
    'import_products_intro' => 'Eller importer produkter fra CSV/Excel',
    'select_attributes' => 'Velg attributter for a opprette varianter:',
    'all' => 'Alle',
    'copy' => 'Kopier',
    'product_translations' => 'Produktoversettelser',
    'view' => 'Se produkt - :name',
    'product_information' => 'Produktinformasjon',
    'total_views' => 'Totalt antall visninger',
    'total_orders' => 'Fullforte bestillinger',
    'total_sold' => 'Totalt solgt',
    'total_revenue' => 'Total inntekt',
    'pending_orders' => 'Ventende bestillinger',
    'pending_revenue' => 'Ventende inntekter',
    'conversion_rate' => 'Konverteringsrate',
    'total_reviews' => 'Totalt anmeldelser',
    'average_rating' => 'Gjennomsnittlig vurdering',
    'views_by_date' => 'Visninger etter dato (siste 30 dager)',
    'recent_orders' => 'Siste bestillinger',
    'no_views_data' => 'Ingen visningsdata tilgjengelig for de siste 30 dagene.',
    'no_orders' => 'Ingen bestillinger enna.',
    'date' => 'Dato',
    'views' => 'Visninger',
    'total' => 'Totalt',
    'view_on_frontend' => 'Se pa nettstedet',
    'select_attribute' => 'Velg :name',
    'all_categories' => 'Alle kategorier',
    'brands' => 'Merker',
    'browse_products' => 'Bla gjennom produkter',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Velg produkter som skal returneres',
    'show_only_discounted_products' => 'Vis kun produkter med rabatt',
    'specification' => 'Spesifikasjon',
    'download_product_with_external_links' => 'Last ned produktet ":name" med eksterne lenker',
    'number_product_available_singular' => ':number produkt tilgjengelig',
    'number_products_available_plural' => ':number produkter tilgjengelige',
    'cart' => [
        'added_to_cart_success' => ':product er lagt til i handlekurven din.',
        'removed_from_cart_success' => ':product er fjernet fra handlekurven din.',
        'updated_cart_success' => 'Handlekurven din er oppdatert.',
        'item_not_found' => 'Denne varen er ikke lenger i handlekurven din.',
        'out_of_stock' => 'Beklager, :product er for oyeblikket utsolgt.',
        'max_quantity' => 'Du kan bare legge til opptil :max varer.',
        'max_quantity_detail' => 'Beklager, du kan bare bestille :quantity enheter av :product om gangen.',
        'select_options' => 'Vennligst velg produktalternativer for du legger til i handlekurven.',
        'product_out_of_stock' => 'Beklager, dette produktet er for oyeblikket utsolgt.',
        'product_not_exists' => 'Dette produktet er utsolgt eller eksisterer ikke lenger.',
        'not_enough_quantity' => 'Noen produkter har ikke nok lager til a oppdatere.',
        'empty_success' => 'Handlekurven din er tomt.',
        'bundle_item_already_in_cart' => 'Denne bundelvaren er allerede i handlekurven din. Kun 1 vare per bundelrabatt er tillatt.',
    ],
    'wishlist' => [
        'added_success' => ':product er lagt til i onskelisten din.',
        'removed_success' => ':product er fjernet fra onskelisten din.',
        'product_not_found' => 'Dette produktet ble ikke funnet.',
        'product_not_in_wishlist' => 'Dette produktet er ikke i onskelisten din.',
        'product_not_available' => 'Dette produktet er ikke tilgjengelig.',
    ],
    'compare' => [
        'added_success' => ':product er lagt til i sammenligningslisten din.',
        'removed_success' => ':product er fjernet fra sammenligningslisten din.',
        'product_not_found' => 'Dette produktet ble ikke funnet.',
        'product_not_in_compare' => 'Dette produktet er ikke i sammenligningslisten din.',
        'already_in_list' => ':product er allerede i sammenligningslisten din.',
    ],
];
