<?php

return [
    'name' => '상품',
    'description' => '재고, 가격 및 옵션을 포함한 실물 및 디지털 상품 관리',
    'create' => '새 상품',
    'create_product_type' => [
        'physical' => '새 실물 상품',
        'digital' => '새 디지털 상품',
    ],
    'edit' => '상품 수정 - :name',
    'form' => [
        'name' => '이름',
        'name_placeholder' => '상품명 (최대 120자)',
        'description' => '설명',
        'description_placeholder' => '상품 간단 설명 (최대 400자)',
        'categories' => '카테고리',
        'content' => '내용',
        'price' => '가격',
        'currency' => '통화',
        'currency_for_variations_hint' => '이 통화는 이 상품의 모든 옵션에 적용됩니다.',
        'quantity' => '수량',
        'brand' => '브랜드',
        'width' => '너비',
        'height' => '높이',
        'weight' => '무게',
        'date' => [
            'start' => '시작 날짜',
            'end' => '종료 날짜',
        ],
        'image' => '이미지',
        'collections' => '상품 컬렉션',
        'labels' => '라벨',
        'price_sale' => '할인 가격',
        'product_type' => [
            'title' => '상품 유형',
        ],
        'product' => '상품',
        'total' => '총계',
        'sub_total' => '소계',
        'shipping_fee' => '배송비',
        'discount' => '할인',
        'options' => '옵션',
        'shipping' => [
            'height' => '높이',
            'length' => '길이',
            'title' => '배송',
            'weight' => '무게',
            'wide' => '너비',
        ],
        'barcode' => '바코드 (ISBN, UPC, GTIN 등) ',
        'barcode_placeholder' => '바코드 입력',
        'cost_per_item' => '상품당 비용',
        'cost_per_item_placeholder' => '상품당 비용 입력',
        'cost_per_item_helper' => '고객에게는 이 가격이 표시되지 않습니다.',
        'price_includes_tax' => '가격에 세금 포함',
        'price_includes_tax_helper' => '입력한 가격에 이미 세금이 포함되어 있는 경우 이 항목을 선택하세요. 시스템은 세금 금액을 제거하여 기본 가격을 계산합니다.',
        'stock' => [
            'allow_order_when_out' => '이 상품이 품절일 때 고객 주문 허용',
            'in_stock' => '재고 있음',
            'out_stock' => '품절',
            'title' => '재고 상태',
        ],
        'storehouse' => [
            'no_storehouse' => '창고 관리 없음',
            'storehouse' => '창고 관리 사용',
            'title' => '창고',
            'quantity' => '수량',
        ],
        'tax' => '세금',
        'taxes' => '세금',
        'taxes_helper' => '기본 세율은 <a href=":url">설정 -> 세금</a>에서 구성됩니다. 이 상품에 특정 세금이 선택되지 않으면 기본 세율이 적용됩니다. 이 상품의 세금을 비활성화하려면 세금 설정에서 기본 세율을 제거하세요.',
        'is_default' => '기본값',
        'action' => '작업',
        'restock_quantity' => '재입고 수량',
        'remain' => '남은 수량',
        'choose_discount_period' => '할인 기간 선택',
        'cancel' => '취소',
        'no_results' => '결과 없음!',
        'value' => '값',
        'attribute_name' => '속성명',
        'add_more_attribute' => '속성 추가',
        'continue' => '계속',
        'add_new_attributes' => '새 속성 추가',
        'add_new_attributes_description' => '새 속성을 추가하면 상품에 크기나 색상과 같은 다양한 옵션을 제공할 수 있습니다.',
        'create_product_variations' => '상품 옵션을 생성하려면 :link!',
        'tags' => '태그',
        'write_some_tags' => '태그 입력',
        'variation_existed' => '이 옵션은 이미 존재합니다.',
        'no_attributes_selected' => '선택된 속성이 없습니다!',
        'added_variation_success' => '옵션이 추가되었습니다!',
        'updated_variation_success' => '옵션이 업데이트되었습니다!',
        'created_all_variation_success' => '모든 옵션이 생성되었습니다!',
        'updated_product_attributes_success' => '상품 속성이 업데이트되었습니다!',
        'stock_status' => '재고 상태',
        'auto_generate_sku' => 'SKU 자동 생성?',
        'featured_image' => '대표 이미지 (선택사항)',
        'product_id' => '상품 ID',
        'price_sale_percent_helper' => '원래 가격에서 :percent 할인.',
        'minimum_order_quantity' => '최소 주문 수량',
        'minimum_order_quantity_helper' => '주문 가능한 최소 수량, 값이 0이면 제한이 없습니다.',
        'maximum_order_quantity' => '최대 주문 수량',
        'maximum_order_quantity_helper' => '주문 가능한 최대 수량, 값이 0이면 제한이 없습니다.',
        'video' => '비디오',
        'video_file' => '파일',
        'video_url' => '또는 외부 비디오 URL',
        'video_url_help' => 'YouTube 또는 Vimeo 비디오 URL 입력',
        'enter_video_url' => '비디오 URL 입력',
        'video_thumbnail' => '비디오 썸네일',
        'video_thumbnail_help' => '비디오의 썸네일을 선택하세요. 선택하지 않으면 가능한 경우 비디오 URL에서 자동으로 가져옵니다.',
        'barcode_existed' => '이 바코드는 다른 상품에서 사용 중입니다. 다른 바코드를 입력해주세요.',
        'barcode_helper' => '각 상품마다 고유해야 합니다.',
        'is_new_until' => '신상품 기한',
        'is_new_until_helper' => '이 상품이 "신상품"으로 표시될 날짜를 설정하세요. 날짜 기준으로 신상품으로 표시하지 않으려면 비워두세요.',
    ],
    'price' => '가격',
    'quantity' => '수량',
    'type' => '유형',
    'image' => '썸네일',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => '옵션 SKU',
    'brand' => '브랜드',
    'cannot_delete' => '상품을 삭제할 수 없습니다',
    'product_deleted' => '상품이 삭제되었습니다',
    'product' => '상품',
    'product_collections' => '상품 컬렉션',
    'products' => '상품',
    'total_products_found' => ':total개의 상품이 발견되었습니다',
    'total_product_found' => ':total개의 상품이 발견되었습니다',
    'menu' => '상품',
    'control' => [
        'button_add_image' => '이미지 추가',
    ],
    'price_sale' => '할인 가격',
    'price_group_title' => '상품 가격 관리',
    'store_house_group_title' => '창고 관리',
    'shipping_group_title' => '배송 관리',
    'overview' => '개요',
    'attributes' => '속성',
    'product_has_variations' => '상품에 옵션이 있습니다',
    'manage_products' => '상품 관리',
    'add_new_product' => '새 상품 추가',
    'start_by_adding_new_product' => '새 상품 추가로 시작하세요.',
    'edit_this_product' => '이 상품 수정',
    'delete' => '삭제',
    'related_products' => '관련 상품',
    'cross_selling_products' => '교차 판매 상품',
    'up_selling_products' => '업셀링 상품',
    'grouped_products' => '그룹 상품',
    'search_products' => '상품 검색',
    'selected_products' => '선택된 상품',
    'edit_variation_item' => '수정',
    'variations_box_description' => '"속성 수정"을 클릭하여 옵션의 속성을 추가/제거하거나 "새 옵션 추가"를 클릭하여 옵션을 추가하세요.',
    'save_changes' => '변경사항 저장',
    'continue' => '계속',
    'edit_attribute' => '속성 수정',
    'select_attribute' => '속성 선택',
    'add_new_variation' => '새 옵션 추가',
    'edit_variation' => '옵션 수정',
    'generate_variations' => '옵션 생성',
    'generate_variations_confirmation' => '이 상품의 옵션을 생성하시겠습니까?',
    'delete_variation' => '옵션을 삭제하시겠습니까?',
    'delete_variation_confirmation' => '이 옵션을 삭제하시겠습니까? 이 작업은 취소할 수 없습니다.',
    'delete_variations_confirmation' => '이 옵션들을 삭제하시겠습니까? 이 작업은 취소할 수 없습니다.',
    'product_create_validate_name_required' => '상품명을 입력해주세요',
    'product_create_validate_sale_price_max' => '할인 가격은 원래 가격보다 낮아야 합니다',
    'product_create_validate_cost_per_item_max' => '상품당 비용은 원래 가격보다 낮아야 합니다',
    'product_create_validate_sale_price_required_if' => '프로모션 일정을 설정할 때는 할인 가격을 입력해야 합니다',
    'product_create_validate_end_date_after' => '종료 날짜는 시작 날짜 이후여야 합니다',
    'product_create_validate_start_date_required_if' => '일정이 선택된 경우 할인 시작 날짜를 비워둘 수 없습니다',
    'product_create_validate_sale_price' => '일정이 선택된 경우 할인 가격을 비워둘 수 없습니다',
    'stock_statuses' => [
        'in_stock' => '재고 있음',
        'out_of_stock' => '품절',
        'on_backorder' => '예약 주문 가능',
    ],
    'stock_status' => '재고 상태',
    'processing' => '처리 중...',
    'delete_selected_variations' => '선택한 옵션 삭제',
    'delete_variations' => '옵션 삭제',
    'category' => '카테고리',
    'categories' => '카테고리',
    'tags' => '태그',
    'product_price_flash_sale_warning' => '이 상품은 플래시 세일 <strong>:name</strong>에 포함되어 있으므로 가격은 <strong>:price</strong>입니다.',
    'product_price_discount_warning' => '이 상품은 할인 <strong>:name</strong>에 포함되어 있으므로 가격은 <strong>:price</strong>입니다.',
    'product_image' => '상품 이미지',
    'product_name' => '상품명',
    'product_link' => '상품 링크',
    'types' => [
        'physical' => '실물 상품',
        'digital' => '디지털 상품',
    ],
    'digital_attachments' => [
        'title' => '디지털 첨부파일',
        'add' => '첨부파일 추가',
        'file_name' => '파일명',
        'file_size' => '파일 크기',
        'unsaved' => '저장되지 않음',
        'add_external_link' => '외부 링크 추가',
        'enter_file_name' => '파일명 입력',
        'enter_external_link_download' => '외부 다운로드 링크 입력',
        'enter_file_size' => '파일 크기 입력',
        'external_link_download' => '외부 다운로드 링크',
        'generate_license_code_after_purchasing_product' => '이 상품의 라이선스 코드 할당 활성화',
        'notify_attachment_updated' => '첨부파일이 업데이트되면 고객에게 이메일 전송',
        'no_attachments' => '첨부파일이 없습니다. 위의 버튼을 클릭하여 파일을 추가하세요.',
    ],
    'license_codes' => [
        'title' => '라이선스 코드',
        'add' => '라이선스 코드 추가',
        'back' => '상품으로 돌아가기',
        'edit' => '라이선스 코드 수정',
        'generate' => '코드 생성',
        'manage_codes' => '라이선스 코드 관리',
        'management' => '라이선스 코드 관리',
        'variation_breadcrumb' => '옵션: :name',
        'variation_label' => '상품 옵션',
        'variation_specific_note' => '이 라이선스 코드는 이 상품 옵션에만 적용됩니다. 이 옵션을 구매한 고객은 이 풀에서 코드를 받게 됩니다.',
        'main_product_note' => '이 상품에는 옵션이 있습니다. 각 옵션은 자체 라이선스 코드를 가질 수 있으며, 옵션에 코드가 없는 경우 고객은 이 메인 상품 풀에서 코드를 받을 수 있습니다.',
        'code' => '라이선스 코드',
        'codes' => '라이선스 코드',
        'status' => '상태',
        'assigned_at' => '할당 일시',
        'status_available' => '사용 가능',
        'status_used' => '사용됨',
        'statuses' => [
            'available' => '사용 가능',
            'used' => '사용됨',
        ],
        'no_codes' => '라이선스 코드를 찾을 수 없습니다. 코드를 추가하거나 자동으로 생성하세요.',
        'no_codes_warning_title' => '사용 가능한 라이선스 코드가 없습니다!',
        'no_codes_warning_message' => '이 상품은 "목록에서 선택"으로 설정되어 있지만 사용 가능한 라이선스 코드가 없습니다. 이 상품을 구매하는 고객은 자동 생성된 코드를 받게 됩니다. 적절한 기능을 보장하려면 라이선스 코드를 추가하세요.',
        'no_codes_auto_generate' => '이 상품은 라이선스 코드를 자동 생성하도록 설정되어 있습니다. 수동 코드가 필요하지 않습니다.',
        'used_code_no_actions' => '사용된 코드 - 사용 가능한 작업 없음',
        'created_successfully' => '라이선스 코드가 생성되었습니다!',
        'updated_successfully' => '라이선스 코드가 업데이트되었습니다!',
        'deleted_successfully' => '라이선스 코드가 삭제되었습니다!',
        'generated_successfully' => ':count개의 라이선스 코드가 생성되었습니다!',
        'duplicates_skipped' => ':count개의 중복 코드를 건너뛰었습니다.',
        'generation_incomplete' => '경고: 중복 충돌로 인해 요청된 :requested개 중 :generated개만 생성할 수 있었습니다.',
        'cannot_edit_used_code' => '사용된 라이선스 코드는 수정할 수 없습니다.',
        'cannot_delete_used_code' => '사용된 라이선스 코드는 삭제할 수 없습니다.',
        'show_all' => '모두 표시',
        'show_less' => '간략히 표시',
        'more' => '더보기',
        'used_codes_hidden' => ':count개의 사용된 라이선스 코드가 숨겨져 있습니다. 라이선스 코드 관리 페이지에서 모든 코드를 볼 수 있습니다.',
        'low_stock_title' => '라이선스 코드 재고 부족',
        'low_stock_message' => ':count개의 라이선스 코드만 남아 있습니다. 코드가 부족하지 않도록 더 추가하는 것을 고려하세요.',
        'out_of_stock_title' => '라이선스 코드가 없습니다!',
        'out_of_stock_message' => '사용 가능한 라이선스 코드가 없습니다. 더 추가할 때까지 고객은 자동 생성된 코드를 받게 됩니다.',
        'type' => [
            'title' => '라이선스 코드 할당 방법',
            'auto_generate' => '자동 생성 (시스템이 자동으로 코드 생성)',
            'pick_from_list' => '목록에서 선택 (미리 입력된 코드 사용)',
            'description' => '고객이 이 상품을 구매할 때 라이선스 코드를 어떻게 할당할지 선택하세요.',
        ],
        'add_modal' => [
            'placeholder' => '예: XXXX-XXXX-XXXX-XXXX',
            'help' => '구매 시 고객에게 할당될 고유한 라이선스 코드를 입력하세요.',
        ],
        'generate_modal' => [
            'title' => '라이선스 코드 생성',
            'quantity' => '수량',
            'format' => '형식',
            'custom_pattern' => '사용자 정의 패턴',
            'pattern_help' => '숫자는 #, 대문자는 A, 소문자는 a 사용',
            'generate' => '생성',
        ],
        'errors' => [
            'feature_not_enabled' => '라이선스 코드 기능이 활성화되지 않았습니다. 전자상거래 설정 > 디지털 상품에서 활성화하세요.',
            'digital_products_not_enabled' => '디지털 상품이 활성화되지 않았습니다. 먼저 디지털 상품 지원을 활성화하세요.',
            'product_not_found' => '상품을 찾을 수 없습니다.',
            'not_digital_product' => '라이선스 코드는 디지털 상품에만 사용할 수 있습니다. 이 상품은 실물 상품으로 설정되어 있습니다.',
            'license_codes_not_enabled_for_product' => '이 상품에 라이선스 코드 관리가 활성화되지 않았습니다. 상품 설정에서 "상품 구매 후 라이선스 코드 생성"을 활성화하세요.',
            'cannot_add_codes_auto_generate' => '자동 생성으로 설정된 상품에는 수동으로 라이선스 코드를 추가할 수 없습니다. 먼저 라이선스 코드 유형을 "목록에서 선택"으로 변경하세요.',
            'cannot_generate_codes_auto_generate' => '자동 생성으로 설정된 상품에는 수동으로 라이선스 코드를 생성할 수 없습니다. 먼저 라이선스 코드 유형을 "목록에서 선택"으로 변경하세요.',
        ],
        'bulk_delete' => [
            'button' => '선택 항목 삭제',
            'selected' => '선택됨',
            'confirm' => '선택한 라이선스 코드를 삭제하시겠습니까?',
            'deleted_successfully' => ':count개의 라이선스 코드가 삭제되었습니다.',
            'skipped_used_codes' => ':count개의 사용된 코드를 건너뛰었습니다.',
            'no_deletable_codes' => '삭제 가능한 라이선스 코드가 없습니다. 사용된 코드는 삭제할 수 없습니다.',
        ],
        'import' => [
            'name' => '상품 라이선스 코드 가져오기',
            'description' => 'CSV/Excel 파일에서 디지털 상품의 라이선스 코드를 가져옵니다.',
            'button' => '가져오기',
            'columns' => [
                'product_id' => '상품 ID 또는 SKU',
                'license_code' => '라이선스 코드',
            ],
        ],
        'copied' => '라이선스 코드가 클립보드에 복사되었습니다!',
    ],
    'this_action_will_reload_page' => '이 작업은 데이터를 업데이트하기 위해 페이지를 새로고침합니다!',
    'select' => '선택',
    'clear_filters' => '필터 지우기',
    'set_this_variant_as_default' => '이 옵션을 기본값으로 설정',
    'download' => '다운로드',
    'external_link_downloads' => '외부 링크',
    'download_available_when_completed' => '주문이 완료되면 다운로드 링크를 사용할 수 있습니다.',
    'cross_sell_price_type' => [
        'title' => '가격 유형',
        'fixed' => '고정',
        'percent' => '백분율',
    ],
    'cross_sell_help' => [
        'price' => '* 가격 필드',
        'price_description' => '원래 가격에서 줄이려는 금액을 입력하세요. 예: 원래 가격이 $100인 경우 20을 입력하면 가격이 $80로 줄어듭니다.',
        'type' => '* 유형 필드',
        'type_description' => '할인 유형을 선택하세요: 고정 (특정 금액 할인) 또는 백분율 (백분율로 할인).',
    ],
    'up_sell_price_type' => [
        'title' => '가격 유형',
        'fixed' => '고정',
        'percent' => '백분율',
    ],
    'up_sell_help' => [
        'price' => '* 가격 필드',
        'price_description' => '원래 가격에서 줄이려는 금액을 입력하세요. 예: 원래 가격이 $100인 경우 20을 입력하면 가격이 $80로 줄어듭니다.',
        'type' => '* 유형 필드',
        'type_description' => '할인 유형을 선택하세요: 고정 (특정 금액 할인) 또는 백분율 (백분율로 할인).',
    ],
    'up_sale' => [
        'title' => '함께 구매하고 절약하세요',
        'description' => '이 상품들을 함께 구매하면 특별 할인을 받으세요',
        'unlock_discount' => ':product을(를) 장바구니에 추가하여 번들 할인 잠금 해제',
        'multiple_options' => '다양한 옵션',
        'multiple_options_available' => '다양한 옵션 사용 가능',
        'select' => '선택',
        'selected_items_total' => '선택한 상품 합계:',
        'add_selected_to_cart' => '선택 상품 장바구니에 추가',
        'bundle_discount_with' => ':product과(와) 번들 할인',
        'bundle_with' => ':product과(와) 번들',
    ],
    'cross_sale' => [
        'title' => '함께 자주 구매하는 상품',
        'description' => '이 상품을 본 고객이 구매한 상품',
    ],
    'apply_for_all_variations' => '모든 옵션에 적용',
    'export' => [
        'description' => '상품 데이터를 CSV 또는 Excel 파일로 내보내기.',
        'total_items' => '총 항목',
        'total_products' => '총 상품',
        'total_variations' => '총 옵션',
        'advanced_options' => '고급 옵션',
        'use_chunked_export' => '청크 내보내기 사용',
        'use_chunked_export_helper' => '대량 데이터셋을 효율적으로 처리하기 위해 데이터를 청크로 처리',
        'include_variations' => '상품 옵션 포함',
        'include_variations_helper' => '메인 상품과 함께 상품 옵션 내보내기',
        'optimize_memory' => '메모리 사용 최적화',
        'optimize_memory_helper' => '매우 큰 내보내기를 위한 메모리 최적화 활성화',
        'chunk_size' => '청크 크기',
        'chunk_size_helper' => '한 번에 처리할 상품 수 (50-5000)',
        'use_streaming' => '스트리밍 내보내기 사용',
        'use_streaming_helper' => '매우 큰 데이터셋에 스트리밍 활성화 (10,000개 이상 항목에 대해 자동 활성화)',
        'large_dataset_warning_title' => '대량 상품 카탈로그 감지됨',
        'large_dataset_warning_message' => '카탈로그에 :count개의 항목이 포함되어 있습니다. 대량 크기로 인해 일부 내보내기 옵션이 최상의 성능을 위해 최적화되었습니다.',
        'large_dataset_specific_message' => ':count개의 상품에 대해 스트리밍을 활성화한 CSV 형식을 사용하세요. 이제 시스템은 시간 초과나 메모리 문제 없이 대량 상품 카탈로그를 효율적으로 처리할 수 있습니다.',
        'format_label' => '형식',
        'csv_recommended' => 'CSV (필수)',
        'chunk_label' => '처리',
        'chunk_recommended' => '배치당 300개 상품',
        'time_label' => '예상 시간',
        'time_estimate' => '1-3분',
        'pro_tip' => '프로 팁:',
        'pro_tip_message' => '브라우저에 로딩 표시기가 표시되더라도 내보내기가 계속 실행됩니다. 시작되면 다운로드가 자동으로 시작됩니다.',
        'large_dataset_tip_1' => 'Excel 형식이 비활성화되었습니다 - 더 빠르고 안정적인 내보내기를 위해 CSV 형식 사용',
        'large_dataset_tip_2' => '시간 초과를 방지하기 위해 스트리밍 모드가 자동으로 활성화되었습니다',
        'large_dataset_tip_3' => '서버에 따라 내보내기 프로세스가 1-3분 소요될 수 있습니다',
        'large_dataset_recommendation' => '권장 사항: 최적의 성능을 위해 200-500 청크 크기의 CSV 형식을 사용하세요.',
        'excel_disabled_for_large_export' => '10,000개 이상의 항목이 있는 카탈로그에는 Excel 형식을 사용할 수 없습니다',
        'streaming_auto_enabled' => '대량 데이터셋의 최적 성능을 위해 스트리밍 모드가 자동으로 활성화되었습니다.',
        'streaming_enabled_title' => '대량 내보내기 최적화됨',
        'streaming_enabled_message' => '메모리 문제 없이 원활한 내보내기를 보장하기 위해 스트리밍 모드가 활성화되었습니다.',
        'use_multi_file' => '다중 파일 내보내기 사용',
        'use_multi_file_helper' => '매우 큰 데이터셋의 경우 내보내기를 ZIP으로 패키징된 여러 파일로 분할',
        'multi_file_enabled_title' => '다중 파일 내보내기 활성화됨',
        'multi_file_enabled_message' => '최적의 성능을 위해 내보내기가 :count개의 파일로 분할되어 ZIP으로 패키징됩니다.',
        'records_per_file' => '파일당 레코드',
        'records_per_file_helper' => '다중 파일 내보내기 사용 시 각 파일의 레코드 수',
        'estimated_files' => '예상 파일 수',
        'recommended_range' => '권장 범위',
        'range_large_export' => '200-500개 항목',
        'range_medium_export' => '300-800개 항목',
        'range_small_export' => '500-1000개 항목',
        'export_progress' => '내보내기 진행률',
        'preparing_export' => '내보내기 준비 중...',
        'items_processed' => ':count개 항목 처리됨',
        'estimated_time_calculating' => '예상 시간: 계산 중...',
        'medium_dataset_detected' => '중간 데이터셋 감지됨',
        'medium_dataset_message' => ':count개의 상품을 내보내고 있습니다. 더 나은 성능을 위해 청크 내보내기 사용을 고려하세요.',
        'optimal_range' => '최적 범위',
        'too_small_slow' => '너무 작음 - 느릴 수 있음',
        'too_large_timeouts' => '너무 큼 - 시간 초과가 발생할 수 있음',
        'excel_disabled_warning' => '대량 내보내기(:count개 항목)에 대해 Excel 형식 비활성화됨',
        'starting_export' => '내보내기 시작 중...',
        'processing_data' => '데이터 처리 중...',
        'finalizing_export' => '내보내기 완료 중...',
        'items_processed_suffix' => '개 항목 처리됨',
        'estimated_time_prefix' => '예상 시간:',
        'seconds_remaining' => '초 남음',
        'export_completed' => '내보내기 완료!',
        'download_starting' => '다운로드 시작 중...',
    ],
    'import' => [
        'description' => 'CSV 또는 Excel 파일에서 상품 데이터 가져오기.',
        'rules' => [
            'in' => ':attribute은(는) 정의된 값 중 하나여야 합니다: :values.',
            'required_string_max' => ':attribute은(는) 필수이며 최대 :max자의 문자열이어야 합니다.',
            'nullable_string' => ':attribute은(는) 비워두거나 제공된 경우 문자열이어야 합니다.',
            'nullable_string_max' => ':attribute은(는) 비워두거나 제공된 경우 최대 :max자의 문자열이어야 합니다',
            'nullable_bool' => ':attribute은(는) 비워두거나 제공된 경우 부울 값이어야 합니다.',
            'nullable_numeric_min' => ':attribute은(는) 비워두거나 제공된 경우 0 이상의 숫자여야 합니다.',
            'nullable_numeric_min_max' => ':attribute은(는) 비워두거나 제공된 경우 :min과 :max 사이의 숫자여야 합니다.',
            'nullable_array' => ':attribute은(는) 비워두거나 지정된 경우 배열로 제공되어야 합니다.',
            'nullable_date_required_if' => ':attribute은(는) 비워두거나 제공된 경우 유효한 날짜여야 하며, :required이(가) 지정된 경우 필수입니다.',
            'nullable_date_after' => ':attribute은(는) 비워두거나 제공된 경우 :after 이후의 유효한 날짜여야 합니다.',
        ],
        'updated_message' => ':count개의 상품이 업데이트되었습니다!',
    ],
    'import_products_intro' => '또는 CSV/Excel에서 상품 가져오기',
    'select_attributes' => '옵션을 만들 속성 선택:',
    'all' => '전체',
    'copy' => '복사',
    'product_translations' => '상품 번역',
    'view' => '상품 보기 - :name',
    'product_information' => '상품 정보',
    'total_views' => '총 조회수',
    'total_orders' => '완료된 주문',
    'total_sold' => '총 판매량',
    'total_revenue' => '총 수익',
    'pending_orders' => '대기 중인 주문',
    'pending_revenue' => '대기 중인 수익',
    'conversion_rate' => '전환율',
    'total_reviews' => '총 리뷰 수',
    'average_rating' => '평균 평점',
    'views_by_date' => '날짜별 조회수 (최근 30일)',
    'recent_orders' => '최근 주문',
    'no_views_data' => '최근 30일간 조회 데이터가 없습니다.',
    'no_orders' => '아직 주문이 없습니다.',
    'date' => '날짜',
    'views' => '조회수',
    'total' => '합계',
    'view_on_frontend' => '프론트엔드에서 보기',
    'select_attribute' => ':name 선택',
    'all_categories' => '전체 카테고리',
    'brands' => '브랜드',
    'browse_products' => '상품 둘러보기',
    'sku_1' => 'SKU:',
    'select_products_to_return' => '반품할 상품 선택',
    'show_only_discounted_products' => '할인 상품만 표시',
    'specification' => '사양',
    'download_product_with_external_links' => '외부 링크가 포함된 ":name" 상품을 다운로드',
    'number_product_available_singular' => ':number개의 상품 이용 가능',
    'number_products_available_plural' => ':number개의 상품 이용 가능',
    'cart' => [
        'added_to_cart_success' => ':product이(가) 장바구니에 추가되었습니다.',
        'removed_from_cart_success' => ':product이(가) 장바구니에서 제거되었습니다.',
        'updated_cart_success' => '장바구니가 업데이트되었습니다.',
        'item_not_found' => '이 상품은 더 이상 장바구니에 없습니다.',
        'out_of_stock' => '죄송합니다. :product은(는) 현재 품절입니다.',
        'max_quantity' => '최대 :max개까지만 추가할 수 있습니다.',
        'max_quantity_detail' => '죄송합니다. :product은(는) 한 번에 :quantity개까지만 주문할 수 있습니다.',
        'select_options' => '장바구니에 추가하기 전에 상품 옵션을 선택하세요.',
        'product_out_of_stock' => '죄송합니다. 이 상품은 현재 품절입니다.',
        'product_not_exists' => '이 상품은 품절되었거나 존재하지 않습니다.',
        'not_enough_quantity' => '일부 상품의 재고가 부족하여 업데이트할 수 없습니다.',
        'empty_success' => '장바구니가 비워졌습니다.',
        'bundle_item_already_in_cart' => '이 번들 상품은 이미 장바구니에 있습니다. 번들 할인당 1개 상품만 허용됩니다.',
    ],
    'wishlist' => [
        'added_success' => ':product이(가) 위시리스트에 추가되었습니다.',
        'removed_success' => ':product이(가) 위시리스트에서 제거되었습니다.',
        'product_not_found' => '이 상품을 찾을 수 없습니다.',
        'product_not_in_wishlist' => '이 상품은 위시리스트에 없습니다.',
        'product_not_available' => '이 상품은 이용할 수 없습니다.',
    ],
    'compare' => [
        'added_success' => ':product이(가) 비교 목록에 추가되었습니다.',
        'removed_success' => ':product이(가) 비교 목록에서 제거되었습니다.',
        'product_not_found' => '이 상품을 찾을 수 없습니다.',
        'product_not_in_compare' => '이 상품은 비교 목록에 없습니다.',
        'already_in_list' => ':product은(는) 이미 비교 목록에 있습니다.',
    ],
];
