<?php

return [
    'name' => 'პროდუქტები',
    'description' => 'მართეთ ფიზიკური და ციფრული პროდუქტები მარაგით, ფასებით და ვარიაციებით',
    'create' => 'ახალი პროდუქტი',
    'create_product_type' => [
        'physical' => 'ახალი ფიზიკური პროდუქტი',
        'digital' => 'ახალი ციფრული პროდუქტი',
    ],
    'edit' => 'პროდუქტის რედაქტირება - :name',
    'form' => [
        'name' => 'სახელი',
        'name_placeholder' => 'პროდუქტის სახელი (მაქსიმუმ 120 სიმბოლო)',
        'description' => 'აღწერა',
        'description_placeholder' => 'პროდუქტის მოკლე აღწერა (მაქსიმუმ 400 სიმბოლო)',
        'categories' => 'კატეგორიები',
        'content' => 'კონტენტი',
        'price' => 'ფასი',
        'currency' => 'ვალუტა',
        'currency_for_variations_hint' => 'ეს ვალუტა გამოყენებული იქნება ამ პროდუქტის ყველა ვარიაციისთვის.',
        'quantity' => 'რაოდენობა',
        'brand' => 'ბრენდი',
        'width' => 'სიგანე',
        'height' => 'სიმაღლე',
        'weight' => 'წონა',
        'date' => [
            'start' => 'თარიღიდან',
            'end' => 'თარიღამდე',
        ],
        'image' => 'სურათები',
        'collections' => 'პროდუქტის კოლექციები',
        'labels' => 'ლეიბლები',
        'price_sale' => 'ფასდაკლებული ფასი',
        'product_type' => [
            'title' => 'პროდუქტის ტიპი',
        ],
        'product' => 'პროდუქტი',
        'total' => 'სულ',
        'sub_total' => 'ქვეჯამი',
        'shipping_fee' => 'მიწოდების საფასური',
        'discount' => 'ფასდაკლება',
        'options' => 'ვარიანტები',
        'shipping' => [
            'height' => 'სიმაღლე',
            'length' => 'სიგრძე',
            'title' => 'მიწოდება',
            'weight' => 'წონა',
            'wide' => 'სიგანე',
        ],
        'barcode' => 'შტრიხკოდი (ISBN, UPC, GTIN და ა.შ.) ',
        'barcode_placeholder' => 'შეიყვანეთ შტრიხკოდი',
        'cost_per_item' => 'თვითღირებულება ერთეულზე',
        'cost_per_item_placeholder' => 'შეიყვანეთ თვითღირებულება ერთეულზე',
        'cost_per_item_helper' => 'მომხმარებლები არ დაინახავენ ამ ფასს.',
        'price_includes_tax' => 'ფასი მოიცავს გადასახადს',
        'price_includes_tax_helper' => 'მონიშნეთ ეს, თუ შეყვანილი ფასი უკვე შეიცავს გადასახადებს. სისტემა გამოთვლის საბაზო ფასს გადასახადის თანხის გამოკლებით.',
        'stock' => [
            'allow_order_when_out' => 'მომხმარებელს შეუძლია შეკვეთა, როდესაც ეს პროდუქტი არ არის მარაგში',
            'in_stock' => 'მარაგშია',
            'out_stock' => 'არ არის მარაგში',
            'title' => 'მარაგის სტატუსი',
        ],
        'storehouse' => [
            'no_storehouse' => 'საწყობის მართვის გარეშე',
            'storehouse' => 'საწყობის მართვით',
            'title' => 'საწყობი',
            'quantity' => 'რაოდენობა',
        ],
        'tax' => 'გადასახადი',
        'taxes' => 'გადასახადები',
        'taxes_helper' => 'ნაგულისხმევი გადასახადის განაკვეთი კონფიგურირებულია <a href=":url">პარამეტრები -> გადასახადი</a>-ში. თუ ამ პროდუქტისთვის კონკრეტული გადასახადი არ არის არჩეული, გამოყენებული იქნება ნაგულისხმევი განაკვეთი. ამ პროდუქტისთვის გადასახადის გამორთვისთვის, წაშალეთ ნაგულისხმევი გადასახადის განაკვეთი გადასახადის პარამეტრებიდან.',
        'is_default' => 'ნაგულისხმევია',
        'action' => 'მოქმედება',
        'restock_quantity' => 'მარაგის შევსების რაოდენობა',
        'remain' => 'დარჩენილი',
        'choose_discount_period' => 'აირჩიეთ ფასდაკლების პერიოდი',
        'cancel' => 'გაუქმება',
        'no_results' => 'შედეგები არ მოიძებნა!',
        'value' => 'მნიშვნელობა',
        'attribute_name' => 'ატრიბუტის სახელი',
        'add_more_attribute' => 'დაამატეთ მეტი ატრიბუტი',
        'continue' => 'გაგრძელება',
        'add_new_attributes' => 'ახალი ატრიბუტების დამატება',
        'add_new_attributes_description' => 'ახალი ატრიბუტების დამატება ეხმარება პროდუქტს ჰქონდეს მრავალი ვარიანტი, როგორიცაა ზომა ან ფერი.',
        'create_product_variations' => ':link პროდუქტის ვარიაციების შესაქმნელად!',
        'tags' => 'ტეგები',
        'write_some_tags' => 'დაწერეთ რამდენიმე ტეგი',
        'variation_existed' => 'ეს ვარიაცია უკვე არსებობს.',
        'no_attributes_selected' => 'ატრიბუტები არ არის არჩეული!',
        'added_variation_success' => 'ვარიაცია წარმატებით დაემატა!',
        'updated_variation_success' => 'ვარიაცია წარმატებით განახლდა!',
        'created_all_variation_success' => 'ყველა ვარიაცია წარმატებით შეიქმნა!',
        'updated_product_attributes_success' => 'პროდუქტის ატრიბუტები წარმატებით განახლდა!',
        'stock_status' => 'მარაგის სტატუსი',
        'auto_generate_sku' => 'ავტომატურად გენერირდეს SKU?',
        'featured_image' => 'მთავარი სურათი (არასავალდებულო)',
        'product_id' => 'პროდუქტის ID',
        'price_sale_percent_helper' => 'ფასდაკლება :percent ორიგინალური ფასიდან.',
        'minimum_order_quantity' => 'მინიმალური შეკვეთის რაოდენობა',
        'minimum_order_quantity_helper' => 'მინიმალური რაოდენობა შეკვეთის განსათავსებლად, თუ მნიშვნელობა 0-ია, შეზღუდვა არ არის.',
        'maximum_order_quantity' => 'მაქსიმალური შეკვეთის რაოდენობა',
        'maximum_order_quantity_helper' => 'მაქსიმალური რაოდენობა შეკვეთის განსათავსებლად, თუ მნიშვნელობა 0-ია, შეზღუდვა არ არის.',
        'video' => 'ვიდეო',
        'video_file' => 'ფაილი',
        'video_url' => 'ან გარე ვიდეოს URL',
        'video_url_help' => 'შეიყვანეთ YouTube ან Vimeo ვიდეოს URL',
        'enter_video_url' => 'შეიყვანეთ ვიდეოს URL',
        'video_thumbnail' => 'ვიდეოს მინიატურა',
        'video_thumbnail_help' => 'აირჩიეთ მინიატურა ვიდეოსთვის. თუ არ არის არჩეული, ის ავტომატურად მიიღება ვიდეოს URL-დან, თუ ხელმისაწვდომია.',
        'barcode_existed' => 'ეს შტრიხკოდი გამოიყენება სხვა პროდუქტის მიერ. გთხოვთ შეიყვანოთ სხვა შტრიხკოდი.',
        'barcode_helper' => 'უნდა იყოს უნიკალური თითოეული პროდუქტისთვის.',
        'is_new_until' => 'ახალია მდე',
        'is_new_until_helper' => 'დააყენეთ თარიღი, რომლის ჩათვლით ეს პროდუქტი მონიშნული იქნება როგორც "ახალი". დატოვეთ ცარიელი, რომ თარიღის მიხედვით არ მოინიშნოს როგორც ახალი.',
    ],
    'price' => 'ფასი',
    'quantity' => 'რაოდენობა',
    'type' => 'ტიპი',
    'image' => 'მინიატურა',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'ვარიაციის SKU',
    'brand' => 'ბრენდი',
    'cannot_delete' => 'პროდუქტი ვერ წაიშალა',
    'product_deleted' => 'პროდუქტი წაშლილია',
    'product' => 'პროდუქტი',
    'product_collections' => 'პროდუქტის კოლექციები',
    'products' => 'პროდუქტები',
    'total_products_found' => ':total პროდუქტი ნაპოვნია',
    'total_product_found' => ':total პროდუქტი ნაპოვნია',
    'menu' => 'პროდუქტები',
    'control' => [
        'button_add_image' => 'სურათის დამატება',
    ],
    'price_sale' => 'ფასდაკლებული ფასი',
    'price_group_title' => 'პროდუქტის ფასის მართვა',
    'store_house_group_title' => 'საწყობის მართვა',
    'shipping_group_title' => 'მიწოდების მართვა',
    'overview' => 'მიმოხილვა',
    'attributes' => 'ატრიბუტები',
    'product_has_variations' => 'პროდუქტს აქვს ვარიაციები',
    'manage_products' => 'პროდუქტების მართვა',
    'add_new_product' => 'ახალი პროდუქტის დამატება',
    'start_by_adding_new_product' => 'დაიწყეთ ახალი პროდუქტების დამატებით.',
    'edit_this_product' => 'ამ პროდუქტის რედაქტირება',
    'delete' => 'წაშლა',
    'related_products' => 'დაკავშირებული პროდუქტები',
    'cross_selling_products' => 'ჯვარედინი გაყიდვის პროდუქტები',
    'up_selling_products' => 'აპსელინგ პროდუქტები',
    'grouped_products' => 'დაჯგუფებული პროდუქტები',
    'search_products' => 'პროდუქტების ძიება',
    'selected_products' => 'არჩეული პროდუქტები',
    'edit_variation_item' => 'რედაქტირება',
    'variations_box_description' => 'დააწკაპუნეთ "ატრიბუტის რედაქტირება" ვარიაციის ატრიბუტების დასამატებლად/წასაშლელად ან დააწკაპუნეთ "ახალი ვარიაციის დამატება" ვარიაციის დასამატებლად.',
    'save_changes' => 'ცვლილებების შენახვა',
    'continue' => 'გაგრძელება',
    'edit_attribute' => 'ატრიბუტის რედაქტირება',
    'select_attribute' => 'ატრიბუტის არჩევა',
    'add_new_variation' => 'ახალი ვარიაციის დამატება',
    'edit_variation' => 'ვარიაციის რედაქტირება',
    'generate_variations' => 'ვარიაციების გენერაცია',
    'generate_variations_confirmation' => 'დარწმუნებული ხართ, რომ გსურთ ვარიაციების გენერაცია ამ პროდუქტისთვის?',
    'delete_variation' => 'წავშალოთ ვარიაცია?',
    'delete_variation_confirmation' => 'დარწმუნებული ხართ, რომ გსურთ ამ ვარიაციის წაშლა? ეს მოქმედება ვერ გაუქმდება.',
    'delete_variations_confirmation' => 'დარწმუნებული ხართ, რომ გსურთ ამ ვარიაციების წაშლა? ეს მოქმედება ვერ გაუქმდება.',
    'product_create_validate_name_required' => 'გთხოვთ შეიყვანოთ პროდუქტის სახელი',
    'product_create_validate_sale_price_max' => 'ფასდაკლება უნდა იყოს ორიგინალურ ფასზე ნაკლები',
    'product_create_validate_cost_per_item_max' => 'თვითღირებულება ერთეულზე უნდა იყოს ორიგინალურ ფასზე ნაკლები',
    'product_create_validate_sale_price_required_if' => 'აუცილებელია შეიყვანოთ ფასდაკლება, როდესაც გსურთ აქციის დაგეგმვა',
    'product_create_validate_end_date_after' => 'დასრულების თარიღი უნდა იყოს დაწყების თარიღის შემდეგ',
    'product_create_validate_start_date_required_if' => 'ფასდაკლების დაწყების თარიღი არ შეიძლება იყოს ცარიელი, როდესაც დაგეგმვა არჩეულია',
    'product_create_validate_sale_price' => 'ფასდაკლება არ შეიძლება იყოს ცარიელი, როდესაც დაგეგმვა არჩეულია',
    'stock_statuses' => [
        'in_stock' => 'მარაგშია',
        'out_of_stock' => 'მარაგში არ არის',
        'on_backorder' => 'წინასწარი შეკვეთით',
    ],
    'stock_status' => 'მარაგის სტატუსი',
    'processing' => 'მუშავდება...',
    'delete_selected_variations' => 'არჩეული ვარიაციების წაშლა',
    'delete_variations' => 'ვარიაციების წაშლა',
    'category' => 'კატეგორია',
    'categories' => 'კატეგორიები',
    'tags' => 'ტეგები',
    'product_price_flash_sale_warning' => 'ეს პროდუქტი მონაწილეობს ფლეშ გაყიდვაში <strong>:name</strong> ამიტომ მისი ფასია <strong>:price</strong>.',
    'product_price_discount_warning' => 'ეს პროდუქტი მონაწილეობს ფასდაკლებაში <strong>:name</strong> ამიტომ მისი ფასია <strong>:price</strong>.',
    'product_image' => 'პროდუქტის სურათი',
    'product_name' => 'პროდუქტის სახელი',
    'product_link' => 'პროდუქტის ბმული',
    'types' => [
        'physical' => 'ფიზიკური',
        'digital' => 'ციფრული',
    ],
    'digital_attachments' => [
        'title' => 'ციფრული დანართები',
        'add' => 'დანართის დამატება',
        'file_name' => 'ფაილის სახელი',
        'file_size' => 'ფაილის ზომა',
        'unsaved' => 'შეუნახავი',
        'add_external_link' => 'გარე ბმულის დამატება',
        'enter_file_name' => 'შეიყვანეთ ფაილის სახელი',
        'enter_external_link_download' => 'შეიყვანეთ გარე ჩამოტვირთვის ბმული',
        'enter_file_size' => 'შეიყვანეთ ფაილის ზომა',
        'external_link_download' => 'გარე ჩამოტვირთვის ბმული',
        'generate_license_code_after_purchasing_product' => 'ამ პროდუქტისთვის ლიცენზიის კოდის მინიჭების ჩართვა',
        'notify_attachment_updated' => 'გაუგზავნეთ ელფოსტა მომხმარებელს, როდესაც დანართი განახლდება',
        'no_attachments' => 'ჯერ არ არის დანართები. ფაილების დასამატებლად დააწკაპუნეთ ზემოთ მოცემულ ღილაკებზე.',
    ],
    'license_codes' => [
        'title' => 'ლიცენზიის კოდები',
        'add' => 'ლიცენზიის კოდის დამატება',
        'back' => 'პროდუქტთან დაბრუნება',
        'edit' => 'ლიცენზიის კოდის რედაქტირება',
        'generate' => 'კოდების გენერაცია',
        'manage_codes' => 'ლიცენზიის კოდების მართვა',
        'management' => 'ლიცენზიის კოდების მართვა',
        'variation_breadcrumb' => 'ვარიაცია: :name',
        'variation_label' => 'პროდუქტის ვარიაცია',
        'variation_specific_note' => 'ეს ლიცენზიის კოდები სპეციფიკურია ამ პროდუქტის ვარიაციისთვის. მომხმარებლები, რომლებიც შეიძენენ ამ ვარიაციას, მიიღებენ კოდებს ამ ჯგუფიდან.',
        'main_product_note' => 'ამ პროდუქტს აქვს ვარიაციები. თითოეულ ვარიაციას შეიძლება ჰქონდეს საკუთარი ლიცენზიის კოდები, ან მომხმარებლებს შეუძლიათ მიიღონ კოდები ამ მთავარი პროდუქტის ჯგუფიდან, თუ ვარიაციას არ აქვს კოდები.',
        'code' => 'ლიცენზიის კოდი',
        'codes' => 'ლიცენზიის კოდები',
        'status' => 'სტატუსი',
        'assigned_at' => 'მინიჭებულია',
        'status_available' => 'ხელმისაწვდომი',
        'status_used' => 'გამოყენებული',
        'statuses' => [
            'available' => 'ხელმისაწვდომი',
            'used' => 'გამოყენებული',
        ],
        'no_codes' => 'ლიცენზიის კოდები ვერ მოიძებნა. დაამატეთ რამდენიმე კოდი ან გენერირეთ ისინი ავტომატურად.',
        'no_codes_warning_title' => 'ლიცენზიის კოდები არ არის ხელმისაწვდომი!',
        'no_codes_warning_message' => 'ეს პროდუქტი დაყენებულია "სიიდან არჩევით", მაგრამ არ აქვს ხელმისაწვდომი ლიცენზიის კოდები. მომხმარებლები, რომლებიც შეიძენენ ამ პროდუქტს, მიიღებენ ავტომატურად გენერირებულ კოდებს. გთხოვთ დაამატოთ ლიცენზიის კოდები სწორი ფუნქციონირების უზრუნველსაყოფად.',
        'no_codes_auto_generate' => 'ეს პროდუქტი დაყენებულია ლიცენზიის კოდების ავტომატური გენერაციისთვის. ხელით კოდების დამატება არ არის საჭირო.',
        'used_code_no_actions' => 'გამოყენებული კოდი - მოქმედებები არ არის ხელმისაწვდომი',
        'created_successfully' => 'ლიცენზიის კოდი წარმატებით შეიქმნა!',
        'updated_successfully' => 'ლიცენზიის კოდი წარმატებით განახლდა!',
        'deleted_successfully' => 'ლიცენზიის კოდი წარმატებით წაიშალა!',
        'generated_successfully' => 'წარმატებით გენერირდა :count ლიცენზიის კოდი!',
        'duplicates_skipped' => ':count დუბლიკატი კოდი გამოტოვებულია.',
        'generation_incomplete' => 'გაფრთხილება: მხოლოდ :generated გენერირდა :requested მოთხოვნილი კოდიდან დუბლიკატური კონფლიქტების გამო.',
        'cannot_edit_used_code' => 'გამოყენებული ლიცენზიის კოდის რედაქტირება შეუძლებელია.',
        'cannot_delete_used_code' => 'გამოყენებული ლიცენზიის კოდის წაშლა შეუძლებელია.',
        'show_all' => 'ყველას ნახვა',
        'show_less' => 'ნაკლების ნახვა',
        'more' => 'მეტი',
        'used_codes_hidden' => ':count გამოყენებული ლიცენზიის კოდ(ებ)ი დამალულია. შეგიძლიათ ნახოთ ყველა კოდი ლიცენზიის კოდის მართვის გვერდზე.',
        'low_stock_title' => 'ლიცენზიის კოდების დაბალი მარაგი',
        'low_stock_message' => 'მხოლოდ :count ლიცენზიის კოდი დარჩა. განიხილეთ მეტი კოდის დამატება, რათა თავიდან აიცილოთ ამოწურვა.',
        'out_of_stock_title' => 'ლიცენზიის კოდები ამოწურულია!',
        'out_of_stock_message' => 'ლიცენზიის კოდები არ არის ხელმისაწვდომი. მომხმარებლები მიიღებენ ავტომატურად გენერირებულ კოდებს, სანამ არ დაამატებთ მეტს.',
        'type' => [
            'title' => 'ლიცენზიის კოდის მინიჭების მეთოდი',
            'auto_generate' => 'ავტომატური გენერაცია (სისტემა ავტომატურად გენერირებს კოდებს)',
            'pick_from_list' => 'სიიდან არჩევა (წინასწარ შეყვანილი კოდების გამოყენება)',
            'description' => 'აირჩიეთ როგორ უნდა მინიჭდეს ლიცენზიის კოდები მომხმარებლებს ამ პროდუქტის შეძენისას.',
        ],
        'add_modal' => [
            'placeholder' => 'მაგ., XXXX-XXXX-XXXX-XXXX',
            'help' => 'შეიყვანეთ უნიკალური ლიცენზიის კოდი, რომელიც მომხმარებელს მიენიჭება შეძენისას.',
        ],
        'generate_modal' => [
            'title' => 'ლიცენზიის კოდების გენერაცია',
            'quantity' => 'რაოდენობა',
            'format' => 'ფორმატი',
            'custom_pattern' => 'მორგებული შაბლონი',
            'pattern_help' => 'გამოიყენეთ # ციფრებისთვის, A დიდი ასოებისთვის, a პატარა ასოებისთვის',
            'generate' => 'გენერაცია',
        ],
        'errors' => [
            'feature_not_enabled' => 'ლიცენზიის კოდების ფუნქცია არ არის ჩართული. გთხოვთ ჩართეთ ის ელექტრონული კომერციის პარამეტრები > ციფრული პროდუქტებში.',
            'digital_products_not_enabled' => 'ციფრული პროდუქტები არ არის ჩართული. გთხოვთ ჯერ ჩართეთ ციფრული პროდუქტების მხარდაჭერა.',
            'product_not_found' => 'პროდუქტი ვერ მოიძებნა.',
            'not_digital_product' => 'ლიცენზიის კოდები ხელმისაწვდომია მხოლოდ ციფრული პროდუქტებისთვის. ეს პროდუქტი დაყენებულია როგორც ფიზიკური პროდუქტი.',
            'license_codes_not_enabled_for_product' => 'ლიცენზიის კოდის მართვა არ არის ჩართული ამ პროდუქტისთვის. გთხოვთ ჩართეთ "ლიცენზიის კოდის გენერაცია პროდუქტის შეძენის შემდეგ" პროდუქტის პარამეტრებში.',
            'cannot_add_codes_auto_generate' => 'ლიცენზიის კოდების ხელით დამატება შეუძლებელია პროდუქტებისთვის, რომლებიც დაყენებულია ავტომატური გენერაციისთვის. ჯერ შეცვალეთ ლიცენზიის კოდის ტიპი "სიიდან არჩევით".',
            'cannot_generate_codes_auto_generate' => 'ლიცენზიის კოდების ხელით გენერაცია შეუძლებელია პროდუქტებისთვის, რომლებიც დაყენებულია ავტომატური გენერაციისთვის. ჯერ შეცვალეთ ლიცენზიის კოდის ტიპი "სიიდან არჩევით".',
        ],
        'bulk_delete' => [
            'button' => 'არჩეულის წაშლა',
            'selected' => 'არჩეულია',
            'confirm' => 'დარწმუნებული ხართ, რომ გსურთ არჩეული ლიცენზიის კოდების წაშლა?',
            'deleted_successfully' => 'წარმატებით წაიშალა :count ლიცენზიის კოდ(ებ)ი.',
            'skipped_used_codes' => ':count გამოყენებული კოდ(ებ)ი გამოტოვებულია.',
            'no_deletable_codes' => 'წასაშლელი ხელმისაწვდომი ლიცენზიის კოდები ვერ მოიძებნა. გამოყენებული კოდები ვერ წაიშლება.',
        ],
        'import' => [
            'name' => 'პროდუქტის ლიცენზიის კოდების იმპორტი',
            'description' => 'ციფრული პროდუქტების ლიცენზიის კოდების იმპორტი CSV/Excel ფაილიდან.',
            'button' => 'იმპორტი',
            'columns' => [
                'product_id' => 'პროდუქტის ID ან SKU',
                'license_code' => 'ლიცენზიის კოდი',
            ],
        ],
        'copied' => 'ლიცენზიის კოდი დაკოპირდა!',
    ],
    'this_action_will_reload_page' => 'ეს მოქმედება გადატვირთავს გვერდს მონაცემების განახლებისთვის!',
    'select' => 'არჩევა',
    'clear_filters' => 'ფილტრების გასუფთავება',
    'set_this_variant_as_default' => 'დააყენეთ ეს ვარიანტი ნაგულისხმევად',
    'download' => 'ჩამოტვირთვა',
    'external_link_downloads' => 'გარე ბმულები',
    'download_available_when_completed' => 'ჩამოტვირთვის ბმულები ხელმისაწვდომი იქნება შეკვეთის დასრულების შემდეგ.',
    'cross_sell_price_type' => [
        'title' => 'ფასის ტიპი',
        'fixed' => 'ფიქსირებული',
        'percent' => 'პროცენტი',
    ],
    'cross_sell_help' => [
        'price' => '* ფასის ველი',
        'price_description' => 'შეიყვანეთ თანხა, რომელსაც გსურთ გამოაკლოთ ორიგინალურ ფასს. მაგალითი: თუ ორიგინალური ფასი $100-ია, შეიყვანეთ 20, რომ ფასი შემცირდეს $80-მდე.',
        'type' => '* ტიპის ველი',
        'type_description' => 'აირჩიეთ ფასდაკლების ტიპი: ფიქსირებული (კონკრეტული თანხის გამოკლება) ან პროცენტი (პროცენტული გამოკლება).',
    ],
    'up_sell_price_type' => [
        'title' => 'ფასის ტიპი',
        'fixed' => 'ფიქსირებული',
        'percent' => 'პროცენტი',
    ],
    'up_sell_help' => [
        'price' => '* ფასის ველი',
        'price_description' => 'შეიყვანეთ თანხა, რომელსაც გსურთ გამოაკლოთ ორიგინალურ ფასს. მაგალითი: თუ ორიგინალური ფასი $100-ია, შეიყვანეთ 20, რომ ფასი შემცირდეს $80-მდე.',
        'type' => '* ტიპის ველი',
        'type_description' => 'აირჩიეთ ფასდაკლების ტიპი: ფიქსირებული (კონკრეტული თანხის გამოკლება) ან პროცენტი (პროცენტული გამოკლება).',
    ],
    'up_sale' => [
        'title' => 'იყიდეთ ერთად და დაზოგეთ',
        'description' => 'მიიღეთ სპეციალური ფასდაკლებები ამ ნივთების ერთად შეძენისას',
        'unlock_discount' => 'დაამატეთ :product კალათაში პაკეტის ფასდაკლების გასახსნელად',
        'multiple_options' => 'მრავალი ვარიანტი',
        'multiple_options_available' => 'ხელმისაწვდომია მრავალი ვარიანტი',
        'select' => 'არჩევა',
        'selected_items_total' => 'არჩეული ნივთების ჯამი:',
        'add_selected_to_cart' => 'არჩეულის დამატება კალათაში',
        'bundle_discount_with' => 'პაკეტის ფასდაკლება :product-თან ერთად',
        'bundle_with' => 'პაკეტი :product-თან ერთად',
    ],
    'cross_sale' => [
        'title' => 'ხშირად ყიდულობენ ერთად',
        'description' => 'მომხმარებლები, რომლებმაც ნახეს ეს ნივთი, ასევე იყიდეს',
    ],
    'apply_for_all_variations' => 'გამოიყენეთ ყველა ვარიაციისთვის',
    'export' => [
        'description' => 'ექსპორტი გაუკეთეთ თქვენი პროდუქტის მონაცემებს CSV ან Excel ფაილებში.',
        'total_items' => 'სულ ელემენტები',
        'total_products' => 'სულ პროდუქტები',
        'total_variations' => 'სულ ვარიაციები',
        'advanced_options' => 'გაფართოებული პარამეტრები',
        'use_chunked_export' => 'გამოიყენეთ ნაწილებად ექსპორტი',
        'use_chunked_export_helper' => 'მონაცემების დამუშავება ნაწილებად დიდი მონაცემთა ნაკრებების ეფექტურად დასამუშავებლად',
        'include_variations' => 'პროდუქტის ვარიაციების ჩართვა',
        'include_variations_helper' => 'ექსპორტი გაუკეთეთ პროდუქტის ვარიაციებს ძირითად პროდუქტებთან ერთად',
        'optimize_memory' => 'მეხსიერების ოპტიმიზაცია',
        'optimize_memory_helper' => 'ჩართეთ მეხსიერების ოპტიმიზაცია ძალიან დიდი ექსპორტებისთვის',
        'chunk_size' => 'ნაწილის ზომა',
        'chunk_size_helper' => 'პროდუქტების რაოდენობა ერთდროულად დასამუშავებლად (50-5000)',
        'use_streaming' => 'გამოიყენეთ სტრიმინგ ექსპორტი',
        'use_streaming_helper' => 'ჩართეთ სტრიმინგი ძალიან დიდი მონაცემთა ნაკრებებისთვის (ავტომატურად ჩაირთვება >10,000 ელემენტისთვის)',
        'large_dataset_warning_title' => 'დიდი პროდუქტის კატალოგი აღმოჩენილია',
        'large_dataset_warning_message' => 'თქვენი კატალოგი შეიცავს :count ელემენტს. დიდი ზომის გამო, ზოგიერთი ექსპორტის პარამეტრი ოპტიმიზირებულია საუკეთესო მუშაობისთვის.',
        'large_dataset_specific_message' => 'თქვენი :count პროდუქტისთვის, გამოიყენეთ CSV ფორმატი ჩართული სტრიმინგით. სისტემა ახლა შეუძლია დაამუშაოს თქვენი დიდი პროდუქტის კატალოგი ეფექტურად დროის ამოწურვის ან მეხსიერების პრობლემების გარეშე.',
        'format_label' => 'ფორმატი',
        'csv_recommended' => 'CSV (სავალდებულო)',
        'chunk_label' => 'დამუშავება',
        'chunk_recommended' => '300 პროდუქტი/პაკეტი',
        'time_label' => 'სავარაუდო დრო',
        'time_estimate' => '1-3 წუთი',
        'pro_tip' => 'პროფესიონალური რჩევა:',
        'pro_tip_message' => 'ექსპორტი გაგრძელდება მუშაობას მაშინაც კი, თუ თქვენი ბრაუზერი ჩატვირთვის ინდიკატორს აჩვენებს. დაწყების შემდეგ, ჩამოტვირთვა ავტომატურად დაიწყება.',
        'large_dataset_tip_1' => 'Excel ფორმატი გამორთულია - გამოიყენეთ CSV ფორმატი უფრო სწრაფი და სანდო ექსპორტისთვის',
        'large_dataset_tip_2' => 'სტრიმინგ რეჟიმი ავტომატურად ჩართულია დროის ამოწურვის თავიდან ასაცილებლად',
        'large_dataset_tip_3' => 'ექსპორტის პროცესი შეიძლება გაგრძელდეს 1-3 წუთი თქვენი სერვერის მიხედვით',
        'large_dataset_recommendation' => 'რეკომენდებული: გამოიყენეთ CSV ფორმატი 200-500 ნაწილის ზომით ოპტიმალური მუშაობისთვის.',
        'excel_disabled_for_large_export' => 'Excel ფორმატი არ არის ხელმისაწვდომი 10,000-ზე მეტი ელემენტის კატალოგებისთვის',
        'streaming_auto_enabled' => 'სტრიმინგ რეჟიმი ავტომატურად ჩართულია ოპტიმალური მუშაობისთვის დიდი მონაცემთა ნაკრებებით.',
        'streaming_enabled_title' => 'ოპტიმიზირებულია დიდი ექსპორტისთვის',
        'streaming_enabled_message' => 'სტრიმინგ რეჟიმი აქტიურია, რათა უზრუნველყოს გლუვი ექსპორტი მეხსიერების პრობლემების გარეშე.',
        'use_multi_file' => 'გამოიყენეთ მრავალფაილიანი ექსპორტი',
        'use_multi_file_helper' => 'გაყავით ექსპორტი რამდენიმე ფაილად ZIP არქივში ძალიან დიდი მონაცემთა ნაკრებებისთვის',
        'multi_file_enabled_title' => 'მრავალფაილიანი ექსპორტი ჩართულია',
        'multi_file_enabled_message' => 'თქვენი ექსპორტი გაიყოფა :count ფაილად ZIP არქივში ოპტიმალური მუშაობისთვის.',
        'records_per_file' => 'ჩანაწერები ფაილზე',
        'records_per_file_helper' => 'ჩანაწერების რაოდენობა თითოეულ ფაილში მრავალფაილიანი ექსპორტის გამოყენებისას',
        'estimated_files' => 'სავარაუდო ფაილები',
        'recommended_range' => 'რეკომენდებული დიაპაზონი',
        'range_large_export' => '200-500 ელემენტი',
        'range_medium_export' => '300-800 ელემენტი',
        'range_small_export' => '500-1000 ელემენტი',
        'export_progress' => 'ექსპორტის პროგრესი',
        'preparing_export' => 'ექსპორტის მომზადება...',
        'items_processed' => ':count ელემენტი დამუშავებულია',
        'estimated_time_calculating' => 'სავარაუდო დრო: გამოითვლება...',
        'medium_dataset_detected' => 'საშუალო მონაცემთა ნაკრები აღმოჩენილია',
        'medium_dataset_message' => 'თქვენ ექსპორტს უკეთებთ :count პროდუქტს. განიხილეთ ნაწილებად ექსპორტის გამოყენება უკეთესი მუშაობისთვის.',
        'optimal_range' => 'ოპტიმალური დიაპაზონი',
        'too_small_slow' => 'ძალიან პატარა - შეიძლება იყოს ნელი',
        'too_large_timeouts' => 'ძალიან დიდი - შეიძლება გამოიწვიოს დროის ამოწურვა',
        'excel_disabled_warning' => 'Excel ფორმატი გამორთულია დიდი ექსპორტებისთვის (:count ელემენტი)',
        'starting_export' => 'ექსპორტის დაწყება...',
        'processing_data' => 'მონაცემების დამუშავება...',
        'finalizing_export' => 'ექსპორტის დასრულება...',
        'items_processed_suffix' => 'ელემენტი დამუშავებულია',
        'estimated_time_prefix' => 'სავარაუდო დრო:',
        'seconds_remaining' => 'წმ დარჩა',
        'export_completed' => 'ექსპორტი დასრულდა!',
        'download_starting' => 'ჩამოტვირთვა იწყება...',
    ],
    'import' => [
        'description' => 'იმპორტი გაუკეთეთ თქვენი პროდუქტის მონაცემებს CSV ან Excel ფაილებიდან.',
        'rules' => [
            'in' => ':attribute უნდა იყოს ერთ-ერთი განსაზღვრული მნიშვნელობა: :values.',
            'required_string_max' => ':attribute სავალდებულოა და უნდა იყოს სტრიქონი მაქსიმუმ :max სიმბოლოთი.',
            'nullable_string' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს სტრიქონი თუ მოწოდებულია.',
            'nullable_string_max' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს სტრიქონი მაქსიმუმ :max სიმბოლოთი თუ მოწოდებულია',
            'nullable_bool' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს ლოგიკური მნიშვნელობა თუ მოწოდებულია.',
            'nullable_numeric_min' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს არაუარყოფითი რიცხვი თუ მოწოდებულია.',
            'nullable_numeric_min_max' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს რიცხვი :min-სა და :max-ს შორის თუ მოწოდებულია.',
            'nullable_array' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს მოწოდებული როგორც მასივი თუ მითითებულია.',
            'nullable_date_required_if' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს მოქმედი თარიღი თუ მოწოდებულია, სავალდებულოა თუ :required მითითებულია.',
            'nullable_date_after' => ':attribute შეიძლება დარჩეს ცარიელი ან უნდა იყოს მოქმედი თარიღი :after-ის შემდეგ თუ მოწოდებულია.',
        ],
        'updated_message' => 'წარმატებით განახლდა :count პროდუქტი!',
    ],
    'import_products_intro' => 'ან იმპორტი გაუკეთეთ პროდუქტებს CSV/Excel-დან',
    'select_attributes' => 'აირჩიეთ ატრიბუტები ვარიაციების შესაქმნელად:',
    'all' => 'ყველა',
    'copy' => 'კოპირება',
    'product_translations' => 'პროდუქტის თარგმანები',
    'view' => 'პროდუქტის ნახვა - :name',
    'product_information' => 'პროდუქტის ინფორმაცია',
    'total_views' => 'სულ ნახვები',
    'total_orders' => 'დასრულებული შეკვეთები',
    'total_sold' => 'სულ გაყიდული',
    'total_revenue' => 'მთლიანი შემოსავალი',
    'pending_orders' => 'მომლოდინე შეკვეთები',
    'pending_revenue' => 'მომლოდინე შემოსავალი',
    'conversion_rate' => 'კონვერსიის მაჩვენებელი',
    'total_reviews' => 'სულ მიმოხილვები',
    'average_rating' => 'საშუალო რეიტინგი',
    'views_by_date' => 'ნახვები თარიღის მიხედვით (ბოლო 30 დღე)',
    'recent_orders' => 'ბოლო შეკვეთები',
    'no_views_data' => 'ბოლო 30 დღის ნახვების მონაცემები არ არის ხელმისაწვდომი.',
    'no_orders' => 'ჯერ შეკვეთები არ არის.',
    'date' => 'თარიღი',
    'views' => 'ნახვები',
    'total' => 'სულ',
    'view_on_frontend' => 'ნახვა ვებსაიტზე',
    'select_attribute' => 'აირჩიეთ :name',
    'all_categories' => 'ყველა კატეგორია',
    'brands' => 'ბრენდები',
    'browse_products' => 'პროდუქტების დათვალიერება',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'აირჩიეთ დასაბრუნებელი პროდუქტები',
    'show_only_discounted_products' => 'აჩვენეთ მხოლოდ ფასდაკლებული პროდუქტები',
    'specification' => 'სპეციფიკაცია',
    'download_product_with_external_links' => 'ჩამოტვირთეთ პროდუქტი ":name" გარე ბმულებით',
    'number_product_available_singular' => ':number პროდუქტი ხელმისაწვდომია',
    'number_products_available_plural' => ':number პროდუქტი ხელმისაწვდომია',
    'cart' => [
        'added_to_cart_success' => ':product დაემატა თქვენს კალათაში.',
        'removed_from_cart_success' => ':product წაიშალა თქვენი კალათიდან.',
        'updated_cart_success' => 'თქვენი კალათა განახლდა.',
        'item_not_found' => 'ეს ნივთი აღარ არის თქვენს კალათაში.',
        'out_of_stock' => 'სამწუხაროდ, :product ამჟამად არ არის მარაგში.',
        'max_quantity' => 'შეგიძლიათ დაამატოთ მაქსიმუმ :max ნივთი.',
        'max_quantity_detail' => 'სამწუხაროდ, ერთდროულად შეგიძლიათ შეუკვეთოთ მხოლოდ :quantity ერთეული :product.',
        'select_options' => 'გთხოვთ, აირჩიოთ პროდუქტის ვარიანტები კალათაში დამატებამდე.',
        'product_out_of_stock' => 'სამწუხაროდ, ეს პროდუქტი ამჟამად არ არის მარაგში.',
        'product_not_exists' => 'ეს პროდუქტი არ არის მარაგში ან აღარ არსებობს.',
        'not_enough_quantity' => 'ზოგიერთ პროდუქტს არ აქვს საკმარისი მარაგი განახლებისთვის.',
        'empty_success' => 'თქვენი კალათა დაცარიელდა.',
        'bundle_item_already_in_cart' => 'ეს პაკეტის ნივთი უკვე თქვენს კალათაშია. პაკეტის ფასდაკლებაზე დაშვებულია მხოლოდ 1 ნივთი.',
    ],
    'wishlist' => [
        'added_success' => ':product დაემატა თქვენს სურვილების სიას.',
        'removed_success' => ':product წაიშალა თქვენი სურვილების სიიდან.',
        'product_not_found' => 'ეს პროდუქტი ვერ მოიძებნა.',
        'product_not_in_wishlist' => 'ეს პროდუქტი არ არის თქვენს სურვილების სიაში.',
        'product_not_available' => 'ეს პროდუქტი არ არის ხელმისაწვდომი.',
    ],
    'compare' => [
        'added_success' => ':product დაემატა თქვენს შედარების სიას.',
        'removed_success' => ':product წაიშალა თქვენი შედარების სიიდან.',
        'product_not_found' => 'ეს პროდუქტი ვერ მოიძებნა.',
        'product_not_in_compare' => 'ეს პროდუქტი არ არის თქვენს შედარების სიაში.',
        'already_in_list' => ':product უკვე არის თქვენს შედარების სიაში.',
    ],
];
