<?php

return [
    'name' => 'Produits',
    'description' => 'Gérer les produits physiques et numériques avec inventaire, tarification et variations',
    'create' => 'Nouveau produit',
    'create_product_type' => [
        'physical' => 'Nouveau produit physique',
        'digital' => 'Nouveau produit numérique',
    ],
    'edit' => 'Modifier le produit - :name',
    'form' => [
        'name' => 'Nom',
        'name_placeholder' => 'Nom du produit (Maximum 120 caractères)',
        'description' => 'Description',
        'description_placeholder' => 'Description courte du produit (Maximum 400 caractères)',
        'categories' => 'Catégories',
        'content' => 'Contenu',
        'price' => 'Prix',
        'currency' => 'Devise',
        'currency_for_variations_hint' => 'Cette devise sera appliquée à toutes les variations de ce produit.',
        'quantity' => 'Quantité',
        'brand' => 'Marque',
        'width' => 'Largeur',
        'height' => 'Hauteur',
        'weight' => 'Poids',
        'date' => [
            'start' => 'Date de début',
            'end' => 'Date de fin',
        ],
        'image' => 'Images',
        'collections' => 'Collections de produits',
        'labels' => 'Étiquettes',
        'price_sale' => 'Prix promotionnel',
        'product_type' => [
            'title' => 'Type de produit',
        ],
        'product' => 'Produit',
        'total' => 'Total',
        'sub_total' => 'Sous-total',
        'shipping_fee' => 'Frais de livraison',
        'discount' => 'Remise',
        'options' => 'Options',
        'shipping' => [
            'height' => 'Hauteur',
            'length' => 'Longueur',
            'title' => 'Livraison',
            'weight' => 'Poids',
            'wide' => 'Largeur',
        ],
        'barcode' => 'Code-barres (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Entrer le code-barres',
        'cost_per_item' => 'Coût par article',
        'cost_per_item_placeholder' => 'Entrer le coût par article',
        'cost_per_item_helper' => 'Les clients ne verront pas ce prix.',
        'price_includes_tax' => 'Le prix inclut la taxe',
        'price_includes_tax_helper' => 'Cochez cette case si le prix saisi inclut déjà les taxes. Le système calculera le prix de base en soustrayant le montant de la taxe.',
        'stock' => [
            'allow_order_when_out' => 'Autoriser la commande lorsque ce produit est en rupture de stock',
            'in_stock' => 'En stock',
            'out_stock' => 'Rupture de stock',
            'title' => 'État du stock',
        ],
        'storehouse' => [
            'no_storehouse' => 'Pas de gestion d\'entrepôt',
            'storehouse' => 'Avec gestion d\'entrepôt',
            'title' => 'Entrepôt',
            'quantity' => 'Quantité',
        ],
        'tax' => 'Taxe',
        'taxes' => 'Taxes',
        'taxes_helper' => 'Le taux de taxe par défaut est configuré dans <a href=":url">Paramètres -> Taxe</a>. Si aucune taxe spécifique n\'est sélectionnée pour ce produit, le taux par défaut sera appliqué. Pour désactiver la taxe pour ce produit, supprimez le taux de taxe par défaut dans les paramètres de taxe.',
        'is_default' => 'Par défaut',
        'action' => 'Action',
        'restock_quantity' => 'Quantité de réapprovisionnement',
        'remain' => 'Reste',
        'choose_discount_period' => 'Choisir la période de remise',
        'cancel' => 'Annuler',
        'no_results' => 'Aucun résultat !',
        'value' => 'Valeur',
        'attribute_name' => 'Nom de l\'attribut',
        'add_more_attribute' => 'Ajouter plus d\'attributs',
        'continue' => 'Continuer',
        'add_new_attributes' => 'Ajouter de nouveaux attributs',
        'add_new_attributes_description' => 'L\'ajout de nouveaux attributs permet au produit d\'avoir plusieurs options, comme la taille ou la couleur.',
        'create_product_variations' => ':link pour créer des variations de produit !',
        'tags' => 'Étiquettes',
        'write_some_tags' => 'Écrire quelques étiquettes',
        'variation_existed' => 'Cette variation existe déjà.',
        'no_attributes_selected' => 'Aucun attribut sélectionné !',
        'added_variation_success' => 'Variation ajoutée avec succès !',
        'updated_variation_success' => 'Variation mise à jour avec succès !',
        'created_all_variation_success' => 'Toutes les variations créées avec succès !',
        'updated_product_attributes_success' => 'Attributs du produit mis à jour avec succès !',
        'stock_status' => 'État du stock',
        'auto_generate_sku' => 'Générer automatiquement le SKU ?',
        'featured_image' => 'Image mise en avant (optionnel)',
        'product_id' => 'ID du produit',
        'price_sale_percent_helper' => 'Remise de :percent sur le prix d\'origine.',
        'minimum_order_quantity' => 'Quantité minimale de commande',
        'minimum_order_quantity_helper' => 'Quantité minimale pour passer une commande, si la valeur est 0, il n\'y a pas de limite.',
        'maximum_order_quantity' => 'Quantité maximale de commande',
        'maximum_order_quantity_helper' => 'Quantité maximale pour passer une commande, si la valeur est 0, il n\'y a pas de limite.',
        'video' => 'Vidéo',
        'video_file' => 'Fichier',
        'video_url' => 'Ou URL de vidéo externe',
        'video_url_help' => 'Entrez l\'URL de la vidéo YouTube ou Vimeo',
        'enter_video_url' => 'Entrer l\'URL de la vidéo',
        'video_thumbnail' => 'Miniature de la vidéo',
        'video_thumbnail_help' => 'Choisissez une miniature pour la vidéo. Si non sélectionnée, elle sera automatiquement récupérée depuis l\'URL de la vidéo si disponible.',
        'barcode_existed' => 'Ce code-barres est utilisé par un autre produit. Veuillez entrer un autre code-barres.',
        'barcode_helper' => 'Doit être unique pour chaque produit.',
        'is_new_until' => 'Nouveau jusqu\'au',
        'is_new_until_helper' => 'Définissez une date jusqu\'à laquelle ce produit sera marqué comme "Nouveau". Laissez vide pour ne pas marquer comme nouveau en fonction de la date.',
    ],
    'price' => 'Prix',
    'quantity' => 'Quantité',
    'type' => 'Type',
    'image' => 'Vignette',
    'sku' => 'SKU',
    'sku_line' => 'SKU : :sku',
    'variation_sku' => 'SKU de la variation',
    'brand' => 'Marque',
    'cannot_delete' => 'Le produit n\'a pas pu être supprimé',
    'product_deleted' => 'Produit supprimé',
    'product' => 'Produit',
    'product_collections' => 'Collections de produits',
    'products' => 'Produits',
    'total_products_found' => ':total produits trouvés',
    'total_product_found' => ':total produit trouvé',
    'menu' => 'Produits',
    'control' => [
        'button_add_image' => 'Ajouter une image',
    ],
    'price_sale' => 'Prix promotionnel',
    'price_group_title' => 'Gestion des prix du produit',
    'store_house_group_title' => 'Gestion de l\'entrepôt',
    'shipping_group_title' => 'Gestion de la livraison',
    'overview' => 'Aperçu',
    'attributes' => 'Attributs',
    'product_has_variations' => 'Le produit a des variations',
    'manage_products' => 'Gérer les produits',
    'add_new_product' => 'Ajouter un nouveau produit',
    'start_by_adding_new_product' => 'Commencez par ajouter de nouveaux produits.',
    'edit_this_product' => 'Modifier ce produit',
    'delete' => 'Supprimer',
    'related_products' => 'Produits connexes',
    'cross_selling_products' => 'Produits en vente croisée',
    'up_selling_products' => 'Produits en vente incitative',
    'grouped_products' => 'Produits groupés',
    'search_products' => 'Rechercher des produits',
    'selected_products' => 'Produits sélectionnés',
    'edit_variation_item' => 'Modifier',
    'variations_box_description' => 'Cliquez sur "Modifier l\'attribut" pour ajouter/supprimer des attributs de variation ou cliquez sur "Ajouter une nouvelle variation" pour ajouter une variation.',
    'save_changes' => 'Enregistrer les modifications',
    'continue' => 'Continuer',
    'edit_attribute' => 'Modifier l\'attribut',
    'select_attribute' => 'Sélectionner l\'attribut',
    'add_new_variation' => 'Ajouter une nouvelle variation',
    'edit_variation' => 'Modifier la variation',
    'generate_variations' => 'Générer les variations',
    'generate_variations_confirmation' => 'Êtes-vous sûr de vouloir générer les variations pour ce produit ?',
    'delete_variation' => 'Supprimer la variation ?',
    'delete_variation_confirmation' => 'Êtes-vous sûr de vouloir supprimer cette variation ? Cette action ne peut pas être annulée.',
    'delete_variations_confirmation' => 'Êtes-vous sûr de vouloir supprimer ces variations ? Cette action ne peut pas être annulée.',
    'product_create_validate_name_required' => 'Veuillez entrer le nom du produit',
    'product_create_validate_sale_price_max' => 'La remise doit être inférieure au prix d\'origine',
    'product_create_validate_cost_per_item_max' => 'Le coût par article doit être inférieur au prix d\'origine',
    'product_create_validate_sale_price_required_if' => 'Vous devez entrer une remise lorsque vous souhaitez planifier une promotion',
    'product_create_validate_end_date_after' => 'La date de fin doit être postérieure à la date de début',
    'product_create_validate_start_date_required_if' => 'La date de début de la remise ne peut pas être vide lorsque la planification est sélectionnée',
    'product_create_validate_sale_price' => 'Les remises ne peuvent pas être vides lorsque la planification est sélectionnée',
    'stock_statuses' => [
        'in_stock' => 'En stock',
        'out_of_stock' => 'Rupture de stock',
        'on_backorder' => 'En réapprovisionnement',
    ],
    'stock_status' => 'État du stock',
    'processing' => 'Traitement en cours...',
    'delete_selected_variations' => 'Supprimer les variations sélectionnées',
    'delete_variations' => 'Supprimer les variations',
    'category' => 'Catégorie',
    'categories' => 'Catégories',
    'tags' => 'Étiquettes',
    'product_price_flash_sale_warning' => 'Ce produit est en vente flash <strong>:name</strong> donc son prix est <strong>:price</strong>.',
    'product_price_discount_warning' => 'Ce produit est en promotion <strong>:name</strong> donc son prix est <strong>:price</strong>.',
    'product_image' => 'Image du produit',
    'product_name' => 'Nom du produit',
    'product_link' => 'Lien du produit',
    'types' => [
        'physical' => 'Physique',
        'digital' => 'Numérique',
    ],
    'digital_attachments' => [
        'title' => 'Pièces jointes numériques',
        'add' => 'Ajouter une pièce jointe',
        'file_name' => 'Nom du fichier',
        'file_size' => 'Taille du fichier',
        'unsaved' => 'Non enregistré',
        'add_external_link' => 'Ajouter un lien externe',
        'enter_file_name' => 'Entrer le nom du fichier',
        'enter_external_link_download' => 'Entrer le lien de téléchargement externe',
        'enter_file_size' => 'Entrer la taille du fichier',
        'external_link_download' => 'Lien de téléchargement externe',
        'generate_license_code_after_purchasing_product' => 'Activer l\'attribution de code de licence pour ce produit',
        'notify_attachment_updated' => 'Envoyer un e-mail au client lorsque la pièce jointe est mise à jour',
        'no_attachments' => 'Aucune pièce jointe pour le moment. Cliquez sur les boutons ci-dessus pour ajouter des fichiers.',
    ],
    'license_codes' => [
        'title' => 'Codes de licence',
        'add' => 'Ajouter un code de licence',
        'back' => 'Retour au produit',
        'edit' => 'Modifier le code de licence',
        'generate' => 'Générer des codes',
        'manage_codes' => 'Gérer les codes de licence',
        'management' => 'Gestion des codes de licence',
        'variation_breadcrumb' => 'Variation : :name',
        'variation_label' => 'Variation du produit',
        'variation_specific_note' => 'Ces codes de licence sont spécifiques à cette variation de produit. Les clients qui achètent cette variation recevront des codes de ce pool.',
        'main_product_note' => 'Ce produit a des variations. Chaque variation peut avoir ses propres codes de licence, ou les clients peuvent recevoir des codes du pool du produit principal si la variation n\'a pas de codes.',
        'code' => 'Code de licence',
        'codes' => 'Codes de licence',
        'status' => 'Statut',
        'assigned_at' => 'Attribué le',
        'status_available' => 'Disponible',
        'status_used' => 'Utilisé',
        'statuses' => [
            'available' => 'Disponible',
            'used' => 'Utilisé',
        ],
        'no_codes' => 'Aucun code de licence trouvé. Ajoutez des codes ou générez-les automatiquement.',
        'no_codes_warning_title' => 'Aucun code de licence disponible !',
        'no_codes_warning_message' => 'Ce produit est configuré sur "Choisir dans la liste" mais n\'a pas de codes de licence disponibles. Les clients qui achètent ce produit recevront des codes générés automatiquement à la place. Veuillez ajouter des codes de licence pour assurer un bon fonctionnement.',
        'no_codes_auto_generate' => 'Ce produit est configuré pour générer automatiquement les codes de licence. Aucun code manuel n\'est nécessaire.',
        'used_code_no_actions' => 'Code utilisé - aucune action disponible',
        'created_successfully' => 'Code de licence créé avec succès !',
        'updated_successfully' => 'Code de licence mis à jour avec succès !',
        'deleted_successfully' => 'Code de licence supprimé avec succès !',
        'generated_successfully' => ':count codes de licence générés avec succès !',
        'duplicates_skipped' => ':count codes en double ont été ignorés.',
        'generation_incomplete' => 'Attention : Seuls :generated codes sur :requested demandés ont pu être générés en raison de conflits de doublons.',
        'cannot_edit_used_code' => 'Impossible de modifier un code de licence utilisé.',
        'cannot_delete_used_code' => 'Impossible de supprimer un code de licence utilisé.',
        'show_all' => 'Afficher tout',
        'show_less' => 'Afficher moins',
        'more' => 'plus',
        'used_codes_hidden' => ':count code(s) de licence utilisé(s) sont masqués. Vous pouvez voir tous les codes dans la page de gestion des codes de licence.',
        'low_stock_title' => 'Stock de codes de licence faible',
        'low_stock_message' => 'Il ne reste que :count codes de licence. Envisagez d\'en ajouter d\'autres pour éviter d\'en manquer.',
        'out_of_stock_title' => 'Plus de codes de licence !',
        'out_of_stock_message' => 'Aucun code de licence disponible. Les clients recevront des codes générés automatiquement jusqu\'à ce que vous en ajoutiez d\'autres.',
        'type' => [
            'title' => 'Méthode d\'attribution des codes de licence',
            'auto_generate' => 'Génération automatique (Le système génère les codes automatiquement)',
            'pick_from_list' => 'Choisir dans la liste (Utiliser des codes pré-entrés)',
            'description' => 'Choisissez comment les codes de licence doivent être attribués aux clients lorsqu\'ils achètent ce produit.',
        ],
        'add_modal' => [
            'placeholder' => 'ex., XXXX-XXXX-XXXX-XXXX',
            'help' => 'Entrez un code de licence unique qui sera attribué à un client lors de l\'achat.',
        ],
        'generate_modal' => [
            'title' => 'Générer des codes de licence',
            'quantity' => 'Quantité',
            'format' => 'Format',
            'custom_pattern' => 'Motif personnalisé',
            'pattern_help' => 'Utilisez # pour les chiffres, A pour les lettres majuscules, a pour les lettres minuscules',
            'generate' => 'Générer',
        ],
        'errors' => [
            'feature_not_enabled' => 'La fonctionnalité des codes de licence n\'est pas activée. Veuillez l\'activer dans Paramètres Ecommerce > Produits numériques.',
            'digital_products_not_enabled' => 'Les produits numériques ne sont pas activés. Veuillez d\'abord activer la prise en charge des produits numériques.',
            'product_not_found' => 'Produit non trouvé.',
            'not_digital_product' => 'Les codes de licence ne sont disponibles que pour les produits numériques. Ce produit est défini comme un produit physique.',
            'license_codes_not_enabled_for_product' => 'La gestion des codes de licence n\'est pas activée pour ce produit. Veuillez activer "Générer un code de licence après l\'achat du produit" dans les paramètres du produit.',
            'cannot_add_codes_auto_generate' => 'Impossible d\'ajouter manuellement des codes de licence aux produits configurés pour la génération automatique. Changez d\'abord le type de code de licence en "Choisir dans la liste".',
            'cannot_generate_codes_auto_generate' => 'Impossible de générer manuellement des codes de licence pour les produits configurés pour la génération automatique. Changez d\'abord le type de code de licence en "Choisir dans la liste".',
        ],
        'bulk_delete' => [
            'button' => 'Supprimer la sélection',
            'selected' => 'sélectionné(s)',
            'confirm' => 'Êtes-vous sûr de vouloir supprimer les codes de licence sélectionnés ?',
            'deleted_successfully' => ':count code(s) de licence supprimé(s) avec succès.',
            'skipped_used_codes' => ':count code(s) utilisé(s) ont été ignorés.',
            'no_deletable_codes' => 'Aucun code de licence disponible à supprimer. Les codes utilisés ne peuvent pas être supprimés.',
        ],
        'import' => [
            'name' => 'Importer les codes de licence des produits',
            'description' => 'Importer des codes de licence pour les produits numériques à partir d\'un fichier CSV/Excel.',
            'button' => 'Importer',
            'columns' => [
                'product_id' => 'ID ou SKU du produit',
                'license_code' => 'Code de licence',
            ],
        ],
        'copied' => 'Code de licence copié dans le presse-papiers !',
    ],
    'this_action_will_reload_page' => 'Cette action rechargera la page pour mettre à jour les données !',
    'select' => 'Sélectionner',
    'clear_filters' => 'Effacer les filtres',
    'set_this_variant_as_default' => 'Définir cette variante comme par défaut',
    'download' => 'Télécharger',
    'external_link_downloads' => 'Liens externes',
    'download_available_when_completed' => 'Les liens de téléchargement seront disponibles lorsque la commande sera terminée.',
    'cross_sell_price_type' => [
        'title' => 'Type de prix',
        'fixed' => 'Fixe',
        'percent' => 'Pourcentage',
    ],
    'cross_sell_help' => [
        'price' => '* Champ prix',
        'price_description' => 'Entrez le montant que vous souhaitez réduire du prix d\'origine. Exemple : Si le prix d\'origine est 100 €, entrez 20 pour réduire le prix à 80 €.',
        'type' => '* Champ type',
        'type_description' => 'Choisissez le type de remise : Fixe (réduire un montant spécifique) ou Pourcentage (réduire d\'un pourcentage).',
    ],
    'up_sell_price_type' => [
        'title' => 'Type de prix',
        'fixed' => 'Fixe',
        'percent' => 'Pourcentage',
    ],
    'up_sell_help' => [
        'price' => '* Champ prix',
        'price_description' => 'Entrez le montant que vous souhaitez réduire du prix d\'origine. Exemple : Si le prix d\'origine est 100 €, entrez 20 pour réduire le prix à 80 €.',
        'type' => '* Champ type',
        'type_description' => 'Choisissez le type de remise : Fixe (réduire un montant spécifique) ou Pourcentage (réduire d\'un pourcentage).',
    ],
    'up_sale' => [
        'title' => 'Achetez ensemble et économisez',
        'description' => 'Bénéficiez de remises spéciales lors de l\'achat de ces articles ensemble',
        'unlock_discount' => 'Ajoutez :product au panier pour débloquer la remise groupée',
        'multiple_options' => 'Plusieurs options',
        'multiple_options_available' => 'Plusieurs options disponibles',
        'select' => 'Sélectionner',
        'selected_items_total' => 'Total des articles sélectionnés :',
        'add_selected_to_cart' => 'Ajouter la sélection au panier',
        'bundle_discount_with' => 'Remise groupée avec :product',
        'bundle_with' => 'Lot avec :product',
    ],
    'cross_sale' => [
        'title' => 'Fréquemment achetés ensemble',
        'description' => 'Les clients qui ont consulté cet article ont également acheté',
    ],
    'apply_for_all_variations' => 'Appliquer à toutes les variations',
    'export' => [
        'description' => 'Exportez vos données produits vers des fichiers CSV ou Excel.',
        'total_items' => 'Total des éléments',
        'total_products' => 'Total des produits',
        'total_variations' => 'Total des variations',
        'advanced_options' => 'Options avancées',
        'use_chunked_export' => 'Utiliser l\'exportation par lots',
        'use_chunked_export_helper' => 'Traiter les données par lots pour gérer efficacement les grands ensembles de données',
        'include_variations' => 'Inclure les variations de produits',
        'include_variations_helper' => 'Exporter les variations de produits avec les produits principaux',
        'optimize_memory' => 'Optimiser l\'utilisation de la mémoire',
        'optimize_memory_helper' => 'Activer l\'optimisation de la mémoire pour les très grandes exportations',
        'chunk_size' => 'Taille des lots',
        'chunk_size_helper' => 'Nombre de produits à traiter à la fois (50-5000)',
        'use_streaming' => 'Utiliser l\'exportation en streaming',
        'use_streaming_helper' => 'Activer le streaming pour les très grands ensembles de données (activé automatiquement pour >10 000 éléments)',
        'large_dataset_warning_title' => 'Grand catalogue de produits détecté',
        'large_dataset_warning_message' => 'Votre catalogue contient :count éléments. En raison de la grande taille, certaines options d\'exportation ont été optimisées pour de meilleures performances.',
        'large_dataset_specific_message' => 'Pour vos :count produits, utilisez le format CSV avec le streaming activé. Le système peut maintenant gérer efficacement votre grand catalogue de produits sans délais d\'expiration ni problèmes de mémoire.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Requis)',
        'chunk_label' => 'Traitement',
        'chunk_recommended' => '300 produits/lot',
        'time_label' => 'Temps estimé',
        'time_estimate' => '1-3 minutes',
        'pro_tip' => 'Conseil pro :',
        'pro_tip_message' => 'L\'exportation continuera même si votre navigateur affiche un indicateur de chargement. Une fois démarré, le téléchargement commencera automatiquement.',
        'large_dataset_tip_1' => 'Le format Excel a été désactivé - utilisez le format CSV pour des exportations plus rapides et plus fiables',
        'large_dataset_tip_2' => 'Le mode streaming a été automatiquement activé pour éviter les délais d\'expiration',
        'large_dataset_tip_3' => 'Le processus d\'exportation peut prendre 1 à 3 minutes selon votre serveur',
        'large_dataset_recommendation' => 'Recommandé : Utilisez le format CSV avec une taille de lot de 200-500 pour des performances optimales.',
        'excel_disabled_for_large_export' => 'Format Excel non disponible pour les catalogues de plus de 10 000 articles',
        'streaming_auto_enabled' => 'Le mode streaming a été automatiquement activé pour des performances optimales avec les grands ensembles de données.',
        'streaming_enabled_title' => 'Optimisé pour les grandes exportations',
        'streaming_enabled_message' => 'Le mode streaming est actif pour assurer une exportation fluide sans problèmes de mémoire.',
        'use_multi_file' => 'Utiliser l\'exportation multi-fichiers',
        'use_multi_file_helper' => 'Diviser l\'exportation en plusieurs fichiers empaquetés dans un ZIP pour les très grands ensembles de données',
        'multi_file_enabled_title' => 'Exportation multi-fichiers activée',
        'multi_file_enabled_message' => 'Votre exportation sera divisée en :count fichiers empaquetés dans un ZIP pour des performances optimales.',
        'records_per_file' => 'Enregistrements par fichier',
        'records_per_file_helper' => 'Nombre d\'enregistrements dans chaque fichier lors de l\'utilisation de l\'exportation multi-fichiers',
        'estimated_files' => 'Fichiers estimés',
        'recommended_range' => 'Plage recommandée',
        'range_large_export' => '200-500 éléments',
        'range_medium_export' => '300-800 éléments',
        'range_small_export' => '500-1000 éléments',
        'export_progress' => 'Progression de l\'exportation',
        'preparing_export' => 'Préparation de l\'exportation...',
        'items_processed' => ':count éléments traités',
        'estimated_time_calculating' => 'Temps estimé : calcul en cours...',
        'medium_dataset_detected' => 'Ensemble de données moyen détecté',
        'medium_dataset_message' => 'Vous exportez :count produits. Envisagez d\'utiliser l\'exportation par lots pour de meilleures performances.',
        'optimal_range' => 'Plage optimale',
        'too_small_slow' => 'Trop petit - peut être lent',
        'too_large_timeouts' => 'Trop grand - peut causer des délais d\'expiration',
        'excel_disabled_warning' => 'Format Excel désactivé pour les grandes exportations (:count éléments)',
        'starting_export' => 'Démarrage de l\'exportation...',
        'processing_data' => 'Traitement des données...',
        'finalizing_export' => 'Finalisation de l\'exportation...',
        'items_processed_suffix' => 'éléments traités',
        'estimated_time_prefix' => 'Temps estimé :',
        'seconds_remaining' => 's restantes',
        'export_completed' => 'Exportation terminée !',
        'download_starting' => 'Téléchargement en cours...',
    ],
    'import' => [
        'description' => 'Importez vos données produits à partir de fichiers CSV ou Excel.',
        'rules' => [
            'in' => ':attribute doit être l\'une des valeurs définies : :values.',
            'required_string_max' => ':attribute est requis et doit être une chaîne d\'une longueur maximale de :max caractères.',
            'nullable_string' => ':attribute peut être laissé vide ou doit être une chaîne si fourni.',
            'nullable_string_max' => ':attribute peut être laissé vide ou doit être une chaîne d\'une longueur maximale de :max caractères si fourni',
            'nullable_bool' => ':attribute peut être laissé vide ou doit être une valeur booléenne si fourni.',
            'nullable_numeric_min' => ':attribute peut être laissé vide ou doit être un nombre non négatif si fourni.',
            'nullable_numeric_min_max' => ':attribute peut être laissé vide ou doit être un nombre entre :min et :max si fourni.',
            'nullable_array' => ':attribute peut être laissé vide ou doit être fourni sous forme de tableau si spécifié.',
            'nullable_date_required_if' => ':attribute peut être laissé vide ou doit être une date valide si fourni, requis si :required est spécifié.',
            'nullable_date_after' => ':attribute peut être laissé vide ou doit être une date valide après :after si fourni.',
        ],
        'updated_message' => ':count produits mis à jour avec succès !',
    ],
    'import_products_intro' => 'Ou importer des produits depuis CSV/Excel',
    'select_attributes' => 'Sélectionnez les attributs pour créer des variations :',
    'all' => 'Tout',
    'copy' => 'Copier',
    'product_translations' => 'Traductions du produit',
    'view' => 'Voir le produit - :name',
    'product_information' => 'Informations sur le produit',
    'total_views' => 'Total des vues',
    'total_orders' => 'Commandes terminées',
    'total_sold' => 'Total vendu',
    'total_revenue' => 'Revenu total',
    'pending_orders' => 'Commandes en attente',
    'pending_revenue' => 'Revenu en attente',
    'conversion_rate' => 'Taux de conversion',
    'total_reviews' => 'Total des avis',
    'average_rating' => 'Note moyenne',
    'views_by_date' => 'Vues par date (30 derniers jours)',
    'recent_orders' => 'Commandes récentes',
    'no_views_data' => 'Aucune donnée de vues disponible pour les 30 derniers jours.',
    'no_orders' => 'Aucune commande pour le moment.',
    'date' => 'Date',
    'views' => 'Vues',
    'total' => 'Total',
    'view_on_frontend' => 'Voir sur le frontend',
    'select_attribute' => 'Sélectionner :name',
    'all_categories' => 'Toutes les catégories',
    'brands' => 'Marques',
    'browse_products' => 'Parcourir les produits',
    'sku_1' => 'SKU :',
    'select_products_to_return' => 'Sélectionner les produits à retourner',
    'show_only_discounted_products' => 'Afficher uniquement les produits en promotion',
    'specification' => 'Spécification',
    'download_product_with_external_links' => 'Télécharger le produit ":name" avec des liens externes',
    'number_product_available_singular' => ':number produit disponible',
    'number_products_available_plural' => ':number produits disponibles',
    'cart' => [
        'added_to_cart_success' => ':product a été ajouté à votre panier.',
        'removed_from_cart_success' => ':product a été retiré de votre panier.',
        'updated_cart_success' => 'Votre panier a été mis à jour.',
        'item_not_found' => 'Cet article n\'est plus dans votre panier.',
        'out_of_stock' => 'Désolé, :product est actuellement en rupture de stock.',
        'max_quantity' => 'Vous ne pouvez ajouter que :max articles au maximum.',
        'max_quantity_detail' => 'Désolé, vous ne pouvez commander que :quantity unités de :product à la fois.',
        'select_options' => 'Veuillez sélectionner les options du produit avant d\'ajouter au panier.',
        'product_out_of_stock' => 'Désolé, ce produit est actuellement en rupture de stock.',
        'product_not_exists' => 'Ce produit est en rupture de stock ou n\'existe plus.',
        'not_enough_quantity' => 'Certains produits n\'ont pas assez de stock pour la mise à jour.',
        'empty_success' => 'Votre panier a été vidé.',
        'bundle_item_already_in_cart' => 'Cet article du lot est déjà dans votre panier. Un seul article par remise de lot est autorisé.',
    ],
    'wishlist' => [
        'added_success' => ':product a été ajouté à votre liste de souhaits.',
        'removed_success' => ':product a été retiré de votre liste de souhaits.',
        'product_not_found' => 'Ce produit n\'a pas pu être trouvé.',
        'product_not_in_wishlist' => 'Ce produit n\'est pas dans votre liste de souhaits.',
        'product_not_available' => 'Ce produit n\'est pas disponible.',
    ],
    'compare' => [
        'added_success' => ':product a été ajouté à votre liste de comparaison.',
        'removed_success' => ':product a été retiré de votre liste de comparaison.',
        'product_not_found' => 'Ce produit n\'a pas pu être trouvé.',
        'product_not_in_compare' => 'Ce produit n\'est pas dans votre liste de comparaison.',
        'already_in_list' => ':product est déjà dans votre liste de comparaison.',
    ],
];
