<?php

return [
    'name' => 'Προϊόντα',
    'description' => 'Διαχείριση φυσικών και ψηφιακών προϊόντων με απόθεμα, τιμολόγηση και παραλλαγές',
    'create' => 'Νέο προϊόν',
    'create_product_type' => [
        'physical' => 'Νέο φυσικό προϊόν',
        'digital' => 'Νέο ψηφιακό προϊόν',
    ],
    'edit' => 'Επεξεργασία προϊόντος - :name',
    'form' => [
        'name' => 'Όνομα',
        'name_placeholder' => 'Όνομα προϊόντος (Μέγιστο 120 χαρακτήρες)',
        'description' => 'Περιγραφή',
        'description_placeholder' => 'Σύντομη περιγραφή προϊόντος (Μέγιστο 400 χαρακτήρες)',
        'categories' => 'Κατηγορίες',
        'content' => 'Περιεχόμενο',
        'price' => 'Τιμή',
        'currency' => 'Νόμισμα',
        'currency_for_variations_hint' => 'Αυτό το νόμισμα θα εφαρμοστεί σε όλες τις παραλλαγές αυτού του προϊόντος.',
        'quantity' => 'Ποσότητα',
        'brand' => 'Μάρκα',
        'width' => 'Πλάτος',
        'height' => 'Ύψος',
        'weight' => 'Βάρος',
        'date' => [
            'start' => 'Από ημερομηνία',
            'end' => 'Έως ημερομηνία',
        ],
        'image' => 'Εικόνες',
        'collections' => 'Συλλογές προϊόντων',
        'labels' => 'Ετικέτες',
        'price_sale' => 'Τιμή προσφοράς',
        'product_type' => [
            'title' => 'Τύπος προϊόντος',
        ],
        'product' => 'Προϊόν',
        'total' => 'Σύνολο',
        'sub_total' => 'Υποσύνολο',
        'shipping_fee' => 'Έξοδα αποστολής',
        'discount' => 'Έκπτωση',
        'options' => 'Επιλογές',
        'shipping' => [
            'height' => 'Ύψος',
            'length' => 'Μήκος',
            'title' => 'Αποστολή',
            'weight' => 'Βάρος',
            'wide' => 'Πλάτος',
        ],
        'barcode' => 'Barcode (ISBN, UPC, GTIN, κλπ.) ',
        'barcode_placeholder' => 'Εισάγετε barcode',
        'cost_per_item' => 'Κόστος ανά τεμάχιο',
        'cost_per_item_placeholder' => 'Εισάγετε κόστος ανά τεμάχιο',
        'cost_per_item_helper' => 'Οι πελάτες δεν θα δουν αυτή την τιμή.',
        'price_includes_tax' => 'Η τιμή περιλαμβάνει φόρο',
        'price_includes_tax_helper' => 'Επιλέξτε αυτό αν η τιμή που εισήχθη περιλαμβάνει ήδη φόρους. Το σύστημα θα υπολογίσει τη βασική τιμή αφαιρώντας το ποσό του φόρου.',
        'stock' => [
            'allow_order_when_out' => 'Επιτρέψτε την ολοκλήρωση παραγγελίας όταν το προϊόν δεν υπάρχει σε απόθεμα',
            'in_stock' => 'Σε απόθεμα',
            'out_stock' => 'Εξαντλημένο',
            'title' => 'Κατάσταση αποθέματος',
        ],
        'storehouse' => [
            'no_storehouse' => 'Χωρίς διαχείριση αποθήκης',
            'storehouse' => 'Με διαχείριση αποθήκης',
            'title' => 'Αποθήκη',
            'quantity' => 'Ποσότητα',
        ],
        'tax' => 'Φόρος',
        'taxes' => 'Φόροι',
        'taxes_helper' => 'Ο προεπιλεγμένος φορολογικός συντελεστής ρυθμίζεται στο <a href=":url">Ρυθμίσεις -> Φόρος</a>. Εάν δεν επιλεγεί συγκεκριμένος φόρος για αυτό το προϊόν, θα εφαρμοστεί ο προεπιλεγμένος συντελεστής. Για να απενεργοποιήσετε τον φόρο για αυτό το προϊόν, αφαιρέστε τον προεπιλεγμένο φορολογικό συντελεστή από τις φορολογικές ρυθμίσεις.',
        'is_default' => 'Είναι προεπιλεγμένο',
        'action' => 'Ενέργεια',
        'restock_quantity' => 'Ποσότητα αναπλήρωσης',
        'remain' => 'Υπόλοιπο',
        'choose_discount_period' => 'Επιλέξτε Περίοδο Έκπτωσης',
        'cancel' => 'Ακύρωση',
        'no_results' => 'Δεν υπάρχουν αποτελέσματα!',
        'value' => 'Τιμή',
        'attribute_name' => 'Όνομα χαρακτηριστικού',
        'add_more_attribute' => 'Προσθήκη περισσότερων χαρακτηριστικών',
        'continue' => 'Συνέχεια',
        'add_new_attributes' => 'Προσθήκη νέων χαρακτηριστικών',
        'add_new_attributes_description' => 'Η προσθήκη νέων χαρακτηριστικών βοηθά το προϊόν να έχει πολλές επιλογές, όπως μέγεθος ή χρώμα.',
        'create_product_variations' => ':link για δημιουργία παραλλαγών προϊόντων!',
        'tags' => 'Ετικέτες',
        'write_some_tags' => 'Γράψτε μερικές ετικέτες',
        'variation_existed' => 'Αυτή η παραλλαγή υπάρχει ήδη.',
        'no_attributes_selected' => 'Δεν έχουν επιλεγεί χαρακτηριστικά!',
        'added_variation_success' => 'Η παραλλαγή προστέθηκε με επιτυχία!',
        'updated_variation_success' => 'Η παραλλαγή ενημερώθηκε με επιτυχία!',
        'created_all_variation_success' => 'Όλες οι παραλλαγές δημιουργήθηκαν με επιτυχία!',
        'updated_product_attributes_success' => 'Τα χαρακτηριστικά προϊόντος ενημερώθηκαν με επιτυχία!',
        'stock_status' => 'Κατάσταση αποθέματος',
        'auto_generate_sku' => 'Αυτόματη δημιουργία SKU;',
        'featured_image' => 'Εικόνα προβολής (προαιρετικό)',
        'product_id' => 'ID Προϊόντος',
        'price_sale_percent_helper' => 'Έκπτωση :percent από την αρχική τιμή.',
        'minimum_order_quantity' => 'Ελάχιστη ποσότητα παραγγελίας',
        'minimum_order_quantity_helper' => 'Ελάχιστη ποσότητα για παραγγελία, εάν η τιμή είναι 0, δεν υπάρχει όριο.',
        'maximum_order_quantity' => 'Μέγιστη ποσότητα παραγγελίας',
        'maximum_order_quantity_helper' => 'Μέγιστη ποσότητα για παραγγελία, εάν η τιμή είναι 0, δεν υπάρχει όριο.',
        'video' => 'Βίντεο',
        'video_file' => 'Αρχείο',
        'video_url' => 'Ή Εξωτερική Διεύθυνση URL Βίντεο',
        'video_url_help' => 'Εισάγετε διεύθυνση URL βίντεο YouTube ή Vimeo',
        'enter_video_url' => 'Εισάγετε διεύθυνση URL βίντεο',
        'video_thumbnail' => 'Μικρογραφία βίντεο',
        'video_thumbnail_help' => 'Επιλέξτε μια μικρογραφία για το βίντεο. Εάν δεν επιλεγεί, θα ληφθεί αυτόματα από τη διεύθυνση URL του βίντεο εάν είναι διαθέσιμη.',
        'barcode_existed' => 'Αυτό το barcode χρησιμοποιείται από άλλο προϊόν. Παρακαλώ εισάγετε άλλο barcode.',
        'barcode_helper' => 'Πρέπει να είναι μοναδικό για κάθε προϊόν.',
        'is_new_until' => 'Νέο έως',
        'is_new_until_helper' => 'Ορίστε μια ημερομηνία μέχρι την οποία αυτό το προϊόν θα επισημαίνεται ως "Νέο". Αφήστε κενό για να μην επισημαίνεται ως νέο με βάση την ημερομηνία.',
    ],
    'price' => 'Τιμή',
    'quantity' => 'Ποσότητα',
    'type' => 'Τύπος',
    'image' => 'Μικρογραφία',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU Παραλλαγής',
    'brand' => 'Μάρκα',
    'cannot_delete' => 'Το προϊόν δεν μπόρεσε να διαγραφεί',
    'product_deleted' => 'Το προϊόν διαγράφηκε',
    'product' => 'Προϊόν',
    'product_collections' => 'Συλλογές προϊόντων',
    'products' => 'Προϊόντα',
    'total_products_found' => ':total προϊόντα βρέθηκαν',
    'total_product_found' => ':total προϊόν βρέθηκε',
    'menu' => 'Προϊόντα',
    'control' => [
        'button_add_image' => 'Προσθήκη εικόνας',
    ],
    'price_sale' => 'Τιμή προσφοράς',
    'price_group_title' => 'Διαχείριση τιμής προϊόντος',
    'store_house_group_title' => 'Διαχείριση αποθήκης',
    'shipping_group_title' => 'Διαχείριση αποστολής',
    'overview' => 'Επισκόπηση',
    'attributes' => 'Χαρακτηριστικά',
    'product_has_variations' => 'Το προϊόν έχει παραλλαγές',
    'manage_products' => 'Διαχείριση προϊόντων',
    'add_new_product' => 'Προσθήκη νέου προϊόντος',
    'start_by_adding_new_product' => 'Ξεκινήστε προσθέτοντας νέα προϊόντα.',
    'edit_this_product' => 'Επεξεργασία αυτού του προϊόντος',
    'delete' => 'Διαγραφή',
    'related_products' => 'Σχετικά προϊόντα',
    'cross_selling_products' => 'Προϊόντα διασταυρούμενης πώλησης',
    'up_selling_products' => 'Προϊόντα ανοδικής πώλησης',
    'grouped_products' => 'Ομαδοποιημένα προϊόντα',
    'search_products' => 'Αναζήτηση προϊόντων',
    'selected_products' => 'Επιλεγμένα προϊόντα',
    'edit_variation_item' => 'Επεξεργασία',
    'variations_box_description' => 'Κάντε κλικ στο "Επεξεργασία χαρακτηριστικού" για προσθήκη/αφαίρεση χαρακτηριστικών παραλλαγής ή κάντε κλικ στο "Προσθήκη νέας παραλλαγής" για προσθήκη παραλλαγής.',
    'save_changes' => 'Αποθήκευση αλλαγών',
    'continue' => 'Συνέχεια',
    'edit_attribute' => 'Επεξεργασία χαρακτηριστικού',
    'select_attribute' => 'Επιλογή χαρακτηριστικού',
    'add_new_variation' => 'Προσθήκη νέας παραλλαγής',
    'edit_variation' => 'Επεξεργασία παραλλαγής',
    'generate_variations' => 'Δημιουργία παραλλαγών',
    'generate_variations_confirmation' => 'Είστε βέβαιοι ότι θέλετε να δημιουργήσετε παραλλαγές για αυτό το προϊόν;',
    'delete_variation' => 'Διαγραφή παραλλαγής;',
    'delete_variation_confirmation' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτή την παραλλαγή; Αυτή η ενέργεια δεν μπορεί να αναιρεθεί.',
    'delete_variations_confirmation' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτές τις παραλλαγές; Αυτή η ενέργεια δεν μπορεί να αναιρεθεί.',
    'product_create_validate_name_required' => 'Παρακαλώ εισάγετε όνομα προϊόντος',
    'product_create_validate_sale_price_max' => 'Η έκπτωση πρέπει να είναι μικρότερη από την αρχική τιμή',
    'product_create_validate_cost_per_item_max' => 'Το κόστος ανά τεμάχιο πρέπει να είναι μικρότερο από την αρχική τιμή',
    'product_create_validate_sale_price_required_if' => 'Πρέπει να εισάγετε έκπτωση όταν θέλετε να προγραμματίσετε μια προσφορά',
    'product_create_validate_end_date_after' => 'Η ημερομηνία λήξης πρέπει να είναι μετά την ημερομηνία έναρξης',
    'product_create_validate_start_date_required_if' => 'Η ημερομηνία έναρξης έκπτωσης δεν μπορεί να μείνει κενή όταν έχει επιλεγεί προγραμματισμός',
    'product_create_validate_sale_price' => 'Οι εκπτώσεις δεν μπορούν να μείνουν κενές όταν έχει επιλεγεί προγραμματισμός',
    'stock_statuses' => [
        'in_stock' => 'Σε απόθεμα',
        'out_of_stock' => 'Εξαντλημένο',
        'on_backorder' => 'Σε παραγγελία',
    ],
    'stock_status' => 'Κατάσταση αποθέματος',
    'processing' => 'Επεξεργασία...',
    'delete_selected_variations' => 'Διαγραφή επιλεγμένων παραλλαγών',
    'delete_variations' => 'Διαγραφή παραλλαγών',
    'category' => 'Κατηγορία',
    'categories' => 'Κατηγορίες',
    'tags' => 'Ετικέτες',
    'product_price_flash_sale_warning' => 'Αυτό το προϊόν είναι σε flash προσφορά <strong>:name</strong> οπότε η τιμή του είναι <strong>:price</strong>.',
    'product_price_discount_warning' => 'Αυτό το προϊόν είναι σε έκπτωση <strong>:name</strong> οπότε η τιμή του είναι <strong>:price</strong>.',
    'product_image' => 'Εικόνα προϊόντος',
    'product_name' => 'Όνομα προϊόντος',
    'product_link' => 'Σύνδεσμος προϊόντος',
    'types' => [
        'physical' => 'Φυσικό',
        'digital' => 'Ψηφιακό',
    ],
    'digital_attachments' => [
        'title' => 'Ψηφιακά συνημμένα',
        'add' => 'Προσθήκη Συνημμένου',
        'file_name' => 'Όνομα αρχείου',
        'file_size' => 'Μέγεθος αρχείου',
        'unsaved' => 'Μη αποθηκευμένο',
        'add_external_link' => 'Προσθήκη εξωτερικού συνδέσμου',
        'enter_file_name' => 'Εισάγετε όνομα αρχείου',
        'enter_external_link_download' => 'Εισάγετε εξωτερικό σύνδεσμο λήψης',
        'enter_file_size' => 'Εισάγετε μέγεθος αρχείου',
        'external_link_download' => 'Εξωτερικός σύνδεσμος λήψης',
        'generate_license_code_after_purchasing_product' => 'Ενεργοποίηση ανάθεσης κωδικού άδειας για αυτό το προϊόν',
        'notify_attachment_updated' => 'Αποστολή email στον πελάτη όταν ενημερώνεται το συνημμένο',
        'no_attachments' => 'Δεν υπάρχουν ακόμα συνημμένα. Κάντε κλικ στα κουμπιά παραπάνω για προσθήκη αρχείων.',
    ],
    'license_codes' => [
        'title' => 'Κωδικοί Άδειας',
        'add' => 'Προσθήκη Κωδικού Άδειας',
        'back' => 'Επιστροφή στο Προϊόν',
        'edit' => 'Επεξεργασία Κωδικού Άδειας',
        'generate' => 'Δημιουργία Κωδικών',
        'manage_codes' => 'Διαχείριση Κωδικών Άδειας',
        'management' => 'Διαχείριση Κωδικών Άδειας',
        'variation_breadcrumb' => 'Παραλλαγή: :name',
        'variation_label' => 'Παραλλαγή Προϊόντος',
        'variation_specific_note' => 'Αυτοί οι κωδικοί άδειας είναι συγκεκριμένοι για αυτή την παραλλαγή προϊόντος. Οι πελάτες που αγοράζουν αυτή την παραλλαγή θα λάβουν κωδικούς από αυτό το σύνολο.',
        'main_product_note' => 'Αυτό το προϊόν έχει παραλλαγές. Κάθε παραλλαγή μπορεί να έχει τους δικούς της κωδικούς άδειας, ή οι πελάτες μπορούν να λάβουν κωδικούς από αυτό το κύριο σύνολο προϊόντος εάν η παραλλαγή δεν έχει κωδικούς.',
        'code' => 'Κωδικός Άδειας',
        'codes' => 'Κωδικοί Άδειας',
        'status' => 'Κατάσταση',
        'assigned_at' => 'Ανατέθηκε Στις',
        'status_available' => 'Διαθέσιμο',
        'status_used' => 'Χρησιμοποιημένο',
        'statuses' => [
            'available' => 'Διαθέσιμο',
            'used' => 'Χρησιμοποιημένο',
        ],
        'no_codes' => 'Δεν βρέθηκαν κωδικοί άδειας. Προσθέστε κάποιους κωδικούς ή δημιουργήστε τους αυτόματα.',
        'no_codes_warning_title' => 'Δεν Υπάρχουν Διαθέσιμοι Κωδικοί Άδειας!',
        'no_codes_warning_message' => 'Αυτό το προϊόν έχει οριστεί σε "Επιλογή από Λίστα" αλλά δεν έχει διαθέσιμους κωδικούς άδειας. Οι πελάτες που αγοράζουν αυτό το προϊόν θα λάβουν αυτόματα δημιουργημένους κωδικούς. Παρακαλώ προσθέστε κωδικούς άδειας για να διασφαλίσετε τη σωστή λειτουργία.',
        'no_codes_auto_generate' => 'Αυτό το προϊόν έχει οριστεί να δημιουργεί αυτόματα κωδικούς άδειας. Δεν χρειάζονται χειροκίνητοι κωδικοί.',
        'used_code_no_actions' => 'Χρησιμοποιημένος κωδικός - δεν υπάρχουν διαθέσιμες ενέργειες',
        'created_successfully' => 'Ο κωδικός άδειας δημιουργήθηκε με επιτυχία!',
        'updated_successfully' => 'Ο κωδικός άδειας ενημερώθηκε με επιτυχία!',
        'deleted_successfully' => 'Ο κωδικός άδειας διαγράφηκε με επιτυχία!',
        'generated_successfully' => 'Δημιουργήθηκαν :count κωδικοί άδειας με επιτυχία!',
        'duplicates_skipped' => ':count διπλότυποι κωδικοί παραλείφθηκαν.',
        'generation_incomplete' => 'Προειδοποίηση: Μπόρεσαν να δημιουργηθούν μόνο :generated από τους :requested ζητούμενους κωδικούς λόγω συγκρούσεων διπλότυπων.',
        'cannot_edit_used_code' => 'Δεν είναι δυνατή η επεξεργασία χρησιμοποιημένου κωδικού άδειας.',
        'cannot_delete_used_code' => 'Δεν είναι δυνατή η διαγραφή χρησιμοποιημένου κωδικού άδειας.',
        'show_all' => 'Εμφάνιση όλων',
        'show_less' => 'Εμφάνιση λιγότερων',
        'more' => 'περισσότερο',
        'used_codes_hidden' => ':count χρησιμοποιημένοι κωδικοί άδειας είναι κρυφοί. Μπορείτε να δείτε όλους τους κωδικούς στη σελίδα Διαχείρισης Κωδικών Άδειας.',
        'low_stock_title' => 'Χαμηλό Απόθεμα Κωδικών Άδειας',
        'low_stock_message' => 'Απομένουν μόνο :count κωδικοί άδειας. Εξετάστε την προσθήκη περισσότερων κωδικών για να αποφύγετε την εξάντλησή τους.',
        'out_of_stock_title' => 'Εξαντλημένοι Κωδικοί Άδειας!',
        'out_of_stock_message' => 'Δεν υπάρχουν διαθέσιμοι κωδικοί άδειας. Οι πελάτες θα λάβουν αυτόματα δημιουργημένους κωδικούς μέχρι να προσθέσετε περισσότερους.',
        'type' => [
            'title' => 'Μέθοδος Ανάθεσης Κωδικού Άδειας',
            'auto_generate' => 'Αυτόματη Δημιουργία (Το σύστημα δημιουργεί κωδικούς αυτόματα)',
            'pick_from_list' => 'Επιλογή από Λίστα (Χρήση προεισαγμένων κωδικών)',
            'description' => 'Επιλέξτε πώς πρέπει να ανατίθενται οι κωδικοί άδειας στους πελάτες όταν αγοράζουν αυτό το προϊόν.',
        ],
        'add_modal' => [
            'placeholder' => 'π.χ., XXXX-XXXX-XXXX-XXXX',
            'help' => 'Εισάγετε έναν μοναδικό κωδικό άδειας που θα ανατεθεί σε έναν πελάτη κατά την αγορά.',
        ],
        'generate_modal' => [
            'title' => 'Δημιουργία Κωδικών Άδειας',
            'quantity' => 'Ποσότητα',
            'format' => 'Μορφή',
            'custom_pattern' => 'Προσαρμοσμένο Μοτίβο',
            'pattern_help' => 'Χρησιμοποιήστε # για αριθμούς, A για κεφαλαία γράμματα, a για πεζά γράμματα',
            'generate' => 'Δημιουργία',
        ],
        'errors' => [
            'feature_not_enabled' => 'Η λειτουργία κωδικών άδειας δεν είναι ενεργοποιημένη. Παρακαλώ ενεργοποιήστε την στις Ρυθμίσεις Ηλεκτρονικού Εμπορίου -> Ψηφιακά Προϊόντα.',
            'digital_products_not_enabled' => 'Τα ψηφιακά προϊόντα δεν είναι ενεργοποιημένα. Παρακαλώ ενεργοποιήστε πρώτα την υποστήριξη ψηφιακών προϊόντων.',
            'product_not_found' => 'Το προϊόν δεν βρέθηκε.',
            'not_digital_product' => 'Οι κωδικοί άδειας είναι διαθέσιμοι μόνο για ψηφιακά προϊόντα. Αυτό το προϊόν έχει οριστεί ως φυσικό προϊόν.',
            'license_codes_not_enabled_for_product' => 'Η διαχείριση κωδικών άδειας δεν είναι ενεργοποιημένη για αυτό το προϊόν. Παρακαλώ ενεργοποιήστε "Δημιουργία κωδικού άδειας μετά την αγορά προϊόντος" στις ρυθμίσεις προϊόντος.',
            'cannot_add_codes_auto_generate' => 'Δεν είναι δυνατή η χειροκίνητη προσθήκη κωδικών άδειας σε προϊόντα που έχουν οριστεί για αυτόματη δημιουργία. Αλλάξτε πρώτα τον τύπο κωδικού άδειας σε "Επιλογή από Λίστα".',
            'cannot_generate_codes_auto_generate' => 'Δεν είναι δυνατή η χειροκίνητη δημιουργία κωδικών άδειας για προϊόντα που έχουν οριστεί για αυτόματη δημιουργία. Αλλάξτε πρώτα τον τύπο κωδικού άδειας σε "Επιλογή από Λίστα".',
        ],
        'bulk_delete' => [
            'button' => 'Διαγραφή Επιλεγμένων',
            'selected' => 'επιλεγμένα',
            'confirm' => 'Είστε βέβαιοι ότι θέλετε να διαγράψετε τους επιλεγμένους κωδικούς άδειας;',
            'deleted_successfully' => 'Διαγράφηκαν με επιτυχία :count κωδικοί άδειας.',
            'skipped_used_codes' => ':count χρησιμοποιημένοι κωδικοί παραλείφθηκαν.',
            'no_deletable_codes' => 'Δεν βρέθηκαν διαθέσιμοι κωδικοί άδειας για διαγραφή. Οι χρησιμοποιημένοι κωδικοί δεν μπορούν να διαγραφούν.',
        ],
        'import' => [
            'name' => 'Εισαγωγή Κωδικών Άδειας Προϊόντος',
            'description' => 'Εισαγωγή κωδικών άδειας για ψηφιακά προϊόντα από αρχείο CSV/Excel.',
            'button' => 'Εισαγωγή',
            'columns' => [
                'product_id' => 'ID Προϊόντος ή SKU',
                'license_code' => 'Κωδικός Άδειας',
            ],
        ],
        'copied' => 'Ο κωδικός άδειας αντιγράφηκε στο πρόχειρο!',
    ],
    'this_action_will_reload_page' => 'Αυτή η ενέργεια θα επαναφορτώσει τη σελίδα για ενημέρωση των δεδομένων!',
    'select' => 'Επιλογή',
    'clear_filters' => 'Εκκαθάριση φίλτρων',
    'set_this_variant_as_default' => 'Ορισμός αυτής της παραλλαγής ως προεπιλεγμένη',
    'download' => 'Λήψη',
    'external_link_downloads' => 'Εξωτερικοί σύνδεσμοι',
    'download_available_when_completed' => 'Οι σύνδεσμοι λήψης θα είναι διαθέσιμοι όταν ολοκληρωθεί η παραγγελία.',
    'cross_sell_price_type' => [
        'title' => 'Τύπος τιμής',
        'fixed' => 'Σταθερή',
        'percent' => 'Ποσοστό',
    ],
    'cross_sell_help' => [
        'price' => '* Πεδίο τιμής',
        'price_description' => 'Εισάγετε το ποσό που θέλετε να μειώσετε από την αρχική τιμή. Παράδειγμα: Εάν η αρχική τιμή είναι $100, εισάγετε 20 για μείωση της τιμής στα $80.',
        'type' => '* Πεδίο τύπου',
        'type_description' => 'Επιλέξτε τον τύπο έκπτωσης: Σταθερή (μείωση συγκεκριμένου ποσού) ή Ποσοστό (μείωση κατά ποσοστό).',
    ],
    'up_sell_price_type' => [
        'title' => 'Τύπος τιμής',
        'fixed' => 'Σταθερή',
        'percent' => 'Ποσοστό',
    ],
    'up_sell_help' => [
        'price' => '* Πεδίο τιμής',
        'price_description' => 'Εισάγετε το ποσό που θέλετε να μειώσετε από την αρχική τιμή. Παράδειγμα: Εάν η αρχική τιμή είναι $100, εισάγετε 20 για μείωση της τιμής στα $80.',
        'type' => '* Πεδίο τύπου',
        'type_description' => 'Επιλέξτε τον τύπο έκπτωσης: Σταθερή (μείωση συγκεκριμένου ποσού) ή Ποσοστό (μείωση κατά ποσοστό).',
    ],
    'up_sale' => [
        'title' => 'Αγοράστε Μαζί & Εξοικονομήστε',
        'description' => 'Αποκτήστε ειδικές εκπτώσεις αγοράζοντας αυτά τα προϊόντα μαζί',
        'unlock_discount' => 'Προσθέστε :product στο καλάθι για ξεκλείδωμα έκπτωσης πακέτου',
        'multiple_options' => 'Πολλαπλές επιλογές',
        'multiple_options_available' => 'Διαθέσιμες πολλαπλές επιλογές',
        'select' => 'Επιλογή',
        'selected_items_total' => 'Σύνολο επιλεγμένων προϊόντων:',
        'add_selected_to_cart' => 'Προσθήκη Επιλεγμένων στο Καλάθι',
        'bundle_discount_with' => 'Έκπτωση πακέτου με :product',
        'bundle_with' => 'Πακέτο με :product',
    ],
    'cross_sale' => [
        'title' => 'Αγοράζονται Συχνά Μαζί',
        'description' => 'Οι πελάτες που είδαν αυτό το προϊόν αγόρασαν επίσης',
    ],
    'apply_for_all_variations' => 'Εφαρμογή για όλες τις παραλλαγές',
    'export' => [
        'description' => 'Εξαγωγή δεδομένων προϊόντων σε αρχεία CSV ή Excel.',
        'total_items' => 'Σύνολο Στοιχείων',
        'total_products' => 'Σύνολο Προϊόντων',
        'total_variations' => 'Σύνολο Παραλλαγών',
        'advanced_options' => 'Προηγμένες Επιλογές',
        'use_chunked_export' => 'Χρήση εξαγωγής σε τμήματα',
        'use_chunked_export_helper' => 'Επεξεργασία δεδομένων σε τμήματα για αποτελεσματική διαχείριση μεγάλων συνόλων δεδομένων',
        'include_variations' => 'Συμπερίληψη παραλλαγών προϊόντων',
        'include_variations_helper' => 'Εξαγωγή παραλλαγών προϊόντων μαζί με τα κύρια προϊόντα',
        'optimize_memory' => 'Βελτιστοποίηση χρήσης μνήμης',
        'optimize_memory_helper' => 'Ενεργοποίηση βελτιστοποίησης μνήμης για πολύ μεγάλες εξαγωγές',
        'chunk_size' => 'Μέγεθος τμήματος',
        'chunk_size_helper' => 'Αριθμός προϊόντων προς επεξεργασία κάθε φορά (50-5000)',
        'use_streaming' => 'Χρήση εξαγωγής ροής',
        'use_streaming_helper' => 'Ενεργοποίηση ροής για πολύ μεγάλα σύνολα δεδομένων (ενεργοποιείται αυτόματα για >10.000 στοιχεία)',
        'large_dataset_warning_title' => 'Εντοπίστηκε Μεγάλος Κατάλογος Προϊόντων',
        'large_dataset_warning_message' => 'Ο κατάλογός σας περιέχει :count στοιχεία. Λόγω του μεγάλου μεγέθους, ορισμένες επιλογές εξαγωγής έχουν βελτιστοποιηθεί για καλύτερη απόδοση.',
        'large_dataset_specific_message' => 'Για τα :count προϊόντα σας, χρησιμοποιήστε μορφή CSV με ενεργοποιημένη ροή. Το σύστημα μπορεί τώρα να διαχειριστεί τον μεγάλο κατάλογο προϊόντων σας αποτελεσματικά χωρίς χρονικά όρια ή προβλήματα μνήμης.',
        'format_label' => 'Μορφή',
        'csv_recommended' => 'CSV (Απαιτείται)',
        'chunk_label' => 'Επεξεργασία',
        'chunk_recommended' => '300 προϊόντα/παρτίδα',
        'time_label' => 'Εκτιμώμενος Χρόνος',
        'time_estimate' => '1-3 λεπτά',
        'pro_tip' => 'Συμβουλή:',
        'pro_tip_message' => 'Η εξαγωγή θα συνεχίσει να εκτελείται ακόμα κι αν το πρόγραμμα περιήγησής σας δείχνει ένδειξη φόρτωσης. Μόλις ξεκινήσει, η λήψη θα ξεκινήσει αυτόματα.',
        'large_dataset_tip_1' => 'Η μορφή Excel έχει απενεργοποιηθεί - χρησιμοποιήστε μορφή CSV για ταχύτερες και πιο αξιόπιστες εξαγωγές',
        'large_dataset_tip_2' => 'Η λειτουργία ροής έχει ενεργοποιηθεί αυτόματα για αποφυγή χρονικών ορίων',
        'large_dataset_tip_3' => 'Η διαδικασία εξαγωγής μπορεί να διαρκέσει 1-3 λεπτά ανάλογα με τον διακομιστή σας',
        'large_dataset_recommendation' => 'Συνιστάται: Χρησιμοποιήστε μορφή CSV με μέγεθος τμήματος 200-500 για βέλτιστη απόδοση.',
        'excel_disabled_for_large_export' => 'Η μορφή Excel δεν είναι διαθέσιμη για καταλόγους άνω των 10.000 στοιχείων',
        'streaming_auto_enabled' => 'Η λειτουργία ροής έχει ενεργοποιηθεί αυτόματα για βέλτιστη απόδοση με μεγάλα σύνολα δεδομένων.',
        'streaming_enabled_title' => 'Βελτιστοποιημένο για Μεγάλη Εξαγωγή',
        'streaming_enabled_message' => 'Η λειτουργία ροής είναι ενεργή για να διασφαλίσει ομαλή εξαγωγή χωρίς προβλήματα μνήμης.',
        'use_multi_file' => 'Χρήση εξαγωγής πολλαπλών αρχείων',
        'use_multi_file_helper' => 'Διαχωρισμός εξαγωγής σε πολλαπλά αρχεία συσκευασμένα σε ZIP για πολύ μεγάλα σύνολα δεδομένων',
        'multi_file_enabled_title' => 'Ενεργοποιήθηκε Εξαγωγή Πολλαπλών Αρχείων',
        'multi_file_enabled_message' => 'Η εξαγωγή σας θα διαχωριστεί σε :count αρχεία συσκευασμένα σε ZIP για βέλτιστη απόδοση.',
        'records_per_file' => 'Εγγραφές Ανά Αρχείο',
        'records_per_file_helper' => 'Αριθμός εγγραφών σε κάθε αρχείο κατά τη χρήση εξαγωγής πολλαπλών αρχείων',
        'estimated_files' => 'Εκτιμώμενα Αρχεία',
        'recommended_range' => 'Συνιστώμενο εύρος',
        'range_large_export' => '200-500 στοιχεία',
        'range_medium_export' => '300-800 στοιχεία',
        'range_small_export' => '500-1000 στοιχεία',
        'export_progress' => 'Πρόοδος Εξαγωγής',
        'preparing_export' => 'Προετοιμασία εξαγωγής...',
        'items_processed' => ':count στοιχεία επεξεργάστηκαν',
        'estimated_time_calculating' => 'Εκτιμώμενος χρόνος: υπολογισμός...',
        'medium_dataset_detected' => 'Εντοπίστηκε Μεσαίο Σύνολο Δεδομένων',
        'medium_dataset_message' => 'Εξάγετε :count προϊόντα. Εξετάστε τη χρήση εξαγωγής σε τμήματα για καλύτερη απόδοση.',
        'optimal_range' => 'Βέλτιστο εύρος',
        'too_small_slow' => 'Πολύ μικρό - μπορεί να είναι αργό',
        'too_large_timeouts' => 'Πολύ μεγάλο - μπορεί να προκαλέσει χρονικά όρια',
        'excel_disabled_warning' => 'Η μορφή Excel απενεργοποιήθηκε για μεγάλες εξαγωγές (:count στοιχεία)',
        'starting_export' => 'Έναρξη Εξαγωγής...',
        'processing_data' => 'Επεξεργασία δεδομένων...',
        'finalizing_export' => 'Ολοκλήρωση εξαγωγής...',
        'items_processed_suffix' => 'στοιχεία επεξεργάστηκαν',
        'estimated_time_prefix' => 'Εκτιμώμενος χρόνος:',
        'seconds_remaining' => 'δ υπολειπόμενα',
        'export_completed' => 'Η εξαγωγή ολοκληρώθηκε!',
        'download_starting' => 'Έναρξη λήψης...',
    ],
    'import' => [
        'description' => 'Εισαγωγή δεδομένων προϊόντων από αρχεία CSV ή Excel.',
        'rules' => [
            'in' => 'Το :attribute πρέπει να είναι μία από τις καθορισμένες τιμές: :values.',
            'required_string_max' => 'Το :attribute είναι υποχρεωτικό και πρέπει να είναι συμβολοσειρά με μέγιστο μήκος :max χαρακτήρες.',
            'nullable_string' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να είναι συμβολοσειρά εάν παρέχεται.',
            'nullable_string_max' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να είναι συμβολοσειρά με μέγιστο μήκος :max χαρακτήρες εάν παρέχεται',
            'nullable_bool' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να είναι boolean τιμή εάν παρέχεται.',
            'nullable_numeric_min' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να είναι μη αρνητικός αριθμός εάν παρέχεται.',
            'nullable_numeric_min_max' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να είναι αριθμός μεταξύ :min και :max εάν παρέχεται.',
            'nullable_array' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να παρέχεται ως πίνακας εάν καθορίζεται.',
            'nullable_date_required_if' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να είναι έγκυρη ημερομηνία εάν παρέχεται, υποχρεωτικό εάν καθορίζεται :required.',
            'nullable_date_after' => 'Το :attribute μπορεί να μείνει κενό ή πρέπει να είναι έγκυρη ημερομηνία μετά το :after εάν παρέχεται.',
        ],
        'updated_message' => 'Ενημερώθηκαν :count προϊόντα με επιτυχία!',
    ],
    'import_products_intro' => 'Ή εισαγωγή προϊόντων από CSV/Excel',
    'select_attributes' => 'Επιλέξτε χαρακτηριστικά για δημιουργία παραλλαγών:',
    'all' => 'Όλα',
    'copy' => 'Αντιγραφή',
    'product_translations' => 'Μεταφράσεις Προϊόντων',
    'view' => 'Προβολή προϊόντος - :name',
    'product_information' => 'Πληροφορίες Προϊόντος',
    'total_views' => 'Συνολικές Προβολές',
    'total_orders' => 'Ολοκληρωμένες Παραγγελίες',
    'total_sold' => 'Συνολικά Πωληθέντα',
    'total_revenue' => 'Συνολικά Έσοδα',
    'pending_orders' => 'Εκκρεμείς Παραγγελίες',
    'pending_revenue' => 'Εκκρεμή Έσοδα',
    'conversion_rate' => 'Ποσοστό Μετατροπής',
    'total_reviews' => 'Συνολικές Κριτικές',
    'average_rating' => 'Μέση Βαθμολογία',
    'views_by_date' => 'Προβολές ανά Ημερομηνία (Τελευταίες 30 Ημέρες)',
    'recent_orders' => 'Πρόσφατες Παραγγελίες',
    'no_views_data' => 'Δεν υπάρχουν διαθέσιμα δεδομένα προβολών για τις τελευταίες 30 ημέρες.',
    'no_orders' => 'Δεν υπάρχουν ακόμα παραγγελίες.',
    'date' => 'Ημερομηνία',
    'views' => 'Προβολές',
    'total' => 'Σύνολο',
    'view_on_frontend' => 'Προβολή στο Frontend',
    'select_attribute' => 'Επιλογή :name',
    'all_categories' => 'Όλες οι κατηγορίες',
    'brands' => 'Μάρκες',
    'browse_products' => 'Περιήγηση Προϊόντων',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Επιλέξτε Προϊόντα για Επιστροφή',
    'show_only_discounted_products' => 'Εμφάνιση μόνο προϊόντων με έκπτωση',
    'specification' => 'Προδιαγραφές',
    'download_product_with_external_links' => 'Λήψη προϊόντος ":name" με εξωτερικούς συνδέσμους',
    'number_product_available_singular' => ':number διαθέσιμο προϊόν',
    'number_products_available_plural' => ':number διαθέσιμα προϊόντα',
    'cart' => [
        'added_to_cart_success' => 'Το :product προστέθηκε στο καλάθι σας.',
        'removed_from_cart_success' => 'Το :product αφαιρέθηκε από το καλάθι σας.',
        'updated_cart_success' => 'Το καλάθι σας ενημερώθηκε.',
        'item_not_found' => 'Αυτό το προϊόν δεν βρίσκεται πλέον στο καλάθι σας.',
        'out_of_stock' => 'Λυπούμαστε, το :product είναι αυτή τη στιγμή εξαντλημένο.',
        'max_quantity' => 'Μπορείτε να προσθέσετε μόνο έως :max τεμάχια.',
        'max_quantity_detail' => 'Λυπούμαστε, μπορείτε να παραγγείλετε μόνο έως :quantity μονάδες του :product τη φορά.',
        'select_options' => 'Παρακαλώ επιλέξτε επιλογές προϊόντος πριν την προσθήκη στο καλάθι.',
        'product_out_of_stock' => 'Λυπούμαστε, αυτό το προϊόν είναι αυτή τη στιγμή εξαντλημένο.',
        'product_not_exists' => 'Αυτό το προϊόν είναι εξαντλημένο ή δεν υπάρχει πλέον.',
        'not_enough_quantity' => 'Ορισμένα προϊόντα δεν έχουν αρκετό απόθεμα για ενημέρωση.',
        'empty_success' => 'Το καλάθι σας άδειασε.',
        'bundle_item_already_in_cart' => 'Αυτό το προϊόν πακέτου υπάρχει ήδη στο καλάθι σας. Επιτρέπεται μόνο 1 τεμάχιο ανά έκπτωση πακέτου.',
    ],
    'wishlist' => [
        'added_success' => 'Το :product προστέθηκε στη λίστα επιθυμιών σας.',
        'removed_success' => 'Το :product αφαιρέθηκε από τη λίστα επιθυμιών σας.',
        'product_not_found' => 'Αυτό το προϊόν δεν βρέθηκε.',
        'product_not_in_wishlist' => 'Αυτό το προϊόν δεν βρίσκεται στη λίστα επιθυμιών σας.',
        'product_not_available' => 'Αυτό το προϊόν δεν είναι διαθέσιμο.',
    ],
    'compare' => [
        'added_success' => 'Το :product προστέθηκε στη λίστα σύγκρισής σας.',
        'removed_success' => 'Το :product αφαιρέθηκε από τη λίστα σύγκρισής σας.',
        'product_not_found' => 'Αυτό το προϊόν δεν βρέθηκε.',
        'product_not_in_compare' => 'Αυτό το προϊόν δεν βρίσκεται στη λίστα σύγκρισής σας.',
        'already_in_list' => 'Το :product υπάρχει ήδη στη λίστα σύγκρισής σας.',
    ],
];
