<?php

return [
    'save_settings' => 'Gem indstilling',
    'ecommerce' => 'E-handel',
    'general' => [
        'name' => 'Generelt',
        'description' => 'Butiksnavn, firmainfo, kontaktoplysninger og admin-notifikations-e-mails',
    ],
    'currency' => [
        'name' => 'Valutaer',
        'description' => 'Valutaformater, vekselkurser, auto-detektering og decimal-/tusindtalsseparatorer',
        'currency_setting_description' => 'Vis og opdater valutaer der bruges på hjemmesiden',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Aktiver automatisk registrering af besøgendes valuta',
            'enable_auto_detect_visitor_currency_helper' => 'Automatisk registrer og vis priser i besøgendes lokale valuta baseret på deres placering. Dette giver en mere personlig shoppingoplevelse.',
            'add_space_between_price_and_currency' => 'Tilføj mellemrum mellem pris og valuta',
            'add_space_between_price_and_currency_helper' => 'Når aktiveret, tilføjes et mellemrum mellem prisværdien og valutasymbolet (fx "100 DKK" i stedet for "100DKK").',
            'thousands_separator' => 'Tusindtals separator',
            'thousands_separator_helper' => 'Vælg tegnet til at adskille tusinder i prisvisning (fx 1.000 eller 1,000 eller 1 000).',
            'decimal_separator' => 'Decimal separator',
            'decimal_separator_helper' => 'Vælg tegnet til at adskille decimalværdier i priser (fx 10,99 eller 10.99).',
            'separator_period' => 'Punktum (.)',
            'separator_comma' => 'Komma (,)',
            'separator_space' => 'Mellemrum ( )',
            'api_key' => 'API valutakurs nøgle',
            'api_key_helper' => 'Hent valutakurs API-nøgle på :link',
            'update_currency_rates' => 'Opdater valutakurser',
            'use_exchange_rate_from_api' => 'Brug valutakurs fra API',
            'use_exchange_rate_from_api_helper' => 'Aktiver automatiske valutakursopdateringer fra den konfigurerede API-udbyder. Dette sikrer, at dine priser altid er opdaterede med aktuelle markedsrater.',
            'clear_cache_rates' => 'Ryd cache kurser',
            'auto_detect_visitor_currency_description' => 'Den registrerer besøgendes valuta baseret på browsersprog. Den vil tilsidesætte standard valutavalg.',
            'exchange_rate' => [
                'api_provider' => 'API-udbyder',
                'select' => '-- Vælg --',
                'none' => 'Ingen',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App-ID',
            ],
            'default_currency_warning' => 'For standardvalutaen skal valutakursen være 1.',
        ],
    ],
    'product' => [
        'name' => 'Produkter',
        'description' => 'Lagervisning, SKU-generering, variantbilleder, relaterede produkter og specifikationer',
        'product_settings' => 'Produktindstillinger',
        'product_settings_description' => 'Konfigurer regler for produkt',
        'form' => [
            'show_number_of_products' => 'Vis antal produkter på produktsiden',
            'show_number_of_products_helper' => 'Vis det samlede antal produkter på produktdetaljeside.',
            'show_out_of_stock_products' => 'Vis udsolgte produkter',
            'show_out_of_stock_products_helper' => 'Hvis aktiveret, vises udsolgte produkter på produktlistesiden.',
            'how_to_display_product_variation_images' => 'Hvordan produktvariantbilleder vises',
            'how_to_display_product_variation_images_helper' => 'Vælg om der kun skal vises variantspecifikke billeder eller inkludere både variant- og hovedproduktbilleder.',
            'only_variation_images' => 'Kun variantbilleder',
            'variation_images_and_main_product_images' => 'Variantbilleder og hovedproduktbilleder',
            'enable_product_options' => 'Aktiver produktmuligheder',
            'enable_product_options_helper' => 'Tillad produkter at have tilpassede muligheder som størrelse, farve osv.',
            'is_enabled_cross_sale_products' => 'Aktiver krydssalgsprodukter',
            'is_enabled_cross_sale_products_helper' => 'Vis krydssalgsproduktforslag for at tilskynde til yderligere køb.',
            'is_enabled_related_products' => 'Aktiver relaterede produkter',
            'is_enabled_related_products_helper' => 'Vis relaterede produkter baseret på kategori, eller valgt af admin i produktformular.',
            'related_products_source' => 'Relaterede produkter kilde',
            'related_products_source_helper' => 'Når admin ikke vælger relaterede produkter i produktformular, vis relaterede produkter baseret på denne kilde.',
            'related_products_source_category' => 'Samme kategori',
            'related_products_source_brand' => 'Samme brand',
            'trending_products_period' => 'Trending produkter periode',
            'trending_products_period_helper' => 'Vælg tidsperioden til at overveje for beregning af trending produkter baseret på visningstal.',
            'trending_products_period_1_day' => 'Sidste 24 timer',
            'trending_products_period_3_days' => 'Sidste 3 dage',
            'trending_products_period_7_days' => 'Sidste 7 dage (1 uge)',
            'trending_products_period_14_days' => 'Sidste 14 dage (2 uger)',
            'trending_products_period_30_days' => 'Sidste 30 dage (1 måned)',
            'trending_products_period_60_days' => 'Sidste 60 dage (2 måneder)',
            'trending_products_period_90_days' => 'Sidste 90 dage (3 måneder)',
            'auto_generate_product_sku' => 'Autogenerer SKU ved oprettelse af produkt',
            'auto_generate_product_sku_helper' => 'Generer automatisk unikke SKU\'er for nye produkter baseret på formatet nedenfor.',
            'product_sku_format' => 'SKU-format',
            'product_sku_format_helper' => 'Du kan bruge %s (1 strengtegn) eller %d (1 ciffer) i formatet for at generere tilfældig streng. Fx: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Aktiver produktspecifikation',
            'enable_product_specification_help' => 'Hvis aktiveret, vises produktspecifikationstabellen på produktdetaljeside.',
            'make_product_barcode_required' => 'Gør produktstregkode påkrævet',
            'make_product_barcode_required_helper' => 'Hvis aktiveret, vil produktstregkoden være påkrævet ved oprettelse af et produkt.',
        ],
    ],
    'product_search' => [
        'name' => 'Produktsøgning',
        'description' => 'Søgeadfærd, filtre efter kategori/mærke/tag/attributter og prisintervalfiltrering',
        'product_search_settings' => 'Produktsøgning',
        'product_search_settings_description' => 'Konfigurer regler for produktsøgning',
        'form' => [
            'search_for_an_exact_phrase' => 'Søg efter en nøjagtig sætning',
            'search_products_by' => 'Søg produkter efter:',
            'enable_filter_products_by_categories' => 'Aktiver filtrer produkter efter kategorier',
            'enable_filter_products_by_brands' => 'Aktiver filtrer produkter efter brands',
            'enable_filter_products_by_tags' => 'Aktiver filtrer produkter efter tags',
            'number_of_popular_tags_for_filter' => 'Antal populære tags til filter',
            'number_of_popular_tags_for_filter_placeholder' => 'Indtast antal populære tags til visning',
            'number_of_popular_tags_for_filter_helper' => 'Indstil det maksimale antal populære tags til visning i filteret. Standard er 10.',
            'enable_filter_products_by_attributes' => 'Aktiver filtrer produkter efter attributter',
            'enable_filter_products_by_price' => 'Aktiver filtrer produkter efter pris',
            'max_product_price_for_filter' => 'Maks produktpris til filter',
            'max_product_price_for_filter_placeholder' => 'Hvis den er tom eller nul, hentes den maksimale produktpris fra dine eksisterende produkter.',
            'max_product_price_for_filter_helper' => 'Du kan indstille en fast pris for dette, eller den vil dynamisk hente den maksimale produktpris fra dine eksisterende produkter. I øjeblikket er den :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Digitale produkter',
        'description' => 'Downloadbare produkter, licenskoder, gæstekasse for digitale varer og automatisk fuldførelse',
        'digital_products_settings' => 'Digitale produkter',
        'digital_products_settings_description' => 'Konfigurer regler for digitale produkter',
        'form' => [
            'enable_support_digital_product' => 'Er det aktiveret til at understøtte digitale produkter',
            'enable_support_digital_product_helper' => 'Når aktiveret, vil systemet understøtte salg af digitale produkter såsom software, e-bøger, musik og andet downloadbart indhold.',
            'allow_guest_checkout_for_digital_products' => 'Tillad gæstebetaling for digitale produkter',
            'allow_guest_checkout_for_digital_products_helper' => 'Når aktiveret, kan kunder købe digitale produkter uden at oprette en konto. De modtager downloadlinks via e-mail.',
            'disable_physical_product' => 'Deaktiver fysisk produkt',
            'disable_physical_product_helper' => 'Når aktiveret, vil butikken kun sælge digitale produkter. Fysiske produktmuligheder vil blive skjult fra produktformularer og betaling.',
            'enable_license_codes_for_digital_products' => 'Aktiver licenskoder for digitale produkter',
            'auto_complete_digital_orders_after_payment' => 'Afslut digitale ordrer automatisk efter betaling',
            'auto_complete_digital_orders_after_payment_helper' => 'Når aktiveret, vil ordrer der kun indeholder digitale produkter automatisk blive markeret som gennemførte når betaling er modtaget.',
            'enable_license_codes_for_digital_products_helper' => 'Når aktiveret, kan du tilføje licenskoder til digitale produkter. Når deaktiveret, vil licenskode funktionalitet være skjult fra produktformularer.',
            'hide_used_license_codes_in_product_form' => 'Skjul brugte licenskoder i produktformular',
            'hide_used_license_codes_in_product_form_helper' => 'Når aktiveret, vil brugte licenskoder blive skjult fra licenskode tabellen i produktredigeringsformularen. Dette hjælper med at holde grænsefladen ren når du har mange brugte koder.',
        ],
    ],
    'product_review' => [
        'name' => 'Produktanmeldelser',
        'description' => 'Kundeanmeldelser, vurderingsvisning, billedupload og godkendelseskrav',
        'form' => [
            'enable_review' => 'Aktiver produktanmeldelser',
            'enable_review_help' => 'Tillad kunder at afgive anmeldelser og bedømmelser på produkter. Når deaktiveret, vil alle anmeldelsesfunktioner være skjult fra butikken.',
            'allow_customer_upload_image_in_review' => 'Tillad kunder at uploade billeder i anmeldelser',
            'allow_customer_upload_image_in_review_help' => 'Når deaktiveret, kan kunder ikke uploade billeder ved indsendelse af anmeldelser',
            'review' => [
                'max_file_size' => 'Anmeldelse maks filstørrelse (MB)',
                'max_file_number' => 'Anmeldelse maks antal filer',
            ],
            'only_allow_customers_purchased_to_review' => 'Kun kunder der har købt produktet kan anmelde produktet',
            'review_need_to_be_approved' => 'Anmeldelse skal godkendes før visning på produktsiden',
            'show_customer_full_name' => 'Vis kundens fulde navn',
            'show_customer_full_name_help' => 'Hvis det er fravalgt, vil navnet på den anmeldende kunde blive skjult og erstattet med stjerner (***)',
            'hide_rating_when_no_reviews' => 'Skjul bedømmelse når der ikke er anmeldelser',
            'hide_rating_when_no_reviews_help' => 'Når aktiveret, vil produktbedømmelser blive skjult i produktlister og produktdetaljeside når produktet ikke har anmeldelser',
            'display_uploaded_customer_review_images_list' => 'Vis "Billeder fra kunder" sektion',
            'display_uploaded_customer_review_images_list_help' => 'Når aktiveret, vises et galleri af alle kunde uploadede billeder øverst i anmeldelsessektionen',
        ],
    ],
    'shopping' => [
        'name' => 'Shopping',
        'description' => 'Kurv, ønskeliste, sammenlign, ordresporing, hurtigkøb-knap og upload af betalingsbevis',
        'general_setting' => 'Generelle indstillinger',
        'return_settings' => 'Returindstillinger',
        'return_settings_description' => 'Konfigurer regler for returindstillinger',
        'form' => [
            'enable_cart' => 'Aktiver indkøbskurv',
            'enable_cart_helper' => 'Hvis deaktiveret, fjernes kurvknappen, hvilket gør din side til en katalogvisning.',
            'enable_wishlist' => 'Aktiver ønskeliste',
            'enable_wishlist_helper' => 'Hvis deaktiveret, fjernes ønskelisteknappen fra siden.',
            'enable_wishlist_sharing' => 'Aktiver deling af ønskeliste',
            'shared_wishlist_lifetime' => 'Delt ønskeliste levetid (dage)',
            'shared_wishlist_lifetime_helper' => 'Levetiden for den delte ønskeliste i dage. Efter denne tid slettes den delte ønskeliste.',
            'enable_compare' => 'Aktiver sammenlign',
            'enable_compare_helper' => 'Hvis deaktiveret, fjernes sammenligningsknappen fra siden.',
            'enable_order_tracking' => 'Aktiver ordresporing',
            'enable_order_tracking_helper' => 'Kunder kan spore deres ordrer ved at indtaste ordrekoden og e-mail/telefon på :url',
            'order_tracking_method' => 'Ordresporingsmetode',
            'order_tracking_method_helper' => 'Vælg hvordan kunder vil spore deres ordrer: ved hjælp af Ordre-ID + E-mail eller Ordre-ID + Telefonnummer.',
            'order_tracking_method_email' => 'Ordre-ID + E-mail',
            'order_tracking_method_phone' => 'Ordre-ID + Telefonnummer',
            'enable_quick_buy_button' => 'Aktiver hurtigkøbsknap',
            'enable_quick_buy_button_helper' => 'Det vil vise en Køb nu-knap på produktliste- og detaljeside. Når kunder klikker på denne knap, tilføjes produktet til kurven og omdirigerer til kurv/betalingssiden.',
            'enable_order_auto_confirmed' => 'Autobekræft ordre',
            'enable_order_auto_confirmed_helper' => 'Hvis aktiveret, bekræftes ordren automatisk efter at kunden har afgivet en ordre.',
            'quick_buy_target' => 'Hurtigkøb målside',
            'checkout_page' => 'Betalingsside',
            'cart_page' => 'Kurvside',
            'cart_destroy_on_logout' => 'Ødelæg kurv ved logout',
            'cart_destroy_on_logout_helper' => 'Kurven ødelægges når kunden logger ud.',
            'hide_product_price' => 'Skjul produktpris',
            'hide_product_price_helper' => 'Denne mulighed virker kun hvis du deaktiverer indkøbskurv, hvilket gør din side til en katalogvisning. Hvis aktiveret, skjules produktprisen. Det er nyttigt når du vil skjule prisen og kræve at kunder kontakter dig for prisen.',
            'hide_product_price_when_zero' => 'Skjul produktpris når den er nul',
            'hide_product_price_when_zero_helper' => 'Hvis aktiveret, vises prisen ikke for produkter med pris 0 i butikken.',
            'enable_payment_proof' => 'Aktiver betalingsbevis upload',
            'enable_payment_proof_helper' => 'Tillad kunder at uploade betalingsbevis for deres ordrer. Dette er nyttigt for manuelle betalingsmetoder.',
            'enable_guest_payment_proof' => 'Tillad gæstekunder at uploade betalingsbevis',
            'enable_guest_payment_proof_helper' => 'Når aktiveret, kan gæstekunder uploade betalingsbevis ved hjælp af deres ordretoken uden at logge ind. De modtager uploadlinket i deres ordrebekræftelses-e-mail.',
            'payment_proof_payment_methods' => 'Betalingsmetoder, der kræver betalingsbevis',
            'payment_proof_payment_methods_helper' => 'Vælg hvilke betalingsmetoder, der skal give kunderne mulighed for at uploade betalingsbevis. Bruges typisk til manuelle betalingsmetoder som efterkrav og bankoverførsel.',
        ],
    ],
    'checkout' => [
        'name' => 'Betaling',
        'panel_description' => 'Gæstekasse, påkrævede felter, ordrebegrænsninger, accept af vilkår og landebegrænsninger',
        'description' => 'Konfigurer regler for betalingsindstillinger',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Vis bankinfo på betalingssuccessiden',
            'mandatory_form_fields_at_checkout' => 'Obligatoriske felter på betalingssiden:',
            'mandatory_form_fields_at_checkout_helper' => 'Vælg hvilke felter der er påkrævet under betaling. Kunder skal udfylde disse felter for at gennemføre deres ordre.',
            'hide_form_fields_at_checkout' => 'Skjul kundefelter på betalingssiden:',
            'hide_form_fields_at_checkout_helper' => 'Vælg hvilke felter der skal skjules på betalingssiden. Disse felter vil ikke være synlige for kunder.',
            'load_countries_states_cities_from_location_plugin' => 'Indlæs lande, regioner, byer fra lokations-plugin',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Efter ændring af denne mulighed skal du opdatere alle adresser igen. Du bør indstille den én gang.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Derefter skal du gå til Værktøjer -> Import/Eksport data for at importere lokationsdata.',
            'minimum_order_amount' => 'Minimum ordrebeløb for at afgive en ordre (:currency).',
            'minimum_order_amount_helper' => 'Indstil det mindste samlede beløb der kræves for at en ordre behandles. Ordrer under dette beløb accepteres ikke.',
            'zip_code_enabled' => 'Aktiver postnummer',
            'zip_code_enabled_helper' => 'Aktiver eller deaktiver postnummer/postkodefelt i leveringsadresseformularen.',
            'billing_address_enabled' => 'Aktiver fakturaadresse',
            'billing_address_enabled_helper' => 'Tillad kunder at indtaste en separat fakturaadresse der adskiller sig fra deres leveringsadresse.',
            'display_tax_fields_at_checkout_page' => 'Vis momsinformationsfelter på betalingssiden',
            'display_tax_fields_at_checkout_page_helper' => 'Hvis aktiveret, vises momsinformationsfelter til indtastning af virksomheds momsdetaljer for at modtage en faktura.',
            'use_city_field_as_field_text' => 'Brug byfelt som fritekstefelt',
            'available_countries' => 'Tilgængelige lande',
            'all' => 'Alle',
            'all_helper_text' => 'Hvis du fravælger alle lande, gælder det for alle lande.',
            'enable_guest_checkout' => 'Aktiver gæstebetaling',
            'enable_guest_checkout_helper' => 'Hvis aktiveret, kan kunder afgive en ordre uden at oprette en konto.',
            'recently_viewed' => [
                'enable' => 'Aktiver kundes senest viste produkter',
                'enable_helper' => 'Spor og vis produkter som kunder for nylig har set. Dette hjælper kunder med nemt at finde produkter de var interesserede i.',
                'max' => 'Maksimalt antal kundes senest viste produkter',
                'max_helper_text' => 'Hvis indstillet til 0, vil der ikke være nogen grænse.',
            ],
            'minimum_order_quantity' => 'Minimum ordreantal',
            'minimum_order_quantity_helper' => 'Minimum antal for at afgive en ordre. Lad det være 0 hvis du ikke vil indstille det.',
            'maximum_order_quantity' => 'Maksimum ordreantal',
            'maximum_order_quantity_helper' => 'Maksimum antal for at afgive en ordre. Lad det være 0 hvis du ikke vil indstille det.',
            'default_country_at_checkout_page' => 'Standardland på betalingssiden',
            'default_country_at_checkout_page_placeholder' => 'Vælg et land',
            'default_country_at_checkout_page_help' => 'Hvis du vælger et land, vælges landet som standard på betalingssiden.',
            'checkout_product_quantity_editable' => 'Tillad kunder at ændre produktantal på betalingssiden',
            'checkout_product_quantity_editable_helper' => 'Når aktiveret, kan kunder ændre antallet af produkter direkte på betalingssiden uden at vende tilbage til kurven.',
            'show_terms_and_policy_checkbox' => 'Vis vilkår og politik afkrydsningsfelt',
            'show_terms_and_policy_checkbox_helper' => 'Hvis aktiveret, skal kunder acceptere vilkårene og politikken før de afgiver en ordre. Opsæt venligst Vilkår og privatlivspolitik URL i Udseende -> Temaindstillinger først.',
            'terms_and_policy_checkbox_checked_by_default' => 'Vilkår og politik afkrydsningsfelt markeret som standard',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Hvis aktiveret, vil vilkår og politik afkrydsningsfeltet være forudmarkeret når betalingsformularen indlæses.',
            'checkout_acceptance_message_enabled' => 'Vis betalingsacceptbesked',
            'checkout_acceptance_message_enabled_helper' => 'Vis en informationsbesked der informerer kunder om vilkårene de accepterer ved at afgive en ordre.',
            'hide_customer_info_at_checkout' => 'Skjul kundeinfo ved betaling',
            'hide_customer_info_at_checkout_helper' => 'Skjul kundekontooplysninger og logout-knappen fra betalingssiden. Når aktiveret, vil indloggede kunder ikke se deres kontodetaljer vist.',
        ],
    ],
    'return' => [
        'name' => 'Retur',
        'description' => 'Konfigurer regler for returindstillinger',
        'panel_description' => 'Returneringer, delvise returneringer og returfrister',
        'form' => [
            'is_enabled_order_return' => 'Er ordreretur aktiveret',
            'allow_partial_return' => 'Tillad delvis retur',
            'allow_partial_return_description' => 'Kunde kan returnere nogle få produkter, behøver ikke at returnere alle produkter i en ordre.',
            'returnable_days' => 'Returdage',
            'return_settings_helper' => 'Antal dage en kunde kan anmode om en retur efter ordren er gennemført.',
        ],
    ],
    'invoice' => [
        'name' => 'Fakturaer',
        'description' => 'Firmadetaljer på fakturaer, fakturanummerering, PDF-skrifttyper og stempelindstillinger',
        'company_settings' => 'Invoice configuration',
        'company_settings_description' => 'Company info, invoice numbering, PDF fonts, and payment stamp',
        'form' => [
            'company_name' => 'Virksomhedsnavn',
            'company_address' => 'Virksomhedsadresse',
            'company_zipcode' => 'Virksomhedspostnummer',
            'company_email' => 'Virksomheds e-mail',
            'company_phone' => 'Virksomhedstelefon',
            'company_logo' => 'Virksomhedslogo',
            'company_tax_id' => 'Virksomheds CVR-nummer',
            'invoice_code_prefix' => 'Fakturakode præfiks',
            'using_custom_font_for_invoice' => 'Brug tilpasset skrifttype til faktura',
            'invoice_font_family' => 'Faktura skrifttypefamilie (Virker kun for latinsk sprog)',
            'enable_invoice_stamp' => 'Aktiver fakturastempel',
            'add_language_support' => 'Tilføj sprogsupport',
            'invoice_processing_library' => 'Fakturabehandlingsbibliotek',
            'only_latin_languages' => 'Kun latinske sprog',
            'disable_order_invoice_until_order_confirmed' => 'Deaktiver ordrefaktura indtil ordre bekræftet',
            'date_format' => 'Datoformat',
            'languages' => [
                'arabic' => 'Arabisk',
                'bangladesh' => 'Bengali',
                'chinese' => 'Kinesisk',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Moms',
        'description' => 'Tax calculation, display options, and checkout invoice fields',
        'enable' => 'Aktiver moms?',
        'display_product_price_including_taxes' => 'Vis produktpris inklusiv moms?',
        'display_tax_description' => 'Vis momsinformation på produktpris?',
        'display_tax_description_help' => 'Vis tekst som "(Inklusiv X% moms)" eller "(Eksklusiv X% moms)" ved siden af produktpriser på produktdetaljeside.',
        'tax_included_in_products_price' => 'Moms inkluderet i produktpriser',
        'tax_included_in_products_price_description' => 'Moms vil være inkluderet i produktpriser',
        'tax_setting' => 'Tax display & checkout',
        'tax_setting_description' => 'Configure how taxes are displayed on products and checkout pages',
        'tax_management' => 'Momsstyring',
        'tax_management_description' => 'Vis og administrer dine moms',

        'manage_taxes_info' => 'For at administrere skatter og indstille standardskattesats, gå venligst til',
        'go_to_taxes' => 'E-handel → Skatter',        'form' => [
            'enable_tax' => 'Aktiver moms',
            'display_company_invoice_information_fields_at_checkout_page' => 'Vis virksomhedsfakturainformationsfelter på betalingssiden',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Hvis det er aktiveret, vises virksomhedsfakturainformationsfelterne på betalingssiden. Det er påkrævet at udfylde virksomhedsfakturainformationsfelterne.',
            'default_tax_rate' => 'Standard momssats',
            'default_tax_rate_description' => 'Vigtigt: den anvendes hvis ingen moms er valgt i produktet.',
            'select_tax' => '-- Vælg --',
            'display_product_price_including_taxes' => 'Tilføj moms til viste priser',
            'display_product_price_including_taxes_helper' => 'Tilføjer automatisk moms til produktpriser vist i butikken. F.eks. vises et $100 produkt med 10% moms som $110. Ikke nødvendigt hvis "Pris inkluderer moms" allerede er aktiveret på individuelle produkter.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Kunder',
        'description' => 'Registrering, e-mailbekræftelse, login-muligheder, kontosletning og profilfelter',
        'customer_setting' => 'Kundeindstillinger',
        'customer_setting_description' => 'Konfigurer kundeindstillinger',
        'form' => [
            'enable_customer_registration' => 'Aktiver kunderegistrering',
            'enable_customer_registration_helper' => 'Hvis deaktiveret, vil kunder ikke kunne registrere nye konti. Eksisterende kunder kan stadig logge ind.',
            'verify_customer_email' => 'Verificer kundens e-mail',
            'verify_customer_email_helper' => 'Når det er aktiveret, sendes et verificeringslink til kundens e-mail, kunder skal klikke på dette link for at verificere deres e-mail før de kan logge ind. Skal konfigurere e-mail i Admin -> Indstillinger -> E-mail for at sende e-mailverificering.',
            'verification_expire_minutes' => 'Verificeringslinkudløbstid',
            'verification_expire_minutes_helper' => 'Tiden i minutter som e-mailverificeringslinket vil være gyldigt. Standard er 60 minutter (1 time). Maksimum er 10080 minutter (7 dage).',
            'login_using_phone' => 'Log ind med telefonnummer i stedet for e-mail',
            'login_option' => 'Login mulighed',
            'login_with_email' => 'Login med e-mail',
            'login_with_phone' => 'Login med telefon',
            'login_with_email_or_phone' => 'Login med e-mail eller telefon',
            'enabled_customer_account_deletion' => 'Aktiver kundekontosletning',
            'enabled_customer_account_deletion_helper' => 'Når det er aktiveret, kan kunder slette deres konto i kunde dashboard → Kontoindstillinger.',
            'enabled_customer_dob_field' => 'Aktiver kundens fødselsdatofelt',
            'enabled_customer_dob_field_helper' => 'Når det er aktiveret, kan kunder indtaste deres fødselsdato i kunde dashboard → Kontoindstillinger.',
            'enabled_phone_field_in_registration_form' => 'Aktiver telefonfelt i registreringsformular',
            'enabled_phone_field_in_registration_form_helper' => 'Når det er aktiveret, tilføjes telefonfelt til registreringsformularen.',
            'make_customer_phone_number_required' => 'Gør kundens telefonnummer påkrævet',
            'make_customer_phone_number_required_helper' => 'Når aktiveret, skal kunder indtaste deres telefonnummer under registrering. Det er altid påkrævet for kunder der logger ind med et telefonnummer.',
            'default_avatar' => 'Standard avatar',
            'default_avatar_helper' => 'Standard avatar for kunde når de ikke har en avatar. Hvis du ikke vælger noget billede, genereres det ved hjælp af dit logo eller det første tegn i kundens navn.',
            'keep_email_field_in_registration_form' => 'Behold e-mailfelt i registreringsformular',
            'keep_email_field_in_registration_form_helper' => 'Når det er deaktiveret, skjules e-mailfeltet i registreringsformularen når login mulighed er "Login med telefon".',
        ],
    ],
    'shipping' => [
        'name' => 'Fragt',
        'description' => 'Forsendelsesregler, gratis forsendelsesadfærd og visningsrækkefølge for forsendelsesmuligheder',
        'shipping_rule' => 'Fragtregler',
        'shipping_rule_description' => 'Konfigurer regler til beregning af fragtomkostning',
        'shipping_setting' => 'Fragtindstillinger',
        'shipping_setting_description' => 'Konfigurer fragtindstillinger',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Skjul andre fragtmuligheder hvis den har gratis fragt på listen',
            'disable_shipping_options' => 'Deaktiver fragtmuligheder',
            'disable_shipping_options_helper' => 'Fragtmuligheder fjernes på betalingssiden, kunde vil ikke kunne vælge fragtmuligheder.',
            'sort_shipping_options_direction' => 'Sorter fragtmuligheder retning',
            'sort_shipping_options_direction_helper' => 'Sorter fragtmuligheder efter pris lavere til højere eller højere til lavere.',
            'price_lower_to_higher' => 'Pris lavere til højere',
            'price_higher_to_lower' => 'Pris højere til lavere',
        ],
    ],
    'webhook' => [
        'name' => 'Webhooks',
        'description' => 'Send order events to external services via HTTP callbacks',
        'webhook_setting' => 'Order event webhooks',
        'webhook_setting_description' => 'Konfigurer webhook URL\'er for at modtage notifikationer for forskellige ordrebegivenheder',
        'form' => [
            'order_placed_webhook_url' => 'Ordre afgivet webhook URL (metode: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'For at modtage notifikationer når en ordre er afgivet, kan du opsætte en ekstern webhook URL. Hvis du har en ekstern webhook URL, kan du indtaste denne URL, eller bare lade den være tom.',
            'order_updated_webhook_url' => 'Ordre opdateret webhook URL (metode: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'For at modtage notifikationer når en ordre opdateres, kan du opsætte en ekstern webhook URL. Dette inkluderer statusændringer, adresseopdateringer og andre ordreændringer.',
            'shipping_status_updated_webhook_url' => 'Fragtstatus opdateret webhook URL (metode: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'For at modtage notifikationer når fragtstatus ændres (fx sendt, leveret, annulleret), kan du opsætte en ekstern webhook URL.',
            'order_completed_webhook_url' => 'Ordre gennemført webhook URL (metode: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'For at modtage notifikationer når en ordre er gennemført, kan du opsætte en ekstern webhook URL.',
            'order_cancelled_webhook_url' => 'Ordre annulleret webhook URL (metode: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'For at modtage notifikationer når en ordre annulleres, kan du opsætte en ekstern webhook URL.',
            'payment_status_updated_webhook_url' => 'Betalingsstatus opdateret webhook URL (metode: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'For at modtage notifikationer når betalingsstatus ændres (fx betalt, mislykket, refunderet), kan du opsætte en ekstern webhook URL.',
            'abandoned_cart_webhook_url' => 'Forladt kurv webhook URL (metode: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'For at modtage notifikationer når kurve forlades og følge op med kunder, kan du opsætte en ekstern webhook URL. Notifikationer sendes efter en konfigurerbar tidsperiode.',
        ],
        'test_button' => 'Test webhook',
        'test_success' => 'Webhook test succesfuld! Endepunktet svarede korrekt.',
        'test_failed' => 'Webhook test mislykkedes. Endepunktet svarede ikke som forventet.',
        'test_error' => 'Webhook test fejl: :error',
        'please_enter_url' => 'Indtast venligst en webhook URL først',
        'testing' => 'Tester...',
        'test_failed_title' => 'Test mislykkedes!',
        'test_success_title' => 'Test succesfuld!',
        'status_code' => 'Statuskode',
        'error_occurred' => 'Der opstod en fejl ved test af webhook',
    ],
    'store_locator' => [
        'name' => 'Butikslokationer',
        'description' => 'Vis og opdater lister over dine kæder',
        'store_locator_description' => 'Alle lister over dine kæder, hovedbutikker, filialer osv. Lokationerne kan bruges til at spore salg og til at hjælpe os med at konfigurere momssatser til opkrævning ved salg af produkter.',
        'form' => [
            'change_primary_store' => 'skift standard butikslokation',
            'add_location' => 'Tilføj lokation',
            'edit_location' => 'Rediger lokation',
            'delete_location' => 'Slet lokation',
            'delete_location_confirmation' => 'Er du sikker på, at du vil slette denne lokation? Denne handling kan ikke fortrydes.',
            'change_primary_location' => 'Skift primær lokation',
            'save_location' => 'Gem lokation',
            'add_new' => 'Tilføj ny',
        ],
        'info' => [
            'title' => 'Hvordan butikslokationer fungerer',
            'primary_store' => 'Den primære butiksadresse vises på fakturaer og bruges som standardreturadresse for fragtetiketter.',
            'shipping_location' => 'Butikker markeret som "forsendelseslokation" kan vælges som oprindelseslager ved oprettelse af forsendelser.',
            'shipment_selection' => 'Ved behandling af ordrer kan du vælge hvilket lager der skal sendes fra baseret på lager og kundelokation.',
        ],
    ],
    'tracking' => [
        'name' => 'Sporing',
        'description' => 'Facebook Pixel, Google Tag Manager events og Google Ads konverteringssporing',
        'manage_tracking' => 'Administrer sporing',
        'manage_tracking_description' => 'Administrer sporing: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Aktiver Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Gå til https://developers.facebook.com/docs/meta-pixel for at oprette Facebook Pixel. Sørg for at din pixel er aktiv og korrekt konfigureret.',
            'facebook_pixel_id' => 'Facebook Pixel-ID',
            'facebook_pixel_id_placeholder' => 'Eksempel: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Aktiver Facebook Pixel fejlsøgningstilstand',
            'facebook_pixel_debug_mode_helper' => 'Aktiver fejlsøgningstilstand for at logge Facebook Pixel begivenheder til browserkonsollen og fejlfinde sporingsproblemer',
            'enable_google_tag_manager_tracking_events' => 'Aktiver Google Tag Manager sporingsbegivenheder',
            'google_tag_manager_tracking_info' => 'Når aktiveret, spores e-handelsbegivenheder gennem Google Tag Manager. Sørg for at du har konfigureret Google Tag Manager ovenfor.',
            'google_ads_conversion_id' => 'Google Ads konverterings-ID',
            'google_ads_conversion_id_helper' => 'Indtast dit Google Ads konverterings-ID (format: AW-123456789/AbC-D_efG-h1_ijk-lmN) for at spore købskonverteringer på taksiden.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel-ID skal være 15-16 cifre (fx 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Markedsplads',
        'description' => 'Multi-vendor indstillinger, kommissioner, sælgerregistrering og udbetalingskonfiguration',
    ],
    'standard_and_format' => [
        'name' => 'Standard & Format',
        'panel_description' => 'Ordrekodeformat, vægteenheder (kg/lb) og dimensionsenheder (cm/tommer)',
        'description' => 'Standarder og formater bruges til at beregne ting som produktpriser, fragtvægte og ordretider.',
        'form' => [
            'change_order_format' => 'Rediger ordrekodeformat (valgfri)',
            'change_order_format_description' => 'Standard ordrekode starter ved: nummer. Du kan ændre start- eller slutstrengen for at oprette den ordrekode du ønsker, fx "DH-: nummer" eller ": nummer-A"',
            'start_with' => 'Start med',
            'end_with' => 'Slut med',
            'order_will_be_shown' => 'Din ordrekode vises',
            'weight_unit' => 'Vægtenhed',
            'height_unit' => 'Enhed længde / højde',
            'weight_unit_gram' => 'Gram (g)',
            'weight_unit_kilogram' => 'Kilogram (kg)',
            'weight_unit_lb' => 'Pund (lb)',
            'weight_unit_oz' => 'Ounce (oz)',
            'height_unit_cm' => 'Centimeter (cm)',
            'height_unit_m' => 'Meter (m)',
            'height_unit_inch' => 'Tommer',
        ],
    ],
    'sale_popup' => [
        'name' => 'Salgs-popup',
        'description' => 'Tilpas dine salgs-popup indstillinger med lethed',
    ],
    'flash_sale' => [
        'name' => 'Flash sale',
        'description' => 'Konfigurer flash sale indstillinger for at tilbyde tidsbegrænsede kampagnerabatter',
        'enable' => 'Aktiver flash sale funktionalitet',
        'enable_helper' => 'Når aktiveret, kan du oprette og administrere flash sales med særlige rabatpriser i en begrænset periode.',
        'show_sale_count_left' => 'Vis lagersporer',
        'show_sale_count_left_description' => 'Vis en fremskridtsbjælke med "X solgt ud af Y" for at skabe presserende behov og tilskynde til hurtige køb under flash sales.',
    ],
    'payment_method_cod_minimum_amount' => 'Minimum ordrebeløb - :currency (Valgfri)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Minimum ordrebeløb - :currency (Valgfri)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Vis bankinfo på betalingssuccessiden?',
    'invoice_templates' => 'Fakturaskabeloner',

    'abandoned_cart' => [
        'name' => 'Giỏ hàng bị bỏ rơi',
        'description' => 'Khôi phục doanh số bị mất bằng cách gửi lời nhắc tự động cho khách hàng để lại sản phẩm trong giỏ',
        'panel_description' => 'Thiết lập lời nhắc tự động cho khách hàng bỏ rơi giỏ hàng',
        'how_it_works' => [
            'title' => 'Cách hoạt động',
            'step1_title' => 'Khách hàng thêm sản phẩm',
            'step1_description' => 'Khách hàng thêm sản phẩm vào giỏ hàng và cung cấp địa chỉ email.',
            'step2_title' => 'Giỏ hàng bị bỏ rơi',
            'step2_description' => 'Nếu không có giao dịch mua trong ngưỡng thời gian đã đặt, giỏ hàng được đánh dấu là bị bỏ rơi.',
            'step3_title' => 'Gửi email nhắc nhở',
            'step3_description' => 'Email nhắc nhở tự động được gửi để khuyến khích khách hàng hoàn tất việc mua hàng.',
            'step4_title' => 'Khôi phục doanh số',
            'step4_description' => 'Khách hàng quay lại hoàn tất đơn hàng và giỏ hàng được đánh dấu là đã khôi phục.',
        ],
        'form' => [
            'enable' => 'Bật theo dõi giỏ hàng bị bỏ rơi',
            'enable_helper' => 'Khi được bật, hệ thống sẽ theo dõi giỏ hàng bị bỏ rơi và cho phép bạn gửi email khôi phục cho khách hàng.',
            'timing_section' => 'Cài đặt thời gian',
            'email_section' => 'Cài đặt email nhắc nhở',
            'cleanup_section' => 'Dọn dẹp dữ liệu',
            'time_threshold' => 'Ngưỡng thời gian (giờ)',
            'time_threshold_helper' => 'Giỏ hàng được coi là bị bỏ rơi sau số giờ không hoạt động này. Khuyến nghị: 1-24 giờ.',
            'send_email' => 'Gửi email khôi phục',
            'send_email_helper' => 'Tự động gửi email khôi phục cho khách hàng có giỏ hàng bị bỏ rơi.',
            'max_reminders' => 'Số lượng email nhắc nhở',
            'max_reminders_helper' => 'Số lượng email nhắc nhở gửi cho mỗi giỏ hàng bị bỏ rơi. Mỗi email có thể được tùy chỉnh trong Mẫu Email.',
            'email_delay' => 'Gửi sau (giờ)',
            'email_discount' => 'Giảm giá (%)',
            'email_1_title' => 'Email #1 - Nhắc nhở thân thiện',
            'email_1_description' => 'Lời nhắc nhẹ nhàng đầu tiên để khuyến khích khách hàng quay lại.',
            'email_1_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email đầu tiên. Khuyến nghị: 1-2 giờ.',
            'email_2_title' => 'Email #2 - Kèm ưu đãi',
            'email_2_description' => 'Lời nhắc thứ hai với ưu đãi giảm giá để thúc đẩy mua hàng.',
            'email_2_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email thứ hai. Khuyến nghị: 24 giờ.',
            'email_2_discount_helper' => 'Phần trăm giảm giá để cung cấp trong email này. Đặt 0 nếu không giảm giá.',
            'email_3_title' => 'Email #3 - Cơ hội cuối',
            'email_3_description' => 'Lời nhắc cuối cùng với tính cấp bách và ưu đãi tốt nhất để chốt đơn.',
            'email_3_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email cuối cùng. Khuyến nghị: 72 giờ.',
            'email_3_discount_helper' => 'Phần trăm giảm giá cuối cùng. Thường cao hơn email #2.',
            'cleanup_days' => 'Dọn dẹp sau (ngày)',
            'cleanup_days_helper' => 'Tự động xóa bản ghi giỏ hàng bị bỏ rơi cũ hơn số ngày này.',
            'cronjob_not_setup' => '<strong>Cronjob chưa được cấu hình!</strong> Nhắc nhở giỏ hàng bị bỏ rơi yêu cầu cronjob được cấu hình đúng để hoạt động. <a href=":url">Thiết lập cronjob ngay</a>.',
            'cronjob_not_running' => '<strong>Cronjob không chạy!</strong> Cronjob dường như đã dừng. Vui lòng kiểm tra cấu hình máy chủ của bạn. <a href=":url">Xem trạng thái cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob đang chạy đúng!</strong> Hoạt động cuối: :time. Nhắc nhở giỏ hàng bị bỏ rơi của bạn sẽ được xử lý tự động.',
            'email_setup_warning' => '<strong>Quan trọng:</strong> Đảm bảo cài đặt email của bạn được cấu hình đúng trong <a href=":url">Cài đặt → Email</a>. Gửi email test để xác minh mọi thứ hoạt động trước khi bật tính năng này.',
        ],
    ],
];
