<?php

return [
    'save_settings' => 'Uložit nastavení',
    'ecommerce' => 'E-commerce',
    'general' => [
        'name' => 'Obecné',
        'description' => 'Název obchodu, info o firmě, kontakty a e-maily pro admin notifikace',
    ],
    'currency' => [
        'name' => 'Měny',
        'description' => 'Formáty měn, směnné kurzy, automatická detekce a desetinné/tisícové oddělovače',
        'currency_setting_description' => 'Zobrazit a aktualizovat měny používané na webu',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Povolit automatickou detekci měny návštěvníka',
            'enable_auto_detect_visitor_currency_helper' => 'Automaticky detekovat a zobrazovat ceny v místní měně návštěvníka na základě jeho umístění. To poskytuje personalizovanější nákupní zážitek.',
            'add_space_between_price_and_currency' => 'Přidat mezeru mezi cenou a měnou',
            'add_space_between_price_and_currency_helper' => 'Po povolení přidá mezeru mezi hodnotou ceny a symbolem měny (např. \"100 USD\" místo \"100USD\").',
            'thousands_separator' => 'Oddělovač tisíců',
            'thousands_separator_helper' => 'Vyberte znak pro oddělení tisíců v zobrazení ceny (např. 1,000 nebo 1.000 nebo 1 000).',
            'decimal_separator' => 'Desetinný oddělovač',
            'decimal_separator_helper' => 'Vyberte znak pro oddělení desetinných hodnot v cenách (např. 10.99 nebo 10,99).',
            'separator_period' => 'Tečka (.)',
            'separator_comma' => 'Čárka (,)',
            'separator_space' => 'Mezera ( )',
            'api_key' => 'API klíč směnných kurzů',
            'api_key_helper' => 'Získat API klíč směnných kurzů na :link',
            'update_currency_rates' => 'Aktualizovat směnné kurzy',
            'use_exchange_rate_from_api' => 'Použít směnný kurz z API',
            'use_exchange_rate_from_api_helper' => 'Povolit automatické aktualizace směnných kurzů měn z nakonfigurovaného poskytovatele API. To zajišťuje, že vaše ceny jsou vždy aktuální s aktuálními tržními sazbami.',
            'clear_cache_rates' => 'Vymazat mezipaměť kurzů',
            'auto_detect_visitor_currency_description' => 'Detekuje měnu návštěvníka na základě jazyka prohlížeče. Přepíše výchozí výběr měny.',
            'exchange_rate' => [
                'api_provider' => 'Poskytovatel API',
                'select' => '-- Vyberte --',
                'none' => 'Žádný',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'Pro výchozí měnu musí být směnný kurz 1.',
        ],
    ],
    'product' => [
        'name' => 'Produkty',
        'description' => 'Zobrazení skladů, generování SKU, obrázky variant, související produkty a specifikace',
        'product_settings' => 'Nastavení produktů',
        'product_settings_description' => 'Konfigurovat pravidla pro produkty',
        'form' => [
            'show_number_of_products' => 'Zobrazit počet produktů na stránce produktu',
            'show_number_of_products_helper' => 'Zobrazit celkový počet produktů na stránce s detaily produktu.',
            'show_out_of_stock_products' => 'Zobrazit produkty, které nejsou skladem',
            'show_out_of_stock_products_helper' => 'Pokud je povoleno, produkty, které nejsou skladem, se budou zobrazovat na stránce se seznamem produktů.',
            'how_to_display_product_variation_images' => 'Jak zobrazit obrázky variant produktů',
            'how_to_display_product_variation_images_helper' => 'Vyberte, zda zobrazit pouze obrázky specifické pro variantu nebo zahrnout obrázky varianty i hlavního produktu.',
            'only_variation_images' => 'Pouze obrázky variant',
            'variation_images_and_main_product_images' => 'Obrázky variant a hlavního produktu',
            'enable_product_options' => 'Povolit možnosti produktů',
            'enable_product_options_helper' => 'Povolit produktům mít přizpůsobitelné možnosti jako velikost, barva atd.',
            'is_enabled_cross_sale_products' => 'Povolit cross-sale produkty',
            'is_enabled_cross_sale_products_helper' => 'Zobrazit návrhy cross-sale produktů pro povzbuzení dalších nákupů.',
            'is_enabled_related_products' => 'Povolit související produkty',
            'is_enabled_related_products_helper' => 'Zobrazit související produkty na základě kategorie nebo vybrané administrátorem ve formuláři produktu.',
            'related_products_source' => 'Zdroj souvisejících produktů',
            'related_products_source_helper' => 'Když administrátor nevybere související produkty ve formuláři produktu, zobrazit související produkty na základě tohoto zdroje.',
            'related_products_source_category' => 'Stejná kategorie',
            'related_products_source_brand' => 'Stejná značka',
            'trending_products_period' => 'Období trendových produktů',
            'trending_products_period_helper' => 'Vyberte časové období pro výpočet trendových produktů na základě počtu zobrazení.',
            'trending_products_period_1_day' => 'Posledních 24 hodin',
            'trending_products_period_3_days' => 'Posledních 3 dní',
            'trending_products_period_7_days' => 'Posledních 7 dní (1 týden)',
            'trending_products_period_14_days' => 'Posledních 14 dní (2 týdny)',
            'trending_products_period_30_days' => 'Posledních 30 dní (1 měsíc)',
            'trending_products_period_60_days' => 'Posledních 60 dní (2 měsíce)',
            'trending_products_period_90_days' => 'Posledních 90 dní (3 měsíce)',
            'auto_generate_product_sku' => 'Automaticky generovat SKU při vytváření produktu',
            'auto_generate_product_sku_helper' => 'Automaticky generovat jedinečná SKU pro nové produkty na základě níže uvedeného formátu.',
            'product_sku_format' => 'Formát SKU',
            'product_sku_format_helper' => 'Můžete použít %s (1 řetězcový znak) nebo %d (1 číslice) ve formátu pro generování náhodného řetězce. Např.: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Povolit specifikaci produktu',
            'enable_product_specification_help' => 'Pokud je povoleno, tabulka specifikace produktu se zobrazí na stránce s detaily produktu.',
            'make_product_barcode_required' => 'Učinit čárový kód produktu povinným',
            'make_product_barcode_required_helper' => 'Pokud je povoleno, čárový kód produktu bude povinný při vytváření produktu.',
        ],
    ],
    'product_search' => [
        'name' => 'Vyhledávání produktů',
        'description' => 'Chování vyhledávání, filtry podle kategorie/značky/tagu/atributů a filtrování cenového rozsahu',
        'product_search_settings' => 'Vyhledávání produktů',
        'product_search_settings_description' => 'Konfigurovat pravidla pro vyhledávání produktů',
        'form' => [
            'search_for_an_exact_phrase' => 'Hledat přesnou frázi',
            'search_products_by' => 'Hledat produkty podle:',
            'enable_filter_products_by_categories' => 'Povolit filtrování produktů podle kategorií',
            'enable_filter_products_by_brands' => 'Povolit filtrování produktů podle značek',
            'enable_filter_products_by_tags' => 'Povolit filtrování produktů podle tagů',
            'number_of_popular_tags_for_filter' => 'Počet populárních tagů pro filtr',
            'number_of_popular_tags_for_filter_placeholder' => 'Zadejte počet populárních tagů k zobrazení',
            'number_of_popular_tags_for_filter_helper' => 'Nastavte maximální počet populárních tagů k zobrazení ve filtru. Výchozí je 10.',
            'enable_filter_products_by_attributes' => 'Povolit filtrování produktů podle atributů',
            'enable_filter_products_by_price' => 'Povolit filtrování produktů podle ceny',
            'max_product_price_for_filter' => 'Maximální cena produktu pro filtr',
            'max_product_price_for_filter_placeholder' => 'Pokud je prázdné nebo nula, získá maximální cenu produktu z vašich existujících produktů.',
            'max_product_price_for_filter_helper' => 'Můžete nastavit pevnou cenu nebo se dynamicky získá maximální cena produktu z vašich existujících produktů. V současnosti je to :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Digitální produkty',
        'description' => 'Stahovatelné produkty, licenční kódy, pokladna pro hosty u digitálních položek a automatické dokončení',
        'digital_products_settings' => 'Digitální produkty',
        'digital_products_settings_description' => 'Konfigurovat pravidla pro digitální produkty',
        'form' => [
            'enable_support_digital_product' => 'Je povolena podpora digitálních produktů',
            'enable_support_digital_product_helper' => 'Když je povoleno, systém bude podporovat prodej digitálních produktů jako software, e-knihy, hudba a další stažitelný obsah.',
            'allow_guest_checkout_for_digital_products' => 'Povolit nákup hostů pro digitální produkty',
            'allow_guest_checkout_for_digital_products_helper' => 'Když je povoleno, zákazníci mohou zakoupit digitální produkty bez vytvoření účtu. Obdrží odkazy ke stažení e-mailem.',
            'disable_physical_product' => 'Zakázat fyzické produkty',
            'disable_physical_product_helper' => 'Když je povoleno, obchod bude prodávat pouze digitální produkty. Možnosti fyzických produktů budou skryty z formulářů produktů a pokladny.',
            'enable_license_codes_for_digital_products' => 'Povolit licenční kódy pro digitální produkty',
            'auto_complete_digital_orders_after_payment' => 'Automaticky dokončit digitální objednávky po platbě',
            'auto_complete_digital_orders_after_payment_helper' => 'Když je povoleno, objednávky obsahující pouze digitální produkty budou automaticky označeny jako dokončené po přijetí platby.',
            'enable_license_codes_for_digital_products_helper' => 'Když je povoleno, můžete přidat licenční kódy k digitálním produktům. Když je zakázáno, funkce licenčních kódů bude skryta z formulářů produktů.',
            'hide_used_license_codes_in_product_form' => 'Skrýt použité licenční kódy ve formuláři produktu',
            'hide_used_license_codes_in_product_form_helper' => 'Když je povoleno, použité licenční kódy budou skryty z tabulky licenčních kódů ve formuláři úpravy produktu. To pomáhá udržet rozhraní čisté, když máte mnoho použitých kódů.',
        ],
    ],
    'product_review' => [
        'name' => 'Recenze produktů',
        'description' => 'Recenze zákazníků, zobrazení hodnocení, nahrávání obrázků a požadavky na schválení',
        'form' => [
            'enable_review' => 'Povolit recenze produktů',
            'enable_review_help' => 'Povolit zákazníkům zanechávat recenze a hodnocení produktů. Když je zakázáno, všechny funkce recenzí budou skryty z obchodu.',
            'allow_customer_upload_image_in_review' => 'Povolit zákazníkům nahrávat obrázky v recenzích',
            'allow_customer_upload_image_in_review_help' => 'Když je zakázáno, zákazníci nemohou nahrávat obrázky při odesílání recenzí',
            'review' => [
                'max_file_size' => 'Maximální velikost souboru recenze (MB)',
                'max_file_number' => 'Maximální počet souborů recenze',
            ],
            'only_allow_customers_purchased_to_review' => 'Pouze zákazníci, kteří si produkt zakoupili, mohou produkt recenzovat',
            'review_need_to_be_approved' => 'Recenze musí být schválena před zobrazením na stránce produktu',
            'show_customer_full_name' => 'Zobrazit celé jméno zákazníka',
            'show_customer_full_name_help' => 'Pokud není zaškrtnuto, jméno recenzujícího zákazníka bude skryto a nahrazeno hvězdičkami (***)',
            'hide_rating_when_no_reviews' => 'Skrýt hodnocení, když nejsou žádné recenze',
            'hide_rating_when_no_reviews_help' => 'Když je povoleno, hodnocení produktů bude skryto v seznamech produktů a na stránkách s detaily produktu, když produkt nemá žádné recenze',
            'display_uploaded_customer_review_images_list' => 'Zobrazit sekci "Obrázky od zákazníků"',
            'display_uploaded_customer_review_images_list_help' => 'Když je povoleno, zobrazuje galerii všech obrázků nahraných zákazníky v horní části sekce recenzí',
        ],
    ],
    'shopping' => [
        'name' => 'Nakupování',
        'description' => 'Košík, seznam přání, porovnání, sledování objednávek, tlačítko rychlého nákupu a nahrávání dokladu o platbě',
        'general_setting' => 'Obecná nastavení',
        'return_settings' => 'Nastavení vrácení',
        'return_settings_description' => 'Konfigurovat pravidla pro nastavení vrácení',
        'form' => [
            'enable_cart' => 'Povolit nákupní košík',
            'enable_cart_helper' => 'Pokud je zakázáno, tlačítko košíku bude odebráno, čímž se váš web změní pouze na katalogové zobrazení.',
            'enable_wishlist' => 'Povolit seznam přání',
            'enable_wishlist_helper' => 'Pokud je zakázáno, tlačítko seznamu přání bude odebráno z webu.',
            'enable_wishlist_sharing' => 'Povolit sdílení seznamu přání',
            'shared_wishlist_lifetime' => 'Životnost sdíleného seznamu přání (dny)',
            'shared_wishlist_lifetime_helper' => 'Životnost sdíleného seznamu přání ve dnech. Po této době bude sdílený seznam přání smazán.',
            'enable_compare' => 'Povolit porovnání',
            'enable_compare_helper' => 'Pokud je zakázáno, tlačítko porovnání bude odebráno z webu.',
            'enable_order_tracking' => 'Povolit sledování objednávek',
            'enable_order_tracking_helper' => 'Zákazníci mohou sledovat své objednávky zadáním kódu objednávky a e-mailu/telefonu na :url',
            'order_tracking_method' => 'Metoda sledování objednávek',
            'order_tracking_method_helper' => 'Vyberte, jak budou zákazníci sledovat své objednávky: pomocí ID objednávky + e-mail nebo ID objednávky + telefonní číslo.',
            'order_tracking_method_email' => 'ID objednávky + e-mail',
            'order_tracking_method_phone' => 'ID objednávky + telefonní číslo',
            'enable_quick_buy_button' => 'Povolit tlačítko rychlého nákupu',
            'enable_quick_buy_button_helper' => 'Zobrazí se tlačítko Koupit nyní na stránce se seznamem produktů a na stránce s detaily. Když zákazníci kliknou na toto tlačítko, produkt bude přidán do košíku a přesměruje na stránku košíku/pokladny.',
            'enable_order_auto_confirmed' => 'Automatické potvrzení objednávky',
            'enable_order_auto_confirmed_helper' => 'Pokud je povoleno, objednávka bude automaticky potvrzena poté, co zákazník zadá objednávku.',
            'quick_buy_target' => 'Cílová stránka rychlého nákupu',
            'checkout_page' => 'Stránka pokladny',
            'cart_page' => 'Stránka košíku',
            'cart_destroy_on_logout' => 'Zničit košík při odhlášení',
            'cart_destroy_on_logout_helper' => 'Košík bude zničen, když se zákazník odhlásí.',
            'hide_product_price' => 'Skrýt cenu produktu',
            'hide_product_price_helper' => 'Tato možnost funguje pouze pokud zakážete nákupní košík, čímž se váš web změní pouze na katalogové zobrazení. Pokud je povoleno, cena produktu bude skryta. Je to užitečné, když chcete skrýt cenu a požadovat, aby vás zákazníci kontaktovali kvůli ceně.',
            'hide_product_price_when_zero' => 'Skrýt cenu produktu, když je nula',
            'hide_product_price_when_zero_helper' => 'Pokud je povoleno, produkty s cenou 0 nebudou ve výloze zobrazovat cenu.',
            'enable_payment_proof' => 'Povolit nahrávání dokladu o platbě',
            'enable_payment_proof_helper' => 'Povolit zákazníkům nahrávat doklad o platbě pro jejich objednávky. To je užitečné pro manuální způsoby platby.',
            'enable_guest_payment_proof' => 'Povolit hostům nahrávat doklad o platbě',
            'enable_guest_payment_proof_helper' => 'Když je povoleno, hosté mohou nahrávat doklad o platbě pomocí jejich tokenu objednávky bez přihlášení. Obdrží odkaz pro nahrání v potvrzovacím e-mailu objednávky.',
            'payment_proof_payment_methods' => 'Platební metody vyžadující doklad o platbě',
            'payment_proof_payment_methods_helper' => 'Vyberte, které platební metody by měly umožnit zákazníkům nahrát doklad o platbě. Obvykle se používá pro manuální platební metody, jako je dobírka a bankovní převod.',
        ],
    ],
    'checkout' => [
        'name' => 'Pokladna',
        'panel_description' => 'Pokladna pro hosty, povinná pole, limity objednávek, přijetí podmínek a omezení zemí',
        'description' => 'Konfigurovat pravidla pro nastavení pokladny',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Zobrazit bankovní informace na stránce úspěšné pokladny',
            'mandatory_form_fields_at_checkout' => 'Povinná pole na stránce pokladny:',
            'mandatory_form_fields_at_checkout_helper' => 'Vyberte, která pole jsou povinná během pokladny. Zákazníci musí vyplnit tato pole pro dokončení objednávky.',
            'hide_form_fields_at_checkout' => 'Skrýt zákaznická pole na stránce pokladny:',
            'hide_form_fields_at_checkout_helper' => 'Vyberte, která pole by měla být skryta na stránce pokladny. Tato pole nebudou viditelná pro zákazníky.',
            'load_countries_states_cities_from_location_plugin' => 'Načíst země, kraje, města z pluginu lokace',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Po změně této možnosti musíte znovu aktualizovat všechny adresy. Měli byste to nastavit jednou.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Poté musíte jít do Nástroje -> Import/Export dat pro import dat lokace.',
            'minimum_order_amount' => 'Minimální částka objednávky pro zadání objednávky (:currency).',
            'minimum_order_amount_helper' => 'Nastavte minimální celkovou částku požadovanou pro zpracování objednávky. Objednávky pod touto částkou nebudou přijaty.',
            'zip_code_enabled' => 'Povolit PSČ',
            'zip_code_enabled_helper' => 'Povolit nebo zakázat pole PSČ/poštovního kódu ve formuláři doručovací adresy.',
            'billing_address_enabled' => 'Povolit fakturační adresu',
            'billing_address_enabled_helper' => 'Povolit zákazníkům zadat samostatnou fakturační adresu, která se liší od jejich doručovací adresy.',
            'display_tax_fields_at_checkout_page' => 'Zobrazit pole daňových informací na stránce pokladny',
            'display_tax_fields_at_checkout_page_helper' => 'Pokud je povoleno, pole daňových informací budou zobrazena pro zadání daňových údajů společnosti pro získání faktury.',
            'use_city_field_as_field_text' => 'Použít pole města jako volné textové pole',
            'available_countries' => 'Dostupné země',
            'all' => 'Vše',
            'all_helper_text' => 'Pokud zrušíte označení všech zemí, bude to platit pro všechny země.',
            'enable_guest_checkout' => 'Povolit nákup hostů',
            'enable_guest_checkout_helper' => 'Pokud je povoleno, zákazníci mohou zadat objednávku bez vytvoření účtu.',
            'recently_viewed' => [
                'enable' => 'Povolit nedávno zobrazené produkty zákazníka',
                'enable_helper' => 'Sledovat a zobrazovat produkty, které zákazníci nedávno zobrazili. To pomáhá zákazníkům snadno najít produkty, o které měli zájem.',
                'max' => 'Maximální počet nedávno zobrazených produktů zákazníka',
                'max_helper_text' => 'Pokud je nastaveno na 0, nebude žádný limit.',
            ],
            'minimum_order_quantity' => 'Minimální množství objednávky',
            'minimum_order_quantity_helper' => 'Minimální množství pro zadání objednávky. Nechte to 0, pokud to nechcete nastavit.',
            'maximum_order_quantity' => 'Maximální množství objednávky',
            'maximum_order_quantity_helper' => 'Maximální množství pro zadání objednávky. Nechte to 0, pokud to nechcete nastavit.',
            'default_country_at_checkout_page' => 'Výchozí země na stránce pokladny',
            'default_country_at_checkout_page_placeholder' => 'Vyberte zemi',
            'default_country_at_checkout_page_help' => 'Pokud vyberete zemi, země bude vybrána ve výchozím nastavení na stránce pokladny.',
            'checkout_product_quantity_editable' => 'Povolit zákazníkům měnit množství produktu na stránce pokladny',
            'checkout_product_quantity_editable_helper' => 'Když je povoleno, zákazníci mohou upravit množství produktů přímo na stránce pokladny bez návratu do košíku.',
            'show_terms_and_policy_checkbox' => 'Zobrazit zaškrtávací pole podmínek a zásad',
            'show_terms_and_policy_checkbox_helper' => 'Pokud je povoleno, zákazníci musí souhlasit s podmínkami a zásadami před zadáním objednávky. Nejprve nastavte URL podmínek a zásad ochrany osobních údajů v Vzhled -> Možnosti motivu.',
            'terms_and_policy_checkbox_checked_by_default' => 'Zaškrtávací pole podmínek a zásad zaškrtnuto ve výchozím nastavení',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Pokud je povoleno, zaškrtávací pole podmínek a zásad bude předem zaškrtnuto při načtení formuláře pokladny.',
            'checkout_acceptance_message_enabled' => 'Zobrazit zprávu o přijetí pokladny',
            'checkout_acceptance_message_enabled_helper' => 'Zobrazit informační zprávu, která informuje zákazníky o podmínkách, se kterými souhlasí zadáním objednávky.',
            'hide_customer_info_at_checkout' => 'Skrýt informace o zákazníkovi na pokladně',
            'hide_customer_info_at_checkout_helper' => 'Skrýt informace o zákaznickém účtu a tlačítko odhlášení ze stránky pokladny. Když je povoleno, přihlášení zákazníci neuvidí zobrazené podrobnosti svého účtu.',
        ],
    ],
    'return' => [
        'name' => 'Vrácení',
        'description' => 'Konfigurovat pravidla pro nastavení vrácení',
        'panel_description' => 'Vratky objednávek, částečné vratky a lhůty pro vrácení',
        'form' => [
            'is_enabled_order_return' => 'Je povoleno vrácení objednávky',
            'allow_partial_return' => 'Povolit částečné vrácení',
            'allow_partial_return_description' => 'Zákazník může vrátit několik produktů, nemusí vracet všechny produkty v objednávce.',
            'returnable_days' => 'Dny pro vrácení',
            'return_settings_helper' => 'Počet dní, kdy může zákazník požádat o vrácení po dokončení objednávky.',
        ],
    ],
    'invoice' => [
        'name' => 'Faktury',
        'description' => 'Firemní údaje na fakturách, číslování faktur, PDF fonty a nastavení razítka',
        'company_settings' => 'Invoice configuration',
        'company_settings_description' => 'Company info, invoice numbering, PDF fonts, and payment stamp',
        'form' => [
            'company_name' => 'Název společnosti',
            'company_address' => 'Adresa společnosti',
            'company_zipcode' => 'PSČ společnosti',
            'company_email' => 'E-mail společnosti',
            'company_phone' => 'Telefon společnosti',
            'company_logo' => 'Logo společnosti',
            'company_tax_id' => 'DIČ společnosti',
            'invoice_code_prefix' => 'Prefix kódu faktury',
            'using_custom_font_for_invoice' => 'Použití vlastního fontu pro fakturu',
            'invoice_font_family' => 'Rodina fontů faktury (Funguje pouze pro latinské jazyky)',
            'enable_invoice_stamp' => 'Povolit razítko faktury',
            'add_language_support' => 'Přidat jazykovou podporu',
            'invoice_processing_library' => 'Knihovna zpracování faktur',
            'only_latin_languages' => 'Pouze latinské jazyky',
            'disable_order_invoice_until_order_confirmed' => 'Zakázat fakturu objednávky, dokud není objednávka potvrzena',
            'date_format' => 'Formát data',
            'languages' => [
                'arabic' => 'Arabština',
                'bangladesh' => 'Bengálština',
                'chinese' => 'Čínština',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Daň',
        'description' => 'Tax calculation, display options, and checkout invoice fields',
        'enable' => 'Povolit daň?',
        'display_product_price_including_taxes' => 'Zobrazit cenu produktu včetně daní?',
        'display_tax_description' => 'Zobrazit daňové informace na ceně produktu?',
        'display_tax_description_help' => 'Zobrazit text jako "(Včetně X% DPH)" nebo "(Bez X% DPH)" vedle cen produktů na stránce s detaily produktu.',
        'tax_included_in_products_price' => 'Daň zahrnuta v ceně produktů',
        'tax_included_in_products_price_description' => 'Daň bude zahrnuta v ceně produktů',
        'tax_setting' => 'Tax display & checkout',
        'tax_setting_description' => 'Configure how taxes are displayed on products and checkout pages',
        'tax_management' => 'Správa daní',
        'tax_management_description' => 'Zobrazit a spravovat vaše daně',

        'manage_taxes_info' => 'Pro správu daní a nastavení výchozí sazby daně přejděte na',
        'go_to_taxes' => 'E-commerce → Daně',        'form' => [
            'enable_tax' => 'Povolit daň',
            'display_company_invoice_information_fields_at_checkout_page' => 'Zobrazit pole informací o faktuře společnosti na stránce pokladny',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Pokud je povoleno, pole informací o faktuře společnosti budou zobrazena na stránce pokladny. Je povinné vyplnit pole informací o faktuře společnosti.',
            'default_tax_rate' => 'Výchozí daňová sazba',
            'default_tax_rate_description' => 'Důležité: bude použita, pokud není vybrána žádná daň v produktu.',
            'select_tax' => '-- Vyberte --',
            'display_product_price_including_taxes' => 'Přidat daň k zobrazovaným cenám',
            'display_product_price_including_taxes_helper' => 'Automaticky přidá daň k cenám produktů zobrazeným v obchodě. Např. produkt za $100 s 10% daní se zobrazí jako $110. Není nutné, pokud je u jednotlivých produktů již aktivováno "Cena zahrnuje daň".',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Zákazníci',
        'description' => 'Registrace, ověření e-mailu, možnosti přihlášení, smazání účtu a pole profilu',
        'customer_setting' => 'Nastavení zákazníků',
        'customer_setting_description' => 'Konfigurovat nastavení zákazníků',
        'form' => [
            'enable_customer_registration' => 'Povolit registraci zákazníků',
            'enable_customer_registration_helper' => 'Pokud je zakázáno, zákazníci nebudou moci registrovat nové účty. Existující zákazníci se stále mohou přihlásit.',
            'verify_customer_email' => 'Ověřit e-mail zákazníka',
            'verify_customer_email_helper' => 'Když je povoleno, ověřovací odkaz bude odeslán na e-mail zákazníka, zákazníci musí kliknout na tento odkaz pro ověření e-mailu před přihlášením. Je třeba nakonfigurovat e-mail v Admin -> Nastavení -> E-mail pro odeslání ověření e-mailu.',
            'verification_expire_minutes' => 'Doba vypršení ověřovacího odkazu',
            'verification_expire_minutes_helper' => 'Doba v minutách, po kterou bude ověřovací odkaz e-mailu platný. Výchozí je 60 minut (1 hodina). Maximum je 10080 minut (7 dní).',
            'login_using_phone' => 'Přihlásit se pomocí telefonního čísla místo e-mailu',
            'login_option' => 'Možnost přihlášení',
            'login_with_email' => 'Přihlásit se e-mailem',
            'login_with_phone' => 'Přihlásit se telefonem',
            'login_with_email_or_phone' => 'Přihlásit se e-mailem nebo telefonem',
            'enabled_customer_account_deletion' => 'Povolit smazání zákaznického účtu',
            'enabled_customer_account_deletion_helper' => 'Když je povoleno, zákazníci mohou smazat svůj účet v zákaznickém dashboardu → Nastavení účtu.',
            'enabled_customer_dob_field' => 'Povolit pole datum narození zákazníka',
            'enabled_customer_dob_field_helper' => 'Když je povoleno, zákazníci mohou zadat své datum narození v zákaznickém dashboardu → Nastavení účtu.',
            'enabled_phone_field_in_registration_form' => 'Povolit pole telefonu v registračním formuláři',
            'enabled_phone_field_in_registration_form_helper' => 'Když je povoleno, pole telefonu bude přidáno do registračního formuláře.',
            'make_customer_phone_number_required' => 'Učinit telefonní číslo zákazníka povinným',
            'make_customer_phone_number_required_helper' => 'Když je povoleno, zákazníci musí zadat své telefonní číslo během registrace. Je vždy povinné pro zákazníky přihlašující se telefonním číslem.',
            'default_avatar' => 'Výchozí avatar',
            'default_avatar_helper' => 'Výchozí avatar pro zákazníka, když nemá avatar. Pokud nevyberete žádný obrázek, bude vygenerován pomocí vašeho loga nebo prvního znaku jména zákazníka.',
            'keep_email_field_in_registration_form' => 'Ponechat pole e-mailu v registračním formuláři',
            'keep_email_field_in_registration_form_helper' => 'Když je zakázáno, pole e-mailu bude skryto v registračním formuláři, když je možnost přihlášení "Přihlásit se telefonem".',
        ],
    ],
    'shipping' => [
        'name' => 'Doprava',
        'description' => 'Pravidla dopravy, chování dopravy zdarma a pořadí zobrazení možností dopravy',
        'shipping_rule' => 'Pravidla dopravy',
        'shipping_rule_description' => 'Konfigurovat pravidla pro výpočet poplatku za dopravu',
        'shipping_setting' => 'Nastavení dopravy',
        'shipping_setting_description' => 'Konfigurovat nastavení dopravy',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Skrýt ostatní možnosti dopravy, pokud má v seznamu dopravu zdarma',
            'disable_shipping_options' => 'Zakázat možnosti dopravy',
            'disable_shipping_options_helper' => 'Možnosti dopravy budou odstraněny ze stránky pokladny, zákazník nebude moci vybrat možnosti dopravy.',
            'sort_shipping_options_direction' => 'Směr řazení možností dopravy',
            'sort_shipping_options_direction_helper' => 'Řadit možnosti dopravy podle ceny od nižší k vyšší nebo od vyšší k nižší.',
            'price_lower_to_higher' => 'Cena od nižší k vyšší',
            'price_higher_to_lower' => 'Cena od vyšší k nižší',
        ],
    ],
    'webhook' => [
        'name' => 'Webhooks',
        'description' => 'Send order events to external services via HTTP callbacks',
        'webhook_setting' => 'Order event webhooks',
        'webhook_setting_description' => 'Configure URLs to receive notifications when orders are placed, updated, or shipped',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook zadané objednávky (metoda: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Pro příjem oznámení o zadání objednávky můžete nastavit externí webhook URL. Pokud máte externí webhook URL, můžete zadat tuto URL, nebo ji jednoduše nechat prázdnou.',
            'order_updated_webhook_url' => 'URL webhook aktualizované objednávky (metoda: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Pro příjem oznámení o aktualizaci objednávky můžete nastavit externí webhook URL. To zahrnuje změny stavu, aktualizace adres a další úpravy objednávky.',
            'shipping_status_updated_webhook_url' => 'URL webhook aktualizovaného stavu dopravy (metoda: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Pro příjem oznámení o změnách stavu dopravy (např. odesláno, doručeno, zrušeno) můžete nastavit externí webhook URL.',
            'order_completed_webhook_url' => 'URL webhook dokončené objednávky (metoda: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Pro příjem oznámení o dokončení objednávky můžete nastavit externí webhook URL.',
            'order_cancelled_webhook_url' => 'URL webhook zrušené objednávky (metoda: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Pro příjem oznámení o zrušení objednávky můžete nastavit externí webhook URL.',
            'payment_status_updated_webhook_url' => 'URL webhook aktualizovaného stavu platby (metoda: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Pro příjem oznámení o změnách stavu platby (např. zaplaceno, neúspěšné, refundováno) můžete nastavit externí webhook URL.',
            'abandoned_cart_webhook_url' => 'URL webhook opuštěného košíku (metoda: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Pro příjem oznámení o opuštěných košících a následné kontaktování zákazníků můžete nastavit externí webhook URL. Oznámení jsou odesílána po konfigurovatelném časovém období.',
        ],
        'test_button' => 'Testovat Webhook',
        'test_success' => 'Test webhooku úspěšný! Endpoint odpověděl správně.',
        'test_failed' => 'Test webhooku neúspěšný. Endpoint neodpověděl podle očekávání.',
        'test_error' => 'Chyba testu webhooku: :error',
        'please_enter_url' => 'Nejprve zadejte webhook URL',
        'testing' => 'Testování...',
        'test_failed_title' => 'Test neúspěšný!',
        'test_success_title' => 'Test úspěšný!',
        'status_code' => 'Stavový kód',
        'error_occurred' => 'Došlo k chybě při testování webhooku',
    ],
    'store_locator' => [
        'name' => 'Vyhledávač prodejen',
        'description' => 'Zobrazit a aktualizovat seznamy vašich řetězců',
        'store_locator_description' => 'Všechny seznamy vašich řetězců, hlavních obchodů, poboček atd. Lokace lze použít ke sledování prodejů a pomoci nám nakonfigurovat daňové sazby k účtování při prodeji produktů.',
        'form' => [
            'change_primary_store' => 'změnit výchozí vyhledávač prodejen',
            'add_location' => 'Přidat lokaci',
            'edit_location' => 'Upravit lokaci',
            'delete_location' => 'Smazat lokaci',
            'delete_location_confirmation' => 'Opravdu chcete smazat tuto lokaci? Tuto akci nelze vrátit zpět.',
            'change_primary_location' => 'Změnit primární lokaci',
            'save_location' => 'Uložit lokaci',
            'add_new' => 'Přidat novou',
        ],
        'info' => [
            'title' => 'Jak fungují vyhledávače prodejen',
            'primary_store' => 'Adresa hlavní prodejny se zobrazuje na fakturách a používá se jako výchozí adresa pro vrácení zásilky.',
            'shipping_location' => 'Prodejny označené jako "místo odeslání" mohou být vybrány jako výchozí sklad při vytváření zásilek.',
            'shipment_selection' => 'Při zpracování objednávek můžete vybrat, ze kterého skladu expedovat, na základě zásob a polohy zákazníka.',
        ],
    ],
    'tracking' => [
        'name' => 'Sledování',
        'description' => 'Facebook Pixel, události Google Tag Manager a sledování konverzí Google Ads',
        'manage_tracking' => 'Spravovat sledování',
        'manage_tracking_description' => 'Spravovat sledování: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Povolit Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Jděte na https://developers.facebook.com/docs/meta-pixel pro vytvoření Facebook Pixel. Ujistěte se, že váš pixel je aktivní a správně nakonfigurován.',
            'facebook_pixel_id' => 'Facebook Pixel ID',
            'facebook_pixel_id_placeholder' => 'Příklad: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Povolit Debug režim Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Povolit debug režim pro logování událostí Facebook Pixel do konzole prohlížeče a řešení problémů se sledováním',
            'enable_google_tag_manager_tracking_events' => 'Povolit sledovací události Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Když je povoleno, e-commerce události budou sledovány prostřednictvím Google Tag Manager. Ujistěte se, že máte nakonfigurován Google Tag Manager výše.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'Facebook Pixel ID musí mít 15-16 číslic (např. 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Tržiště',
        'description' => 'Nastavení více prodejců, provize, registrace prodejců a konfigurace výplat',
    ],
    'standard_and_format' => [
        'name' => 'Standardy a formáty',
        'panel_description' => 'Formát kódu objednávky, jednotky hmotnosti (kg/lb) a jednotky rozměrů (cm/palec)',
        'description' => 'Standardy a formáty se používají k výpočtu věcí jako ceny produktů, váhy dopravy a časy objednávek.',
        'form' => [
            'change_order_format' => 'Upravit formát kódu objednávky (volitelné)',
            'change_order_format_description' => 'Výchozí kód objednávky začíná na: číslo. Můžete změnit začátek nebo konec řetězce pro vytvoření požadovaného kódu objednávky, například "DH-: číslo" nebo ": číslo-A"',
            'start_with' => 'Začít s',
            'end_with' => 'Končit s',
            'order_will_be_shown' => 'Váš kód objednávky bude zobrazen',
            'weight_unit' => 'Jednotka hmotnosti',
            'height_unit' => 'Jednotka délky / výšky',
            'weight_unit_gram' => 'Gram (g)',
            'weight_unit_kilogram' => 'Kilogram (kg)',
            'weight_unit_lb' => 'Libra (lb)',
            'weight_unit_oz' => 'Unce (oz)',
            'height_unit_cm' => 'Centimetr (cm)',
            'height_unit_m' => 'Metr (m)',
            'height_unit_inch' => 'Palec',
        ],
    ],
    'sale_popup' => [
        'name' => 'Prodejní popup',
        'description' => 'Přizpůsobte nastavení vašeho prodejního popupu snadno',
    ],
    'flash_sale' => [
        'name' => 'Výprodej',
        'description' => 'Konfigurovat nastavení výprodeje pro nabídku časově omezených promocí',
        'enable' => 'Povolit funkci výprodeje',
        'enable_helper' => 'Když je povoleno, můžete vytvářet a spravovat výprodeje se speciálními slevami na omezenou dobu.',
        'show_sale_count_left' => 'Zobrazit sledování inventáře',
        'show_sale_count_left_description' => 'Zobrazit progress bar s "X prodáno z Y" pro vytvoření naléhavosti a povzbuzení rychlých nákupů během výprodejů.',
    ],
    'payment_method_cod_minimum_amount' => 'Minimální částka objednávky - :currency (Volitelné)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Minimální částka objednávky - :currency (Volitelné)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Zobrazit bankovní informace na stránce úspěšné pokladny?',
    'invoice_templates' => 'Šablony faktur',

    'abandoned_cart' => [
        'name' => 'Giỏ hàng bị bỏ rơi',
        'description' => 'Khôi phục doanh số bị mất bằng cách gửi lời nhắc tự động cho khách hàng để lại sản phẩm trong giỏ',
        'panel_description' => 'Thiết lập lời nhắc tự động cho khách hàng bỏ rơi giỏ hàng',
        'how_it_works' => [
            'title' => 'Cách hoạt động',
            'step1_title' => 'Khách hàng thêm sản phẩm',
            'step1_description' => 'Khách hàng thêm sản phẩm vào giỏ hàng và cung cấp địa chỉ email.',
            'step2_title' => 'Giỏ hàng bị bỏ rơi',
            'step2_description' => 'Nếu không có giao dịch mua trong ngưỡng thời gian đã đặt, giỏ hàng được đánh dấu là bị bỏ rơi.',
            'step3_title' => 'Gửi email nhắc nhở',
            'step3_description' => 'Email nhắc nhở tự động được gửi để khuyến khích khách hàng hoàn tất việc mua hàng.',
            'step4_title' => 'Khôi phục doanh số',
            'step4_description' => 'Khách hàng quay lại hoàn tất đơn hàng và giỏ hàng được đánh dấu là đã khôi phục.',
        ],
        'form' => [
            'enable' => 'Bật theo dõi giỏ hàng bị bỏ rơi',
            'enable_helper' => 'Khi được bật, hệ thống sẽ theo dõi giỏ hàng bị bỏ rơi và cho phép bạn gửi email khôi phục cho khách hàng.',
            'timing_section' => 'Cài đặt thời gian',
            'email_section' => 'Cài đặt email nhắc nhở',
            'cleanup_section' => 'Dọn dẹp dữ liệu',
            'time_threshold' => 'Ngưỡng thời gian (giờ)',
            'time_threshold_helper' => 'Giỏ hàng được coi là bị bỏ rơi sau số giờ không hoạt động này. Khuyến nghị: 1-24 giờ.',
            'send_email' => 'Gửi email khôi phục',
            'send_email_helper' => 'Tự động gửi email khôi phục cho khách hàng có giỏ hàng bị bỏ rơi.',
            'max_reminders' => 'Số lượng email nhắc nhở',
            'max_reminders_helper' => 'Số lượng email nhắc nhở gửi cho mỗi giỏ hàng bị bỏ rơi. Mỗi email có thể được tùy chỉnh trong Mẫu Email.',
            'email_delay' => 'Gửi sau (giờ)',
            'email_discount' => 'Giảm giá (%)',
            'email_1_title' => 'Email #1 - Nhắc nhở thân thiện',
            'email_1_description' => 'Lời nhắc nhẹ nhàng đầu tiên để khuyến khích khách hàng quay lại.',
            'email_1_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email đầu tiên. Khuyến nghị: 1-2 giờ.',
            'email_2_title' => 'Email #2 - Kèm ưu đãi',
            'email_2_description' => 'Lời nhắc thứ hai với ưu đãi giảm giá để thúc đẩy mua hàng.',
            'email_2_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email thứ hai. Khuyến nghị: 24 giờ.',
            'email_2_discount_helper' => 'Phần trăm giảm giá để cung cấp trong email này. Đặt 0 nếu không giảm giá.',
            'email_3_title' => 'Email #3 - Cơ hội cuối',
            'email_3_description' => 'Lời nhắc cuối cùng với tính cấp bách và ưu đãi tốt nhất để chốt đơn.',
            'email_3_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email cuối cùng. Khuyến nghị: 72 giờ.',
            'email_3_discount_helper' => 'Phần trăm giảm giá cuối cùng. Thường cao hơn email #2.',
            'cleanup_days' => 'Dọn dẹp sau (ngày)',
            'cleanup_days_helper' => 'Tự động xóa bản ghi giỏ hàng bị bỏ rơi cũ hơn số ngày này.',
            'cronjob_not_setup' => '<strong>Cronjob chưa được cấu hình!</strong> Nhắc nhở giỏ hàng bị bỏ rơi yêu cầu cronjob được cấu hình đúng để hoạt động. <a href=":url">Thiết lập cronjob ngay</a>.',
            'cronjob_not_running' => '<strong>Cronjob không chạy!</strong> Cronjob dường như đã dừng. Vui lòng kiểm tra cấu hình máy chủ của bạn. <a href=":url">Xem trạng thái cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob đang chạy đúng!</strong> Hoạt động cuối: :time. Nhắc nhở giỏ hàng bị bỏ rơi của bạn sẽ được xử lý tự động.',
            'email_setup_warning' => '<strong>Quan trọng:</strong> Đảm bảo cài đặt email của bạn được cấu hình đúng trong <a href=":url">Cài đặt → Email</a>. Gửi email test để xác minh mọi thứ hoạt động trước khi bật tính năng này.',
        ],
    ],
];
