<?php

return [
    'title' => 'Configurações',
    'general_setting' => 'Configurações Gerais',
    'menu' => 'Todas as configurações',
    'email_setting_title' => 'Configurações de e-mail',
    'email_setting_description' => 'Definir configurações de e-mail',
    'general' => [
        'theme' => 'Tema',
        'title' => 'Informações gerais',
        'description' => 'Visualizar e atualizar informações do site',
        'rich_editor' => 'Editor rico',
        'site_title' => 'Título do site',
        'admin_email' => 'E-mail do administrador',
        'seo_block' => 'Configuração SEO',
        'seo_title' => 'Título SEO',
        'seo_description' => 'Descrição SEO',
        'webmaster_tools_block' => 'Ferramentas para webmasters do Google',
        'placeholder' => [
            'site_title' => 'Título do site (máximo 120 caracteres)',
            'admin_email' => 'E-mail do administrador',
            'seo_title' => 'Título SEO (máximo 120 caracteres)',
            'seo_description' => 'Descrição SEO (máximo 120 caracteres)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Enviar relatório de erros por e-mail',
        'enable_send_error_reporting_via_email_helper' => 'Quando ativado, relatórios detalhados de erros serão enviados aos endereços de e-mail do administrador quando ocorrerem erros críticos no site',
        'time_zone' => 'Fuso horário',
        'time_zone_helper' => 'Selecione o fuso horário do seu site. Isso será usado para todas as exibições de data e hora em todo o sistema',
        'enable' => 'Habilitar',
        'disable' => 'Desativar',
        'disabled_helper' => 'Não é possível desativar este modelo de e-mail!',
        'enable_cache_site_map' => 'Ativar cache do mapa do site',
        'cache_time_site_map' => 'Tempo limite de cache do mapa do site (em minutos)',
        'admin_logo' => 'Logotipo do administrador',
        'admin_favicon' => 'Favicon de administrador',
        'admin_title' => 'Título de administrador',
        'admin_title_placeholder' => 'Título para mostrar na aba do navegador',
        'admin_appearance_title' => 'Aparência do administrador',
        'admin_appearance_description' => 'Configurando a aparência do administrador, como editor, idioma...',
        'seo_block_description' => 'Definir o título do site, meta descrição do site, palavra-chave do site para otimizar SEO',
        'webmaster_tools_description' => 'O Google Search Console é uma ferramenta web gratuita fornecida pelo Google que ajuda os proprietários de sites a monitorar o desempenho de seus sites nos resultados da Pesquisa Google.',
        'yes' => 'Sim',
        'no' => 'Não',
        'show_on_front' => 'Sua página inicial exibe',
        'select' => '— Selecione —',
        'show_site_name' => 'Mostrar o nome do site após o título da página, separado por “-”',
        'locale' => 'Idioma do site',
        'locale_direction' => 'Direção do idioma do site frontal',
        'minutes' => 'minutos',
        'redirect_404_to_homepage' => 'Redirecionar todas as solicitações não encontradas para a página inicial',
    ],
    'admin_appearance' => [
        'title' => 'Aparência do administrador',
        'description' => 'Visualize e atualize logotipo, favicon, layout,...',
        'layout' => 'Disposição',
        'layout_helper' => 'Escolha entre o menu horizontal (barra de navegação superior) ou o menu vertical (barra lateral).',
        'horizontal' => 'Layout horizontal',
        'vertical' => 'Layout vertical',
        'show_menu_item_icon' => 'Mostrar ícone do item de menu',
        'language' => 'Idioma do painel de administração',
        'theme_mode' => 'Modo tema',
        'dark' => 'Escuro',
        'light' => 'Luz',
        'container_width' => [
            'title' => 'Largura do contêiner',
            'title_helper' => 'Defina a largura máxima para os contêineres de conteúdo no painel administrativo.',
            'default' => 'Padrão',
            'large' => 'Grande',
            'full' => 'Completo',
        ],
        'form' => [
            'admin_logo' => 'Logotipo do administrador',
            'admin_logo_helper' => 'Envie um logotipo personalizado para exibir no cabeçalho do painel administrativo. Tamanho recomendado: 150x50px.',
            'admin_logo_max_height' => 'Altura do logotipo (px)',
            'admin_logo_max_height_helper' => 'Defina a altura do logotipo em pixels. O valor padrão é :default.',
            'admin_favicon' => 'Favicon de administrador',
            'admin_favicon_helper' => 'Envie um favicon para o painel administrativo. Este ícone aparece nas abas do navegador e nos favoritos.',
            'admin_favicon_type' => 'Tipo de favicon do administrador',
            'admin_favicon_type_helper' => 'Selecione o formato de imagem do seu favicon. O formato ICO é recomendado para melhor compatibilidade.',
            'admin_title' => 'Título de administrador',
            'admin_title_helper' => 'Defina o título que aparece na aba do navegador ao visualizar páginas administrativas.',
            'admin_title_placeholder' => 'Título para mostrar na aba do navegador',
            'admin_login_screen_backgrounds' => 'Planos de fundo da tela de login (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Envie uma ou mais imagens de fundo para a tela de login. As imagens serão alternadas aleatoriamente. Tamanho recomendado: 1366x768px.',
            'admin_locale' => 'Idioma do administrador',
            'admin_locale_helper' => 'Escolha o idioma da interface do painel administrativo.',
            'admin_locale_direction' => 'Direção do idioma do administrador',
            'admin_locale_direction_helper' => 'Defina o sentido do texto no painel. Escolha RTL para idiomas como árabe ou hebraico.',
            'rich_editor' => 'Editor rico',
            'rich_editor_helper' => 'Selecione o editor de texto avançado padrão usado para criação de conteúdo no painel.',
            'primary_font' => 'Fonte primária',
            'primary_font_helper' => 'Escolha a família tipográfica principal do painel administrativo. Será utilizada na maioria dos textos.',
            'primary_color' => 'Cor primária',
            'primary_color_helper' => 'Defina a cor primária do tema usada em botões, links e destaques. Padrão: #206bc4.',
            'secondary_color' => 'Cor secundária',
            'secondary_color_helper' => 'Defina a cor secundária usada em elementos menos destacados da interface. Padrão: #6c7a91.',
            'heading_color' => 'Cor do título',
            'heading_color_helper' => 'Defina a cor dos títulos em todo o painel. Utilize "inherit" para herdar a cor de texto padrão.',
            'text_color' => 'Cor do texto',
            'text_color_helper' => 'Defina a cor de texto padrão do painel administrativo. Padrão: #182433.',
            'link_color' => 'Cor do link',
            'link_color_helper' => 'Defina a cor dos links no painel. Padrão: #206bc4.',
            'link_hover_color' => 'Cor de foco do link',
            'link_hover_color_helper' => 'Defina a cor dos links ao passar o cursor. Padrão: #1a569d.',
            'show_menu_item_icon' => 'Mostrar ícone do item de menu',
            'show_menu_item_icon_helper' => 'Exibe ícones ao lado dos itens do menu administrativo para facilitar a identificação.',
            'custom_css' => 'CSS personalizado',
            'custom_css_helper' => 'Adicione estilos CSS personalizados para substituir ou estender o estilo padrão do painel.',
            'custom_js' => 'JS personalizado',
            'custom_header_js' => 'Cabeçalho JS',
            'custom_header_js_placeholder' => 'JavaScript no cabeçalho da página, coloque-o dentro de <script></script>',
            'custom_body_js' => 'Corpo JS',
            'custom_body_js_placeholder' => 'JavaScript no corpo da página, coloque-o dentro de <script></script>',
            'custom_footer_js' => 'Rodapé JS',
            'custom_footer_js_placeholder' => 'JavaScript no rodapé da página, coloque-o dentro de <script></script>',
        ],
    ],
    'datatable' => [
        'title' => 'Tabelas de dados',
        'description' => 'Configurações para tabelas de dados',
        'form' => [
            'show_column_visibility' => 'Mostrar visibilidade da coluna por padrão',
            'show_column_visibility_helper' => 'Ative o botão de alternância de colunas nas tabelas para permitir mostrar ou ocultar colunas.',
            'show_export_button' => 'Mostrar botão de exportação por padrão',
            'show_export_button_helper' => 'Mostra as opções de exportação (CSV, Excel, PDF) nas tabelas para descarregar os dados.',
            'pagination_type' => 'Tipo de paginação',
            'pagination_type_helper' => 'Escolha como apresentar os controlos de paginação: padrão com números ou em formato de lista suspensa.',
            'default' => 'Padrão',
            'dropdown' => 'Suspenso',
            'enable_responsive' => 'Ativar responsividade da tabela',
            'enable_responsive_helper' => 'Ajusta automaticamente as colunas para diferentes tamanhos de ecrã e melhora a experiência mobile.',
        ],
    ],
    'email' => [
        'subject' => 'Assunto',
        'content' => 'Contente',
        'title' => 'Configuração do modelo de e-mail',
        'description' => 'Modelo de email usando HTML e variáveis ​​de sistema.',
        'reset_to_default' => 'Redefinir para o padrão',
        'back' => 'Voltar às configurações',
        'reset_success' => 'Redefinir para o padrão com sucesso',
        'confirm_reset' => 'Confirmar para redefinir o modelo de e-mail?',
        'confirm_message' => 'Você realmente deseja redefinir este modelo de e-mail para o padrão?',
        'continue' => 'Continuar',
        'sender_name' => 'Nome do remetente',
        'sender_name_placeholder' => 'Nome',
            'sender_name_helper' => 'Nome exibido no campo De das mensagens enviadas pelo sistema.',
            'sender_email' => 'E-mail do remetente',
            'sender_email_placeholder' => 'Endereço de e-mail (ex.: :default)',
            'sender_email_helper' => 'Endereço usado como remetente para todos os e-mails enviados pelo sistema.',
        'mailer' => 'Envio de correspondência',
        'port' => 'Porta',
        'port_placeholder' => 'Exemplo: 587',
            'port_helper' => 'Porta usada pelo servidor de e-mail (mais comuns: 25, 465, 587).',
        'host' => 'Hospedar',
        'host_placeholder' => 'Ex.: smtp.gmail.com',
            'host_helper' => 'Endereço do servidor SMTP.',
        'username' => 'Nome de usuário',
        'username_placeholder' => 'Nome de usuário para fazer login no servidor de e-mail',
            'username_helper' => 'Nome de utilizador para autenticar no servidor de e-mail.',
        'password' => 'Senha',
        'password_placeholder' => 'Senha para fazer login no servidor de e-mail',
            'password_helper' => 'Palavra-passe para autenticar no servidor de e-mail.',
        'encryption' => 'Criptografia',
        'encryption_placeholder' => 'Criptografia: SSL ou TLS',
            'encryption_helper' => 'Escolha o método de encriptação para enviar e-mails com segurança.',
            'encryption_none' => 'Nenhuma',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Dicas para configuração de e-mail',
        'setup_tip_gmail' => 'Para Gmail: utilize smtp.gmail.com como host, porta 587 com TLS ou porta 465 com SSL. Ative “Acesso a apps menos seguros” ou use uma Palavra-passe de Aplicação.',
        'setup_tip_port' => 'Portas mais comuns: 25 (sem encriptação), 587 (TLS/STARTTLS), 465 (SSL/TLS) e 2525 (alternativa).',
        'setup_tip_encryption' => 'Use TLS para a porta 587 (recomendado), SSL para a porta 465 ou nenhum para a porta 25 (não recomendado em produção).',
        'setup_tip_test' => 'Utilize sempre o botão "Enviar e-mail de teste" para validar a configuração antes de guardar.',
        'setup_tip_mailgun' => 'Para melhor entregabilidade, considere serviços como Mailgun, SendGrid ou Amazon SES em vez de SMTP.',
        'queue_warning_title' => 'Configuração de Fila Necessária',
        'queue_warning_description' => 'Sua fila de e-mail está atualmente configurada para usar o driver ":default", mas seu worker de fila pode não estar funcionando. Isso significa que os e-mails não serão enviados até que você configure um worker de fila.',
        'queue_warning_action' => 'Para enviar e-mails imediatamente sem um worker de fila, defina QUEUE_CONNECTION=sync em seu arquivo .env. Caso contrário, certifique-se de que seu worker de fila esteja funcionando com "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Saiba mais sobre Laravel Queues</a>.',
        'mail_gun_domain' => 'Domínio',
        'mail_gun_domain_placeholder' => 'Domínio',
        'mail_gun_domain_helper' => 'Domínio que registou no Mailgun.',
        'mail_gun_secret' => 'Segredo',
        'mail_gun_secret_placeholder' => 'Segredo',
        'mail_gun_secret_helper' => 'A sua chave API do Mailgun.',
        'mail_gun_endpoint' => 'Ponto final',
        'mail_gun_endpoint_placeholder' => 'Ponto final',
        'mail_gun_endpoint_helper' => 'Endpoint da API do Mailgun (api.mailgun.net para EUA, api.eu.mailgun.net para UE).',
        'log_channel' => 'Canal de registro',
        'log_channel_helper' => 'Selecione o canal de log que será usado para os registos de e-mail.',
        'sendmail_path' => 'Caminho do Sendmail',
        'local_domain' => 'Domínio local',
        'local_domain_placeholder' => 'Pode estar vazio. Precisa ser definido para seu domínio ao usar o SMTP Relay. Por exemplo seu-domínio.com',
        'local_domain_helper' => 'Domínio utilizado para identificar o servidor ao comunicar com servidores SMTP remotos.',
        'ses_key' => 'Chave',
        'ses_key_placeholder' => 'Chave',
        'ses_key_helper' => 'O seu AWS Access Key ID.',
        'ses_secret' => 'Segredo',
        'ses_secret_placeholder' => 'Segredo',
        'ses_secret_helper' => 'A sua AWS Secret Access Key.',
        'ses_region' => 'Região',
        'ses_region_placeholder' => 'Região',
        'ses_region_helper' => 'Região AWS na qual o SES está configurado.',
        'postmark_token' => 'Símbolo',
        'postmark_token_placeholder' => 'Símbolo',
        'postmark_token_helper' => 'Token do servidor Postmark.',
        'resend_key' => 'Chave da API',
        'resend_key_placeholder' => 'Ex.: re_123456789012345678901234567890',
        'resend_key_helper' => 'A sua chave API do Resend.',
        'email_templates' => 'Modelos de e-mail',
        'email_templates_description' => 'Modelos de e-mail usando HTML e variáveis ​​de sistema.',
        'email_template_settings' => 'Configurações do modelo de e-mail',
        'email_template_settings_description' => 'Visualize e atualize suas configurações de modelos de e-mail',
        'email_rules' => 'Regras de e-mail',
        'email_rules_description' => 'Configurar regras de e-mail para validação',
        'base_template' => 'Modelo básico',
        'base_template_description' => 'Modelo base para todos os e-mails',
        'template_header' => 'Cabeçalho do modelo de e-mail',
        'template_header_description' => 'Modelo para cabeçalho de e-mails',
        'template_footer' => 'Rodapé do modelo de e-mail',
        'template_footer_description' => 'Modelo para rodapé de e-mails',
        'default' => 'Padrão',
        'template_off_status_helper' => 'Este modelo de e-mail está desativado.',
        'blacklist_email_domains' => 'Domínios de e-mail na lista negra',
        'blacklist_email_domains_helper' => 'Insira uma lista de domínios de e-mail a serem colocados na lista negra. Por exemplo gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Endereços de e-mail na lista negra',
        'blacklist_specified_emails_helper' => 'Insira uma lista de endereços de e-mail específicos a serem colocados na lista negra. Por exemplo mail@exemplo.com.',
        'exception_emails' => 'E-mails de exceção',
        'exception_emails_helper' => 'Esses e-mails serão excluídos das regras de validação.',
        'email_rules_strict' => 'Validação estrita de e-mail',
        'email_rules_strict_helper' => 'Execute validação de e-mail semelhante a RFC com regras rígidas.',
        'email_rules_dns' => 'Validação de verificação de DNS',
        'email_rules_dns_helper' => 'Verifique se há registros DNS indicando que o servidor aceita emails.',
        'email_rules_spoof' => 'Detecção de falsificação',
        'email_rules_spoof_helper' => 'Detecte possíveis tentativas de falsificação de e-mail.',
        'template_turn_off' => 'Clique para desativar este modelo de e-mail',
        'template_turn_on' => 'Clique para ativar este modelo de e-mail',
        'turn_on_success_message' => 'Ative o modelo de e-mail com sucesso!',
        'turn_off_success_message' => 'Desative o modelo de e-mail com sucesso!',
        'email_template_status' => 'Status do modelo de e-mail',
        'email_template_status_description' => 'Ativar/desativar modelo de e-mail',
        'email_template_logo' => 'Logotipo',
        'email_template_logo_helper_text' => 'Se não definido, ele será obtido no logotipo do administrador em Admin -> Configurações -> Aparência do administrador -> Logotipo.',
        'email_template_copyright_text_helper_text' => 'Se não definido, ele obterá direitos autorais nas opções de tema em Admin -> Aparência -> Opções de tema -> Geral -> Direitos autorais.',
        'email_template_email_contact' => 'Endereço de e-mail de contato',
        'email_template_email_contact_helper_text' => 'Se não definido, ele receberá o e-mail do remetente em Admin -> Configurações -> E-mail',
        'email_template_social_links' => 'Links Sociais',
        'email_template_copyright_text' => 'Direitos autorais',
        'image_upload_supported' => 'Suporta apenas os formatos PNG, JPG, JPEG e GIF.',
        'email_template_custom_css' => 'CSS personalizado do modelo de e-mail',
        'social_links' => [
            'name' => 'Nome',
            'icon' => 'Ícone',
            'icon_image' => 'Imagem do ícone (suporta apenas os formatos PNG, JPG, JPEG e GIF).',
            'url' => 'URL',
            'image' => 'Imagem',
        ],
        'logo_height' => 'Altura do logotipo (px)',
        'logo_height_helper' => 'Defina a altura do logotipo em pixels. O valor padrão é :default.',
    ],
    'license_title' => 'Licença',
    'setup_license' => 'Configurar código de licença',
    'close' => 'Fechar',
    'media' => [
        'title' => 'Mídia',
        'driver' => 'Motorista',
        'description' => 'Configurações para mídia',
        'local_disk' => 'Disco local',
        'aws_access_key_id' => 'ID da chave de acesso da AWS',
        'aws_secret_key' => 'Chave secreta da AWS',
        'aws_default_region' => 'Região padrão da AWS',
        'aws_bucket' => 'Balde AWS',
        'aws_url' => 'URL da AWS',
        'aws_endpoint' => 'Endpoint AWS (opcional)',
        'use_path_style_endpoint' => 'Usar endpoint de estilo de caminho',
        'r2_access_key_id' => 'ID da chave de acesso R2',
        'r2_secret_key' => 'Chave secreta R2',
        'r2_bucket' => 'Balde R2',
        'r2_url' => 'URL R2',
        'r2_endpoint' => 'Ponto final R2',
        'do_spaces_access_key_id' => 'ID da chave de acesso do DO Spaces',
        'do_spaces_secret_key' => 'Chave secreta do DO Spaces',
        'do_spaces_default_region' => 'Região padrão dos espaços DO',
        'do_spaces_bucket' => 'Balde de espaços DO',
        'do_spaces_endpoint' => 'Ponto final do DO Spaces',
        'do_spaces_cdn_enabled' => 'O DO Spaces CDN está habilitado?',
        'do_spaces_cdn_enabled_helper' => 'Quando ativado, os arquivos de mídia serão servidos por meio do CDN do DigitalOcean Spaces para uma entrega mais rápida de conteúdo global. Opcionalmente, você pode configurar um domínio CDN personalizado abaixo.',
        'media_do_spaces_cdn_custom_domain' => 'Domínio personalizado do Spaces CDN',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://seu-domínio-personalizado.com',
        'wasabi_access_key_id' => 'ID da chave de acesso Wasabi',
        'wasabi_secret_key' => 'Chave secreta Wasabi',
        'wasabi_default_region' => 'Região padrão Wasabi',
        'wasabi_bucket' => 'Balde de wasabi',
        'wasabi_root' => 'Raiz de Wasabi',
        'wasabi_root_helper' => 'Para reutilizar imagens existentes, simplesmente designe a raiz do Wasabi como "/" e, em seguida, carregue todos os arquivos atuais de público/armazenamento para o diretório raiz do Wasabi.',
        'backblaze_access_key_id' => 'ID da chave de acesso Backblaze',
        'backblaze_secret_key' => 'Chave secreta Backblaze',
        'backblaze_bucket' => 'Balde Backblaze',
        'backblaze_default_region' => 'Região padrão do Backblaze',
        'backblaze_url' => 'URL de backblaze',
        'backblaze_endpoint' => 'Ponto final Backblaze',
        'backblaze_cdn_enabled' => 'Ativar CDN do Backblaze?',
        'backblaze_cdn_enabled_helper' => 'Quando ativado, os ficheiros de mídia serão entregues através de um CDN para melhorar a distribuição global. Configure abaixo um domínio CDN personalizado (ex.: Cloudflare ou Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Domínio personalizado do Backblaze CDN',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://o-seu-dominio-personalizado.com',
        'default_placeholder_image' => 'Imagem de espaço reservado padrão',
        'enable_chunk' => 'Habilite o upload de blocos',
        'chunk_size' => 'Tamanho do bloco (bytes)',
        'chunk_size_placeholder' => 'Padrão: 1048576 ~ 1 MB',
        'max_file_size' => 'Tamanho máximo do arquivo do bloco (MB)',
        'max_file_size_placeholder' => 'Padrão: 1048576 ~ 1 GB',
        'enable_watermark' => 'Ativar marca d\'água',
        'enable_watermark_helper' => 'Quando ativado, uma marca d\'água será adicionada automaticamente às imagens recém-carregadas nas pastas selecionadas. Isso não afeta as imagens existentes.',
        'watermark_source' => 'Imagem de marca d’água',
        'watermark_source_helper' => 'Suporta apenas formatos PNG, JPG e JPEG. Utilize uma imagem inferior a 200x200px e com menos de 50 KB.',
        'watermark_size' => 'Tamanho da marca d’água (%)',
        'watermark_size_placeholder' => 'Padrão: 10 (%)',
        'watermark_opacity' => 'Opacidade da marca d’água (%)',
        'watermark_opacity_placeholder' => 'Padrão: 70 (%)',
        'watermark_position' => 'Posição da marca d\'água',
        'watermark_position_x' => 'Posição da marca d\'água X',
        'watermark_position_y' => 'Posição da marca d’água Y',
        'watermark_position_top_left' => 'Canto superior esquerdo',
        'watermark_position_top_right' => 'Canto superior direito',
        'watermark_position_bottom_left' => 'Canto inferior esquerdo',
        'watermark_position_bottom_right' => 'Canto inferior direito',
        'watermark_position_center' => 'Centro',
        'turn_off_automatic_url_translation_into_latin' => 'Desative a tradução automática de URL para latim',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Quando ativado, os URLs dos arquivos não serão transliterados automaticamente para caracteres latinos, preservando os caracteres originais de alfabetos não latinos.',
        'bunnycdn_hostname' => 'Nome do host',
        'bunnycdn_zone' => 'Nome da zona (o nome da sua zona de armazenamento)',
        'bunnycdn_key' => 'Senha de acesso FTP e API (a senha de acesso API da zona de armazenamento)',
        'bunnycdn_region' => 'Região (a região da zona de armazenamento)',
        'optional' => 'Opcional',
        'sizes' => 'Tamanhos de miniaturas de mídia',
        'media_sizes_helper' => 'Defina largura ou altura como 0 se quiser apenas cortar por largura ou altura.',
        'width' => 'Largura',
        'height' => 'Altura',
        'default_size_value' => 'Padrão: :size',
        'all' => 'Todos',
        'all_helper_text' => 'Se você desmarcar todas as pastas, isso será aplicado a todas as pastas.',
        'media_folders_can_add_watermark' => 'Adicione marca d\'água para imagens em pastas:',
        'max_upload_filesize' => 'Tamanho máximo do arquivo de upload (MB)',
        'max_upload_filesize_placeholder' => 'Padrão: :size, deve ser inferior a :size.',
        'max_upload_filesize_helper' => 'O seu servidor permite carregar ficheiros até :size. Pode definir um valor menor para limitar o tamanho permitido.',
        'image_processing_library' => 'Biblioteca de processamento de imagens',
        'use_original_name_for_file_path' => 'Use o nome original para o caminho do arquivo',
        'use_original_name_for_file_path_helper' => 'Quando ativado, os arquivos enviados manterão seus nomes originais. Quando desativado, os nomes dos arquivos serão convertidos em slugs compatíveis com URL (por exemplo, "My Photo.jpg" torna-se "my-photo.jpg").',
        'keep_original_file_size_and_quality' => 'Mantenha o tamanho e a qualidade do arquivo original',
        'keep_original_file_size_and_quality_helper' => 'Quando ativado, as imagens enviadas não serão redimensionadas ou otimizadas, preservando a qualidade original e o tamanho do arquivo. Quando desativado, as imagens podem ser compactadas e redimensionadas com base nas suas configurações.',
        'update_thumbnail_sizes_warning' => 'Após ajustar o tamanho das miniaturas, você deve clicar no botão ":button_text" para atualizá-las.',
        'thumbnail_crop_position' => 'Posição de corte da miniatura',
        'thumbnail_crop_position_left' => 'Esquerda',
        'thumbnail_crop_position_center' => 'Centro',
        'thumbnail_crop_position_right' => 'Certo',
        'thumbnail_crop_position_top' => 'Principal',
        'thumbnail_crop_position_bottom' => 'Fundo',
        'thumbnail_crop_position_helper' => 'Esta configuração é usada para cortar a imagem ao gerar miniaturas. Ele será cortado desta posição até que a imagem seja preenchida.',
        'user_can_only_view_own_media' => 'Os usuários só podem visualizar sua própria mídia',
        'user_can_only_view_own_media_helper' => 'Quando ativado, os usuários só podem visualizar suas próprias mídias, enquanto os superadministradores podem visualizar todas as mídias.',
        'enable_thumbnail_sizes' => 'Ativar tamanhos de miniaturas',
        'enable_thumbnail_sizes_helper' => 'Habilite esta opção para gerar miniaturas de imagens. Se estiver desabilitado, o sistema não gerará miniaturas para imagens e sempre utilizará imagens em tamanho real.',
        'convert_image_to_webp' => 'Converta imagem JPG, JPEG, PNG para WebP',
        'convert_image_to_webp_helper' => 'WebP é um formato de imagem moderno que fornece compactação superior sem e com perdas para imagens na web. É compatível com Chrome, Firefox, Edge e Opera. A imagem será convertida para o formato WebP durante o upload. É aplicado apenas para imagens JPG, JPEG, PNG.',
        'reduce_large_image_size' => 'Reduza o tamanho grande da imagem ao fazer upload',
        'reduce_large_image_size_helper' => 'Quando ativado, o sistema reduzirá o tamanho de imagens grandes durante o upload, aplicado para imagens JPG, JPEG, PNG, WebP. A largura e altura máximas da imagem serão redimensionadas para os valores definidos abaixo.',
        'image_max_width' => 'Largura máxima da imagem (px)',
        'image_max_height' => 'Altura máxima da imagem (px)',
        'image_max_width_placeholder' => 'Deixe em branco para manter a largura original',
        'image_max_height_placeholder' => 'Deixe em branco para manter a altura original',
        'image_max_width_helper' => 'Defina a largura máxima da imagem em pixels. A largura original será mantida se este campo estiver vazio.',
        'image_max_height_helper' => 'Defina a altura máxima da imagem em pixels. A altura original será mantida se este campo estiver vazio.',
        'customize_upload_path' => 'Personalizar o caminho de upload',
        'customize_upload_path_helper' => 'Defina um caminho personalizado para os ficheiros de mídia. Por padrão, os ficheiros são guardados na pasta ":path".',
        'upload_path' => 'Pasta de upload',
        'upload_path_placeholder' => 'Ex.: uploads',
        'upload_path_helper' => 'A pasta será criada em /public. A pasta padrão é ":folder". Os ficheiros serão enviados para "/public/:folder".',
        'upload_path_warning' => 'O sistema não move ficheiros existentes para a nova pasta. Se precisar mover os ficheiros antigos, faça-o manualmente.',
        'convert_file_name_to_uuid' => 'Converter nome de ficheiro para UUID',
        'convert_file_name_to_uuid_helper' => 'Quando ativado, o sistema converte o nome do ficheiro para um UUID ao carregar, evitando duplicados e aumentando a segurança.',
        's3_path' => 'Caminho S3 personalizado (opcional)',
        's3_path_placeholder' => 'Caminho opcional no bucket S3 (ex.: uploads/media)',
    ],
    'field_type_not_exists' => 'Este tipo de campo não existe',
    'save_settings' => 'Salvar configurações',
    'template' => 'Modelo',
    'description' => 'Descrição',
    'enable' => 'Habilitar',
    'send' => 'Enviar',
    'test_email_description' => 'Para enviar e-mail de teste, certifique-se de ter as configurações atualizadas para envio de e-mail!',
    'test_email_input_placeholder' => 'Digite o endereço de e-mail para o qual deseja enviar o e-mail de teste.',
    'test_email_modal_title' => 'Envie um e-mail de teste',
    'test_send_mail' => 'Enviar e-mail de teste',
    'test_email_send_success' => 'E-mail enviado com sucesso!',
    'locale_direction_ltr' => 'Da esquerda para a direita',
    'locale_direction_rtl' => 'Da direita para a esquerda',
    'emails_warning' => 'Pode adicionar no máximo :count endereços de e-mail',
    'email_add_more' => 'Adicionar mais',
    'generate' => 'Gerar',
    'generate_thumbnails' => 'Gerar miniaturas',
    'generate_thumbnails_success' => 'Miniaturas geradas com sucesso. :count ficheiro(s) foram processados!',
    'generate_thumbnails_error' => 'Não foi possível regenerar as miniaturas de :count ficheiro(s)!',
    'generate_thumbnails_description' => 'Tem certeza de que deseja gerar novamente miniaturas para todas as imagens? Isso pode levar algum tempo. Não saia desta página até que o processo seja concluído.',
    'enable_chunk_description' => 'O upload de tamanho de bloco é usado para fazer upload de arquivos grandes.',
    'watermark_description' => 'AVISO: A marca d\'água é adicionada apenas às novas imagens enviadas, não será adicionada às imagens existentes. Desativar a marca d\'água não removerá a marca d\'água das imagens existentes.',
    'submit' => 'Enviar',
    'back' => 'Voltar',
    'enter_sample_value' => 'Insira valores de amostra para teste',
    'preview' => 'Visualização',
    'media_size_width' => 'A largura do tamanho :size deve ser superior a 0',
    'media_size_height' => 'A altura do tamanho :size deve ser superior a 0',
    'security' => [
        'title' => 'Configurações de Segurança',
        'description' => 'Verifique e configure as definições de segurança para o seu site.',
        'menu_description' => 'Gerenciar segurança de cookies e cabeçalhos HTTP',
        'status_secure' => 'Todas as configurações de segurança estão configuradas corretamente!',
        'status_insecure' => 'Algumas configurações de segurança precisam de atenção!',
        'current_settings' => 'Configurações de Segurança Atuais',
        'status' => 'Estado',
        'setting' => 'Configuração',
        'current_value' => 'Valor Atual',
        'recommended_value' => 'Recomendado',
        'session_http_only' => 'Sinalizador HttpOnly Cookie',
        'session_http_only_description' => 'Impede que JavaScript acesse cookies de sessão (protege contra ataques XSS)',
        'session_secure_cookie' => 'Sinalizador Secure Cookie',
        'session_secure_cookie_description' => 'Garante que os cookies sejam enviados apenas por conexões HTTPS',
        'session_same_site' => 'Sinalizador SameSite Cookie',
        'session_same_site_description' => 'Previne ataques CSRF ao restringir quando os cookies são enviados',
        'http_security_headers' => 'Cabeçalhos de Segurança HTTP',
        'http_security_headers_description' => 'Adiciona cabeçalhos de segurança para proteger contra vulnerabilidades web comuns',
        'https_warning' => 'Seu site não está usando HTTPS',
        'https_warning_description' => 'Alguns recursos de segurança, como cookies seguros, exigem HTTPS. Considere ativar SSL para o seu site.',
        'how_to_fix' => 'Como Corrigir Problemas de Segurança',
        'env_file_location' => 'Edite seu arquivo .env localizado em:',
        'add_to_env' => 'Configurações a Adicionar',
        'required_settings' => 'Configurações de Segurança Obrigatórias',
        'for_https_sites' => 'Apenas para Sites HTTPS',
        'copy' => 'Copiar',
        'copy_settings' => 'Copiar Todas as Configurações',
        'copied' => 'Copiado!',
        'steps' => 'Passos para Aplicar Configurações',
        'step_1' => 'Abra seu arquivo .env em um editor de texto',
        'step_2' => 'Adicione ou atualize as configurações de segurança mostradas acima',
        'step_3' => 'Salve o arquivo .env',
        'step_4' => 'Limpe o cache usando Painel de Administração → Administração da Plataforma → Gerenciamento de Cache',
        'security_headers_info' => 'Informação sobre Cabeçalhos de Segurança',
        'security_headers_list' => 'Quando ativado, os seguintes cabeçalhos são adicionados a todas as respostas:',
        'header_nosniff' => 'Impede que navegadores adivinhem tipos de conteúdo',
        'header_frame' => 'Protege contra ataques de clickjacking',
        'header_xss' => 'Ativa a proteção XSS do navegador',
        'header_referrer' => 'Controla quanta informação de referência é enviada',
        'learn_more' => 'Para informações mais detalhadas, consulte a :documentation',
        'documentation' => 'documentação de segurança',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Configure o cache para velocidade otimizada',
        'form' => [
            'cache_admin_menu' => 'Menu de administração de cache',
            'cache_admin_menu_helper' => 'Menu de administração de cache para velocidade otimizada. Esta opção deve ser desabilitada se você estiver desenvolvendo ou personalizando o menu de administração.',
            'enable_cache_site_map' => 'Mapa do site de cache',
            'enable_cache_site_map_helper' => 'O mapa do site :url deve ser armazenado em cache quando existirem muitas páginas. Se tiver poucas páginas pode desativar esta opção.',
            'cache_time_site_map' => 'Tempo limite de cache do mapa do site (em minutos)',
            'cache_front_menu' => 'Menu frontal do cache',
            'cache_front_menu_helper' => 'Menu frontal de cache para velocidade otimizada',
            'cache_user_avatar' => 'Cache do avatar do usuário',
            'cache_user_avatar_helper' => 'Para usuários sem avatar, o sistema irá gerar avatares a partir de seus nomes de usuário. Os avatares serão armazenados em cache para velocidade otimizada e não serão regenerados.',
            'shortcode_cache_enabled' => 'Cache de shortcodes (blocos de IU)',
            'shortcode_cache_enabled_helper' => 'Ative o cache para shortcodes e melhore o desempenho. Quando ativo, os blocos são armazenados para reduzir o tempo de renderização.',
            'shortcode_cache_warning' => '<strong>⚠️ Aviso importante:</strong><br>• Shortcodes que contenham formulários (contacto, newsletter, etc.) ignoram o cache automaticamente para manter a funcionalidade.<br>• Shortcodes com JavaScript dinâmico devem ter o cache desativado manualmente.<br>• Para desativar o cache de um shortcode específico, defina <code>Enable caching: No</code> na configuração do bloco.<br>• Formulários com tokens CSRF, reCAPTCHA ou outros elementos dinâmicos são detetados e excluídos do cache automaticamente.',
            'shortcode_cache_ttl' => 'Duração do cache (segundos)',
            'shortcode_cache_ttl_helper' => 'Duração em segundos para manter os shortcodes em cache. Padrão: 1800 segundos (30 minutos).',
            'widget_cache_enabled' => 'Cache de widgets',
            'widget_cache_enabled_helper' => 'Ative o cache dos widgets para melhorar o desempenho. Quando ativo, os widgets são armazenados para reduzir o tempo de renderização.',
            'widget_cache_warning' => '<strong>⚠️ Aviso importante:</strong><br>• Widgets que contenham formulários (contacto, newsletter, etc.) ignoram o cache automaticamente.<br>• Widgets com JavaScript dinâmico devem ter o cache desativado manualmente.<br>• Para desativar o cache de um widget específico, defina <code>Enable caching: No</code> na sua configuração.<br>• Formulários com tokens CSRF, reCAPTCHA ou outros elementos dinâmicos são detetados e excluídos do cache automaticamente.',
            'widget_cache_ttl' => 'Duração do cache (segundos)',
            'widget_cache_ttl_helper' => 'Duração em segundos para manter os widgets em cache. Padrão: 1800 segundos (30 minutos).',
            'plugin_cache_enabled' => 'Cachear plugins instalados',
            'plugin_cache_enabled_helper' => 'Armazena a lista de plugins instalados durante 30 minutos para reduzir leituras no sistema de ficheiros e melhorar o desempenho.',
        ],
    ],
    'appearance' => [
        'title' => 'Aparência',
    ],
    'panel' => [
        'common' => 'Comum',
        'general' => 'Em geral',
        'general_description' => 'Visualize e atualize suas configurações gerais e ative a licença',
        'email' => 'E-mail',
        'email_description' => 'Visualize e atualize suas configurações e modelos de email',
        'media' => 'Mídia',
        'media_description' => 'Visualize e atualize suas configurações de mídia',
        'system' => 'Sistema',
        'system_updater' => 'Atualizador do sistema',
        'system_updater_description' => 'Atualize seu sistema para a versão mais recente',
        'others' => 'Outros',
    ],
    'saving' => 'Salvando...',
    'generating_media_thumbnails' => 'Gerando miniaturas de mídia...',
    'test_email_template' => 'Modelo de e-mail de teste',
    'select_email_template' => 'Selecione o modelo de e-mail',
    'enums' => [
        'data_retention_period' => [
            'Nunca',
            '1 dia',
            3 => '3 dias',
            7 => '1 semana',
            30 => '1 mês',
            90 => '3 meses',
            180 => '6 meses',
            365 => '1 ano',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => 'O campo :attribute deve ser uma região AWS válida (ex.: us-east-1, eu-west-1).',
    ],
    'phone_number' => [
        'title' => 'Número de telefone',
        'description' => 'Configurar definições do campo de número de telefone',
        'enable_country_code' => 'Ativar seleção de código de país',
        'enable_country_code_helper' => 'Quando ativado, os campos de número de telefone exibirão um seletor de código de país com deteção automática do país.',
        'available_countries' => 'Países disponíveis',
        'all' => 'Todos',
        'all_helper_text' => 'Selecione todos os países disponíveis no seletor de código de país do telefone.',
        'min_length' => 'Comprimento mínimo',
        'min_length_helper' => 'Número mínimo de caracteres necessários para números de telefone.',
        'max_length' => 'Comprimento máximo',
        'max_length_helper' => 'Número máximo de caracteres permitidos para números de telefone.',        'note_content' => '<p class="mb-1"><strong>Para formato local (sem código de país):</strong> Defina mín/máx com base no comprimento do número de telefone do seu país (por exemplo, 8-15 para a maioria dos países).</p><p class="mb-0"><strong>Para formato internacional (com código de país ativado):</strong> Recomendado mín: 7, máx: 20. Isso acomoda códigos de país (1-4 dígitos) + números de telefone (normalmente 6-15 dígitos).</p>',
    ],
];
