<?php

return [
    'title' => 'הגדרות',
    'general_setting' => 'הגדרות כלליות',
    'menu' => 'כל ההגדרות',
    'email_setting_title' => 'הגדרות דואר אלקטרוני',
    'email_setting_description' => 'הגדר את הגדרות הדואר האלקטרוני',
    'general' => [
        'theme' => 'עיצוב',
        'title' => 'מידע כללי',
        'description' => 'צפה ועדכן את מידע האתר',
        'rich_editor' => 'עורך עשיר',
        'site_title' => 'כותרת האתר',
        'admin_email' => 'דואר אלקטרוני של מנהל',
        'seo_block' => 'הגדרות SEO',
        'seo_title' => 'כותרת SEO',
        'seo_description' => 'תיאור SEO',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'כותרת האתר (מקסימום 120 תווים)',
            'admin_email' => 'דואר אלקטרוני של מנהל',
            'seo_title' => 'כותרת SEO (מקסימום 120 תווים)',
            'seo_description' => 'תיאור SEO (מקסימום 120 תווים)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'שלח דיווחי שגיאות באמצעות דואר אלקטרוני',
        'enable_send_error_reporting_via_email_helper' => 'כאשר מופעל, דוחות שגיאה מפורטים יישלחו לכתובות הדוא"ל של המנהל כאשר מתרחשות שגיאות קריטיות באתר',
        'time_zone' => 'אזור זמן',
        'time_zone_helper' => 'בחר את אזור הזמן עבור האתר שלך. זה ישמש לכל תצוגות התאריך והשעה בכל המערכת',
        'enable' => 'הפעל',
        'disable' => 'השבת',
        'disabled_helper' => 'לא ניתן להשבית תבנית דואר אלקטרוני זו!',
        'enable_cache_site_map' => 'הפעל שמירת מפת אתר במטמון',
        'cache_time_site_map' => 'זמן תפוגה של מטמון מפת אתר (בדקות)',
        'admin_logo' => 'לוגו ניהול',
        'admin_favicon' => 'סמל מועדפים ניהול',
        'admin_title' => 'כותרת ניהול',
        'admin_title_placeholder' => 'כותרת להצגה בלשונית הדפדפן',
        'admin_appearance_title' => 'מראה ניהול',
        'admin_appearance_description' => 'הגדר את מראה הניהול כגון עורך, שפה...',
        'seo_block_description' => 'הגדר כותרת אתר, תיאור מטא של אתר, מילות מפתח של אתר לאופטימיזציה של SEO',
        'webmaster_tools_description' => 'Google Search Console הוא כלי אינטרנט חינמי המסופק על ידי Google המסייע לבעלי אתרים לעקוב אחר ביצועי האתר שלהם בתוצאות חיפוש Google.',
        'yes' => 'כן',
        'no' => 'לא',
        'show_on_front' => 'דף הבית שלך מציג',
        'select' => '— בחר —',
        'show_site_name' => 'הצג שם אתר אחרי כותרת הדף, מופרד עם "-"',
        'locale' => 'שפת האתר',
        'locale_direction' => 'כיוון שפת האתר הקדמי',
        'minutes' => 'דקות',
        'redirect_404_to_homepage' => 'הפנה את כל בקשות הלא נמצאו לדף הבית',
    ],
    'admin_appearance' => [
        'title' => 'מראה ניהול',
        'description' => 'צפה ועדכן לוגו, סמל מועדפים, פריסה,...',
        'layout' => 'פריסה',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => 'אופקי',
        'vertical' => 'אנכי',
        'show_menu_item_icon' => 'הצג סמל פריט תפריט',
        'language' => 'שפת לוח הניהול',
        'theme_mode' => 'מצב עיצוב',
        'dark' => 'כהה',
        'light' => 'בהיר',
        'container_width' => [
            'title' => 'רוחב מיכל',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => 'ברירת מחדל',
            'large' => 'גדול',
            'full' => 'מלא',
        ],
        'form' => [
            'admin_logo' => 'לוגו ניהול',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => 'גובה לוגו (px)',
            'admin_logo_max_height_helper' => 'הגדר את גובה הלוגו בפיקסלים. ערך ברירת המחדל הוא :default.',
            'admin_favicon' => 'סמל מועדפים ניהול',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => 'סוג סמל מועדפים ניהול',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => 'כותרת ניהול',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => 'כותרת להצגה בלשונית הדפדפן',
            'admin_login_screen_backgrounds' => 'רקעים למסך כניסה (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => 'שפת ניהול',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => 'כיוון שפת ניהול',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => 'עורך עשיר',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => 'גופן ראשי',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => 'צבע ראשי',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => 'צבע משני',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => 'צבע כותרת',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => 'צבע טקסט',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => 'צבע קישור',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => 'צבע ריחוף קישור',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => 'הצג סמל פריט תפריט',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => 'CSS מותאם אישית',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => 'JS מותאם אישית',
            'custom_header_js' => 'Header JS',
            'custom_header_js_placeholder' => 'JavaScript בכותרת הדף, עטוף אותו בתוך &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript בגוף הדף, עטוף אותו בתוך &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Footer JS',
            'custom_footer_js_placeholder' => 'JavaScript בתחתית הדף, עטוף אותו בתוך &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'טבלאות נתונים',
        'description' => 'הגדרות עבור טבלאות נתונים',
        'form' => [
            'show_column_visibility' => 'הצג נראות עמודות כברירת מחדל',
            'show_column_visibility_helper' => 'הפעל את כפתור החלפת נראות עמודות בטבלאות נתונים כדי לאפשר למשתמשים להציג/להסתיר עמודות',
            'show_export_button' => 'הצג כפתור ייצוא כברירת מחדל',
            'show_export_button_helper' => 'הצג אפשרויות ייצוא (CSV, Excel, PDF) בטבלאות נתונים להורדת נתוני טבלה',
            'pagination_type' => 'סוג עימוד',
            'pagination_type_helper' => 'בחר כיצד מוצגים בקרי עימוד: ברירת מחדל מציגה מספרי עמודים, רשימה נפתחת מציגה בורר רשימה נפתחת קומפקטי',
            'default' => 'ברירת מחדל',
            'dropdown' => 'רשימה נפתחת',
            'enable_responsive' => 'הפעל תגובתיות טבלה',
            'enable_responsive_helper' => 'התאם אוטומטית עמודות טבלה להתאים לגדלי מסך שונים לחוויה טובה יותר במובייל',
        ],
    ],
    'email' => [
        'subject' => 'נושא',
        'content' => 'תוכן',
        'title' => 'הגדרה לתבנית דואר אלקטרוני',
        'description' => 'תבנית דואר אלקטרוני המשתמשת ב-HTML ומשתני מערכת.',
        'reset_to_default' => 'אפס לברירת מחדל',
        'back' => 'חזור להגדרות',
        'reset_success' => 'אופס בהצלחה לברירת מחדל',
        'confirm_reset' => 'אשר איפוס תבנית דואר אלקטרוני?',
        'confirm_message' => 'האם אתה באמת רוצה לאפס תבנית דואר אלקטרוני זו לברירת מחדל?',
        'continue' => 'המשך',
        'sender_name' => 'שם שולח',
        'sender_name_placeholder' => 'שם',
        'sender_name_helper' => 'השם שיופיע בשדה מאת של הודעות דואר אלקטרוני הנשלחות על ידי המערכת',
        'sender_email' => 'דואר אלקטרוני של שולח',
        'sender_email_placeholder' => 'כתובת דואר אלקטרוני (לדוגמה :default)',
        'sender_email_helper' => 'כתובת הדואר האלקטרוני שתשמש כשולח עבור כל הודעות הדואר האלקטרוני הנשלחות על ידי המערכת',
        'mailer' => 'שולח דואר',
        'port' => 'פורט',
        'port_placeholder' => 'לדוגמה: 587',
        'port_helper' => 'הפורט המשמש את שרת הדואר שלך (פורטים נפוצים: 25, 465, 587)',
        'host' => 'מארח',
        'host_placeholder' => 'לדוגמה: smtp.gmail.com',
        'host_helper' => 'כתובת מארח SMTP',
        'username' => 'שם משתמש',
        'username_placeholder' => 'שם משתמש להתחברות לשרת דואר',
        'username_helper' => 'שם המשתמש שלך להתחברות לשרת הדואר',
        'password' => 'סיסמה',
        'password_placeholder' => 'סיסמה להתחברות לשרת דואר',
        'password_helper' => 'הסיסמה שלך להתחברות לשרת הדואר',
        'encryption' => 'הצפנה',
        'encryption_placeholder' => 'בחר סוג הצפנה',
        'encryption_helper' => 'בחר את שיטת ההצפנה עבור שידור דואר אלקטרוני מאובטח',
        'encryption_none' => 'ללא',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'טיפים להגדרת דואר אלקטרוני',
        'setup_tip_gmail' => 'עבור Gmail: השתמש ב-smtp.gmail.com כמארח, פורט 587 עם TLS או פורט 465 עם SSL. הפעל "גישה לאפליקציה פחות מאובטחת" או השתמש בסיסמת אפליקציה.',
        'setup_tip_port' => 'פורטים נפוצים: 25 (לא מוצפן), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (חלופי).',
        'setup_tip_encryption' => 'השתמש ב-TLS עבור פורט 587 (מומלץ), SSL עבור פורט 465, או ללא עבור פורט 25 (לא מומלץ לייצור).',
        'setup_tip_test' => 'השתמש תמיד בכפתור "שלח דואר אלקטרוני לבדיקה" כדי לאמת את התצורה שלך לפני השמירה.',
        'setup_tip_mailgun' => 'לאספקה טובה יותר, שקול להשתמש בשירותי דואר אלקטרוני כמו Mailgun, SendGrid או Amazon SES במקום SMTP.',
        'queue_warning_title' => 'נדרשת הגדרת תור',
        'queue_warning_description' => 'תור הדואר האלקטרוני שלך מוגדר כעת להשתמש במנהל התקן ":default", אבל עובד התור שלך עשוי לא לפעול. המשמעות היא שהודעות דואר אלקטרוני לא יישלחו עד שתגדיר עובד תור.',
        'queue_warning_action' => 'כדי לשלוח הודעות דואר אלקטרוני מיד ללא עובד תור, הגדר QUEUE_CONNECTION=sync בקובץ .env שלך. אחרת, ודא שעובד התור שלך פועל עם "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">למד עוד על תורי Laravel</a>.',
        'mail_gun_domain' => 'דומיין',
        'mail_gun_domain_placeholder' => 'לדוגמה: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'שם הדומיין שרשמת ב-Mailgun',
        'mail_gun_secret' => 'סוד',
        'mail_gun_secret_placeholder' => 'לדוגמה: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'מפתח ה-API שלך ב-Mailgun',
        'mail_gun_endpoint' => 'נקודת קצה',
        'mail_gun_endpoint_placeholder' => 'לדוגמה: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'נקודת קצה של Mailgun API (api.mailgun.net עבור ארה"ב, api.eu.mailgun.net עבור אירופה)',
        'log_channel' => 'ערוץ יומן',
        'log_channel_helper' => 'בחר איזה ערוץ רישום להשתמש ביומני דואר אלקטרוני',
        'sendmail_path' => 'נתיב Sendmail',
        'local_domain' => 'דומיין מקומי',
        'local_domain_placeholder' => 'זה יכול להיות ריק. צריך להגדיר לדומיין שלך בעת שימוש ב-SMTP Relay. לדוגמה your-domain.com',
        'local_domain_helper' => 'הדומיין שישמש לזיהוי השרת בעת תקשורת עם שרתי SMTP מרוחקים',
        'ses_key' => 'מפתח',
        'ses_key_placeholder' => 'לדוגמה: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'מזהה מפתח הגישה שלך ל-AWS',
        'ses_secret' => 'סוד',
        'ses_secret_placeholder' => 'לדוגמה: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'מפתח הגישה הסודי שלך ל-AWS',
        'ses_region' => 'אזור',
        'ses_region_placeholder' => 'לדוגמה: us-east-1',
        'ses_region_helper' => 'אזור ה-AWS שבו שירות ה-SES שלך מוגדר',
        'postmark_token' => 'אסימון',
        'postmark_token_placeholder' => 'לדוגמה: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'אסימון השרת שלך ב-Postmark',
        'resend_key' => 'מפתח API',
        'resend_key_placeholder' => 'לדוגמה: re_123456789012345678901234567890',
        'resend_key_helper' => 'מפתח ה-API שלך ב-Resend',
        'email_templates' => 'תבניות דואר אלקטרוני',
        'email_templates_description' => 'תבניות דואר אלקטרוני המשתמשות ב-HTML ומשתני מערכת.',
        'email_template_settings' => 'הגדרות תבנית דואר אלקטרוני',
        'email_template_settings_description' => 'צפה ועדכן את הגדרות תבניות הדואר האלקטרוני שלך',
        'email_rules' => 'כללי דואר אלקטרוני',
        'email_rules_description' => 'הגדר כללי דואר אלקטרוני לאימות',
        'base_template' => 'תבנית בסיס',
        'base_template_description' => 'תבנית בסיס עבור כל הודעות הדואר האלקטרוני',
        'template_header' => 'כותרת תבנית דואר אלקטרוני',
        'template_header_description' => 'תבנית עבור כותרת הודעות דואר אלקטרוני',
        'template_footer' => 'תחתית תבנית דואר אלקטרוני',
        'template_footer_description' => 'תבנית עבור תחתית הודעות דואר אלקטרוני',
        'default' => 'ברירת מחדל',
        'template_off_status_helper' => 'תבנית דואר אלקטרוני זו כבויה.',
        'blacklist_email_domains' => 'דומיינים חסומים של דואר אלקטרוני',
        'blacklist_email_domains_helper' => 'הזן רשימה של דומיינים של דואר אלקטרוני להיות חסומים. לדוגמה gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'כתובות דואר אלקטרוני חסומות',
        'blacklist_specified_emails_helper' => 'הזן רשימה של כתובות דואר אלקטרוני ספציפיות להיות חסומות. לדוגמה mail@example.com.',
        'exception_emails' => 'הודעות דואר אלקטרוני חריגות',
        'exception_emails_helper' => 'הודעות דואר אלקטרוני אלה יוחרגו מכללי האימות.',
        'email_rules_strict' => 'אימות דואר אלקטרוני קפדני',
        'email_rules_strict_helper' => 'בצע אימות דואר אלקטרוני כמו-RFC עם כללים קפדניים.',
        'email_rules_dns' => 'אימות בדיקת DNS',
        'email_rules_dns_helper' => 'בדוק אם יש רשומות DNS המצביעות על כך שהשרת מקבל הודעות דואר אלקטרוני.',
        'email_rules_spoof' => 'זיהוי התחזות',
        'email_rules_spoof_helper' => 'זהה ניסיונות התחזות דואר אלקטרוני פוטנציאליים.',
        'template_turn_off' => 'לחץ לכיבוי תבנית דואר אלקטרוני זו',
        'template_turn_on' => 'לחץ להפעלת תבנית דואר אלקטרוני זו',
        'turn_on_success_message' => 'הפעל תבנית דואר אלקטרוני בהצלחה!',
        'turn_off_success_message' => 'כבה תבנית דואר אלקטרוני בהצלחה!',
        'email_template_status' => 'סטטוס תבנית דואר אלקטרוני',
        'email_template_status_description' => 'הפעל/כבה תבנית דואר אלקטרוני',
        'email_template_logo' => 'לוגו',
        'email_template_logo_helper_text' => 'אם לא תגדיר, זה ייקח מלוגו הניהול בניהול -> הגדרות -> מראה ניהול -> לוגו.',
        'email_template_copyright_text_helper_text' => 'אם לא תגדיר, זה ייקח מזכויות יוצרים של אפשרויות עיצוב בניהול -> מראה -> אפשרויות עיצוב -> כללי -> זכויות יוצרים.',
        'email_template_email_contact' => 'כתובת דואר אלקטרוני ליצירת קשר',
        'email_template_email_contact_helper_text' => 'אם לא תגדיר, זה ייקח מדואר אלקטרוני שולח בניהול -> הגדרות -> דואר אלקטרוני',
        'email_template_social_links' => 'קישורים חברתיים',
        'email_template_copyright_text' => 'זכויות יוצרים',
        'image_upload_supported' => 'תומך רק בפורמטים PNG, JPG, JPEG ו-GIF.',
        'email_template_custom_css' => 'CSS מותאם אישית לתבנית דואר אלקטרוני',
        'social_links' => [
            'name' => 'שם',
            'icon' => 'סמל',
            'icon_image' => 'תמונת סמל (תומך רק בפורמטים PNG, JPG, JPEG ו-GIF.)',
            'url' => 'URL',
            'image' => 'תמונה',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'רישיון',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'מדיה',
        'driver' => 'מנהל התקן',
        'description' => 'הגדרות עבור מדיה',
        'local_disk' => 'דיסק מקומי',
        'aws_access_key_id' => 'AWS Access Key ID',
        'aws_secret_key' => 'AWS Secret Key',
        'aws_default_region' => 'AWS Default Region',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (אופציונלי)',
        'use_path_style_endpoint' => 'השתמש בנקודת קצה בסגנון נתיב',
        'r2_access_key_id' => 'R2 Access Key ID',
        'r2_secret_key' => 'R2 Secret Key',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces Access Key ID',
        'do_spaces_secret_key' => 'DO Spaces Secret Key',
        'do_spaces_default_region' => 'DO Spaces Default Region',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'האם DO Spaces CDN מופעל?',
        'do_spaces_cdn_enabled_helper' => 'When enabled, media files will be served through DigitalOcean Spaces CDN for faster global content delivery. You can optionally configure a custom CDN domain below.',
        'media_do_spaces_cdn_custom_domain' => 'דומיין מותאם אישית של Do Spaces CDN',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi Access Key ID',
        'wasabi_secret_key' => 'Wasabi Secret Key',
        'wasabi_default_region' => 'Wasabi Default Region',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => 'כדי לעשות שימוש חוזר בתמונות קיימות, פשוט ציין את שורש Wasabi כ-"/"، ואז העלה את כל הקבצים הנוכחיים מ-public/storage לספריית השורש של Wasabi שלך.',
        'backblaze_access_key_id' => 'Backblaze Access Key ID',
        'backblaze_secret_key' => 'Backblaze Secret Key',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze Default Region',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'האם Backblaze CDN מופעל?',
        'backblaze_cdn_enabled_helper' => 'When enabled, media files will be served through a CDN for faster global content delivery. You must configure a custom CDN domain below (e.g., Cloudflare CDN or Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'דומיין מותאם אישית של Backblaze CDN',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => 'תמונת ממלא מקום ברירת מחדל',
        'enable_chunk' => 'הפעל העלאת נתחים',
        'chunk_size' => 'גודל נתח (Bytes)',
        'chunk_size_placeholder' => 'ברירת מחדל: 1048576 ~ 1MB',
        'max_file_size' => 'גודל קובץ מקסימלי של נתח (MB)',
        'max_file_size_placeholder' => 'ברירת מחדל: 1048576 ~ 1GB',
        'enable_watermark' => 'הפעל סימן מים',
        'enable_watermark_helper' => 'When enabled, a watermark will be automatically added to newly uploaded images in selected folders. This does not affect existing images.',
        'watermark_source' => 'תמונת סימן מים',
        'watermark_source_helper' => 'תומך רק בפורמטים PNG, JPG ו-JPEG. עליך להשתמש בתמונה קטנה מ-200x200px ובגודל קטן מ-50KB.',
        'watermark_size' => 'גודל סימן מים (%)',
        'watermark_size_placeholder' => 'ברירת מחדל: 10 (%)',
        'watermark_opacity' => 'שקיפות סימן מים (%)',
        'watermark_opacity_placeholder' => 'ברירת מחדל: 70 (%)',
        'watermark_position' => 'מיקום סימן מים',
        'watermark_position_x' => 'מיקום X של סימן מים',
        'watermark_position_y' => 'מיקום Y של סימן מים',
        'watermark_position_top_left' => 'למעלה משמאל',
        'watermark_position_top_right' => 'למעלה מימין',
        'watermark_position_bottom_left' => 'למטה משמאל',
        'watermark_position_bottom_right' => 'למטה מימין',
        'watermark_position_center' => 'מרכז',
        'turn_off_automatic_url_translation_into_latin' => 'כבה תרגום אוטומטי של URL ללטינית',
        'turn_off_automatic_url_translation_into_latin_helper' => 'When enabled, file URLs will not be automatically transliterated to Latin characters, preserving original characters from non-Latin alphabets.',
        'bunnycdn_hostname' => 'שם מארח',
        'bunnycdn_zone' => 'שם אזור (השם של אזור האחסון שלך)',
        'bunnycdn_key' => 'סיסמת גישה FTP & API (סיסמת הגישה API של אזור האחסון)',
        'bunnycdn_region' => 'אזור (אזור אזור האחסון)',
        'optional' => 'אופציונלי',
        'sizes' => 'גדלי תמונות ממוזערות מדיה',
        'media_sizes_helper' => 'הגדר רוחב או גובה ל-0 אם אתה רוצה רק לחתוך לפי רוחב או גובה.',
        'width' => 'רוחב',
        'height' => 'גובה',
        'default_size_value' => 'ברירת מחדל: :size',
        'all' => 'הכל',
        'all_helper_text' => 'אם תבטל את הסימון של כל התיקיות, זה יחול על כל התיקיות.',
        'media_folders_can_add_watermark' => 'הוסף סימן מים לתמונות בתיקיות:',
        'max_upload_filesize' => 'גודל קובץ מקסימלי להעלאה (MB)',
        'max_upload_filesize_placeholder' => 'ברירת מחדל: :size, חייב להיות פחות מ-:size.',
        'max_upload_filesize_helper' => 'השרת שלך מאפשר להעלות קבצים מקסימום :size, אתה יכול לשנות ערך זה כדי להגביל את גודל הקובץ להעלאה.',
        'image_processing_library' => 'ספריית עיבוד תמונה',
        'use_original_name_for_file_path' => 'השתמש בשם המקורי עבור נתיב קובץ',
        'use_original_name_for_file_path_helper' => 'When enabled, uploaded files will keep their original names. When disabled, file names will be converted to URL-friendly slugs (e.g., "My Photo.jpg" becomes "my-photo.jpg").',
        'keep_original_file_size_and_quality' => 'שמור על גודל ואיכות הקובץ המקוריים',
        'keep_original_file_size_and_quality_helper' => 'When enabled, uploaded images will not be resized or optimized, preserving their original quality and file size. When disabled, images may be compressed and resized based on your settings.',
        'update_thumbnail_sizes_warning' => 'לאחר התאמת גדלי התמונות הממוזערות, עליך ללחוץ על כפתור ":button_text" כדי לרענן אותן.',
        'thumbnail_crop_position' => 'מיקום חיתוך תמונה ממוזערת',
        'thumbnail_crop_position_left' => 'שמאל',
        'thumbnail_crop_position_center' => 'מרכז',
        'thumbnail_crop_position_right' => 'ימין',
        'thumbnail_crop_position_top' => 'למעלה',
        'thumbnail_crop_position_bottom' => 'למטה',
        'thumbnail_crop_position_helper' => 'הגדרה זו משמשת לחיתוך התמונה בעת יצירת תמונות ממוזערות. היא תיחתך ממיקום זה עד שהתמונה תתמלא.',
        'user_can_only_view_own_media' => 'משתמשים יכולים לצפות רק במדיה שלהם',
        'user_can_only_view_own_media_helper' => 'כאשר מופעל, משתמשים יכולים לצפות רק במדיה שלהם, בעוד מנהלי על יכולים לצפות בכל המדיה.',
        'enable_thumbnail_sizes' => 'הפעל גדלי תמונות ממוזערות',
        'enable_thumbnail_sizes_helper' => 'הפעל אפשרות זו כדי ליצור תמונות ממוזערות עבור תמונות. אם היא מושבתת, המערכת לא תיצור תמונות ממוזערות עבור תמונות ותשתמש תמיד בתמונה בגודל מלא.',
        'convert_image_to_webp' => 'המר תמונת JPG, JPEG, PNG ל-WebP',
        'convert_image_to_webp_helper' => 'WebP הוא פורמט תמונה מודרני המספק דחיסה ללא אובדן ועם אובדן מעולה לתמונות באינטרנט. הוא נתמך ב-Chrome, Firefox, Edge ו-Opera. התמונה תומר לפורמט WebP בעת העלאה. זה מוחל רק על תמונות JPG, JPEG, PNG.',
        'reduce_large_image_size' => 'הקטן גודל תמונה גדולה בעת העלאה',
        'reduce_large_image_size_helper' => 'כאשר מופעל, המערכת תקטין את גודל התמונות הגדולות בעת העלאה, מוחל על תמונות JPG, JPEG, PNG, WebP. הרוחב והגובה המקסימליים של התמונה ישונו לערכים שהגדרת למטה.',
        'image_max_width' => 'רוחב מקסימלי של תמונה (px)',
        'image_max_height' => 'גובה מקסימלי של תמונה (px)',
        'image_max_width_placeholder' => 'השאר ריק כדי לשמור על רוחב מקורי',
        'image_max_height_placeholder' => 'השאר ריק כדי לשמור על גובה מקורי',
        'image_max_width_helper' => 'הגדר את הרוחב המקסימלי של התמונה בפיקסלים. הרוחב המקורי יישמר אם שדה זה ריק.',
        'image_max_height_helper' => 'הגדר את הגובה המקסימלי של התמונה בפיקסלים. הגובה המקורי יישמר אם שדה זה ריק.',
        'customize_upload_path' => 'התאם אישית נתיב העלאה',
        'customize_upload_path_helper' => 'התאם אישית את נתיב ההעלאה עבור קבצי מדיה. כברירת מחדל, המערכת תעלה קבצים לתיקיית ":path".',
        'upload_path' => 'נתיב העלאה',
        'upload_path_placeholder' => 'דוגמה: uploads',
        'upload_path_helper' => 'התיקייה תיווצר ב-/public. תיקיית ברירת המחדל היא ":folder". לאחר מכן היא תועלה אל "/public/:folder".',
        'upload_path_warning' => 'המערכת לא תעביר קבצים קיימים לתיקייה החדשה. אם אתה רוצה להעביר קבצים קיימים לתיקייה החדשה, עליך לעשות זאת באופן ידני.',
        'convert_file_name_to_uuid' => 'המר שם קובץ ל-UUID',
        'convert_file_name_to_uuid_helper' => 'כאשר מופעל, המערכת תמיר את שם הקובץ ל-UUID בעת העלאה. זה שימושי למניעת שמות קבצים כפולים ואבטחה טובה יותר.',
        's3_path' => 'נתיב S3 מותאם אישית (אופציונלי)',
        's3_path_placeholder' => 'נתיב מותאם אישית אופציונלי ב-S3 bucket (לדוגמה, uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'שמור הגדרות',
    'template' => 'תבנית',
    'description' => 'תיאור',
    'enable' => 'הפעל',
    'send' => 'שלח',
    'test_email_description' => 'כדי לשלוח דואר אלקטרוני לבדיקה, ודא שעדכנת את התצורות לשליחת דואר אלקטרוני!',
    'test_email_input_placeholder' => 'הזן את כתובת הדואר האלקטרוני אליה אתה רוצה לשלוח דואר אלקטרוני לבדיקה.',
    'test_email_modal_title' => 'שלח דואר אלקטרוני לבדיקה',
    'test_send_mail' => 'שלח דואר אלקטרוני לבדיקה',
    'test_email_send_success' => 'דואר אלקטרוני נשלח בהצלחה!',
    'locale_direction_ltr' => 'משמאל לימין',
    'locale_direction_rtl' => 'מימין לשמאל',
    'emails_warning' => 'אתה יכול להוסיף מקסימום :count הודעות דואר אלקטרוני',
    'email_add_more' => 'הוסף עוד',
    'generate' => 'צור',
    'generate_thumbnails' => 'צור תמונות ממוזערות',
    'generate_thumbnails_success' => 'תמונות ממוזערות נוצרו בהצלחה. :count קבצים נוצרו!',
    'generate_thumbnails_error' => 'לא הצלחנו ליצור מחדש תמונות ממוזערות עבור :count קבצים!',
    'generate_thumbnails_description' => 'האם אתה בטוח שברצונך ליצור מחדש תמונות ממוזערות עבור כל התמונות? זה עשוי לקחת קצת זמן. אנא אל תנווט הרחק מדף זה עד שהתהליך יושלם.',
    'enable_chunk_description' => 'העלאת גודל נתח משמשת להעלאת קובץ בגודל גדול.',
    'watermark_description' => 'אזהרה: סימן מים נוסף רק לתמונות שהועלו לאחרונה, הוא לא יתווסף לתמונות קיימות. השבתת סימן מים לא תסיר סימן מים מתמונות קיימות.',
    'submit' => 'שלח',
    'back' => 'חזור',
    'enter_sample_value' => 'הזן ערכי דוגמה לבדיקה',
    'preview' => 'תצוגה מקדימה',
    'media_size_width' => 'רוחב גודל :size חייב להיות גדול מ-0',
    'media_size_height' => 'גובה גודל :size חייב להיות גדול מ-0',
    'security' => [
        'title' => 'הגדרות אבטחה',
        'description' => 'בדוק והגדר הגדרות אבטחה עבור האתר שלך.',
        'menu_description' => 'נהל אבטחת עוגיות וכותרות HTTP',
        'status_secure' => 'כל הגדרות האבטחה מוגדרות כראוי!',
        'status_insecure' => 'חלק מהגדרות האבטחה זקוקות לתשומת לב!',
        'current_settings' => 'הגדרות אבטחה נוכחיות',
        'status' => 'סטטוס',
        'setting' => 'הגדרה',
        'current_value' => 'ערך נוכחי',
        'recommended_value' => 'מומלץ',
        'session_http_only' => 'דגל עוגיה HttpOnly',
        'session_http_only_description' => 'מונע מ-JavaScript לגשת לעוגיות הפעלה (מגן מפני התקפות XSS)',
        'session_secure_cookie' => 'דגל עוגיה מאובטחת',
        'session_secure_cookie_description' => 'מבטיח שעוגיות נשלחות רק דרך חיבורי HTTPS',
        'session_same_site' => 'דגל עוגיה SameSite',
        'session_same_site_description' => 'מונע התקפות CSRF על ידי הגבלה מתי נשלחות עוגיות',
        'http_security_headers' => 'כותרות אבטחה HTTP',
        'http_security_headers_description' => 'מוסיף כותרות אבטחה כדי להגן מפני פגיעויות אינטרנט נפוצות',
        'https_warning' => 'האתר שלך לא משתמש ב-HTTPS',
        'https_warning_description' => 'חלק מתכונות האבטחה כמו עוגיות מאובטחות דורשות HTTPS. שקול להפעיל SSL עבור האתר שלך.',
        'how_to_fix' => 'כיצד לתקן בעיות אבטחה',
        'env_file_location' => 'ערוך את קובץ ה-.env שלך הממוקם ב:',
        'add_to_env' => 'הגדרות להוספה',
        'required_settings' => 'הגדרות אבטחה נדרשות',
        'for_https_sites' => 'עבור אתרי HTTPS בלבד',
        'copy' => 'העתק',
        'copy_settings' => 'העתק את כל ההגדרות',
        'copied' => 'הועתק!',
        'steps' => 'שלבים להחלת הגדרות',
        'step_1' => 'פתח את קובץ ה-.env שלך בעורך טקסט',
        'step_2' => 'הוסף או עדכן את הגדרות האבטחה המוצגות למעלה',
        'step_3' => 'שמור את קובץ ה-.env',
        'step_4' => 'נקה מטמון באמצעות לוח ניהול → ניהול פלטפורמה → ניהול מטמון',
        'security_headers_info' => 'מידע על כותרות אבטחה',
        'security_headers_list' => 'כאשר מופעל, הכותרות הבאות נוספות לכל התשובות:',
        'header_nosniff' => 'מונע מדפדפנים לנחש סוגי תוכן',
        'header_frame' => 'מגן מפני התקפות clickjacking',
        'header_xss' => 'מפעיל הגנת XSS של דפדפן',
        'header_referrer' => 'שולט בכמה מידע referrer נשלח',
        'learn_more' => 'למידע מפורט יותר, עיין ב-:documentation',
        'documentation' => 'תיעוד אבטחה',
    ],
    'cache' => [
        'title' => 'מטמון',
        'description' => 'הגדר שמירה במטמון למהירות מיטבית',
        'form' => [
            'cache_admin_menu' => 'שמור תפריט ניהול במטמון',
            'cache_admin_menu_helper' => 'שמור תפריט ניהול במטמון למהירות מיטבית. אפשרות זו צריכה להיות מושבתת אם אתה מפתח או מתאים אישית את תפריט הניהול.',
            'enable_cache_site_map' => 'שמור מפת אתר במטמון',
            'enable_cache_site_map_helper' => 'מפת אתר :url צריכה להישמר במטמון בשל המספר הגדול של דפים. אם יש לך מספר קטן של דפים, אתה יכול להשבית אפשרות זו.',
            'cache_time_site_map' => 'זמן תפוגה של מטמון מפת אתר (בדקות)',
            'cache_front_menu' => 'שמור תפריט קדמי במטמון',
            'cache_front_menu_helper' => 'שמור תפריט קדמי במטמון למהירות מיטבית',
            'cache_user_avatar' => 'שמור אווטר משתמש במטמון',
            'cache_user_avatar_helper' => 'עבור משתמשים ללא אווטר, המערכת תיצור אווטרים משמות המשתמש שלהם. האווטרים יישמרו במטמון למהירות מיטבית ולא יוצרו מחדש.',
            'shortcode_cache_enabled' => 'שמור קודים קצרים במטמון (בלוקי UI)',
            'shortcode_cache_enabled_helper' => 'הפעל שמירה במטמון עבור קודים קצרים לשיפור ביצועים. כאשר מופעל, קודים קצרים יישמרו במטמון כדי להפחית את זמן העיבוד.',
            'shortcode_cache_warning' => '<strong>⚠️ הודעה חשובה:</strong><br>• קודים קצרים המכילים טפסים (טפסי יצירת קשר, מנויים לניוזלטר וכו\') יעקפו אוטומטית את השמירה במטמון כדי לשמר את הפונקציונליות.<br>• קודים קצרים עם תוכן JavaScript דינמי צריכים להשבית את השמירה במטמון באופן ידני.<br>• כדי להשבית שמירה במטמון עבור קודים קצרים ספציפיים, הוסף <code>הפעל שמירה במטמון: לא</code> לתצורת הקוד הקצר.<br>• טפסים עם אסימוני CSRF, reCAPTCHA או אלמנטים דינמיים אחרים מזוהים אוטומטית ומוחרגים משמירה במטמון.',
            'shortcode_cache_ttl' => 'משך שמירה במטמון (שניות)',
            'shortcode_cache_ttl_helper' => 'המשך לשמירת כל הקודים הקצרים במטמון. ברירת המחדל היא 1800 שניות (30 דקות).',
            'widget_cache_enabled' => 'שמור ווידג\'טים במטמון',
            'widget_cache_enabled_helper' => 'הפעל שמירה במטמון עבור ווידג\'טים לשיפור ביצועים. כאשר מופעל, ווידג\'טים יישמרו במטמון כדי להפחית את זמן העיבוד.',
            'widget_cache_warning' => '<strong>⚠️ הודעה חשובה:</strong><br>• ווידג\'טים המכילים טפסים (טפסי יצירת קשר, מנויים לניוזלטר וכו\') יעקפו אוטומטית את השמירה במטמון כדי לשמר את הפונקציונליות.<br>• ווידג\'טים עם תוכן JavaScript דינמי צריכים להשבית את השמירה במטמון באופן ידני.<br>• כדי להשבית שמירה במטמון עבור ווידג\'טים ספציפיים, הגדר <code>הפעל שמירה במטמון: לא</code> בתצורת הווידג\'ט.<br>• טפסים עם אסימוני CSRF, reCAPTCHA או אלמנטים דינמיים אחרים מזוהים אוטומטית ומוחרגים משמירה במטמון.',
            'widget_cache_ttl' => 'משך שמירה במטמון (שניות)',
            'widget_cache_ttl_helper' => 'המשך לשמירת כל הווידג\'טים במטמון. ברירת המחדל היא 1800 שניות (30 דקות).',
            'plugin_cache_enabled' => 'שמור תוספים מותקנים במטמון',
            'plugin_cache_enabled_helper' => 'שמור את רשימת התוספים המותקנים במטמון לביצועים משופרים. כאשר מופעל, המערכת תשמור את רשימת התוספים במטמון למשך 30 דקות כדי להפחית סריקות מערכת קבצים.',
        ],
    ],
    'appearance' => [
        'title' => 'מראה',
    ],
    'panel' => [
        'common' => 'נפוץ',
        'general' => 'כללי',
        'general_description' => 'צפה ועדכן את ההגדרות הכלליות שלך והפעל רישיון',
        'email' => 'דואר אלקטרוני',
        'email_description' => 'צפה ועדכן את הגדרות הדואר האלקטרוני ותבניות הדואר האלקטרוני שלך',
        'media' => 'מדיה',
        'media_description' => 'צפה ועדכן את הגדרות המדיה שלך',
        'system' => 'מערכת',
        'system_updater' => 'מעדכן מערכת',
        'system_updater_description' => 'עדכן את המערכת שלך לגרסה האחרונה',
        'others' => 'אחרים',
    ],
    'saving' => 'שומר...',
    'generating_media_thumbnails' => 'יוצר תמונות ממוזערות מדיה...',
    'test_email_template' => 'בדוק תבנית דואר אלקטרוני',
    'select_email_template' => 'בחר תבנית דואר אלקטרוני',
    'enums' => [
        'data_retention_period' => [
            'לעולם לא',
            'יום אחד',
            3 => '3 ימים',
            7 => 'שבוע אחד',
            30 => 'חודש אחד',
            90 => '3 חודשים',
            180 => '6 חודשים',
            365 => 'שנה אחת',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => 'ה-:attribute חייב להיות אזור AWS תקף (לדוגמה, us-east-1, eu-west-1).',
    ],
    'phone_number' => [
        'title' => 'Phone Number',
        'description' => 'Configure phone number field settings',
        'enable_country_code' => 'Enable Country Code Selection',
        'enable_country_code_helper' => 'When enabled, phone number fields will display a country code selector with automatic country detection.',
        'available_countries' => 'Available Countries',
        'all' => 'All',
        'all_helper_text' => 'Select all countries to be available in the phone country code selector.',
        'min_length' => 'Minimum Length',
        'min_length_helper' => 'Minimum number of characters required for phone numbers.',
        'max_length' => 'Maximum Length',
        'max_length_helper' => 'Maximum number of characters allowed for phone numbers.',        'note_content' => '<p class="mb-1"><strong>לפורמט מקומי (ללא קוד מדינה):</strong> הגדר מינימום/מקסימום על סמך אורך מספר הטלפון של המדינה שלך (למשל, 8-15 לרוב המדינות).</p><p class="mb-0"><strong>לפורמט בינלאומי (עם קוד מדינה מופעל):</strong> מומלץ מינימום: 7, מקסימום: 20. זה כולל קודי מדינה (1-4 ספרות) + מספרי טלפון (בדרך כלל 6-15 ספרות).</p>',
    ],
];
